import json
from subprocess import Popen
import os
import inspect
import time
import logging

import boto.ec2.elb

from qds_ops.utils.fork import Fork
from qds_ops.tparty.knife import Knife


class DeployUtils:
    @staticmethod
    def wait_till_node_registers(env, tier, master_id):
        search_string = "name:%s" % master_id
        knife = Knife()
        nodes = knife.search(env, tier, [search_string])
        while not nodes:
            logging.info("Node %s has not registered with Chef yet." % master_id)
            time.sleep(20)
            nodes = knife.search(env, tier, [search_string])
        logging.info("%s is now registered with Chef" % master_id)

    @staticmethod
    def wait_till_node_healthy(access, secret, elb_name,
                               master_id):#${env_str} $host $password $username $database $lb_name ${pemfile} ${a}):
        if elb_name is not None:
            elb = boto.ec2.elb.connect_to_region('us-east-1', aws_access_key_id=access, aws_secret_access_key=secret)
            state = elb.describe_instance_health(elb_name, [master_id])[0].state
            while state != "InService":
                logging.info("Current elb health of master instance is:" + state)
                time.sleep(20)
                state = elb.describe_instance_health(elb_name, [master_id])[0].state
            logging.info("Current elb health of master instance is:" + state)

    @staticmethod
    def run_chef_command(chef_command, env, tier, pemfile,
                         base_selector):#${env_str} $host $password $username $database $lb_name ${pemfile} ${a}):
        select = "chef_environment:%s AND qubole_tier:%s" % (env, tier)
        selector = " ".join([select, base_selector])
        logging.info("Running chef command: %s on  selector: %s" % (chef_command, selector))
        p = Popen(["knife", "ssh", selector, chef_command, "-x", "ec2-user", "-i", pemfile, "-a", "ec2.public_hostname",
                   "--no-host-key-verify"])
        retcode = p.wait()
        return retcode

    @staticmethod
    def run_common_stuff(env, tier, pemfile):#${env_str} $host $password $username $database $lb_name ${pemfile} ${a}):
        logging.info("Running common stuff recipe on all nodes because -c argument is specified.")
        run_list = '{"run_list":["recipe[webslave::common_stuff]"]}'
        chef_command = "echo '%s' > /tmp/runlist; sudo chef-client -j /tmp/runlist -E %s" % (run_list, env)
        retcode = DeployUtils.run_chef_command(chef_command, env, tier, pemfile, "")
        logging.info("-------Done with running the common stuff recipe--------")
        return retcode

    @staticmethod
    def get_chef_command_for_module(module,
                                    env):#${env_str} $host $password $username $database $lb_name ${pemfile} ${a}):
        chef_command = "sudo chef-client -j /etc/chef/first-boot.json -E %s" % (env)
        if module != "all":
            run_list = '{"run_list":["recipe[webslave::deploy_%s]"]}' % (module)
            chef_command = "echo '%s' > /tmp/runlist; sudo chef-client -j /tmp/runlist" % (run_list)
        return chef_command

    @staticmethod
    def do_master_slave_deploy(env, tier, pemfile, module, access, secret, lb_name):
        chef_command = DeployUtils.get_chef_command_for_module(module, env)
        selector = "chef_environment:%s AND qubole_tier:%s" % (env, tier)
        master_selector = "%s AND is_master:true AND NOT shutdown_gracefully:yes" % (selector)
        slave_selector = "%s AND is_master:false AND NOT shutdown_gracefully:yes" % (selector)
        base_path = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
        out = Fork.check_output(["knife", "exec", base_path + "/../scripts/set_single_master.rb", env, "true", tier],
                                stderr=None)
        print out
        time.sleep(10)
        knife = Knife()
        master_node = knife.getnodes(master_selector)
        if (master_node["results"] != 1):
            raise Exception("Multiple masters exist. This should not have happened. Exiting...")
        master_node_ip = master_node["rows"][0]["fqdn"]
        master_node_id = master_node["rows"][0]["id"]
        logging.info("Master node is: " + master_node_ip + ", " + master_node_id)
        p = Popen(["ssh", "-o", "StrictHostKeyChecking=no", "-t", "-t", "-i", pemfile, "ec2-user@" + master_node_ip,
                   chef_command])
        retcode = p.wait()
        if retcode != 0:
            raise Exception("Deploy on master node failed. Exiting....")
        logging.info("Waiting for master node to get healthy under elb")
        DeployUtils.wait_till_node_healthy(access, secret, lb_name, master_node_id)
        slave_nodes = knife.getnodes(slave_selector)
        if slave_nodes["results"] == 0:
            logging.info("No slave nodes found. Done with deploy.")
        else:
            p = Popen(["knife", "ssh", slave_selector, chef_command, "-x", "ec2-user", "-i", pemfile, "-a",
                       "ec2.public_hostname", "--no-host-key-verify"])
            retcode = p.wait()