import os
from setuptools import setup, find_packages
from os import listdir
from os.path import isfile, join
from pip.req import parse_requirements
from distutils.sysconfig import get_python_lib 
import versioneer

versioneer.versionfile_source = 'qds_ops/_version.py'
versioneer.versionfile_build = 'qds_ops/_version.py'
versioneer.tag_prefix = 'qds_ops-' # tags are like 1.2.0
versioneer.parentdir_prefix = 'qds_ops-' # dirname like 'myproject-1.2.0'

# parse_requirements() returns generator of pip.req.InstallRequirement objects
INSTALL_REQUIRES = parse_requirements('requirements.txt')

# # reqs is a list of requirement
# # e.g. ['django==1.5.1', 'mezzanine==1.4.6']
REQS = [str(ir.req) for ir in INSTALL_REQUIRES]

def read(fname):
    return open(os.path.join(os.path.dirname(__file__), fname)).read()

mypath= "qds_ops/scripts"
onlyfiles = [ join(mypath,f) for f in listdir(mypath) if isfile(join(mypath,f)) ]

datapath = get_python_lib() + "/qds_ops/scripts"

setup(
    name = "qds_ops",
    version = versioneer.get_version(),
    cmdclass = versioneer.get_cmdclass(),
    author = "Qubole",
    author_email = "dev@qubole.com",
    description = ("Python SDK for operating the Qubole Data Service"),
    keywords = "qubole ops",
    url = "http://packages.python.org/qds_ops",
    packages=find_packages(),
    scripts=[],
    entry_points = {
        'console_scripts': ['qds-ops=qds_ops.command_line:main'],
    },
    install_requires=REQS,
    long_description=read('README.md'),
    data_files=[(datapath,onlyfiles)]
    )


