#!/bin/env python

import os
import sys
import traceback
import logging
import atexit
from qds_ops.entities.web import Web
from qds_ops.entities.log import Log
from qds_ops.entities.oozie_master import OozieMaster
from qds_ops.entities.oozie_slave import OozieSlave
from qds_ops.entities.oozie import Oozie
from qds_ops.entities.chef import Chef
from qds_ops.entities.rds import RDS
from qds_ops.entities.scheduler import Scheduler
from qds_ops.entities.default_dj import DefaultDJ
from qds_ops.entities.experimental_dj import ExperimentalDJ
from qds_ops.entities.redis_server import Redis
from qds_ops.utils import argparse
from qds_ops import __version__
from qds_ops.tparty.knife import Knife


def main():

    root = logging.getLogger()
    root.setLevel(logging.INFO)

    ch = logging.StreamHandler(sys.stdout)
    ch.setLevel(logging.INFO)
    formatter = logging.Formatter('%(asctime)s - %(module)s - %(levelname)s - %(message)s')
    ch.setFormatter(formatter)
    root.addHandler(ch)

    argparser = argparse.ArgumentParser(description="Operational tool for Qubole Data Service.")
    argparser.add_argument("-e", "--env", dest="environment",
        help="Qubole environment")
    argparser.add_argument("-d", "--debug", action = "store_true", default=False,
                           help="Turn on debug logging")
    argparser.add_argument('--version', action='version', version=__version__)
    subparsers = argparser.add_subparsers()


    chef = Chef(subparsers)
    web = Web(subparsers)
    log = Log(subparsers)
    master = OozieMaster(subparsers)
    slave = OozieSlave(subparsers)
    oozie = Oozie(subparsers)
    rds = RDS(subparsers)
    scheduler = Scheduler(subparsers)
    defaultDJ = DefaultDJ(subparsers)
    experimentalDJ = ExperimentalDJ(subparsers)
    Redis(subparsers)

    args = argparser.parse_args()
    if args.debug:
        ch.setLevel(logging.DEBUG)
        root.setLevel(logging.DEBUG)
        logging.debug("Debug is ON!")
    try:
        args.func(args)
    finally:
        logging.debug("Cleaning up")
        Knife().cleanup()

if __name__ == '__main__':
    try:
        sys.exit(main())
    except Exception:
        traceback.print_exc(file=sys.stderr)
        sys.exit(3)

