import json
import os
import inspect
import logging
from qds_ops.entities.tier import Tier
from qds_ops.utils.fork import Fork
from qds_ops.utils.rolling_deploy import RollingDeploy
from qds_ops.utils.deploy_utils import DeployUtils
from qds_ops.tparty.knife import Knife
from qds_ops.entities.rds import RDS
import re
import boto.rds
import boto.ec2.elb
import boto.ec2.autoscale
import boto.ec2
import boto.ec2.cloudwatch
from boto.ec2.cloudwatch import MetricAlarm

class Web(Tier):
    tier = "web"
    modules = ["hive_scripts", "hadoop", "hadoop2", "hustler", "hive", "hive2", "sqoop", "pig", "tapp2", "cloudman"]
    worker = "qpal_worker"
    region = "us-east-1"

    def __init__(self, subparser):
        super(Web, self).__init__(subparser)

        # sanitize-autoscaling-group
        san = self.tier_parser.add_parser("sanitize-as-group", help="Create and associate an upscaling policy with autoscaling group. ")
        san.add_argument("-r", "--region", help="Region where the tier will be located",
                            default=self.region, dest="region")
        san.set_defaults(func=self.sanitize)

        # policy-create
        pol = self.tier_parser.add_parser("as-policy", help="Create and associate an upscaling policy with autoscaling group. ")
        pol.add_argument("-r", "--region", help="Region where the tier will be located",
                            default=self.region, dest="region")
        pol.set_defaults(func=self.policy)


        #CMD
        cli = self.tier_parser.add_parser("cli",
                                          help="Show all cli.py processes or commands running on ALL web nodes")
        cli.add_argument("-z", "--zombies", dest="zombies",
                                action="store_true", help="Login into a zombie node in %s" % (self.tier))
        cli.set_defaults(func=self.cli)

        #CMD Count
        cli_count = self.tier_parser.add_parser("cli-count",
                                                help="Count number of cli.py or commands running on ALL web nodes")
        cli_count.add_argument("-z", "--zombies", dest="zombies",
                                action="store_true", help="Login into a zombie node in %s" % (self.tier))
        cli_count.set_defaults(func=self.cli_count)

        #DJ
        dj = self.tier_parser.add_parser("dj", help="List all Delayed jobs running on web nodes")
        dj.add_argument("-z", "--zombies", dest="zombies",
                                action="store_true", help="Login into a zombie node in %s" % (self.tier))
        dj.set_defaults(func=self.dj)

        #DJ Count
        dj_count = self.tier_parser.add_parser("dj-count", help="Count all DJs on each web node")
        dj_count.add_argument("-z", "--zombies", dest="zombies",
                                action="store_true", help="Login into a zombie node in %s" % (self.tier))
        dj_count.set_defaults(func=self.dj_count)

        # List - add --new argument
        self.list_parser.add_argument("-z", "--zombies", dest="zombies",
                                action="store_true", help="Login into a zombie node in %s" % (self.tier))
        self.list_parser.set_defaults(func=self.web_list)

        # ssh - add --new argument
        self.ssh_parser.add_argument("-z", "--zombies", dest="zombies",
                                action="store_true", help="Login into a zombie node in %s" % (self.tier))
        self.ssh_parser.set_defaults(func=self.web_ssh)

        # screen - add --new argument
        self.screen_parser.add_argument("-z", "--zombies", dest="zombies",
                                action="store_true", help="Login into a zombie node in %s" % (self.tier))
        self.screen_parser.set_defaults(func=self.web_screen)

        # Login - add --new argument
        self.login_parser.add_argument("-z", "--zombies", dest="zombies",
                                action="store_true", help="Login into a zombie node in %s" % (self.tier))
        self.login_parser.set_defaults(func=self.web_login)

        #add new args for deploy_parser
        self.deploy_parser.add_argument("-r", "--no-rolling", dest="rolling",
                                   default=True, action="store_false",
                                   help="Don't do rolling deploy to %s" % (self.tier))
        self.deploy_parser.add_argument("-t", "--stop-djs-at-start", dest="stopdjs",
                                   default=False, action="store_true",
                                   help="At start of rolling deploy, stop DJs on current nodes")
        self.deploy_parser.add_argument("-c", "--run-common-stuff-recipe", dest="commstuff",
                                   default=False, action="store_true", help="Run common stuff at start of deploy")
        self.deploy_parser.add_argument("-d", "--no-djrestart", dest="djrestart",
                                   default=True, action="store_false", help="Don't do DJ restart on %s" % (self.tier))
        self.deploy_parser.set_defaults(func=self.web_deploy)

        #Deploy Lock
        lock_parser = self.tier_parser.add_parser("deploy-lock",
                                                help="Check, lock or unlock deploy lock")
        lock_parser.add_argument("-a", "--action", dest="action", choices=["check", "lock", "unlock"], default="check",
                                 help="Action to apply to the lock")
        lock_parser.add_argument("-t", "--tunnel", dest="tunnel",
                                 action="store_true", help="Setup a tunnel to RDS", default="False")
        lock_parser.set_defaults(func=self.deploy_lock)

	#update-cache
	update_cache_parser = self.tier_parser.add_parser("update-cache",
							help="Update settings cache via http request")
	update_cache_parser.set_defaults(func=self.update_settings_cache)

    @staticmethod
    def get_filter(args):
        if args.zombies:
            return ["shutdown_gracefully:yes"]
        else:
            return [" NOT shutdown_gracefully:yes"]

    def cli(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"cli.py\" | grep -v \"sh -c\" | grep -v grep ",
                           args.environment, self.tier, self.get_filter(args))
        print output

    def cli_count(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"cli.py\" | grep -v \"sh -c\" | grep -v grep | wc -l",
                           args.environment, self.tier, self.get_filter(args))
        print output

    def dj(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"delayed_job\" | grep -v \"sh -c\" | grep -v grep ",
                           args.environment, self.tier, self.get_filter(args))
        print output

    def dj_count(self, args):
        knife = Knife()
        output = knife.ssh("ps -ef | egrep \"delayed_job\" | grep -v \"sh -c\" | grep -v grep | wc -l",
                           args.environment, self.tier, self.get_filter(args))
        print output

    def web_list(self, args):
        knife_search = Knife()
        nodes = knife_search.search(args.environment, self.tier, self.get_filter(args))
        print json.dumps(nodes, indent=4, sort_keys=True)

    def web_ssh(self, args):
        knife = Knife()
        output = ""
        if args.any:
            output = knife.ssh_one(args.command, args.environment, self.tier, self.get_filter(args))
        else:
            output = knife.ssh(args.command, args.environment, self.tier, self.get_filter(args))
        print output

    def web_screen(self, args):
        output = Knife().ssh("screen", args.environment, self.tier, self.get_filter(args))
        print output

    def get_elb(self, env):
        creds = Knife().get_credentials(env)
        return creds["lb_name"]

    def as_name(self, env):
        return RDS.run_query(env, False, "SELECT value from settings where var IN ('aws.as_group_name')")['value']

    def web_deploy(self, args):
        if args.djrestart == False and args.module != "tapp2":
            raise Exception("-d argument can be specified only with -m tapp2")

        logging.info("Trying to take a lock for deploy on " + args.environment)
        knife = Knife()
        success = knife.deploy_lock(args.environment, False, self.tier, "lock")
        if success == False:
            raise Exception("Failed to take lock for deploy. Exiting...")

        try: 
            knife.reap_instances(args)
            temp = knife.get_pemfile(args.environment)
            creds = knife.get_credentials(args.environment) 

            if (args.commstuff == True):
                DeployUtils.run_common_stuff(args.environment, self.tier, temp)

            djrestart = "yes"
            if args.djrestart == False:
                djrestart = "no"

            elb_name = self.get_elb(args.environment)
            base_path = os.path.dirname(os.path.abspath(inspect.getfile(inspect.currentframe())))
            out = Fork.check_output(["knife", "exec", base_path + "/../scripts/set_node_attr.rb", args.environment, "djrestart", djrestart, self.tier ], stderr=None)
            print out

            if args.djrestart == False:
              DeployUtils.do_master_slave_deploy(args.environment, self.tier, temp, args.module, creds["access"], creds["secret"], elb_name)
            elif ((args.module == "all" or args.module == "tapp2" or args.module == "hive") and args.rolling == True):
                logging.info("Doing Rolling deploy")
                rd = RollingDeploy(creds["host"], creds["password"], creds["username"], creds["database"], elb_name, args.environment, temp, args.stopdjs, creds['access'], creds['secret'], self.as_name(args.environment), self.tier, self.worker).deploy()
            else:
                chef_command = DeployUtils.get_chef_command_for_module(args.module, args.environment)
                DeployUtils.run_chef_command(chef_command, args.environment, self.tier, temp, "AND NOT shutdown_gracefully:yes")
            logging.info("-------Done with deploy--------")
        finally:
            success = knife.deploy_lock(args.environment, False, self.tier, "unlock")

    def web_login(self, args):
        if args.host is None:
            knife_search = Knife()
            nodes = knife_search.search(args.environment, self.tier, self.get_filter(args))
            args.host = nodes[0]
        self.login(args)


    def deploy_lock(self, args):
        knife = Knife()
        knife.deploy_lock(args.environment, args.tunnel, self.tier, args.action)

    def update_settings_cache(self, args):
	knife = Knife()
	output = knife.ssh("curl --header 'Accepts: application/json' http://localhost/update_settings_cache", args.environment, self.tier)
	print output

    def camelize(self, a):
        return re.sub(r"(?:^|_)(.)", lambda x: x.group(0)[-1].upper(), a)

    def as_name(self, env):
        rows = RDS.run_query(env, False, "select value from rstore.settings where var='aws.as_group_name'")
        return rows["value"]

    def policy(self, args):
        knife = Knife()
        creds = knife.get_credentials(args.environment)

        logging.info("applying autoscaling policy in %s" % args.environment)
        autoscale_conn = boto.ec2.autoscale.connect_to_region(
            args.region,
            aws_access_key_id=creds["access"],
            aws_secret_access_key=creds["secret"])
        as_group_name = self.as_name(args.environment)
        logging.debug("autoscaling group for %s should be %s" % (args.environment, as_group_name))

        policy_name = "%s-%s-upscale-policy" % (args.environment, self.tier)
        policies = autoscale_conn.get_all_policies(as_group=as_group_name)
        if len(policies) > 0:
            raise Exception("autoscaling policy %s:%s already exists" % (as_group_name, policies[0]))
        policy = boto.ec2.autoscale.policy.ScalingPolicy(
            autoscale_conn,
            name=policy_name,
            adjustment_type="ChangeInCapacity",
            as_name=as_group_name,
            scaling_adjustment=1,
            cooldown=1200)
        autoscale_conn.create_scaling_policy(policy)
        policies = autoscale_conn.get_all_policies(as_group=as_group_name)
        assert len(policies) == 1, "Found multiple (%s) autoscaling policies!" % as_group_name
        logging.info("created new upscale policy %s" % policies[0])
        policy = policies[0]

        cw_conn = boto.ec2.cloudwatch.connect_to_region(
            args.region,
            aws_access_key_id=creds["access"],
            aws_secret_access_key=creds["secret"])
        aname = "%s-%s-wait-time-policy" % (args.environment, self.tier) 
        t = self.camelize(self.tier)
        anspace = "Qubole/%s/%sTier" % (args.environment, t)
        scale_up_alarm = MetricAlarm(
                name=aname, namespace=anspace,
                metric='DJWaitTime', statistic='Average',
                comparison='>', threshold='150',
                period='300', evaluation_periods=1,
                alarm_actions=[policy.policy_arn],
                dimensions=None)
        cw_conn.create_alarm(scale_up_alarm)
        logging.info("created cloudwatch alarm %s for autoscaling policy %s" % (aname, policy_name))


    def sanitize(self, args):
        logging.info("Begin sanitize %s autoscaling group" % args.environment)
        knife = Knife()
        creds = knife.get_credentials(args.environment)
        as_group_name = self.as_name(args.environment)
        logging.debug("autoscaling group for %s should be %s" % (args.environment, as_group_name))
        autoscale_conn = boto.ec2.autoscale.connect_to_region(
            args.region,
            aws_access_key_id=creds["access"],
            aws_secret_access_key=creds["secret"])

        logging.info("querying AWS for %s" % as_group_name)
        as_objs = autoscale_conn.get_all_groups([as_group_name])
        if len(as_objs) < 1:
            raise Exception("As Group: %s does not exist. First create this group "
                            "and then call sanitize" % as_group_name)
        assert len(as_objs) == 1, "Duplicate names (%s) found for ASG!" % as_group_name
        logging.info("autoscaling group for %s found to be %s" % (args.environment, as_objs[0]))
        as_obj = as_objs[0]

        as_obj.cooldown = 1200
        as_obj.health_check_period = 600
        as_obj.update()
        as_obj.suspend_processes(["ReplaceUnhealthy"])
        logging.info("ASG updated successfully: cooldown: %d healthcheck %d"
                     % (as_obj.cooldown, as_obj.health_check_period))
