import boto
import json
from qds_ops.tparty.knife import Knife
import logging
from boto.elasticache import layer1
from boto.exception import BotoServerError
import time

class Memcache():

    def __init__(self):
        self.region = "us-east-1"
        self.instance_type = "cache.m3.medium"
        self.port = 7777
        self.engine_version = "1.4.14"
        self.knife = Knife()

    def configure_parsers(self,subparser):
        parser = subparser.add_parser("memcache",
                                      help="Commands to create and monitor memcache cluster")
        memcache_subparser = parser.add_subparsers()

        #create 
        create = memcache_subparser.add_parser("create", help="""launches a new
            instance of memcache""")
        create.add_argument("-r", "--region", help="Region where the tier will be located",
                            default=self.region, dest="region")
        create.add_argument("-i", "--instance-type", help="Instance Type of the machine",
                            choices=["cache.m3.medium", "cache.m3.large"], dest="instance_type",
                            default=self.instance_type)
        create.add_argument("-c", "--cluster-id", dest="cluster_id",
                             help="""Name of the cluster. defaults to
                             memcache-<env-name>""")
        create.add_argument("-p", "--port", dest="port",
                            default=self.port, help="Cache port")
        create.set_defaults(func=self.create)

        #delete
        delete = memcache_subparser.add_parser("delete", help="terminate memcache cluster")
        delete.add_argument("-c", "--cluster-id", dest="cluster_id",
                             help="""Name of the cluster. defaults to
                             memcache-<env-name>""")
        delete.set_defaults(func=self.delete)

        #info
        info = memcache_subparser.add_parser("info",
                          help="List cluster id, port of the memcache cluster")
        info.set_defaults(func=self.info)

    def info(self, args):
        creds = self.knife.get_credentials(args.environment)
        output = {"memcache_cluster": creds["memcache_server"], "cache_store":
            creds["cache_store"]}
        print json.dumps(output, indent=4, sort_keys=True)

    def create(self, args):
        creds = self.knife.get_credentials(args.environment)
        if args.cluster_id is None:
          args.cluster_id = self._cluster_id(args.environment)
        ec2_cache = layer1.ElastiCacheConnection(
            aws_access_key_id=creds["access"],
            aws_secret_access_key=creds["secret"]
        )
        logging.info("creating memcache cluster")
        ec2_cache.create_cache_cluster(args.cluster_id,
            num_cache_nodes = 1, cache_node_type = args.instance_type, engine =
            "memcached", engine_version = self.engine_version, port = args.port)
	self.wait_until_cluster_available(ec2_cache, args.cluster_id)

    def delete(self, args):
        if args.cluster_id is None:
          args.cluster_id = self._cluster_id(args.environment)
        creds = self.knife.get_credentials(args.environment)
        ec2_cache = layer1.ElastiCacheConnection(
            aws_access_key_id=creds["access"],
            aws_secret_access_key=creds["secret"]
        )
        ec2_cache.delete_cache_cluster(args.cluster_id)
        timeout = time.time() + 600
        logging.info("terminating %s" %(args.cluster_id))
        while time.time() < timeout:
	  try:
	    ec2_cache.describe_cache_clusters(args.cluster_id)
          except BotoServerError:
            logging.info("terminated %s" %(args.cluster_id))
            break
          time.sleep(5)
        else:
	    logging.error("Timeout waiting for cache cluster to be deleted")

    def _cluster_id(self, env):
        return "memcache-" + env

    def wait_until_cluster_available(self, elasticache, cluster_id):
        timeout = time.time() + 600
        while time.time() < timeout:
            response = elasticache.describe_cache_clusters(cluster_id)
            status = response['DescribeCacheClustersResponse']\
                    ['DescribeCacheClustersResult']\
                    ['CacheClusters'][0]['CacheClusterStatus']
            if status == 'available':
                logging.info("Memcache cluster is created")
                endpoint = response['DescribeCacheClustersResponse']\
                    ['DescribeCacheClustersResult']\
                    ['CacheClusters'][0]['ConfigurationEndpoint']
                logging.info("Endpoint is %s:%s" %(endpoint['Address'],
                  endpoint['Port']))  
                logging.info("YOU NEED TO UPDATE DATABAG TO USE THIS MEMCACHE CLUSTER")
                break
            time.sleep(5)
        else:
            logging.error('Timeout waiting for cache cluster %r'
                      'to become available.' % cluster_id)
