#!/usr/bin/env ruby
require 'rubygems'
require 'active_support'
require 'optparse'

options = {}
optparser = OptionParser.new do |opts|
  opts.banner = "Usage: validate_chef_attributes_versions.rb [options] ..."
end

optparser.parse!

@@out_path = ARGV[0]
base_s3_path= ARGV[1]
tagname= ARGV[2]
cloud = ARGV[3]
puts base_s3_path
puts tagname
def s3_path_exists?(path)
  aws_dir = "#{@@out_path}/qbol/aws-tools"
  cmd = "#{aws_dir}/s3cmd/s3cmd -c #{aws_dir}/creds/s3cfg ls #{path}"
  a=`#{cmd}`
  exists = !(a.nil? || a.empty?)
  return exists
end

def git_tag_exists?(tag, ver)
  return true if (ver.empty?)
  cmd = "git show #{tag} >> /dev/null;echo $?"
  a=`#{cmd}`.strip
  exists = (a == "0")
  return exists
end

f = "#{@@out_path}/chef-repo/cookbooks/webslave/attributes/"
f = "#{@@out_path}/chef-repo/cookbooks/#{cloud}_webslave/attributes" if cloud != "aws"

class TestNode 
  attr_accessor :default  
  def initialize  
    @default = Hash.new
    @default['qubole'] = {}
  end 
end 
node = TestNode.new 

node.instance_eval(IO.read(f + "package_versions.rb")) 
latest_versions = node.default

ctp = latest_versions["qubole"]
puts ctp.inspect
exists = true
unvalidated_packages = []
ctp.each do |x,y|
  x = x.gsub("_version","")
  next if x == "chef" || x == "hive_0.8" || x == "tapp2"
  puts "checking for #{x}"
  if x == "tapp"
    if cloud == "aws"
      exists = git_tag_exists?("#{x}_#{tagname}_#{y}", y)
    else
      exists = git_tag_exists?("#{cloud}_#{x}_#{tagname}_#{y}", y) if cloud != "aws"
    end
  else
    s3_path = "#{base_s3_path}/#{x}/#{x}-#{y}.tar.gz"
    exists = s3_path_exists?(s3_path)
  end
  unvalidated_packages << "#{x}" if exists == false
end
if unvalidated_packages.length > 0
  puts "Error: EXITING: Packages or tags do not exist for #{unvalidated_packages.join(', ')}. Please update the versions with correct value in attributes file." 
  exit(1) 
end
exit(0)


