# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

from default_dj import DefaultDJ

class ExperimentalDJ(DefaultDJ):


    def __init__(self):
        super(ExperimentalDJ, self).__init__()
        tier = "experimentalDJ"
        worker = "experimental_worker"
        ami = "ami-d47493bc"
        instance_type = "m1.xlarge"
        run_list = '{"run_list":["recipe[%swebslave::deploy_dj]"],"qubole_tier":"%s", "worker_name":"%s"}'
        modules = ["hive_scripts", "hadoop", "hadoop2", "hustler", "hive", "hive13", "hive2", "sqoop", "pig", "tapp2", "cloudman"]
        region = "us-east-1"
        az = "us-east-1b"
        security_groups = ['default']

        self.set_ami(ami), self.set_az(az), self.set_region(region)
        self.set_instance_type(instance_type), self.set_run_list(run_list)
        self.set_tier(tier), self.set_worker(worker), self.set_modules(modules),
        self.set_security_groups(security_groups)
        self.is_autoscalable = True

    def configure_parsers(self):
        super(ExperimentalDJ, self).configure_parsers()
