#!/usr/bin/python3

from qgmap import *

if __name__ == '__main__' :

	def goCoords() :
		def resetError() :
			coordsEdit.setStyleSheet('')
		try : latitude, longitude = coordsEdit.text().split(",")
		except ValueError :
			coordsEdit.setStyleSheet("color: red;")
			QtCore.QTimer.singleShot(500, resetError)
		else :
			gmap.centerAt(latitude, longitude)
			gmap.moveMarker("MyDragableMark", latitude, longitude)

	def goAddress() :
		def resetError() :
			addressEdit.setStyleSheet('')
		coords = gmap.centerAtAddress(addressEdit.text())
		if coords is None :
			addressEdit.setStyleSheet("color: red;")
			QtCore.QTimer.singleShot(500, resetError)
			return
		gmap.moveMarker("MyDragableMark", *coords)
		coordsEdit.setText("{}, {}".format(*coords))

	def onMarkerMoved(key, latitude, longitude) :
		print("Moved!!", key, latitude, longitude)
		coordsEdit.setText("{}, {}".format(latitude, longitude))

	app = QtGui.QApplication([])
	w = QtGui.QDialog()
	h = QtGui.QVBoxLayout(w)
	l = QtGui.QFormLayout()
	h.addLayout(l)

	addressEdit = QtGui.QLineEdit()
	l.addRow('Address:', addressEdit)
	addressEdit.editingFinished.connect(goAddress)
	coordsEdit = QtGui.QLineEdit()
	l.addRow('Coords:', coordsEdit)
	coordsEdit.editingFinished.connect(goCoords)
	gmap = QGoogleMap(w)
	gmap.markerMoved.connect(onMarkerMoved)
	h.addWidget(gmap)
	gmap.setSizePolicy(
		QtGui.QSizePolicy.MinimumExpanding,
		QtGui.QSizePolicy.MinimumExpanding)
	w.show()

	gmap.waitUntilReady()

	gmap.centerAt(41.35,2.05)
	gmap.setZoom(13)
	coords = gmap.centerAtAddress("Pau Casals 3, Santa Coloma de Cervelló")
	# Many icons at: https://sites.google.com/site/gmapsdevelopment/
	gmap.addMarker("MyDragableMark", *coords, **dict(
		icon="http://google.com/mapfiles/ms/micons/blue-dot.png",
		draggable=True,
		title = "Move me!"
		))

	# Some Static points
	for place in [
		"Pau Casals 13, Santa Coloma de Cervelló",
		"Ferrer 20, Santa Coloma de Cervelló",
		]:
		gmap.addMarkerAtAddress(place,
			icon="http://google.com/mapfiles/ms/micons/green-dot.png",
			)

	gmap.setZoom(17)



	app.exec_()



