""" Make all python projects available in the current build configuration

"""
import sys
import os

from qisys import ui
import qisys.sh
import qisys.command
import qisys.parsers
import qibuild.parsers
import qipy.parsers
import qipy.worktree

def configure_parser(parser):
    qibuild.parsers.cmake_build_parser(parser)
    parser.add_argument("requirements", nargs="*")
    parser.set_defaults(requirements=["pip", "virtualenv", "ipython"])

def do(args):
    python_builder = qipy.parsers.get_python_builder(args)
    python_builder.bootstrap(remote_packages=args.requirements)
