/*
 * Decompiled with CFR 0.152.
 */
package king;

import driftwood.gui.ReflectiveAction;
import driftwood.gui.TextCutCopyPasteMenu;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import king.KMessage;
import king.KingMain;
import king.MageHypertext;

public class UIText
implements MouseListener,
KMessage.Subscriber {
    KingMain kMain;
    JFrame frame;
    JTextArea textarea;
    JCheckBox allowTextEdits;
    JButton popupButton;
    Collection mageHypertextListeners = new ArrayList();

    public UIText(KingMain kingMain) {
        this.kMain = kingMain;
        this.popupButton = new JButton(new ReflectiveAction("Show text", null, this, "onPopupButton"));
        this.frame = new JFrame("Text window");
        this.frame.setDefaultCloseOperation(1);
        this.frame.setIconImage(this.kMain.getPrefs().windowIcon);
        this.allowTextEdits = new JCheckBox(new ReflectiveAction("Allow text to be edited", null, this, "onAllowTextEdits"));
        this.allowTextEdits.setSelected(this.kMain.getPrefs().getBoolean("textDefaultAllowEdits"));
        this.textarea = new JTextArea();
        this.textarea.setEditable(this.allowTextEdits.isSelected());
        this.textarea.setLineWrap(true);
        this.textarea.setWrapStyleWord(true);
        this.textarea.addMouseListener(this);
        this.textarea.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JScrollPane jScrollPane = new JScrollPane(this.textarea);
        jScrollPane.setPreferredSize(new Dimension(500, 400));
        new TextCutCopyPasteMenu(this.textarea);
        this.addHypertextListener(new MageHypertext(this.kMain));
        this.frame.getContentPane().add((Component)this.allowTextEdits, "North");
        this.frame.getContentPane().add((Component)jScrollPane, "Center");
        this.kMain.subscribe(this);
    }

    public String getText() {
        return this.textarea.getText();
    }

    public void setText(String string) {
        this.textarea.setText(string);
        this.textarea.setCaretPosition(0);
    }

    public void appendText(String string) {
        string = this.getText().concat(string);
        int n = this.textarea.getCaretPosition();
        n = Math.min(n, string.length());
        this.textarea.setText(string);
        this.textarea.setCaretPosition(n);
    }

    public void deliverMessage(KMessage kMessage) {
        if (kMessage.testProg(16L)) {
            this.setText("");
        }
        if (kMessage.testProg(1024L)) {
            this.frame.dispose();
        }
    }

    public void cascadeBehind(Window window) {
        if (window == null) {
            return;
        }
        this.frame.pack();
        Point point = window.getLocation();
        this.frame.setLocation(point);
        this.frame.setVisible(true);
        point.x += 24;
        point.y += 24;
        window.setLocation(point);
        window.toFront();
        window.requestFocus();
    }

    public void onPopupButton(ActionEvent actionEvent) {
        if (!this.frame.isVisible()) {
            this.frame.pack();
            this.frame.setVisible(true);
        } else {
            this.frame.toFront();
        }
    }

    public void onAllowTextEdits(ActionEvent actionEvent) {
        this.textarea.setEditable(this.allowTextEdits.isSelected());
    }

    public JButton getButton() {
        return this.popupButton;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        int n = this.textarea.viewToModel(mouseEvent.getPoint());
        String string = this.getText();
        int n2 = string.lastIndexOf("*{", n);
        int n3 = string.lastIndexOf("}*", n - 2);
        int n4 = string.indexOf("*{", n);
        int n5 = string.indexOf("}*", n - 1);
        if (n2 != -1 && n2 > n3 && n5 != -1 && (n5 < n4 || n4 == -1)) {
            String string2 = string.substring(n2 + 2, n5);
            this.textarea.select(n2, n5 + 2);
            for (HypertextListener hypertextListener : this.mageHypertextListeners) {
                hypertextListener.mageHypertextHit(string2);
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void addHypertextListener(HypertextListener hypertextListener) {
        this.mageHypertextListeners.add(hypertextListener);
    }

    public void removeHypertextListener(HypertextListener hypertextListener) {
        this.mageHypertextListeners.remove(hypertextListener);
    }

    public static interface HypertextListener {
        public void mageHypertextHit(String var1);
    }
}

