/*
 * Decompiled with CFR 0.152.
 */
package molikin;

import driftwood.moldb2.Residue;
import driftwood.moldb2.SecondaryStructure;
import driftwood.r3.NRUBS;
import driftwood.r3.Triple;
import driftwood.r3.Tuple3;
import driftwood.util.Strings;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import molikin.GuidePoint;
import molikin.RibbonCrayon;
import molikin.crayons.CompositeCrayon;
import molikin.crayons.ConstCrayon;

public class RibbonPrinter {
    static final DecimalFormat df = Strings.usDecimalFormat("0.###");
    PrintWriter out;
    RibbonCrayon crayon = ConstCrayon.NONE;
    Triple tmp = new Triple();
    double widthAlpha = 2.0;
    double widthBeta = 2.2;
    double widthCoil = 1.0;
    double widthDefault = 2.0;
    boolean rnaPointIDs = false;

    public RibbonPrinter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void printGuidepoints(GuidePoint[] guidePointArray) {
        int n;
        Triple triple = new Triple();
        this.out.println("@balllist {guide points} color= red radius= 0.20 master= {guidepts}");
        for (n = 0; n < guidePointArray.length; ++n) {
            this.out.println("{guide point off=" + df.format(guidePointArray[n].offsetFactor) + " wid=" + df.format(guidePointArray[n].widthFactor) + "} " + guidePointArray[n].xyz.format(df));
        }
        this.out.println("@vectorlist {c vectors} color= green master= {guidepts}");
        for (n = 0; n < guidePointArray.length; ++n) {
            triple.likeSum(guidePointArray[n].xyz, guidePointArray[n].cvec);
            this.out.println("{c}P " + guidePointArray[n].xyz.format(df) + " {\"}L " + triple.format(df));
        }
        this.out.println("@vectorlist {d vectors} color= blue master= {guidepts}");
        for (n = 0; n < guidePointArray.length; ++n) {
            triple.likeSum(guidePointArray[n].xyz, guidePointArray[n].dvec);
            this.out.println("{d}P " + guidePointArray[n].xyz.format(df) + " {\"}L " + triple.format(df));
        }
        this.out.flush();
    }

    public void printOneLine(GuidePoint[] guidePointArray, int n, boolean bl) {
        this.printNLineImpl(guidePointArray, n, bl, 0.0, 99.0);
    }

    public void printTwoLine(GuidePoint[] guidePointArray, int n, boolean bl) {
        this.printNLineImpl(guidePointArray, n, bl, -1.0, 2.0);
    }

    public void printThreeLine(GuidePoint[] guidePointArray, int n, boolean bl) {
        this.printNLineImpl(guidePointArray, n, bl, -1.0, 1.0);
    }

    public void printFiveLine(GuidePoint[] guidePointArray, int n, boolean bl) {
        this.printNLineImpl(guidePointArray, n, bl, -1.0, 0.5);
    }

    public void printNLineImpl(GuidePoint[] guidePointArray, int n, boolean bl, double d, double d2) {
        int n2 = guidePointArray.length;
        NRUBS nRUBS = new NRUBS();
        Tuple3[] tuple3Array = new Triple[n2];
        for (int i = 0; i < n2; ++i) {
            tuple3Array[i] = new Triple();
        }
        for (double d3 = d; d3 <= 1.0; d3 += d2) {
            for (int i = 0; i < n2; ++i) {
                double d4 = guidePointArray[i].offsetFactor > 0.0 ? this.widthAlpha : this.widthBeta;
                double d5 = 0.5 * (this.widthCoil + guidePointArray[i].widthFactor * (d4 - this.widthCoil));
                if (!bl) {
                    d5 = this.widthDefault / 2.0;
                }
                ((Triple)tuple3Array[i]).like(guidePointArray[i].xyz).addMult(d3 * d5, guidePointArray[i].dvec);
            }
            Tuple3[] tuple3Array2 = nRUBS.spline(tuple3Array, n);
            boolean bl2 = true;
            for (int i = 0; i < tuple3Array2.length; ++i) {
                int n3 = i / n + 1;
                this.crayon.forRibbon(tuple3Array2[i], guidePointArray[n3], guidePointArray[n3 + 1], i % n, n);
                if (!this.crayon.shouldPrint()) {
                    bl2 = true;
                    continue;
                }
                String string = this.getPointID(tuple3Array2[i], guidePointArray[n3], guidePointArray[n3 + 1], i % n, n);
                this.tmp.like(tuple3Array2[i]);
                this.out.println("{" + string + "}" + (bl2 ? "P " : "") + this.crayon.getKinString() + " " + this.tmp.format(df));
                bl2 = false;
            }
        }
        this.out.flush();
    }

    public void printFlatRibbon(GuidePoint[] guidePointArray, int n, boolean bl) {
        int n2;
        int n3 = guidePointArray.length;
        NRUBS nRUBS = new NRUBS();
        Tuple3[] tuple3Array = new Triple[n3];
        Tuple3[] tuple3Array2 = new Triple[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            tuple3Array[n2] = new Triple();
            tuple3Array2[n2] = new Triple();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            double d = guidePointArray[n2].offsetFactor > 0.0 ? this.widthAlpha : this.widthBeta;
            double d2 = 0.5 * (this.widthCoil + guidePointArray[n2].widthFactor * (d - this.widthCoil));
            if (!bl) {
                d2 = this.widthDefault / 2.0;
            }
            ((Triple)tuple3Array[n2]).like(guidePointArray[n2].xyz).addMult(d2, guidePointArray[n2].dvec);
            ((Triple)tuple3Array2[n2]).like(guidePointArray[n2].xyz).addMult(-d2, guidePointArray[n2].dvec);
        }
        Tuple3[] tuple3Array3 = nRUBS.spline(tuple3Array, n);
        Tuple3[] tuple3Array4 = nRUBS.spline(tuple3Array2, n);
        boolean bl2 = true;
        for (int i = 0; i < tuple3Array3.length; ++i) {
            int n4 = i / n + 1;
            this.tmp.likeMidpoint(tuple3Array3[i], tuple3Array4[i]);
            this.crayon.forRibbon(this.tmp, guidePointArray[n4], guidePointArray[n4 + 1], i % n, n);
            if (!this.crayon.shouldPrint()) {
                bl2 = true;
                continue;
            }
            String string = this.getPointID(this.tmp, guidePointArray[n4], guidePointArray[n4 + 1], i % n, n);
            this.tmp.like(tuple3Array3[i]);
            this.out.println("{" + string + "}" + (bl2 ? "X " : "") + this.crayon.getKinString() + " " + this.tmp.format(df));
            this.tmp.like(tuple3Array4[i]);
            this.out.println("{\"}" + this.crayon.getKinString() + " " + this.tmp.format(df));
            bl2 = false;
        }
        this.out.flush();
    }

    public void printFancyRibbon(GuidePoint[] guidePointArray, SecondaryStructure secondaryStructure, double d, double d2, String string, String string2, String string3) {
        Object object;
        int n;
        int n2 = guidePointArray.length;
        NRUBS nRUBS = new NRUBS();
        double[] dArray = new double[]{0.0, -d / 2.0, d / 2.0, -d2 / 2.0, d2 / 2.0, -d2, d2};
        Triple[][] tripleArray = new Triple[dArray.length][guidePointArray.length];
        for (int i = 0; i < tripleArray.length; ++i) {
            for (n = 0; n < tripleArray[i].length; ++n) {
                tripleArray[i][n] = new Triple(guidePointArray[n].xyz).addMult(dArray[i], guidePointArray[n].dvec);
            }
        }
        Tuple3[][] tuple3ArrayArray = new Tuple3[dArray.length][];
        for (n = 0; n < dArray.length; ++n) {
            tuple3ArrayArray[n] = nRUBS.spline(tripleArray[n], 4);
        }
        ArrayList<RibbonElement> arrayList = new ArrayList<RibbonElement>();
        RibbonElement ribbonElement4 = new RibbonElement();
        arrayList.add(ribbonElement4);
        ribbonElement4.type = null;
        for (int i = 0; i < guidePointArray.length - 3; ++i) {
            object = guidePointArray[i + 1];
            GuidePoint guidePoint = guidePointArray[i + 2];
            RibbonElement ribbonElement2 = new RibbonElement(secondaryStructure.getRange(((GuidePoint)object).nextRes));
            RibbonElement ribbonElement3 = new RibbonElement(secondaryStructure.getRange(guidePoint.nextRes));
            if (ribbonElement4.type == null) {
                ribbonElement4.like(ribbonElement2);
            }
            if (!(ribbonElement4.sameSSE(ribbonElement2) || ribbonElement2.type != SecondaryStructure.HELIX && ribbonElement2.type != SecondaryStructure.STRAND)) {
                ribbonElement4.end = 4 * i + 1;
                ribbonElement4 = new RibbonElement(ribbonElement2);
                arrayList.add(ribbonElement4);
                ribbonElement4.start = 4 * i + 1;
            }
            if (ribbonElement4.sameSSE(ribbonElement3) || ribbonElement2.type != SecondaryStructure.HELIX && ribbonElement2.type != SecondaryStructure.STRAND) continue;
            int n3 = 4 * i + 0;
            if (ribbonElement2.type == SecondaryStructure.STRAND) {
                n3 += 3;
            }
            ribbonElement4.end = n3;
            ribbonElement4 = new RibbonElement();
            arrayList.add(ribbonElement4);
            ribbonElement4.type = SecondaryStructure.COIL;
            ribbonElement4.start = n3;
        }
        ribbonElement4.end = tuple3ArrayArray[0].length - 1;
        RibbonCrayon ribbonCrayon = this.getCrayon();
        object = new CompositeCrayon().add(new ConstCrayon("")).add(ribbonCrayon);
        for (RibbonElement ribbonElement4 : arrayList) {
            int n4;
            if (ribbonElement4.type == SecondaryStructure.HELIX) {
                this.setCrayon(ribbonCrayon);
                this.out.println("@ribbonlist {fancy helix} " + string);
                for (n4 = ribbonElement4.start; n4 < ribbonElement4.end; ++n4) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[1], n4);
                    this.printFancy(guidePointArray, tuple3ArrayArray[2], n4);
                }
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement4.end);
                this.setCrayon((RibbonCrayon)object);
                this.out.println("@vectorlist {fancy helix edges} width= 1 " + string + " color= deadblack");
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement4.start, true);
                for (n4 = ribbonElement4.start; n4 < ribbonElement4.end; ++n4) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[1], n4);
                }
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement4.end);
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement4.start, true);
                for (n4 = ribbonElement4.start; n4 < ribbonElement4.end; ++n4) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[2], n4);
                }
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement4.end);
                continue;
            }
            if (ribbonElement4.type == SecondaryStructure.STRAND) {
                this.setCrayon(ribbonCrayon);
                this.out.println("@ribbonlist {fancy sheet} " + string2);
                for (n4 = ribbonElement4.start; n4 < ribbonElement4.end - 1; ++n4) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[3], n4);
                    this.printFancy(guidePointArray, tuple3ArrayArray[4], n4);
                }
                this.printFancy(guidePointArray, tuple3ArrayArray[5], ribbonElement4.end - 2);
                this.printFancy(guidePointArray, tuple3ArrayArray[6], ribbonElement4.end - 2);
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement4.end);
                this.setCrayon((RibbonCrayon)object);
                this.out.println("@vectorlist {fancy sheet edges} width= 1 " + string2 + " color= deadblack");
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement4.start, true);
                for (n4 = ribbonElement4.start; n4 < ribbonElement4.end - 1; ++n4) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[3], n4);
                }
                this.printFancy(guidePointArray, tuple3ArrayArray[5], ribbonElement4.end - 2);
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement4.end);
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement4.start, true);
                for (n4 = ribbonElement4.start; n4 < ribbonElement4.end - 1; ++n4) {
                    this.printFancy(guidePointArray, tuple3ArrayArray[4], n4);
                }
                this.printFancy(guidePointArray, tuple3ArrayArray[6], ribbonElement4.end - 2);
                this.printFancy(guidePointArray, tuple3ArrayArray[0], ribbonElement4.end);
                continue;
            }
            this.setCrayon(ribbonCrayon);
            this.out.println("@vectorlist {fancy coil} " + string3);
            for (n4 = ribbonElement4.start; n4 <= ribbonElement4.end; ++n4) {
                this.printFancy(guidePointArray, tuple3ArrayArray[0], n4);
            }
        }
        this.setCrayon(ribbonCrayon);
        this.out.flush();
    }

    private void printFancy(GuidePoint[] guidePointArray, Tuple3[] tuple3Array, int n) {
        this.printFancy(guidePointArray, tuple3Array, n, false);
    }

    private void printFancy(GuidePoint[] guidePointArray, Tuple3[] tuple3Array, int n, boolean bl) {
        int n2 = (tuple3Array.length - 1) / (guidePointArray.length - 3);
        int n3 = n % n2;
        int n4 = n / n2 + 1;
        this.tmp.like(tuple3Array[n]);
        this.out.print("{");
        this.out.print(this.getPointID(tuple3Array[n], guidePointArray[n4], guidePointArray[n4 + 1], n3, n2));
        this.out.print("}");
        if (bl) {
            this.out.print("P ");
        }
        this.crayon.forRibbon(tuple3Array[n], guidePointArray[n4], guidePointArray[n4 + 1], n3, n2);
        this.out.print(this.crayon.getKinString());
        this.out.print(" ");
        this.out.println(this.tmp.format(df));
    }

    public RibbonCrayon getCrayon() {
        return this.crayon;
    }

    public void setCrayon(RibbonCrayon ribbonCrayon) {
        this.crayon = ribbonCrayon;
    }

    public void setWidth(double d) {
        this.widthDefault = d;
    }

    public void setWidth(double d, double d2, double d3) {
        this.widthAlpha = d;
        this.widthBeta = d2;
        this.widthCoil = d3;
    }

    private String getPointID(Tuple3 tuple3, GuidePoint guidePoint, GuidePoint guidePoint2, int n, int n2) {
        Residue residue = guidePoint.nextRes;
        if (this.rnaPointIDs && n <= n2 / 2) {
            residue = guidePoint.prevRes;
        }
        StringBuffer stringBuffer = new StringBuffer(11);
        stringBuffer.append(residue.getName());
        stringBuffer.append(" ");
        stringBuffer.append(residue.getChain());
        stringBuffer.append(" ");
        stringBuffer.append(residue.getSequenceNumber().trim());
        stringBuffer.append(residue.getInsertionCode());
        return stringBuffer.toString().toLowerCase();
    }

    public void setRnaPointIDs(boolean bl) {
        this.rnaPointIDs = bl;
    }

    static class RibbonElement {
        int start = 0;
        int end = 0;
        Object type = SecondaryStructure.COIL;
        SecondaryStructure.Range range = null;

        public RibbonElement() {
        }

        public RibbonElement(RibbonElement ribbonElement) {
            this.like(ribbonElement);
        }

        public RibbonElement(SecondaryStructure.Range range) {
            this.range = range;
            this.type = range == null ? SecondaryStructure.COIL : range.getType();
            if (this.type == SecondaryStructure.TURN) {
                this.type = SecondaryStructure.COIL;
            }
        }

        public boolean sameSSE(RibbonElement ribbonElement) {
            return this.type == ribbonElement.type && this.range == ribbonElement.range;
        }

        public void like(RibbonElement ribbonElement) {
            this.start = ribbonElement.start;
            this.end = ribbonElement.end;
            this.type = ribbonElement.type;
            this.range = ribbonElement.range;
        }
    }
}

