from setuptools import setup

setup(
    name='qmpy',
    version='0.2.0',
    author='S. Kirklin',
    author_email='scott.kirklin@gmail.com',
    packages=['qmpy', 
        'qmpy.analysis', 
        'qmpy.io', 
        'qmpy.materials',
        'qmpy.analysis',
        'qmpy.analysis.vasp',
        'qmpy.analysis.thermodynamics',
        'qmpy.analysis.symmetry',
        'qmpy.computing',
        'qmpy.configuration', 
        'qmpy.utils'],
    scripts=['bin/oqmd'],
    url='http://pypi.python.org/pypi/qmpy',
    license='LICENSE.txt',
    description='Suite of computational materials science tools',
    long_description=open('README.txt').read(),
    install_requires=[
        "Django >= 1.1.1",
        "PuLP",
        "numpy >= 1.6.4",
        "scipy >= 0.12.0",
        "PyYAML",
        "MySQL-python",
        "pytest",
        "PyCifRW",
        "matplotlib",
        "networkx",
        "python-memcached",
        "django-extensions",
        "ase",
        "argparse"
    ],
)
