from setuptools import setup

setup(
    name='qmpy',
    version='0.3.3',
    author='S. Kirklin',
    author_email='scott.kirklin@gmail.com',
    packages=['qmpy', 
        'qmpy.analysis', 
        'qmpy.configuration',
        'qmpy.configuration.resources',
        'qmpy.configuration.vasp_settings',
        'qmpy.configuration.qfiles',
        'qmpy.io', 
        'qmpy.db',
        'qmpy.data',
        'qmpy.data.elements',
        'qmpy.materials',
        'qmpy.analysis',
        'qmpy.analysis.vasp',
        'qmpy.analysis.thermodynamics',
        'qmpy.analysis.symmetry',
        'qmpy.computing',
        'qmpy.configuration', 
        'qmpy.utils'],
    scripts=['bin/oqmd'],
    url='http://pypi.python.org/pypi/qmpy',
    license='LICENSE.txt',
    description='Suite of computational materials science tools',
    long_description=open('README.txt').read(),
    package_data = {'': ['*.yml', '*.txt', '*.dat', '*.cfg']},

    install_requires=[
        "Django >= 1.1.1",
        "PuLP",
        "numpy >= 1.6.4",
        "scipy >= 0.12.0",
        "PyYAML",
        "MySQL-python",
        "pytest",
        "PyCifRW",
        "matplotlib",
        "networkx",
        "python-memcached",
        "django-extensions",
        "argparse"
    ],
)
