#!/usr/bin/env python
# -*- Mode: python; tab-width: 4; indent-tabs-mode: nil; coding: utf-8 -*-
"""
qslaunch.helpers.exec
~~~~~~~~~~~~~~~~~~~~~

Provides helper functions for executing shell commands.

Execute helpers
-----------------------------------------------------------------------------

.. autofunction:: shell_exec

Commands
-----------------------------------------------------------------------------

.. autofunction:: cmd_exec


..
    :copyright: 2010 Serge Émond
    :license: Apache License 2.0
"""

import os
import shlex

#############################################################################
################################################################# shortcuts #
#############################################################################

def shell_exec(command):
    """
    :func:`shell_exec` helper for :func:`cmd_exec`.
    
    See :func:`cmd_shell_exec` for usage.
    
    """
    return (cmd_exec, (), {'command': command})

#############################################################################
################################################################## commands #
#############################################################################

def cmd_exec(command, **kwargs):
    """
    Simply "exec" the command with the given arguments in the current process.
    
    :param command: shell command to execute
    
    """
    if len(kwargs) > 0:
        command = command % kwargs
    args = shlex.split(command)
    cmd = args[0]
    args[0] = os.path.basename(args[0])
    os.execv(cmd, args)

