#!/usr/bin/env python
import os
import sys

from setuptools import setup, find_packages

here = os.path.dirname(os.path.abspath(__file__))
sys.path.insert(0, os.path.join(here, 'src'))

from quant import __version__

basePath = os.path.abspath(os.path.dirname(sys.argv[0]))
scripts = [ 
    os.path.join('bin', 'quant-makeconfig'),
    os.path.join('bin', 'quant-admin'),
    os.path.join('bin', 'quant-test'),
]

setup(
    name='quant',
    version=__version__,

    package_dir={'': 'src'},
    packages=find_packages('src'),
    scripts=scripts,
    # just use auto-include and specify special items in MANIFEST.in
    include_package_data = True,
    zip_safe = False,
    install_requires = [
        'domainmodel==0.11',
        'python-dateutil',
        # Installing scipy with setuptools doesn't work.
        #'scipy', 
        #'numpy',
    ],
    author='Appropriate Software Foundation',
    author_email='john.bywater@appropriatesoftware.net',
    license='GPL',
    url='http://appropriatesoftware.net/quant',
    description='Enterprise architecture for quantitative analysis',
    long_description = """

Welcome to Quant
----------------

Quant is a Python enterprise application for quantitative analysis. 
Quant combines `SciPy <http://www.scipy.org/>`_ and `DomainModel
<http://appropriatesoftware.net/domainmodel/Home.html>`_.

Quant contains a domain model of quantitative analysis. It has object markets,
prices, contracts, books and reports. There are cohesive mechanisms for pricing
and reporting. The domain model can easily be extended to support different
applications of quantitative analysis.

Please note: this is new software; several important things don't work at all.


Install Guide
-------------

The easiest way to deploy the Quant system is with the quant installer::

    $ wget http://appropriatesoftware.net/provide/docs/quant-virtualenv
    $ chmod +x quant-virtualenv

The installer will build a virtual Python environment, and install
the Quant software. The installer will then set up a new site with an SQLite
database, and it will create an Apache config file to be included in the main
Apache configuration (see below).

Before running the installer, make sure the following packages are installed::

    $ sudo aptitude install apache2 libapache2-mod-wsgi build-essential gcc python-numpy python-scipy

Also, make sure Apache mod_wsgi is enabled::

    $ sudo a2enmod wsgi

Run the installer, at least with a path argument (see --help for options)::

    $ ./quant-virtualenv YOUR-SITE-DIR
 
The path argument can be relative or absolute.

Then, change ownership of the entire site to the Apache server::

    $ sudo chown -R www-data:www-data YOUR-SITE-PATH

You can do more complicated things with the installer (see --help) and
with the file permissions and ownerships, but those few lines should work.

Finally, follow the instructions about configuring Apache that are shown
by the installer. Pick a domain name for your site. Create a new virtual
host which includes the auto-generated Apache configuration (path mentioned
by the installer). Then configure your DNS. A new Apache virtual host could
simply look like this::

    <VirtualHost *:80>
        ServerName YOUR-SITE-DOMAIN-NAME
        Include YOUR-SITE-PATH/var/httpd-autogenerated.conf
    </VirtualHost>

The path to the auto-generated file must be an absolute path (not a relative path).

After restarting, your virtual host will show a page saying 'Welcome to Quant'.
You will be able to login with username 'admin' and password 'pass'.


Contact
-------

Please note: this is new software; several important things don't work at all.

If you have any difficulties or questions about Quant, please contact::

    john.bywater@appropriatesoftware.net


Please note at the moment, Quant is developed and tested on Ubuntu 10.10 (64 bit)
with Python 2.6 only, although it should work on any recent Linux distribution.


About
-------

Quant is a project of the Appropriate Software Foundation. Please refer to the `Quant website <http://appropriatesoftware.net/quant/Home.html>`_ for more information.

""",
    classifiers = [
#        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Environment :: Web Environment',
#        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License (GPL)',
#        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules'],
)
