import numpy as np
import os.path
import matplotlib.pyplot as plt
import matplotlib
import urllib
import urllib2
import datetime
import sys
import webbrowser
import os
import re
import time
import json
import imp
from sys import platform as _platform
import subprocess as sp
import inspect

def loaddata(marketlist=None, refresh=False):


    # Check if Marketlist is supplied. If not use default stock list.
    if marketlist==None:

        # SP 100 Stocks
        #marketlist = ['AAPL','ABBV','ABT','ACN','AEP','AIG','ALL','AMGN','AMZN','APA','APC','AXP','BA','BAC','BAX','BK','BMY','BRKB','C','CAT','CL','CMCSA','COF','COP','COST','CSCO','CVS','CVX','DD','DIS','DOW','DVN','EBAY','EMC','EMR','EXC','F','FB','FCX','FDX','FOXA','GD','GE','GILD','GM','GOOGL','GS','HAL','HD','HON','HPQ','IBM','INTC','JNJ','JPM','KO','LLY','LMT','LOW','MA','MCD','MDLZ','MDT','MET','MMM','MO','MON','MRK','MS','MSFT','NKE','NOV','NSC','ORCL','OXY','PEP','PFE','PG','PM','QCOM','RTN','SBUX','SLB','SO','SPG','T','TGT','TWX','TXN','UNH','UNP','UPS','USB','UTX','V','VZ','WAG','WFC','WMT','XOM']
        # Futures Data
        marketlist = ['F_AD', 'F_BO', 'F_BP', 'F_C', 'F_CD', 'F_CL', 'F_DJ', 'F_EC', 'F_ES', 'F_FV', 'F_GC', 'F_HG', 'F_HO', 'F_LC', 'F_LN', 'F_NG', 'F_NQ', 'F_RB', 'F_S', 'F_SF', 'F_SI', 'F_SM', 'F_SP', 'F_TY', 'F_US', 'F_W', 'F_YM']
    nMarkets = len(marketlist)


    #Save within working directory
    dataDir=os.path.join('tickerData')

    #check if data directory exists. If not make directory.
    if not os.path.isdir(dataDir):
        os.mkdir(dataDir)

    # Loop through market list. Download and save market data.
    for j in range(nMarkets):
        path=os.path.join(dataDir,marketlist[j]+'.txt')

        # check to see if market data is present. If not (or refresh is true), download data from quantiacs.
        if not os.path.isfile(path) or refresh:
            try:
                urllib.urlretrieve('https://www.quantiacs.com/data/'+marketlist[j]+'.txt', path)
                print 'Downloading '+ marketlist[j]
            except:
                print 'Unable to download '+marketlist[j]
                marketlist.remove(marketlist[j])


    #Date management -- Uses ordinal dates to count
    StartDateInt=datetime.date(1990,01,01).toordinal()
    Today=datetime.date.today()
    TodayInt=Today.toordinal()
    OrdinalRange=range(StartDateInt,TodayInt+1)
    DATE_Large=[]

    #Build list of dates from 1990 to today in YYYYMMDD format
    for j in OrdinalRange:
        dt=datetime.datetime.fromordinal(j)
        DATE_Large.append(dt.strftime('%Y%m%d'))

    fieldNames=[]
    fieldNames=np.genfromtxt(path, delimiter=',',dtype=None)
    fieldNames=str(fieldNames[0][:])


    nDays=len(OrdinalRange)
    CLOSE=np.empty((nDays,nMarkets))
    OPEN=np.empty((nDays,nMarkets))
    HIGH=np.empty((nDays,nMarkets))
    LOW=np.empty((nDays,nMarkets))
    VOL=np.empty((nDays,nMarkets))
    E=np.empty((nDays,nMarkets))
    CLOSE[:],OPEN[:],HIGH[:],LOW[:],VOL[:],E[:]=np.nan,np.nan,np.nan,np.nan,np.nan,np.nan

    sys.stdout.write( 'Loading Markets... '),


    DATE_global=[False]*len(OrdinalRange)
    #import and load market data
    for j in range(nMarkets):
        path=os.path.join(dataDir, marketlist[j] +'.txt')
        data=np.genfromtxt(path, delimiter=',',dtype=None)[1:][:]

#         if j%(nMarkets/10.)==0:
#             print '.',
#             sys.stdout.flush()

        DATES=map(int,data[:,0])

        # Find positions of equity trading days in DATES_Large
        DATES_unique_sorted, DATES_idx = np.unique(DATES, return_index=True)
        DATE_ordinal_IDX = np.in1d(DATE_Large, DATES_unique_sorted,  assume_unique=True)


        OPEN[DATE_ordinal_IDX,j], HIGH[DATE_ordinal_IDX,j], LOW[DATE_ordinal_IDX,j], CLOSE[DATE_ordinal_IDX,j], VOL[DATE_ordinal_IDX,j], E[DATE_ordinal_IDX,j] = data[DATES_idx,1], data[DATES_idx,2], data[DATES_idx,3], data[DATES_idx,4], data[DATES_idx,5], data[DATES_idx,6]
        DATE_global=map(sum, zip(DATE_global,DATE_ordinal_IDX))

    CLOSE=CLOSE[~np.isnan(CLOSE).all(axis=1)]

    CLOSE=fillnans(CLOSE)

    OPEN=OPEN[~np.isnan(OPEN).all(axis=1)]
    LOW=LOW[~np.isnan(LOW).all(axis=1)]
    HIGH=HIGH[~np.isnan(HIGH).all(axis=1)]
    VOL=VOL[~np.isnan(VOL).all(axis=1)]
    E=E[~np.isnan(E).all(axis=1)]
    OPEN, HIGH, LOW = fillwith(OPEN,CLOSE), fillwith(HIGH,CLOSE), fillwith(LOW,CLOSE)

    E[np.isnan(E)]=0

    finalDates=map(bool,DATE_global)
    DATES_out=[DATE_Large[i] for i in range(len(OrdinalRange)) if finalDates[i]==True]

    print '\b Done! \n',
    sys.stdout.flush()

    return CLOSE,OPEN,HIGH,LOW,VOL,E,fieldNames, DATES_out


def runts(tradingSystem, plotEquity=True, reloadData=False, state={}):


  #check that filepath is a proper path or a callable object is submitted
    if hasattr(tradingSystem,'__call__'):
        filePathFlag=False
        TSobject=tradingSystem
    elif os.path.isfile(tradingSystem):
        filePathFlag=True
        filePath=tradingSystem

        try:
            TSmodule=imp.load_source('tradingSystemModule',filePath)
            settings=TSmodule.mySettings()
        except:
            print 'Trading system file not found. Please input the path to your trading system'


    else:
        print "Please input the your trading system's file path or a callable object."


    if not state:
        state['save']=False
        state['resume']=False
        state['runtimeInterrupt']=False
    else:
        if isinstance(state, dict):
            if 'save' not in state:
                state['save']=False
            if 'resume' not in state:
                state['resume']=False
            if 'runtimeInterrupt' not in state:
                state['runtimeInterrupt'] = False

        else:
            print 'state variable is not a dict'


    # get boolean index of futures

    futuresIx=map(lambda string:bool(re.match("F_",string)),settings['markets'])


    #Load markets and pass data to data variables
#    global CLOSE,OPEN,HIGH,LOW,VOL,R,fieldNames,DATE
    CLOSE,OPEN,HIGH,LOW,VOL,R,fieldNames,DATE=loaddata( settings['markets'],reloadData)
    SLIPPAGE = (HIGH - LOW) *  settings['slippage']

    errorlog=[]
    nMarkets=len( settings['markets'])
    nDays=len(DATE)
    Rix= R>0

    equity=np.zeros((nDays,nMarkets))
    exposure=np.zeros((nDays+2,nMarkets))
    returns=CLOSE-OPEN
    gaps=OPEN[1:,:]-CLOSE[0:-1,:]
    gaps=np.insert(gaps,0,np.zeros((1,nMarkets))*np.nan,axis=0)


    if np.isnan( settings['lookback'] ):
        startLoop=0
    else:
        startLoop= settings['lookback']-1

    # Server evaluation --- resumes for new day.
    if state['resume']:
        if 'ret' in state:
            try:
                ixNew=DATE>state['ret']['fundDate'][-1]
                ret=state['ret']
                if plotEquity:
                    for j in ret['errorLog']:
                        print(ret['erroLog'][j])

                    plotts(ret['fundEquity'], ret['fundTradeDates'],ret['tsName'])
            except:
                pass

            ixMap=ismember(DATE,state['ret']['fundDate'])
            ixMapExposure=np.concatenate(([False,False],ixMap),axis=0)
            equity[ixMap,:]=state['ret']['marketEquity']
            exposure[ixMapExposure,:]=state['ret']['marketExposure']

            posVec=arange(1,len(ixNew))
            posVec=posVec[ixNew].copy()
            startLoop=posVec[1]

            print('Resuming'+tsName+'| computing' +str(nDays-startLoop+1)+' new days')
            settings= state['ret']['settings']


    t0= time.time()

    for t in range(startLoop,nDays):

        todaysP=exposure[t+1,:].copy()
        yesterdaysP=exposure[t,:].copy()
        deltaP=todaysP-yesterdaysP

        newGap=yesterdaysP * gaps[t,:]
        newGap[np.isnan(newGap)]= 0

     # Morning

        equity[t,:]=equity[t-1,:]+newGap * np.invert(Rix[t,:])

        # Dynamic contract Rolls
        if np.any(Rix[t,:]):
            CLOSE[0:t,Rix[t,:]] = CLOSE[0:t,Rix[t,:]] + np.tile( OPEN[t,Rix[t,:]]-CLOSE[t-1,Rix[t,:]],(t,1) )
            OPEN[0:t,Rix[t,:]]  = OPEN[0:t,Rix[t,:]]  + np.tile(OPEN[t,Rix[t,:]]-CLOSE[t-1,Rix[t,:]],(t,1))
            HIGH[0:t,Rix[t,:]] = HIGH[0:t,Rix[t,:]] + np.tile(OPEN[t,Rix[t,:]]-CLOSE[t-1,Rix[t,:]],(t,1))
            LOW[0:t,Rix[t,:]]   = LOW[0:t,Rix[t,:]]   + np.tile(OPEN[t,Rix[t,:]]-CLOSE[t-1,Rix[t,:]],(t,1))

        cash=settings['budget']+np.sum(equity[t,:])

        if  cash <= 0:
            errorlog.append(str(DATE[t])+ ': Out of money.')
            exposure[t+2,:] = todaysP.copy()
            equity[t:,:] = np.tile(equity[t,:],(nDays-t+1,1))
            break

    # enough margin check
        O = OPEN[t,:].copy()
        S = SLIPPAGE[t,:].copy()
        O[np.isnan(O)] = 0
        S[np.isnan(S)] = 0

        marginOS= cash - np.sum(np.abs(todaysP * O)) - np.sum(np.abs(deltaP * S))
        if marginOS< 0 and any(deltaP):
            errorlog.append(str(DATE[t])+ ': Orders rejected. Not enough margin.')
            exposure[t+1,:]=yesterdaysP.copy()
            todaysP = yesterdaysP.copy()
            deltaP = np.zeros((1, nMarkets))

    #  forced sells
        marginO= cash- np.sum(np.abs(todaysP * O))
        if  marginO< 0:
            errorlog.append(str(DATE[t])+': Forced reduction of assets due to insufficient margin.')
            oneSlice = todaysP / np.max(np.abs(todaysP))
            numSlice = 0
            tP = todaysP.copy()
            dP = deltaP.copy()

            while np.sum(np.abs(tP)) > 0 and  cash - np.sum(np.abs(tP * O)) - np.sum(np.abs(dP * S)) < 0:

                numSlice = numSlice + 1
                tP = np.round(todaysP - numSlice * oneSlice)
                if numSlice > np.max(np.abs(todaysP)):
                    tP = np.zeros(np.size(tP))

                dP = tP - yesterdaysP

            exposure[t+1,:]=tP.copy()
            todaysP = tP.copy()
            deltaP =  dP.copy()

    # market participation check
        V = VOL[t,:].copy()
        V[np.isnan(V)] = 0
        V[futuresIx]=10**8
        cX = np.abs(deltaP) > V *  settings['participation']
        if cX.any()>0:
            errorlog.append(str(DATE[t])+ ': Orders not fully executed.')
            deltaP[cX] = np.sign(deltaP[cX]) * np.floor(V[cX] *  settings['participation'])
            todaysP = deltaP + yesterdaysP

        newRet = todaysP * returns[t,:] - np.abs(deltaP * SLIPPAGE[t,:])
        newRet[np.isnan(newRet)] = 0

     # Evening
        equity[t,:] = equity[t,:] + newRet

        # run trading system
        try:

           #python returns the value up to but not including the end of the slice (hence the t+1 or +2 in the case of exposure)
            if filePathFlag is True:
                position, settings = TSmodule.myTradingSystem(DATE[t- settings['lookback'] +1:t+1], OPEN[t- settings['lookback'] +1:t+1,:], HIGH[t- settings['lookback'] +1:t+1,:], LOW[t- settings['lookback'] +1:t+1,:], CLOSE[t- settings['lookback']+1:t+1,:], VOL[t- settings['lookback'] +1:t+1,:], exposure[t- settings['lookback'] +2:t+2,:], equity[t- settings['lookback'] +1:t+1,:], settings);
            else:
                position, settings = TSobject.myTradingSystem(DATE[t- settings['lookback'] +1:t+1], OPEN[t- settings['lookback'] +1:t+1,:], HIGH[t- settings['lookback'] +1:t+1,:], LOW[t- settings['lookback'] +1:t+1,:], CLOSE[t- settings['lookback']+1:t+1,:], VOL[t- settings['lookback'] +1:t+1,:], exposure[t- settings['lookback'] +2:t+2,:], equity[t- settings['lookback'] +1:t+1,:], settings);
        except:
            errorlog.append(str(DATE[t])+ ': ' + str(sys.exc_info()[0]))
            equity[t:,:] = np.tile(equity[t,:] - SLIPPAGE[t,:] * np.abs(todaysP) ,(nDays-t,1))
            raise
            break

    # Reset to contest settings (used for various contest evaluations)
#         settings['lookback'] = 504
#         settings['budget'] = 10**6
#         settings['slippage'] = 0.05
#         settings['participation'] = 0.1

        position[np.isnan(position)] = 0
        position = np.real(np.floor(position))
        exposure[t+2,:] = position.copy()

        t1=time.time()
        runtime = t1-t0

        if runtime >300:
            errorlog.append('Evaluation stopped: Runtime exceeds 5 minutes.')
            break






    ret['fundDate']=DATE
    ret['fundTradeDates']=DATE[settings['lookback']:]
    ret['fundEquity']=settings['budget']+np.sum(equity[settings['lookback']:,:],axis=1)
    ret['marketEquity']= equity
    ret['marketExposure'] = exposure[2:,:]
    ret['settings']=settings
    ret['errorLog']=errorlog[1:]
    ret['runtime']=runtime
    ret['stats']=stats(ret['fundEquity'])
    ret['evalDate']=DATE[t]

    if state['save']:
        with open(tsName+'.json') as fileID:
            stateSave=json.dump(state,fileID)




    fundequity = settings['budget'] + np.sum(equity[(settings['lookback']-1):,:],axis=1)
    np.savetxt('/Users/vnredmon/Desktop/eqCurve.csv',fundequity,delimiter=",")

    np.savetxt('/Users/vnredmon/Desktop/pyExposure.csv',exposure,delimiter=",")


    if plotEquity:
        statistics,returns = plotts(fundequity,DATE[settings['lookback']-1:])
    else:
        statistics,returns = stats(fundequity)
    results={}
    results['equity']=equity
    results['exposure']=exposure
    results['errorlog']=errorlog
    results['stats']=statistics
    results['settings']=settings
    results['ret']=ret

    return results


def plotts(equity,DATE):
# plotting equity curve

    DATEord=[]
    for i in range(len(DATE)):
        DATEord.append(datetime.datetime.strptime(str(DATE[i]),'%Y%m%d'))

    st,returns=stats(equity)


    ax=plt.subplot(111)

    ax.plot(np.array(DATEord),equity, label='perf',linewidth=0.5)
    ax.plot(DATEord[st['maxDDBegin']:st['maxDDEnd']+1],equity[st['maxDDBegin']:st['maxDDEnd']+1],color='red',linewidth=0.5)
    ax.plot(DATEord[(st['maxTimeOffPeakBegin']+1):(st['maxTimeOffPeakBegin']+st['maxTimeOffPeak']+2)],equity[st['maxTimeOffPeakBegin']+1]*np.ones((st['maxTimeOffPeak']+1)),'r--',linewidth=2)

    box = ax.get_position()
    ax.set_position([box.x0, box.y0, box.width * 0.8, box.height])

    ax.autoscale(tight=True)
    ax.set_title('Trading System Performance')
    ax.set_ylabel('Performance (Logarithmic)')
    ax.set_xlabel('Year')
    ax.set_yscale('log')

    statsStr="Sharpe Ratio = {sharpe:.4f}\nSortino Ratio = {sortino:.4f}\n\nPerformance (%/yr) = {returnYearly:.4f}\nVolatility (%/yr)       = {volaYearly:.4f}\n\nMax Drawdown = {maxDD:.4f}\nMAR Ratio         = {mar:.4f}\n\n Max Time off peak =  {maxTimeOffPeak}\n\n\n\n\n\n".format(**st)
    ax.text(1.05, 0.8, statsStr, ha="left", va="top", size=10,transform=ax.transAxes)

    locator=matplotlib.ticker.LinearLocator(numticks=5)
    ax.yaxis.set_major_locator(locator)
    ax.yaxis.set_major_formatter(matplotlib.ticker.FormatStrFormatter('%d'))

    plt.draw()
    plt.show()
    return st,returns



def stats(equityCurve):

    returns=(equityCurve[1:]-equityCurve[0:-1])/equityCurve[0:-1]

    volaDaily=np.std(returns)
    volaYearly=np.sqrt(252)*volaDaily

    index=np.cumprod(1+returns)
    indexEnd=index[-1]

    returnDaily = np.exp(np.log(indexEnd)/returns.shape[0])-1
    returnYearly = (1+returnDaily)**252-1
    sharpeRatio = returnYearly / volaYearly

    downsideReturns = returns.copy()
    downsideReturns[downsideReturns > 0]= 0
    downsideVola = np.std(downsideReturns)
    downsideVolaYearly = downsideVola *np.sqrt(252)

    sortino = returnYearly / downsideVolaYearly

    highCurve = equityCurve.copy();
    for k in range(len(highCurve)-1):
        if highCurve[k+1] < highCurve[k]:
            highCurve[k+1] = highCurve[k]

    underwater = equityCurve / highCurve;
    mi = np.min(underwater)
    mIx = np.argmin(underwater)
    maxDD = 1 - mi;

    mX= np.where(highCurve[0:mIx] == np.max(highCurve[0:mIx]))
    mX=mX[0][0]

    mar   = returnYearly / maxDD;


    mToP = equityCurve < highCurve;
    mToP = np.insert(mToP, [0,len(mToP)],False)
    mToPdiff=np.diff(mToP.astype('int'))
    ixStart   = np.where(mToPdiff==1)[0]
    ixEnd     = np.where(mToPdiff==-1)[0]


    offPeak         = ixEnd - ixStart
    maxTimeOffPeak  = np.max(offPeak)
    topIx           = np.argmax(offPeak)


    if np.not_equal(np.size(topIx),0):

        mtopStart= ixStart[topIx]-2
        mtopEnd= ixEnd[topIx]-1

    else:
        mtopStart = np.NaN
        mtopEnd = np.NaN
        maxTimeOffPeak = np.NaN

    st={}
    st['sharpe']              = sharpeRatio
    st['sortino']             = sortino
    st['returnYearly']        = returnYearly
    st['volaYearly']          = volaYearly
    st['maxDD']               = maxDD
    st['maxDDBegin']          = mX
    st['maxDDEnd']            = mIx
    st['mar']                 = mar
    st['maxTimeOffPeak']      = maxTimeOffPeak
    st['maxTimeOffPeakBegin'] = mtopStart
    st['maxTimeOffPeakEnd']   = mtopEnd


    return st, returns


def submit(tradingSystem, tsName):

    if hasattr(tradingSystem,'__call__'):
        import inspect
        filePathFlag=False
        tsSource=inspect.getsource(tradingSystem)
        tsFilePath="./TSupload1618.py"
        tsFile = open(tsFilePath, "w")

        tsFile.write(tsSource)

        tsFile.close()
        filePath=tsFilePath
        fileFolder, fileName=os.path.split(inspect.getsourcefile(tradingSystem))

        if os.path.isfile(filePath+'.asc'):
            os.remove(filePath+'.asc')


    elif os.path.isfile(tradingSystem) and os.access(tradingSystem, os.R_OK):
        filePathFlag=True
        filePath=tradingSystem
        fileFolder, fileName=os.path.split(filePath)

        if os.path.isfile(filePath+'.asc'):
            os.remove(filePath+'.asc')
    else:
        print "Please input the your trading system's file path or a callable object."


    toolboxPath=os.path.realpath(__file__)
    toolboxDir,Nothing=os.path.split(toolboxPath)

    #Perform encryption on Linux Machines
    if _platform == "linux" or _platform == "linux2" or _platform=="darwin":
        # linux
        try:
            gpgLocation=sp.check_output("which gpg", shell=True)# findout if gpg get exists

        except sp.CalledProcessError:
            print 'GnuPG encryption not found.\n\nPlease install GnuPG!\nMore Information can be found at https://www.gnupg.org'
            raise

        try:
            sp.call(gpgLocation.rstrip() + ' --import '+ os.path.join(toolboxDir, 'data', 'GnuPG','key','Quantiacs.asc'), shell=True ) ###verify file path. ##need os.path.join?

        except sp.CalledProcessError:
            print 'Quantiacs Public Key not found'
            raise

        try:
            encryptedSystem=sp.check_output(gpgLocation.rstrip()+' --armor --recipient submit@quantiacs.com --encrypt --trust-model always ' + filePath,shell=True)
        except sp.CalledProcessError:
            print 'Encryption of' + fileName + ' failed'
            raise


  # Perform encryption on Windows machines
    elif _platform == "win32":
        print 'Cannot encrypt files on Windows Machines. Visit quantiacs.com/Upload.aspx to upload your system. Quantiacs SSL enabled website will provide some protection for your Trading System. Additionally, you can encrypt your system by hand using the Quantiacs Public Key.'


    print "Submitting File..."
    encryptedFile=open(filePath+'.asc')
    encryptedText=encryptedFile.read()

    submissionUrl='http://www.quantiacs.com/quantnetsite/UploadTradingSystem.aspx'
    data=urllib.urlencode({'fileName':fileName[:-3],'name':tsName,'data':encryptedText})
    req = urllib2.Request(submissionUrl, data)
    guid= urllib2.urlopen(req)
    the_page = guid.read()
    print the_page

    os.remove(filePath+'.asc')


    webbrowser.open_new_tab('http://www.quantiacs.com/quantnetsite/UploadSuccess.aspx?guid='+str(the_page))


def simpleTS(DATE, OPEN, HIGH, LOW, CLOSE, VOL, exposure, equity, settings):

    nMarkets=CLOSE.shape[1]
    pos=np.ones((1,nMarkets))*0.001
    cash=settings['budget'] + np.sum(equity[-1,:])*0.95
    pos=pos*cash/CLOSE[-1,:]
    return pos, settings

def fillnans(inArr):

    nanPos= np.where(np.isnan(inArr))
    nanRow=nanPos[0]
    nanCol=nanPos[1]

    for i in range(len(nanRow)):
        if nanRow[i] >0:
            inArr[nanRow[i],nanCol[i]]=inArr[nanRow[i]-1,nanCol[i]]
    return inArr

def fillwith(field, lookup):
#    pdb.set_trace()
    out = field
    nanPos= np.where(np.isnan(out[2:,:]));
    nanRow=nanPos[0]
    nanCol=nanPos[1]

    for i in range(len(nanRow)):
        if nanRow[i] > 0:
            out[nanRow[i],nanCol[i]] = lookup[nanRow[i]-1,nanCol[i]];

    return out


def ismember(a, b):
    bIndex = {}
    for item, elt in enumerate(b):
        if elt not in bIndex:
            bIndex[elt] = item
    return [bIndex.get(item, None) for item in a]  # None can be replaced by any other "not in b" value
