from quick_orm.core import Database
from sqlalchemy import Column, String, Text

class User(object):
    __metaclass__ = Database.DefaultMeta
    name = Column(String(30))

@Database.one_to_one(User)
class Contact(object):
    __metaclass__ = Database.DefaultMeta
    email = Column(String(70))
    address = Column(String(70))

if __name__ == '__main__':
    database = Database('sqlite://')
    database.create_tables()

    contact = Contact(email = 'quick.orm.feedback@gmail.com', address = 'Shenzhen, China')
    user = User(name = 'Tyler Long', contact = contact)
    database.session.add_then_commit(user)
    
    user = database.session.query(User).get(1)
    print 'User:', user.name
    print 'Email:', user.contact.email
    print 'Address:', user.contact.address
