from testharness import import_from_parent, test_run

import_from_parent()
from quoter import *

def test_braces():
    assert braces('this') == '{this}'
    assert braces('this', padding=1) == '{ this }'
    assert braces('this', margin=1) == ' {this} '
    assert braces('this', padding=1, margin=1) == ' { this } '

def test_brackets():
    assert brackets('this') == '[this]'
    assert brackets('this', padding=1) == '[ this ]'
    assert brackets('this', margin=1) == ' [this] '
    assert brackets('this', padding=1, margin=1) == ' [ this ] '
    
def test_chars():
    percent = Quoter(chars='%%')
    assert percent('something') == '%something%'
    doublea = Quoter(chars='<<>>')
    assert doublea('AAA') == '<<AAA>>'

def test_shortcuts():    
    assert ' '.join([qs('one'), qd('two'), qb('and'), qt('three')]) == \
        "'one' \"two\" `and` \"\"\"three\"\"\""
    
def test_instant():
    assert Quoter(chars='+[  ]+')('castle') == '+[ castle ]+'
    
def test_lambda():
    f = lambda v: ('(', abs(v), ')') if v < 0 else ('', v, '')
    financial = LambdaQuoter(f)
    print financial(-3)
    print financial(45)
    assert financial(-10) == '(10)'
    assert financial(44)  == '44'
    
    password = LambdaQuoter(lambda v: ('', 'x' * len(v), ''))
    assert password('secret!') == 'xxxxxxx'
    
    wf = lambda v:  ('**', v, '**') if v < 0 else ('', v, '')
    warning = LambdaQuoter(wf)
    assert warning(12) == '12'
    assert warning(-99) == '**-99**'
    assert warning(-99, padding=1) == '** -99 **'
    
def test_examples():
    assert single('this') == "'this'"
    assert double('that') == '"that"'
    assert backticks('ls -l') == "`ls -l`"
    assert braces('curlycue') == "{curlycue}"
    
    bars = Quoter('|')
    assert bars('x') == '|x|'
    
    plus = Quoter('+', '')
    assert plus('x') == '+x'
    
    variable = Quoter('${', '}', name='variable')
    assert variable('x') == '${x}'
    assert quote('myvar', style='variable') == '${myvar}'
    
def test_redef():
    braces = Quoter('{', '}', padding=1, name='braces')
    assert braces('this') == '{ this }'
    assert braces('this', padding=0) == '{this}'


def test_para():
    para = HTMLQuoter('p')
    assert para('this is great!', {'class':'emphatic'}) == "<p class='emphatic'>this is great!</p>"
    assert para('this is great!', '.emphatic') == "<p class='emphatic'>this is great!</p>"
    assert para('First para!', '#first') == "<p id='first'>First para!</p>"

    para_e = HTMLQuoter('p.emphatic')
    assert para_e('this is great!') == "<p class='emphatic'>this is great!</p>"
    assert para_e('this is great?', '.question') == "<p class='question'>this is great?</p>"
    
    br = HTMLQuoter('br', void=True)
    assert br() == '<br>'
    
    para = HTMLQuoter('p', attquote=double)
    assert para('this is great!', {'class':'emphatic'}) == '<p class="emphatic">this is great!</p>'
    
    div = HTMLQuoter('div', attquote=double)
    assert div('something', '.todo') == '<div class="todo">something</div>'

    
if __name__ == '__main__':
    test_run()