from testharness import import_from_parent, test_run

import_from_parent()
from quoter import *

def test_braces():
    assert braces('this') == '{this}'
    assert braces('this', padding=1) == '{ this }'
    assert braces('this', margin=1) == ' {this} '
    assert braces('this', padding=1, margin=1) == ' { this } '

def test_brackets():
    assert brackets('this') == '[this]'
    assert brackets('this', padding=1) == '[ this ]'
    assert brackets('this', margin=1) == ' [this] '
    assert brackets('this', padding=1, margin=1) == ' [ this ] '
    
def test_lambda():
    f = lambda v: ('(', abs(v), ')') if v < 0 else ('', v, '')
    financial = LambdaQuoter(f)
    print financial(-3)
    print financial(45)
    assert financial(-10) == '(10)'
    assert financial(44)  == '44'
    
    password = LambdaQuoter(lambda v: ('', 'x' * len(v), ''))
    assert password('secret!') == 'xxxxxxx'

def test_examples():
    assert single('this') == "'this'"
    assert double('that') == '"that"'
    assert backticks('ls -l') == "`ls -l`"
    assert braces('curlycue') == "{curlycue}"
    
    bars = Quoter('|')
    assert bars('x') == '|x|'
    
    plus = Quoter('+', '')
    assert plus('x') == '+x'
    
    variable = Quoter('${', '}', name='variable')
    assert variable('x') == '${x}'
    assert quote('myvar', style='variable') == '${myvar}'

def test_para():
    para = HTMLQuoter('p')
    print para('this is great!', {'class':'emphatic'})
    print para('this is great!', '.emphatic')
    parae = HTMLQuoter('p.emphatic')
    print parae('this is great!')
    print parae('this is great?', '.question')
    
    br = HTMLQuoter('br', void=True)
    print br()
    
if __name__ == '__main__':
    test_run()