## A list `railroadtracks_import` will be needed for this to run
## That list will contain the following elements:
## counttable_fn: file name for CSV file with counts.
##                The data table will only contain counts, an column names
##                will correspond to sample identifiers
## sampleinfo_fn: file name for CSV file with sample information, with one row per sample
##                The data table will only contain at least the following columns:
##                - sample_id: this must correspond to the column names in the file counttable_fn
##                - group: this will contain group information for 2-sample testing
##                - libsize: library size (FIXME: should this )
## dispersion_fittype: "parametric" or "local" (default: "local")
### FIXME: format for results ? should be common to all differential expression results
### FIXME: method="per-condition" as a parameter
## results_fn: file name for results

require("DESeq")

run <- local({
    ## Return R connection, deciding on whether it is gzip-compressed
    ## according to the file extension
    autoopen <- function(filename, open) {
        if (grepl("\\.gz$", filename)) {
                                        # gzip-compressed file
            conn <- gzfile(filename, open=open)
        } else {
            conn <- file(filename, open=open)
        }
        return(conn)
    }

    load_csv <- function(fn, row_names=NULL) {
        conn <- autoopen(fn, open="r")
        cds <- read.csv(conn, row.names=row_names)
        close(conn)
        return(cds)
    }

    run <- function(railroadtracks_import) {
        p <- railroadtracks_import
        dataf <- load_csv(p$counttable_fn,row_names=1)
        dataf_si <- load_csv(p$sampleinfo_fn, row_names="sample_id")
        cds <- newCountDataSet(dataf, dataf_si$group)
        cds <- estimateSizeFactors( cds )
        cds <- estimateDispersions( cds, fitType=p$dispersion_fittype)
        de <- DESeq::nbinomTest( cds, "A", "B" ) 
        ##topTags(de)
        out_conn <- autoopen(p$diffexp_fn, "w")
        write.csv(de, file=out_conn)
        close(out_conn)
    }
    run
})
