﻿////////////////////////////////////////////
// Project: Flash 10 Coverflow
// Date: 10/3/09
// Author: Stephen Weber
////////////////////////////////////////////
package {
	
	////////////////////////////////////////////
	// IMPORTS
	////////////////////////////////////////////
	import flash.display.Sprite;
	import flash.events.MouseEvent;
	import flash.events.Event;
	import flash.events.IOErrorEvent;
	import flash.display.Loader;
	import flash.net.URLRequest;
	import flash.display.Bitmap;
	import flash.geom.Point;

	//TweenLite - Tweening Engine - SOURCE: http://blog.greensock.com/tweenliteas3/
	import com.greensock.*;
	import com.greensock.easing.*;

	public class CoverflowItem extends Sprite {

		////////////////////////////////////////////
		// VARIABLES
		////////////////////////////////////////////

		private var _data:Object = new Object();

		private var _loader:Loader = new Loader();

		private var _padding:uint;
		
		private var _holder:MovieClip = new MovieClip();
		
		//Reflection Properties
		private var _alpha:Number = 35;
		
		private var _ratio:Number = 50;
		
		private var _distance:Number = 0;
		
		private var _updateTime:Number = -1;
		
		private var _reflectionDropoff:Number = 1;
		
		private var _imageWidth:Number = 148;
		private var _imageHeight:Number = 148;
		
		////////////////////////////////////////////
		// CONSTRUCTOR - INITIAL ACTIONS
		////////////////////////////////////////////
		public function CoverflowItem(__data:Object, width:Number, height:Number, padding:Number):void {
			_data=__data;
			_padding=padding;
			_imageWidth=width;
			_imageHeight=height;
			loading.y = -_imageHeight/2 - loading.height/2;
			addChild(_holder)
			_holder.buttonMode=true;
			_holder.addEventListener(MouseEvent.CLICK, click);
			drawBackground();
		}
		////////////////////////////////////////////
		// GETTERS/SETTERS
		////////////////////////////////////////////
		public function set image(_input:String):void {

			_loader.contentLoaderInfo.addEventListener(Event.COMPLETE, imageComplete);
			_loader.contentLoaderInfo.addEventListener(IOErrorEvent.IO_ERROR, imageIOError);
			_loader.load(new URLRequest(_input));

		}
		////////////////////////////////////////////
		// FUNCTIONS
		////////////////////////////////////////////
		public function setReflection(__alpha:Number, __ratio:Number, __distance:Number, __updateTime:Number, __reflectionDropoff:Number) {
			_alpha = __alpha;
			_ratio = __ratio;
			_distance = __distance;
			_updateTime = __updateTime;
			_reflectionDropoff = __reflectionDropoff;
		}
		private function drawBackground():void {
			_bg.graphics.clear();
			_bg.graphics.beginFill(0xFFFFFF);
			_bg.graphics.drawRect(-Math.floor(_imageWidth/2+_padding), -Math.floor(_imageHeight+_padding), Math.floor(_imageWidth+2*_padding), Math.floor(_imageHeight+2*_padding));
			_bg.graphics.endFill();
		}
		private function imageComplete(e:Event):void {
			_holder.addChild(_loader);
			this.removeChild(loading);
			var factor:Number = Math.min(this._imageWidth/_loader.width,
                         				 this._imageHeight/_loader.height);
            _loader.scaleX = factor;
            _loader.scaleY = factor;
			_loader.x = -_loader.width/2;
			_loader.y = Math.floor(-_loader.height);
			_imageWidth = Math.ceil(_loader.width);
			_imageHeight = Math.ceil(_loader.height);
			if(this._padding > 0) {
				drawBackground();
			} else {
				_bg.graphics.clear();
			}
			var reflection:Reflect=new Reflect({target:this,alpha:_alpha,ratio:_ratio,distance:_distance,updateTime:_updateTime,reflectionDropoff:_reflectionDropoff});
		}
		private function imageIOError(e:IOErrorEvent):void {
			trace("CoverflowItem - Error Loading");
		}
		private function click(e:MouseEvent):void {

			dispatchEvent(new CoverflowItemEvent(CoverflowItemEvent.COVERFLOWITEM_SELECTED, _data));

		}
	}
}