#!/usr/bin/env python
# -*- coding: utf-8  -*-
################################################################################
#
#  Rattail -- Retail Software Framework
#  Copyright © 2010-2012 Lance Edgar
#
#  This file is part of Rattail.
#
#  Rattail is free software: you can redistribute it and/or modify it under the
#  terms of the GNU Affero General Public License as published by the Free
#  Software Foundation, either version 3 of the License, or (at your option)
#  any later version.
#
#  Rattail is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for
#  more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with Rattail.  If not, see <http://www.gnu.org/licenses/>.
#
################################################################################

"""
SMS Database Interface
"""

from locsms.db import Session

from rattail.db.util import engine_from_config


def init(config):
    """
    Initialize the SMS database engine.

    This function creates the database engine defined by configuration, and
    establishes it as the default bind for the ``locsms.db.Session`` class.
    The database configuration should look something like this:

    .. code-block: ini

       [rattail.sw.locsms]
       sqlalchemy.url = mssql://SMS-STORESQL
    """
    config.require(u'rattail.sw.locsms', u'sqlalchemy.url')
    engine = engine_from_config(config.get_dict(u'rattail.sw.locsms'))
    Session.configure(bind=engine)
