#!/usr/bin/env python
# -*- coding: utf-8  -*-
################################################################################
#
#  Rattail -- Retail Software Framework
#  Copyright © 2010-2012 Lance Edgar
#
#  This file is part of Rattail.
#
#  Rattail is free software: you can redistribute it and/or modify it under the
#  terms of the GNU Affero General Public License as published by the Free
#  Software Foundation, either version 3 of the License, or (at your option)
#  any later version.
#
#  Rattail is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for
#  more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with Rattail.  If not, see <http://www.gnu.org/licenses/>.
#
################################################################################

"""
Exceptions
"""

from rattail.exceptions import RattailError


class TransferError(RattailError):
    """
    Base class for all transfer-related errors.
    """


class InvalidTransferFileName(TransferError):
    """
    Raised when a transfer file's name does not match the expected pattern.
    """

    def __init__(self, path):
        self.path = path

    def __str__(self):
        return "Transfer file name does not match expected pattern: {0}".format(self.path)
