# -*- coding: utf-8 -*-
################################################################################
#
#  Rattail -- Retail Software Framework
#  Copyright © 2010-2014 Lance Edgar
#
#  This file is part of Rattail.
#
#  Rattail is free software: you can redistribute it and/or modify it under the
#  terms of the GNU Affero General Public License as published by the Free
#  Software Foundation, either version 3 of the License, or (at your option)
#  any later version.
#
#  Rattail is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for
#  more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with Rattail.  If not, see <http://www.gnu.org/licenses/>.
#
################################################################################

from __future__ import unicode_literals

import os.path
import sys
import re
from setuptools import setup, find_packages


here = os.path.abspath(os.path.dirname(__file__))
execfile(os.path.join(here, 'rattail_locsms', '_version.py'))
README = open(os.path.join(here, 'README.rst')).read()


requires = [
    #
    # Version numbers within comments below have specific meanings.
    # Basically the 'low' value is a "soft low," and 'high' a "soft high."
    # In other words:
    #
    # If either a 'low' or 'high' value exists, the primary point to be
    # made about the value is that it represents the most current (stable)
    # version available for the package (assuming typical public access
    # methods) whenever this project was started and/or documented.
    # Therefore:
    #
    # If a 'low' version is present, you should know that attempts to use
    # versions of the package significantly older than the 'low' version
    # may not yield happy results.  (A "hard" high limit may or may not be
    # indicated by a true version requirement.)
    #
    # Similarly, if a 'high' version is present, and especially if this
    # project has laid dormant for a while, you may need to refactor a bit
    # when attempting to support a more recent version of the package.  (A
    # "hard" low limit should be indicated by a true version requirement
    # when a 'high' version is present.)
    #
    # In any case, developers and other users are encouraged to play
    # outside the lines with regard to these soft limits.  If bugs are
    # encountered then they should be filed as such.
    #
    # package                           # low                   high

    u'Mako',                            # 0.6.2
    u'pyodbc',                          # 3.0.3
    u'pyLOCSMS>=0.1.2',                 #                       0.1.2
    'rattail>=0.3.35',                  #                       0.3.35
    ]


extras = {

    'docs': [
        #
        # package                       # low                   high

        'Sphinx',                       # 1.2.1
        ],

    'tests': [
        #
        # package                       # low                   high

        'coverage',                     # 3.7.1
        'nose',                         # 1.3.0
        ],
    }


extra_kwargs = {}
has_py2exe = False

if sys.platform == 'win32':

    # The following is courtesy of the py2exe wiki, at
    # http://www.py2exe.org/index.cgi/win32com.shell

    # ModuleFinder can't handle runtime changes to __path__, but win32com uses them
    try:
        # py2exe 0.6.4 introduced a replacement modulefinder.
        # This means we have to add package paths there, not to the built-in
        # one.  If this new modulefinder gets integrated into Python, then
        # we might be able to revert this some day.
        # if this doesn't work, try import modulefinder
        try:
            import py2exe.mf as modulefinder
        except ImportError:
            import modulefinder
        import win32com
        for p in win32com.__path__[1:]:
            modulefinder.AddPackagePath('win32com', p)
        for extra in ['win32com.shell']:
            __import__(extra)
            m = sys.modules[extra]
            for p in m.__path__[1:]:
                modulefinder.AddPackagePath(extra, p)
    except ImportError:
        # no build path setup, no worries.
        pass    

    # Folks don't necessarily have py2exe installed.
    try:
        import py2exe
        from py2exe.build_exe import Target
    except ImportError:
        pass
    else:

        has_py2exe = True

        class AdminTarget(Target):

            def __init__(self, **kwargs):
                self.__dict__.update(kwargs)

                self.script = r'rattail_locsms\wx\Admin.py'
                self.icon_resources = [(0, r'rattail_locsms\images\sms-admin.ico')]

                self.name = "SMS Admin"
                self.description = "Administrative Utility for LOC SMS"

                self.copyright = u'© 2010-2012 Lance Edgar'
                self.comments = ("This utility is part of the Rattail software suite.  "
                                 "For more information, visit http://rattailproject.org/.")

                # py2exe (really, MS Windows) doesn't like the format we (usually)
                # use for version strings, so we must morph it to suit.
                m = re.match(r'^(\d+(?:\.\d+)*)', __version__)
                self.version = m.group(1)

                # This one can still be free-form though.
                self.product_version = __version__

        extra_kwargs = {

            'options': {
                'py2exe': {
                    'ignores': [
                        '__pypy__',
                        '_imaging_gif',
                        '_imagingagg',
                        '_scproxy',
                        'babel.messages.extract',
                        'bcrypt',
                        'builtins',
                        'Carbon',
                        'Carbon.Files',
                        'chardet',
                        'cmemcache',
                        'configparser',
                        'Crypto.Cipher',
                        'Crypto.Hash',
                        'cx_Oracle',
                        'DNS',
                        'genshi.template',
                        'html',
                        'http.cookies',
                        'ICCProfile',
                        'jarray',
                        'javax.crypto',
                        'javax.crypto.spec',
                        'memcache',
                        'mx',
                        'nose',
                        'ordereddict',
                        'progressbar',
                        'pycountry',
                        'pycryptopp.cipher',
                        'pygments.formatters.TerminalFormatter',
                        'pygments.lexers.TextLexer',
                        'pyinotify',
                        'pylibmc',
                        'pylons',
                        'pylons.i18n',
                        'routes',
                        'tempita',
                        'turbogears.i18n',
                        'urllib.parse',
                        'urllib.request',
                        'webob',
                        'win32com.gen_py',
                        'zope.deprecation',
                        'zope.deprecation.deprecation',
                        'zope.interface',
                        'zope.interface.interface',
                        'zope.interface.interfaces',
                        'zope.interface.registry',
                        ],
                    'packages': [
                        'edbob',
                        'mako',
                        ],
                    },
                },

            'windows': [AdminTarget()],
            }


setup(
    name = "rattail_locsms",
    version = __version__,
    author = "Lance Edgar",
    author_email = "lance@edbob.org",
    url = "http://rattailproject.org/",
    license = "GNU Affero GPL v3",
    description = "Rattail Software Interfaces for LOC SMS",
    long_description = README,

    classifiers = [
        'Development Status :: 3 - Alpha',
        'Environment :: Console',
        'Environment :: Web Environment',
        'Environment :: Win32 (MS Windows)',
        'Environment :: X11 Applications',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU Affero General Public License v3',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Topic :: Office/Business',
        'Topic :: Software Development :: Libraries :: Python Modules',
        ],

    install_requires = requires,
    extras_require = extras,
    tests_require = ['rattail_locsms[tests]'],
    test_suite = 'nose.collector',

    packages = find_packages(exclude=['tests.*', 'tests']),
    include_package_data = True,
    zip_safe = False,

    entry_points = """

[rattail.commands]
sms-admin = rattail_locsms.commands:AdminCommand
sms-gen-sample = rattail_locsms.commands:GenerateSampleCommand
sms-pull-sample = rattail_locsms.commands:PullSampleCommand

[rattail.sil.column_providers]
locsms = rattail_locsms.sil:provide_columns

""",

    **extra_kwargs
    )


# If we're building with py2exe, we have some extra work to do.
if has_py2exe and 'py2exe' in sys.argv:
    if '-h' not in sys.argv and '--help' not in sys.argv:

        # Unfortunately there is no "conventional" way to ensure certain package
        # data is included in the output ``library.zip`` file.  The following hack
        # is based on code from the "googletransitdatafeed" project, found at:
        # http://code.google.com/p/googletransitdatafeed/source/browse/trunk/python/setup.py

        # Some data files are not copied automatically by py2exe into the
        # library.zip file. This concerns mainly files which are loaded by modules
        # using pkg_resources.
        import zipfile
        # Open the library.zip file for appending additional files.
        zipfile_path = os.path.join('dist', 'library.zip')
        z = zipfile.ZipFile(zipfile_path, 'a')

        # Sometime between pytz-2008a and pytz-2008i common_timezones started to
        # include only names of zones with a corresponding data file in zoneinfo.
        # pytz installs the zoneinfo directory tree in the same directory
        # as the pytz/__init__.py file. These data files are loaded using
        # pkg_resources.resource_stream. py2exe does not copy this to library.zip so
        # resource_stream can't find the files and common_timezones is empty when
        # read in the py2exe executable.
        # This manually copies zoneinfo into the zip. See also
        # http://code.google.com/p/googletransitdatafeed/issues/detail?id=121
        import pytz
        # Make sure the layout of pytz hasn't changed
        assert (pytz.__file__.endswith('__init__.pyc') or
                pytz.__file__.endswith('__init__.py')), pytz.__file__
        zoneinfo_dir = os.path.join(os.path.dirname(pytz.__file__), 'zoneinfo')
        # '..\\Lib\\pytz\\__init__.py' -> '..\\Lib'
        disk_basedir = os.path.dirname(os.path.dirname(pytz.__file__))
        for absdir, directories, filenames in os.walk(zoneinfo_dir):
            assert absdir.startswith(disk_basedir), (absdir, disk_basedir)
            zip_dir = absdir[len(disk_basedir):]
            for f in filenames:
                z.write(os.path.join(absdir, f), os.path.join(zip_dir, f))

        # Finally close the library.zip file.
        z.close()
