# -*- coding: utf-8 -*-
################################################################################
#
#  Rattail -- Retail Software Framework
#  Copyright © 2010-2014 Lance Edgar
#
#  This file is part of Rattail.
#
#  Rattail is free software: you can redistribute it and/or modify it under the
#  terms of the GNU Affero General Public License as published by the Free
#  Software Foundation, either version 3 of the License, or (at your option)
#  any later version.
#
#  Rattail is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for
#  more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with Rattail.  If not, see <http://www.gnu.org/licenses/>.
#
################################################################################

"""
Mail Utilities
"""

from __future__ import unicode_literals

import os
import socket

from rattail.filemon import Action
from rattail.files import creation_time
from rattail.mail import send_email


class EmailImportError(Action):
    """
    Send an email informing someone of an SMS import error.

    This is meant to be used with the file monitor, which would presumably be
    watching an SMS node's "ZE" (import error) folder.
    """

    def __call__(self, path, *args, **kwargs):
        data = {
            'hostname':         socket.gethostname(),
            'abspath':          path,
            'dirname':          os.path.dirname(path),
            'basename':         os.path.basename(path),
            'created':          creation_time(path),
            }
        send_email(self.config, 'locsms_import_error', data)
