#!/usr/bin/env python
# -*- coding: utf-8  -*-
################################################################################
#
#  Rattail -- Retail Software Framework
#  Copyright © 2010-2012 Lance Edgar
#
#  This file is part of Rattail.
#
#  Rattail is free software: you can redistribute it and/or modify it under the
#  terms of the GNU Affero General Public License as published by the Free
#  Software Foundation, either version 3 of the License, or (at your option)
#  any later version.
#
#  Rattail is distributed in the hope that it will be useful, but WITHOUT ANY
#  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
#  FOR A PARTICULAR PURPOSE.  See the GNU Affero General Public License for
#  more details.
#
#  You should have received a copy of the GNU Affero General Public License
#  along with Rattail.  If not, see <http://www.gnu.org/licenses/>.
#
################################################################################

"""
Mail Utilities
"""

import os.path
import socket

from mako.template import Template

import edbob

from rattail.files import resource_path, creation_time
from rattail.mail import sendmail_with_config


def email_import_error(path):
    """
    Send an email informing someone of an SMS import error.

    This function is designed for use with the file monitor, which would
    presumably be watching a SMS node's "ZE" (import error) folder.
    """

    template_path = edbob.config.get(
        'rattail.sw.locsms', 'mail.import_error_template',
        default='rattail_locsms:data/templates/email_import_error.mako')
    template_path = resource_path(template_path)

    path = os.path.abspath(path)
    data = {
        'hostname': socket.gethostname(),
        'abspath': path,
        'dirname': os.path.dirname(path),
        'basename': os.path.basename(path),
        'created': creation_time(path),
        }

    template = Template(filename=template_path)
    sendmail_with_config('locsms_import_error', template.render(**data), content_type='text/html')
