#!/usr/bin/env python
# -*- coding: utf-8 -*-

import distribute_setup
distribute_setup.use_setuptools()

try:
    from setuptools import setup, find_packages
    have_setuptools = True
except ImportError:
    from distutils.core import setup
    def find_packages():
        return [
            'rctl',
        ]
    have_setuptools = False

requires = ['paramiko>=1.7.7.1']

setup(
    author = 'Mark Fink',
    author_email = 'mark@mark-fink.de',
    description = 'Executing task recipes on remote servers',
    url = 'https://github.com/aogaeru/rctl',
    download_url='http://pypi.python.org/pypi/rctl',
    name='rctl',
    version='0.1.1',
    packages = find_packages(),
    license='GNU LESSER GENERAL PUBLIC LICENSE, Version 3',
    long_description=open('README.md').read(),
    scripts=['bin/rctl','bin/password'],
    platforms = 'any',
    classifiers = [
        'License :: OSI Approved :: MIT License',
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators',
        'Development Status :: 3 - Alpha',
        'Programming Language :: Python',
        'Programming Language :: Python :: 2',
        'Operating System :: OS Independent',
        'Topic :: System :: Systems Administration',
        'Natural Language :: English',
    ],
)
