import unittest

from rdflib import *
from rdflib.Graph import Graph
from rdflib.StringInputSource import StringInputSource

class SeqTestCase(unittest.TestCase):
    backend = 'default'
    path = 'store'

    def setUp(self):
        store = self.store = Graph(store=self.backend)
        store.open(self.path)
        store.parse(StringInputSource(s))

    def tearDown(self):
        self.store.close()

    def testSeq(self):
        items = self.store.seq(URIRef("http://example.org/Seq"))
        self.assertEquals(len(items), 6)
        self.assertEquals(items[-1].concrete(), URIRef("http://example.org/six"))
        self.assertEquals(items[2].concrete(), URIRef("http://example.org/three"))
        # just make sure we can serialize
        self.store.serialize()

def test_suite():
    return unittest.makeSuite(SeqTestCase)

if __name__ == '__main__':
    unittest.main(defaultTest='test_suite')

s = """\
<?xml version="1.0" encoding="UTF-8"?>
<rdf:RDF
 xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
 xmlns="http://purl.org/rss/1.0/"
 xmlns:nzgls="http://www.nzgls.govt.nz/standard/"
>
 <rdf:Seq rdf:about="http://example.org/Seq">
   <rdf:li rdf:resource="http://example.org/one" />
   <rdf:li rdf:resource="http://example.org/two" />
   <rdf:li rdf:resource="http://example.org/three" />
   <rdf:li rdf:resource="http://example.org/four" />
   <rdf:li rdf:resource="http://example.org/five_five" />
   <rdf:li rdf:resource="http://example.org/six" />
 </rdf:Seq>
</rdf:RDF>
"""

