from distutils.core import setup, Extension

setup(name='rdrand',
      version='1.0.0',
      description="Python interface to Intel hardware rng",
      long_description= "".join(open('setup.rst').readlines()),
      author="Chris Stillson",
      author_email="stillson@gmail.com",
      url='https://github.com/stillson/rdrand',
      license="New BSD license",
      ext_modules=[Extension('_rdrand', ['rdrand.c'])],
      py_modules = ['rdrand',],
      keywords = ["intel","hardware","random","number","generator","rng"],
      classifiers = ["Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: BSD License",
        "Programming Language :: Python",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 3",
        "Topic :: Security",
        "Topic :: Security :: Cryptography",],
)
