
import unittest

import rsd.rsd


class TestSearch(unittest.TestCase):

    def test_kalign(self):
        in_fasta = '''>E8S7Y8
MNSPLTGTVALVAGATRGAGRQIAVQLGAAGATVYATGRTTRERRSEMDRPETIEETAELVTAAGGTGIAVAVDHLDPEQVRGLVERIDAEQGRL
DVLVNDVWGADPLITWEKPVWEQPLDAGFRTLRLAVDTHIITSHFALPLLIRNPGGLVVEVGDGTKEHNDSEYRLSVFYDLAKVSVNRLGFSQAHELAPHGCTAVALTPG
WLRSEAMLEHYGVTEANWRDAATTEPHFVMSETPAFVGRAVAALAADPDRARWNGQSLDSGGLSQVYGFTDVDGSRPHWARYYEEVVKPGKPADPDGYR
>B1K8E8
MATNLFDLTGKIALVTGASRGIGEEIAKLLAEQGAYVIVSSRKLDDCQAVADAIVAAGGRAEALACHVGRLEDIAATFEHIRGKHGRLDI
LVNNAAANPYFGHILDTDLAAYEKTVDVNIRGYFFMSVEAGKLMKTHGGGAIVNTASVNALQPGDRQGIYSITKAAVVNMTKAFAKECGP
LGIRVNALLPGLTKTKFAGALFADKDIYETWMTKIPLRRHAEPREMAGTVLYLVSDAASYTNGECIVVDGGLTI
'''
        aligned = '''>E8S7Y8
MNS---PLTGTVALVAGATRGAGRQIAVQLGAAGATVYATGRTTRERRSEMDRPETIEET
AELVTAAGGTGIAVAVDHLDPEQVRGLVERIDAEQGRLDVLVNDVWGADPLITWEKPVWE
QPLDAGFRTLRLAVDTHIITSHFALPLLIRNPGGLVVEVGDGTKEHNDSEYRLSV-----
FYDLAKVSVNRLGFSQAHELAPHGCTAVALTPGWLRSE---AMLEHYGVTEANWRDAATT
EPHFVMSETPAFVGRAVAALAADPDRARWNGQSLDSGGLSQVYGFTDVDGSRPHWARYYE
EVVKPGKPADPDGYR
>B1K8E8
MATNLFDLTGKIALVTGASRGIGEEIAKLLAEQGAYVIVSSR----------KLDDCQAV
ADAIVAAGGRAEALACHVGRLEDIAATFEHIRGKHGRLDILVNN--------AAANPYFG
HILDTDLAAYEKTVDVN-IRGYFFMSV---EAGKLMKTHGGGAIVNTASVNALQPGDRQG
IYSITKAAVVNMTKAFAKECGPLGIRVNALLPGLTKTKFAGALFADKDIYET-WMTKIPL
RRH----AEPREMAGTVLYLVSDAASYTNGECIVVDGGLTI-------------------
---------------
'''
        self.assertEqual(aligned, rsd.rsd.alignFastaKalign(in_fasta))
