/*
 * Secret Labs' Regular Expression Engine
 *
 * regular expression matching engine
 *
 * Copyright (c) 1997-2001 by Secret Labs AB.  All rights reserved.
 *
 * NOTE: This file is generated by regex.py.  If you need
 * to change anything in here, edit regex.py and run it.
 *
 * 2010-01-16 mrab Re-written
 */

#define RE_MAGIC 20100116

/* Size of a code word (must be unsigned short or larger, and large enough to
 * hold a Py_UNICODE character).
 */

#if SIZEOF_INT >= 4
#define RE_CODE unsigned int
#else
#define RE_CODE SIZEOF_LONG
#define RE_CODE unsigned long
#endif

#define RE_UNLIMITED (~(RE_CODE)0)

#define RE_OP_FAILURE 0
#define RE_OP_SUCCESS 1
#define RE_OP_ANY 2
#define RE_OP_ANY_ALL 3
#define RE_OP_ANY_ALL_REV 4
#define RE_OP_ANY_REV 5
#define RE_OP_ATOMIC 6
#define RE_OP_BEGIN_GROUP 7
#define RE_OP_BITSET 8
#define RE_OP_BOUNDARY 9
#define RE_OP_BRANCH 10
#define RE_OP_CATEGORY 11
#define RE_OP_CATEGORY_REV 12
#define RE_OP_CHARACTER 13
#define RE_OP_CHARACTER_IGNORE 14
#define RE_OP_CHARACTER_IGNORE_REV 15
#define RE_OP_CHARACTER_REV 16
#define RE_OP_END 17
#define RE_OP_END_GREEDY_REPEAT 18
#define RE_OP_END_GROUP 19
#define RE_OP_END_LAZY_REPEAT 20
#define RE_OP_END_OF_LINE 21
#define RE_OP_END_OF_STRING 22
#define RE_OP_END_OF_STRING_LINE 23
#define RE_OP_GREEDY_REPEAT 24
#define RE_OP_GREEDY_REPEAT_ONE 25
#define RE_OP_GROUP 26
#define RE_OP_GROUP_EXISTS 27
#define RE_OP_LAZY_REPEAT 28
#define RE_OP_LAZY_REPEAT_ONE 29
#define RE_OP_LOOKAROUND 30
#define RE_OP_NEXT_BRANCH 31
#define RE_OP_RANGE 32
#define RE_OP_REF_GROUP 33
#define RE_OP_REF_GROUP_IGNORE 34
#define RE_OP_REF_GROUP_IGNORE_REV 35
#define RE_OP_REF_GROUP_REV 36
#define RE_OP_SEARCH_ANCHOR 37
#define RE_OP_SET 38
#define RE_OP_SET_IGNORE 39
#define RE_OP_SET_IGNORE_REV 40
#define RE_OP_SET_REV 41
#define RE_OP_START_OF_LINE 42
#define RE_OP_START_OF_STRING 43
#define RE_OP_STRING 44
#define RE_OP_STRING_IGNORE 45
#define RE_OP_STRING_IGNORE_REV 46
#define RE_OP_STRING_REV 47

char* re_op_text[] = {
    "RE_OP_FAILURE",
    "RE_OP_SUCCESS",
    "RE_OP_ANY",
    "RE_OP_ANY_ALL",
    "RE_OP_ANY_ALL_REV",
    "RE_OP_ANY_REV",
    "RE_OP_ATOMIC",
    "RE_OP_BEGIN_GROUP",
    "RE_OP_BITSET",
    "RE_OP_BOUNDARY",
    "RE_OP_BRANCH",
    "RE_OP_CATEGORY",
    "RE_OP_CATEGORY_REV",
    "RE_OP_CHARACTER",
    "RE_OP_CHARACTER_IGNORE",
    "RE_OP_CHARACTER_IGNORE_REV",
    "RE_OP_CHARACTER_REV",
    "RE_OP_END",
    "RE_OP_END_GREEDY_REPEAT",
    "RE_OP_END_GROUP",
    "RE_OP_END_LAZY_REPEAT",
    "RE_OP_END_OF_LINE",
    "RE_OP_END_OF_STRING",
    "RE_OP_END_OF_STRING_LINE",
    "RE_OP_GREEDY_REPEAT",
    "RE_OP_GREEDY_REPEAT_ONE",
    "RE_OP_GROUP",
    "RE_OP_GROUP_EXISTS",
    "RE_OP_LAZY_REPEAT",
    "RE_OP_LAZY_REPEAT_ONE",
    "RE_OP_LOOKAROUND",
    "RE_OP_NEXT",
    "RE_OP_RANGE",
    "RE_OP_REF_GROUP",
    "RE_OP_REF_GROUP_IGNORE",
    "RE_OP_REF_GROUP_IGNORE_REV",
    "RE_OP_REF_GROUP_REV",
    "RE_OP_SEARCH_ANCHOR",
    "RE_OP_SET",
    "RE_OP_SET_IGNORE",
    "RE_OP_SET_IGNORE_REV",
    "RE_OP_SET_REV",
    "RE_OP_START_OF_LINE",
    "RE_OP_START_OF_STRING",
    "RE_OP_STRING",
    "RE_OP_STRING_IGNORE",
    "RE_OP_STRING_IGNORE_REV",
    "RE_OP_STRING_REV",
};

/* Character categories. */
#define RE_CAT_CN 0
#define RE_CAT_LU 1
#define RE_CAT_LL 2
#define RE_CAT_LT 3
#define RE_CAT_MN 4
#define RE_CAT_MC 5
#define RE_CAT_ME 6
#define RE_CAT_ND 7
#define RE_CAT_NL 8
#define RE_CAT_NO 9
#define RE_CAT_ZS 10
#define RE_CAT_ZL 11
#define RE_CAT_ZP 12
#define RE_CAT_CC 13
#define RE_CAT_CF 14
#define RE_CAT_CS 15
#define RE_CAT_CO 16
#define RE_CAT_LM 18
#define RE_CAT_LO 19
#define RE_CAT_PC 20
#define RE_CAT_PD 21
#define RE_CAT_PS 22
#define RE_CAT_PE 23
#define RE_CAT_PI 24
#define RE_CAT_PF 25
#define RE_CAT_PO 26
#define RE_CAT_SM 27
#define RE_CAT_SC 28
#define RE_CAT_SK 29
#define RE_CAT_SO 30
#define RE_CAT_C 32
#define RE_CAT_L 33
#define RE_CAT_M 34
#define RE_CAT_N 35
#define RE_CAT_Z 36
#define RE_CAT_P 37
#define RE_CAT_S 38
#define RE_CAT_ALPHA 39
#define RE_CAT_ALNUM 40
#define RE_CAT_ASCII 41
#define RE_CAT_BLANK 42
#define RE_CAT_CNTRL 43
#define RE_CAT_DIGIT 44
#define RE_CAT_GRAPH 45
#define RE_CAT_LINEBREAK 46
#define RE_CAT_LOWER 47
#define RE_CAT_PRINT 48
#define RE_CAT_PUNCT 49
#define RE_CAT_SPACE 50
#define RE_CAT_UPPER 51
#define RE_CAT_WORD 52
#define RE_CAT_XDIGIT 53
#define RE_CAT_BASICLATIN 54
#define RE_CAT_LATIN1SUPPLEMENT 55
#define RE_CAT_LATINEXTENDEDA 56
#define RE_CAT_LATINEXTENDEDB 57
#define RE_CAT_IPAEXTENSIONS 58
#define RE_CAT_SPACINGMODIFIERLETTERS 59
#define RE_CAT_COMBININGDIACRITICALMARKS 60
#define RE_CAT_GREEKANDCOPTIC 61
#define RE_CAT_CYRILLIC 62
#define RE_CAT_CYRILLICSUPPLEMENTARY 63
#define RE_CAT_ARMENIAN 64
#define RE_CAT_HEBREW 65
#define RE_CAT_ARABIC 66
#define RE_CAT_SYRIAC 67
#define RE_CAT_THAANA 68
#define RE_CAT_DEVANAGARI 69
#define RE_CAT_BENGALI 70
#define RE_CAT_GURMUKHI 71
#define RE_CAT_GUJARATI 72
#define RE_CAT_ORIYA 73
#define RE_CAT_TAMIL 74
#define RE_CAT_TELUGU 75
#define RE_CAT_KANNADA 76
#define RE_CAT_MALAYALAM 77
#define RE_CAT_SINHALA 78
#define RE_CAT_THAI 79
#define RE_CAT_LAO 80
#define RE_CAT_TIBETAN 81
#define RE_CAT_MYANMAR 82
#define RE_CAT_GEORGIAN 83
#define RE_CAT_HANGULJAMO 84
#define RE_CAT_ETHIOPIC 85
#define RE_CAT_CHEROKEE 86
#define RE_CAT_UNIFIEDCANADIANABORIGINALSYLLABICS 87
#define RE_CAT_OGHAM 88
#define RE_CAT_RUNIC 89
#define RE_CAT_TAGALOG 90
#define RE_CAT_HANUNOO 91
#define RE_CAT_BUHID 92
#define RE_CAT_TAGBANWA 93
#define RE_CAT_KHMER 94
#define RE_CAT_MONGOLIAN 95
#define RE_CAT_LIMBU 96
#define RE_CAT_TAILE 97
#define RE_CAT_KHMERSYMBOLS 98
#define RE_CAT_PHONETICEXTENSIONS 99
#define RE_CAT_LATINEXTENDEDADDITIONAL 100
#define RE_CAT_GREEKEXTENDED 101
#define RE_CAT_GENERALPUNCTUATION 102
#define RE_CAT_SUPERSCRIPTSANDSUBSCRIPTS 103
#define RE_CAT_CURRENCYSYMBOLS 104
#define RE_CAT_COMBININGDIACRITICALMARKSFORSYMBOLS 105
#define RE_CAT_LETTERLIKESYMBOLS 106
#define RE_CAT_NUMBERFORMS 107
#define RE_CAT_ARROWS 108
#define RE_CAT_MATHEMATICALOPERATORS 109
#define RE_CAT_MISCELLANEOUSTECHNICAL 110
#define RE_CAT_CONTROLPICTURES 111
#define RE_CAT_OPTICALCHARACTERRECOGNITION 112
#define RE_CAT_ENCLOSEDALPHANUMERICS 113
#define RE_CAT_BOXDRAWING 114
#define RE_CAT_BLOCKELEMENTS 115
#define RE_CAT_GEOMETRICSHAPES 116
#define RE_CAT_MISCELLANEOUSSYMBOLS 117
#define RE_CAT_DINGBATS 118
#define RE_CAT_MISCELLANEOUSMATHEMATICALSYMBOLSA 119
#define RE_CAT_SUPPLEMENTALARROWSA 120
#define RE_CAT_BRAILLEPATTERNS 121
#define RE_CAT_SUPPLEMENTALARROWSB 122
#define RE_CAT_MISCELLANEOUSMATHEMATICALSYMBOLSB 123
#define RE_CAT_SUPPLEMENTALMATHEMATICALOPERATORS 124
#define RE_CAT_MISCELLANEOUSSYMBOLSANDARROWS 125
#define RE_CAT_CJKRADICALSSUPPLEMENT 126
#define RE_CAT_KANGXIRADICALS 127
#define RE_CAT_IDEOGRAPHICDESCRIPTIONCHARACTERS 128
#define RE_CAT_CJKSYMBOLSANDPUNCTUATION 129
#define RE_CAT_HIRAGANA 130
#define RE_CAT_KATAKANA 131
#define RE_CAT_BOPOMOFO 132
#define RE_CAT_HANGULCOMPATIBILITYJAMO 133
#define RE_CAT_KANBUN 134
#define RE_CAT_BOPOMOFOEXTENDED 135
#define RE_CAT_KATAKANAPHONETICEXTENSIONS 136
#define RE_CAT_ENCLOSEDCJKLETTERSANDMONTHS 137
#define RE_CAT_CJKCOMPATIBILITY 138
#define RE_CAT_CJKUNIFIEDIDEOGRAPHSEXTENSIONA 139
#define RE_CAT_YIJINGHEXAGRAMSYMBOLS 140
#define RE_CAT_CJKUNIFIEDIDEOGRAPHS 141
#define RE_CAT_YISYLLABLES 142
#define RE_CAT_YIRADICALS 143
#define RE_CAT_HANGULSYLLABLES 144
#define RE_CAT_HIGHSURROGATES 145
#define RE_CAT_HIGHPRIVATEUSESURROGATES 146
#define RE_CAT_LOWSURROGATES 147
#define RE_CAT_PRIVATEUSEAREA 148
#define RE_CAT_CJKCOMPATIBILITYIDEOGRAPHS 149
#define RE_CAT_ALPHABETICPRESENTATIONFORMS 150
#define RE_CAT_ARABICPRESENTATIONFORMSA 151
#define RE_CAT_VARIATIONSELECTORS 152
#define RE_CAT_COMBININGHALFMARKS 153
#define RE_CAT_CJKCOMPATIBILITYFORMS 154
#define RE_CAT_SMALLFORMVARIANTS 155
#define RE_CAT_ARABICPRESENTATIONFORMSB 156
#define RE_CAT_HALFWIDTHANDFULLWIDTHFORMS 157
#define RE_CAT_SPECIALS 158

/* Unicode character properties. */
#define RE_PROP_MASK_C 0x0003E001
#define RE_PROP_MASK_CC 0x00002000
#define RE_PROP_MASK_CF 0x00004000
#define RE_PROP_MASK_CN 0x00020001
#define RE_PROP_MASK_CO 0x00010000
#define RE_PROP_MASK_CS 0x00008000
#define RE_PROP_MASK_L 0x000C000E
#define RE_PROP_MASK_LL 0x00000004
#define RE_PROP_MASK_LM 0x00040000
#define RE_PROP_MASK_LO 0x00080000
#define RE_PROP_MASK_LT 0x00000008
#define RE_PROP_MASK_LU 0x00000002
#define RE_PROP_MASK_M 0x00000070
#define RE_PROP_MASK_MC 0x00000020
#define RE_PROP_MASK_ME 0x00000040
#define RE_PROP_MASK_MN 0x00000010
#define RE_PROP_MASK_N 0x00000380
#define RE_PROP_MASK_ND 0x00000080
#define RE_PROP_MASK_NL 0x00000100
#define RE_PROP_MASK_NO 0x00000200
#define RE_PROP_MASK_P 0x07F00000
#define RE_PROP_MASK_PC 0x00100000
#define RE_PROP_MASK_PD 0x00200000
#define RE_PROP_MASK_PE 0x00800000
#define RE_PROP_MASK_PF 0x02000000
#define RE_PROP_MASK_PI 0x01000000
#define RE_PROP_MASK_PO 0x04000000
#define RE_PROP_MASK_PS 0x00400000
#define RE_PROP_MASK_S 0x78000000
#define RE_PROP_MASK_SC 0x10000000
#define RE_PROP_MASK_SK 0x20000000
#define RE_PROP_MASK_SM 0x08000000
#define RE_PROP_MASK_SO 0x40000000
#define RE_PROP_MASK_Z 0x00001C00
#define RE_PROP_MASK_ZL 0x00000800
#define RE_PROP_MASK_ZP 0x00001000
#define RE_PROP_MASK_ZS 0x00000400

#define RE_PROP_MASK_ALNUM (RE_PROP_MASK_L | RE_PROP_MASK_ND)
#define RE_PROP_MASK_NONGRAPH (RE_PROP_MASK_Z | RE_PROP_MASK_C)
#define RE_PROP_MASK_PUNCT (RE_PROP_MASK_P | RE_PROP_MASK_S)
#define RE_PROP_MASK_SPACE (RE_PROP_MASK_ZL | RE_PROP_MASK_ZP | \
  RE_PROP_MASK_CC | RE_PROP_MASK_CF);
#define RE_PROP_MASK_WORD (RE_PROP_MASK_L | RE_PROP_MASK_M | RE_PROP_MASK_N | \
  RE_PROP_MASK_PC)

#define RE_MIN_SCRIPT 54
#define RE_MAX_SCRIPT 158

typedef struct RE_ScriptRange {
    unsigned int min_char;
    unsigned int max_char;
} RE_ScriptRange;

RE_ScriptRange re_script_ranges[] = {
    {0x0, 0x7F},
    {0x80, 0xFF},
    {0x100, 0x17F},
    {0x180, 0x24F},
    {0x250, 0x2AF},
    {0x2B0, 0x2FF},
    {0x300, 0x36F},
    {0x370, 0x3FF},
    {0x400, 0x4FF},
    {0x500, 0x52F},
    {0x530, 0x58F},
    {0x590, 0x5FF},
    {0x600, 0x6FF},
    {0x700, 0x74F},
    {0x780, 0x7BF},
    {0x900, 0x97F},
    {0x980, 0x9FF},
    {0xA00, 0xA7F},
    {0xA80, 0xAFF},
    {0xB00, 0xB7F},
    {0xB80, 0xBFF},
    {0xC00, 0xC7F},
    {0xC80, 0xCFF},
    {0xD00, 0xD7F},
    {0xD80, 0xDFF},
    {0xE00, 0xE7F},
    {0xE80, 0xEFF},
    {0xF00, 0xFFF},
    {0x1000, 0x109F},
    {0x10A0, 0x10FF},
    {0x1100, 0x11FF},
    {0x1200, 0x137F},
    {0x13A0, 0x13FF},
    {0x1400, 0x167F},
    {0x1680, 0x169F},
    {0x16A0, 0x16FF},
    {0x1700, 0x171F},
    {0x1720, 0x173F},
    {0x1740, 0x175F},
    {0x1760, 0x177F},
    {0x1780, 0x17FF},
    {0x1800, 0x18AF},
    {0x1900, 0x194F},
    {0x1950, 0x197F},
    {0x19E0, 0x19FF},
    {0x1D00, 0x1D7F},
    {0x1E00, 0x1EFF},
    {0x1F00, 0x1FFF},
    {0x2000, 0x206F},
    {0x2070, 0x209F},
    {0x20A0, 0x20CF},
    {0x20D0, 0x20FF},
    {0x2100, 0x214F},
    {0x2150, 0x218F},
    {0x2190, 0x21FF},
    {0x2200, 0x22FF},
    {0x2300, 0x23FF},
    {0x2400, 0x243F},
    {0x2440, 0x245F},
    {0x2460, 0x24FF},
    {0x2500, 0x257F},
    {0x2580, 0x259F},
    {0x25A0, 0x25FF},
    {0x2600, 0x26FF},
    {0x2700, 0x27BF},
    {0x27C0, 0x27EF},
    {0x27F0, 0x27FF},
    {0x2800, 0x28FF},
    {0x2900, 0x297F},
    {0x2980, 0x29FF},
    {0x2A00, 0x2AFF},
    {0x2B00, 0x2BFF},
    {0x2E80, 0x2EFF},
    {0x2F00, 0x2FDF},
    {0x2FF0, 0x2FFF},
    {0x3000, 0x303F},
    {0x3040, 0x309F},
    {0x30A0, 0x30FF},
    {0x3100, 0x312F},
    {0x3130, 0x318F},
    {0x3190, 0x319F},
    {0x31A0, 0x31BF},
    {0x31F0, 0x31FF},
    {0x3200, 0x32FF},
    {0x3300, 0x33FF},
    {0x3400, 0x4DBF},
    {0x4DC0, 0x4DFF},
    {0x4E00, 0x9FFF},
    {0xA000, 0xA48F},
    {0xA490, 0xA4CF},
    {0xAC00, 0xD7AF},
    {0xD800, 0xDB7F},
    {0xDB80, 0xDBFF},
    {0xDC00, 0xDFFF},
    {0xE000, 0xF8FF},
    {0xF900, 0xFAFF},
    {0xFB00, 0xFB4F},
    {0xFB50, 0xFDFF},
    {0xFE00, 0xFE0F},
    {0xFE20, 0xFE2F},
    {0xFE30, 0xFE4F},
    {0xFE50, 0xFE6F},
    {0xFE70, 0xFEFF},
    {0xFF00, 0xFFEF},
    {0xFFF0, 0xFFFF},
};

/* ASCII character categories. */
#define RE_MASK_DIGIT 0x1
#define RE_MASK_LOWER 0x2
#define RE_MASK_PUNCT 0x4
#define RE_MASK_SPACE 0x8
#define RE_MASK_UPPER 0x10
#define RE_MASK_XDIGIT 0x20

/* alpha = upper | lower */
#define RE_MASK_ALPHA (RE_MASK_UPPER | RE_MASK_LOWER)
/* alnum = alpha | digit */
#define RE_MASK_ALNUM (RE_MASK_ALPHA | RE_MASK_DIGIT)

char re_ascii_category[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
    0x21, 0x21, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x00,
};

#define RE_FLAG_ASCII 0x80
#define RE_FLAG_DEBUG 0x200
#define RE_FLAG_DOTALL 0x10
#define RE_FLAG_IGNORECASE 0x2
#define RE_FLAG_LOCALE 0x4
#define RE_FLAG_MULTILINE 0x8
#define RE_FLAG_TEMPLATE 0x1
#define RE_FLAG_UNICODE 0x20
#define RE_FLAG_VERBOSE 0x40
#define RE_FLAG_ZEROWIDTH 0x100
