/*
 * Secret Labs' Regular Expression Engine
 *
 * regular expression matching engine
 *
 * Copyright (c) 1997-2001 by Secret Labs AB.  All rights reserved.
 *
 * NOTE: This file is generated by regex.py.  If you need
 * to change anything in here, edit regex.py and run it.
 *
 * 2010-01-16 mrab Re-written
 */

#define RE_MAGIC 20100116

/* Size of a code word (must be unsigned short or larger, and large enough to
 * hold a Py_UNICODE character).
 */
#if SIZEOF_INT >= 4
#define RE_CODE unsigned int
#else
#define RE_CODE SIZEOF_LONG
#define RE_CODE unsigned long
#endif

/* Unlimited repeat count. */
#define RE_UNLIMITED (~(RE_CODE)0)

/* Operators. */
#define RE_OP_FAILURE 0
#define RE_OP_SUCCESS 1
#define RE_OP_ANY 2
#define RE_OP_ANY_ALL 3
#define RE_OP_ANY_ALL_REV 4
#define RE_OP_ANY_REV 5
#define RE_OP_ATOMIC 6
#define RE_OP_BEGIN_GROUP 7
#define RE_OP_BITSET 8
#define RE_OP_BOUNDARY 9
#define RE_OP_BRANCH 10
#define RE_OP_CATEGORY 11
#define RE_OP_CATEGORY_REV 12
#define RE_OP_CHARACTER 13
#define RE_OP_CHARACTER_IGNORE 14
#define RE_OP_CHARACTER_IGNORE_REV 15
#define RE_OP_CHARACTER_REV 16
#define RE_OP_END 17
#define RE_OP_END_GREEDY_REPEAT 18
#define RE_OP_END_GROUP 19
#define RE_OP_END_LAZY_REPEAT 20
#define RE_OP_END_OF_LINE 21
#define RE_OP_END_OF_STRING 22
#define RE_OP_END_OF_STRING_LINE 23
#define RE_OP_GREEDY_REPEAT 24
#define RE_OP_GREEDY_REPEAT_ONE 25
#define RE_OP_GROUP 26
#define RE_OP_GROUP_EXISTS 27
#define RE_OP_LAZY_REPEAT 28
#define RE_OP_LAZY_REPEAT_ONE 29
#define RE_OP_LOOKAROUND 30
#define RE_OP_NEXT 31
#define RE_OP_RANGE 32
#define RE_OP_REF_GROUP 33
#define RE_OP_REF_GROUP_IGNORE 34
#define RE_OP_REF_GROUP_IGNORE_REV 35
#define RE_OP_REF_GROUP_REV 36
#define RE_OP_SEARCH_ANCHOR 37
#define RE_OP_SET 38
#define RE_OP_SET_IGNORE 39
#define RE_OP_SET_IGNORE_REV 40
#define RE_OP_SET_REV 41
#define RE_OP_START_OF_LINE 42
#define RE_OP_START_OF_STRING 43
#define RE_OP_STRING 44
#define RE_OP_STRING_IGNORE 45
#define RE_OP_STRING_IGNORE_REV 46
#define RE_OP_STRING_REV 47

char* re_op_text[] = {
    "RE_OP_FAILURE",
    "RE_OP_SUCCESS",
    "RE_OP_ANY",
    "RE_OP_ANY_ALL",
    "RE_OP_ANY_ALL_REV",
    "RE_OP_ANY_REV",
    "RE_OP_ATOMIC",
    "RE_OP_BEGIN_GROUP",
    "RE_OP_BITSET",
    "RE_OP_BOUNDARY",
    "RE_OP_BRANCH",
    "RE_OP_CATEGORY",
    "RE_OP_CATEGORY_REV",
    "RE_OP_CHARACTER",
    "RE_OP_CHARACTER_IGNORE",
    "RE_OP_CHARACTER_IGNORE_REV",
    "RE_OP_CHARACTER_REV",
    "RE_OP_END",
    "RE_OP_END_GREEDY_REPEAT",
    "RE_OP_END_GROUP",
    "RE_OP_END_LAZY_REPEAT",
    "RE_OP_END_OF_LINE",
    "RE_OP_END_OF_STRING",
    "RE_OP_END_OF_STRING_LINE",
    "RE_OP_GREEDY_REPEAT",
    "RE_OP_GREEDY_REPEAT_ONE",
    "RE_OP_GROUP",
    "RE_OP_GROUP_EXISTS",
    "RE_OP_LAZY_REPEAT",
    "RE_OP_LAZY_REPEAT_ONE",
    "RE_OP_LOOKAROUND",
    "RE_OP_NEXT",
    "RE_OP_RANGE",
    "RE_OP_REF_GROUP",
    "RE_OP_REF_GROUP_IGNORE",
    "RE_OP_REF_GROUP_IGNORE_REV",
    "RE_OP_REF_GROUP_REV",
    "RE_OP_SEARCH_ANCHOR",
    "RE_OP_SET",
    "RE_OP_SET_IGNORE",
    "RE_OP_SET_IGNORE_REV",
    "RE_OP_SET_REV",
    "RE_OP_START_OF_LINE",
    "RE_OP_START_OF_STRING",
    "RE_OP_STRING",
    "RE_OP_STRING_IGNORE",
    "RE_OP_STRING_IGNORE_REV",
    "RE_OP_STRING_REV",
};

/* Character/codepoint categories. */
#define RE_CAT_CN 0
#define RE_CAT_LU 1
#define RE_CAT_LL 2
#define RE_CAT_LT 3
#define RE_CAT_MN 4
#define RE_CAT_MC 5
#define RE_CAT_ME 6
#define RE_CAT_ND 7
#define RE_CAT_NL 8
#define RE_CAT_NO 9
#define RE_CAT_ZS 10
#define RE_CAT_ZL 11
#define RE_CAT_ZP 12
#define RE_CAT_CC 13
#define RE_CAT_CF 14
#define RE_CAT_CS 15
#define RE_CAT_CO 16
#define RE_CAT_LM 18
#define RE_CAT_LO 19
#define RE_CAT_PC 20
#define RE_CAT_PD 21
#define RE_CAT_PS 22
#define RE_CAT_PE 23
#define RE_CAT_PI 24
#define RE_CAT_PF 25
#define RE_CAT_PO 26
#define RE_CAT_SM 27
#define RE_CAT_SC 28
#define RE_CAT_SK 29
#define RE_CAT_SO 30
#define RE_CAT_L 39
#define RE_CAT_M 40
#define RE_CAT_Z 41
#define RE_CAT_S 42
#define RE_CAT_N 43
#define RE_CAT_P 44
#define RE_CAT_C 45
#define RE_CAT_ALPHA 46
#define RE_CAT_ALNUM 47
#define RE_CAT_ASCII 48
#define RE_CAT_BLANK 49
#define RE_CAT_CNTRL 50
#define RE_CAT_DIGIT 51
#define RE_CAT_GRAPH 52
#define RE_CAT_LINEBREAK 53
#define RE_CAT_LOWER 54
#define RE_CAT_PRINT 55
#define RE_CAT_PUNCT 56
#define RE_CAT_SPACE 57
#define RE_CAT_UPPER 58
#define RE_CAT_WORD 59
#define RE_CAT_XDIGIT 60

/* Unicode character properties. */
#define RE_PROP_MASK_C 0x0003E001
#define RE_PROP_MASK_CC 0x00002000
#define RE_PROP_MASK_CF 0x00004000
#define RE_PROP_MASK_CN 0x00020001
#define RE_PROP_MASK_CO 0x00010000
#define RE_PROP_MASK_CS 0x00008000
#define RE_PROP_MASK_L 0x000C000E
#define RE_PROP_MASK_LL 0x00000004
#define RE_PROP_MASK_LM 0x00040000
#define RE_PROP_MASK_LO 0x00080000
#define RE_PROP_MASK_LT 0x00000008
#define RE_PROP_MASK_LU 0x00000002
#define RE_PROP_MASK_M 0x00000070
#define RE_PROP_MASK_MC 0x00000020
#define RE_PROP_MASK_ME 0x00000040
#define RE_PROP_MASK_MN 0x00000010
#define RE_PROP_MASK_N 0x00000380
#define RE_PROP_MASK_ND 0x00000080
#define RE_PROP_MASK_NL 0x00000100
#define RE_PROP_MASK_NO 0x00000200
#define RE_PROP_MASK_P 0x07F00000
#define RE_PROP_MASK_PC 0x00100000
#define RE_PROP_MASK_PD 0x00200000
#define RE_PROP_MASK_PE 0x00800000
#define RE_PROP_MASK_PF 0x02000000
#define RE_PROP_MASK_PI 0x01000000
#define RE_PROP_MASK_PO 0x04000000
#define RE_PROP_MASK_PS 0x00400000
#define RE_PROP_MASK_S 0x78000000
#define RE_PROP_MASK_SC 0x10000000
#define RE_PROP_MASK_SK 0x20000000
#define RE_PROP_MASK_SM 0x08000000
#define RE_PROP_MASK_SO 0x40000000
#define RE_PROP_MASK_Z 0x00001C00
#define RE_PROP_MASK_ZL 0x00000800
#define RE_PROP_MASK_ZP 0x00001000
#define RE_PROP_MASK_ZS 0x00000400

#define RE_PROP_MASK_ALNUM (RE_PROP_MASK_L | RE_PROP_MASK_ND)
#define RE_PROP_MASK_NONGRAPH (RE_PROP_MASK_Z | RE_PROP_MASK_C)
#define RE_PROP_MASK_PUNCT (RE_PROP_MASK_P | RE_PROP_MASK_S)
#define RE_PROP_MASK_SPACE (RE_PROP_MASK_ZL | RE_PROP_MASK_ZP | \
  RE_PROP_MASK_CC | RE_PROP_MASK_CF)
#define RE_PROP_MASK_WORD (RE_PROP_MASK_L | RE_PROP_MASK_M | RE_PROP_MASK_N | \
  RE_PROP_MASK_PC)

/* Block ranges. */
#define RE_MIN_BLOCK 61
#define RE_MAX_BLOCK 257

typedef struct RE_BlockRange {
    unsigned int min_char;
    unsigned int max_char;
} RE_BlockRange;

RE_BlockRange re_block_ranges[] = {
    {0x0, 0x7F},
    {0x80, 0xFF},
    {0x100, 0x17F},
    {0x180, 0x24F},
    {0x250, 0x2AF},
    {0x2B0, 0x2FF},
    {0x300, 0x36F},
    {0x370, 0x3FF},
    {0x400, 0x4FF},
    {0x500, 0x52F},
    {0x530, 0x58F},
    {0x590, 0x5FF},
    {0x600, 0x6FF},
    {0x700, 0x74F},
    {0x750, 0x77F},
    {0x780, 0x7BF},
    {0x7C0, 0x7FF},
    {0x800, 0x83F},
    {0x900, 0x97F},
    {0x980, 0x9FF},
    {0xA00, 0xA7F},
    {0xA80, 0xAFF},
    {0xB00, 0xB7F},
    {0xB80, 0xBFF},
    {0xC00, 0xC7F},
    {0xC80, 0xCFF},
    {0xD00, 0xD7F},
    {0xD80, 0xDFF},
    {0xE00, 0xE7F},
    {0xE80, 0xEFF},
    {0xF00, 0xFFF},
    {0x1000, 0x109F},
    {0x10A0, 0x10FF},
    {0x1100, 0x11FF},
    {0x1200, 0x137F},
    {0x1380, 0x139F},
    {0x13A0, 0x13FF},
    {0x1400, 0x167F},
    {0x1680, 0x169F},
    {0x16A0, 0x16FF},
    {0x1700, 0x171F},
    {0x1720, 0x173F},
    {0x1740, 0x175F},
    {0x1760, 0x177F},
    {0x1780, 0x17FF},
    {0x1800, 0x18AF},
    {0x18B0, 0x18FF},
    {0x1900, 0x194F},
    {0x1950, 0x197F},
    {0x1980, 0x19DF},
    {0x19E0, 0x19FF},
    {0x1A00, 0x1A1F},
    {0x1A20, 0x1AAF},
    {0x1B00, 0x1B7F},
    {0x1B80, 0x1BBF},
    {0x1C00, 0x1C4F},
    {0x1C50, 0x1C7F},
    {0x1CD0, 0x1CFF},
    {0x1D00, 0x1D7F},
    {0x1D80, 0x1DBF},
    {0x1DC0, 0x1DFF},
    {0x1E00, 0x1EFF},
    {0x1F00, 0x1FFF},
    {0x2000, 0x206F},
    {0x2070, 0x209F},
    {0x20A0, 0x20CF},
    {0x20D0, 0x20FF},
    {0x2100, 0x214F},
    {0x2150, 0x218F},
    {0x2190, 0x21FF},
    {0x2200, 0x22FF},
    {0x2300, 0x23FF},
    {0x2400, 0x243F},
    {0x2440, 0x245F},
    {0x2460, 0x24FF},
    {0x2500, 0x257F},
    {0x2580, 0x259F},
    {0x25A0, 0x25FF},
    {0x2600, 0x26FF},
    {0x2700, 0x27BF},
    {0x27C0, 0x27EF},
    {0x27F0, 0x27FF},
    {0x2800, 0x28FF},
    {0x2900, 0x297F},
    {0x2980, 0x29FF},
    {0x2A00, 0x2AFF},
    {0x2B00, 0x2BFF},
    {0x2C00, 0x2C5F},
    {0x2C60, 0x2C7F},
    {0x2C80, 0x2CFF},
    {0x2D00, 0x2D2F},
    {0x2D30, 0x2D7F},
    {0x2D80, 0x2DDF},
    {0x2DE0, 0x2DFF},
    {0x2E00, 0x2E7F},
    {0x2E80, 0x2EFF},
    {0x2F00, 0x2FDF},
    {0x2FF0, 0x2FFF},
    {0x3000, 0x303F},
    {0x3040, 0x309F},
    {0x30A0, 0x30FF},
    {0x3100, 0x312F},
    {0x3130, 0x318F},
    {0x3190, 0x319F},
    {0x31A0, 0x31BF},
    {0x31C0, 0x31EF},
    {0x31F0, 0x31FF},
    {0x3200, 0x32FF},
    {0x3300, 0x33FF},
    {0x3400, 0x4DBF},
    {0x4DC0, 0x4DFF},
    {0x4E00, 0x9FFF},
    {0xA000, 0xA48F},
    {0xA490, 0xA4CF},
    {0xA4D0, 0xA4FF},
    {0xA500, 0xA63F},
    {0xA640, 0xA69F},
    {0xA6A0, 0xA6FF},
    {0xA700, 0xA71F},
    {0xA720, 0xA7FF},
    {0xA800, 0xA82F},
    {0xA830, 0xA83F},
    {0xA840, 0xA87F},
    {0xA880, 0xA8DF},
    {0xA8E0, 0xA8FF},
    {0xA900, 0xA92F},
    {0xA930, 0xA95F},
    {0xA960, 0xA97F},
    {0xA980, 0xA9DF},
    {0xAA00, 0xAA5F},
    {0xAA60, 0xAA7F},
    {0xAA80, 0xAADF},
    {0xABC0, 0xABFF},
    {0xAC00, 0xD7AF},
    {0xD7B0, 0xD7FF},
    {0xD800, 0xDB7F},
    {0xDB80, 0xDBFF},
    {0xDC00, 0xDFFF},
    {0xE000, 0xF8FF},
    {0xF900, 0xFAFF},
    {0xFB00, 0xFB4F},
    {0xFB50, 0xFDFF},
    {0xFE00, 0xFE0F},
    {0xFE10, 0xFE1F},
    {0xFE20, 0xFE2F},
    {0xFE30, 0xFE4F},
    {0xFE50, 0xFE6F},
    {0xFE70, 0xFEFF},
    {0xFF00, 0xFFEF},
    {0xFFF0, 0xFFFF},
    {0x10000, 0x1007F},
    {0x10080, 0x100FF},
    {0x10100, 0x1013F},
    {0x10140, 0x1018F},
    {0x10190, 0x101CF},
    {0x101D0, 0x101FF},
    {0x10280, 0x1029F},
    {0x102A0, 0x102DF},
    {0x10300, 0x1032F},
    {0x10330, 0x1034F},
    {0x10380, 0x1039F},
    {0x103A0, 0x103DF},
    {0x10400, 0x1044F},
    {0x10450, 0x1047F},
    {0x10480, 0x104AF},
    {0x10800, 0x1083F},
    {0x10840, 0x1085F},
    {0x10900, 0x1091F},
    {0x10920, 0x1093F},
    {0x10A00, 0x10A5F},
    {0x10A60, 0x10A7F},
    {0x10B00, 0x10B3F},
    {0x10B40, 0x10B5F},
    {0x10B60, 0x10B7F},
    {0x10C00, 0x10C4F},
    {0x10E60, 0x10E7F},
    {0x11080, 0x110CF},
    {0x12000, 0x123FF},
    {0x12400, 0x1247F},
    {0x13000, 0x1342F},
    {0x1D000, 0x1D0FF},
    {0x1D100, 0x1D1FF},
    {0x1D200, 0x1D24F},
    {0x1D300, 0x1D35F},
    {0x1D360, 0x1D37F},
    {0x1D400, 0x1D7FF},
    {0x1F000, 0x1F02F},
    {0x1F030, 0x1F09F},
    {0x1F100, 0x1F1FF},
    {0x1F200, 0x1F2FF},
    {0x20000, 0x2A6DF},
    {0x2A700, 0x2B73F},
    {0x2F800, 0x2FA1F},
    {0xE0000, 0xE007F},
    {0xE0100, 0xE01EF},
    {0xF0000, 0xFFFFF},
    {0x100000, 0x10FFFF},
};

/* Script ranges. */
#define RE_MIN_SCRIPT 258
#define RE_MAX_SCRIPT 349

typedef struct RE_ScriptRange {
    unsigned int min_char;
    unsigned int max_char;
    unsigned int script;
} RE_ScriptRange;

RE_ScriptRange re_script_ranges[] = {
    {0x0, 0x40, 258},
    {0x41, 0x5A, 259},
    {0x5B, 0x60, 258},
    {0x61, 0x7A, 259},
    {0x7B, 0xA9, 258},
    {0xAA, 0xAA, 259},
    {0xAB, 0xB9, 258},
    {0xBA, 0xBA, 259},
    {0xBB, 0xBF, 258},
    {0xC0, 0xD6, 259},
    {0xD7, 0xD7, 258},
    {0xD8, 0xF6, 259},
    {0xF7, 0xF7, 258},
    {0xF8, 0x2B8, 259},
    {0x2B9, 0x2DF, 258},
    {0x2E0, 0x2E4, 259},
    {0x2E5, 0x2FF, 258},
    {0x300, 0x36F, 260},
    {0x370, 0x373, 261},
    {0x374, 0x374, 258},
    {0x375, 0x377, 261},
    {0x37A, 0x37D, 261},
    {0x37E, 0x37E, 258},
    {0x384, 0x384, 261},
    {0x385, 0x385, 258},
    {0x386, 0x386, 261},
    {0x387, 0x387, 258},
    {0x388, 0x38A, 261},
    {0x38C, 0x38C, 261},
    {0x38E, 0x3A1, 261},
    {0x3A3, 0x3E1, 261},
    {0x3E2, 0x3EF, 262},
    {0x3F0, 0x3FF, 261},
    {0x400, 0x484, 263},
    {0x485, 0x486, 260},
    {0x487, 0x525, 263},
    {0x531, 0x556, 264},
    {0x559, 0x55F, 264},
    {0x561, 0x587, 264},
    {0x589, 0x589, 258},
    {0x58A, 0x58A, 264},
    {0x591, 0x5C7, 265},
    {0x5D0, 0x5EA, 265},
    {0x5F0, 0x5F4, 265},
    {0x600, 0x603, 258},
    {0x606, 0x60B, 266},
    {0x60C, 0x60C, 258},
    {0x60D, 0x61A, 266},
    {0x61B, 0x61B, 258},
    {0x61E, 0x61E, 266},
    {0x61F, 0x61F, 258},
    {0x621, 0x63F, 266},
    {0x640, 0x640, 258},
    {0x641, 0x64A, 266},
    {0x64B, 0x655, 260},
    {0x656, 0x65E, 266},
    {0x660, 0x669, 258},
    {0x66A, 0x66F, 266},
    {0x670, 0x670, 260},
    {0x671, 0x6DC, 266},
    {0x6DD, 0x6DD, 258},
    {0x6DE, 0x6FF, 266},
    {0x700, 0x70D, 267},
    {0x70F, 0x74A, 267},
    {0x74D, 0x74F, 267},
    {0x750, 0x77F, 266},
    {0x780, 0x7B1, 268},
    {0x7C0, 0x7FA, 269},
    {0x800, 0x82D, 270},
    {0x830, 0x83E, 270},
    {0x900, 0x939, 271},
    {0x93C, 0x94E, 271},
    {0x950, 0x950, 271},
    {0x951, 0x952, 260},
    {0x953, 0x955, 271},
    {0x958, 0x963, 271},
    {0x964, 0x965, 258},
    {0x966, 0x96F, 271},
    {0x970, 0x970, 258},
    {0x971, 0x972, 271},
    {0x979, 0x97F, 271},
    {0x981, 0x983, 272},
    {0x985, 0x98C, 272},
    {0x98F, 0x990, 272},
    {0x993, 0x9A8, 272},
    {0x9AA, 0x9B0, 272},
    {0x9B2, 0x9B2, 272},
    {0x9B6, 0x9B9, 272},
    {0x9BC, 0x9C4, 272},
    {0x9C7, 0x9C8, 272},
    {0x9CB, 0x9CE, 272},
    {0x9D7, 0x9D7, 272},
    {0x9DC, 0x9DD, 272},
    {0x9DF, 0x9E3, 272},
    {0x9E6, 0x9FB, 272},
    {0xA01, 0xA03, 273},
    {0xA05, 0xA0A, 273},
    {0xA0F, 0xA10, 273},
    {0xA13, 0xA28, 273},
    {0xA2A, 0xA30, 273},
    {0xA32, 0xA33, 273},
    {0xA35, 0xA36, 273},
    {0xA38, 0xA39, 273},
    {0xA3C, 0xA3C, 273},
    {0xA3E, 0xA42, 273},
    {0xA47, 0xA48, 273},
    {0xA4B, 0xA4D, 273},
    {0xA51, 0xA51, 273},
    {0xA59, 0xA5C, 273},
    {0xA5E, 0xA5E, 273},
    {0xA66, 0xA75, 273},
    {0xA81, 0xA83, 274},
    {0xA85, 0xA8D, 274},
    {0xA8F, 0xA91, 274},
    {0xA93, 0xAA8, 274},
    {0xAAA, 0xAB0, 274},
    {0xAB2, 0xAB3, 274},
    {0xAB5, 0xAB9, 274},
    {0xABC, 0xAC5, 274},
    {0xAC7, 0xAC9, 274},
    {0xACB, 0xACD, 274},
    {0xAD0, 0xAD0, 274},
    {0xAE0, 0xAE3, 274},
    {0xAE6, 0xAEF, 274},
    {0xAF1, 0xAF1, 274},
    {0xB01, 0xB03, 275},
    {0xB05, 0xB0C, 275},
    {0xB0F, 0xB10, 275},
    {0xB13, 0xB28, 275},
    {0xB2A, 0xB30, 275},
    {0xB32, 0xB33, 275},
    {0xB35, 0xB39, 275},
    {0xB3C, 0xB44, 275},
    {0xB47, 0xB48, 275},
    {0xB4B, 0xB4D, 275},
    {0xB56, 0xB57, 275},
    {0xB5C, 0xB5D, 275},
    {0xB5F, 0xB63, 275},
    {0xB66, 0xB71, 275},
    {0xB82, 0xB83, 276},
    {0xB85, 0xB8A, 276},
    {0xB8E, 0xB90, 276},
    {0xB92, 0xB95, 276},
    {0xB99, 0xB9A, 276},
    {0xB9C, 0xB9C, 276},
    {0xB9E, 0xB9F, 276},
    {0xBA3, 0xBA4, 276},
    {0xBA8, 0xBAA, 276},
    {0xBAE, 0xBB9, 276},
    {0xBBE, 0xBC2, 276},
    {0xBC6, 0xBC8, 276},
    {0xBCA, 0xBCD, 276},
    {0xBD0, 0xBD0, 276},
    {0xBD7, 0xBD7, 276},
    {0xBE6, 0xBFA, 276},
    {0xC01, 0xC03, 277},
    {0xC05, 0xC0C, 277},
    {0xC0E, 0xC10, 277},
    {0xC12, 0xC28, 277},
    {0xC2A, 0xC33, 277},
    {0xC35, 0xC39, 277},
    {0xC3D, 0xC44, 277},
    {0xC46, 0xC48, 277},
    {0xC4A, 0xC4D, 277},
    {0xC55, 0xC56, 277},
    {0xC58, 0xC59, 277},
    {0xC60, 0xC63, 277},
    {0xC66, 0xC6F, 277},
    {0xC78, 0xC7F, 277},
    {0xC82, 0xC83, 278},
    {0xC85, 0xC8C, 278},
    {0xC8E, 0xC90, 278},
    {0xC92, 0xCA8, 278},
    {0xCAA, 0xCB3, 278},
    {0xCB5, 0xCB9, 278},
    {0xCBC, 0xCC4, 278},
    {0xCC6, 0xCC8, 278},
    {0xCCA, 0xCCD, 278},
    {0xCD5, 0xCD6, 278},
    {0xCDE, 0xCDE, 278},
    {0xCE0, 0xCE3, 278},
    {0xCE6, 0xCEF, 278},
    {0xCF1, 0xCF2, 258},
    {0xD02, 0xD03, 279},
    {0xD05, 0xD0C, 279},
    {0xD0E, 0xD10, 279},
    {0xD12, 0xD28, 279},
    {0xD2A, 0xD39, 279},
    {0xD3D, 0xD44, 279},
    {0xD46, 0xD48, 279},
    {0xD4A, 0xD4D, 279},
    {0xD57, 0xD57, 279},
    {0xD60, 0xD63, 279},
    {0xD66, 0xD75, 279},
    {0xD79, 0xD7F, 279},
    {0xD82, 0xD83, 280},
    {0xD85, 0xD96, 280},
    {0xD9A, 0xDB1, 280},
    {0xDB3, 0xDBB, 280},
    {0xDBD, 0xDBD, 280},
    {0xDC0, 0xDC6, 280},
    {0xDCA, 0xDCA, 280},
    {0xDCF, 0xDD4, 280},
    {0xDD6, 0xDD6, 280},
    {0xDD8, 0xDDF, 280},
    {0xDF2, 0xDF4, 280},
    {0xE01, 0xE3A, 281},
    {0xE3F, 0xE3F, 258},
    {0xE40, 0xE5B, 281},
    {0xE81, 0xE82, 282},
    {0xE84, 0xE84, 282},
    {0xE87, 0xE88, 282},
    {0xE8A, 0xE8A, 282},
    {0xE8D, 0xE8D, 282},
    {0xE94, 0xE97, 282},
    {0xE99, 0xE9F, 282},
    {0xEA1, 0xEA3, 282},
    {0xEA5, 0xEA5, 282},
    {0xEA7, 0xEA7, 282},
    {0xEAA, 0xEAB, 282},
    {0xEAD, 0xEB9, 282},
    {0xEBB, 0xEBD, 282},
    {0xEC0, 0xEC4, 282},
    {0xEC6, 0xEC6, 282},
    {0xEC8, 0xECD, 282},
    {0xED0, 0xED9, 282},
    {0xEDC, 0xEDD, 282},
    {0xF00, 0xF47, 283},
    {0xF49, 0xF6C, 283},
    {0xF71, 0xF8B, 283},
    {0xF90, 0xF97, 283},
    {0xF99, 0xFBC, 283},
    {0xFBE, 0xFCC, 283},
    {0xFCE, 0xFD4, 283},
    {0xFD5, 0xFD8, 258},
    {0x1000, 0x109F, 284},
    {0x10A0, 0x10C5, 285},
    {0x10D0, 0x10FA, 285},
    {0x10FB, 0x10FB, 258},
    {0x10FC, 0x10FC, 285},
    {0x1100, 0x11FF, 286},
    {0x1200, 0x1248, 287},
    {0x124A, 0x124D, 287},
    {0x1250, 0x1256, 287},
    {0x1258, 0x1258, 287},
    {0x125A, 0x125D, 287},
    {0x1260, 0x1288, 287},
    {0x128A, 0x128D, 287},
    {0x1290, 0x12B0, 287},
    {0x12B2, 0x12B5, 287},
    {0x12B8, 0x12BE, 287},
    {0x12C0, 0x12C0, 287},
    {0x12C2, 0x12C5, 287},
    {0x12C8, 0x12D6, 287},
    {0x12D8, 0x1310, 287},
    {0x1312, 0x1315, 287},
    {0x1318, 0x135A, 287},
    {0x135F, 0x137C, 287},
    {0x1380, 0x1399, 287},
    {0x13A0, 0x13F4, 288},
    {0x1400, 0x167F, 289},
    {0x1680, 0x169C, 290},
    {0x16A0, 0x16EA, 291},
    {0x16EB, 0x16ED, 258},
    {0x16EE, 0x16F0, 291},
    {0x1700, 0x170C, 292},
    {0x170E, 0x1714, 292},
    {0x1720, 0x1734, 293},
    {0x1735, 0x1736, 258},
    {0x1740, 0x1753, 294},
    {0x1760, 0x176C, 295},
    {0x176E, 0x1770, 295},
    {0x1772, 0x1773, 295},
    {0x1780, 0x17DD, 296},
    {0x17E0, 0x17E9, 296},
    {0x17F0, 0x17F9, 296},
    {0x1800, 0x1801, 297},
    {0x1802, 0x1803, 258},
    {0x1804, 0x1804, 297},
    {0x1805, 0x1805, 258},
    {0x1806, 0x180E, 297},
    {0x1810, 0x1819, 297},
    {0x1820, 0x1877, 297},
    {0x1880, 0x18AA, 297},
    {0x18B0, 0x18F5, 289},
    {0x1900, 0x191C, 298},
    {0x1920, 0x192B, 298},
    {0x1930, 0x193B, 298},
    {0x1940, 0x1940, 298},
    {0x1944, 0x194F, 298},
    {0x1950, 0x196D, 299},
    {0x1970, 0x1974, 299},
    {0x1980, 0x19AB, 300},
    {0x19B0, 0x19C9, 300},
    {0x19D0, 0x19DA, 300},
    {0x19DE, 0x19DF, 300},
    {0x19E0, 0x19FF, 296},
    {0x1A00, 0x1A1B, 301},
    {0x1A1E, 0x1A1F, 301},
    {0x1A20, 0x1A5E, 302},
    {0x1A60, 0x1A7C, 302},
    {0x1A7F, 0x1A89, 302},
    {0x1A90, 0x1A99, 302},
    {0x1AA0, 0x1AAD, 302},
    {0x1B00, 0x1B4B, 303},
    {0x1B50, 0x1B7C, 303},
    {0x1B80, 0x1BAA, 304},
    {0x1BAE, 0x1BB9, 304},
    {0x1C00, 0x1C37, 305},
    {0x1C3B, 0x1C49, 305},
    {0x1C4D, 0x1C4F, 305},
    {0x1C50, 0x1C7F, 306},
    {0x1CD0, 0x1CD2, 260},
    {0x1CD3, 0x1CD3, 258},
    {0x1CD4, 0x1CE0, 260},
    {0x1CE1, 0x1CE1, 258},
    {0x1CE2, 0x1CE8, 260},
    {0x1CE9, 0x1CEC, 258},
    {0x1CED, 0x1CED, 260},
    {0x1CEE, 0x1CF2, 258},
    {0x1D00, 0x1D25, 259},
    {0x1D26, 0x1D2A, 261},
    {0x1D2B, 0x1D2B, 263},
    {0x1D2C, 0x1D5C, 259},
    {0x1D5D, 0x1D61, 261},
    {0x1D62, 0x1D65, 259},
    {0x1D66, 0x1D6A, 261},
    {0x1D6B, 0x1D77, 259},
    {0x1D78, 0x1D78, 263},
    {0x1D79, 0x1DBE, 259},
    {0x1DBF, 0x1DBF, 261},
    {0x1DC0, 0x1DE6, 260},
    {0x1DFD, 0x1DFF, 260},
    {0x1E00, 0x1EFF, 259},
    {0x1F00, 0x1F15, 261},
    {0x1F18, 0x1F1D, 261},
    {0x1F20, 0x1F45, 261},
    {0x1F48, 0x1F4D, 261},
    {0x1F50, 0x1F57, 261},
    {0x1F59, 0x1F59, 261},
    {0x1F5B, 0x1F5B, 261},
    {0x1F5D, 0x1F5D, 261},
    {0x1F5F, 0x1F7D, 261},
    {0x1F80, 0x1FB4, 261},
    {0x1FB6, 0x1FC4, 261},
    {0x1FC6, 0x1FD3, 261},
    {0x1FD6, 0x1FDB, 261},
    {0x1FDD, 0x1FEF, 261},
    {0x1FF2, 0x1FF4, 261},
    {0x1FF6, 0x1FFE, 261},
    {0x2000, 0x200B, 258},
    {0x200C, 0x200D, 260},
    {0x200E, 0x2064, 258},
    {0x206A, 0x2070, 258},
    {0x2071, 0x2071, 259},
    {0x2074, 0x207E, 258},
    {0x207F, 0x207F, 259},
    {0x2080, 0x208E, 258},
    {0x2090, 0x2094, 259},
    {0x20A0, 0x20B8, 258},
    {0x20D0, 0x20F0, 260},
    {0x2100, 0x2125, 258},
    {0x2126, 0x2126, 261},
    {0x2127, 0x2129, 258},
    {0x212A, 0x212B, 259},
    {0x212C, 0x2131, 258},
    {0x2132, 0x2132, 259},
    {0x2133, 0x214D, 258},
    {0x214E, 0x214E, 259},
    {0x214F, 0x215F, 258},
    {0x2160, 0x2188, 259},
    {0x2189, 0x2189, 258},
    {0x2190, 0x23E8, 258},
    {0x2400, 0x2426, 258},
    {0x2440, 0x244A, 258},
    {0x2460, 0x26CD, 258},
    {0x26CF, 0x26E1, 258},
    {0x26E3, 0x26E3, 258},
    {0x26E8, 0x26FF, 258},
    {0x2701, 0x2704, 258},
    {0x2706, 0x2709, 258},
    {0x270C, 0x2727, 258},
    {0x2729, 0x274B, 258},
    {0x274D, 0x274D, 258},
    {0x274F, 0x2752, 258},
    {0x2756, 0x275E, 258},
    {0x2761, 0x2794, 258},
    {0x2798, 0x27AF, 258},
    {0x27B1, 0x27BE, 258},
    {0x27C0, 0x27CA, 258},
    {0x27CC, 0x27CC, 258},
    {0x27D0, 0x27FF, 258},
    {0x2800, 0x28FF, 307},
    {0x2900, 0x2B4C, 258},
    {0x2B50, 0x2B59, 258},
    {0x2C00, 0x2C2E, 308},
    {0x2C30, 0x2C5E, 308},
    {0x2C60, 0x2C7F, 259},
    {0x2C80, 0x2CF1, 262},
    {0x2CF9, 0x2CFF, 262},
    {0x2D00, 0x2D25, 285},
    {0x2D30, 0x2D65, 309},
    {0x2D6F, 0x2D6F, 309},
    {0x2D80, 0x2D96, 287},
    {0x2DA0, 0x2DA6, 287},
    {0x2DA8, 0x2DAE, 287},
    {0x2DB0, 0x2DB6, 287},
    {0x2DB8, 0x2DBE, 287},
    {0x2DC0, 0x2DC6, 287},
    {0x2DC8, 0x2DCE, 287},
    {0x2DD0, 0x2DD6, 287},
    {0x2DD8, 0x2DDE, 287},
    {0x2DE0, 0x2DFF, 263},
    {0x2E00, 0x2E31, 258},
    {0x2E80, 0x2E99, 310},
    {0x2E9B, 0x2EF3, 310},
    {0x2F00, 0x2FD5, 310},
    {0x2FF0, 0x2FFB, 258},
    {0x3000, 0x3004, 258},
    {0x3005, 0x3005, 310},
    {0x3006, 0x3006, 258},
    {0x3007, 0x3007, 310},
    {0x3008, 0x3020, 258},
    {0x3021, 0x3029, 310},
    {0x302A, 0x302F, 260},
    {0x3030, 0x3037, 258},
    {0x3038, 0x303B, 310},
    {0x303C, 0x303F, 258},
    {0x3041, 0x3096, 311},
    {0x3099, 0x309A, 260},
    {0x309B, 0x309C, 258},
    {0x309D, 0x309F, 311},
    {0x30A0, 0x30A0, 258},
    {0x30A1, 0x30FA, 312},
    {0x30FB, 0x30FC, 258},
    {0x30FD, 0x30FF, 312},
    {0x3105, 0x312D, 313},
    {0x3131, 0x318E, 286},
    {0x3190, 0x319F, 258},
    {0x31A0, 0x31B7, 313},
    {0x31C0, 0x31E3, 258},
    {0x31F0, 0x31FF, 312},
    {0x3200, 0x321E, 286},
    {0x3220, 0x325F, 258},
    {0x3260, 0x327E, 286},
    {0x327F, 0x32CF, 258},
    {0x32D0, 0x32FE, 312},
    {0x3300, 0x3357, 312},
    {0x3358, 0x33FF, 258},
    {0x3400, 0x4DB5, 310},
    {0x4DC0, 0x4DFF, 258},
    {0x4E00, 0x9FCB, 310},
    {0xA000, 0xA48C, 314},
    {0xA490, 0xA4C6, 314},
    {0xA4D0, 0xA4FF, 315},
    {0xA500, 0xA62B, 316},
    {0xA640, 0xA65F, 263},
    {0xA662, 0xA673, 263},
    {0xA67C, 0xA697, 263},
    {0xA6A0, 0xA6F7, 317},
    {0xA700, 0xA721, 258},
    {0xA722, 0xA787, 259},
    {0xA788, 0xA78A, 258},
    {0xA78B, 0xA78C, 259},
    {0xA7FB, 0xA7FF, 259},
    {0xA800, 0xA82B, 318},
    {0xA830, 0xA839, 258},
    {0xA840, 0xA877, 319},
    {0xA880, 0xA8C4, 320},
    {0xA8CE, 0xA8D9, 320},
    {0xA8E0, 0xA8FB, 271},
    {0xA900, 0xA92F, 321},
    {0xA930, 0xA953, 322},
    {0xA95F, 0xA95F, 322},
    {0xA960, 0xA97C, 286},
    {0xA980, 0xA9CD, 323},
    {0xA9CF, 0xA9D9, 323},
    {0xA9DE, 0xA9DF, 323},
    {0xAA00, 0xAA36, 324},
    {0xAA40, 0xAA4D, 324},
    {0xAA50, 0xAA59, 324},
    {0xAA5C, 0xAA5F, 324},
    {0xAA60, 0xAA7B, 284},
    {0xAA80, 0xAAC2, 325},
    {0xAADB, 0xAADF, 325},
    {0xABC0, 0xABED, 326},
    {0xABF0, 0xABF9, 326},
    {0xAC00, 0xD7A3, 286},
    {0xD7B0, 0xD7C6, 286},
    {0xD7CB, 0xD7FB, 286},
    {0xF900, 0xFA2D, 310},
    {0xFA30, 0xFA6D, 310},
    {0xFA70, 0xFAD9, 310},
    {0xFB00, 0xFB06, 259},
    {0xFB13, 0xFB17, 264},
    {0xFB1D, 0xFB36, 265},
    {0xFB38, 0xFB3C, 265},
    {0xFB3E, 0xFB3E, 265},
    {0xFB40, 0xFB41, 265},
    {0xFB43, 0xFB44, 265},
    {0xFB46, 0xFB4F, 265},
    {0xFB50, 0xFBB1, 266},
    {0xFBD3, 0xFD3D, 266},
    {0xFD3E, 0xFD3F, 258},
    {0xFD50, 0xFD8F, 266},
    {0xFD92, 0xFDC7, 266},
    {0xFDF0, 0xFDFC, 266},
    {0xFDFD, 0xFDFD, 258},
    {0xFE00, 0xFE0F, 260},
    {0xFE10, 0xFE19, 258},
    {0xFE20, 0xFE26, 260},
    {0xFE30, 0xFE52, 258},
    {0xFE54, 0xFE66, 258},
    {0xFE68, 0xFE6B, 258},
    {0xFE70, 0xFE74, 266},
    {0xFE76, 0xFEFC, 266},
    {0xFEFF, 0xFEFF, 258},
    {0xFF01, 0xFF20, 258},
    {0xFF21, 0xFF3A, 259},
    {0xFF3B, 0xFF40, 258},
    {0xFF41, 0xFF5A, 259},
    {0xFF5B, 0xFF65, 258},
    {0xFF66, 0xFF6F, 312},
    {0xFF70, 0xFF70, 258},
    {0xFF71, 0xFF9D, 312},
    {0xFF9E, 0xFF9F, 258},
    {0xFFA0, 0xFFBE, 286},
    {0xFFC2, 0xFFC7, 286},
    {0xFFCA, 0xFFCF, 286},
    {0xFFD2, 0xFFD7, 286},
    {0xFFDA, 0xFFDC, 286},
    {0xFFE0, 0xFFE6, 258},
    {0xFFE8, 0xFFEE, 258},
    {0xFFF9, 0xFFFD, 258},
    {0x10000, 0x1000B, 327},
    {0x1000D, 0x10026, 327},
    {0x10028, 0x1003A, 327},
    {0x1003C, 0x1003D, 327},
    {0x1003F, 0x1004D, 327},
    {0x10050, 0x1005D, 327},
    {0x10080, 0x100FA, 327},
    {0x10100, 0x10102, 258},
    {0x10107, 0x10133, 258},
    {0x10137, 0x1013F, 258},
    {0x10140, 0x1018A, 261},
    {0x10190, 0x1019B, 258},
    {0x101D0, 0x101FC, 258},
    {0x101FD, 0x101FD, 260},
    {0x10280, 0x1029C, 328},
    {0x102A0, 0x102D0, 329},
    {0x10300, 0x1031E, 330},
    {0x10320, 0x10323, 330},
    {0x10330, 0x1034A, 331},
    {0x10380, 0x1039D, 332},
    {0x1039F, 0x1039F, 332},
    {0x103A0, 0x103C3, 333},
    {0x103C8, 0x103D5, 333},
    {0x10400, 0x1044F, 334},
    {0x10450, 0x1047F, 335},
    {0x10480, 0x1049D, 336},
    {0x104A0, 0x104A9, 336},
    {0x10800, 0x10805, 337},
    {0x10808, 0x10808, 337},
    {0x1080A, 0x10835, 337},
    {0x10837, 0x10838, 337},
    {0x1083C, 0x1083C, 337},
    {0x1083F, 0x1083F, 337},
    {0x10840, 0x10855, 338},
    {0x10857, 0x1085F, 338},
    {0x10900, 0x1091B, 339},
    {0x1091F, 0x1091F, 339},
    {0x10920, 0x10939, 340},
    {0x1093F, 0x1093F, 340},
    {0x10A00, 0x10A03, 341},
    {0x10A05, 0x10A06, 341},
    {0x10A0C, 0x10A13, 341},
    {0x10A15, 0x10A17, 341},
    {0x10A19, 0x10A33, 341},
    {0x10A38, 0x10A3A, 341},
    {0x10A3F, 0x10A47, 341},
    {0x10A50, 0x10A58, 341},
    {0x10A60, 0x10A7F, 342},
    {0x10B00, 0x10B35, 343},
    {0x10B39, 0x10B3F, 343},
    {0x10B40, 0x10B55, 344},
    {0x10B58, 0x10B5F, 344},
    {0x10B60, 0x10B72, 345},
    {0x10B78, 0x10B7F, 345},
    {0x10C00, 0x10C48, 346},
    {0x10E60, 0x10E7E, 266},
    {0x11080, 0x110C1, 347},
    {0x12000, 0x1236E, 348},
    {0x12400, 0x12462, 348},
    {0x12470, 0x12473, 348},
    {0x13000, 0x1342E, 349},
    {0x1D000, 0x1D0F5, 258},
    {0x1D100, 0x1D126, 258},
    {0x1D129, 0x1D166, 258},
    {0x1D167, 0x1D169, 260},
    {0x1D16A, 0x1D17A, 258},
    {0x1D17B, 0x1D182, 260},
    {0x1D183, 0x1D184, 258},
    {0x1D185, 0x1D18B, 260},
    {0x1D18C, 0x1D1A9, 258},
    {0x1D1AA, 0x1D1AD, 260},
    {0x1D1AE, 0x1D1DD, 258},
    {0x1D200, 0x1D245, 261},
    {0x1D300, 0x1D356, 258},
    {0x1D360, 0x1D371, 258},
    {0x1D400, 0x1D454, 258},
    {0x1D456, 0x1D49C, 258},
    {0x1D49E, 0x1D49F, 258},
    {0x1D4A2, 0x1D4A2, 258},
    {0x1D4A5, 0x1D4A6, 258},
    {0x1D4A9, 0x1D4AC, 258},
    {0x1D4AE, 0x1D4B9, 258},
    {0x1D4BB, 0x1D4BB, 258},
    {0x1D4BD, 0x1D4C3, 258},
    {0x1D4C5, 0x1D505, 258},
    {0x1D507, 0x1D50A, 258},
    {0x1D50D, 0x1D514, 258},
    {0x1D516, 0x1D51C, 258},
    {0x1D51E, 0x1D539, 258},
    {0x1D53B, 0x1D53E, 258},
    {0x1D540, 0x1D544, 258},
    {0x1D546, 0x1D546, 258},
    {0x1D54A, 0x1D550, 258},
    {0x1D552, 0x1D6A5, 258},
    {0x1D6A8, 0x1D7CB, 258},
    {0x1D7CE, 0x1D7FF, 258},
    {0x1F000, 0x1F02B, 258},
    {0x1F030, 0x1F093, 258},
    {0x1F100, 0x1F10A, 258},
    {0x1F110, 0x1F12E, 258},
    {0x1F131, 0x1F131, 258},
    {0x1F13D, 0x1F13D, 258},
    {0x1F13F, 0x1F13F, 258},
    {0x1F142, 0x1F142, 258},
    {0x1F146, 0x1F146, 258},
    {0x1F14A, 0x1F14E, 258},
    {0x1F157, 0x1F157, 258},
    {0x1F15F, 0x1F15F, 258},
    {0x1F179, 0x1F179, 258},
    {0x1F17B, 0x1F17C, 258},
    {0x1F17F, 0x1F17F, 258},
    {0x1F18A, 0x1F18D, 258},
    {0x1F190, 0x1F190, 258},
    {0x1F200, 0x1F200, 311},
    {0x1F210, 0x1F231, 258},
    {0x1F240, 0x1F248, 258},
    {0x20000, 0x2A6D6, 310},
    {0x2A700, 0x2B734, 310},
    {0x2F800, 0x2FA1D, 310},
    {0xE0001, 0xE0001, 258},
    {0xE0020, 0xE007F, 258},
    {0xE0100, 0xE01EF, 260},
};

/* ASCII character categories. */
#define RE_MASK_DIGIT 0x1
#define RE_MASK_LOWER 0x2
#define RE_MASK_PUNCT 0x4
#define RE_MASK_SPACE 0x8
#define RE_MASK_UPPER 0x10
#define RE_MASK_XDIGIT 0x20

/* alpha = upper | lower */
#define RE_MASK_ALPHA (RE_MASK_UPPER | RE_MASK_LOWER)
/* alnum = alpha | digit */
#define RE_MASK_ALNUM (RE_MASK_ALPHA | RE_MASK_DIGIT)

unsigned char re_ascii_category[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
    0x21, 0x21, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x00,
};

#define RE_FLAG_ASCII 0x80
#define RE_FLAG_DEBUG 0x200
#define RE_FLAG_DOTALL 0x10
#define RE_FLAG_IGNORECASE 0x2
#define RE_FLAG_LOCALE 0x4
#define RE_FLAG_MULTILINE 0x8
#define RE_FLAG_REVERSE 0x400
#define RE_FLAG_TEMPLATE 0x1
#define RE_FLAG_UNICODE 0x20
#define RE_FLAG_VERBOSE 0x40
#define RE_FLAG_ZEROWIDTH 0x100
