/*
 * Secret Labs' Regular Expression Engine
 *
 * regular expression matching engine
 *
 * Copyright (c) 1997-2001 by Secret Labs AB.  All rights reserved.
 *
 * NOTE: This file is generated by regex.py.  If you need
 * to change anything in here, edit regex.py and run it.
 *
 * 2010-01-16 mrab Re-written
 */

#define RE_MAGIC 20100116

/* Size of a code word (must be unsigned short or larger, and large enough to
 * hold a Py_UNICODE character).
 */
#if SIZEOF_INT >= 4
#define RE_CODE unsigned int
#else
#define RE_CODE SIZEOF_LONG
#define RE_CODE unsigned long
#endif

/* Unlimited repeat count. */
#define RE_UNLIMITED (~(RE_CODE)0)

/* Operators. */
#define RE_OP_FAILURE 0
#define RE_OP_SUCCESS 1
#define RE_OP_ANY 2
#define RE_OP_ANY_ALL 3
#define RE_OP_ANY_ALL_REV 4
#define RE_OP_ANY_REV 5
#define RE_OP_ATOMIC 6
#define RE_OP_BEGIN_GROUP 7
#define RE_OP_BIG_BITSET 8
#define RE_OP_BIG_BITSET_IGN 9
#define RE_OP_BIG_BITSET_IGN_REV 10
#define RE_OP_BIG_BITSET_REV 11
#define RE_OP_BOUNDARY 12
#define RE_OP_BRANCH 13
#define RE_OP_CHARACTER 14
#define RE_OP_CHARACTER_IGN 15
#define RE_OP_CHARACTER_IGN_REV 16
#define RE_OP_CHARACTER_REV 17
#define RE_OP_CHECK 18
#define RE_OP_CHECK_IGN 19
#define RE_OP_CHECK_IGN_REV 20
#define RE_OP_CHECK_REV 21
#define RE_OP_DEFAULT_BOUNDARY 22
#define RE_OP_END 23
#define RE_OP_END_GREEDY_REPEAT 24
#define RE_OP_END_GROUP 25
#define RE_OP_END_LAZY_REPEAT 26
#define RE_OP_END_OF_LINE 27
#define RE_OP_END_OF_STRING 28
#define RE_OP_END_OF_STRING_LINE 29
#define RE_OP_GREEDY_REPEAT 30
#define RE_OP_GREEDY_REPEAT_ONE 31
#define RE_OP_GROUP 32
#define RE_OP_GROUP_EXISTS 33
#define RE_OP_LAZY_REPEAT 34
#define RE_OP_LAZY_REPEAT_ONE 35
#define RE_OP_LOOKAROUND 36
#define RE_OP_NEXT 37
#define RE_OP_PROPERTY 38
#define RE_OP_PROPERTY_REV 39
#define RE_OP_RANGE 40
#define RE_OP_RANGE_IGN 41
#define RE_OP_RANGE_IGN_REV 42
#define RE_OP_RANGE_REV 43
#define RE_OP_REF_GROUP 44
#define RE_OP_REF_GROUP_IGN 45
#define RE_OP_REF_GROUP_IGN_REV 46
#define RE_OP_REF_GROUP_REV 47
#define RE_OP_SEARCH_ANCHOR 48
#define RE_OP_SET 49
#define RE_OP_SET_IGN 50
#define RE_OP_SET_IGN_REV 51
#define RE_OP_SET_REV 52
#define RE_OP_SMALL_BITSET 53
#define RE_OP_SMALL_BITSET_IGN 54
#define RE_OP_SMALL_BITSET_IGN_REV 55
#define RE_OP_SMALL_BITSET_REV 56
#define RE_OP_START_OF_LINE 57
#define RE_OP_START_OF_STRING 58
#define RE_OP_STRING 59
#define RE_OP_STRING_IGN 60
#define RE_OP_STRING_IGN_REV 61
#define RE_OP_STRING_REV 62

char* re_op_text[] = {
    "RE_OP_FAILURE",
    "RE_OP_SUCCESS",
    "RE_OP_ANY",
    "RE_OP_ANY_ALL",
    "RE_OP_ANY_ALL_REV",
    "RE_OP_ANY_REV",
    "RE_OP_ATOMIC",
    "RE_OP_BEGIN_GROUP",
    "RE_OP_BIG_BITSET",
    "RE_OP_BIG_BITSET_IGN",
    "RE_OP_BIG_BITSET_IGN_REV",
    "RE_OP_BIG_BITSET_REV",
    "RE_OP_BOUNDARY",
    "RE_OP_BRANCH",
    "RE_OP_CHARACTER",
    "RE_OP_CHARACTER_IGN",
    "RE_OP_CHARACTER_IGN_REV",
    "RE_OP_CHARACTER_REV",
    "RE_OP_CHECK",
    "RE_OP_CHECK_IGN",
    "RE_OP_CHECK_IGN_REV",
    "RE_OP_CHECK_REV",
    "RE_OP_DEFAULT_BOUNDARY",
    "RE_OP_END",
    "RE_OP_END_GREEDY_REPEAT",
    "RE_OP_END_GROUP",
    "RE_OP_END_LAZY_REPEAT",
    "RE_OP_END_OF_LINE",
    "RE_OP_END_OF_STRING",
    "RE_OP_END_OF_STRING_LINE",
    "RE_OP_GREEDY_REPEAT",
    "RE_OP_GREEDY_REPEAT_ONE",
    "RE_OP_GROUP",
    "RE_OP_GROUP_EXISTS",
    "RE_OP_LAZY_REPEAT",
    "RE_OP_LAZY_REPEAT_ONE",
    "RE_OP_LOOKAROUND",
    "RE_OP_NEXT",
    "RE_OP_PROPERTY",
    "RE_OP_PROPERTY_REV",
    "RE_OP_RANGE",
    "RE_OP_RANGE_IGN",
    "RE_OP_RANGE_IGN_REV",
    "RE_OP_RANGE_REV",
    "RE_OP_REF_GROUP",
    "RE_OP_REF_GROUP_IGN",
    "RE_OP_REF_GROUP_IGN_REV",
    "RE_OP_REF_GROUP_REV",
    "RE_OP_SEARCH_ANCHOR",
    "RE_OP_SET",
    "RE_OP_SET_IGN",
    "RE_OP_SET_IGN_REV",
    "RE_OP_SET_REV",
    "RE_OP_SMALL_BITSET",
    "RE_OP_SMALL_BITSET_IGN",
    "RE_OP_SMALL_BITSET_IGN_REV",
    "RE_OP_SMALL_BITSET_REV",
    "RE_OP_START_OF_LINE",
    "RE_OP_START_OF_STRING",
    "RE_OP_STRING",
    "RE_OP_STRING_IGN",
    "RE_OP_STRING_IGN_REV",
    "RE_OP_STRING_REV",
};

/* Character/codepoint properties. */
#define RE_PROP_CN 0
#define RE_PROP_LU 1
#define RE_PROP_LL 2
#define RE_PROP_LT 3
#define RE_PROP_MN 4
#define RE_PROP_MC 5
#define RE_PROP_ME 6
#define RE_PROP_ND 7
#define RE_PROP_NL 8
#define RE_PROP_NO 9
#define RE_PROP_ZS 10
#define RE_PROP_ZL 11
#define RE_PROP_ZP 12
#define RE_PROP_CC 13
#define RE_PROP_CF 14
#define RE_PROP_CS 15
#define RE_PROP_CO 16
#define RE_PROP_LM 18
#define RE_PROP_LO 19
#define RE_PROP_PC 20
#define RE_PROP_PD 21
#define RE_PROP_PS 22
#define RE_PROP_PE 23
#define RE_PROP_PI 24
#define RE_PROP_PF 25
#define RE_PROP_PO 26
#define RE_PROP_SM 27
#define RE_PROP_SC 28
#define RE_PROP_SK 29
#define RE_PROP_SO 30
#define RE_PROP_L 32
#define RE_PROP_M 33
#define RE_PROP_Z 34
#define RE_PROP_S 35
#define RE_PROP_N 36
#define RE_PROP_P 37
#define RE_PROP_C 38
#define RE_PROP_ALPHA 39
#define RE_PROP_ALNUM 40
#define RE_PROP_ASCII 41
#define RE_PROP_BLANK 42
#define RE_PROP_CNTRL 43
#define RE_PROP_DIGIT 44
#define RE_PROP_GRAPH 45
#define RE_PROP_LINEBREAK 46
#define RE_PROP_LOWER 47
#define RE_PROP_PRINT 48
#define RE_PROP_PUNCT 49
#define RE_PROP_SPACE 50
#define RE_PROP_UPPER 51
#define RE_PROP_WORD 52
#define RE_PROP_XDIGIT 53

/* Unicode character properties. */
#define RE_PROP_MASK_CN 0x00020001
#define RE_PROP_MASK_LU 0x00000002
#define RE_PROP_MASK_LL 0x00000004
#define RE_PROP_MASK_LT 0x00000008
#define RE_PROP_MASK_MN 0x00000010
#define RE_PROP_MASK_MC 0x00000020
#define RE_PROP_MASK_ME 0x00000040
#define RE_PROP_MASK_ND 0x00000080
#define RE_PROP_MASK_NL 0x00000100
#define RE_PROP_MASK_NO 0x00000200
#define RE_PROP_MASK_ZS 0x00000400
#define RE_PROP_MASK_ZL 0x00000800
#define RE_PROP_MASK_ZP 0x00001000
#define RE_PROP_MASK_CC 0x00002000
#define RE_PROP_MASK_CF 0x00004000
#define RE_PROP_MASK_CS 0x00008000
#define RE_PROP_MASK_CO 0x00010000
#define RE_PROP_MASK_LM 0x00040000
#define RE_PROP_MASK_LO 0x00080000
#define RE_PROP_MASK_PC 0x00100000
#define RE_PROP_MASK_PD 0x00200000
#define RE_PROP_MASK_PS 0x00400000
#define RE_PROP_MASK_PE 0x00800000
#define RE_PROP_MASK_PI 0x01000000
#define RE_PROP_MASK_PF 0x02000000
#define RE_PROP_MASK_PO 0x04000000
#define RE_PROP_MASK_SM 0x08000000
#define RE_PROP_MASK_SC 0x10000000
#define RE_PROP_MASK_SK 0x20000000
#define RE_PROP_MASK_SO 0x40000000
#define RE_PROP_MASK_L 0x000C000E
#define RE_PROP_MASK_M 0x00000070
#define RE_PROP_MASK_Z 0x00001C00
#define RE_PROP_MASK_S 0x78000000
#define RE_PROP_MASK_N 0x00000380
#define RE_PROP_MASK_P 0x07F00000
#define RE_PROP_MASK_C 0x0003E001

#define RE_PROP_MASK_ALNUM (RE_PROP_MASK_L | RE_PROP_MASK_ND)
#define RE_PROP_MASK_NONGRAPH (RE_PROP_MASK_Z | RE_PROP_MASK_C)
#define RE_PROP_MASK_PUNCT (RE_PROP_MASK_P | RE_PROP_MASK_S)
#define RE_PROP_MASK_SPACE (RE_PROP_MASK_ZL | RE_PROP_MASK_ZP | \
  RE_PROP_MASK_CC | RE_PROP_MASK_CF)
#define RE_PROP_MASK_WORD (RE_PROP_MASK_L | RE_PROP_MASK_M | RE_PROP_MASK_N | \
  RE_PROP_MASK_PC)

/* Unicode block ranges. */
#define RE_MIN_BLOCK 54
#define RE_MAX_BLOCK 251

/* Unicode script ranges. */
#define RE_MIN_SCRIPT 252
#define RE_MAX_SCRIPT 344

/* Forms of Unicode word break. */
#define RE_BREAK_OTHER 345
#define RE_BREAK_CR 346
#define RE_BREAK_LF 347
#define RE_BREAK_NEWLINE 348
#define RE_BREAK_EXTEND 349
#define RE_BREAK_FORMAT 350
#define RE_BREAK_KATAKANA 351
#define RE_BREAK_ALETTER 352
#define RE_BREAK_MIDLETTER 353
#define RE_BREAK_MIDNUM 354
#define RE_BREAK_MIDNUMLET 355
#define RE_BREAK_NUMERIC 356
#define RE_BREAK_EXTENDNUMLET 357

typedef struct RE_InfoRange {
    unsigned int min_char;
    unsigned int max_char;
    int block;
    int script;
    int word_break;
} RE_InfoRange;

/* The codepoint info table. */
RE_InfoRange re_codepoint_info[] = {
    {0x0, 0x9, 55, 253, 345},
    {0xA, 0xA, 55, 253, 347},
    {0xB, 0xC, 55, 253, 348},
    {0xD, 0xD, 55, 253, 346},
    {0xE, 0x26, 55, 253, 345},
    {0x27, 0x27, 55, 253, 355},
    {0x28, 0x2B, 55, 253, 345},
    {0x2C, 0x2C, 55, 253, 354},
    {0x2D, 0x2D, 55, 253, 345},
    {0x2E, 0x2E, 55, 253, 355},
    {0x2F, 0x2F, 55, 253, 345},
    {0x30, 0x39, 55, 253, 356},
    {0x3A, 0x3A, 55, 253, 353},
    {0x3B, 0x3B, 55, 253, 354},
    {0x3C, 0x40, 55, 253, 345},
    {0x41, 0x5A, 55, 254, 352},
    {0x5B, 0x5E, 55, 253, 345},
    {0x5F, 0x5F, 55, 253, 357},
    {0x60, 0x60, 55, 253, 345},
    {0x61, 0x7A, 55, 254, 352},
    {0x7B, 0x7F, 55, 253, 345},
    {0x80, 0x84, 56, 253, 345},
    {0x85, 0x85, 56, 253, 348},
    {0x86, 0xA9, 56, 253, 345},
    {0xAA, 0xAA, 56, 254, 352},
    {0xAB, 0xAC, 56, 253, 345},
    {0xAD, 0xAD, 56, 253, 350},
    {0xAE, 0xB4, 56, 253, 345},
    {0xB5, 0xB5, 56, 253, 352},
    {0xB6, 0xB6, 56, 253, 345},
    {0xB7, 0xB7, 56, 253, 353},
    {0xB8, 0xB9, 56, 253, 345},
    {0xBA, 0xBA, 56, 254, 352},
    {0xBB, 0xBF, 56, 253, 345},
    {0xC0, 0xD6, 56, 254, 352},
    {0xD7, 0xD7, 56, 253, 345},
    {0xD8, 0xF6, 56, 254, 352},
    {0xF7, 0xF7, 56, 253, 345},
    {0xF8, 0xFF, 56, 254, 352},
    {0x100, 0x17F, 57, 254, 352},
    {0x180, 0x24F, 58, 254, 352},
    {0x250, 0x2AF, 59, 254, 352},
    {0x2B0, 0x2B8, 60, 254, 352},
    {0x2B9, 0x2C1, 60, 253, 352},
    {0x2C2, 0x2C5, 60, 253, 345},
    {0x2C6, 0x2D1, 60, 253, 352},
    {0x2D2, 0x2DF, 60, 253, 345},
    {0x2E0, 0x2E4, 60, 254, 352},
    {0x2E5, 0x2EB, 60, 253, 345},
    {0x2EC, 0x2EC, 60, 253, 352},
    {0x2ED, 0x2ED, 60, 253, 345},
    {0x2EE, 0x2EE, 60, 253, 352},
    {0x2EF, 0x2FF, 60, 253, 345},
    {0x300, 0x36F, 61, 293, 349},
    {0x370, 0x373, 62, 255, 352},
    {0x374, 0x374, 62, 253, 352},
    {0x375, 0x375, 62, 255, 345},
    {0x376, 0x377, 62, 255, 352},
    {0x378, 0x379, 62, 252, 345},
    {0x37A, 0x37D, 62, 255, 352},
    {0x37E, 0x37E, 62, 253, 354},
    {0x37F, 0x383, 62, 252, 345},
    {0x384, 0x384, 62, 255, 345},
    {0x385, 0x385, 62, 253, 345},
    {0x386, 0x386, 62, 255, 352},
    {0x387, 0x387, 62, 253, 353},
    {0x388, 0x38A, 62, 255, 352},
    {0x38B, 0x38B, 62, 252, 345},
    {0x38C, 0x38C, 62, 255, 352},
    {0x38D, 0x38D, 62, 252, 345},
    {0x38E, 0x3A1, 62, 255, 352},
    {0x3A2, 0x3A2, 62, 252, 345},
    {0x3A3, 0x3E1, 62, 255, 352},
    {0x3E2, 0x3EF, 62, 307, 352},
    {0x3F0, 0x3F5, 62, 255, 352},
    {0x3F6, 0x3F6, 62, 255, 345},
    {0x3F7, 0x3FF, 62, 255, 352},
    {0x400, 0x481, 63, 256, 352},
    {0x482, 0x482, 63, 256, 345},
    {0x483, 0x484, 63, 256, 349},
    {0x485, 0x486, 63, 293, 349},
    {0x487, 0x489, 63, 256, 349},
    {0x48A, 0x4FF, 63, 256, 352},
    {0x500, 0x525, 64, 256, 352},
    {0x526, 0x52F, 64, 252, 345},
    {0x530, 0x530, 65, 252, 345},
    {0x531, 0x556, 65, 257, 352},
    {0x557, 0x558, 65, 252, 345},
    {0x559, 0x559, 65, 257, 352},
    {0x55A, 0x55F, 65, 257, 345},
    {0x560, 0x560, 65, 252, 345},
    {0x561, 0x587, 65, 257, 352},
    {0x588, 0x588, 65, 252, 345},
    {0x589, 0x589, 65, 253, 354},
    {0x58A, 0x58A, 65, 257, 345},
    {0x58B, 0x58F, 65, 252, 345},
    {0x590, 0x590, 66, 252, 345},
    {0x591, 0x5BD, 66, 258, 349},
    {0x5BE, 0x5BE, 66, 258, 345},
    {0x5BF, 0x5BF, 66, 258, 349},
    {0x5C0, 0x5C0, 66, 258, 345},
    {0x5C1, 0x5C2, 66, 258, 349},
    {0x5C3, 0x5C3, 66, 258, 345},
    {0x5C4, 0x5C5, 66, 258, 349},
    {0x5C6, 0x5C6, 66, 258, 345},
    {0x5C7, 0x5C7, 66, 258, 349},
    {0x5C8, 0x5CF, 66, 252, 345},
    {0x5D0, 0x5EA, 66, 258, 352},
    {0x5EB, 0x5EF, 66, 252, 345},
    {0x5F0, 0x5F3, 66, 258, 352},
    {0x5F4, 0x5F4, 66, 258, 353},
    {0x5F5, 0x5FF, 66, 252, 345},
    {0x600, 0x603, 67, 253, 350},
    {0x604, 0x605, 67, 252, 345},
    {0x606, 0x60B, 67, 259, 345},
    {0x60C, 0x60C, 67, 253, 354},
    {0x60D, 0x60D, 67, 259, 354},
    {0x60E, 0x60F, 67, 259, 345},
    {0x610, 0x61A, 67, 259, 349},
    {0x61B, 0x61B, 67, 253, 345},
    {0x61C, 0x61D, 67, 252, 345},
    {0x61E, 0x61E, 67, 259, 345},
    {0x61F, 0x61F, 67, 253, 345},
    {0x620, 0x620, 67, 252, 345},
    {0x621, 0x63F, 67, 259, 352},
    {0x640, 0x640, 67, 253, 352},
    {0x641, 0x64A, 67, 259, 352},
    {0x64B, 0x655, 67, 293, 349},
    {0x656, 0x65E, 67, 259, 349},
    {0x65F, 0x65F, 67, 252, 345},
    {0x660, 0x669, 67, 253, 356},
    {0x66A, 0x66A, 67, 259, 345},
    {0x66B, 0x66B, 67, 259, 356},
    {0x66C, 0x66C, 67, 259, 354},
    {0x66D, 0x66D, 67, 259, 345},
    {0x66E, 0x66F, 67, 259, 352},
    {0x670, 0x670, 67, 293, 349},
    {0x671, 0x6D3, 67, 259, 352},
    {0x6D4, 0x6D4, 67, 259, 345},
    {0x6D5, 0x6D5, 67, 259, 352},
    {0x6D6, 0x6DC, 67, 259, 349},
    {0x6DD, 0x6DD, 67, 253, 350},
    {0x6DE, 0x6E4, 67, 259, 349},
    {0x6E5, 0x6E6, 67, 259, 352},
    {0x6E7, 0x6E8, 67, 259, 349},
    {0x6E9, 0x6E9, 67, 259, 345},
    {0x6EA, 0x6ED, 67, 259, 349},
    {0x6EE, 0x6EF, 67, 259, 352},
    {0x6F0, 0x6F9, 67, 259, 356},
    {0x6FA, 0x6FC, 67, 259, 352},
    {0x6FD, 0x6FE, 67, 259, 345},
    {0x6FF, 0x6FF, 67, 259, 352},
    {0x700, 0x70D, 68, 260, 345},
    {0x70E, 0x70E, 68, 252, 345},
    {0x70F, 0x70F, 68, 260, 350},
    {0x710, 0x710, 68, 260, 352},
    {0x711, 0x711, 68, 260, 349},
    {0x712, 0x72F, 68, 260, 352},
    {0x730, 0x74A, 68, 260, 349},
    {0x74B, 0x74C, 68, 252, 345},
    {0x74D, 0x74F, 68, 260, 352},
    {0x750, 0x77F, 69, 259, 352},
    {0x780, 0x7A5, 70, 261, 352},
    {0x7A6, 0x7B0, 70, 261, 349},
    {0x7B1, 0x7B1, 70, 261, 352},
    {0x7B2, 0x7BF, 70, 252, 345},
    {0x7C0, 0x7C9, 71, 318, 356},
    {0x7CA, 0x7EA, 71, 318, 352},
    {0x7EB, 0x7F3, 71, 318, 349},
    {0x7F4, 0x7F5, 71, 318, 352},
    {0x7F6, 0x7F7, 71, 318, 345},
    {0x7F8, 0x7F8, 71, 318, 354},
    {0x7F9, 0x7F9, 71, 318, 345},
    {0x7FA, 0x7FA, 71, 318, 352},
    {0x7FB, 0x7FF, 71, 252, 345},
    {0x800, 0x815, 72, 334, 352},
    {0x816, 0x819, 72, 334, 349},
    {0x81A, 0x81A, 72, 334, 352},
    {0x81B, 0x823, 72, 334, 349},
    {0x824, 0x824, 72, 334, 352},
    {0x825, 0x827, 72, 334, 349},
    {0x828, 0x828, 72, 334, 352},
    {0x829, 0x82D, 72, 334, 349},
    {0x82E, 0x82F, 72, 252, 345},
    {0x830, 0x83E, 72, 334, 345},
    {0x83F, 0x83F, 72, 252, 345},
    {0x840, 0x8FF, 54, 252, 345},
    {0x900, 0x903, 73, 262, 349},
    {0x904, 0x939, 73, 262, 352},
    {0x93A, 0x93B, 73, 252, 345},
    {0x93C, 0x93C, 73, 262, 349},
    {0x93D, 0x93D, 73, 262, 352},
    {0x93E, 0x94E, 73, 262, 349},
    {0x94F, 0x94F, 73, 252, 345},
    {0x950, 0x950, 73, 262, 352},
    {0x951, 0x952, 73, 293, 349},
    {0x953, 0x955, 73, 262, 349},
    {0x956, 0x957, 73, 252, 345},
    {0x958, 0x961, 73, 262, 352},
    {0x962, 0x963, 73, 262, 349},
    {0x964, 0x965, 73, 253, 345},
    {0x966, 0x96F, 73, 262, 356},
    {0x970, 0x970, 73, 253, 345},
    {0x971, 0x972, 73, 262, 352},
    {0x973, 0x978, 73, 252, 345},
    {0x979, 0x97F, 73, 262, 352},
    {0x980, 0x980, 74, 252, 345},
    {0x981, 0x983, 74, 263, 349},
    {0x984, 0x984, 74, 252, 345},
    {0x985, 0x98C, 74, 263, 352},
    {0x98D, 0x98E, 74, 252, 345},
    {0x98F, 0x990, 74, 263, 352},
    {0x991, 0x992, 74, 252, 345},
    {0x993, 0x9A8, 74, 263, 352},
    {0x9A9, 0x9A9, 74, 252, 345},
    {0x9AA, 0x9B0, 74, 263, 352},
    {0x9B1, 0x9B1, 74, 252, 345},
    {0x9B2, 0x9B2, 74, 263, 352},
    {0x9B3, 0x9B5, 74, 252, 345},
    {0x9B6, 0x9B9, 74, 263, 352},
    {0x9BA, 0x9BB, 74, 252, 345},
    {0x9BC, 0x9BC, 74, 263, 349},
    {0x9BD, 0x9BD, 74, 263, 352},
    {0x9BE, 0x9C4, 74, 263, 349},
    {0x9C5, 0x9C6, 74, 252, 345},
    {0x9C7, 0x9C8, 74, 263, 349},
    {0x9C9, 0x9CA, 74, 252, 345},
    {0x9CB, 0x9CD, 74, 263, 349},
    {0x9CE, 0x9CE, 74, 263, 352},
    {0x9CF, 0x9D6, 74, 252, 345},
    {0x9D7, 0x9D7, 74, 263, 349},
    {0x9D8, 0x9DB, 74, 252, 345},
    {0x9DC, 0x9DD, 74, 263, 352},
    {0x9DE, 0x9DE, 74, 252, 345},
    {0x9DF, 0x9E1, 74, 263, 352},
    {0x9E2, 0x9E3, 74, 263, 349},
    {0x9E4, 0x9E5, 74, 252, 345},
    {0x9E6, 0x9EF, 74, 263, 356},
    {0x9F0, 0x9F1, 74, 263, 352},
    {0x9F2, 0x9FB, 74, 263, 345},
    {0x9FC, 0x9FF, 74, 252, 345},
    {0xA00, 0xA00, 75, 252, 345},
    {0xA01, 0xA03, 75, 264, 349},
    {0xA04, 0xA04, 75, 252, 345},
    {0xA05, 0xA0A, 75, 264, 352},
    {0xA0B, 0xA0E, 75, 252, 345},
    {0xA0F, 0xA10, 75, 264, 352},
    {0xA11, 0xA12, 75, 252, 345},
    {0xA13, 0xA28, 75, 264, 352},
    {0xA29, 0xA29, 75, 252, 345},
    {0xA2A, 0xA30, 75, 264, 352},
    {0xA31, 0xA31, 75, 252, 345},
    {0xA32, 0xA33, 75, 264, 352},
    {0xA34, 0xA34, 75, 252, 345},
    {0xA35, 0xA36, 75, 264, 352},
    {0xA37, 0xA37, 75, 252, 345},
    {0xA38, 0xA39, 75, 264, 352},
    {0xA3A, 0xA3B, 75, 252, 345},
    {0xA3C, 0xA3C, 75, 264, 349},
    {0xA3D, 0xA3D, 75, 252, 345},
    {0xA3E, 0xA42, 75, 264, 349},
    {0xA43, 0xA46, 75, 252, 345},
    {0xA47, 0xA48, 75, 264, 349},
    {0xA49, 0xA4A, 75, 252, 345},
    {0xA4B, 0xA4D, 75, 264, 349},
    {0xA4E, 0xA50, 75, 252, 345},
    {0xA51, 0xA51, 75, 264, 349},
    {0xA52, 0xA58, 75, 252, 345},
    {0xA59, 0xA5C, 75, 264, 352},
    {0xA5D, 0xA5D, 75, 252, 345},
    {0xA5E, 0xA5E, 75, 264, 352},
    {0xA5F, 0xA65, 75, 252, 345},
    {0xA66, 0xA6F, 75, 264, 356},
    {0xA70, 0xA71, 75, 264, 349},
    {0xA72, 0xA74, 75, 264, 352},
    {0xA75, 0xA75, 75, 264, 349},
    {0xA76, 0xA7F, 75, 252, 345},
    {0xA80, 0xA80, 76, 252, 345},
    {0xA81, 0xA83, 76, 265, 349},
    {0xA84, 0xA84, 76, 252, 345},
    {0xA85, 0xA8D, 76, 265, 352},
    {0xA8E, 0xA8E, 76, 252, 345},
    {0xA8F, 0xA91, 76, 265, 352},
    {0xA92, 0xA92, 76, 252, 345},
    {0xA93, 0xAA8, 76, 265, 352},
    {0xAA9, 0xAA9, 76, 252, 345},
    {0xAAA, 0xAB0, 76, 265, 352},
    {0xAB1, 0xAB1, 76, 252, 345},
    {0xAB2, 0xAB3, 76, 265, 352},
    {0xAB4, 0xAB4, 76, 252, 345},
    {0xAB5, 0xAB9, 76, 265, 352},
    {0xABA, 0xABB, 76, 252, 345},
    {0xABC, 0xABC, 76, 265, 349},
    {0xABD, 0xABD, 76, 265, 352},
    {0xABE, 0xAC5, 76, 265, 349},
    {0xAC6, 0xAC6, 76, 252, 345},
    {0xAC7, 0xAC9, 76, 265, 349},
    {0xACA, 0xACA, 76, 252, 345},
    {0xACB, 0xACD, 76, 265, 349},
    {0xACE, 0xACF, 76, 252, 345},
    {0xAD0, 0xAD0, 76, 265, 352},
    {0xAD1, 0xADF, 76, 252, 345},
    {0xAE0, 0xAE1, 76, 265, 352},
    {0xAE2, 0xAE3, 76, 265, 349},
    {0xAE4, 0xAE5, 76, 252, 345},
    {0xAE6, 0xAEF, 76, 265, 356},
    {0xAF0, 0xAF0, 76, 252, 345},
    {0xAF1, 0xAF1, 76, 265, 345},
    {0xAF2, 0xAFF, 76, 252, 345},
    {0xB00, 0xB00, 77, 252, 345},
    {0xB01, 0xB03, 77, 266, 349},
    {0xB04, 0xB04, 77, 252, 345},
    {0xB05, 0xB0C, 77, 266, 352},
    {0xB0D, 0xB0E, 77, 252, 345},
    {0xB0F, 0xB10, 77, 266, 352},
    {0xB11, 0xB12, 77, 252, 345},
    {0xB13, 0xB28, 77, 266, 352},
    {0xB29, 0xB29, 77, 252, 345},
    {0xB2A, 0xB30, 77, 266, 352},
    {0xB31, 0xB31, 77, 252, 345},
    {0xB32, 0xB33, 77, 266, 352},
    {0xB34, 0xB34, 77, 252, 345},
    {0xB35, 0xB39, 77, 266, 352},
    {0xB3A, 0xB3B, 77, 252, 345},
    {0xB3C, 0xB3C, 77, 266, 349},
    {0xB3D, 0xB3D, 77, 266, 352},
    {0xB3E, 0xB44, 77, 266, 349},
    {0xB45, 0xB46, 77, 252, 345},
    {0xB47, 0xB48, 77, 266, 349},
    {0xB49, 0xB4A, 77, 252, 345},
    {0xB4B, 0xB4D, 77, 266, 349},
    {0xB4E, 0xB55, 77, 252, 345},
    {0xB56, 0xB57, 77, 266, 349},
    {0xB58, 0xB5B, 77, 252, 345},
    {0xB5C, 0xB5D, 77, 266, 352},
    {0xB5E, 0xB5E, 77, 252, 345},
    {0xB5F, 0xB61, 77, 266, 352},
    {0xB62, 0xB63, 77, 266, 349},
    {0xB64, 0xB65, 77, 252, 345},
    {0xB66, 0xB6F, 77, 266, 356},
    {0xB70, 0xB70, 77, 266, 345},
    {0xB71, 0xB71, 77, 266, 352},
    {0xB72, 0xB7F, 77, 252, 345},
    {0xB80, 0xB81, 78, 252, 345},
    {0xB82, 0xB82, 78, 267, 349},
    {0xB83, 0xB83, 78, 267, 352},
    {0xB84, 0xB84, 78, 252, 345},
    {0xB85, 0xB8A, 78, 267, 352},
    {0xB8B, 0xB8D, 78, 252, 345},
    {0xB8E, 0xB90, 78, 267, 352},
    {0xB91, 0xB91, 78, 252, 345},
    {0xB92, 0xB95, 78, 267, 352},
    {0xB96, 0xB98, 78, 252, 345},
    {0xB99, 0xB9A, 78, 267, 352},
    {0xB9B, 0xB9B, 78, 252, 345},
    {0xB9C, 0xB9C, 78, 267, 352},
    {0xB9D, 0xB9D, 78, 252, 345},
    {0xB9E, 0xB9F, 78, 267, 352},
    {0xBA0, 0xBA2, 78, 252, 345},
    {0xBA3, 0xBA4, 78, 267, 352},
    {0xBA5, 0xBA7, 78, 252, 345},
    {0xBA8, 0xBAA, 78, 267, 352},
    {0xBAB, 0xBAD, 78, 252, 345},
    {0xBAE, 0xBB9, 78, 267, 352},
    {0xBBA, 0xBBD, 78, 252, 345},
    {0xBBE, 0xBC2, 78, 267, 349},
    {0xBC3, 0xBC5, 78, 252, 345},
    {0xBC6, 0xBC8, 78, 267, 349},
    {0xBC9, 0xBC9, 78, 252, 345},
    {0xBCA, 0xBCD, 78, 267, 349},
    {0xBCE, 0xBCF, 78, 252, 345},
    {0xBD0, 0xBD0, 78, 267, 352},
    {0xBD1, 0xBD6, 78, 252, 345},
    {0xBD7, 0xBD7, 78, 267, 349},
    {0xBD8, 0xBE5, 78, 252, 345},
    {0xBE6, 0xBEF, 78, 267, 356},
    {0xBF0, 0xBFA, 78, 267, 345},
    {0xBFB, 0xBFF, 78, 252, 345},
    {0xC00, 0xC00, 79, 252, 345},
    {0xC01, 0xC03, 79, 268, 349},
    {0xC04, 0xC04, 79, 252, 345},
    {0xC05, 0xC0C, 79, 268, 352},
    {0xC0D, 0xC0D, 79, 252, 345},
    {0xC0E, 0xC10, 79, 268, 352},
    {0xC11, 0xC11, 79, 252, 345},
    {0xC12, 0xC28, 79, 268, 352},
    {0xC29, 0xC29, 79, 252, 345},
    {0xC2A, 0xC33, 79, 268, 352},
    {0xC34, 0xC34, 79, 252, 345},
    {0xC35, 0xC39, 79, 268, 352},
    {0xC3A, 0xC3C, 79, 252, 345},
    {0xC3D, 0xC3D, 79, 268, 352},
    {0xC3E, 0xC44, 79, 268, 349},
    {0xC45, 0xC45, 79, 252, 345},
    {0xC46, 0xC48, 79, 268, 349},
    {0xC49, 0xC49, 79, 252, 345},
    {0xC4A, 0xC4D, 79, 268, 349},
    {0xC4E, 0xC54, 79, 252, 345},
    {0xC55, 0xC56, 79, 268, 349},
    {0xC57, 0xC57, 79, 252, 345},
    {0xC58, 0xC59, 79, 268, 352},
    {0xC5A, 0xC5F, 79, 252, 345},
    {0xC60, 0xC61, 79, 268, 352},
    {0xC62, 0xC63, 79, 268, 349},
    {0xC64, 0xC65, 79, 252, 345},
    {0xC66, 0xC6F, 79, 268, 356},
    {0xC70, 0xC77, 79, 252, 345},
    {0xC78, 0xC7F, 79, 268, 345},
    {0xC80, 0xC81, 80, 252, 345},
    {0xC82, 0xC83, 80, 269, 349},
    {0xC84, 0xC84, 80, 252, 345},
    {0xC85, 0xC8C, 80, 269, 352},
    {0xC8D, 0xC8D, 80, 252, 345},
    {0xC8E, 0xC90, 80, 269, 352},
    {0xC91, 0xC91, 80, 252, 345},
    {0xC92, 0xCA8, 80, 269, 352},
    {0xCA9, 0xCA9, 80, 252, 345},
    {0xCAA, 0xCB3, 80, 269, 352},
    {0xCB4, 0xCB4, 80, 252, 345},
    {0xCB5, 0xCB9, 80, 269, 352},
    {0xCBA, 0xCBB, 80, 252, 345},
    {0xCBC, 0xCBC, 80, 269, 349},
    {0xCBD, 0xCBD, 80, 269, 352},
    {0xCBE, 0xCC4, 80, 269, 349},
    {0xCC5, 0xCC5, 80, 252, 345},
    {0xCC6, 0xCC8, 80, 269, 349},
    {0xCC9, 0xCC9, 80, 252, 345},
    {0xCCA, 0xCCD, 80, 269, 349},
    {0xCCE, 0xCD4, 80, 252, 345},
    {0xCD5, 0xCD6, 80, 269, 349},
    {0xCD7, 0xCDD, 80, 252, 345},
    {0xCDE, 0xCDE, 80, 269, 352},
    {0xCDF, 0xCDF, 80, 252, 345},
    {0xCE0, 0xCE1, 80, 269, 352},
    {0xCE2, 0xCE3, 80, 269, 349},
    {0xCE4, 0xCE5, 80, 252, 345},
    {0xCE6, 0xCEF, 80, 269, 356},
    {0xCF0, 0xCF0, 80, 252, 345},
    {0xCF1, 0xCF2, 80, 253, 345},
    {0xCF3, 0xCFF, 80, 252, 345},
    {0xD00, 0xD01, 81, 252, 345},
    {0xD02, 0xD03, 81, 270, 349},
    {0xD04, 0xD04, 81, 252, 345},
    {0xD05, 0xD0C, 81, 270, 352},
    {0xD0D, 0xD0D, 81, 252, 345},
    {0xD0E, 0xD10, 81, 270, 352},
    {0xD11, 0xD11, 81, 252, 345},
    {0xD12, 0xD28, 81, 270, 352},
    {0xD29, 0xD29, 81, 252, 345},
    {0xD2A, 0xD39, 81, 270, 352},
    {0xD3A, 0xD3C, 81, 252, 345},
    {0xD3D, 0xD3D, 81, 270, 352},
    {0xD3E, 0xD44, 81, 270, 349},
    {0xD45, 0xD45, 81, 252, 345},
    {0xD46, 0xD48, 81, 270, 349},
    {0xD49, 0xD49, 81, 252, 345},
    {0xD4A, 0xD4D, 81, 270, 349},
    {0xD4E, 0xD56, 81, 252, 345},
    {0xD57, 0xD57, 81, 270, 349},
    {0xD58, 0xD5F, 81, 252, 345},
    {0xD60, 0xD61, 81, 270, 352},
    {0xD62, 0xD63, 81, 270, 349},
    {0xD64, 0xD65, 81, 252, 345},
    {0xD66, 0xD6F, 81, 270, 356},
    {0xD70, 0xD75, 81, 270, 345},
    {0xD76, 0xD78, 81, 252, 345},
    {0xD79, 0xD79, 81, 270, 345},
    {0xD7A, 0xD7F, 81, 270, 352},
    {0xD80, 0xD81, 82, 252, 345},
    {0xD82, 0xD83, 82, 271, 349},
    {0xD84, 0xD84, 82, 252, 345},
    {0xD85, 0xD96, 82, 271, 352},
    {0xD97, 0xD99, 82, 252, 345},
    {0xD9A, 0xDB1, 82, 271, 352},
    {0xDB2, 0xDB2, 82, 252, 345},
    {0xDB3, 0xDBB, 82, 271, 352},
    {0xDBC, 0xDBC, 82, 252, 345},
    {0xDBD, 0xDBD, 82, 271, 352},
    {0xDBE, 0xDBF, 82, 252, 345},
    {0xDC0, 0xDC6, 82, 271, 352},
    {0xDC7, 0xDC9, 82, 252, 345},
    {0xDCA, 0xDCA, 82, 271, 349},
    {0xDCB, 0xDCE, 82, 252, 345},
    {0xDCF, 0xDD4, 82, 271, 349},
    {0xDD5, 0xDD5, 82, 252, 345},
    {0xDD6, 0xDD6, 82, 271, 349},
    {0xDD7, 0xDD7, 82, 252, 345},
    {0xDD8, 0xDDF, 82, 271, 349},
    {0xDE0, 0xDF1, 82, 252, 345},
    {0xDF2, 0xDF3, 82, 271, 349},
    {0xDF4, 0xDF4, 82, 271, 345},
    {0xDF5, 0xDFF, 82, 252, 345},
    {0xE00, 0xE00, 83, 252, 345},
    {0xE01, 0xE30, 83, 272, 345},
    {0xE31, 0xE31, 83, 272, 349},
    {0xE32, 0xE33, 83, 272, 345},
    {0xE34, 0xE3A, 83, 272, 349},
    {0xE3B, 0xE3E, 83, 252, 345},
    {0xE3F, 0xE3F, 83, 253, 345},
    {0xE40, 0xE46, 83, 272, 345},
    {0xE47, 0xE4E, 83, 272, 349},
    {0xE4F, 0xE4F, 83, 272, 345},
    {0xE50, 0xE59, 83, 272, 356},
    {0xE5A, 0xE5B, 83, 272, 345},
    {0xE5C, 0xE7F, 83, 252, 345},
    {0xE80, 0xE80, 84, 252, 345},
    {0xE81, 0xE82, 84, 273, 345},
    {0xE83, 0xE83, 84, 252, 345},
    {0xE84, 0xE84, 84, 273, 345},
    {0xE85, 0xE86, 84, 252, 345},
    {0xE87, 0xE88, 84, 273, 345},
    {0xE89, 0xE89, 84, 252, 345},
    {0xE8A, 0xE8A, 84, 273, 345},
    {0xE8B, 0xE8C, 84, 252, 345},
    {0xE8D, 0xE8D, 84, 273, 345},
    {0xE8E, 0xE93, 84, 252, 345},
    {0xE94, 0xE97, 84, 273, 345},
    {0xE98, 0xE98, 84, 252, 345},
    {0xE99, 0xE9F, 84, 273, 345},
    {0xEA0, 0xEA0, 84, 252, 345},
    {0xEA1, 0xEA3, 84, 273, 345},
    {0xEA4, 0xEA4, 84, 252, 345},
    {0xEA5, 0xEA5, 84, 273, 345},
    {0xEA6, 0xEA6, 84, 252, 345},
    {0xEA7, 0xEA7, 84, 273, 345},
    {0xEA8, 0xEA9, 84, 252, 345},
    {0xEAA, 0xEAB, 84, 273, 345},
    {0xEAC, 0xEAC, 84, 252, 345},
    {0xEAD, 0xEB0, 84, 273, 345},
    {0xEB1, 0xEB1, 84, 273, 349},
    {0xEB2, 0xEB3, 84, 273, 345},
    {0xEB4, 0xEB9, 84, 273, 349},
    {0xEBA, 0xEBA, 84, 252, 345},
    {0xEBB, 0xEBC, 84, 273, 349},
    {0xEBD, 0xEBD, 84, 273, 345},
    {0xEBE, 0xEBF, 84, 252, 345},
    {0xEC0, 0xEC4, 84, 273, 345},
    {0xEC5, 0xEC5, 84, 252, 345},
    {0xEC6, 0xEC6, 84, 273, 345},
    {0xEC7, 0xEC7, 84, 252, 345},
    {0xEC8, 0xECD, 84, 273, 349},
    {0xECE, 0xECF, 84, 252, 345},
    {0xED0, 0xED9, 84, 273, 356},
    {0xEDA, 0xEDB, 84, 252, 345},
    {0xEDC, 0xEDD, 84, 273, 345},
    {0xEDE, 0xEFF, 84, 252, 345},
    {0xF00, 0xF00, 85, 274, 352},
    {0xF01, 0xF17, 85, 274, 345},
    {0xF18, 0xF19, 85, 274, 349},
    {0xF1A, 0xF1F, 85, 274, 345},
    {0xF20, 0xF29, 85, 274, 356},
    {0xF2A, 0xF34, 85, 274, 345},
    {0xF35, 0xF35, 85, 274, 349},
    {0xF36, 0xF36, 85, 274, 345},
    {0xF37, 0xF37, 85, 274, 349},
    {0xF38, 0xF38, 85, 274, 345},
    {0xF39, 0xF39, 85, 274, 349},
    {0xF3A, 0xF3D, 85, 274, 345},
    {0xF3E, 0xF3F, 85, 274, 349},
    {0xF40, 0xF47, 85, 274, 352},
    {0xF48, 0xF48, 85, 252, 345},
    {0xF49, 0xF6C, 85, 274, 352},
    {0xF6D, 0xF70, 85, 252, 345},
    {0xF71, 0xF84, 85, 274, 349},
    {0xF85, 0xF85, 85, 274, 345},
    {0xF86, 0xF87, 85, 274, 349},
    {0xF88, 0xF8B, 85, 274, 352},
    {0xF8C, 0xF8F, 85, 252, 345},
    {0xF90, 0xF97, 85, 274, 349},
    {0xF98, 0xF98, 85, 252, 345},
    {0xF99, 0xFBC, 85, 274, 349},
    {0xFBD, 0xFBD, 85, 252, 345},
    {0xFBE, 0xFC5, 85, 274, 345},
    {0xFC6, 0xFC6, 85, 274, 349},
    {0xFC7, 0xFCC, 85, 274, 345},
    {0xFCD, 0xFCD, 85, 252, 345},
    {0xFCE, 0xFD4, 85, 274, 345},
    {0xFD5, 0xFD8, 85, 253, 345},
    {0xFD9, 0xFFF, 85, 252, 345},
    {0x1000, 0x102A, 86, 275, 345},
    {0x102B, 0x103E, 86, 275, 349},
    {0x103F, 0x103F, 86, 275, 345},
    {0x1040, 0x1049, 86, 275, 356},
    {0x104A, 0x1055, 86, 275, 345},
    {0x1056, 0x1059, 86, 275, 349},
    {0x105A, 0x105D, 86, 275, 345},
    {0x105E, 0x1060, 86, 275, 349},
    {0x1061, 0x1061, 86, 275, 345},
    {0x1062, 0x1064, 86, 275, 349},
    {0x1065, 0x1066, 86, 275, 345},
    {0x1067, 0x106D, 86, 275, 349},
    {0x106E, 0x1070, 86, 275, 345},
    {0x1071, 0x1074, 86, 275, 349},
    {0x1075, 0x1081, 86, 275, 345},
    {0x1082, 0x108D, 86, 275, 349},
    {0x108E, 0x108E, 86, 275, 345},
    {0x108F, 0x108F, 86, 275, 349},
    {0x1090, 0x1099, 86, 275, 356},
    {0x109A, 0x109D, 86, 275, 349},
    {0x109E, 0x109F, 86, 275, 345},
    {0x10A0, 0x10C5, 87, 276, 352},
    {0x10C6, 0x10CF, 87, 252, 345},
    {0x10D0, 0x10FA, 87, 276, 352},
    {0x10FB, 0x10FB, 87, 253, 345},
    {0x10FC, 0x10FC, 87, 276, 352},
    {0x10FD, 0x10FF, 87, 252, 345},
    {0x1100, 0x11FF, 88, 277, 352},
    {0x1200, 0x1248, 89, 278, 352},
    {0x1249, 0x1249, 89, 252, 345},
    {0x124A, 0x124D, 89, 278, 352},
    {0x124E, 0x124F, 89, 252, 345},
    {0x1250, 0x1256, 89, 278, 352},
    {0x1257, 0x1257, 89, 252, 345},
    {0x1258, 0x1258, 89, 278, 352},
    {0x1259, 0x1259, 89, 252, 345},
    {0x125A, 0x125D, 89, 278, 352},
    {0x125E, 0x125F, 89, 252, 345},
    {0x1260, 0x1288, 89, 278, 352},
    {0x1289, 0x1289, 89, 252, 345},
    {0x128A, 0x128D, 89, 278, 352},
    {0x128E, 0x128F, 89, 252, 345},
    {0x1290, 0x12B0, 89, 278, 352},
    {0x12B1, 0x12B1, 89, 252, 345},
    {0x12B2, 0x12B5, 89, 278, 352},
    {0x12B6, 0x12B7, 89, 252, 345},
    {0x12B8, 0x12BE, 89, 278, 352},
    {0x12BF, 0x12BF, 89, 252, 345},
    {0x12C0, 0x12C0, 89, 278, 352},
    {0x12C1, 0x12C1, 89, 252, 345},
    {0x12C2, 0x12C5, 89, 278, 352},
    {0x12C6, 0x12C7, 89, 252, 345},
    {0x12C8, 0x12D6, 89, 278, 352},
    {0x12D7, 0x12D7, 89, 252, 345},
    {0x12D8, 0x1310, 89, 278, 352},
    {0x1311, 0x1311, 89, 252, 345},
    {0x1312, 0x1315, 89, 278, 352},
    {0x1316, 0x1317, 89, 252, 345},
    {0x1318, 0x135A, 89, 278, 352},
    {0x135B, 0x135E, 89, 252, 345},
    {0x135F, 0x135F, 89, 278, 349},
    {0x1360, 0x137C, 89, 278, 345},
    {0x137D, 0x137F, 89, 252, 345},
    {0x1380, 0x138F, 90, 278, 352},
    {0x1390, 0x1399, 90, 278, 345},
    {0x139A, 0x139F, 90, 252, 345},
    {0x13A0, 0x13F4, 91, 279, 352},
    {0x13F5, 0x13FF, 91, 252, 345},
    {0x1400, 0x1400, 92, 280, 345},
    {0x1401, 0x166C, 92, 280, 352},
    {0x166D, 0x166E, 92, 280, 345},
    {0x166F, 0x167F, 92, 280, 352},
    {0x1680, 0x1680, 93, 281, 345},
    {0x1681, 0x169A, 93, 281, 352},
    {0x169B, 0x169C, 93, 281, 345},
    {0x169D, 0x169F, 93, 252, 345},
    {0x16A0, 0x16EA, 94, 282, 352},
    {0x16EB, 0x16ED, 94, 253, 345},
    {0x16EE, 0x16F0, 94, 282, 352},
    {0x16F1, 0x16FF, 94, 252, 345},
    {0x1700, 0x170C, 95, 294, 352},
    {0x170D, 0x170D, 95, 252, 345},
    {0x170E, 0x1711, 95, 294, 352},
    {0x1712, 0x1714, 95, 294, 349},
    {0x1715, 0x171F, 95, 252, 345},
    {0x1720, 0x1731, 96, 295, 352},
    {0x1732, 0x1734, 96, 295, 349},
    {0x1735, 0x1736, 96, 253, 345},
    {0x1737, 0x173F, 96, 252, 345},
    {0x1740, 0x1751, 97, 296, 352},
    {0x1752, 0x1753, 97, 296, 349},
    {0x1754, 0x175F, 97, 252, 345},
    {0x1760, 0x176C, 98, 297, 352},
    {0x176D, 0x176D, 98, 252, 345},
    {0x176E, 0x1770, 98, 297, 352},
    {0x1771, 0x1771, 98, 252, 345},
    {0x1772, 0x1773, 98, 297, 349},
    {0x1774, 0x177F, 98, 252, 345},
    {0x1780, 0x17B3, 99, 283, 345},
    {0x17B4, 0x17B5, 99, 283, 350},
    {0x17B6, 0x17D3, 99, 283, 349},
    {0x17D4, 0x17DC, 99, 283, 345},
    {0x17DD, 0x17DD, 99, 283, 349},
    {0x17DE, 0x17DF, 99, 252, 345},
    {0x17E0, 0x17E9, 99, 283, 356},
    {0x17EA, 0x17EF, 99, 252, 345},
    {0x17F0, 0x17F9, 99, 283, 345},
    {0x17FA, 0x17FF, 99, 252, 345},
    {0x1800, 0x1801, 100, 284, 345},
    {0x1802, 0x1803, 100, 253, 345},
    {0x1804, 0x1804, 100, 284, 345},
    {0x1805, 0x1805, 100, 253, 345},
    {0x1806, 0x180A, 100, 284, 345},
    {0x180B, 0x180D, 100, 284, 349},
    {0x180E, 0x180E, 100, 284, 345},
    {0x180F, 0x180F, 100, 252, 345},
    {0x1810, 0x1819, 100, 284, 356},
    {0x181A, 0x181F, 100, 252, 345},
    {0x1820, 0x1877, 100, 284, 352},
    {0x1878, 0x187F, 100, 252, 345},
    {0x1880, 0x18A8, 100, 284, 352},
    {0x18A9, 0x18A9, 100, 284, 349},
    {0x18AA, 0x18AA, 100, 284, 352},
    {0x18AB, 0x18AF, 100, 252, 345},
    {0x18B0, 0x18F5, 101, 280, 352},
    {0x18F6, 0x18FF, 101, 252, 345},
    {0x1900, 0x191C, 102, 298, 352},
    {0x191D, 0x191F, 102, 252, 345},
    {0x1920, 0x192B, 102, 298, 349},
    {0x192C, 0x192F, 102, 252, 345},
    {0x1930, 0x193B, 102, 298, 349},
    {0x193C, 0x193F, 102, 252, 345},
    {0x1940, 0x1940, 102, 298, 345},
    {0x1941, 0x1943, 102, 252, 345},
    {0x1944, 0x1945, 102, 298, 345},
    {0x1946, 0x194F, 102, 298, 356},
    {0x1950, 0x196D, 103, 299, 345},
    {0x196E, 0x196F, 103, 252, 345},
    {0x1970, 0x1974, 103, 299, 345},
    {0x1975, 0x197F, 103, 252, 345},
    {0x1980, 0x19AB, 104, 308, 345},
    {0x19AC, 0x19AF, 104, 252, 345},
    {0x19B0, 0x19C0, 104, 308, 349},
    {0x19C1, 0x19C7, 104, 308, 345},
    {0x19C8, 0x19C9, 104, 308, 349},
    {0x19CA, 0x19CF, 104, 252, 345},
    {0x19D0, 0x19DA, 104, 308, 356},
    {0x19DB, 0x19DD, 104, 252, 345},
    {0x19DE, 0x19DF, 104, 308, 345},
    {0x19E0, 0x19FF, 105, 283, 345},
    {0x1A00, 0x1A16, 106, 306, 352},
    {0x1A17, 0x1A1B, 106, 306, 349},
    {0x1A1C, 0x1A1D, 106, 252, 345},
    {0x1A1E, 0x1A1F, 106, 306, 345},
    {0x1A20, 0x1A54, 107, 330, 345},
    {0x1A55, 0x1A5E, 107, 330, 349},
    {0x1A5F, 0x1A5F, 107, 252, 345},
    {0x1A60, 0x1A7C, 107, 330, 349},
    {0x1A7D, 0x1A7E, 107, 252, 345},
    {0x1A7F, 0x1A7F, 107, 330, 349},
    {0x1A80, 0x1A89, 107, 330, 356},
    {0x1A8A, 0x1A8F, 107, 252, 345},
    {0x1A90, 0x1A99, 107, 330, 356},
    {0x1A9A, 0x1A9F, 107, 252, 345},
    {0x1AA0, 0x1AAD, 107, 330, 345},
    {0x1AAE, 0x1AAF, 107, 252, 345},
    {0x1AB0, 0x1AFF, 54, 252, 345},
    {0x1B00, 0x1B04, 108, 314, 349},
    {0x1B05, 0x1B33, 108, 314, 352},
    {0x1B34, 0x1B44, 108, 314, 349},
    {0x1B45, 0x1B4B, 108, 314, 352},
    {0x1B4C, 0x1B4F, 108, 252, 345},
    {0x1B50, 0x1B59, 108, 314, 356},
    {0x1B5A, 0x1B6A, 108, 314, 345},
    {0x1B6B, 0x1B73, 108, 314, 349},
    {0x1B74, 0x1B7C, 108, 314, 345},
    {0x1B7D, 0x1B7F, 108, 252, 345},
    {0x1B80, 0x1B82, 109, 319, 349},
    {0x1B83, 0x1BA0, 109, 319, 352},
    {0x1BA1, 0x1BAA, 109, 319, 349},
    {0x1BAB, 0x1BAD, 109, 252, 345},
    {0x1BAE, 0x1BAF, 109, 319, 352},
    {0x1BB0, 0x1BB9, 109, 319, 356},
    {0x1BBA, 0x1BBF, 109, 252, 345},
    {0x1BC0, 0x1BFF, 54, 252, 345},
    {0x1C00, 0x1C23, 110, 320, 352},
    {0x1C24, 0x1C37, 110, 320, 349},
    {0x1C38, 0x1C3A, 110, 252, 345},
    {0x1C3B, 0x1C3F, 110, 320, 345},
    {0x1C40, 0x1C49, 110, 320, 356},
    {0x1C4A, 0x1C4C, 110, 252, 345},
    {0x1C4D, 0x1C4F, 110, 320, 352},
    {0x1C50, 0x1C59, 111, 321, 356},
    {0x1C5A, 0x1C7D, 111, 321, 352},
    {0x1C7E, 0x1C7F, 111, 321, 345},
    {0x1C80, 0x1CCF, 54, 252, 345},
    {0x1CD0, 0x1CD2, 112, 293, 349},
    {0x1CD3, 0x1CD3, 112, 253, 345},
    {0x1CD4, 0x1CE0, 112, 293, 349},
    {0x1CE1, 0x1CE1, 112, 253, 349},
    {0x1CE2, 0x1CE8, 112, 293, 349},
    {0x1CE9, 0x1CEC, 112, 253, 352},
    {0x1CED, 0x1CED, 112, 293, 349},
    {0x1CEE, 0x1CF1, 112, 253, 352},
    {0x1CF2, 0x1CF2, 112, 253, 349},
    {0x1CF3, 0x1CFF, 112, 252, 345},
    {0x1D00, 0x1D25, 113, 254, 352},
    {0x1D26, 0x1D2A, 113, 255, 352},
    {0x1D2B, 0x1D2B, 113, 256, 352},
    {0x1D2C, 0x1D5C, 113, 254, 352},
    {0x1D5D, 0x1D61, 113, 255, 352},
    {0x1D62, 0x1D65, 113, 254, 352},
    {0x1D66, 0x1D6A, 113, 255, 352},
    {0x1D6B, 0x1D77, 113, 254, 352},
    {0x1D78, 0x1D78, 113, 256, 352},
    {0x1D79, 0x1D7F, 113, 254, 352},
    {0x1D80, 0x1DBE, 114, 254, 352},
    {0x1DBF, 0x1DBF, 114, 255, 352},
    {0x1DC0, 0x1DE6, 115, 293, 349},
    {0x1DE7, 0x1DFC, 115, 252, 345},
    {0x1DFD, 0x1DFF, 115, 293, 349},
    {0x1E00, 0x1EFF, 116, 254, 352},
    {0x1F00, 0x1F15, 117, 255, 352},
    {0x1F16, 0x1F17, 117, 252, 345},
    {0x1F18, 0x1F1D, 117, 255, 352},
    {0x1F1E, 0x1F1F, 117, 252, 345},
    {0x1F20, 0x1F45, 117, 255, 352},
    {0x1F46, 0x1F47, 117, 252, 345},
    {0x1F48, 0x1F4D, 117, 255, 352},
    {0x1F4E, 0x1F4F, 117, 252, 345},
    {0x1F50, 0x1F57, 117, 255, 352},
    {0x1F58, 0x1F58, 117, 252, 345},
    {0x1F59, 0x1F59, 117, 255, 352},
    {0x1F5A, 0x1F5A, 117, 252, 345},
    {0x1F5B, 0x1F5B, 117, 255, 352},
    {0x1F5C, 0x1F5C, 117, 252, 345},
    {0x1F5D, 0x1F5D, 117, 255, 352},
    {0x1F5E, 0x1F5E, 117, 252, 345},
    {0x1F5F, 0x1F7D, 117, 255, 352},
    {0x1F7E, 0x1F7F, 117, 252, 345},
    {0x1F80, 0x1FB4, 117, 255, 352},
    {0x1FB5, 0x1FB5, 117, 252, 345},
    {0x1FB6, 0x1FBC, 117, 255, 352},
    {0x1FBD, 0x1FBD, 117, 255, 345},
    {0x1FBE, 0x1FBE, 117, 255, 352},
    {0x1FBF, 0x1FC1, 117, 255, 345},
    {0x1FC2, 0x1FC4, 117, 255, 352},
    {0x1FC5, 0x1FC5, 117, 252, 345},
    {0x1FC6, 0x1FCC, 117, 255, 352},
    {0x1FCD, 0x1FCF, 117, 255, 345},
    {0x1FD0, 0x1FD3, 117, 255, 352},
    {0x1FD4, 0x1FD5, 117, 252, 345},
    {0x1FD6, 0x1FDB, 117, 255, 352},
    {0x1FDC, 0x1FDC, 117, 252, 345},
    {0x1FDD, 0x1FDF, 117, 255, 345},
    {0x1FE0, 0x1FEC, 117, 255, 352},
    {0x1FED, 0x1FEF, 117, 255, 345},
    {0x1FF0, 0x1FF1, 117, 252, 345},
    {0x1FF2, 0x1FF4, 117, 255, 352},
    {0x1FF5, 0x1FF5, 117, 252, 345},
    {0x1FF6, 0x1FFC, 117, 255, 352},
    {0x1FFD, 0x1FFE, 117, 255, 345},
    {0x1FFF, 0x1FFF, 117, 252, 345},
    {0x2000, 0x200B, 118, 253, 345},
    {0x200C, 0x200D, 118, 293, 349},
    {0x200E, 0x200F, 118, 253, 350},
    {0x2010, 0x2017, 118, 253, 345},
    {0x2018, 0x2019, 118, 253, 355},
    {0x201A, 0x2023, 118, 253, 345},
    {0x2024, 0x2024, 118, 253, 355},
    {0x2025, 0x2026, 118, 253, 345},
    {0x2027, 0x2027, 118, 253, 353},
    {0x2028, 0x2029, 118, 253, 348},
    {0x202A, 0x202E, 118, 253, 350},
    {0x202F, 0x203E, 118, 253, 345},
    {0x203F, 0x2040, 118, 253, 357},
    {0x2041, 0x2043, 118, 253, 345},
    {0x2044, 0x2044, 118, 253, 354},
    {0x2045, 0x2053, 118, 253, 345},
    {0x2054, 0x2054, 118, 253, 357},
    {0x2055, 0x205F, 118, 253, 345},
    {0x2060, 0x2064, 118, 253, 350},
    {0x2065, 0x2069, 118, 252, 345},
    {0x206A, 0x206F, 118, 253, 350},
    {0x2070, 0x2070, 119, 253, 345},
    {0x2071, 0x2071, 119, 254, 352},
    {0x2072, 0x2073, 119, 252, 345},
    {0x2074, 0x207E, 119, 253, 345},
    {0x207F, 0x207F, 119, 254, 352},
    {0x2080, 0x208E, 119, 253, 345},
    {0x208F, 0x208F, 119, 252, 345},
    {0x2090, 0x2094, 119, 254, 352},
    {0x2095, 0x209F, 119, 252, 345},
    {0x20A0, 0x20B8, 120, 253, 345},
    {0x20B9, 0x20CF, 120, 252, 345},
    {0x20D0, 0x20F0, 121, 293, 349},
    {0x20F1, 0x20FF, 121, 252, 345},
    {0x2100, 0x2101, 122, 253, 345},
    {0x2102, 0x2102, 122, 253, 352},
    {0x2103, 0x2106, 122, 253, 345},
    {0x2107, 0x2107, 122, 253, 352},
    {0x2108, 0x2109, 122, 253, 345},
    {0x210A, 0x2113, 122, 253, 352},
    {0x2114, 0x2114, 122, 253, 345},
    {0x2115, 0x2115, 122, 253, 352},
    {0x2116, 0x2118, 122, 253, 345},
    {0x2119, 0x211D, 122, 253, 352},
    {0x211E, 0x2123, 122, 253, 345},
    {0x2124, 0x2124, 122, 253, 352},
    {0x2125, 0x2125, 122, 253, 345},
    {0x2126, 0x2126, 122, 255, 352},
    {0x2127, 0x2127, 122, 253, 345},
    {0x2128, 0x2128, 122, 253, 352},
    {0x2129, 0x2129, 122, 253, 345},
    {0x212A, 0x212B, 122, 254, 352},
    {0x212C, 0x212D, 122, 253, 352},
    {0x212E, 0x212E, 122, 253, 345},
    {0x212F, 0x2131, 122, 253, 352},
    {0x2132, 0x2132, 122, 254, 352},
    {0x2133, 0x2139, 122, 253, 352},
    {0x213A, 0x213B, 122, 253, 345},
    {0x213C, 0x213F, 122, 253, 352},
    {0x2140, 0x2144, 122, 253, 345},
    {0x2145, 0x2149, 122, 253, 352},
    {0x214A, 0x214D, 122, 253, 345},
    {0x214E, 0x214E, 122, 254, 352},
    {0x214F, 0x214F, 122, 253, 345},
    {0x2150, 0x215F, 123, 253, 345},
    {0x2160, 0x2188, 123, 254, 352},
    {0x2189, 0x2189, 123, 253, 345},
    {0x218A, 0x218F, 123, 252, 345},
    {0x2190, 0x21FF, 124, 253, 345},
    {0x2200, 0x22FF, 125, 253, 345},
    {0x2300, 0x23E8, 126, 253, 345},
    {0x23E9, 0x23FF, 126, 252, 345},
    {0x2400, 0x2426, 127, 253, 345},
    {0x2427, 0x243F, 127, 252, 345},
    {0x2440, 0x244A, 128, 253, 345},
    {0x244B, 0x245F, 128, 252, 345},
    {0x2460, 0x24B5, 129, 253, 345},
    {0x24B6, 0x24E9, 129, 253, 352},
    {0x24EA, 0x24FF, 129, 253, 345},
    {0x2500, 0x257F, 130, 253, 345},
    {0x2580, 0x259F, 131, 253, 345},
    {0x25A0, 0x25FF, 132, 253, 345},
    {0x2600, 0x26CD, 133, 253, 345},
    {0x26CE, 0x26CE, 133, 252, 345},
    {0x26CF, 0x26E1, 133, 253, 345},
    {0x26E2, 0x26E2, 133, 252, 345},
    {0x26E3, 0x26E3, 133, 253, 345},
    {0x26E4, 0x26E7, 133, 252, 345},
    {0x26E8, 0x26FF, 133, 253, 345},
    {0x2700, 0x2700, 134, 252, 345},
    {0x2701, 0x2704, 134, 253, 345},
    {0x2705, 0x2705, 134, 252, 345},
    {0x2706, 0x2709, 134, 253, 345},
    {0x270A, 0x270B, 134, 252, 345},
    {0x270C, 0x2727, 134, 253, 345},
    {0x2728, 0x2728, 134, 252, 345},
    {0x2729, 0x274B, 134, 253, 345},
    {0x274C, 0x274C, 134, 252, 345},
    {0x274D, 0x274D, 134, 253, 345},
    {0x274E, 0x274E, 134, 252, 345},
    {0x274F, 0x2752, 134, 253, 345},
    {0x2753, 0x2755, 134, 252, 345},
    {0x2756, 0x275E, 134, 253, 345},
    {0x275F, 0x2760, 134, 252, 345},
    {0x2761, 0x2794, 134, 253, 345},
    {0x2795, 0x2797, 134, 252, 345},
    {0x2798, 0x27AF, 134, 253, 345},
    {0x27B0, 0x27B0, 134, 252, 345},
    {0x27B1, 0x27BE, 134, 253, 345},
    {0x27BF, 0x27BF, 134, 252, 345},
    {0x27C0, 0x27CA, 135, 253, 345},
    {0x27CB, 0x27CB, 135, 252, 345},
    {0x27CC, 0x27CC, 135, 253, 345},
    {0x27CD, 0x27CF, 135, 252, 345},
    {0x27D0, 0x27EF, 135, 253, 345},
    {0x27F0, 0x27FF, 136, 253, 345},
    {0x2800, 0x28FF, 137, 305, 345},
    {0x2900, 0x297F, 138, 253, 345},
    {0x2980, 0x29FF, 139, 253, 345},
    {0x2A00, 0x2AFF, 140, 253, 345},
    {0x2B00, 0x2B4C, 141, 253, 345},
    {0x2B4D, 0x2B4F, 141, 252, 345},
    {0x2B50, 0x2B59, 141, 253, 345},
    {0x2B5A, 0x2BFF, 141, 252, 345},
    {0x2C00, 0x2C2E, 142, 309, 352},
    {0x2C2F, 0x2C2F, 142, 252, 345},
    {0x2C30, 0x2C5E, 142, 309, 352},
    {0x2C5F, 0x2C5F, 142, 252, 345},
    {0x2C60, 0x2C7F, 143, 254, 352},
    {0x2C80, 0x2CE4, 144, 307, 352},
    {0x2CE5, 0x2CEA, 144, 307, 345},
    {0x2CEB, 0x2CEE, 144, 307, 352},
    {0x2CEF, 0x2CF1, 144, 307, 349},
    {0x2CF2, 0x2CF8, 144, 252, 345},
    {0x2CF9, 0x2CFF, 144, 307, 345},
    {0x2D00, 0x2D25, 145, 276, 352},
    {0x2D26, 0x2D2F, 145, 252, 345},
    {0x2D30, 0x2D65, 146, 310, 352},
    {0x2D66, 0x2D6E, 146, 252, 345},
    {0x2D6F, 0x2D6F, 146, 310, 352},
    {0x2D70, 0x2D7F, 146, 252, 345},
    {0x2D80, 0x2D96, 147, 278, 352},
    {0x2D97, 0x2D9F, 147, 252, 345},
    {0x2DA0, 0x2DA6, 147, 278, 352},
    {0x2DA7, 0x2DA7, 147, 252, 345},
    {0x2DA8, 0x2DAE, 147, 278, 352},
    {0x2DAF, 0x2DAF, 147, 252, 345},
    {0x2DB0, 0x2DB6, 147, 278, 352},
    {0x2DB7, 0x2DB7, 147, 252, 345},
    {0x2DB8, 0x2DBE, 147, 278, 352},
    {0x2DBF, 0x2DBF, 147, 252, 345},
    {0x2DC0, 0x2DC6, 147, 278, 352},
    {0x2DC7, 0x2DC7, 147, 252, 345},
    {0x2DC8, 0x2DCE, 147, 278, 352},
    {0x2DCF, 0x2DCF, 147, 252, 345},
    {0x2DD0, 0x2DD6, 147, 278, 352},
    {0x2DD7, 0x2DD7, 147, 252, 345},
    {0x2DD8, 0x2DDE, 147, 278, 352},
    {0x2DDF, 0x2DDF, 147, 252, 345},
    {0x2DE0, 0x2DFF, 148, 256, 349},
    {0x2E00, 0x2E2E, 149, 253, 345},
    {0x2E2F, 0x2E2F, 149, 253, 352},
    {0x2E30, 0x2E31, 149, 253, 345},
    {0x2E32, 0x2E7F, 149, 252, 345},
    {0x2E80, 0x2E99, 150, 288, 345},
    {0x2E9A, 0x2E9A, 150, 252, 345},
    {0x2E9B, 0x2EF3, 150, 288, 345},
    {0x2EF4, 0x2EFF, 150, 252, 345},
    {0x2F00, 0x2FD5, 151, 288, 345},
    {0x2FD6, 0x2FDF, 151, 252, 345},
    {0x2FE0, 0x2FEF, 54, 252, 345},
    {0x2FF0, 0x2FFB, 152, 253, 345},
    {0x2FFC, 0x2FFF, 152, 252, 345},
    {0x3000, 0x3004, 153, 253, 345},
    {0x3005, 0x3005, 153, 288, 352},
    {0x3006, 0x3006, 153, 253, 345},
    {0x3007, 0x3007, 153, 288, 345},
    {0x3008, 0x3020, 153, 253, 345},
    {0x3021, 0x3029, 153, 288, 345},
    {0x302A, 0x302F, 153, 293, 349},
    {0x3030, 0x3030, 153, 253, 345},
    {0x3031, 0x3035, 153, 253, 351},
    {0x3036, 0x3037, 153, 253, 345},
    {0x3038, 0x303A, 153, 288, 345},
    {0x303B, 0x303B, 153, 288, 352},
    {0x303C, 0x303C, 153, 253, 352},
    {0x303D, 0x303F, 153, 253, 345},
    {0x3040, 0x3040, 154, 252, 345},
    {0x3041, 0x3096, 154, 285, 345},
    {0x3097, 0x3098, 154, 252, 345},
    {0x3099, 0x309A, 154, 293, 349},
    {0x309B, 0x309C, 154, 253, 351},
    {0x309D, 0x309F, 154, 285, 345},
    {0x30A0, 0x30A0, 155, 253, 351},
    {0x30A1, 0x30FA, 155, 286, 351},
    {0x30FB, 0x30FB, 155, 253, 345},
    {0x30FC, 0x30FC, 155, 253, 351},
    {0x30FD, 0x30FF, 155, 286, 351},
    {0x3100, 0x3104, 156, 252, 345},
    {0x3105, 0x312D, 156, 287, 352},
    {0x312E, 0x312F, 156, 252, 345},
    {0x3130, 0x3130, 157, 252, 345},
    {0x3131, 0x318E, 157, 277, 352},
    {0x318F, 0x318F, 157, 252, 345},
    {0x3190, 0x319F, 158, 253, 345},
    {0x31A0, 0x31B7, 159, 287, 352},
    {0x31B8, 0x31BF, 159, 252, 345},
    {0x31C0, 0x31E3, 160, 253, 345},
    {0x31E4, 0x31EF, 160, 252, 345},
    {0x31F0, 0x31FF, 161, 286, 351},
    {0x3200, 0x321E, 162, 277, 345},
    {0x321F, 0x321F, 162, 252, 345},
    {0x3220, 0x325F, 162, 253, 345},
    {0x3260, 0x327E, 162, 277, 345},
    {0x327F, 0x32CF, 162, 253, 345},
    {0x32D0, 0x32FE, 162, 286, 351},
    {0x32FF, 0x32FF, 162, 252, 345},
    {0x3300, 0x3357, 163, 286, 351},
    {0x3358, 0x33FF, 163, 253, 345},
    {0x3400, 0x4DB5, 164, 288, 345},
    {0x4DB6, 0x4DBF, 164, 252, 345},
    {0x4DC0, 0x4DFF, 165, 253, 345},
    {0x4E00, 0x9FCB, 166, 288, 345},
    {0x9FCC, 0x9FFF, 166, 252, 345},
    {0xA000, 0xA48C, 167, 289, 352},
    {0xA48D, 0xA48F, 167, 252, 345},
    {0xA490, 0xA4C6, 168, 289, 345},
    {0xA4C7, 0xA4CF, 168, 252, 345},
    {0xA4D0, 0xA4FD, 169, 335, 352},
    {0xA4FE, 0xA4FF, 169, 335, 345},
    {0xA500, 0xA60C, 170, 322, 352},
    {0xA60D, 0xA60F, 170, 322, 345},
    {0xA610, 0xA61F, 170, 322, 352},
    {0xA620, 0xA629, 170, 322, 356},
    {0xA62A, 0xA62B, 170, 322, 352},
    {0xA62C, 0xA63F, 170, 252, 345},
    {0xA640, 0xA65F, 171, 256, 352},
    {0xA660, 0xA661, 171, 252, 345},
    {0xA662, 0xA66E, 171, 256, 352},
    {0xA66F, 0xA672, 171, 256, 349},
    {0xA673, 0xA673, 171, 256, 345},
    {0xA674, 0xA67B, 171, 252, 345},
    {0xA67C, 0xA67D, 171, 256, 349},
    {0xA67E, 0xA67E, 171, 256, 345},
    {0xA67F, 0xA697, 171, 256, 352},
    {0xA698, 0xA69F, 171, 252, 345},
    {0xA6A0, 0xA6EF, 172, 336, 352},
    {0xA6F0, 0xA6F1, 172, 336, 349},
    {0xA6F2, 0xA6F7, 172, 336, 345},
    {0xA6F8, 0xA6FF, 172, 252, 345},
    {0xA700, 0xA716, 173, 253, 345},
    {0xA717, 0xA71F, 173, 253, 352},
    {0xA720, 0xA721, 174, 253, 345},
    {0xA722, 0xA787, 174, 254, 352},
    {0xA788, 0xA788, 174, 253, 352},
    {0xA789, 0xA78A, 174, 253, 345},
    {0xA78B, 0xA78C, 174, 254, 352},
    {0xA78D, 0xA7FA, 174, 252, 345},
    {0xA7FB, 0xA7FF, 174, 254, 352},
    {0xA800, 0xA801, 175, 311, 352},
    {0xA802, 0xA802, 175, 311, 349},
    {0xA803, 0xA805, 175, 311, 352},
    {0xA806, 0xA806, 175, 311, 349},
    {0xA807, 0xA80A, 175, 311, 352},
    {0xA80B, 0xA80B, 175, 311, 349},
    {0xA80C, 0xA822, 175, 311, 352},
    {0xA823, 0xA827, 175, 311, 349},
    {0xA828, 0xA82B, 175, 311, 345},
    {0xA82C, 0xA82F, 175, 252, 345},
    {0xA830, 0xA839, 176, 253, 345},
    {0xA83A, 0xA83F, 176, 252, 345},
    {0xA840, 0xA873, 177, 317, 352},
    {0xA874, 0xA877, 177, 317, 345},
    {0xA878, 0xA87F, 177, 252, 345},
    {0xA880, 0xA881, 178, 323, 349},
    {0xA882, 0xA8B3, 178, 323, 352},
    {0xA8B4, 0xA8C4, 178, 323, 349},
    {0xA8C5, 0xA8CD, 178, 252, 345},
    {0xA8CE, 0xA8CF, 178, 323, 345},
    {0xA8D0, 0xA8D9, 178, 323, 356},
    {0xA8DA, 0xA8DF, 178, 252, 345},
    {0xA8E0, 0xA8F1, 179, 262, 349},
    {0xA8F2, 0xA8F7, 179, 262, 352},
    {0xA8F8, 0xA8FA, 179, 262, 345},
    {0xA8FB, 0xA8FB, 179, 262, 352},
    {0xA8FC, 0xA8FF, 179, 252, 345},
    {0xA900, 0xA909, 180, 324, 356},
    {0xA90A, 0xA925, 180, 324, 352},
    {0xA926, 0xA92D, 180, 324, 349},
    {0xA92E, 0xA92F, 180, 324, 345},
    {0xA930, 0xA946, 181, 325, 352},
    {0xA947, 0xA953, 181, 325, 349},
    {0xA954, 0xA95E, 181, 252, 345},
    {0xA95F, 0xA95F, 181, 325, 345},
    {0xA960, 0xA97C, 182, 277, 352},
    {0xA97D, 0xA97F, 182, 252, 345},
    {0xA980, 0xA983, 183, 337, 349},
    {0xA984, 0xA9B2, 183, 337, 352},
    {0xA9B3, 0xA9C0, 183, 337, 349},
    {0xA9C1, 0xA9CD, 183, 337, 345},
    {0xA9CE, 0xA9CE, 183, 252, 345},
    {0xA9CF, 0xA9CF, 183, 337, 352},
    {0xA9D0, 0xA9D9, 183, 337, 356},
    {0xA9DA, 0xA9DD, 183, 252, 345},
    {0xA9DE, 0xA9DF, 183, 337, 345},
    {0xA9E0, 0xA9FF, 54, 252, 345},
    {0xAA00, 0xAA28, 184, 329, 352},
    {0xAA29, 0xAA36, 184, 329, 349},
    {0xAA37, 0xAA3F, 184, 252, 345},
    {0xAA40, 0xAA42, 184, 329, 352},
    {0xAA43, 0xAA43, 184, 329, 349},
    {0xAA44, 0xAA4B, 184, 329, 352},
    {0xAA4C, 0xAA4D, 184, 329, 349},
    {0xAA4E, 0xAA4F, 184, 252, 345},
    {0xAA50, 0xAA59, 184, 329, 356},
    {0xAA5A, 0xAA5B, 184, 252, 345},
    {0xAA5C, 0xAA5F, 184, 329, 345},
    {0xAA60, 0xAA7A, 185, 275, 345},
    {0xAA7B, 0xAA7B, 185, 275, 349},
    {0xAA7C, 0xAA7F, 185, 252, 345},
    {0xAA80, 0xAAAF, 186, 331, 345},
    {0xAAB0, 0xAAB0, 186, 331, 349},
    {0xAAB1, 0xAAB1, 186, 331, 345},
    {0xAAB2, 0xAAB4, 186, 331, 349},
    {0xAAB5, 0xAAB6, 186, 331, 345},
    {0xAAB7, 0xAAB8, 186, 331, 349},
    {0xAAB9, 0xAABD, 186, 331, 345},
    {0xAABE, 0xAABF, 186, 331, 349},
    {0xAAC0, 0xAAC0, 186, 331, 345},
    {0xAAC1, 0xAAC1, 186, 331, 349},
    {0xAAC2, 0xAAC2, 186, 331, 345},
    {0xAAC3, 0xAADA, 186, 252, 345},
    {0xAADB, 0xAADF, 186, 331, 345},
    {0xAAE0, 0xABBF, 54, 252, 345},
    {0xABC0, 0xABE2, 187, 338, 352},
    {0xABE3, 0xABEA, 187, 338, 349},
    {0xABEB, 0xABEB, 187, 338, 345},
    {0xABEC, 0xABED, 187, 338, 349},
    {0xABEE, 0xABEF, 187, 252, 345},
    {0xABF0, 0xABF9, 187, 338, 356},
    {0xABFA, 0xABFF, 187, 252, 345},
    {0xAC00, 0xD7A3, 188, 277, 352},
    {0xD7A4, 0xD7AF, 188, 252, 345},
    {0xD7B0, 0xD7C6, 189, 277, 352},
    {0xD7C7, 0xD7CA, 189, 252, 345},
    {0xD7CB, 0xD7FB, 189, 277, 352},
    {0xD7FC, 0xD7FF, 189, 252, 345},
    {0xD800, 0xDB7F, 190, 252, 345},
    {0xDB80, 0xDBFF, 191, 252, 345},
    {0xDC00, 0xDFFF, 192, 252, 345},
    {0xE000, 0xF8FF, 193, 252, 345},
    {0xF900, 0xFA2D, 194, 288, 345},
    {0xFA2E, 0xFA2F, 194, 252, 345},
    {0xFA30, 0xFA6D, 194, 288, 345},
    {0xFA6E, 0xFA6F, 194, 252, 345},
    {0xFA70, 0xFAD9, 194, 288, 345},
    {0xFADA, 0xFAFF, 194, 252, 345},
    {0xFB00, 0xFB06, 195, 254, 352},
    {0xFB07, 0xFB12, 195, 252, 345},
    {0xFB13, 0xFB17, 195, 257, 352},
    {0xFB18, 0xFB1C, 195, 252, 345},
    {0xFB1D, 0xFB1D, 195, 258, 352},
    {0xFB1E, 0xFB1E, 195, 258, 349},
    {0xFB1F, 0xFB28, 195, 258, 352},
    {0xFB29, 0xFB29, 195, 258, 345},
    {0xFB2A, 0xFB36, 195, 258, 352},
    {0xFB37, 0xFB37, 195, 252, 345},
    {0xFB38, 0xFB3C, 195, 258, 352},
    {0xFB3D, 0xFB3D, 195, 252, 345},
    {0xFB3E, 0xFB3E, 195, 258, 352},
    {0xFB3F, 0xFB3F, 195, 252, 345},
    {0xFB40, 0xFB41, 195, 258, 352},
    {0xFB42, 0xFB42, 195, 252, 345},
    {0xFB43, 0xFB44, 195, 258, 352},
    {0xFB45, 0xFB45, 195, 252, 345},
    {0xFB46, 0xFB4F, 195, 258, 352},
    {0xFB50, 0xFBB1, 196, 259, 352},
    {0xFBB2, 0xFBD2, 196, 252, 345},
    {0xFBD3, 0xFD3D, 196, 259, 352},
    {0xFD3E, 0xFD3F, 196, 253, 345},
    {0xFD40, 0xFD4F, 196, 252, 345},
    {0xFD50, 0xFD8F, 196, 259, 352},
    {0xFD90, 0xFD91, 196, 252, 345},
    {0xFD92, 0xFDC7, 196, 259, 352},
    {0xFDC8, 0xFDEF, 196, 252, 345},
    {0xFDF0, 0xFDFB, 196, 259, 352},
    {0xFDFC, 0xFDFC, 196, 259, 345},
    {0xFDFD, 0xFDFD, 196, 253, 345},
    {0xFDFE, 0xFDFF, 196, 252, 345},
    {0xFE00, 0xFE0F, 197, 293, 349},
    {0xFE10, 0xFE10, 198, 253, 354},
    {0xFE11, 0xFE12, 198, 253, 345},
    {0xFE13, 0xFE13, 198, 253, 353},
    {0xFE14, 0xFE14, 198, 253, 354},
    {0xFE15, 0xFE19, 198, 253, 345},
    {0xFE1A, 0xFE1F, 198, 252, 345},
    {0xFE20, 0xFE26, 199, 293, 349},
    {0xFE27, 0xFE2F, 199, 252, 345},
    {0xFE30, 0xFE32, 200, 253, 345},
    {0xFE33, 0xFE34, 200, 253, 357},
    {0xFE35, 0xFE4C, 200, 253, 345},
    {0xFE4D, 0xFE4F, 200, 253, 357},
    {0xFE50, 0xFE50, 201, 253, 354},
    {0xFE51, 0xFE51, 201, 253, 345},
    {0xFE52, 0xFE52, 201, 253, 355},
    {0xFE53, 0xFE53, 201, 252, 345},
    {0xFE54, 0xFE54, 201, 253, 354},
    {0xFE55, 0xFE55, 201, 253, 353},
    {0xFE56, 0xFE66, 201, 253, 345},
    {0xFE67, 0xFE67, 201, 252, 345},
    {0xFE68, 0xFE6B, 201, 253, 345},
    {0xFE6C, 0xFE6F, 201, 252, 345},
    {0xFE70, 0xFE74, 202, 259, 352},
    {0xFE75, 0xFE75, 202, 252, 345},
    {0xFE76, 0xFEFC, 202, 259, 352},
    {0xFEFD, 0xFEFE, 202, 252, 345},
    {0xFEFF, 0xFEFF, 202, 253, 350},
    {0xFF00, 0xFF00, 203, 252, 345},
    {0xFF01, 0xFF06, 203, 253, 345},
    {0xFF07, 0xFF07, 203, 253, 355},
    {0xFF08, 0xFF0B, 203, 253, 345},
    {0xFF0C, 0xFF0C, 203, 253, 354},
    {0xFF0D, 0xFF0D, 203, 253, 345},
    {0xFF0E, 0xFF0E, 203, 253, 355},
    {0xFF0F, 0xFF19, 203, 253, 345},
    {0xFF1A, 0xFF1A, 203, 253, 353},
    {0xFF1B, 0xFF1B, 203, 253, 354},
    {0xFF1C, 0xFF20, 203, 253, 345},
    {0xFF21, 0xFF3A, 203, 254, 352},
    {0xFF3B, 0xFF3E, 203, 253, 345},
    {0xFF3F, 0xFF3F, 203, 253, 357},
    {0xFF40, 0xFF40, 203, 253, 345},
    {0xFF41, 0xFF5A, 203, 254, 352},
    {0xFF5B, 0xFF65, 203, 253, 345},
    {0xFF66, 0xFF6F, 203, 286, 351},
    {0xFF70, 0xFF70, 203, 253, 351},
    {0xFF71, 0xFF9D, 203, 286, 351},
    {0xFF9E, 0xFF9F, 203, 253, 349},
    {0xFFA0, 0xFFBE, 203, 277, 352},
    {0xFFBF, 0xFFC1, 203, 252, 345},
    {0xFFC2, 0xFFC7, 203, 277, 352},
    {0xFFC8, 0xFFC9, 203, 252, 345},
    {0xFFCA, 0xFFCF, 203, 277, 352},
    {0xFFD0, 0xFFD1, 203, 252, 345},
    {0xFFD2, 0xFFD7, 203, 277, 352},
    {0xFFD8, 0xFFD9, 203, 252, 345},
    {0xFFDA, 0xFFDC, 203, 277, 352},
    {0xFFDD, 0xFFDF, 203, 252, 345},
    {0xFFE0, 0xFFE6, 203, 253, 345},
    {0xFFE7, 0xFFE7, 203, 252, 345},
    {0xFFE8, 0xFFEE, 203, 253, 345},
    {0xFFEF, 0xFFEF, 203, 252, 345},
    {0xFFF0, 0xFFF8, 204, 252, 345},
    {0xFFF9, 0xFFFB, 204, 253, 350},
    {0xFFFC, 0xFFFD, 204, 253, 345},
    {0xFFFE, 0xFFFF, 204, 252, 345},
    {0x10000, 0x1000B, 205, 300, 352},
    {0x1000C, 0x1000C, 205, 252, 345},
    {0x1000D, 0x10026, 205, 300, 352},
    {0x10027, 0x10027, 205, 252, 345},
    {0x10028, 0x1003A, 205, 300, 352},
    {0x1003B, 0x1003B, 205, 252, 345},
    {0x1003C, 0x1003D, 205, 300, 352},
    {0x1003E, 0x1003E, 205, 252, 345},
    {0x1003F, 0x1004D, 205, 300, 352},
    {0x1004E, 0x1004F, 205, 252, 345},
    {0x10050, 0x1005D, 205, 300, 352},
    {0x1005E, 0x1007F, 205, 252, 345},
    {0x10080, 0x100FA, 206, 300, 352},
    {0x100FB, 0x100FF, 206, 252, 345},
    {0x10100, 0x10102, 207, 253, 345},
    {0x10103, 0x10106, 207, 252, 345},
    {0x10107, 0x10133, 207, 253, 345},
    {0x10134, 0x10136, 207, 252, 345},
    {0x10137, 0x1013F, 207, 253, 345},
    {0x10140, 0x10174, 208, 255, 352},
    {0x10175, 0x1018A, 208, 255, 345},
    {0x1018B, 0x1018F, 208, 252, 345},
    {0x10190, 0x1019B, 209, 253, 345},
    {0x1019C, 0x101CF, 209, 252, 345},
    {0x101D0, 0x101FC, 210, 253, 345},
    {0x101FD, 0x101FD, 210, 293, 349},
    {0x101FE, 0x101FF, 210, 252, 345},
    {0x10200, 0x1027F, 54, 252, 345},
    {0x10280, 0x1029C, 211, 326, 352},
    {0x1029D, 0x1029F, 211, 252, 345},
    {0x102A0, 0x102D0, 212, 327, 352},
    {0x102D1, 0x102DF, 212, 252, 345},
    {0x102E0, 0x102FF, 54, 252, 345},
    {0x10300, 0x1031E, 213, 290, 352},
    {0x1031F, 0x1031F, 213, 252, 345},
    {0x10320, 0x10323, 213, 290, 345},
    {0x10324, 0x1032F, 213, 252, 345},
    {0x10330, 0x1034A, 214, 291, 352},
    {0x1034B, 0x1034F, 214, 252, 345},
    {0x10350, 0x1037F, 54, 252, 345},
    {0x10380, 0x1039D, 215, 301, 352},
    {0x1039E, 0x1039E, 215, 252, 345},
    {0x1039F, 0x1039F, 215, 301, 345},
    {0x103A0, 0x103C3, 216, 312, 352},
    {0x103C4, 0x103C7, 216, 252, 345},
    {0x103C8, 0x103CF, 216, 312, 352},
    {0x103D0, 0x103D0, 216, 312, 345},
    {0x103D1, 0x103D5, 216, 312, 352},
    {0x103D6, 0x103DF, 216, 252, 345},
    {0x103E0, 0x103FF, 54, 252, 345},
    {0x10400, 0x1044F, 217, 292, 352},
    {0x10450, 0x1047F, 218, 302, 352},
    {0x10480, 0x1049D, 219, 303, 352},
    {0x1049E, 0x1049F, 219, 252, 345},
    {0x104A0, 0x104A9, 219, 303, 356},
    {0x104AA, 0x104AF, 219, 252, 345},
    {0x104B0, 0x107FF, 54, 252, 345},
    {0x10800, 0x10805, 220, 304, 352},
    {0x10806, 0x10807, 220, 252, 345},
    {0x10808, 0x10808, 220, 304, 352},
    {0x10809, 0x10809, 220, 252, 345},
    {0x1080A, 0x10835, 220, 304, 352},
    {0x10836, 0x10836, 220, 252, 345},
    {0x10837, 0x10838, 220, 304, 352},
    {0x10839, 0x1083B, 220, 252, 345},
    {0x1083C, 0x1083C, 220, 304, 352},
    {0x1083D, 0x1083E, 220, 252, 345},
    {0x1083F, 0x1083F, 220, 304, 352},
    {0x10840, 0x10855, 221, 339, 352},
    {0x10856, 0x10856, 221, 252, 345},
    {0x10857, 0x1085F, 221, 339, 345},
    {0x10860, 0x108FF, 54, 252, 345},
    {0x10900, 0x10915, 222, 316, 352},
    {0x10916, 0x1091B, 222, 316, 345},
    {0x1091C, 0x1091E, 222, 252, 345},
    {0x1091F, 0x1091F, 222, 316, 345},
    {0x10920, 0x10939, 223, 328, 352},
    {0x1093A, 0x1093E, 223, 252, 345},
    {0x1093F, 0x1093F, 223, 328, 345},
    {0x10940, 0x109FF, 54, 252, 345},
    {0x10A00, 0x10A00, 224, 313, 352},
    {0x10A01, 0x10A03, 224, 313, 349},
    {0x10A04, 0x10A04, 224, 252, 345},
    {0x10A05, 0x10A06, 224, 313, 349},
    {0x10A07, 0x10A0B, 224, 252, 345},
    {0x10A0C, 0x10A0F, 224, 313, 349},
    {0x10A10, 0x10A13, 224, 313, 352},
    {0x10A14, 0x10A14, 224, 252, 345},
    {0x10A15, 0x10A17, 224, 313, 352},
    {0x10A18, 0x10A18, 224, 252, 345},
    {0x10A19, 0x10A33, 224, 313, 352},
    {0x10A34, 0x10A37, 224, 252, 345},
    {0x10A38, 0x10A3A, 224, 313, 349},
    {0x10A3B, 0x10A3E, 224, 252, 345},
    {0x10A3F, 0x10A3F, 224, 313, 349},
    {0x10A40, 0x10A47, 224, 313, 345},
    {0x10A48, 0x10A4F, 224, 252, 345},
    {0x10A50, 0x10A58, 224, 313, 345},
    {0x10A59, 0x10A5F, 224, 252, 345},
    {0x10A60, 0x10A7C, 225, 340, 352},
    {0x10A7D, 0x10A7F, 225, 340, 345},
    {0x10A80, 0x10AFF, 54, 252, 345},
    {0x10B00, 0x10B35, 226, 332, 352},
    {0x10B36, 0x10B38, 226, 252, 345},
    {0x10B39, 0x10B3F, 226, 332, 345},
    {0x10B40, 0x10B55, 227, 341, 352},
    {0x10B56, 0x10B57, 227, 252, 345},
    {0x10B58, 0x10B5F, 227, 341, 345},
    {0x10B60, 0x10B72, 228, 342, 352},
    {0x10B73, 0x10B77, 228, 252, 345},
    {0x10B78, 0x10B7F, 228, 342, 345},
    {0x10B80, 0x10BFF, 54, 252, 345},
    {0x10C00, 0x10C48, 229, 343, 352},
    {0x10C49, 0x10C4F, 229, 252, 345},
    {0x10C50, 0x10E5F, 54, 252, 345},
    {0x10E60, 0x10E7E, 230, 259, 345},
    {0x10E7F, 0x10E7F, 230, 252, 345},
    {0x10E80, 0x1107F, 54, 252, 345},
    {0x11080, 0x11082, 231, 344, 349},
    {0x11083, 0x110AF, 231, 344, 352},
    {0x110B0, 0x110BA, 231, 344, 349},
    {0x110BB, 0x110BC, 231, 344, 345},
    {0x110BD, 0x110BD, 231, 344, 350},
    {0x110BE, 0x110C1, 231, 344, 345},
    {0x110C2, 0x110CF, 231, 252, 345},
    {0x110D0, 0x11FFF, 54, 252, 345},
    {0x12000, 0x1236E, 232, 315, 352},
    {0x1236F, 0x123FF, 232, 252, 345},
    {0x12400, 0x12462, 233, 315, 352},
    {0x12463, 0x1246F, 233, 252, 345},
    {0x12470, 0x12473, 233, 315, 345},
    {0x12474, 0x1247F, 233, 252, 345},
    {0x12480, 0x12FFF, 54, 252, 345},
    {0x13000, 0x1342E, 234, 333, 352},
    {0x1342F, 0x1342F, 234, 252, 345},
    {0x13430, 0x1CFFF, 54, 252, 345},
    {0x1D000, 0x1D0F5, 235, 253, 345},
    {0x1D0F6, 0x1D0FF, 235, 252, 345},
    {0x1D100, 0x1D126, 236, 253, 345},
    {0x1D127, 0x1D128, 236, 252, 345},
    {0x1D129, 0x1D164, 236, 253, 345},
    {0x1D165, 0x1D166, 236, 253, 349},
    {0x1D167, 0x1D169, 236, 293, 349},
    {0x1D16A, 0x1D16C, 236, 253, 345},
    {0x1D16D, 0x1D172, 236, 253, 349},
    {0x1D173, 0x1D17A, 236, 253, 350},
    {0x1D17B, 0x1D182, 236, 293, 349},
    {0x1D183, 0x1D184, 236, 253, 345},
    {0x1D185, 0x1D18B, 236, 293, 349},
    {0x1D18C, 0x1D1A9, 236, 253, 345},
    {0x1D1AA, 0x1D1AD, 236, 293, 349},
    {0x1D1AE, 0x1D1DD, 236, 253, 345},
    {0x1D1DE, 0x1D1FF, 236, 252, 345},
    {0x1D200, 0x1D241, 237, 255, 345},
    {0x1D242, 0x1D244, 237, 255, 349},
    {0x1D245, 0x1D245, 237, 255, 345},
    {0x1D246, 0x1D24F, 237, 252, 345},
    {0x1D250, 0x1D2FF, 54, 252, 345},
    {0x1D300, 0x1D356, 238, 253, 345},
    {0x1D357, 0x1D35F, 238, 252, 345},
    {0x1D360, 0x1D371, 239, 253, 345},
    {0x1D372, 0x1D37F, 239, 252, 345},
    {0x1D380, 0x1D3FF, 54, 252, 345},
    {0x1D400, 0x1D454, 240, 253, 352},
    {0x1D455, 0x1D455, 240, 252, 345},
    {0x1D456, 0x1D49C, 240, 253, 352},
    {0x1D49D, 0x1D49D, 240, 252, 345},
    {0x1D49E, 0x1D49F, 240, 253, 352},
    {0x1D4A0, 0x1D4A1, 240, 252, 345},
    {0x1D4A2, 0x1D4A2, 240, 253, 352},
    {0x1D4A3, 0x1D4A4, 240, 252, 345},
    {0x1D4A5, 0x1D4A6, 240, 253, 352},
    {0x1D4A7, 0x1D4A8, 240, 252, 345},
    {0x1D4A9, 0x1D4AC, 240, 253, 352},
    {0x1D4AD, 0x1D4AD, 240, 252, 345},
    {0x1D4AE, 0x1D4B9, 240, 253, 352},
    {0x1D4BA, 0x1D4BA, 240, 252, 345},
    {0x1D4BB, 0x1D4BB, 240, 253, 352},
    {0x1D4BC, 0x1D4BC, 240, 252, 345},
    {0x1D4BD, 0x1D4C3, 240, 253, 352},
    {0x1D4C4, 0x1D4C4, 240, 252, 345},
    {0x1D4C5, 0x1D505, 240, 253, 352},
    {0x1D506, 0x1D506, 240, 252, 345},
    {0x1D507, 0x1D50A, 240, 253, 352},
    {0x1D50B, 0x1D50C, 240, 252, 345},
    {0x1D50D, 0x1D514, 240, 253, 352},
    {0x1D515, 0x1D515, 240, 252, 345},
    {0x1D516, 0x1D51C, 240, 253, 352},
    {0x1D51D, 0x1D51D, 240, 252, 345},
    {0x1D51E, 0x1D539, 240, 253, 352},
    {0x1D53A, 0x1D53A, 240, 252, 345},
    {0x1D53B, 0x1D53E, 240, 253, 352},
    {0x1D53F, 0x1D53F, 240, 252, 345},
    {0x1D540, 0x1D544, 240, 253, 352},
    {0x1D545, 0x1D545, 240, 252, 345},
    {0x1D546, 0x1D546, 240, 253, 352},
    {0x1D547, 0x1D549, 240, 252, 345},
    {0x1D54A, 0x1D550, 240, 253, 352},
    {0x1D551, 0x1D551, 240, 252, 345},
    {0x1D552, 0x1D6A5, 240, 253, 352},
    {0x1D6A6, 0x1D6A7, 240, 252, 345},
    {0x1D6A8, 0x1D6C0, 240, 253, 352},
    {0x1D6C1, 0x1D6C1, 240, 253, 345},
    {0x1D6C2, 0x1D6DA, 240, 253, 352},
    {0x1D6DB, 0x1D6DB, 240, 253, 345},
    {0x1D6DC, 0x1D6FA, 240, 253, 352},
    {0x1D6FB, 0x1D6FB, 240, 253, 345},
    {0x1D6FC, 0x1D714, 240, 253, 352},
    {0x1D715, 0x1D715, 240, 253, 345},
    {0x1D716, 0x1D734, 240, 253, 352},
    {0x1D735, 0x1D735, 240, 253, 345},
    {0x1D736, 0x1D74E, 240, 253, 352},
    {0x1D74F, 0x1D74F, 240, 253, 345},
    {0x1D750, 0x1D76E, 240, 253, 352},
    {0x1D76F, 0x1D76F, 240, 253, 345},
    {0x1D770, 0x1D788, 240, 253, 352},
    {0x1D789, 0x1D789, 240, 253, 345},
    {0x1D78A, 0x1D7A8, 240, 253, 352},
    {0x1D7A9, 0x1D7A9, 240, 253, 345},
    {0x1D7AA, 0x1D7C2, 240, 253, 352},
    {0x1D7C3, 0x1D7C3, 240, 253, 345},
    {0x1D7C4, 0x1D7CB, 240, 253, 352},
    {0x1D7CC, 0x1D7CD, 240, 252, 345},
    {0x1D7CE, 0x1D7FF, 240, 253, 356},
    {0x1D800, 0x1EFFF, 54, 252, 345},
    {0x1F000, 0x1F02B, 241, 253, 345},
    {0x1F02C, 0x1F02F, 241, 252, 345},
    {0x1F030, 0x1F093, 242, 253, 345},
    {0x1F094, 0x1F09F, 242, 252, 345},
    {0x1F0A0, 0x1F0FF, 54, 252, 345},
    {0x1F100, 0x1F10A, 243, 253, 345},
    {0x1F10B, 0x1F10F, 243, 252, 345},
    {0x1F110, 0x1F12E, 243, 253, 345},
    {0x1F12F, 0x1F130, 243, 252, 345},
    {0x1F131, 0x1F131, 243, 253, 345},
    {0x1F132, 0x1F13C, 243, 252, 345},
    {0x1F13D, 0x1F13D, 243, 253, 345},
    {0x1F13E, 0x1F13E, 243, 252, 345},
    {0x1F13F, 0x1F13F, 243, 253, 345},
    {0x1F140, 0x1F141, 243, 252, 345},
    {0x1F142, 0x1F142, 243, 253, 345},
    {0x1F143, 0x1F145, 243, 252, 345},
    {0x1F146, 0x1F146, 243, 253, 345},
    {0x1F147, 0x1F149, 243, 252, 345},
    {0x1F14A, 0x1F14E, 243, 253, 345},
    {0x1F14F, 0x1F156, 243, 252, 345},
    {0x1F157, 0x1F157, 243, 253, 345},
    {0x1F158, 0x1F15E, 243, 252, 345},
    {0x1F15F, 0x1F15F, 243, 253, 345},
    {0x1F160, 0x1F178, 243, 252, 345},
    {0x1F179, 0x1F179, 243, 253, 345},
    {0x1F17A, 0x1F17A, 243, 252, 345},
    {0x1F17B, 0x1F17C, 243, 253, 345},
    {0x1F17D, 0x1F17E, 243, 252, 345},
    {0x1F17F, 0x1F17F, 243, 253, 345},
    {0x1F180, 0x1F189, 243, 252, 345},
    {0x1F18A, 0x1F18D, 243, 253, 345},
    {0x1F18E, 0x1F18F, 243, 252, 345},
    {0x1F190, 0x1F190, 243, 253, 345},
    {0x1F191, 0x1F1FF, 243, 252, 345},
    {0x1F200, 0x1F200, 244, 285, 345},
    {0x1F201, 0x1F20F, 244, 252, 345},
    {0x1F210, 0x1F231, 244, 253, 345},
    {0x1F232, 0x1F23F, 244, 252, 345},
    {0x1F240, 0x1F248, 244, 253, 345},
    {0x1F249, 0x1F2FF, 244, 252, 345},
    {0x1F300, 0x1FFFF, 54, 252, 345},
    {0x20000, 0x2A6D6, 245, 288, 345},
    {0x2A6D7, 0x2A6DF, 245, 252, 345},
    {0x2A6E0, 0x2A6FF, 54, 252, 345},
    {0x2A700, 0x2B734, 246, 288, 345},
    {0x2B735, 0x2B73F, 246, 252, 345},
    {0x2B740, 0x2F7FF, 54, 252, 345},
    {0x2F800, 0x2FA1D, 247, 288, 345},
    {0x2FA1E, 0x2FA1F, 247, 252, 345},
    {0x2FA20, 0xDFFFF, 54, 252, 345},
    {0xE0000, 0xE0000, 248, 252, 345},
    {0xE0001, 0xE0001, 248, 253, 350},
    {0xE0002, 0xE001F, 248, 252, 345},
    {0xE0020, 0xE007F, 248, 253, 350},
    {0xE0080, 0xE00FF, 54, 252, 345},
    {0xE0100, 0xE01EF, 249, 293, 349},
    {0xE01F0, 0xEFFFF, 54, 252, 345},
    {0xF0000, 0xFFFFF, 250, 252, 345},
    {0x100000, 0x10FFFF, 251, 252, 345},
};

/* ASCII character properties. */
#define RE_MASK_DIGIT 0x1
#define RE_MASK_LOWER 0x2
#define RE_MASK_PUNCT 0x4
#define RE_MASK_SPACE 0x8
#define RE_MASK_UPPER 0x10
#define RE_MASK_XDIGIT 0x20

/* alpha = upper | lower */
#define RE_MASK_ALPHA (RE_MASK_UPPER | RE_MASK_LOWER)
/* alnum = alpha | digit */
#define RE_MASK_ALNUM (RE_MASK_ALPHA | RE_MASK_DIGIT)

unsigned char re_ascii_property[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
    0x21, 0x21, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x00,
};

#define RE_FLAG_ASCII 0x80
#define RE_FLAG_DEBUG 0x200
#define RE_FLAG_DOTALL 0x10
#define RE_FLAG_IGNORECASE 0x2
#define RE_FLAG_LOCALE 0x4
#define RE_FLAG_MULTILINE 0x8
#define RE_FLAG_REVERSE 0x400
#define RE_FLAG_TEMPLATE 0x1
#define RE_FLAG_UNICODE 0x20
#define RE_FLAG_VERBOSE 0x40
#define RE_FLAG_WORD 0x800
#define RE_FLAG_ZEROWIDTH 0x100
