/*
 * Secret Labs' Regular Expression Engine
 *
 * regular expression matching engine
 *
 * Copyright (c) 1997-2001 by Secret Labs AB.  All rights reserved.
 *
 * NOTE: This file is generated by regex.py.  If you need
 * to change anything in here, edit regex.py and run it.
 *
 * 2010-01-16 mrab Re-written
 */

/* Supports Unicode version 6.0.0. */

#define RE_MAGIC 20100116

/* Size of a code word (must be unsigned short or larger, and large enough to
 * hold a Py_UNICODE character).
 */
#if SIZEOF_INT >= 4
#define RE_CODE unsigned int
#else
#define RE_CODE SIZEOF_LONG
#define RE_CODE unsigned long
#endif

/* Unlimited repeat count. */
#define RE_UNLIMITED (~(RE_CODE)0)

/* Operators. */
#define RE_OP_FAILURE 0
#define RE_OP_SUCCESS 1
#define RE_OP_ANY 2
#define RE_OP_ANY_ALL 3
#define RE_OP_ANY_ALL_REV 4
#define RE_OP_ANY_REV 5
#define RE_OP_ATOMIC 6
#define RE_OP_BIG_BITSET 7
#define RE_OP_BIG_BITSET_REV 8
#define RE_OP_BOUNDARY 9
#define RE_OP_BRANCH 10
#define RE_OP_CHARACTER 11
#define RE_OP_CHARACTER_IGN 12
#define RE_OP_CHARACTER_IGN_REV 13
#define RE_OP_CHARACTER_REV 14
#define RE_OP_DEFAULT_BOUNDARY 15
#define RE_OP_END 16
#define RE_OP_END_GREEDY_REPEAT 17
#define RE_OP_END_GROUP 18
#define RE_OP_END_LAZY_REPEAT 19
#define RE_OP_END_OF_LINE 20
#define RE_OP_END_OF_STRING 21
#define RE_OP_END_OF_STRING_LINE 22
#define RE_OP_GREEDY_REPEAT 23
#define RE_OP_GREEDY_REPEAT_ONE 24
#define RE_OP_GROUP 25
#define RE_OP_GROUP_EXISTS 26
#define RE_OP_LAZY_REPEAT 27
#define RE_OP_LAZY_REPEAT_ONE 28
#define RE_OP_LOOKAROUND 29
#define RE_OP_NEXT 30
#define RE_OP_PROPERTY 31
#define RE_OP_PROPERTY_REV 32
#define RE_OP_REF_GROUP 33
#define RE_OP_REF_GROUP_IGN 34
#define RE_OP_REF_GROUP_IGN_REV 35
#define RE_OP_REF_GROUP_REV 36
#define RE_OP_SEARCH_ANCHOR 37
#define RE_OP_SET 38
#define RE_OP_SET_REV 39
#define RE_OP_SMALL_BITSET 40
#define RE_OP_SMALL_BITSET_REV 41
#define RE_OP_START_GROUP 42
#define RE_OP_START_OF_LINE 43
#define RE_OP_START_OF_STRING 44
#define RE_OP_STRING 45
#define RE_OP_STRING_IGN 46
#define RE_OP_STRING_IGN_REV 47
#define RE_OP_STRING_REV 48
#define RE_OP_TAIL_GUARD 49

char* re_op_text[] = {
    "RE_OP_FAILURE",
    "RE_OP_SUCCESS",
    "RE_OP_ANY",
    "RE_OP_ANY_ALL",
    "RE_OP_ANY_ALL_REV",
    "RE_OP_ANY_REV",
    "RE_OP_ATOMIC",
    "RE_OP_BIG_BITSET",
    "RE_OP_BIG_BITSET_REV",
    "RE_OP_BOUNDARY",
    "RE_OP_BRANCH",
    "RE_OP_CHARACTER",
    "RE_OP_CHARACTER_IGN",
    "RE_OP_CHARACTER_IGN_REV",
    "RE_OP_CHARACTER_REV",
    "RE_OP_DEFAULT_BOUNDARY",
    "RE_OP_END",
    "RE_OP_END_GREEDY_REPEAT",
    "RE_OP_END_GROUP",
    "RE_OP_END_LAZY_REPEAT",
    "RE_OP_END_OF_LINE",
    "RE_OP_END_OF_STRING",
    "RE_OP_END_OF_STRING_LINE",
    "RE_OP_GREEDY_REPEAT",
    "RE_OP_GREEDY_REPEAT_ONE",
    "RE_OP_GROUP",
    "RE_OP_GROUP_EXISTS",
    "RE_OP_LAZY_REPEAT",
    "RE_OP_LAZY_REPEAT_ONE",
    "RE_OP_LOOKAROUND",
    "RE_OP_NEXT",
    "RE_OP_PROPERTY",
    "RE_OP_PROPERTY_REV",
    "RE_OP_REF_GROUP",
    "RE_OP_REF_GROUP_IGN",
    "RE_OP_REF_GROUP_IGN_REV",
    "RE_OP_REF_GROUP_REV",
    "RE_OP_SEARCH_ANCHOR",
    "RE_OP_SET",
    "RE_OP_SET_REV",
    "RE_OP_SMALL_BITSET",
    "RE_OP_SMALL_BITSET_REV",
    "RE_OP_START_GROUP",
    "RE_OP_START_OF_LINE",
    "RE_OP_START_OF_STRING",
    "RE_OP_STRING",
    "RE_OP_STRING_IGN",
    "RE_OP_STRING_IGN_REV",
    "RE_OP_STRING_REV",
    "RE_OP_TAIL_GUARD",
};

/* Character/codepoint properties. */
#define RE_PROP_CN 0
#define RE_PROP_LU 1
#define RE_PROP_LL 2
#define RE_PROP_LT 3
#define RE_PROP_MN 4
#define RE_PROP_MC 5
#define RE_PROP_ME 6
#define RE_PROP_ND 7
#define RE_PROP_NL 8
#define RE_PROP_NO 9
#define RE_PROP_ZS 10
#define RE_PROP_ZL 11
#define RE_PROP_ZP 12
#define RE_PROP_CC 13
#define RE_PROP_CF 14
#define RE_PROP_CS 15
#define RE_PROP_CO 16
#define RE_PROP_LM 18
#define RE_PROP_LO 19
#define RE_PROP_PC 20
#define RE_PROP_PD 21
#define RE_PROP_PS 22
#define RE_PROP_PE 23
#define RE_PROP_PI 24
#define RE_PROP_PF 25
#define RE_PROP_PO 26
#define RE_PROP_SM 27
#define RE_PROP_SC 28
#define RE_PROP_SK 29
#define RE_PROP_SO 30
#define RE_PROP_L 32
#define RE_PROP_M 33
#define RE_PROP_Z 34
#define RE_PROP_S 35
#define RE_PROP_N 36
#define RE_PROP_P 37
#define RE_PROP_C 38
#define RE_PROP_ALPHA 39
#define RE_PROP_ALNUM 40
#define RE_PROP_ASCII 41
#define RE_PROP_BLANK 42
#define RE_PROP_CNTRL 43
#define RE_PROP_DIGIT 44
#define RE_PROP_GRAPH 45
#define RE_PROP_LINEBREAK 46
#define RE_PROP_LOWER 47
#define RE_PROP_PRINT 48
#define RE_PROP_PUNCT 49
#define RE_PROP_SPACE 50
#define RE_PROP_UPPER 51
#define RE_PROP_WORD 52
#define RE_PROP_XDIGIT 53

/* Unicode character properties. */
#define RE_PROP_MASK_CN 0x00020001
#define RE_PROP_MASK_LU 0x00000002
#define RE_PROP_MASK_LL 0x00000004
#define RE_PROP_MASK_LT 0x00000008
#define RE_PROP_MASK_MN 0x00000010
#define RE_PROP_MASK_MC 0x00000020
#define RE_PROP_MASK_ME 0x00000040
#define RE_PROP_MASK_ND 0x00000080
#define RE_PROP_MASK_NL 0x00000100
#define RE_PROP_MASK_NO 0x00000200
#define RE_PROP_MASK_ZS 0x00000400
#define RE_PROP_MASK_ZL 0x00000800
#define RE_PROP_MASK_ZP 0x00001000
#define RE_PROP_MASK_CC 0x00002000
#define RE_PROP_MASK_CF 0x00004000
#define RE_PROP_MASK_CS 0x00008000
#define RE_PROP_MASK_CO 0x00010000
#define RE_PROP_MASK_LM 0x00040000
#define RE_PROP_MASK_LO 0x00080000
#define RE_PROP_MASK_PC 0x00100000
#define RE_PROP_MASK_PD 0x00200000
#define RE_PROP_MASK_PS 0x00400000
#define RE_PROP_MASK_PE 0x00800000
#define RE_PROP_MASK_PI 0x01000000
#define RE_PROP_MASK_PF 0x02000000
#define RE_PROP_MASK_PO 0x04000000
#define RE_PROP_MASK_SM 0x08000000
#define RE_PROP_MASK_SC 0x10000000
#define RE_PROP_MASK_SK 0x20000000
#define RE_PROP_MASK_SO 0x40000000
#define RE_PROP_MASK_L 0x000C000E
#define RE_PROP_MASK_M 0x00000070
#define RE_PROP_MASK_Z 0x00001C00
#define RE_PROP_MASK_S 0x78000000
#define RE_PROP_MASK_N 0x00000380
#define RE_PROP_MASK_P 0x07F00000
#define RE_PROP_MASK_C 0x0003E001

#define RE_PROP_MASK_ALNUM (RE_PROP_MASK_L | RE_PROP_MASK_ND)
#define RE_PROP_MASK_NONGRAPH (RE_PROP_MASK_Z | RE_PROP_MASK_C)
#define RE_PROP_MASK_PUNCT (RE_PROP_MASK_P | RE_PROP_MASK_S)
#define RE_PROP_MASK_SPACE (RE_PROP_MASK_ZL | RE_PROP_MASK_ZP | \
  RE_PROP_MASK_CC | RE_PROP_MASK_CF)
#define RE_PROP_MASK_WORD (RE_PROP_MASK_L | RE_PROP_MASK_M | RE_PROP_MASK_N | \
  RE_PROP_MASK_PC)

/* Unicode block ranges. */
#define RE_MIN_BLOCK 54
#define RE_MAX_BLOCK 263

/* Unicode script ranges. */
#define RE_MIN_SCRIPT 264
#define RE_MAX_SCRIPT 359

/* Unicode cases. */
#define RE_MIN_CASE 65
#define RE_MAX_CASE 66639

#define RE_MIN_CASE_INDEX_8 0
#define RE_MAX_CASE_INDEX_8 5
#define RE_MIN_CASE_INDEX_12 5
#define RE_MAX_CASE_INDEX_12 50
#define RE_MIN_CASE_INDEX_16 51
#define RE_MAX_CASE_INDEX_16 106
#define RE_MIN_CASE_INDEX_32 107
#define RE_MAX_CASE_INDEX_32 107

/* Forms of Unicode word break. */
#define RE_BREAK_OTHER 360
#define RE_BREAK_CR 361
#define RE_BREAK_LF 362
#define RE_BREAK_NEWLINE 363
#define RE_BREAK_EXTEND 364
#define RE_BREAK_FORMAT 365
#define RE_BREAK_KATAKANA 366
#define RE_BREAK_ALETTER 367
#define RE_BREAK_MIDLETTER 368
#define RE_BREAK_MIDNUM 369
#define RE_BREAK_MIDNUMLET 370
#define RE_BREAK_NUMERIC 371
#define RE_BREAK_EXTENDNUMLET 372

typedef struct RE_InfoRange {
    unsigned int min_char;
    unsigned int max_char;
    int block;
    int script;
    int word_break;
} RE_InfoRange;

typedef struct RE_CaseRange {
    unsigned int min_char;
    unsigned int max_char;
    int offset;
} RE_CaseRange;

typedef struct RE_Case {
    unsigned int code[3];
} RE_Case;

/* The codepoint info table. */
RE_InfoRange re_codepoint_info[] = {
    {0x0, 0x9, 55, 265, 360},
    {0xA, 0xA, 55, 265, 362},
    {0xB, 0xC, 55, 265, 363},
    {0xD, 0xD, 55, 265, 361},
    {0xE, 0x26, 55, 265, 360},
    {0x27, 0x27, 55, 265, 370},
    {0x28, 0x2B, 55, 265, 360},
    {0x2C, 0x2C, 55, 265, 369},
    {0x2D, 0x2D, 55, 265, 360},
    {0x2E, 0x2E, 55, 265, 370},
    {0x2F, 0x2F, 55, 265, 360},
    {0x30, 0x39, 55, 265, 371},
    {0x3A, 0x3A, 55, 265, 368},
    {0x3B, 0x3B, 55, 265, 369},
    {0x3C, 0x40, 55, 265, 360},
    {0x41, 0x5A, 55, 266, 367},
    {0x5B, 0x5E, 55, 265, 360},
    {0x5F, 0x5F, 55, 265, 372},
    {0x60, 0x60, 55, 265, 360},
    {0x61, 0x7A, 55, 266, 367},
    {0x7B, 0x7F, 55, 265, 360},
    {0x80, 0x84, 56, 265, 360},
    {0x85, 0x85, 56, 265, 363},
    {0x86, 0xA9, 56, 265, 360},
    {0xAA, 0xAA, 56, 266, 367},
    {0xAB, 0xAC, 56, 265, 360},
    {0xAD, 0xAD, 56, 265, 365},
    {0xAE, 0xB4, 56, 265, 360},
    {0xB5, 0xB5, 56, 265, 367},
    {0xB6, 0xB6, 56, 265, 360},
    {0xB7, 0xB7, 56, 265, 368},
    {0xB8, 0xB9, 56, 265, 360},
    {0xBA, 0xBA, 56, 266, 367},
    {0xBB, 0xBF, 56, 265, 360},
    {0xC0, 0xD6, 56, 266, 367},
    {0xD7, 0xD7, 56, 265, 360},
    {0xD8, 0xF6, 56, 266, 367},
    {0xF7, 0xF7, 56, 265, 360},
    {0xF8, 0xFF, 56, 266, 367},
    {0x100, 0x17F, 57, 266, 367},
    {0x180, 0x24F, 58, 266, 367},
    {0x250, 0x2AF, 59, 266, 367},
    {0x2B0, 0x2B8, 60, 266, 367},
    {0x2B9, 0x2C1, 60, 265, 367},
    {0x2C2, 0x2C5, 60, 265, 360},
    {0x2C6, 0x2D1, 60, 265, 367},
    {0x2D2, 0x2DF, 60, 265, 360},
    {0x2E0, 0x2E4, 60, 266, 367},
    {0x2E5, 0x2E9, 60, 265, 360},
    {0x2EA, 0x2EB, 60, 299, 360},
    {0x2EC, 0x2EC, 60, 265, 367},
    {0x2ED, 0x2ED, 60, 265, 360},
    {0x2EE, 0x2EE, 60, 265, 367},
    {0x2EF, 0x2FF, 60, 265, 360},
    {0x300, 0x36F, 61, 305, 364},
    {0x370, 0x373, 62, 267, 367},
    {0x374, 0x374, 62, 265, 367},
    {0x375, 0x375, 62, 267, 360},
    {0x376, 0x377, 62, 267, 367},
    {0x378, 0x379, 62, 264, 360},
    {0x37A, 0x37D, 62, 267, 367},
    {0x37E, 0x37E, 62, 265, 369},
    {0x37F, 0x383, 62, 264, 360},
    {0x384, 0x384, 62, 267, 360},
    {0x385, 0x385, 62, 265, 360},
    {0x386, 0x386, 62, 267, 367},
    {0x387, 0x387, 62, 265, 368},
    {0x388, 0x38A, 62, 267, 367},
    {0x38B, 0x38B, 62, 264, 360},
    {0x38C, 0x38C, 62, 267, 367},
    {0x38D, 0x38D, 62, 264, 360},
    {0x38E, 0x3A1, 62, 267, 367},
    {0x3A2, 0x3A2, 62, 264, 360},
    {0x3A3, 0x3E1, 62, 267, 367},
    {0x3E2, 0x3EF, 62, 319, 367},
    {0x3F0, 0x3F5, 62, 267, 367},
    {0x3F6, 0x3F6, 62, 267, 360},
    {0x3F7, 0x3FF, 62, 267, 367},
    {0x400, 0x481, 63, 268, 367},
    {0x482, 0x482, 63, 268, 360},
    {0x483, 0x484, 63, 268, 364},
    {0x485, 0x486, 63, 305, 364},
    {0x487, 0x489, 63, 268, 364},
    {0x48A, 0x4FF, 63, 268, 367},
    {0x500, 0x527, 64, 268, 367},
    {0x528, 0x52F, 64, 264, 360},
    {0x530, 0x530, 65, 264, 360},
    {0x531, 0x556, 65, 269, 367},
    {0x557, 0x558, 65, 264, 360},
    {0x559, 0x559, 65, 269, 367},
    {0x55A, 0x55F, 65, 269, 360},
    {0x560, 0x560, 65, 264, 360},
    {0x561, 0x587, 65, 269, 367},
    {0x588, 0x588, 65, 264, 360},
    {0x589, 0x589, 65, 265, 369},
    {0x58A, 0x58A, 65, 269, 360},
    {0x58B, 0x58F, 65, 264, 360},
    {0x590, 0x590, 66, 264, 360},
    {0x591, 0x5BD, 66, 270, 364},
    {0x5BE, 0x5BE, 66, 270, 360},
    {0x5BF, 0x5BF, 66, 270, 364},
    {0x5C0, 0x5C0, 66, 270, 360},
    {0x5C1, 0x5C2, 66, 270, 364},
    {0x5C3, 0x5C3, 66, 270, 360},
    {0x5C4, 0x5C5, 66, 270, 364},
    {0x5C6, 0x5C6, 66, 270, 360},
    {0x5C7, 0x5C7, 66, 270, 364},
    {0x5C8, 0x5CF, 66, 264, 360},
    {0x5D0, 0x5EA, 66, 270, 367},
    {0x5EB, 0x5EF, 66, 264, 360},
    {0x5F0, 0x5F3, 66, 270, 367},
    {0x5F4, 0x5F4, 66, 270, 368},
    {0x5F5, 0x5FF, 66, 264, 360},
    {0x600, 0x603, 67, 271, 365},
    {0x604, 0x605, 67, 264, 360},
    {0x606, 0x60B, 67, 271, 360},
    {0x60C, 0x60C, 67, 265, 369},
    {0x60D, 0x60D, 67, 271, 369},
    {0x60E, 0x60F, 67, 271, 360},
    {0x610, 0x61A, 67, 271, 364},
    {0x61B, 0x61B, 67, 265, 360},
    {0x61C, 0x61D, 67, 264, 360},
    {0x61E, 0x61E, 67, 271, 360},
    {0x61F, 0x61F, 67, 265, 360},
    {0x620, 0x63F, 67, 271, 367},
    {0x640, 0x640, 67, 265, 367},
    {0x641, 0x64A, 67, 271, 367},
    {0x64B, 0x655, 67, 305, 364},
    {0x656, 0x65E, 67, 271, 364},
    {0x65F, 0x65F, 67, 305, 364},
    {0x660, 0x669, 67, 265, 371},
    {0x66A, 0x66A, 67, 271, 360},
    {0x66B, 0x66B, 67, 271, 371},
    {0x66C, 0x66C, 67, 271, 369},
    {0x66D, 0x66D, 67, 271, 360},
    {0x66E, 0x66F, 67, 271, 367},
    {0x670, 0x670, 67, 305, 364},
    {0x671, 0x6D3, 67, 271, 367},
    {0x6D4, 0x6D4, 67, 271, 360},
    {0x6D5, 0x6D5, 67, 271, 367},
    {0x6D6, 0x6DC, 67, 271, 364},
    {0x6DD, 0x6DD, 67, 265, 365},
    {0x6DE, 0x6DE, 67, 271, 360},
    {0x6DF, 0x6E4, 67, 271, 364},
    {0x6E5, 0x6E6, 67, 271, 367},
    {0x6E7, 0x6E8, 67, 271, 364},
    {0x6E9, 0x6E9, 67, 271, 360},
    {0x6EA, 0x6ED, 67, 271, 364},
    {0x6EE, 0x6EF, 67, 271, 367},
    {0x6F0, 0x6F9, 67, 271, 371},
    {0x6FA, 0x6FC, 67, 271, 367},
    {0x6FD, 0x6FE, 67, 271, 360},
    {0x6FF, 0x6FF, 67, 271, 367},
    {0x700, 0x70D, 68, 272, 360},
    {0x70E, 0x70E, 68, 264, 360},
    {0x70F, 0x70F, 68, 272, 365},
    {0x710, 0x710, 68, 272, 367},
    {0x711, 0x711, 68, 272, 364},
    {0x712, 0x72F, 68, 272, 367},
    {0x730, 0x74A, 68, 272, 364},
    {0x74B, 0x74C, 68, 264, 360},
    {0x74D, 0x74F, 68, 272, 367},
    {0x750, 0x77F, 69, 271, 367},
    {0x780, 0x7A5, 70, 273, 367},
    {0x7A6, 0x7B0, 70, 273, 364},
    {0x7B1, 0x7B1, 70, 273, 367},
    {0x7B2, 0x7BF, 70, 264, 360},
    {0x7C0, 0x7C9, 71, 330, 371},
    {0x7CA, 0x7EA, 71, 330, 367},
    {0x7EB, 0x7F3, 71, 330, 364},
    {0x7F4, 0x7F5, 71, 330, 367},
    {0x7F6, 0x7F7, 71, 330, 360},
    {0x7F8, 0x7F8, 71, 330, 369},
    {0x7F9, 0x7F9, 71, 330, 360},
    {0x7FA, 0x7FA, 71, 330, 367},
    {0x7FB, 0x7FF, 71, 264, 360},
    {0x800, 0x815, 72, 346, 367},
    {0x816, 0x819, 72, 346, 364},
    {0x81A, 0x81A, 72, 346, 367},
    {0x81B, 0x823, 72, 346, 364},
    {0x824, 0x824, 72, 346, 367},
    {0x825, 0x827, 72, 346, 364},
    {0x828, 0x828, 72, 346, 367},
    {0x829, 0x82D, 72, 346, 364},
    {0x82E, 0x82F, 72, 264, 360},
    {0x830, 0x83E, 72, 346, 360},
    {0x83F, 0x83F, 72, 264, 360},
    {0x840, 0x858, 73, 359, 367},
    {0x859, 0x85B, 73, 359, 364},
    {0x85C, 0x85D, 73, 264, 360},
    {0x85E, 0x85E, 73, 359, 360},
    {0x85F, 0x85F, 73, 264, 360},
    {0x860, 0x8FF, 54, 264, 360},
    {0x900, 0x903, 74, 274, 364},
    {0x904, 0x939, 74, 274, 367},
    {0x93A, 0x93C, 74, 274, 364},
    {0x93D, 0x93D, 74, 274, 367},
    {0x93E, 0x94F, 74, 274, 364},
    {0x950, 0x950, 74, 274, 367},
    {0x951, 0x952, 74, 305, 364},
    {0x953, 0x957, 74, 274, 364},
    {0x958, 0x961, 74, 274, 367},
    {0x962, 0x963, 74, 274, 364},
    {0x964, 0x965, 74, 265, 360},
    {0x966, 0x96F, 74, 274, 371},
    {0x970, 0x970, 74, 265, 360},
    {0x971, 0x977, 74, 274, 367},
    {0x978, 0x978, 74, 264, 360},
    {0x979, 0x97F, 74, 274, 367},
    {0x980, 0x980, 75, 264, 360},
    {0x981, 0x983, 75, 275, 364},
    {0x984, 0x984, 75, 264, 360},
    {0x985, 0x98C, 75, 275, 367},
    {0x98D, 0x98E, 75, 264, 360},
    {0x98F, 0x990, 75, 275, 367},
    {0x991, 0x992, 75, 264, 360},
    {0x993, 0x9A8, 75, 275, 367},
    {0x9A9, 0x9A9, 75, 264, 360},
    {0x9AA, 0x9B0, 75, 275, 367},
    {0x9B1, 0x9B1, 75, 264, 360},
    {0x9B2, 0x9B2, 75, 275, 367},
    {0x9B3, 0x9B5, 75, 264, 360},
    {0x9B6, 0x9B9, 75, 275, 367},
    {0x9BA, 0x9BB, 75, 264, 360},
    {0x9BC, 0x9BC, 75, 275, 364},
    {0x9BD, 0x9BD, 75, 275, 367},
    {0x9BE, 0x9C4, 75, 275, 364},
    {0x9C5, 0x9C6, 75, 264, 360},
    {0x9C7, 0x9C8, 75, 275, 364},
    {0x9C9, 0x9CA, 75, 264, 360},
    {0x9CB, 0x9CD, 75, 275, 364},
    {0x9CE, 0x9CE, 75, 275, 367},
    {0x9CF, 0x9D6, 75, 264, 360},
    {0x9D7, 0x9D7, 75, 275, 364},
    {0x9D8, 0x9DB, 75, 264, 360},
    {0x9DC, 0x9DD, 75, 275, 367},
    {0x9DE, 0x9DE, 75, 264, 360},
    {0x9DF, 0x9E1, 75, 275, 367},
    {0x9E2, 0x9E3, 75, 275, 364},
    {0x9E4, 0x9E5, 75, 264, 360},
    {0x9E6, 0x9EF, 75, 275, 371},
    {0x9F0, 0x9F1, 75, 275, 367},
    {0x9F2, 0x9FB, 75, 275, 360},
    {0x9FC, 0x9FF, 75, 264, 360},
    {0xA00, 0xA00, 76, 264, 360},
    {0xA01, 0xA03, 76, 276, 364},
    {0xA04, 0xA04, 76, 264, 360},
    {0xA05, 0xA0A, 76, 276, 367},
    {0xA0B, 0xA0E, 76, 264, 360},
    {0xA0F, 0xA10, 76, 276, 367},
    {0xA11, 0xA12, 76, 264, 360},
    {0xA13, 0xA28, 76, 276, 367},
    {0xA29, 0xA29, 76, 264, 360},
    {0xA2A, 0xA30, 76, 276, 367},
    {0xA31, 0xA31, 76, 264, 360},
    {0xA32, 0xA33, 76, 276, 367},
    {0xA34, 0xA34, 76, 264, 360},
    {0xA35, 0xA36, 76, 276, 367},
    {0xA37, 0xA37, 76, 264, 360},
    {0xA38, 0xA39, 76, 276, 367},
    {0xA3A, 0xA3B, 76, 264, 360},
    {0xA3C, 0xA3C, 76, 276, 364},
    {0xA3D, 0xA3D, 76, 264, 360},
    {0xA3E, 0xA42, 76, 276, 364},
    {0xA43, 0xA46, 76, 264, 360},
    {0xA47, 0xA48, 76, 276, 364},
    {0xA49, 0xA4A, 76, 264, 360},
    {0xA4B, 0xA4D, 76, 276, 364},
    {0xA4E, 0xA50, 76, 264, 360},
    {0xA51, 0xA51, 76, 276, 364},
    {0xA52, 0xA58, 76, 264, 360},
    {0xA59, 0xA5C, 76, 276, 367},
    {0xA5D, 0xA5D, 76, 264, 360},
    {0xA5E, 0xA5E, 76, 276, 367},
    {0xA5F, 0xA65, 76, 264, 360},
    {0xA66, 0xA6F, 76, 276, 371},
    {0xA70, 0xA71, 76, 276, 364},
    {0xA72, 0xA74, 76, 276, 367},
    {0xA75, 0xA75, 76, 276, 364},
    {0xA76, 0xA7F, 76, 264, 360},
    {0xA80, 0xA80, 77, 264, 360},
    {0xA81, 0xA83, 77, 277, 364},
    {0xA84, 0xA84, 77, 264, 360},
    {0xA85, 0xA8D, 77, 277, 367},
    {0xA8E, 0xA8E, 77, 264, 360},
    {0xA8F, 0xA91, 77, 277, 367},
    {0xA92, 0xA92, 77, 264, 360},
    {0xA93, 0xAA8, 77, 277, 367},
    {0xAA9, 0xAA9, 77, 264, 360},
    {0xAAA, 0xAB0, 77, 277, 367},
    {0xAB1, 0xAB1, 77, 264, 360},
    {0xAB2, 0xAB3, 77, 277, 367},
    {0xAB4, 0xAB4, 77, 264, 360},
    {0xAB5, 0xAB9, 77, 277, 367},
    {0xABA, 0xABB, 77, 264, 360},
    {0xABC, 0xABC, 77, 277, 364},
    {0xABD, 0xABD, 77, 277, 367},
    {0xABE, 0xAC5, 77, 277, 364},
    {0xAC6, 0xAC6, 77, 264, 360},
    {0xAC7, 0xAC9, 77, 277, 364},
    {0xACA, 0xACA, 77, 264, 360},
    {0xACB, 0xACD, 77, 277, 364},
    {0xACE, 0xACF, 77, 264, 360},
    {0xAD0, 0xAD0, 77, 277, 367},
    {0xAD1, 0xADF, 77, 264, 360},
    {0xAE0, 0xAE1, 77, 277, 367},
    {0xAE2, 0xAE3, 77, 277, 364},
    {0xAE4, 0xAE5, 77, 264, 360},
    {0xAE6, 0xAEF, 77, 277, 371},
    {0xAF0, 0xAF0, 77, 264, 360},
    {0xAF1, 0xAF1, 77, 277, 360},
    {0xAF2, 0xAFF, 77, 264, 360},
    {0xB00, 0xB00, 78, 264, 360},
    {0xB01, 0xB03, 78, 278, 364},
    {0xB04, 0xB04, 78, 264, 360},
    {0xB05, 0xB0C, 78, 278, 367},
    {0xB0D, 0xB0E, 78, 264, 360},
    {0xB0F, 0xB10, 78, 278, 367},
    {0xB11, 0xB12, 78, 264, 360},
    {0xB13, 0xB28, 78, 278, 367},
    {0xB29, 0xB29, 78, 264, 360},
    {0xB2A, 0xB30, 78, 278, 367},
    {0xB31, 0xB31, 78, 264, 360},
    {0xB32, 0xB33, 78, 278, 367},
    {0xB34, 0xB34, 78, 264, 360},
    {0xB35, 0xB39, 78, 278, 367},
    {0xB3A, 0xB3B, 78, 264, 360},
    {0xB3C, 0xB3C, 78, 278, 364},
    {0xB3D, 0xB3D, 78, 278, 367},
    {0xB3E, 0xB44, 78, 278, 364},
    {0xB45, 0xB46, 78, 264, 360},
    {0xB47, 0xB48, 78, 278, 364},
    {0xB49, 0xB4A, 78, 264, 360},
    {0xB4B, 0xB4D, 78, 278, 364},
    {0xB4E, 0xB55, 78, 264, 360},
    {0xB56, 0xB57, 78, 278, 364},
    {0xB58, 0xB5B, 78, 264, 360},
    {0xB5C, 0xB5D, 78, 278, 367},
    {0xB5E, 0xB5E, 78, 264, 360},
    {0xB5F, 0xB61, 78, 278, 367},
    {0xB62, 0xB63, 78, 278, 364},
    {0xB64, 0xB65, 78, 264, 360},
    {0xB66, 0xB6F, 78, 278, 371},
    {0xB70, 0xB70, 78, 278, 360},
    {0xB71, 0xB71, 78, 278, 367},
    {0xB72, 0xB77, 78, 278, 360},
    {0xB78, 0xB7F, 78, 264, 360},
    {0xB80, 0xB81, 79, 264, 360},
    {0xB82, 0xB82, 79, 279, 364},
    {0xB83, 0xB83, 79, 279, 367},
    {0xB84, 0xB84, 79, 264, 360},
    {0xB85, 0xB8A, 79, 279, 367},
    {0xB8B, 0xB8D, 79, 264, 360},
    {0xB8E, 0xB90, 79, 279, 367},
    {0xB91, 0xB91, 79, 264, 360},
    {0xB92, 0xB95, 79, 279, 367},
    {0xB96, 0xB98, 79, 264, 360},
    {0xB99, 0xB9A, 79, 279, 367},
    {0xB9B, 0xB9B, 79, 264, 360},
    {0xB9C, 0xB9C, 79, 279, 367},
    {0xB9D, 0xB9D, 79, 264, 360},
    {0xB9E, 0xB9F, 79, 279, 367},
    {0xBA0, 0xBA2, 79, 264, 360},
    {0xBA3, 0xBA4, 79, 279, 367},
    {0xBA5, 0xBA7, 79, 264, 360},
    {0xBA8, 0xBAA, 79, 279, 367},
    {0xBAB, 0xBAD, 79, 264, 360},
    {0xBAE, 0xBB9, 79, 279, 367},
    {0xBBA, 0xBBD, 79, 264, 360},
    {0xBBE, 0xBC2, 79, 279, 364},
    {0xBC3, 0xBC5, 79, 264, 360},
    {0xBC6, 0xBC8, 79, 279, 364},
    {0xBC9, 0xBC9, 79, 264, 360},
    {0xBCA, 0xBCD, 79, 279, 364},
    {0xBCE, 0xBCF, 79, 264, 360},
    {0xBD0, 0xBD0, 79, 279, 367},
    {0xBD1, 0xBD6, 79, 264, 360},
    {0xBD7, 0xBD7, 79, 279, 364},
    {0xBD8, 0xBE5, 79, 264, 360},
    {0xBE6, 0xBEF, 79, 279, 371},
    {0xBF0, 0xBFA, 79, 279, 360},
    {0xBFB, 0xBFF, 79, 264, 360},
    {0xC00, 0xC00, 80, 264, 360},
    {0xC01, 0xC03, 80, 280, 364},
    {0xC04, 0xC04, 80, 264, 360},
    {0xC05, 0xC0C, 80, 280, 367},
    {0xC0D, 0xC0D, 80, 264, 360},
    {0xC0E, 0xC10, 80, 280, 367},
    {0xC11, 0xC11, 80, 264, 360},
    {0xC12, 0xC28, 80, 280, 367},
    {0xC29, 0xC29, 80, 264, 360},
    {0xC2A, 0xC33, 80, 280, 367},
    {0xC34, 0xC34, 80, 264, 360},
    {0xC35, 0xC39, 80, 280, 367},
    {0xC3A, 0xC3C, 80, 264, 360},
    {0xC3D, 0xC3D, 80, 280, 367},
    {0xC3E, 0xC44, 80, 280, 364},
    {0xC45, 0xC45, 80, 264, 360},
    {0xC46, 0xC48, 80, 280, 364},
    {0xC49, 0xC49, 80, 264, 360},
    {0xC4A, 0xC4D, 80, 280, 364},
    {0xC4E, 0xC54, 80, 264, 360},
    {0xC55, 0xC56, 80, 280, 364},
    {0xC57, 0xC57, 80, 264, 360},
    {0xC58, 0xC59, 80, 280, 367},
    {0xC5A, 0xC5F, 80, 264, 360},
    {0xC60, 0xC61, 80, 280, 367},
    {0xC62, 0xC63, 80, 280, 364},
    {0xC64, 0xC65, 80, 264, 360},
    {0xC66, 0xC6F, 80, 280, 371},
    {0xC70, 0xC77, 80, 264, 360},
    {0xC78, 0xC7F, 80, 280, 360},
    {0xC80, 0xC81, 81, 264, 360},
    {0xC82, 0xC83, 81, 281, 364},
    {0xC84, 0xC84, 81, 264, 360},
    {0xC85, 0xC8C, 81, 281, 367},
    {0xC8D, 0xC8D, 81, 264, 360},
    {0xC8E, 0xC90, 81, 281, 367},
    {0xC91, 0xC91, 81, 264, 360},
    {0xC92, 0xCA8, 81, 281, 367},
    {0xCA9, 0xCA9, 81, 264, 360},
    {0xCAA, 0xCB3, 81, 281, 367},
    {0xCB4, 0xCB4, 81, 264, 360},
    {0xCB5, 0xCB9, 81, 281, 367},
    {0xCBA, 0xCBB, 81, 264, 360},
    {0xCBC, 0xCBC, 81, 281, 364},
    {0xCBD, 0xCBD, 81, 281, 367},
    {0xCBE, 0xCC4, 81, 281, 364},
    {0xCC5, 0xCC5, 81, 264, 360},
    {0xCC6, 0xCC8, 81, 281, 364},
    {0xCC9, 0xCC9, 81, 264, 360},
    {0xCCA, 0xCCD, 81, 281, 364},
    {0xCCE, 0xCD4, 81, 264, 360},
    {0xCD5, 0xCD6, 81, 281, 364},
    {0xCD7, 0xCDD, 81, 264, 360},
    {0xCDE, 0xCDE, 81, 281, 367},
    {0xCDF, 0xCDF, 81, 264, 360},
    {0xCE0, 0xCE1, 81, 281, 367},
    {0xCE2, 0xCE3, 81, 281, 364},
    {0xCE4, 0xCE5, 81, 264, 360},
    {0xCE6, 0xCEF, 81, 281, 371},
    {0xCF0, 0xCF0, 81, 264, 360},
    {0xCF1, 0xCF2, 81, 281, 367},
    {0xCF3, 0xCFF, 81, 264, 360},
    {0xD00, 0xD01, 82, 264, 360},
    {0xD02, 0xD03, 82, 282, 364},
    {0xD04, 0xD04, 82, 264, 360},
    {0xD05, 0xD0C, 82, 282, 367},
    {0xD0D, 0xD0D, 82, 264, 360},
    {0xD0E, 0xD10, 82, 282, 367},
    {0xD11, 0xD11, 82, 264, 360},
    {0xD12, 0xD3A, 82, 282, 367},
    {0xD3B, 0xD3C, 82, 264, 360},
    {0xD3D, 0xD3D, 82, 282, 367},
    {0xD3E, 0xD44, 82, 282, 364},
    {0xD45, 0xD45, 82, 264, 360},
    {0xD46, 0xD48, 82, 282, 364},
    {0xD49, 0xD49, 82, 264, 360},
    {0xD4A, 0xD4D, 82, 282, 364},
    {0xD4E, 0xD4E, 82, 282, 367},
    {0xD4F, 0xD56, 82, 264, 360},
    {0xD57, 0xD57, 82, 282, 364},
    {0xD58, 0xD5F, 82, 264, 360},
    {0xD60, 0xD61, 82, 282, 367},
    {0xD62, 0xD63, 82, 282, 364},
    {0xD64, 0xD65, 82, 264, 360},
    {0xD66, 0xD6F, 82, 282, 371},
    {0xD70, 0xD75, 82, 282, 360},
    {0xD76, 0xD78, 82, 264, 360},
    {0xD79, 0xD79, 82, 282, 360},
    {0xD7A, 0xD7F, 82, 282, 367},
    {0xD80, 0xD81, 83, 264, 360},
    {0xD82, 0xD83, 83, 283, 364},
    {0xD84, 0xD84, 83, 264, 360},
    {0xD85, 0xD96, 83, 283, 367},
    {0xD97, 0xD99, 83, 264, 360},
    {0xD9A, 0xDB1, 83, 283, 367},
    {0xDB2, 0xDB2, 83, 264, 360},
    {0xDB3, 0xDBB, 83, 283, 367},
    {0xDBC, 0xDBC, 83, 264, 360},
    {0xDBD, 0xDBD, 83, 283, 367},
    {0xDBE, 0xDBF, 83, 264, 360},
    {0xDC0, 0xDC6, 83, 283, 367},
    {0xDC7, 0xDC9, 83, 264, 360},
    {0xDCA, 0xDCA, 83, 283, 364},
    {0xDCB, 0xDCE, 83, 264, 360},
    {0xDCF, 0xDD4, 83, 283, 364},
    {0xDD5, 0xDD5, 83, 264, 360},
    {0xDD6, 0xDD6, 83, 283, 364},
    {0xDD7, 0xDD7, 83, 264, 360},
    {0xDD8, 0xDDF, 83, 283, 364},
    {0xDE0, 0xDF1, 83, 264, 360},
    {0xDF2, 0xDF3, 83, 283, 364},
    {0xDF4, 0xDF4, 83, 283, 360},
    {0xDF5, 0xDFF, 83, 264, 360},
    {0xE00, 0xE00, 84, 264, 360},
    {0xE01, 0xE30, 84, 284, 360},
    {0xE31, 0xE31, 84, 284, 364},
    {0xE32, 0xE33, 84, 284, 360},
    {0xE34, 0xE3A, 84, 284, 364},
    {0xE3B, 0xE3E, 84, 264, 360},
    {0xE3F, 0xE3F, 84, 265, 360},
    {0xE40, 0xE46, 84, 284, 360},
    {0xE47, 0xE4E, 84, 284, 364},
    {0xE4F, 0xE4F, 84, 284, 360},
    {0xE50, 0xE59, 84, 284, 371},
    {0xE5A, 0xE5B, 84, 284, 360},
    {0xE5C, 0xE7F, 84, 264, 360},
    {0xE80, 0xE80, 85, 264, 360},
    {0xE81, 0xE82, 85, 285, 360},
    {0xE83, 0xE83, 85, 264, 360},
    {0xE84, 0xE84, 85, 285, 360},
    {0xE85, 0xE86, 85, 264, 360},
    {0xE87, 0xE88, 85, 285, 360},
    {0xE89, 0xE89, 85, 264, 360},
    {0xE8A, 0xE8A, 85, 285, 360},
    {0xE8B, 0xE8C, 85, 264, 360},
    {0xE8D, 0xE8D, 85, 285, 360},
    {0xE8E, 0xE93, 85, 264, 360},
    {0xE94, 0xE97, 85, 285, 360},
    {0xE98, 0xE98, 85, 264, 360},
    {0xE99, 0xE9F, 85, 285, 360},
    {0xEA0, 0xEA0, 85, 264, 360},
    {0xEA1, 0xEA3, 85, 285, 360},
    {0xEA4, 0xEA4, 85, 264, 360},
    {0xEA5, 0xEA5, 85, 285, 360},
    {0xEA6, 0xEA6, 85, 264, 360},
    {0xEA7, 0xEA7, 85, 285, 360},
    {0xEA8, 0xEA9, 85, 264, 360},
    {0xEAA, 0xEAB, 85, 285, 360},
    {0xEAC, 0xEAC, 85, 264, 360},
    {0xEAD, 0xEB0, 85, 285, 360},
    {0xEB1, 0xEB1, 85, 285, 364},
    {0xEB2, 0xEB3, 85, 285, 360},
    {0xEB4, 0xEB9, 85, 285, 364},
    {0xEBA, 0xEBA, 85, 264, 360},
    {0xEBB, 0xEBC, 85, 285, 364},
    {0xEBD, 0xEBD, 85, 285, 360},
    {0xEBE, 0xEBF, 85, 264, 360},
    {0xEC0, 0xEC4, 85, 285, 360},
    {0xEC5, 0xEC5, 85, 264, 360},
    {0xEC6, 0xEC6, 85, 285, 360},
    {0xEC7, 0xEC7, 85, 264, 360},
    {0xEC8, 0xECD, 85, 285, 364},
    {0xECE, 0xECF, 85, 264, 360},
    {0xED0, 0xED9, 85, 285, 371},
    {0xEDA, 0xEDB, 85, 264, 360},
    {0xEDC, 0xEDD, 85, 285, 360},
    {0xEDE, 0xEFF, 85, 264, 360},
    {0xF00, 0xF00, 86, 286, 367},
    {0xF01, 0xF17, 86, 286, 360},
    {0xF18, 0xF19, 86, 286, 364},
    {0xF1A, 0xF1F, 86, 286, 360},
    {0xF20, 0xF29, 86, 286, 371},
    {0xF2A, 0xF34, 86, 286, 360},
    {0xF35, 0xF35, 86, 286, 364},
    {0xF36, 0xF36, 86, 286, 360},
    {0xF37, 0xF37, 86, 286, 364},
    {0xF38, 0xF38, 86, 286, 360},
    {0xF39, 0xF39, 86, 286, 364},
    {0xF3A, 0xF3D, 86, 286, 360},
    {0xF3E, 0xF3F, 86, 286, 364},
    {0xF40, 0xF47, 86, 286, 367},
    {0xF48, 0xF48, 86, 264, 360},
    {0xF49, 0xF6C, 86, 286, 367},
    {0xF6D, 0xF70, 86, 264, 360},
    {0xF71, 0xF84, 86, 286, 364},
    {0xF85, 0xF85, 86, 286, 360},
    {0xF86, 0xF87, 86, 286, 364},
    {0xF88, 0xF8C, 86, 286, 367},
    {0xF8D, 0xF97, 86, 286, 364},
    {0xF98, 0xF98, 86, 264, 360},
    {0xF99, 0xFBC, 86, 286, 364},
    {0xFBD, 0xFBD, 86, 264, 360},
    {0xFBE, 0xFC5, 86, 286, 360},
    {0xFC6, 0xFC6, 86, 286, 364},
    {0xFC7, 0xFCC, 86, 286, 360},
    {0xFCD, 0xFCD, 86, 264, 360},
    {0xFCE, 0xFD4, 86, 286, 360},
    {0xFD5, 0xFD8, 86, 265, 360},
    {0xFD9, 0xFDA, 86, 286, 360},
    {0xFDB, 0xFFF, 86, 264, 360},
    {0x1000, 0x102A, 87, 287, 360},
    {0x102B, 0x103E, 87, 287, 364},
    {0x103F, 0x103F, 87, 287, 360},
    {0x1040, 0x1049, 87, 287, 371},
    {0x104A, 0x1055, 87, 287, 360},
    {0x1056, 0x1059, 87, 287, 364},
    {0x105A, 0x105D, 87, 287, 360},
    {0x105E, 0x1060, 87, 287, 364},
    {0x1061, 0x1061, 87, 287, 360},
    {0x1062, 0x1064, 87, 287, 364},
    {0x1065, 0x1066, 87, 287, 360},
    {0x1067, 0x106D, 87, 287, 364},
    {0x106E, 0x1070, 87, 287, 360},
    {0x1071, 0x1074, 87, 287, 364},
    {0x1075, 0x1081, 87, 287, 360},
    {0x1082, 0x108D, 87, 287, 364},
    {0x108E, 0x108E, 87, 287, 360},
    {0x108F, 0x108F, 87, 287, 364},
    {0x1090, 0x1099, 87, 287, 371},
    {0x109A, 0x109D, 87, 287, 364},
    {0x109E, 0x109F, 87, 287, 360},
    {0x10A0, 0x10C5, 88, 288, 367},
    {0x10C6, 0x10CF, 88, 264, 360},
    {0x10D0, 0x10FA, 88, 288, 367},
    {0x10FB, 0x10FB, 88, 265, 360},
    {0x10FC, 0x10FC, 88, 288, 367},
    {0x10FD, 0x10FF, 88, 264, 360},
    {0x1100, 0x11FF, 89, 289, 367},
    {0x1200, 0x1248, 90, 290, 367},
    {0x1249, 0x1249, 90, 264, 360},
    {0x124A, 0x124D, 90, 290, 367},
    {0x124E, 0x124F, 90, 264, 360},
    {0x1250, 0x1256, 90, 290, 367},
    {0x1257, 0x1257, 90, 264, 360},
    {0x1258, 0x1258, 90, 290, 367},
    {0x1259, 0x1259, 90, 264, 360},
    {0x125A, 0x125D, 90, 290, 367},
    {0x125E, 0x125F, 90, 264, 360},
    {0x1260, 0x1288, 90, 290, 367},
    {0x1289, 0x1289, 90, 264, 360},
    {0x128A, 0x128D, 90, 290, 367},
    {0x128E, 0x128F, 90, 264, 360},
    {0x1290, 0x12B0, 90, 290, 367},
    {0x12B1, 0x12B1, 90, 264, 360},
    {0x12B2, 0x12B5, 90, 290, 367},
    {0x12B6, 0x12B7, 90, 264, 360},
    {0x12B8, 0x12BE, 90, 290, 367},
    {0x12BF, 0x12BF, 90, 264, 360},
    {0x12C0, 0x12C0, 90, 290, 367},
    {0x12C1, 0x12C1, 90, 264, 360},
    {0x12C2, 0x12C5, 90, 290, 367},
    {0x12C6, 0x12C7, 90, 264, 360},
    {0x12C8, 0x12D6, 90, 290, 367},
    {0x12D7, 0x12D7, 90, 264, 360},
    {0x12D8, 0x1310, 90, 290, 367},
    {0x1311, 0x1311, 90, 264, 360},
    {0x1312, 0x1315, 90, 290, 367},
    {0x1316, 0x1317, 90, 264, 360},
    {0x1318, 0x135A, 90, 290, 367},
    {0x135B, 0x135C, 90, 264, 360},
    {0x135D, 0x135F, 90, 290, 364},
    {0x1360, 0x137C, 90, 290, 360},
    {0x137D, 0x137F, 90, 264, 360},
    {0x1380, 0x138F, 91, 290, 367},
    {0x1390, 0x1399, 91, 290, 360},
    {0x139A, 0x139F, 91, 264, 360},
    {0x13A0, 0x13F4, 92, 291, 367},
    {0x13F5, 0x13FF, 92, 264, 360},
    {0x1400, 0x1400, 93, 292, 360},
    {0x1401, 0x166C, 93, 292, 367},
    {0x166D, 0x166E, 93, 292, 360},
    {0x166F, 0x167F, 93, 292, 367},
    {0x1680, 0x1680, 94, 293, 360},
    {0x1681, 0x169A, 94, 293, 367},
    {0x169B, 0x169C, 94, 293, 360},
    {0x169D, 0x169F, 94, 264, 360},
    {0x16A0, 0x16EA, 95, 294, 367},
    {0x16EB, 0x16ED, 95, 265, 360},
    {0x16EE, 0x16F0, 95, 294, 367},
    {0x16F1, 0x16FF, 95, 264, 360},
    {0x1700, 0x170C, 96, 306, 367},
    {0x170D, 0x170D, 96, 264, 360},
    {0x170E, 0x1711, 96, 306, 367},
    {0x1712, 0x1714, 96, 306, 364},
    {0x1715, 0x171F, 96, 264, 360},
    {0x1720, 0x1731, 97, 307, 367},
    {0x1732, 0x1734, 97, 307, 364},
    {0x1735, 0x1736, 97, 265, 360},
    {0x1737, 0x173F, 97, 264, 360},
    {0x1740, 0x1751, 98, 308, 367},
    {0x1752, 0x1753, 98, 308, 364},
    {0x1754, 0x175F, 98, 264, 360},
    {0x1760, 0x176C, 99, 309, 367},
    {0x176D, 0x176D, 99, 264, 360},
    {0x176E, 0x1770, 99, 309, 367},
    {0x1771, 0x1771, 99, 264, 360},
    {0x1772, 0x1773, 99, 309, 364},
    {0x1774, 0x177F, 99, 264, 360},
    {0x1780, 0x17B3, 100, 295, 360},
    {0x17B4, 0x17B5, 100, 295, 365},
    {0x17B6, 0x17D3, 100, 295, 364},
    {0x17D4, 0x17DC, 100, 295, 360},
    {0x17DD, 0x17DD, 100, 295, 364},
    {0x17DE, 0x17DF, 100, 264, 360},
    {0x17E0, 0x17E9, 100, 295, 371},
    {0x17EA, 0x17EF, 100, 264, 360},
    {0x17F0, 0x17F9, 100, 295, 360},
    {0x17FA, 0x17FF, 100, 264, 360},
    {0x1800, 0x1801, 101, 296, 360},
    {0x1802, 0x1803, 101, 265, 360},
    {0x1804, 0x1804, 101, 296, 360},
    {0x1805, 0x1805, 101, 265, 360},
    {0x1806, 0x180A, 101, 296, 360},
    {0x180B, 0x180D, 101, 296, 364},
    {0x180E, 0x180E, 101, 296, 360},
    {0x180F, 0x180F, 101, 264, 360},
    {0x1810, 0x1819, 101, 296, 371},
    {0x181A, 0x181F, 101, 264, 360},
    {0x1820, 0x1877, 101, 296, 367},
    {0x1878, 0x187F, 101, 264, 360},
    {0x1880, 0x18A8, 101, 296, 367},
    {0x18A9, 0x18A9, 101, 296, 364},
    {0x18AA, 0x18AA, 101, 296, 367},
    {0x18AB, 0x18AF, 101, 264, 360},
    {0x18B0, 0x18F5, 102, 292, 367},
    {0x18F6, 0x18FF, 102, 264, 360},
    {0x1900, 0x191C, 103, 310, 367},
    {0x191D, 0x191F, 103, 264, 360},
    {0x1920, 0x192B, 103, 310, 364},
    {0x192C, 0x192F, 103, 264, 360},
    {0x1930, 0x193B, 103, 310, 364},
    {0x193C, 0x193F, 103, 264, 360},
    {0x1940, 0x1940, 103, 310, 360},
    {0x1941, 0x1943, 103, 264, 360},
    {0x1944, 0x1945, 103, 310, 360},
    {0x1946, 0x194F, 103, 310, 371},
    {0x1950, 0x196D, 104, 311, 360},
    {0x196E, 0x196F, 104, 264, 360},
    {0x1970, 0x1974, 104, 311, 360},
    {0x1975, 0x197F, 104, 264, 360},
    {0x1980, 0x19AB, 105, 320, 360},
    {0x19AC, 0x19AF, 105, 264, 360},
    {0x19B0, 0x19C0, 105, 320, 364},
    {0x19C1, 0x19C7, 105, 320, 360},
    {0x19C8, 0x19C9, 105, 320, 364},
    {0x19CA, 0x19CF, 105, 264, 360},
    {0x19D0, 0x19D9, 105, 320, 371},
    {0x19DA, 0x19DA, 105, 320, 360},
    {0x19DB, 0x19DD, 105, 264, 360},
    {0x19DE, 0x19DF, 105, 320, 360},
    {0x19E0, 0x19FF, 106, 295, 360},
    {0x1A00, 0x1A16, 107, 318, 367},
    {0x1A17, 0x1A1B, 107, 318, 364},
    {0x1A1C, 0x1A1D, 107, 264, 360},
    {0x1A1E, 0x1A1F, 107, 318, 360},
    {0x1A20, 0x1A54, 108, 342, 360},
    {0x1A55, 0x1A5E, 108, 342, 364},
    {0x1A5F, 0x1A5F, 108, 264, 360},
    {0x1A60, 0x1A7C, 108, 342, 364},
    {0x1A7D, 0x1A7E, 108, 264, 360},
    {0x1A7F, 0x1A7F, 108, 342, 364},
    {0x1A80, 0x1A89, 108, 342, 371},
    {0x1A8A, 0x1A8F, 108, 264, 360},
    {0x1A90, 0x1A99, 108, 342, 371},
    {0x1A9A, 0x1A9F, 108, 264, 360},
    {0x1AA0, 0x1AAD, 108, 342, 360},
    {0x1AAE, 0x1AAF, 108, 264, 360},
    {0x1AB0, 0x1AFF, 54, 264, 360},
    {0x1B00, 0x1B04, 109, 326, 364},
    {0x1B05, 0x1B33, 109, 326, 367},
    {0x1B34, 0x1B44, 109, 326, 364},
    {0x1B45, 0x1B4B, 109, 326, 367},
    {0x1B4C, 0x1B4F, 109, 264, 360},
    {0x1B50, 0x1B59, 109, 326, 371},
    {0x1B5A, 0x1B6A, 109, 326, 360},
    {0x1B6B, 0x1B73, 109, 326, 364},
    {0x1B74, 0x1B7C, 109, 326, 360},
    {0x1B7D, 0x1B7F, 109, 264, 360},
    {0x1B80, 0x1B82, 110, 331, 364},
    {0x1B83, 0x1BA0, 110, 331, 367},
    {0x1BA1, 0x1BAA, 110, 331, 364},
    {0x1BAB, 0x1BAD, 110, 264, 360},
    {0x1BAE, 0x1BAF, 110, 331, 367},
    {0x1BB0, 0x1BB9, 110, 331, 371},
    {0x1BBA, 0x1BBF, 110, 264, 360},
    {0x1BC0, 0x1BE5, 111, 357, 367},
    {0x1BE6, 0x1BF3, 111, 357, 364},
    {0x1BF4, 0x1BFB, 111, 264, 360},
    {0x1BFC, 0x1BFF, 111, 357, 360},
    {0x1C00, 0x1C23, 112, 332, 367},
    {0x1C24, 0x1C37, 112, 332, 364},
    {0x1C38, 0x1C3A, 112, 264, 360},
    {0x1C3B, 0x1C3F, 112, 332, 360},
    {0x1C40, 0x1C49, 112, 332, 371},
    {0x1C4A, 0x1C4C, 112, 264, 360},
    {0x1C4D, 0x1C4F, 112, 332, 367},
    {0x1C50, 0x1C59, 113, 333, 371},
    {0x1C5A, 0x1C7D, 113, 333, 367},
    {0x1C7E, 0x1C7F, 113, 333, 360},
    {0x1C80, 0x1CCF, 54, 264, 360},
    {0x1CD0, 0x1CD2, 114, 305, 364},
    {0x1CD3, 0x1CD3, 114, 265, 360},
    {0x1CD4, 0x1CE0, 114, 305, 364},
    {0x1CE1, 0x1CE1, 114, 265, 364},
    {0x1CE2, 0x1CE8, 114, 305, 364},
    {0x1CE9, 0x1CEC, 114, 265, 367},
    {0x1CED, 0x1CED, 114, 305, 364},
    {0x1CEE, 0x1CF1, 114, 265, 367},
    {0x1CF2, 0x1CF2, 114, 265, 364},
    {0x1CF3, 0x1CFF, 114, 264, 360},
    {0x1D00, 0x1D25, 115, 266, 367},
    {0x1D26, 0x1D2A, 115, 267, 367},
    {0x1D2B, 0x1D2B, 115, 268, 367},
    {0x1D2C, 0x1D5C, 115, 266, 367},
    {0x1D5D, 0x1D61, 115, 267, 367},
    {0x1D62, 0x1D65, 115, 266, 367},
    {0x1D66, 0x1D6A, 115, 267, 367},
    {0x1D6B, 0x1D77, 115, 266, 367},
    {0x1D78, 0x1D78, 115, 268, 367},
    {0x1D79, 0x1D7F, 115, 266, 367},
    {0x1D80, 0x1DBE, 116, 266, 367},
    {0x1DBF, 0x1DBF, 116, 267, 367},
    {0x1DC0, 0x1DE6, 117, 305, 364},
    {0x1DE7, 0x1DFB, 117, 264, 360},
    {0x1DFC, 0x1DFF, 117, 305, 364},
    {0x1E00, 0x1EFF, 118, 266, 367},
    {0x1F00, 0x1F15, 119, 267, 367},
    {0x1F16, 0x1F17, 119, 264, 360},
    {0x1F18, 0x1F1D, 119, 267, 367},
    {0x1F1E, 0x1F1F, 119, 264, 360},
    {0x1F20, 0x1F45, 119, 267, 367},
    {0x1F46, 0x1F47, 119, 264, 360},
    {0x1F48, 0x1F4D, 119, 267, 367},
    {0x1F4E, 0x1F4F, 119, 264, 360},
    {0x1F50, 0x1F57, 119, 267, 367},
    {0x1F58, 0x1F58, 119, 264, 360},
    {0x1F59, 0x1F59, 119, 267, 367},
    {0x1F5A, 0x1F5A, 119, 264, 360},
    {0x1F5B, 0x1F5B, 119, 267, 367},
    {0x1F5C, 0x1F5C, 119, 264, 360},
    {0x1F5D, 0x1F5D, 119, 267, 367},
    {0x1F5E, 0x1F5E, 119, 264, 360},
    {0x1F5F, 0x1F7D, 119, 267, 367},
    {0x1F7E, 0x1F7F, 119, 264, 360},
    {0x1F80, 0x1FB4, 119, 267, 367},
    {0x1FB5, 0x1FB5, 119, 264, 360},
    {0x1FB6, 0x1FBC, 119, 267, 367},
    {0x1FBD, 0x1FBD, 119, 267, 360},
    {0x1FBE, 0x1FBE, 119, 267, 367},
    {0x1FBF, 0x1FC1, 119, 267, 360},
    {0x1FC2, 0x1FC4, 119, 267, 367},
    {0x1FC5, 0x1FC5, 119, 264, 360},
    {0x1FC6, 0x1FCC, 119, 267, 367},
    {0x1FCD, 0x1FCF, 119, 267, 360},
    {0x1FD0, 0x1FD3, 119, 267, 367},
    {0x1FD4, 0x1FD5, 119, 264, 360},
    {0x1FD6, 0x1FDB, 119, 267, 367},
    {0x1FDC, 0x1FDC, 119, 264, 360},
    {0x1FDD, 0x1FDF, 119, 267, 360},
    {0x1FE0, 0x1FEC, 119, 267, 367},
    {0x1FED, 0x1FEF, 119, 267, 360},
    {0x1FF0, 0x1FF1, 119, 264, 360},
    {0x1FF2, 0x1FF4, 119, 267, 367},
    {0x1FF5, 0x1FF5, 119, 264, 360},
    {0x1FF6, 0x1FFC, 119, 267, 367},
    {0x1FFD, 0x1FFE, 119, 267, 360},
    {0x1FFF, 0x1FFF, 119, 264, 360},
    {0x2000, 0x200B, 120, 265, 360},
    {0x200C, 0x200D, 120, 305, 364},
    {0x200E, 0x200F, 120, 265, 365},
    {0x2010, 0x2017, 120, 265, 360},
    {0x2018, 0x2019, 120, 265, 370},
    {0x201A, 0x2023, 120, 265, 360},
    {0x2024, 0x2024, 120, 265, 370},
    {0x2025, 0x2026, 120, 265, 360},
    {0x2027, 0x2027, 120, 265, 368},
    {0x2028, 0x2029, 120, 265, 363},
    {0x202A, 0x202E, 120, 265, 365},
    {0x202F, 0x203E, 120, 265, 360},
    {0x203F, 0x2040, 120, 265, 372},
    {0x2041, 0x2043, 120, 265, 360},
    {0x2044, 0x2044, 120, 265, 369},
    {0x2045, 0x2053, 120, 265, 360},
    {0x2054, 0x2054, 120, 265, 372},
    {0x2055, 0x205F, 120, 265, 360},
    {0x2060, 0x2064, 120, 265, 365},
    {0x2065, 0x2069, 120, 264, 360},
    {0x206A, 0x206F, 120, 265, 365},
    {0x2070, 0x2070, 121, 265, 360},
    {0x2071, 0x2071, 121, 266, 367},
    {0x2072, 0x2073, 121, 264, 360},
    {0x2074, 0x207E, 121, 265, 360},
    {0x207F, 0x207F, 121, 266, 367},
    {0x2080, 0x208E, 121, 265, 360},
    {0x208F, 0x208F, 121, 264, 360},
    {0x2090, 0x209C, 121, 266, 367},
    {0x209D, 0x209F, 121, 264, 360},
    {0x20A0, 0x20B9, 122, 265, 360},
    {0x20BA, 0x20CF, 122, 264, 360},
    {0x20D0, 0x20F0, 123, 305, 364},
    {0x20F1, 0x20FF, 123, 264, 360},
    {0x2100, 0x2101, 124, 265, 360},
    {0x2102, 0x2102, 124, 265, 367},
    {0x2103, 0x2106, 124, 265, 360},
    {0x2107, 0x2107, 124, 265, 367},
    {0x2108, 0x2109, 124, 265, 360},
    {0x210A, 0x2113, 124, 265, 367},
    {0x2114, 0x2114, 124, 265, 360},
    {0x2115, 0x2115, 124, 265, 367},
    {0x2116, 0x2118, 124, 265, 360},
    {0x2119, 0x211D, 124, 265, 367},
    {0x211E, 0x2123, 124, 265, 360},
    {0x2124, 0x2124, 124, 265, 367},
    {0x2125, 0x2125, 124, 265, 360},
    {0x2126, 0x2126, 124, 267, 367},
    {0x2127, 0x2127, 124, 265, 360},
    {0x2128, 0x2128, 124, 265, 367},
    {0x2129, 0x2129, 124, 265, 360},
    {0x212A, 0x212B, 124, 266, 367},
    {0x212C, 0x212D, 124, 265, 367},
    {0x212E, 0x212E, 124, 265, 360},
    {0x212F, 0x2131, 124, 265, 367},
    {0x2132, 0x2132, 124, 266, 367},
    {0x2133, 0x2139, 124, 265, 367},
    {0x213A, 0x213B, 124, 265, 360},
    {0x213C, 0x213F, 124, 265, 367},
    {0x2140, 0x2144, 124, 265, 360},
    {0x2145, 0x2149, 124, 265, 367},
    {0x214A, 0x214D, 124, 265, 360},
    {0x214E, 0x214E, 124, 266, 367},
    {0x214F, 0x214F, 124, 265, 360},
    {0x2150, 0x215F, 125, 265, 360},
    {0x2160, 0x2188, 125, 266, 367},
    {0x2189, 0x2189, 125, 265, 360},
    {0x218A, 0x218F, 125, 264, 360},
    {0x2190, 0x21FF, 126, 265, 360},
    {0x2200, 0x22FF, 127, 265, 360},
    {0x2300, 0x23F3, 128, 265, 360},
    {0x23F4, 0x23FF, 128, 264, 360},
    {0x2400, 0x2426, 129, 265, 360},
    {0x2427, 0x243F, 129, 264, 360},
    {0x2440, 0x244A, 130, 265, 360},
    {0x244B, 0x245F, 130, 264, 360},
    {0x2460, 0x24B5, 131, 265, 360},
    {0x24B6, 0x24E9, 131, 265, 367},
    {0x24EA, 0x24FF, 131, 265, 360},
    {0x2500, 0x257F, 132, 265, 360},
    {0x2580, 0x259F, 133, 265, 360},
    {0x25A0, 0x25FF, 134, 265, 360},
    {0x2600, 0x26FF, 135, 265, 360},
    {0x2700, 0x2700, 136, 264, 360},
    {0x2701, 0x27BF, 136, 265, 360},
    {0x27C0, 0x27CA, 137, 265, 360},
    {0x27CB, 0x27CB, 137, 264, 360},
    {0x27CC, 0x27CC, 137, 265, 360},
    {0x27CD, 0x27CD, 137, 264, 360},
    {0x27CE, 0x27EF, 137, 265, 360},
    {0x27F0, 0x27FF, 138, 265, 360},
    {0x2800, 0x28FF, 139, 317, 360},
    {0x2900, 0x297F, 140, 265, 360},
    {0x2980, 0x29FF, 141, 265, 360},
    {0x2A00, 0x2AFF, 142, 265, 360},
    {0x2B00, 0x2B4C, 143, 265, 360},
    {0x2B4D, 0x2B4F, 143, 264, 360},
    {0x2B50, 0x2B59, 143, 265, 360},
    {0x2B5A, 0x2BFF, 143, 264, 360},
    {0x2C00, 0x2C2E, 144, 321, 367},
    {0x2C2F, 0x2C2F, 144, 264, 360},
    {0x2C30, 0x2C5E, 144, 321, 367},
    {0x2C5F, 0x2C5F, 144, 264, 360},
    {0x2C60, 0x2C7F, 145, 266, 367},
    {0x2C80, 0x2CE4, 146, 319, 367},
    {0x2CE5, 0x2CEA, 146, 319, 360},
    {0x2CEB, 0x2CEE, 146, 319, 367},
    {0x2CEF, 0x2CF1, 146, 319, 364},
    {0x2CF2, 0x2CF8, 146, 264, 360},
    {0x2CF9, 0x2CFF, 146, 319, 360},
    {0x2D00, 0x2D25, 147, 288, 367},
    {0x2D26, 0x2D2F, 147, 264, 360},
    {0x2D30, 0x2D65, 148, 322, 367},
    {0x2D66, 0x2D6E, 148, 264, 360},
    {0x2D6F, 0x2D6F, 148, 322, 367},
    {0x2D70, 0x2D70, 148, 322, 360},
    {0x2D71, 0x2D7E, 148, 264, 360},
    {0x2D7F, 0x2D7F, 148, 322, 364},
    {0x2D80, 0x2D96, 149, 290, 367},
    {0x2D97, 0x2D9F, 149, 264, 360},
    {0x2DA0, 0x2DA6, 149, 290, 367},
    {0x2DA7, 0x2DA7, 149, 264, 360},
    {0x2DA8, 0x2DAE, 149, 290, 367},
    {0x2DAF, 0x2DAF, 149, 264, 360},
    {0x2DB0, 0x2DB6, 149, 290, 367},
    {0x2DB7, 0x2DB7, 149, 264, 360},
    {0x2DB8, 0x2DBE, 149, 290, 367},
    {0x2DBF, 0x2DBF, 149, 264, 360},
    {0x2DC0, 0x2DC6, 149, 290, 367},
    {0x2DC7, 0x2DC7, 149, 264, 360},
    {0x2DC8, 0x2DCE, 149, 290, 367},
    {0x2DCF, 0x2DCF, 149, 264, 360},
    {0x2DD0, 0x2DD6, 149, 290, 367},
    {0x2DD7, 0x2DD7, 149, 264, 360},
    {0x2DD8, 0x2DDE, 149, 290, 367},
    {0x2DDF, 0x2DDF, 149, 264, 360},
    {0x2DE0, 0x2DFF, 150, 268, 364},
    {0x2E00, 0x2E2E, 151, 265, 360},
    {0x2E2F, 0x2E2F, 151, 265, 367},
    {0x2E30, 0x2E31, 151, 265, 360},
    {0x2E32, 0x2E7F, 151, 264, 360},
    {0x2E80, 0x2E99, 152, 300, 360},
    {0x2E9A, 0x2E9A, 152, 264, 360},
    {0x2E9B, 0x2EF3, 152, 300, 360},
    {0x2EF4, 0x2EFF, 152, 264, 360},
    {0x2F00, 0x2FD5, 153, 300, 360},
    {0x2FD6, 0x2FDF, 153, 264, 360},
    {0x2FE0, 0x2FEF, 54, 264, 360},
    {0x2FF0, 0x2FFB, 154, 265, 360},
    {0x2FFC, 0x2FFF, 154, 264, 360},
    {0x3000, 0x3004, 155, 265, 360},
    {0x3005, 0x3005, 155, 300, 367},
    {0x3006, 0x3006, 155, 265, 360},
    {0x3007, 0x3007, 155, 300, 360},
    {0x3008, 0x3020, 155, 265, 360},
    {0x3021, 0x3029, 155, 300, 360},
    {0x302A, 0x302D, 155, 305, 364},
    {0x302E, 0x302F, 155, 289, 364},
    {0x3030, 0x3030, 155, 265, 360},
    {0x3031, 0x3035, 155, 265, 366},
    {0x3036, 0x3037, 155, 265, 360},
    {0x3038, 0x303A, 155, 300, 360},
    {0x303B, 0x303B, 155, 300, 367},
    {0x303C, 0x303C, 155, 265, 367},
    {0x303D, 0x303F, 155, 265, 360},
    {0x3040, 0x3040, 156, 264, 360},
    {0x3041, 0x3096, 156, 297, 360},
    {0x3097, 0x3098, 156, 264, 360},
    {0x3099, 0x309A, 156, 305, 364},
    {0x309B, 0x309C, 156, 265, 366},
    {0x309D, 0x309F, 156, 297, 360},
    {0x30A0, 0x30A0, 157, 265, 366},
    {0x30A1, 0x30FA, 157, 298, 366},
    {0x30FB, 0x30FB, 157, 265, 360},
    {0x30FC, 0x30FC, 157, 265, 366},
    {0x30FD, 0x30FF, 157, 298, 366},
    {0x3100, 0x3104, 158, 264, 360},
    {0x3105, 0x312D, 158, 299, 367},
    {0x312E, 0x312F, 158, 264, 360},
    {0x3130, 0x3130, 159, 264, 360},
    {0x3131, 0x318E, 159, 289, 367},
    {0x318F, 0x318F, 159, 264, 360},
    {0x3190, 0x319F, 160, 265, 360},
    {0x31A0, 0x31BA, 161, 299, 367},
    {0x31BB, 0x31BF, 161, 264, 360},
    {0x31C0, 0x31E3, 162, 265, 360},
    {0x31E4, 0x31EF, 162, 264, 360},
    {0x31F0, 0x31FF, 163, 298, 366},
    {0x3200, 0x321E, 164, 289, 360},
    {0x321F, 0x321F, 164, 264, 360},
    {0x3220, 0x325F, 164, 265, 360},
    {0x3260, 0x327E, 164, 289, 360},
    {0x327F, 0x32CF, 164, 265, 360},
    {0x32D0, 0x32FE, 164, 298, 366},
    {0x32FF, 0x32FF, 164, 264, 360},
    {0x3300, 0x3357, 165, 298, 366},
    {0x3358, 0x33FF, 165, 265, 360},
    {0x3400, 0x4DB5, 166, 300, 360},
    {0x4DB6, 0x4DBF, 166, 264, 360},
    {0x4DC0, 0x4DFF, 167, 265, 360},
    {0x4E00, 0x9FCB, 168, 300, 360},
    {0x9FCC, 0x9FFF, 168, 264, 360},
    {0xA000, 0xA48C, 169, 301, 367},
    {0xA48D, 0xA48F, 169, 264, 360},
    {0xA490, 0xA4C6, 170, 301, 360},
    {0xA4C7, 0xA4CF, 170, 264, 360},
    {0xA4D0, 0xA4FD, 171, 347, 367},
    {0xA4FE, 0xA4FF, 171, 347, 360},
    {0xA500, 0xA60C, 172, 334, 367},
    {0xA60D, 0xA60F, 172, 334, 360},
    {0xA610, 0xA61F, 172, 334, 367},
    {0xA620, 0xA629, 172, 334, 371},
    {0xA62A, 0xA62B, 172, 334, 367},
    {0xA62C, 0xA63F, 172, 264, 360},
    {0xA640, 0xA66E, 173, 268, 367},
    {0xA66F, 0xA672, 173, 268, 364},
    {0xA673, 0xA673, 173, 268, 360},
    {0xA674, 0xA67B, 173, 264, 360},
    {0xA67C, 0xA67D, 173, 268, 364},
    {0xA67E, 0xA67E, 173, 268, 360},
    {0xA67F, 0xA697, 173, 268, 367},
    {0xA698, 0xA69F, 173, 264, 360},
    {0xA6A0, 0xA6EF, 174, 348, 367},
    {0xA6F0, 0xA6F1, 174, 348, 364},
    {0xA6F2, 0xA6F7, 174, 348, 360},
    {0xA6F8, 0xA6FF, 174, 264, 360},
    {0xA700, 0xA716, 175, 265, 360},
    {0xA717, 0xA71F, 175, 265, 367},
    {0xA720, 0xA721, 176, 265, 360},
    {0xA722, 0xA787, 176, 266, 367},
    {0xA788, 0xA788, 176, 265, 367},
    {0xA789, 0xA78A, 176, 265, 360},
    {0xA78B, 0xA78E, 176, 266, 367},
    {0xA78F, 0xA78F, 176, 264, 360},
    {0xA790, 0xA791, 176, 266, 367},
    {0xA792, 0xA79F, 176, 264, 360},
    {0xA7A0, 0xA7A9, 176, 266, 367},
    {0xA7AA, 0xA7F9, 176, 264, 360},
    {0xA7FA, 0xA7FF, 176, 266, 367},
    {0xA800, 0xA801, 177, 323, 367},
    {0xA802, 0xA802, 177, 323, 364},
    {0xA803, 0xA805, 177, 323, 367},
    {0xA806, 0xA806, 177, 323, 364},
    {0xA807, 0xA80A, 177, 323, 367},
    {0xA80B, 0xA80B, 177, 323, 364},
    {0xA80C, 0xA822, 177, 323, 367},
    {0xA823, 0xA827, 177, 323, 364},
    {0xA828, 0xA82B, 177, 323, 360},
    {0xA82C, 0xA82F, 177, 264, 360},
    {0xA830, 0xA839, 178, 265, 360},
    {0xA83A, 0xA83F, 178, 264, 360},
    {0xA840, 0xA873, 179, 329, 367},
    {0xA874, 0xA877, 179, 329, 360},
    {0xA878, 0xA87F, 179, 264, 360},
    {0xA880, 0xA881, 180, 335, 364},
    {0xA882, 0xA8B3, 180, 335, 367},
    {0xA8B4, 0xA8C4, 180, 335, 364},
    {0xA8C5, 0xA8CD, 180, 264, 360},
    {0xA8CE, 0xA8CF, 180, 335, 360},
    {0xA8D0, 0xA8D9, 180, 335, 371},
    {0xA8DA, 0xA8DF, 180, 264, 360},
    {0xA8E0, 0xA8F1, 181, 274, 364},
    {0xA8F2, 0xA8F7, 181, 274, 367},
    {0xA8F8, 0xA8FA, 181, 274, 360},
    {0xA8FB, 0xA8FB, 181, 274, 367},
    {0xA8FC, 0xA8FF, 181, 264, 360},
    {0xA900, 0xA909, 182, 336, 371},
    {0xA90A, 0xA925, 182, 336, 367},
    {0xA926, 0xA92D, 182, 336, 364},
    {0xA92E, 0xA92F, 182, 336, 360},
    {0xA930, 0xA946, 183, 337, 367},
    {0xA947, 0xA953, 183, 337, 364},
    {0xA954, 0xA95E, 183, 264, 360},
    {0xA95F, 0xA95F, 183, 337, 360},
    {0xA960, 0xA97C, 184, 289, 367},
    {0xA97D, 0xA97F, 184, 264, 360},
    {0xA980, 0xA983, 185, 349, 364},
    {0xA984, 0xA9B2, 185, 349, 367},
    {0xA9B3, 0xA9C0, 185, 349, 364},
    {0xA9C1, 0xA9CD, 185, 349, 360},
    {0xA9CE, 0xA9CE, 185, 264, 360},
    {0xA9CF, 0xA9CF, 185, 349, 367},
    {0xA9D0, 0xA9D9, 185, 349, 371},
    {0xA9DA, 0xA9DD, 185, 264, 360},
    {0xA9DE, 0xA9DF, 185, 349, 360},
    {0xA9E0, 0xA9FF, 54, 264, 360},
    {0xAA00, 0xAA28, 186, 341, 367},
    {0xAA29, 0xAA36, 186, 341, 364},
    {0xAA37, 0xAA3F, 186, 264, 360},
    {0xAA40, 0xAA42, 186, 341, 367},
    {0xAA43, 0xAA43, 186, 341, 364},
    {0xAA44, 0xAA4B, 186, 341, 367},
    {0xAA4C, 0xAA4D, 186, 341, 364},
    {0xAA4E, 0xAA4F, 186, 264, 360},
    {0xAA50, 0xAA59, 186, 341, 371},
    {0xAA5A, 0xAA5B, 186, 264, 360},
    {0xAA5C, 0xAA5F, 186, 341, 360},
    {0xAA60, 0xAA7A, 187, 287, 360},
    {0xAA7B, 0xAA7B, 187, 287, 364},
    {0xAA7C, 0xAA7F, 187, 264, 360},
    {0xAA80, 0xAAAF, 188, 343, 360},
    {0xAAB0, 0xAAB0, 188, 343, 364},
    {0xAAB1, 0xAAB1, 188, 343, 360},
    {0xAAB2, 0xAAB4, 188, 343, 364},
    {0xAAB5, 0xAAB6, 188, 343, 360},
    {0xAAB7, 0xAAB8, 188, 343, 364},
    {0xAAB9, 0xAABD, 188, 343, 360},
    {0xAABE, 0xAABF, 188, 343, 364},
    {0xAAC0, 0xAAC0, 188, 343, 360},
    {0xAAC1, 0xAAC1, 188, 343, 364},
    {0xAAC2, 0xAAC2, 188, 343, 360},
    {0xAAC3, 0xAADA, 188, 264, 360},
    {0xAADB, 0xAADF, 188, 343, 360},
    {0xAAE0, 0xAAFF, 54, 264, 360},
    {0xAB00, 0xAB00, 189, 264, 360},
    {0xAB01, 0xAB06, 189, 290, 367},
    {0xAB07, 0xAB08, 189, 264, 360},
    {0xAB09, 0xAB0E, 189, 290, 367},
    {0xAB0F, 0xAB10, 189, 264, 360},
    {0xAB11, 0xAB16, 189, 290, 367},
    {0xAB17, 0xAB1F, 189, 264, 360},
    {0xAB20, 0xAB26, 189, 290, 367},
    {0xAB27, 0xAB27, 189, 264, 360},
    {0xAB28, 0xAB2E, 189, 290, 367},
    {0xAB2F, 0xAB2F, 189, 264, 360},
    {0xAB30, 0xABBF, 54, 264, 360},
    {0xABC0, 0xABE2, 190, 350, 367},
    {0xABE3, 0xABEA, 190, 350, 364},
    {0xABEB, 0xABEB, 190, 350, 360},
    {0xABEC, 0xABED, 190, 350, 364},
    {0xABEE, 0xABEF, 190, 264, 360},
    {0xABF0, 0xABF9, 190, 350, 371},
    {0xABFA, 0xABFF, 190, 264, 360},
    {0xAC00, 0xD7A3, 191, 289, 367},
    {0xD7A4, 0xD7AF, 191, 264, 360},
    {0xD7B0, 0xD7C6, 192, 289, 367},
    {0xD7C7, 0xD7CA, 192, 264, 360},
    {0xD7CB, 0xD7FB, 192, 289, 367},
    {0xD7FC, 0xD7FF, 192, 264, 360},
    {0xD800, 0xDB7F, 193, 264, 360},
    {0xDB80, 0xDBFF, 194, 264, 360},
    {0xDC00, 0xDFFF, 195, 264, 360},
    {0xE000, 0xF8FF, 196, 264, 360},
    {0xF900, 0xFA2D, 197, 300, 360},
    {0xFA2E, 0xFA2F, 197, 264, 360},
    {0xFA30, 0xFA6D, 197, 300, 360},
    {0xFA6E, 0xFA6F, 197, 264, 360},
    {0xFA70, 0xFAD9, 197, 300, 360},
    {0xFADA, 0xFAFF, 197, 264, 360},
    {0xFB00, 0xFB06, 198, 266, 367},
    {0xFB07, 0xFB12, 198, 264, 360},
    {0xFB13, 0xFB17, 198, 269, 367},
    {0xFB18, 0xFB1C, 198, 264, 360},
    {0xFB1D, 0xFB1D, 198, 270, 367},
    {0xFB1E, 0xFB1E, 198, 270, 364},
    {0xFB1F, 0xFB28, 198, 270, 367},
    {0xFB29, 0xFB29, 198, 270, 360},
    {0xFB2A, 0xFB36, 198, 270, 367},
    {0xFB37, 0xFB37, 198, 264, 360},
    {0xFB38, 0xFB3C, 198, 270, 367},
    {0xFB3D, 0xFB3D, 198, 264, 360},
    {0xFB3E, 0xFB3E, 198, 270, 367},
    {0xFB3F, 0xFB3F, 198, 264, 360},
    {0xFB40, 0xFB41, 198, 270, 367},
    {0xFB42, 0xFB42, 198, 264, 360},
    {0xFB43, 0xFB44, 198, 270, 367},
    {0xFB45, 0xFB45, 198, 264, 360},
    {0xFB46, 0xFB4F, 198, 270, 367},
    {0xFB50, 0xFBB1, 199, 271, 367},
    {0xFBB2, 0xFBC1, 199, 271, 360},
    {0xFBC2, 0xFBD2, 199, 264, 360},
    {0xFBD3, 0xFD3D, 199, 271, 367},
    {0xFD3E, 0xFD3F, 199, 265, 360},
    {0xFD40, 0xFD4F, 199, 264, 360},
    {0xFD50, 0xFD8F, 199, 271, 367},
    {0xFD90, 0xFD91, 199, 264, 360},
    {0xFD92, 0xFDC7, 199, 271, 367},
    {0xFDC8, 0xFDEF, 199, 264, 360},
    {0xFDF0, 0xFDFB, 199, 271, 367},
    {0xFDFC, 0xFDFC, 199, 271, 360},
    {0xFDFD, 0xFDFD, 199, 265, 360},
    {0xFDFE, 0xFDFF, 199, 264, 360},
    {0xFE00, 0xFE0F, 200, 305, 364},
    {0xFE10, 0xFE10, 201, 265, 369},
    {0xFE11, 0xFE12, 201, 265, 360},
    {0xFE13, 0xFE13, 201, 265, 368},
    {0xFE14, 0xFE14, 201, 265, 369},
    {0xFE15, 0xFE19, 201, 265, 360},
    {0xFE1A, 0xFE1F, 201, 264, 360},
    {0xFE20, 0xFE26, 202, 305, 364},
    {0xFE27, 0xFE2F, 202, 264, 360},
    {0xFE30, 0xFE32, 203, 265, 360},
    {0xFE33, 0xFE34, 203, 265, 372},
    {0xFE35, 0xFE4C, 203, 265, 360},
    {0xFE4D, 0xFE4F, 203, 265, 372},
    {0xFE50, 0xFE50, 204, 265, 369},
    {0xFE51, 0xFE51, 204, 265, 360},
    {0xFE52, 0xFE52, 204, 265, 370},
    {0xFE53, 0xFE53, 204, 264, 360},
    {0xFE54, 0xFE54, 204, 265, 369},
    {0xFE55, 0xFE55, 204, 265, 368},
    {0xFE56, 0xFE66, 204, 265, 360},
    {0xFE67, 0xFE67, 204, 264, 360},
    {0xFE68, 0xFE6B, 204, 265, 360},
    {0xFE6C, 0xFE6F, 204, 264, 360},
    {0xFE70, 0xFE74, 205, 271, 367},
    {0xFE75, 0xFE75, 205, 264, 360},
    {0xFE76, 0xFEFC, 205, 271, 367},
    {0xFEFD, 0xFEFE, 205, 264, 360},
    {0xFEFF, 0xFEFF, 205, 265, 365},
    {0xFF00, 0xFF00, 206, 264, 360},
    {0xFF01, 0xFF06, 206, 265, 360},
    {0xFF07, 0xFF07, 206, 265, 370},
    {0xFF08, 0xFF0B, 206, 265, 360},
    {0xFF0C, 0xFF0C, 206, 265, 369},
    {0xFF0D, 0xFF0D, 206, 265, 360},
    {0xFF0E, 0xFF0E, 206, 265, 370},
    {0xFF0F, 0xFF19, 206, 265, 360},
    {0xFF1A, 0xFF1A, 206, 265, 368},
    {0xFF1B, 0xFF1B, 206, 265, 369},
    {0xFF1C, 0xFF20, 206, 265, 360},
    {0xFF21, 0xFF3A, 206, 266, 367},
    {0xFF3B, 0xFF3E, 206, 265, 360},
    {0xFF3F, 0xFF3F, 206, 265, 372},
    {0xFF40, 0xFF40, 206, 265, 360},
    {0xFF41, 0xFF5A, 206, 266, 367},
    {0xFF5B, 0xFF65, 206, 265, 360},
    {0xFF66, 0xFF6F, 206, 298, 366},
    {0xFF70, 0xFF70, 206, 265, 366},
    {0xFF71, 0xFF9D, 206, 298, 366},
    {0xFF9E, 0xFF9F, 206, 265, 364},
    {0xFFA0, 0xFFBE, 206, 289, 367},
    {0xFFBF, 0xFFC1, 206, 264, 360},
    {0xFFC2, 0xFFC7, 206, 289, 367},
    {0xFFC8, 0xFFC9, 206, 264, 360},
    {0xFFCA, 0xFFCF, 206, 289, 367},
    {0xFFD0, 0xFFD1, 206, 264, 360},
    {0xFFD2, 0xFFD7, 206, 289, 367},
    {0xFFD8, 0xFFD9, 206, 264, 360},
    {0xFFDA, 0xFFDC, 206, 289, 367},
    {0xFFDD, 0xFFDF, 206, 264, 360},
    {0xFFE0, 0xFFE6, 206, 265, 360},
    {0xFFE7, 0xFFE7, 206, 264, 360},
    {0xFFE8, 0xFFEE, 206, 265, 360},
    {0xFFEF, 0xFFEF, 206, 264, 360},
    {0xFFF0, 0xFFF8, 207, 264, 360},
    {0xFFF9, 0xFFFB, 207, 265, 365},
    {0xFFFC, 0xFFFD, 207, 265, 360},
    {0xFFFE, 0xFFFF, 207, 264, 360},
    {0x10000, 0x1000B, 208, 312, 367},
    {0x1000C, 0x1000C, 208, 264, 360},
    {0x1000D, 0x10026, 208, 312, 367},
    {0x10027, 0x10027, 208, 264, 360},
    {0x10028, 0x1003A, 208, 312, 367},
    {0x1003B, 0x1003B, 208, 264, 360},
    {0x1003C, 0x1003D, 208, 312, 367},
    {0x1003E, 0x1003E, 208, 264, 360},
    {0x1003F, 0x1004D, 208, 312, 367},
    {0x1004E, 0x1004F, 208, 264, 360},
    {0x10050, 0x1005D, 208, 312, 367},
    {0x1005E, 0x1007F, 208, 264, 360},
    {0x10080, 0x100FA, 209, 312, 367},
    {0x100FB, 0x100FF, 209, 264, 360},
    {0x10100, 0x10102, 210, 265, 360},
    {0x10103, 0x10106, 210, 264, 360},
    {0x10107, 0x10133, 210, 265, 360},
    {0x10134, 0x10136, 210, 264, 360},
    {0x10137, 0x1013F, 210, 265, 360},
    {0x10140, 0x10174, 211, 267, 367},
    {0x10175, 0x1018A, 211, 267, 360},
    {0x1018B, 0x1018F, 211, 264, 360},
    {0x10190, 0x1019B, 212, 265, 360},
    {0x1019C, 0x101CF, 212, 264, 360},
    {0x101D0, 0x101FC, 213, 265, 360},
    {0x101FD, 0x101FD, 213, 305, 364},
    {0x101FE, 0x101FF, 213, 264, 360},
    {0x10200, 0x1027F, 54, 264, 360},
    {0x10280, 0x1029C, 214, 338, 367},
    {0x1029D, 0x1029F, 214, 264, 360},
    {0x102A0, 0x102D0, 215, 339, 367},
    {0x102D1, 0x102DF, 215, 264, 360},
    {0x102E0, 0x102FF, 54, 264, 360},
    {0x10300, 0x1031E, 216, 302, 367},
    {0x1031F, 0x1031F, 216, 264, 360},
    {0x10320, 0x10323, 216, 302, 360},
    {0x10324, 0x1032F, 216, 264, 360},
    {0x10330, 0x1034A, 217, 303, 367},
    {0x1034B, 0x1034F, 217, 264, 360},
    {0x10350, 0x1037F, 54, 264, 360},
    {0x10380, 0x1039D, 218, 313, 367},
    {0x1039E, 0x1039E, 218, 264, 360},
    {0x1039F, 0x1039F, 218, 313, 360},
    {0x103A0, 0x103C3, 219, 324, 367},
    {0x103C4, 0x103C7, 219, 264, 360},
    {0x103C8, 0x103CF, 219, 324, 367},
    {0x103D0, 0x103D0, 219, 324, 360},
    {0x103D1, 0x103D5, 219, 324, 367},
    {0x103D6, 0x103DF, 219, 264, 360},
    {0x103E0, 0x103FF, 54, 264, 360},
    {0x10400, 0x1044F, 220, 304, 367},
    {0x10450, 0x1047F, 221, 314, 367},
    {0x10480, 0x1049D, 222, 315, 367},
    {0x1049E, 0x1049F, 222, 264, 360},
    {0x104A0, 0x104A9, 222, 315, 371},
    {0x104AA, 0x104AF, 222, 264, 360},
    {0x104B0, 0x107FF, 54, 264, 360},
    {0x10800, 0x10805, 223, 316, 367},
    {0x10806, 0x10807, 223, 264, 360},
    {0x10808, 0x10808, 223, 316, 367},
    {0x10809, 0x10809, 223, 264, 360},
    {0x1080A, 0x10835, 223, 316, 367},
    {0x10836, 0x10836, 223, 264, 360},
    {0x10837, 0x10838, 223, 316, 367},
    {0x10839, 0x1083B, 223, 264, 360},
    {0x1083C, 0x1083C, 223, 316, 367},
    {0x1083D, 0x1083E, 223, 264, 360},
    {0x1083F, 0x1083F, 223, 316, 367},
    {0x10840, 0x10855, 224, 351, 367},
    {0x10856, 0x10856, 224, 264, 360},
    {0x10857, 0x1085F, 224, 351, 360},
    {0x10860, 0x108FF, 54, 264, 360},
    {0x10900, 0x10915, 225, 328, 367},
    {0x10916, 0x1091B, 225, 328, 360},
    {0x1091C, 0x1091E, 225, 264, 360},
    {0x1091F, 0x1091F, 225, 328, 360},
    {0x10920, 0x10939, 226, 340, 367},
    {0x1093A, 0x1093E, 226, 264, 360},
    {0x1093F, 0x1093F, 226, 340, 360},
    {0x10940, 0x109FF, 54, 264, 360},
    {0x10A00, 0x10A00, 227, 325, 367},
    {0x10A01, 0x10A03, 227, 325, 364},
    {0x10A04, 0x10A04, 227, 264, 360},
    {0x10A05, 0x10A06, 227, 325, 364},
    {0x10A07, 0x10A0B, 227, 264, 360},
    {0x10A0C, 0x10A0F, 227, 325, 364},
    {0x10A10, 0x10A13, 227, 325, 367},
    {0x10A14, 0x10A14, 227, 264, 360},
    {0x10A15, 0x10A17, 227, 325, 367},
    {0x10A18, 0x10A18, 227, 264, 360},
    {0x10A19, 0x10A33, 227, 325, 367},
    {0x10A34, 0x10A37, 227, 264, 360},
    {0x10A38, 0x10A3A, 227, 325, 364},
    {0x10A3B, 0x10A3E, 227, 264, 360},
    {0x10A3F, 0x10A3F, 227, 325, 364},
    {0x10A40, 0x10A47, 227, 325, 360},
    {0x10A48, 0x10A4F, 227, 264, 360},
    {0x10A50, 0x10A58, 227, 325, 360},
    {0x10A59, 0x10A5F, 227, 264, 360},
    {0x10A60, 0x10A7C, 228, 352, 367},
    {0x10A7D, 0x10A7F, 228, 352, 360},
    {0x10A80, 0x10AFF, 54, 264, 360},
    {0x10B00, 0x10B35, 229, 344, 367},
    {0x10B36, 0x10B38, 229, 264, 360},
    {0x10B39, 0x10B3F, 229, 344, 360},
    {0x10B40, 0x10B55, 230, 353, 367},
    {0x10B56, 0x10B57, 230, 264, 360},
    {0x10B58, 0x10B5F, 230, 353, 360},
    {0x10B60, 0x10B72, 231, 354, 367},
    {0x10B73, 0x10B77, 231, 264, 360},
    {0x10B78, 0x10B7F, 231, 354, 360},
    {0x10B80, 0x10BFF, 54, 264, 360},
    {0x10C00, 0x10C48, 232, 355, 367},
    {0x10C49, 0x10C4F, 232, 264, 360},
    {0x10C50, 0x10E5F, 54, 264, 360},
    {0x10E60, 0x10E7E, 233, 271, 360},
    {0x10E7F, 0x10E7F, 233, 264, 360},
    {0x10E80, 0x10FFF, 54, 264, 360},
    {0x11000, 0x11002, 234, 358, 364},
    {0x11003, 0x11037, 234, 358, 367},
    {0x11038, 0x11046, 234, 358, 364},
    {0x11047, 0x1104D, 234, 358, 360},
    {0x1104E, 0x11051, 234, 264, 360},
    {0x11052, 0x11065, 234, 358, 360},
    {0x11066, 0x1106F, 234, 358, 371},
    {0x11070, 0x1107F, 234, 264, 360},
    {0x11080, 0x11082, 235, 356, 364},
    {0x11083, 0x110AF, 235, 356, 367},
    {0x110B0, 0x110BA, 235, 356, 364},
    {0x110BB, 0x110BC, 235, 356, 360},
    {0x110BD, 0x110BD, 235, 356, 365},
    {0x110BE, 0x110C1, 235, 356, 360},
    {0x110C2, 0x110CF, 235, 264, 360},
    {0x110D0, 0x11FFF, 54, 264, 360},
    {0x12000, 0x1236E, 236, 327, 367},
    {0x1236F, 0x123FF, 236, 264, 360},
    {0x12400, 0x12462, 237, 327, 367},
    {0x12463, 0x1246F, 237, 264, 360},
    {0x12470, 0x12473, 237, 327, 360},
    {0x12474, 0x1247F, 237, 264, 360},
    {0x12480, 0x12FFF, 54, 264, 360},
    {0x13000, 0x1342E, 238, 345, 367},
    {0x1342F, 0x1342F, 238, 264, 360},
    {0x13430, 0x167FF, 54, 264, 360},
    {0x16800, 0x16A38, 239, 348, 367},
    {0x16A39, 0x16A3F, 239, 264, 360},
    {0x16A40, 0x1AFFF, 54, 264, 360},
    {0x1B000, 0x1B000, 240, 298, 366},
    {0x1B001, 0x1B001, 240, 297, 360},
    {0x1B002, 0x1B0FF, 240, 264, 360},
    {0x1B100, 0x1CFFF, 54, 264, 360},
    {0x1D000, 0x1D0F5, 241, 265, 360},
    {0x1D0F6, 0x1D0FF, 241, 264, 360},
    {0x1D100, 0x1D126, 242, 265, 360},
    {0x1D127, 0x1D128, 242, 264, 360},
    {0x1D129, 0x1D164, 242, 265, 360},
    {0x1D165, 0x1D166, 242, 265, 364},
    {0x1D167, 0x1D169, 242, 305, 364},
    {0x1D16A, 0x1D16C, 242, 265, 360},
    {0x1D16D, 0x1D172, 242, 265, 364},
    {0x1D173, 0x1D17A, 242, 265, 365},
    {0x1D17B, 0x1D182, 242, 305, 364},
    {0x1D183, 0x1D184, 242, 265, 360},
    {0x1D185, 0x1D18B, 242, 305, 364},
    {0x1D18C, 0x1D1A9, 242, 265, 360},
    {0x1D1AA, 0x1D1AD, 242, 305, 364},
    {0x1D1AE, 0x1D1DD, 242, 265, 360},
    {0x1D1DE, 0x1D1FF, 242, 264, 360},
    {0x1D200, 0x1D241, 243, 267, 360},
    {0x1D242, 0x1D244, 243, 267, 364},
    {0x1D245, 0x1D245, 243, 267, 360},
    {0x1D246, 0x1D24F, 243, 264, 360},
    {0x1D250, 0x1D2FF, 54, 264, 360},
    {0x1D300, 0x1D356, 244, 265, 360},
    {0x1D357, 0x1D35F, 244, 264, 360},
    {0x1D360, 0x1D371, 245, 265, 360},
    {0x1D372, 0x1D37F, 245, 264, 360},
    {0x1D380, 0x1D3FF, 54, 264, 360},
    {0x1D400, 0x1D454, 246, 265, 367},
    {0x1D455, 0x1D455, 246, 264, 360},
    {0x1D456, 0x1D49C, 246, 265, 367},
    {0x1D49D, 0x1D49D, 246, 264, 360},
    {0x1D49E, 0x1D49F, 246, 265, 367},
    {0x1D4A0, 0x1D4A1, 246, 264, 360},
    {0x1D4A2, 0x1D4A2, 246, 265, 367},
    {0x1D4A3, 0x1D4A4, 246, 264, 360},
    {0x1D4A5, 0x1D4A6, 246, 265, 367},
    {0x1D4A7, 0x1D4A8, 246, 264, 360},
    {0x1D4A9, 0x1D4AC, 246, 265, 367},
    {0x1D4AD, 0x1D4AD, 246, 264, 360},
    {0x1D4AE, 0x1D4B9, 246, 265, 367},
    {0x1D4BA, 0x1D4BA, 246, 264, 360},
    {0x1D4BB, 0x1D4BB, 246, 265, 367},
    {0x1D4BC, 0x1D4BC, 246, 264, 360},
    {0x1D4BD, 0x1D4C3, 246, 265, 367},
    {0x1D4C4, 0x1D4C4, 246, 264, 360},
    {0x1D4C5, 0x1D505, 246, 265, 367},
    {0x1D506, 0x1D506, 246, 264, 360},
    {0x1D507, 0x1D50A, 246, 265, 367},
    {0x1D50B, 0x1D50C, 246, 264, 360},
    {0x1D50D, 0x1D514, 246, 265, 367},
    {0x1D515, 0x1D515, 246, 264, 360},
    {0x1D516, 0x1D51C, 246, 265, 367},
    {0x1D51D, 0x1D51D, 246, 264, 360},
    {0x1D51E, 0x1D539, 246, 265, 367},
    {0x1D53A, 0x1D53A, 246, 264, 360},
    {0x1D53B, 0x1D53E, 246, 265, 367},
    {0x1D53F, 0x1D53F, 246, 264, 360},
    {0x1D540, 0x1D544, 246, 265, 367},
    {0x1D545, 0x1D545, 246, 264, 360},
    {0x1D546, 0x1D546, 246, 265, 367},
    {0x1D547, 0x1D549, 246, 264, 360},
    {0x1D54A, 0x1D550, 246, 265, 367},
    {0x1D551, 0x1D551, 246, 264, 360},
    {0x1D552, 0x1D6A5, 246, 265, 367},
    {0x1D6A6, 0x1D6A7, 246, 264, 360},
    {0x1D6A8, 0x1D6C0, 246, 265, 367},
    {0x1D6C1, 0x1D6C1, 246, 265, 360},
    {0x1D6C2, 0x1D6DA, 246, 265, 367},
    {0x1D6DB, 0x1D6DB, 246, 265, 360},
    {0x1D6DC, 0x1D6FA, 246, 265, 367},
    {0x1D6FB, 0x1D6FB, 246, 265, 360},
    {0x1D6FC, 0x1D714, 246, 265, 367},
    {0x1D715, 0x1D715, 246, 265, 360},
    {0x1D716, 0x1D734, 246, 265, 367},
    {0x1D735, 0x1D735, 246, 265, 360},
    {0x1D736, 0x1D74E, 246, 265, 367},
    {0x1D74F, 0x1D74F, 246, 265, 360},
    {0x1D750, 0x1D76E, 246, 265, 367},
    {0x1D76F, 0x1D76F, 246, 265, 360},
    {0x1D770, 0x1D788, 246, 265, 367},
    {0x1D789, 0x1D789, 246, 265, 360},
    {0x1D78A, 0x1D7A8, 246, 265, 367},
    {0x1D7A9, 0x1D7A9, 246, 265, 360},
    {0x1D7AA, 0x1D7C2, 246, 265, 367},
    {0x1D7C3, 0x1D7C3, 246, 265, 360},
    {0x1D7C4, 0x1D7CB, 246, 265, 367},
    {0x1D7CC, 0x1D7CD, 246, 264, 360},
    {0x1D7CE, 0x1D7FF, 246, 265, 371},
    {0x1D800, 0x1EFFF, 54, 264, 360},
    {0x1F000, 0x1F02B, 247, 265, 360},
    {0x1F02C, 0x1F02F, 247, 264, 360},
    {0x1F030, 0x1F093, 248, 265, 360},
    {0x1F094, 0x1F09F, 248, 264, 360},
    {0x1F0A0, 0x1F0AE, 249, 265, 360},
    {0x1F0AF, 0x1F0B0, 249, 264, 360},
    {0x1F0B1, 0x1F0BE, 249, 265, 360},
    {0x1F0BF, 0x1F0C0, 249, 264, 360},
    {0x1F0C1, 0x1F0CF, 249, 265, 360},
    {0x1F0D0, 0x1F0D0, 249, 264, 360},
    {0x1F0D1, 0x1F0DF, 249, 265, 360},
    {0x1F0E0, 0x1F0FF, 249, 264, 360},
    {0x1F100, 0x1F10A, 250, 265, 360},
    {0x1F10B, 0x1F10F, 250, 264, 360},
    {0x1F110, 0x1F12E, 250, 265, 360},
    {0x1F12F, 0x1F12F, 250, 264, 360},
    {0x1F130, 0x1F169, 250, 265, 360},
    {0x1F16A, 0x1F16F, 250, 264, 360},
    {0x1F170, 0x1F19A, 250, 265, 360},
    {0x1F19B, 0x1F1E5, 250, 264, 360},
    {0x1F1E6, 0x1F1FF, 250, 265, 360},
    {0x1F200, 0x1F200, 251, 297, 360},
    {0x1F201, 0x1F202, 251, 265, 360},
    {0x1F203, 0x1F20F, 251, 264, 360},
    {0x1F210, 0x1F23A, 251, 265, 360},
    {0x1F23B, 0x1F23F, 251, 264, 360},
    {0x1F240, 0x1F248, 251, 265, 360},
    {0x1F249, 0x1F24F, 251, 264, 360},
    {0x1F250, 0x1F251, 251, 265, 360},
    {0x1F252, 0x1F2FF, 251, 264, 360},
    {0x1F300, 0x1F320, 252, 265, 360},
    {0x1F321, 0x1F32F, 252, 264, 360},
    {0x1F330, 0x1F335, 252, 265, 360},
    {0x1F336, 0x1F336, 252, 264, 360},
    {0x1F337, 0x1F37C, 252, 265, 360},
    {0x1F37D, 0x1F37F, 252, 264, 360},
    {0x1F380, 0x1F393, 252, 265, 360},
    {0x1F394, 0x1F39F, 252, 264, 360},
    {0x1F3A0, 0x1F3C4, 252, 265, 360},
    {0x1F3C5, 0x1F3C5, 252, 264, 360},
    {0x1F3C6, 0x1F3CA, 252, 265, 360},
    {0x1F3CB, 0x1F3DF, 252, 264, 360},
    {0x1F3E0, 0x1F3F0, 252, 265, 360},
    {0x1F3F1, 0x1F3FF, 252, 264, 360},
    {0x1F400, 0x1F43E, 252, 265, 360},
    {0x1F43F, 0x1F43F, 252, 264, 360},
    {0x1F440, 0x1F440, 252, 265, 360},
    {0x1F441, 0x1F441, 252, 264, 360},
    {0x1F442, 0x1F4F7, 252, 265, 360},
    {0x1F4F8, 0x1F4F8, 252, 264, 360},
    {0x1F4F9, 0x1F4FC, 252, 265, 360},
    {0x1F4FD, 0x1F4FF, 252, 264, 360},
    {0x1F500, 0x1F53D, 252, 265, 360},
    {0x1F53E, 0x1F54F, 252, 264, 360},
    {0x1F550, 0x1F567, 252, 265, 360},
    {0x1F568, 0x1F5FA, 252, 264, 360},
    {0x1F5FB, 0x1F5FF, 252, 265, 360},
    {0x1F600, 0x1F600, 253, 264, 360},
    {0x1F601, 0x1F610, 253, 265, 360},
    {0x1F611, 0x1F611, 253, 264, 360},
    {0x1F612, 0x1F614, 253, 265, 360},
    {0x1F615, 0x1F615, 253, 264, 360},
    {0x1F616, 0x1F616, 253, 265, 360},
    {0x1F617, 0x1F617, 253, 264, 360},
    {0x1F618, 0x1F618, 253, 265, 360},
    {0x1F619, 0x1F619, 253, 264, 360},
    {0x1F61A, 0x1F61A, 253, 265, 360},
    {0x1F61B, 0x1F61B, 253, 264, 360},
    {0x1F61C, 0x1F61E, 253, 265, 360},
    {0x1F61F, 0x1F61F, 253, 264, 360},
    {0x1F620, 0x1F625, 253, 265, 360},
    {0x1F626, 0x1F627, 253, 264, 360},
    {0x1F628, 0x1F62B, 253, 265, 360},
    {0x1F62C, 0x1F62C, 253, 264, 360},
    {0x1F62D, 0x1F62D, 253, 265, 360},
    {0x1F62E, 0x1F62F, 253, 264, 360},
    {0x1F630, 0x1F633, 253, 265, 360},
    {0x1F634, 0x1F634, 253, 264, 360},
    {0x1F635, 0x1F640, 253, 265, 360},
    {0x1F641, 0x1F644, 253, 264, 360},
    {0x1F645, 0x1F64F, 253, 265, 360},
    {0x1F650, 0x1F67F, 54, 264, 360},
    {0x1F680, 0x1F6C5, 254, 265, 360},
    {0x1F6C6, 0x1F6FF, 254, 264, 360},
    {0x1F700, 0x1F773, 255, 265, 360},
    {0x1F774, 0x1F77F, 255, 264, 360},
    {0x1F780, 0x1FFFF, 54, 264, 360},
    {0x20000, 0x2A6D6, 256, 300, 360},
    {0x2A6D7, 0x2A6DF, 256, 264, 360},
    {0x2A6E0, 0x2A6FF, 54, 264, 360},
    {0x2A700, 0x2B734, 257, 300, 360},
    {0x2B735, 0x2B73F, 257, 264, 360},
    {0x2B740, 0x2B81D, 258, 300, 360},
    {0x2B81E, 0x2B81F, 258, 264, 360},
    {0x2B820, 0x2F7FF, 54, 264, 360},
    {0x2F800, 0x2FA1D, 259, 300, 360},
    {0x2FA1E, 0x2FA1F, 259, 264, 360},
    {0x2FA20, 0xDFFFF, 54, 264, 360},
    {0xE0000, 0xE0000, 260, 264, 360},
    {0xE0001, 0xE0001, 260, 265, 365},
    {0xE0002, 0xE001F, 260, 264, 360},
    {0xE0020, 0xE007F, 260, 265, 365},
    {0xE0080, 0xE00FF, 54, 264, 360},
    {0xE0100, 0xE01EF, 261, 305, 364},
    {0xE01F0, 0xEFFFF, 54, 264, 360},
    {0xF0000, 0xFFFFF, 262, 264, 360},
    {0x100000, 0x10FFFF, 263, 264, 360},
};

/* The codepoint case ranges table. */
RE_CaseRange re_codepoint_case_ranges[] = {
    {0x41, 0x5A, -65},
    {0x61, 0x7A, -71},
    {0xB5, 0xB5, -129},
    {0xC0, 0xD6, -139},
    {0xD8, 0xF6, -140},
    {0xF8, 0x137, -141},
    {0x139, 0x148, -142},
    {0x14A, 0x18C, -143},
    {0x18E, 0x19A, -144},
    {0x19C, 0x1A9, -145},
    {0x1AC, 0x1B9, -147},
    {0x1BC, 0x1BD, -149},
    {0x1BF, 0x1BF, -150},
    {0x1C4, 0x1EF, -154},
    {0x1F1, 0x220, -155},
    {0x222, 0x233, -156},
    {0x23A, 0x254, -162},
    {0x256, 0x257, -163},
    {0x259, 0x259, -164},
    {0x25B, 0x25B, -165},
    {0x260, 0x260, -169},
    {0x263, 0x263, -171},
    {0x265, 0x265, -172},
    {0x268, 0x269, -174},
    {0x26B, 0x26B, -175},
    {0x26F, 0x26F, -178},
    {0x271, 0x272, -179},
    {0x275, 0x275, -181},
    {0x27D, 0x27D, -188},
    {0x280, 0x280, -190},
    {0x283, 0x283, -192},
    {0x288, 0x28C, -196},
    {0x292, 0x292, -201},
    {0x345, 0x345, -379},
    {0x370, 0x373, -421},
    {0x376, 0x377, -423},
    {0x37B, 0x37D, -426},
    {0x386, 0x386, -434},
    {0x388, 0x38A, -435},
    {0x38C, 0x38C, -436},
    {0x38E, 0x38F, -437},
    {0x391, 0x3A1, -438},
    {0x3A3, 0x3AF, -439},
    {0x3B1, 0x3D1, -440},
    {0x3D5, 0x3F2, -443},
    {0x3F4, 0x3F5, -444},
    {0x3F7, 0x3FB, -445},
    {0x3FD, 0x481, -446},
    {0x48A, 0x527, -454},
    {0x531, 0x556, -463},
    {0x561, 0x586, -473},
    {0x10A0, 0x10C5, -3314},
    {0x1D79, 0x1D79, -6565},
    {0x1D7D, 0x1D7D, -6568},
    {0x1E00, 0x1E95, -6698},
    {0x1E9B, 0x1E9B, -6703},
    {0x1E9E, 0x1E9E, -6705},
    {0x1EA0, 0x1F15, -6706},
    {0x1F18, 0x1F1D, -6708},
    {0x1F20, 0x1F45, -6710},
    {0x1F48, 0x1F4D, -6712},
    {0x1F51, 0x1F51, -6715},
    {0x1F53, 0x1F53, -6716},
    {0x1F55, 0x1F55, -6717},
    {0x1F57, 0x1F57, -6718},
    {0x1F59, 0x1F59, -6719},
    {0x1F5B, 0x1F5B, -6720},
    {0x1F5D, 0x1F5D, -6721},
    {0x1F5F, 0x1F7D, -6722},
    {0x1F80, 0x1FB1, -6724},
    {0x1FB3, 0x1FB3, -6725},
    {0x1FB8, 0x1FBC, -6729},
    {0x1FBE, 0x1FBE, -6730},
    {0x1FC3, 0x1FC3, -6734},
    {0x1FC8, 0x1FCC, -6738},
    {0x1FD0, 0x1FD1, -6741},
    {0x1FD8, 0x1FDB, -6747},
    {0x1FE0, 0x1FE1, -6751},
    {0x1FE5, 0x1FE5, -6754},
    {0x1FE8, 0x1FEC, -6756},
    {0x1FF3, 0x1FF3, -6762},
    {0x1FF8, 0x1FFC, -6766},
    {0x2126, 0x2126, -7063},
    {0x212A, 0x212B, -7066},
    {0x2132, 0x2132, -7072},
    {0x214E, 0x214E, -7099},
    {0x2160, 0x217F, -7116},
    {0x2183, 0x2184, -7119},
    {0x24B6, 0x24E9, -7936},
    {0x2C00, 0x2C2E, -9750},
    {0x2C30, 0x2C5E, -9751},
    {0x2C60, 0x2C70, -9752},
    {0x2C72, 0x2C73, -9753},
    {0x2C75, 0x2C76, -9754},
    {0x2C7E, 0x2CE3, -9761},
    {0x2CEB, 0x2CEE, -9768},
    {0x2D00, 0x2D25, -9785},
    {0xA640, 0xA66D, -40787},
    {0xA680, 0xA697, -40805},
    {0xA722, 0xA72F, -40943},
    {0xA732, 0xA76F, -40945},
    {0xA779, 0xA787, -40954},
    {0xA78B, 0xA78D, -40957},
    {0xA790, 0xA791, -40959},
    {0xA7A0, 0xA7A9, -40973},
    {0xFF21, 0xFF3A, -63364},
    {0xFF41, 0xFF5A, -63370},
    {0x10400, 0x1044F, -64559},
};

/* The codepoint cases table. */
RE_Case re_codepoint_cases[] = {
    {0x61, 0x41, 0x41},
    {0x62, 0x42, 0x42},
    {0x63, 0x43, 0x43},
    {0x64, 0x44, 0x44},
    {0x65, 0x45, 0x45},
    {0x66, 0x46, 0x46},
    {0x67, 0x47, 0x47},
    {0x68, 0x48, 0x48},
    {0x69, 0x131, 0x49},
    {0x6A, 0x4A, 0x4A},
    {0x6B, 0x4B, 0x4B},
    {0x6C, 0x4C, 0x4C},
    {0x6D, 0x4D, 0x4D},
    {0x6E, 0x4E, 0x4E},
    {0x6F, 0x4F, 0x4F},
    {0x70, 0x50, 0x50},
    {0x71, 0x51, 0x51},
    {0x72, 0x52, 0x52},
    {0x73, 0x17F, 0x53},
    {0x74, 0x54, 0x54},
    {0x75, 0x55, 0x55},
    {0x76, 0x56, 0x56},
    {0x77, 0x57, 0x57},
    {0x78, 0x58, 0x58},
    {0x79, 0x59, 0x59},
    {0x7A, 0x5A, 0x5A},
    {0x41, 0x61, 0x61},
    {0x42, 0x62, 0x62},
    {0x43, 0x63, 0x63},
    {0x44, 0x64, 0x64},
    {0x45, 0x65, 0x65},
    {0x46, 0x66, 0x66},
    {0x47, 0x67, 0x67},
    {0x48, 0x68, 0x68},
    {0x49, 0x130, 0x69},
    {0x4A, 0x6A, 0x6A},
    {0x4B, 0x212A, 0x6B},
    {0x4C, 0x6C, 0x6C},
    {0x4D, 0x6D, 0x6D},
    {0x4E, 0x6E, 0x6E},
    {0x4F, 0x6F, 0x6F},
    {0x50, 0x70, 0x70},
    {0x51, 0x71, 0x71},
    {0x52, 0x72, 0x72},
    {0x53, 0x73, 0x73},
    {0x54, 0x74, 0x74},
    {0x55, 0x75, 0x75},
    {0x56, 0x76, 0x76},
    {0x57, 0x77, 0x77},
    {0x58, 0x78, 0x78},
    {0x59, 0x79, 0x79},
    {0x5A, 0x7A, 0x7A},
    {0x39C, 0xB5, 0xB5},
    {0xE0, 0xC0, 0xC0},
    {0xE1, 0xC1, 0xC1},
    {0xE2, 0xC2, 0xC2},
    {0xE3, 0xC3, 0xC3},
    {0xE4, 0xC4, 0xC4},
    {0xE5, 0xC5, 0xC5},
    {0xE6, 0xC6, 0xC6},
    {0xE7, 0xC7, 0xC7},
    {0xE8, 0xC8, 0xC8},
    {0xE9, 0xC9, 0xC9},
    {0xEA, 0xCA, 0xCA},
    {0xEB, 0xCB, 0xCB},
    {0xEC, 0xCC, 0xCC},
    {0xED, 0xCD, 0xCD},
    {0xEE, 0xCE, 0xCE},
    {0xEF, 0xCF, 0xCF},
    {0xF0, 0xD0, 0xD0},
    {0xF1, 0xD1, 0xD1},
    {0xF2, 0xD2, 0xD2},
    {0xF3, 0xD3, 0xD3},
    {0xF4, 0xD4, 0xD4},
    {0xF5, 0xD5, 0xD5},
    {0xF6, 0xD6, 0xD6},
    {0xF8, 0xD8, 0xD8},
    {0xF9, 0xD9, 0xD9},
    {0xFA, 0xDA, 0xDA},
    {0xFB, 0xDB, 0xDB},
    {0xFC, 0xDC, 0xDC},
    {0xFD, 0xDD, 0xDD},
    {0xFE, 0xDE, 0xDE},
    {0x1E9E, 0xDF, 0xDF},
    {0xC0, 0xE0, 0xE0},
    {0xC1, 0xE1, 0xE1},
    {0xC2, 0xE2, 0xE2},
    {0xC3, 0xE3, 0xE3},
    {0xC4, 0xE4, 0xE4},
    {0xC5, 0x212B, 0xE5},
    {0xC6, 0xE6, 0xE6},
    {0xC7, 0xE7, 0xE7},
    {0xC8, 0xE8, 0xE8},
    {0xC9, 0xE9, 0xE9},
    {0xCA, 0xEA, 0xEA},
    {0xCB, 0xEB, 0xEB},
    {0xCC, 0xEC, 0xEC},
    {0xCD, 0xED, 0xED},
    {0xCE, 0xEE, 0xEE},
    {0xCF, 0xEF, 0xEF},
    {0xD0, 0xF0, 0xF0},
    {0xD1, 0xF1, 0xF1},
    {0xD2, 0xF2, 0xF2},
    {0xD3, 0xF3, 0xF3},
    {0xD4, 0xF4, 0xF4},
    {0xD5, 0xF5, 0xF5},
    {0xD6, 0xF6, 0xF6},
    {0xD8, 0xF8, 0xF8},
    {0xD9, 0xF9, 0xF9},
    {0xDA, 0xFA, 0xFA},
    {0xDB, 0xFB, 0xFB},
    {0xDC, 0xFC, 0xFC},
    {0xDD, 0xFD, 0xFD},
    {0xDE, 0xFE, 0xFE},
    {0x178, 0xFF, 0xFF},
    {0x101, 0x100, 0x100},
    {0x100, 0x101, 0x101},
    {0x103, 0x102, 0x102},
    {0x102, 0x103, 0x103},
    {0x105, 0x104, 0x104},
    {0x104, 0x105, 0x105},
    {0x107, 0x106, 0x106},
    {0x106, 0x107, 0x107},
    {0x109, 0x108, 0x108},
    {0x108, 0x109, 0x109},
    {0x10B, 0x10A, 0x10A},
    {0x10A, 0x10B, 0x10B},
    {0x10D, 0x10C, 0x10C},
    {0x10C, 0x10D, 0x10D},
    {0x10F, 0x10E, 0x10E},
    {0x10E, 0x10F, 0x10F},
    {0x111, 0x110, 0x110},
    {0x110, 0x111, 0x111},
    {0x113, 0x112, 0x112},
    {0x112, 0x113, 0x113},
    {0x115, 0x114, 0x114},
    {0x114, 0x115, 0x115},
    {0x117, 0x116, 0x116},
    {0x116, 0x117, 0x117},
    {0x119, 0x118, 0x118},
    {0x118, 0x119, 0x119},
    {0x11B, 0x11A, 0x11A},
    {0x11A, 0x11B, 0x11B},
    {0x11D, 0x11C, 0x11C},
    {0x11C, 0x11D, 0x11D},
    {0x11F, 0x11E, 0x11E},
    {0x11E, 0x11F, 0x11F},
    {0x121, 0x120, 0x120},
    {0x120, 0x121, 0x121},
    {0x123, 0x122, 0x122},
    {0x122, 0x123, 0x123},
    {0x125, 0x124, 0x124},
    {0x124, 0x125, 0x125},
    {0x127, 0x126, 0x126},
    {0x126, 0x127, 0x127},
    {0x129, 0x128, 0x128},
    {0x128, 0x129, 0x129},
    {0x12B, 0x12A, 0x12A},
    {0x12A, 0x12B, 0x12B},
    {0x12D, 0x12C, 0x12C},
    {0x12C, 0x12D, 0x12D},
    {0x12F, 0x12E, 0x12E},
    {0x12E, 0x12F, 0x12F},
    {0x69, 0x130, 0x130},
    {0x49, 0x131, 0x131},
    {0x133, 0x132, 0x132},
    {0x132, 0x133, 0x133},
    {0x135, 0x134, 0x134},
    {0x134, 0x135, 0x135},
    {0x137, 0x136, 0x136},
    {0x136, 0x137, 0x137},
    {0x13A, 0x139, 0x139},
    {0x139, 0x13A, 0x13A},
    {0x13C, 0x13B, 0x13B},
    {0x13B, 0x13C, 0x13C},
    {0x13E, 0x13D, 0x13D},
    {0x13D, 0x13E, 0x13E},
    {0x140, 0x13F, 0x13F},
    {0x13F, 0x140, 0x140},
    {0x142, 0x141, 0x141},
    {0x141, 0x142, 0x142},
    {0x144, 0x143, 0x143},
    {0x143, 0x144, 0x144},
    {0x146, 0x145, 0x145},
    {0x145, 0x146, 0x146},
    {0x148, 0x147, 0x147},
    {0x147, 0x148, 0x148},
    {0x14B, 0x14A, 0x14A},
    {0x14A, 0x14B, 0x14B},
    {0x14D, 0x14C, 0x14C},
    {0x14C, 0x14D, 0x14D},
    {0x14F, 0x14E, 0x14E},
    {0x14E, 0x14F, 0x14F},
    {0x151, 0x150, 0x150},
    {0x150, 0x151, 0x151},
    {0x153, 0x152, 0x152},
    {0x152, 0x153, 0x153},
    {0x155, 0x154, 0x154},
    {0x154, 0x155, 0x155},
    {0x157, 0x156, 0x156},
    {0x156, 0x157, 0x157},
    {0x159, 0x158, 0x158},
    {0x158, 0x159, 0x159},
    {0x15B, 0x15A, 0x15A},
    {0x15A, 0x15B, 0x15B},
    {0x15D, 0x15C, 0x15C},
    {0x15C, 0x15D, 0x15D},
    {0x15F, 0x15E, 0x15E},
    {0x15E, 0x15F, 0x15F},
    {0x161, 0x160, 0x160},
    {0x160, 0x161, 0x161},
    {0x163, 0x162, 0x162},
    {0x162, 0x163, 0x163},
    {0x165, 0x164, 0x164},
    {0x164, 0x165, 0x165},
    {0x167, 0x166, 0x166},
    {0x166, 0x167, 0x167},
    {0x169, 0x168, 0x168},
    {0x168, 0x169, 0x169},
    {0x16B, 0x16A, 0x16A},
    {0x16A, 0x16B, 0x16B},
    {0x16D, 0x16C, 0x16C},
    {0x16C, 0x16D, 0x16D},
    {0x16F, 0x16E, 0x16E},
    {0x16E, 0x16F, 0x16F},
    {0x171, 0x170, 0x170},
    {0x170, 0x171, 0x171},
    {0x173, 0x172, 0x172},
    {0x172, 0x173, 0x173},
    {0x175, 0x174, 0x174},
    {0x174, 0x175, 0x175},
    {0x177, 0x176, 0x176},
    {0x176, 0x177, 0x177},
    {0xFF, 0x178, 0x178},
    {0x17A, 0x179, 0x179},
    {0x179, 0x17A, 0x17A},
    {0x17C, 0x17B, 0x17B},
    {0x17B, 0x17C, 0x17C},
    {0x17E, 0x17D, 0x17D},
    {0x17D, 0x17E, 0x17E},
    {0x53, 0x17F, 0x17F},
    {0x243, 0x180, 0x180},
    {0x253, 0x181, 0x181},
    {0x183, 0x182, 0x182},
    {0x182, 0x183, 0x183},
    {0x185, 0x184, 0x184},
    {0x184, 0x185, 0x185},
    {0x254, 0x186, 0x186},
    {0x188, 0x187, 0x187},
    {0x187, 0x188, 0x188},
    {0x256, 0x189, 0x189},
    {0x257, 0x18A, 0x18A},
    {0x18C, 0x18B, 0x18B},
    {0x18B, 0x18C, 0x18C},
    {0x1DD, 0x18E, 0x18E},
    {0x259, 0x18F, 0x18F},
    {0x25B, 0x190, 0x190},
    {0x192, 0x191, 0x191},
    {0x191, 0x192, 0x192},
    {0x260, 0x193, 0x193},
    {0x263, 0x194, 0x194},
    {0x1F6, 0x195, 0x195},
    {0x269, 0x196, 0x196},
    {0x268, 0x197, 0x197},
    {0x199, 0x198, 0x198},
    {0x198, 0x199, 0x199},
    {0x23D, 0x19A, 0x19A},
    {0x26F, 0x19C, 0x19C},
    {0x272, 0x19D, 0x19D},
    {0x220, 0x19E, 0x19E},
    {0x275, 0x19F, 0x19F},
    {0x1A1, 0x1A0, 0x1A0},
    {0x1A0, 0x1A1, 0x1A1},
    {0x1A3, 0x1A2, 0x1A2},
    {0x1A2, 0x1A3, 0x1A3},
    {0x1A5, 0x1A4, 0x1A4},
    {0x1A4, 0x1A5, 0x1A5},
    {0x280, 0x1A6, 0x1A6},
    {0x1A8, 0x1A7, 0x1A7},
    {0x1A7, 0x1A8, 0x1A8},
    {0x283, 0x1A9, 0x1A9},
    {0x1AD, 0x1AC, 0x1AC},
    {0x1AC, 0x1AD, 0x1AD},
    {0x288, 0x1AE, 0x1AE},
    {0x1B0, 0x1AF, 0x1AF},
    {0x1AF, 0x1B0, 0x1B0},
    {0x28A, 0x1B1, 0x1B1},
    {0x28B, 0x1B2, 0x1B2},
    {0x1B4, 0x1B3, 0x1B3},
    {0x1B3, 0x1B4, 0x1B4},
    {0x1B6, 0x1B5, 0x1B5},
    {0x1B5, 0x1B6, 0x1B6},
    {0x292, 0x1B7, 0x1B7},
    {0x1B9, 0x1B8, 0x1B8},
    {0x1B8, 0x1B9, 0x1B9},
    {0x1BD, 0x1BC, 0x1BC},
    {0x1BC, 0x1BD, 0x1BD},
    {0x1F7, 0x1BF, 0x1BF},
    {0x1C5, 0x1C6, 0x1C4},
    {0x1C4, 0x1C6, 0x1C5},
    {0x1C4, 0x1C5, 0x1C6},
    {0x1C8, 0x1C9, 0x1C7},
    {0x1C7, 0x1C9, 0x1C8},
    {0x1C7, 0x1C8, 0x1C9},
    {0x1CB, 0x1CC, 0x1CA},
    {0x1CA, 0x1CC, 0x1CB},
    {0x1CA, 0x1CB, 0x1CC},
    {0x1CE, 0x1CD, 0x1CD},
    {0x1CD, 0x1CE, 0x1CE},
    {0x1D0, 0x1CF, 0x1CF},
    {0x1CF, 0x1D0, 0x1D0},
    {0x1D2, 0x1D1, 0x1D1},
    {0x1D1, 0x1D2, 0x1D2},
    {0x1D4, 0x1D3, 0x1D3},
    {0x1D3, 0x1D4, 0x1D4},
    {0x1D6, 0x1D5, 0x1D5},
    {0x1D5, 0x1D6, 0x1D6},
    {0x1D8, 0x1D7, 0x1D7},
    {0x1D7, 0x1D8, 0x1D8},
    {0x1DA, 0x1D9, 0x1D9},
    {0x1D9, 0x1DA, 0x1DA},
    {0x1DC, 0x1DB, 0x1DB},
    {0x1DB, 0x1DC, 0x1DC},
    {0x18E, 0x1DD, 0x1DD},
    {0x1DF, 0x1DE, 0x1DE},
    {0x1DE, 0x1DF, 0x1DF},
    {0x1E1, 0x1E0, 0x1E0},
    {0x1E0, 0x1E1, 0x1E1},
    {0x1E3, 0x1E2, 0x1E2},
    {0x1E2, 0x1E3, 0x1E3},
    {0x1E5, 0x1E4, 0x1E4},
    {0x1E4, 0x1E5, 0x1E5},
    {0x1E7, 0x1E6, 0x1E6},
    {0x1E6, 0x1E7, 0x1E7},
    {0x1E9, 0x1E8, 0x1E8},
    {0x1E8, 0x1E9, 0x1E9},
    {0x1EB, 0x1EA, 0x1EA},
    {0x1EA, 0x1EB, 0x1EB},
    {0x1ED, 0x1EC, 0x1EC},
    {0x1EC, 0x1ED, 0x1ED},
    {0x1EF, 0x1EE, 0x1EE},
    {0x1EE, 0x1EF, 0x1EF},
    {0x1F2, 0x1F3, 0x1F1},
    {0x1F1, 0x1F3, 0x1F2},
    {0x1F1, 0x1F2, 0x1F3},
    {0x1F5, 0x1F4, 0x1F4},
    {0x1F4, 0x1F5, 0x1F5},
    {0x195, 0x1F6, 0x1F6},
    {0x1BF, 0x1F7, 0x1F7},
    {0x1F9, 0x1F8, 0x1F8},
    {0x1F8, 0x1F9, 0x1F9},
    {0x1FB, 0x1FA, 0x1FA},
    {0x1FA, 0x1FB, 0x1FB},
    {0x1FD, 0x1FC, 0x1FC},
    {0x1FC, 0x1FD, 0x1FD},
    {0x1FF, 0x1FE, 0x1FE},
    {0x1FE, 0x1FF, 0x1FF},
    {0x201, 0x200, 0x200},
    {0x200, 0x201, 0x201},
    {0x203, 0x202, 0x202},
    {0x202, 0x203, 0x203},
    {0x205, 0x204, 0x204},
    {0x204, 0x205, 0x205},
    {0x207, 0x206, 0x206},
    {0x206, 0x207, 0x207},
    {0x209, 0x208, 0x208},
    {0x208, 0x209, 0x209},
    {0x20B, 0x20A, 0x20A},
    {0x20A, 0x20B, 0x20B},
    {0x20D, 0x20C, 0x20C},
    {0x20C, 0x20D, 0x20D},
    {0x20F, 0x20E, 0x20E},
    {0x20E, 0x20F, 0x20F},
    {0x211, 0x210, 0x210},
    {0x210, 0x211, 0x211},
    {0x213, 0x212, 0x212},
    {0x212, 0x213, 0x213},
    {0x215, 0x214, 0x214},
    {0x214, 0x215, 0x215},
    {0x217, 0x216, 0x216},
    {0x216, 0x217, 0x217},
    {0x219, 0x218, 0x218},
    {0x218, 0x219, 0x219},
    {0x21B, 0x21A, 0x21A},
    {0x21A, 0x21B, 0x21B},
    {0x21D, 0x21C, 0x21C},
    {0x21C, 0x21D, 0x21D},
    {0x21F, 0x21E, 0x21E},
    {0x21E, 0x21F, 0x21F},
    {0x19E, 0x220, 0x220},
    {0x223, 0x222, 0x222},
    {0x222, 0x223, 0x223},
    {0x225, 0x224, 0x224},
    {0x224, 0x225, 0x225},
    {0x227, 0x226, 0x226},
    {0x226, 0x227, 0x227},
    {0x229, 0x228, 0x228},
    {0x228, 0x229, 0x229},
    {0x22B, 0x22A, 0x22A},
    {0x22A, 0x22B, 0x22B},
    {0x22D, 0x22C, 0x22C},
    {0x22C, 0x22D, 0x22D},
    {0x22F, 0x22E, 0x22E},
    {0x22E, 0x22F, 0x22F},
    {0x231, 0x230, 0x230},
    {0x230, 0x231, 0x231},
    {0x233, 0x232, 0x232},
    {0x232, 0x233, 0x233},
    {0x2C65, 0x23A, 0x23A},
    {0x23C, 0x23B, 0x23B},
    {0x23B, 0x23C, 0x23C},
    {0x19A, 0x23D, 0x23D},
    {0x2C66, 0x23E, 0x23E},
    {0x2C7E, 0x23F, 0x23F},
    {0x2C7F, 0x240, 0x240},
    {0x242, 0x241, 0x241},
    {0x241, 0x242, 0x242},
    {0x180, 0x243, 0x243},
    {0x289, 0x244, 0x244},
    {0x28C, 0x245, 0x245},
    {0x247, 0x246, 0x246},
    {0x246, 0x247, 0x247},
    {0x249, 0x248, 0x248},
    {0x248, 0x249, 0x249},
    {0x24B, 0x24A, 0x24A},
    {0x24A, 0x24B, 0x24B},
    {0x24D, 0x24C, 0x24C},
    {0x24C, 0x24D, 0x24D},
    {0x24F, 0x24E, 0x24E},
    {0x24E, 0x24F, 0x24F},
    {0x2C6F, 0x250, 0x250},
    {0x2C6D, 0x251, 0x251},
    {0x2C70, 0x252, 0x252},
    {0x181, 0x253, 0x253},
    {0x186, 0x254, 0x254},
    {0x189, 0x256, 0x256},
    {0x18A, 0x257, 0x257},
    {0x18F, 0x259, 0x259},
    {0x190, 0x25B, 0x25B},
    {0x193, 0x260, 0x260},
    {0x194, 0x263, 0x263},
    {0xA78D, 0x265, 0x265},
    {0x197, 0x268, 0x268},
    {0x196, 0x269, 0x269},
    {0x2C62, 0x26B, 0x26B},
    {0x19C, 0x26F, 0x26F},
    {0x2C6E, 0x271, 0x271},
    {0x19D, 0x272, 0x272},
    {0x19F, 0x275, 0x275},
    {0x2C64, 0x27D, 0x27D},
    {0x1A6, 0x280, 0x280},
    {0x1A9, 0x283, 0x283},
    {0x1AE, 0x288, 0x288},
    {0x244, 0x289, 0x289},
    {0x1B1, 0x28A, 0x28A},
    {0x1B2, 0x28B, 0x28B},
    {0x245, 0x28C, 0x28C},
    {0x1B7, 0x292, 0x292},
    {0x399, 0x345, 0x345},
    {0x371, 0x370, 0x370},
    {0x370, 0x371, 0x371},
    {0x373, 0x372, 0x372},
    {0x372, 0x373, 0x373},
    {0x377, 0x376, 0x376},
    {0x376, 0x377, 0x377},
    {0x3FD, 0x37B, 0x37B},
    {0x3FE, 0x37C, 0x37C},
    {0x3FF, 0x37D, 0x37D},
    {0x3AC, 0x386, 0x386},
    {0x3AD, 0x388, 0x388},
    {0x3AE, 0x389, 0x389},
    {0x3AF, 0x38A, 0x38A},
    {0x3CC, 0x38C, 0x38C},
    {0x3CD, 0x38E, 0x38E},
    {0x3CE, 0x38F, 0x38F},
    {0x3B1, 0x391, 0x391},
    {0x3B2, 0x3D0, 0x392},
    {0x3B3, 0x393, 0x393},
    {0x3B4, 0x394, 0x394},
    {0x3B5, 0x3F5, 0x395},
    {0x3B6, 0x396, 0x396},
    {0x3B7, 0x397, 0x397},
    {0x3B8, 0x3D1, 0x398},
    {0x345, 0x3B9, 0x1FBE},
    {0x3BA, 0x3F0, 0x39A},
    {0x3BB, 0x39B, 0x39B},
    {0xB5, 0x3BC, 0x39C},
    {0x3BD, 0x39D, 0x39D},
    {0x3BE, 0x39E, 0x39E},
    {0x3BF, 0x39F, 0x39F},
    {0x3C0, 0x3D6, 0x3A0},
    {0x3C1, 0x3F1, 0x3A1},
    {0x3C2, 0x3C3, 0x3A3},
    {0x3C4, 0x3A4, 0x3A4},
    {0x3C5, 0x3A5, 0x3A5},
    {0x3C6, 0x3D5, 0x3A6},
    {0x3C7, 0x3A7, 0x3A7},
    {0x3C8, 0x3A8, 0x3A8},
    {0x3C9, 0x3A9, 0x3A9},
    {0x3CA, 0x3AA, 0x3AA},
    {0x3CB, 0x3AB, 0x3AB},
    {0x386, 0x3AC, 0x3AC},
    {0x388, 0x3AD, 0x3AD},
    {0x389, 0x3AE, 0x3AE},
    {0x38A, 0x3AF, 0x3AF},
    {0x391, 0x3B1, 0x3B1},
    {0x392, 0x3B2, 0x3B2},
    {0x393, 0x3B3, 0x3B3},
    {0x394, 0x3B4, 0x3B4},
    {0x395, 0x3B5, 0x3B5},
    {0x396, 0x3B6, 0x3B6},
    {0x397, 0x3B7, 0x3B7},
    {0x398, 0x3F4, 0x3B8},
    {0x399, 0x3B9, 0x3B9},
    {0x39A, 0x3BA, 0x3BA},
    {0x39B, 0x3BB, 0x3BB},
    {0x39C, 0x3BC, 0x3BC},
    {0x39D, 0x3BD, 0x3BD},
    {0x39E, 0x3BE, 0x3BE},
    {0x39F, 0x3BF, 0x3BF},
    {0x3A0, 0x3C0, 0x3C0},
    {0x3A1, 0x3C1, 0x3C1},
    {0x3A3, 0x3C2, 0x3C2},
    {0x3A3, 0x3C3, 0x3C3},
    {0x3A4, 0x3C4, 0x3C4},
    {0x3A5, 0x3C5, 0x3C5},
    {0x3A6, 0x3C6, 0x3C6},
    {0x3A7, 0x3C7, 0x3C7},
    {0x3A8, 0x3C8, 0x3C8},
    {0x3A9, 0x2126, 0x3C9},
    {0x3AA, 0x3CA, 0x3CA},
    {0x3AB, 0x3CB, 0x3CB},
    {0x38C, 0x3CC, 0x3CC},
    {0x38E, 0x3CD, 0x3CD},
    {0x38F, 0x3CE, 0x3CE},
    {0x3D7, 0x3CF, 0x3CF},
    {0x392, 0x3D0, 0x3D0},
    {0x398, 0x3D1, 0x3D1},
    {0x3A6, 0x3D5, 0x3D5},
    {0x3A0, 0x3D6, 0x3D6},
    {0x3CF, 0x3D7, 0x3D7},
    {0x3D9, 0x3D8, 0x3D8},
    {0x3D8, 0x3D9, 0x3D9},
    {0x3DB, 0x3DA, 0x3DA},
    {0x3DA, 0x3DB, 0x3DB},
    {0x3DD, 0x3DC, 0x3DC},
    {0x3DC, 0x3DD, 0x3DD},
    {0x3DF, 0x3DE, 0x3DE},
    {0x3DE, 0x3DF, 0x3DF},
    {0x3E1, 0x3E0, 0x3E0},
    {0x3E0, 0x3E1, 0x3E1},
    {0x3E3, 0x3E2, 0x3E2},
    {0x3E2, 0x3E3, 0x3E3},
    {0x3E5, 0x3E4, 0x3E4},
    {0x3E4, 0x3E5, 0x3E5},
    {0x3E7, 0x3E6, 0x3E6},
    {0x3E6, 0x3E7, 0x3E7},
    {0x3E9, 0x3E8, 0x3E8},
    {0x3E8, 0x3E9, 0x3E9},
    {0x3EB, 0x3EA, 0x3EA},
    {0x3EA, 0x3EB, 0x3EB},
    {0x3ED, 0x3EC, 0x3EC},
    {0x3EC, 0x3ED, 0x3ED},
    {0x3EF, 0x3EE, 0x3EE},
    {0x3EE, 0x3EF, 0x3EF},
    {0x39A, 0x3F0, 0x3F0},
    {0x3A1, 0x3F1, 0x3F1},
    {0x3F9, 0x3F2, 0x3F2},
    {0x3B8, 0x3F4, 0x3F4},
    {0x395, 0x3F5, 0x3F5},
    {0x3F8, 0x3F7, 0x3F7},
    {0x3F7, 0x3F8, 0x3F8},
    {0x3F2, 0x3F9, 0x3F9},
    {0x3FB, 0x3FA, 0x3FA},
    {0x3FA, 0x3FB, 0x3FB},
    {0x37B, 0x3FD, 0x3FD},
    {0x37C, 0x3FE, 0x3FE},
    {0x37D, 0x3FF, 0x3FF},
    {0x450, 0x400, 0x400},
    {0x451, 0x401, 0x401},
    {0x452, 0x402, 0x402},
    {0x453, 0x403, 0x403},
    {0x454, 0x404, 0x404},
    {0x455, 0x405, 0x405},
    {0x456, 0x406, 0x406},
    {0x457, 0x407, 0x407},
    {0x458, 0x408, 0x408},
    {0x459, 0x409, 0x409},
    {0x45A, 0x40A, 0x40A},
    {0x45B, 0x40B, 0x40B},
    {0x45C, 0x40C, 0x40C},
    {0x45D, 0x40D, 0x40D},
    {0x45E, 0x40E, 0x40E},
    {0x45F, 0x40F, 0x40F},
    {0x430, 0x410, 0x410},
    {0x431, 0x411, 0x411},
    {0x432, 0x412, 0x412},
    {0x433, 0x413, 0x413},
    {0x434, 0x414, 0x414},
    {0x435, 0x415, 0x415},
    {0x436, 0x416, 0x416},
    {0x437, 0x417, 0x417},
    {0x438, 0x418, 0x418},
    {0x439, 0x419, 0x419},
    {0x43A, 0x41A, 0x41A},
    {0x43B, 0x41B, 0x41B},
    {0x43C, 0x41C, 0x41C},
    {0x43D, 0x41D, 0x41D},
    {0x43E, 0x41E, 0x41E},
    {0x43F, 0x41F, 0x41F},
    {0x440, 0x420, 0x420},
    {0x441, 0x421, 0x421},
    {0x442, 0x422, 0x422},
    {0x443, 0x423, 0x423},
    {0x444, 0x424, 0x424},
    {0x445, 0x425, 0x425},
    {0x446, 0x426, 0x426},
    {0x447, 0x427, 0x427},
    {0x448, 0x428, 0x428},
    {0x449, 0x429, 0x429},
    {0x44A, 0x42A, 0x42A},
    {0x44B, 0x42B, 0x42B},
    {0x44C, 0x42C, 0x42C},
    {0x44D, 0x42D, 0x42D},
    {0x44E, 0x42E, 0x42E},
    {0x44F, 0x42F, 0x42F},
    {0x410, 0x430, 0x430},
    {0x411, 0x431, 0x431},
    {0x412, 0x432, 0x432},
    {0x413, 0x433, 0x433},
    {0x414, 0x434, 0x434},
    {0x415, 0x435, 0x435},
    {0x416, 0x436, 0x436},
    {0x417, 0x437, 0x437},
    {0x418, 0x438, 0x438},
    {0x419, 0x439, 0x439},
    {0x41A, 0x43A, 0x43A},
    {0x41B, 0x43B, 0x43B},
    {0x41C, 0x43C, 0x43C},
    {0x41D, 0x43D, 0x43D},
    {0x41E, 0x43E, 0x43E},
    {0x41F, 0x43F, 0x43F},
    {0x420, 0x440, 0x440},
    {0x421, 0x441, 0x441},
    {0x422, 0x442, 0x442},
    {0x423, 0x443, 0x443},
    {0x424, 0x444, 0x444},
    {0x425, 0x445, 0x445},
    {0x426, 0x446, 0x446},
    {0x427, 0x447, 0x447},
    {0x428, 0x448, 0x448},
    {0x429, 0x449, 0x449},
    {0x42A, 0x44A, 0x44A},
    {0x42B, 0x44B, 0x44B},
    {0x42C, 0x44C, 0x44C},
    {0x42D, 0x44D, 0x44D},
    {0x42E, 0x44E, 0x44E},
    {0x42F, 0x44F, 0x44F},
    {0x400, 0x450, 0x450},
    {0x401, 0x451, 0x451},
    {0x402, 0x452, 0x452},
    {0x403, 0x453, 0x453},
    {0x404, 0x454, 0x454},
    {0x405, 0x455, 0x455},
    {0x406, 0x456, 0x456},
    {0x407, 0x457, 0x457},
    {0x408, 0x458, 0x458},
    {0x409, 0x459, 0x459},
    {0x40A, 0x45A, 0x45A},
    {0x40B, 0x45B, 0x45B},
    {0x40C, 0x45C, 0x45C},
    {0x40D, 0x45D, 0x45D},
    {0x40E, 0x45E, 0x45E},
    {0x40F, 0x45F, 0x45F},
    {0x461, 0x460, 0x460},
    {0x460, 0x461, 0x461},
    {0x463, 0x462, 0x462},
    {0x462, 0x463, 0x463},
    {0x465, 0x464, 0x464},
    {0x464, 0x465, 0x465},
    {0x467, 0x466, 0x466},
    {0x466, 0x467, 0x467},
    {0x469, 0x468, 0x468},
    {0x468, 0x469, 0x469},
    {0x46B, 0x46A, 0x46A},
    {0x46A, 0x46B, 0x46B},
    {0x46D, 0x46C, 0x46C},
    {0x46C, 0x46D, 0x46D},
    {0x46F, 0x46E, 0x46E},
    {0x46E, 0x46F, 0x46F},
    {0x471, 0x470, 0x470},
    {0x470, 0x471, 0x471},
    {0x473, 0x472, 0x472},
    {0x472, 0x473, 0x473},
    {0x475, 0x474, 0x474},
    {0x474, 0x475, 0x475},
    {0x477, 0x476, 0x476},
    {0x476, 0x477, 0x477},
    {0x479, 0x478, 0x478},
    {0x478, 0x479, 0x479},
    {0x47B, 0x47A, 0x47A},
    {0x47A, 0x47B, 0x47B},
    {0x47D, 0x47C, 0x47C},
    {0x47C, 0x47D, 0x47D},
    {0x47F, 0x47E, 0x47E},
    {0x47E, 0x47F, 0x47F},
    {0x481, 0x480, 0x480},
    {0x480, 0x481, 0x481},
    {0x48B, 0x48A, 0x48A},
    {0x48A, 0x48B, 0x48B},
    {0x48D, 0x48C, 0x48C},
    {0x48C, 0x48D, 0x48D},
    {0x48F, 0x48E, 0x48E},
    {0x48E, 0x48F, 0x48F},
    {0x491, 0x490, 0x490},
    {0x490, 0x491, 0x491},
    {0x493, 0x492, 0x492},
    {0x492, 0x493, 0x493},
    {0x495, 0x494, 0x494},
    {0x494, 0x495, 0x495},
    {0x497, 0x496, 0x496},
    {0x496, 0x497, 0x497},
    {0x499, 0x498, 0x498},
    {0x498, 0x499, 0x499},
    {0x49B, 0x49A, 0x49A},
    {0x49A, 0x49B, 0x49B},
    {0x49D, 0x49C, 0x49C},
    {0x49C, 0x49D, 0x49D},
    {0x49F, 0x49E, 0x49E},
    {0x49E, 0x49F, 0x49F},
    {0x4A1, 0x4A0, 0x4A0},
    {0x4A0, 0x4A1, 0x4A1},
    {0x4A3, 0x4A2, 0x4A2},
    {0x4A2, 0x4A3, 0x4A3},
    {0x4A5, 0x4A4, 0x4A4},
    {0x4A4, 0x4A5, 0x4A5},
    {0x4A7, 0x4A6, 0x4A6},
    {0x4A6, 0x4A7, 0x4A7},
    {0x4A9, 0x4A8, 0x4A8},
    {0x4A8, 0x4A9, 0x4A9},
    {0x4AB, 0x4AA, 0x4AA},
    {0x4AA, 0x4AB, 0x4AB},
    {0x4AD, 0x4AC, 0x4AC},
    {0x4AC, 0x4AD, 0x4AD},
    {0x4AF, 0x4AE, 0x4AE},
    {0x4AE, 0x4AF, 0x4AF},
    {0x4B1, 0x4B0, 0x4B0},
    {0x4B0, 0x4B1, 0x4B1},
    {0x4B3, 0x4B2, 0x4B2},
    {0x4B2, 0x4B3, 0x4B3},
    {0x4B5, 0x4B4, 0x4B4},
    {0x4B4, 0x4B5, 0x4B5},
    {0x4B7, 0x4B6, 0x4B6},
    {0x4B6, 0x4B7, 0x4B7},
    {0x4B9, 0x4B8, 0x4B8},
    {0x4B8, 0x4B9, 0x4B9},
    {0x4BB, 0x4BA, 0x4BA},
    {0x4BA, 0x4BB, 0x4BB},
    {0x4BD, 0x4BC, 0x4BC},
    {0x4BC, 0x4BD, 0x4BD},
    {0x4BF, 0x4BE, 0x4BE},
    {0x4BE, 0x4BF, 0x4BF},
    {0x4CF, 0x4C0, 0x4C0},
    {0x4C2, 0x4C1, 0x4C1},
    {0x4C1, 0x4C2, 0x4C2},
    {0x4C4, 0x4C3, 0x4C3},
    {0x4C3, 0x4C4, 0x4C4},
    {0x4C6, 0x4C5, 0x4C5},
    {0x4C5, 0x4C6, 0x4C6},
    {0x4C8, 0x4C7, 0x4C7},
    {0x4C7, 0x4C8, 0x4C8},
    {0x4CA, 0x4C9, 0x4C9},
    {0x4C9, 0x4CA, 0x4CA},
    {0x4CC, 0x4CB, 0x4CB},
    {0x4CB, 0x4CC, 0x4CC},
    {0x4CE, 0x4CD, 0x4CD},
    {0x4CD, 0x4CE, 0x4CE},
    {0x4C0, 0x4CF, 0x4CF},
    {0x4D1, 0x4D0, 0x4D0},
    {0x4D0, 0x4D1, 0x4D1},
    {0x4D3, 0x4D2, 0x4D2},
    {0x4D2, 0x4D3, 0x4D3},
    {0x4D5, 0x4D4, 0x4D4},
    {0x4D4, 0x4D5, 0x4D5},
    {0x4D7, 0x4D6, 0x4D6},
    {0x4D6, 0x4D7, 0x4D7},
    {0x4D9, 0x4D8, 0x4D8},
    {0x4D8, 0x4D9, 0x4D9},
    {0x4DB, 0x4DA, 0x4DA},
    {0x4DA, 0x4DB, 0x4DB},
    {0x4DD, 0x4DC, 0x4DC},
    {0x4DC, 0x4DD, 0x4DD},
    {0x4DF, 0x4DE, 0x4DE},
    {0x4DE, 0x4DF, 0x4DF},
    {0x4E1, 0x4E0, 0x4E0},
    {0x4E0, 0x4E1, 0x4E1},
    {0x4E3, 0x4E2, 0x4E2},
    {0x4E2, 0x4E3, 0x4E3},
    {0x4E5, 0x4E4, 0x4E4},
    {0x4E4, 0x4E5, 0x4E5},
    {0x4E7, 0x4E6, 0x4E6},
    {0x4E6, 0x4E7, 0x4E7},
    {0x4E9, 0x4E8, 0x4E8},
    {0x4E8, 0x4E9, 0x4E9},
    {0x4EB, 0x4EA, 0x4EA},
    {0x4EA, 0x4EB, 0x4EB},
    {0x4ED, 0x4EC, 0x4EC},
    {0x4EC, 0x4ED, 0x4ED},
    {0x4EF, 0x4EE, 0x4EE},
    {0x4EE, 0x4EF, 0x4EF},
    {0x4F1, 0x4F0, 0x4F0},
    {0x4F0, 0x4F1, 0x4F1},
    {0x4F3, 0x4F2, 0x4F2},
    {0x4F2, 0x4F3, 0x4F3},
    {0x4F5, 0x4F4, 0x4F4},
    {0x4F4, 0x4F5, 0x4F5},
    {0x4F7, 0x4F6, 0x4F6},
    {0x4F6, 0x4F7, 0x4F7},
    {0x4F9, 0x4F8, 0x4F8},
    {0x4F8, 0x4F9, 0x4F9},
    {0x4FB, 0x4FA, 0x4FA},
    {0x4FA, 0x4FB, 0x4FB},
    {0x4FD, 0x4FC, 0x4FC},
    {0x4FC, 0x4FD, 0x4FD},
    {0x4FF, 0x4FE, 0x4FE},
    {0x4FE, 0x4FF, 0x4FF},
    {0x501, 0x500, 0x500},
    {0x500, 0x501, 0x501},
    {0x503, 0x502, 0x502},
    {0x502, 0x503, 0x503},
    {0x505, 0x504, 0x504},
    {0x504, 0x505, 0x505},
    {0x507, 0x506, 0x506},
    {0x506, 0x507, 0x507},
    {0x509, 0x508, 0x508},
    {0x508, 0x509, 0x509},
    {0x50B, 0x50A, 0x50A},
    {0x50A, 0x50B, 0x50B},
    {0x50D, 0x50C, 0x50C},
    {0x50C, 0x50D, 0x50D},
    {0x50F, 0x50E, 0x50E},
    {0x50E, 0x50F, 0x50F},
    {0x511, 0x510, 0x510},
    {0x510, 0x511, 0x511},
    {0x513, 0x512, 0x512},
    {0x512, 0x513, 0x513},
    {0x515, 0x514, 0x514},
    {0x514, 0x515, 0x515},
    {0x517, 0x516, 0x516},
    {0x516, 0x517, 0x517},
    {0x519, 0x518, 0x518},
    {0x518, 0x519, 0x519},
    {0x51B, 0x51A, 0x51A},
    {0x51A, 0x51B, 0x51B},
    {0x51D, 0x51C, 0x51C},
    {0x51C, 0x51D, 0x51D},
    {0x51F, 0x51E, 0x51E},
    {0x51E, 0x51F, 0x51F},
    {0x521, 0x520, 0x520},
    {0x520, 0x521, 0x521},
    {0x523, 0x522, 0x522},
    {0x522, 0x523, 0x523},
    {0x525, 0x524, 0x524},
    {0x524, 0x525, 0x525},
    {0x527, 0x526, 0x526},
    {0x526, 0x527, 0x527},
    {0x561, 0x531, 0x531},
    {0x562, 0x532, 0x532},
    {0x563, 0x533, 0x533},
    {0x564, 0x534, 0x534},
    {0x565, 0x535, 0x535},
    {0x566, 0x536, 0x536},
    {0x567, 0x537, 0x537},
    {0x568, 0x538, 0x538},
    {0x569, 0x539, 0x539},
    {0x56A, 0x53A, 0x53A},
    {0x56B, 0x53B, 0x53B},
    {0x56C, 0x53C, 0x53C},
    {0x56D, 0x53D, 0x53D},
    {0x56E, 0x53E, 0x53E},
    {0x56F, 0x53F, 0x53F},
    {0x570, 0x540, 0x540},
    {0x571, 0x541, 0x541},
    {0x572, 0x542, 0x542},
    {0x573, 0x543, 0x543},
    {0x574, 0x544, 0x544},
    {0x575, 0x545, 0x545},
    {0x576, 0x546, 0x546},
    {0x577, 0x547, 0x547},
    {0x578, 0x548, 0x548},
    {0x579, 0x549, 0x549},
    {0x57A, 0x54A, 0x54A},
    {0x57B, 0x54B, 0x54B},
    {0x57C, 0x54C, 0x54C},
    {0x57D, 0x54D, 0x54D},
    {0x57E, 0x54E, 0x54E},
    {0x57F, 0x54F, 0x54F},
    {0x580, 0x550, 0x550},
    {0x581, 0x551, 0x551},
    {0x582, 0x552, 0x552},
    {0x583, 0x553, 0x553},
    {0x584, 0x554, 0x554},
    {0x585, 0x555, 0x555},
    {0x586, 0x556, 0x556},
    {0x531, 0x561, 0x561},
    {0x532, 0x562, 0x562},
    {0x533, 0x563, 0x563},
    {0x534, 0x564, 0x564},
    {0x535, 0x565, 0x565},
    {0x536, 0x566, 0x566},
    {0x537, 0x567, 0x567},
    {0x538, 0x568, 0x568},
    {0x539, 0x569, 0x569},
    {0x53A, 0x56A, 0x56A},
    {0x53B, 0x56B, 0x56B},
    {0x53C, 0x56C, 0x56C},
    {0x53D, 0x56D, 0x56D},
    {0x53E, 0x56E, 0x56E},
    {0x53F, 0x56F, 0x56F},
    {0x540, 0x570, 0x570},
    {0x541, 0x571, 0x571},
    {0x542, 0x572, 0x572},
    {0x543, 0x573, 0x573},
    {0x544, 0x574, 0x574},
    {0x545, 0x575, 0x575},
    {0x546, 0x576, 0x576},
    {0x547, 0x577, 0x577},
    {0x548, 0x578, 0x578},
    {0x549, 0x579, 0x579},
    {0x54A, 0x57A, 0x57A},
    {0x54B, 0x57B, 0x57B},
    {0x54C, 0x57C, 0x57C},
    {0x54D, 0x57D, 0x57D},
    {0x54E, 0x57E, 0x57E},
    {0x54F, 0x57F, 0x57F},
    {0x550, 0x580, 0x580},
    {0x551, 0x581, 0x581},
    {0x552, 0x582, 0x582},
    {0x553, 0x583, 0x583},
    {0x554, 0x584, 0x584},
    {0x555, 0x585, 0x585},
    {0x556, 0x586, 0x586},
    {0x2D00, 0x10A0, 0x10A0},
    {0x2D01, 0x10A1, 0x10A1},
    {0x2D02, 0x10A2, 0x10A2},
    {0x2D03, 0x10A3, 0x10A3},
    {0x2D04, 0x10A4, 0x10A4},
    {0x2D05, 0x10A5, 0x10A5},
    {0x2D06, 0x10A6, 0x10A6},
    {0x2D07, 0x10A7, 0x10A7},
    {0x2D08, 0x10A8, 0x10A8},
    {0x2D09, 0x10A9, 0x10A9},
    {0x2D0A, 0x10AA, 0x10AA},
    {0x2D0B, 0x10AB, 0x10AB},
    {0x2D0C, 0x10AC, 0x10AC},
    {0x2D0D, 0x10AD, 0x10AD},
    {0x2D0E, 0x10AE, 0x10AE},
    {0x2D0F, 0x10AF, 0x10AF},
    {0x2D10, 0x10B0, 0x10B0},
    {0x2D11, 0x10B1, 0x10B1},
    {0x2D12, 0x10B2, 0x10B2},
    {0x2D13, 0x10B3, 0x10B3},
    {0x2D14, 0x10B4, 0x10B4},
    {0x2D15, 0x10B5, 0x10B5},
    {0x2D16, 0x10B6, 0x10B6},
    {0x2D17, 0x10B7, 0x10B7},
    {0x2D18, 0x10B8, 0x10B8},
    {0x2D19, 0x10B9, 0x10B9},
    {0x2D1A, 0x10BA, 0x10BA},
    {0x2D1B, 0x10BB, 0x10BB},
    {0x2D1C, 0x10BC, 0x10BC},
    {0x2D1D, 0x10BD, 0x10BD},
    {0x2D1E, 0x10BE, 0x10BE},
    {0x2D1F, 0x10BF, 0x10BF},
    {0x2D20, 0x10C0, 0x10C0},
    {0x2D21, 0x10C1, 0x10C1},
    {0x2D22, 0x10C2, 0x10C2},
    {0x2D23, 0x10C3, 0x10C3},
    {0x2D24, 0x10C4, 0x10C4},
    {0x2D25, 0x10C5, 0x10C5},
    {0xA77D, 0x1D79, 0x1D79},
    {0x2C63, 0x1D7D, 0x1D7D},
    {0x1E01, 0x1E00, 0x1E00},
    {0x1E00, 0x1E01, 0x1E01},
    {0x1E03, 0x1E02, 0x1E02},
    {0x1E02, 0x1E03, 0x1E03},
    {0x1E05, 0x1E04, 0x1E04},
    {0x1E04, 0x1E05, 0x1E05},
    {0x1E07, 0x1E06, 0x1E06},
    {0x1E06, 0x1E07, 0x1E07},
    {0x1E09, 0x1E08, 0x1E08},
    {0x1E08, 0x1E09, 0x1E09},
    {0x1E0B, 0x1E0A, 0x1E0A},
    {0x1E0A, 0x1E0B, 0x1E0B},
    {0x1E0D, 0x1E0C, 0x1E0C},
    {0x1E0C, 0x1E0D, 0x1E0D},
    {0x1E0F, 0x1E0E, 0x1E0E},
    {0x1E0E, 0x1E0F, 0x1E0F},
    {0x1E11, 0x1E10, 0x1E10},
    {0x1E10, 0x1E11, 0x1E11},
    {0x1E13, 0x1E12, 0x1E12},
    {0x1E12, 0x1E13, 0x1E13},
    {0x1E15, 0x1E14, 0x1E14},
    {0x1E14, 0x1E15, 0x1E15},
    {0x1E17, 0x1E16, 0x1E16},
    {0x1E16, 0x1E17, 0x1E17},
    {0x1E19, 0x1E18, 0x1E18},
    {0x1E18, 0x1E19, 0x1E19},
    {0x1E1B, 0x1E1A, 0x1E1A},
    {0x1E1A, 0x1E1B, 0x1E1B},
    {0x1E1D, 0x1E1C, 0x1E1C},
    {0x1E1C, 0x1E1D, 0x1E1D},
    {0x1E1F, 0x1E1E, 0x1E1E},
    {0x1E1E, 0x1E1F, 0x1E1F},
    {0x1E21, 0x1E20, 0x1E20},
    {0x1E20, 0x1E21, 0x1E21},
    {0x1E23, 0x1E22, 0x1E22},
    {0x1E22, 0x1E23, 0x1E23},
    {0x1E25, 0x1E24, 0x1E24},
    {0x1E24, 0x1E25, 0x1E25},
    {0x1E27, 0x1E26, 0x1E26},
    {0x1E26, 0x1E27, 0x1E27},
    {0x1E29, 0x1E28, 0x1E28},
    {0x1E28, 0x1E29, 0x1E29},
    {0x1E2B, 0x1E2A, 0x1E2A},
    {0x1E2A, 0x1E2B, 0x1E2B},
    {0x1E2D, 0x1E2C, 0x1E2C},
    {0x1E2C, 0x1E2D, 0x1E2D},
    {0x1E2F, 0x1E2E, 0x1E2E},
    {0x1E2E, 0x1E2F, 0x1E2F},
    {0x1E31, 0x1E30, 0x1E30},
    {0x1E30, 0x1E31, 0x1E31},
    {0x1E33, 0x1E32, 0x1E32},
    {0x1E32, 0x1E33, 0x1E33},
    {0x1E35, 0x1E34, 0x1E34},
    {0x1E34, 0x1E35, 0x1E35},
    {0x1E37, 0x1E36, 0x1E36},
    {0x1E36, 0x1E37, 0x1E37},
    {0x1E39, 0x1E38, 0x1E38},
    {0x1E38, 0x1E39, 0x1E39},
    {0x1E3B, 0x1E3A, 0x1E3A},
    {0x1E3A, 0x1E3B, 0x1E3B},
    {0x1E3D, 0x1E3C, 0x1E3C},
    {0x1E3C, 0x1E3D, 0x1E3D},
    {0x1E3F, 0x1E3E, 0x1E3E},
    {0x1E3E, 0x1E3F, 0x1E3F},
    {0x1E41, 0x1E40, 0x1E40},
    {0x1E40, 0x1E41, 0x1E41},
    {0x1E43, 0x1E42, 0x1E42},
    {0x1E42, 0x1E43, 0x1E43},
    {0x1E45, 0x1E44, 0x1E44},
    {0x1E44, 0x1E45, 0x1E45},
    {0x1E47, 0x1E46, 0x1E46},
    {0x1E46, 0x1E47, 0x1E47},
    {0x1E49, 0x1E48, 0x1E48},
    {0x1E48, 0x1E49, 0x1E49},
    {0x1E4B, 0x1E4A, 0x1E4A},
    {0x1E4A, 0x1E4B, 0x1E4B},
    {0x1E4D, 0x1E4C, 0x1E4C},
    {0x1E4C, 0x1E4D, 0x1E4D},
    {0x1E4F, 0x1E4E, 0x1E4E},
    {0x1E4E, 0x1E4F, 0x1E4F},
    {0x1E51, 0x1E50, 0x1E50},
    {0x1E50, 0x1E51, 0x1E51},
    {0x1E53, 0x1E52, 0x1E52},
    {0x1E52, 0x1E53, 0x1E53},
    {0x1E55, 0x1E54, 0x1E54},
    {0x1E54, 0x1E55, 0x1E55},
    {0x1E57, 0x1E56, 0x1E56},
    {0x1E56, 0x1E57, 0x1E57},
    {0x1E59, 0x1E58, 0x1E58},
    {0x1E58, 0x1E59, 0x1E59},
    {0x1E5B, 0x1E5A, 0x1E5A},
    {0x1E5A, 0x1E5B, 0x1E5B},
    {0x1E5D, 0x1E5C, 0x1E5C},
    {0x1E5C, 0x1E5D, 0x1E5D},
    {0x1E5F, 0x1E5E, 0x1E5E},
    {0x1E5E, 0x1E5F, 0x1E5F},
    {0x1E61, 0x1E9B, 0x1E60},
    {0x1E60, 0x1E61, 0x1E61},
    {0x1E63, 0x1E62, 0x1E62},
    {0x1E62, 0x1E63, 0x1E63},
    {0x1E65, 0x1E64, 0x1E64},
    {0x1E64, 0x1E65, 0x1E65},
    {0x1E67, 0x1E66, 0x1E66},
    {0x1E66, 0x1E67, 0x1E67},
    {0x1E69, 0x1E68, 0x1E68},
    {0x1E68, 0x1E69, 0x1E69},
    {0x1E6B, 0x1E6A, 0x1E6A},
    {0x1E6A, 0x1E6B, 0x1E6B},
    {0x1E6D, 0x1E6C, 0x1E6C},
    {0x1E6C, 0x1E6D, 0x1E6D},
    {0x1E6F, 0x1E6E, 0x1E6E},
    {0x1E6E, 0x1E6F, 0x1E6F},
    {0x1E71, 0x1E70, 0x1E70},
    {0x1E70, 0x1E71, 0x1E71},
    {0x1E73, 0x1E72, 0x1E72},
    {0x1E72, 0x1E73, 0x1E73},
    {0x1E75, 0x1E74, 0x1E74},
    {0x1E74, 0x1E75, 0x1E75},
    {0x1E77, 0x1E76, 0x1E76},
    {0x1E76, 0x1E77, 0x1E77},
    {0x1E79, 0x1E78, 0x1E78},
    {0x1E78, 0x1E79, 0x1E79},
    {0x1E7B, 0x1E7A, 0x1E7A},
    {0x1E7A, 0x1E7B, 0x1E7B},
    {0x1E7D, 0x1E7C, 0x1E7C},
    {0x1E7C, 0x1E7D, 0x1E7D},
    {0x1E7F, 0x1E7E, 0x1E7E},
    {0x1E7E, 0x1E7F, 0x1E7F},
    {0x1E81, 0x1E80, 0x1E80},
    {0x1E80, 0x1E81, 0x1E81},
    {0x1E83, 0x1E82, 0x1E82},
    {0x1E82, 0x1E83, 0x1E83},
    {0x1E85, 0x1E84, 0x1E84},
    {0x1E84, 0x1E85, 0x1E85},
    {0x1E87, 0x1E86, 0x1E86},
    {0x1E86, 0x1E87, 0x1E87},
    {0x1E89, 0x1E88, 0x1E88},
    {0x1E88, 0x1E89, 0x1E89},
    {0x1E8B, 0x1E8A, 0x1E8A},
    {0x1E8A, 0x1E8B, 0x1E8B},
    {0x1E8D, 0x1E8C, 0x1E8C},
    {0x1E8C, 0x1E8D, 0x1E8D},
    {0x1E8F, 0x1E8E, 0x1E8E},
    {0x1E8E, 0x1E8F, 0x1E8F},
    {0x1E91, 0x1E90, 0x1E90},
    {0x1E90, 0x1E91, 0x1E91},
    {0x1E93, 0x1E92, 0x1E92},
    {0x1E92, 0x1E93, 0x1E93},
    {0x1E95, 0x1E94, 0x1E94},
    {0x1E94, 0x1E95, 0x1E95},
    {0x1E60, 0x1E9B, 0x1E9B},
    {0xDF, 0x1E9E, 0x1E9E},
    {0x1EA1, 0x1EA0, 0x1EA0},
    {0x1EA0, 0x1EA1, 0x1EA1},
    {0x1EA3, 0x1EA2, 0x1EA2},
    {0x1EA2, 0x1EA3, 0x1EA3},
    {0x1EA5, 0x1EA4, 0x1EA4},
    {0x1EA4, 0x1EA5, 0x1EA5},
    {0x1EA7, 0x1EA6, 0x1EA6},
    {0x1EA6, 0x1EA7, 0x1EA7},
    {0x1EA9, 0x1EA8, 0x1EA8},
    {0x1EA8, 0x1EA9, 0x1EA9},
    {0x1EAB, 0x1EAA, 0x1EAA},
    {0x1EAA, 0x1EAB, 0x1EAB},
    {0x1EAD, 0x1EAC, 0x1EAC},
    {0x1EAC, 0x1EAD, 0x1EAD},
    {0x1EAF, 0x1EAE, 0x1EAE},
    {0x1EAE, 0x1EAF, 0x1EAF},
    {0x1EB1, 0x1EB0, 0x1EB0},
    {0x1EB0, 0x1EB1, 0x1EB1},
    {0x1EB3, 0x1EB2, 0x1EB2},
    {0x1EB2, 0x1EB3, 0x1EB3},
    {0x1EB5, 0x1EB4, 0x1EB4},
    {0x1EB4, 0x1EB5, 0x1EB5},
    {0x1EB7, 0x1EB6, 0x1EB6},
    {0x1EB6, 0x1EB7, 0x1EB7},
    {0x1EB9, 0x1EB8, 0x1EB8},
    {0x1EB8, 0x1EB9, 0x1EB9},
    {0x1EBB, 0x1EBA, 0x1EBA},
    {0x1EBA, 0x1EBB, 0x1EBB},
    {0x1EBD, 0x1EBC, 0x1EBC},
    {0x1EBC, 0x1EBD, 0x1EBD},
    {0x1EBF, 0x1EBE, 0x1EBE},
    {0x1EBE, 0x1EBF, 0x1EBF},
    {0x1EC1, 0x1EC0, 0x1EC0},
    {0x1EC0, 0x1EC1, 0x1EC1},
    {0x1EC3, 0x1EC2, 0x1EC2},
    {0x1EC2, 0x1EC3, 0x1EC3},
    {0x1EC5, 0x1EC4, 0x1EC4},
    {0x1EC4, 0x1EC5, 0x1EC5},
    {0x1EC7, 0x1EC6, 0x1EC6},
    {0x1EC6, 0x1EC7, 0x1EC7},
    {0x1EC9, 0x1EC8, 0x1EC8},
    {0x1EC8, 0x1EC9, 0x1EC9},
    {0x1ECB, 0x1ECA, 0x1ECA},
    {0x1ECA, 0x1ECB, 0x1ECB},
    {0x1ECD, 0x1ECC, 0x1ECC},
    {0x1ECC, 0x1ECD, 0x1ECD},
    {0x1ECF, 0x1ECE, 0x1ECE},
    {0x1ECE, 0x1ECF, 0x1ECF},
    {0x1ED1, 0x1ED0, 0x1ED0},
    {0x1ED0, 0x1ED1, 0x1ED1},
    {0x1ED3, 0x1ED2, 0x1ED2},
    {0x1ED2, 0x1ED3, 0x1ED3},
    {0x1ED5, 0x1ED4, 0x1ED4},
    {0x1ED4, 0x1ED5, 0x1ED5},
    {0x1ED7, 0x1ED6, 0x1ED6},
    {0x1ED6, 0x1ED7, 0x1ED7},
    {0x1ED9, 0x1ED8, 0x1ED8},
    {0x1ED8, 0x1ED9, 0x1ED9},
    {0x1EDB, 0x1EDA, 0x1EDA},
    {0x1EDA, 0x1EDB, 0x1EDB},
    {0x1EDD, 0x1EDC, 0x1EDC},
    {0x1EDC, 0x1EDD, 0x1EDD},
    {0x1EDF, 0x1EDE, 0x1EDE},
    {0x1EDE, 0x1EDF, 0x1EDF},
    {0x1EE1, 0x1EE0, 0x1EE0},
    {0x1EE0, 0x1EE1, 0x1EE1},
    {0x1EE3, 0x1EE2, 0x1EE2},
    {0x1EE2, 0x1EE3, 0x1EE3},
    {0x1EE5, 0x1EE4, 0x1EE4},
    {0x1EE4, 0x1EE5, 0x1EE5},
    {0x1EE7, 0x1EE6, 0x1EE6},
    {0x1EE6, 0x1EE7, 0x1EE7},
    {0x1EE9, 0x1EE8, 0x1EE8},
    {0x1EE8, 0x1EE9, 0x1EE9},
    {0x1EEB, 0x1EEA, 0x1EEA},
    {0x1EEA, 0x1EEB, 0x1EEB},
    {0x1EED, 0x1EEC, 0x1EEC},
    {0x1EEC, 0x1EED, 0x1EED},
    {0x1EEF, 0x1EEE, 0x1EEE},
    {0x1EEE, 0x1EEF, 0x1EEF},
    {0x1EF1, 0x1EF0, 0x1EF0},
    {0x1EF0, 0x1EF1, 0x1EF1},
    {0x1EF3, 0x1EF2, 0x1EF2},
    {0x1EF2, 0x1EF3, 0x1EF3},
    {0x1EF5, 0x1EF4, 0x1EF4},
    {0x1EF4, 0x1EF5, 0x1EF5},
    {0x1EF7, 0x1EF6, 0x1EF6},
    {0x1EF6, 0x1EF7, 0x1EF7},
    {0x1EF9, 0x1EF8, 0x1EF8},
    {0x1EF8, 0x1EF9, 0x1EF9},
    {0x1EFB, 0x1EFA, 0x1EFA},
    {0x1EFA, 0x1EFB, 0x1EFB},
    {0x1EFD, 0x1EFC, 0x1EFC},
    {0x1EFC, 0x1EFD, 0x1EFD},
    {0x1EFF, 0x1EFE, 0x1EFE},
    {0x1EFE, 0x1EFF, 0x1EFF},
    {0x1F08, 0x1F00, 0x1F00},
    {0x1F09, 0x1F01, 0x1F01},
    {0x1F0A, 0x1F02, 0x1F02},
    {0x1F0B, 0x1F03, 0x1F03},
    {0x1F0C, 0x1F04, 0x1F04},
    {0x1F0D, 0x1F05, 0x1F05},
    {0x1F0E, 0x1F06, 0x1F06},
    {0x1F0F, 0x1F07, 0x1F07},
    {0x1F00, 0x1F08, 0x1F08},
    {0x1F01, 0x1F09, 0x1F09},
    {0x1F02, 0x1F0A, 0x1F0A},
    {0x1F03, 0x1F0B, 0x1F0B},
    {0x1F04, 0x1F0C, 0x1F0C},
    {0x1F05, 0x1F0D, 0x1F0D},
    {0x1F06, 0x1F0E, 0x1F0E},
    {0x1F07, 0x1F0F, 0x1F0F},
    {0x1F18, 0x1F10, 0x1F10},
    {0x1F19, 0x1F11, 0x1F11},
    {0x1F1A, 0x1F12, 0x1F12},
    {0x1F1B, 0x1F13, 0x1F13},
    {0x1F1C, 0x1F14, 0x1F14},
    {0x1F1D, 0x1F15, 0x1F15},
    {0x1F10, 0x1F18, 0x1F18},
    {0x1F11, 0x1F19, 0x1F19},
    {0x1F12, 0x1F1A, 0x1F1A},
    {0x1F13, 0x1F1B, 0x1F1B},
    {0x1F14, 0x1F1C, 0x1F1C},
    {0x1F15, 0x1F1D, 0x1F1D},
    {0x1F28, 0x1F20, 0x1F20},
    {0x1F29, 0x1F21, 0x1F21},
    {0x1F2A, 0x1F22, 0x1F22},
    {0x1F2B, 0x1F23, 0x1F23},
    {0x1F2C, 0x1F24, 0x1F24},
    {0x1F2D, 0x1F25, 0x1F25},
    {0x1F2E, 0x1F26, 0x1F26},
    {0x1F2F, 0x1F27, 0x1F27},
    {0x1F20, 0x1F28, 0x1F28},
    {0x1F21, 0x1F29, 0x1F29},
    {0x1F22, 0x1F2A, 0x1F2A},
    {0x1F23, 0x1F2B, 0x1F2B},
    {0x1F24, 0x1F2C, 0x1F2C},
    {0x1F25, 0x1F2D, 0x1F2D},
    {0x1F26, 0x1F2E, 0x1F2E},
    {0x1F27, 0x1F2F, 0x1F2F},
    {0x1F38, 0x1F30, 0x1F30},
    {0x1F39, 0x1F31, 0x1F31},
    {0x1F3A, 0x1F32, 0x1F32},
    {0x1F3B, 0x1F33, 0x1F33},
    {0x1F3C, 0x1F34, 0x1F34},
    {0x1F3D, 0x1F35, 0x1F35},
    {0x1F3E, 0x1F36, 0x1F36},
    {0x1F3F, 0x1F37, 0x1F37},
    {0x1F30, 0x1F38, 0x1F38},
    {0x1F31, 0x1F39, 0x1F39},
    {0x1F32, 0x1F3A, 0x1F3A},
    {0x1F33, 0x1F3B, 0x1F3B},
    {0x1F34, 0x1F3C, 0x1F3C},
    {0x1F35, 0x1F3D, 0x1F3D},
    {0x1F36, 0x1F3E, 0x1F3E},
    {0x1F37, 0x1F3F, 0x1F3F},
    {0x1F48, 0x1F40, 0x1F40},
    {0x1F49, 0x1F41, 0x1F41},
    {0x1F4A, 0x1F42, 0x1F42},
    {0x1F4B, 0x1F43, 0x1F43},
    {0x1F4C, 0x1F44, 0x1F44},
    {0x1F4D, 0x1F45, 0x1F45},
    {0x1F40, 0x1F48, 0x1F48},
    {0x1F41, 0x1F49, 0x1F49},
    {0x1F42, 0x1F4A, 0x1F4A},
    {0x1F43, 0x1F4B, 0x1F4B},
    {0x1F44, 0x1F4C, 0x1F4C},
    {0x1F45, 0x1F4D, 0x1F4D},
    {0x1F59, 0x1F51, 0x1F51},
    {0x1F5B, 0x1F53, 0x1F53},
    {0x1F5D, 0x1F55, 0x1F55},
    {0x1F5F, 0x1F57, 0x1F57},
    {0x1F51, 0x1F59, 0x1F59},
    {0x1F53, 0x1F5B, 0x1F5B},
    {0x1F55, 0x1F5D, 0x1F5D},
    {0x1F57, 0x1F5F, 0x1F5F},
    {0x1F68, 0x1F60, 0x1F60},
    {0x1F69, 0x1F61, 0x1F61},
    {0x1F6A, 0x1F62, 0x1F62},
    {0x1F6B, 0x1F63, 0x1F63},
    {0x1F6C, 0x1F64, 0x1F64},
    {0x1F6D, 0x1F65, 0x1F65},
    {0x1F6E, 0x1F66, 0x1F66},
    {0x1F6F, 0x1F67, 0x1F67},
    {0x1F60, 0x1F68, 0x1F68},
    {0x1F61, 0x1F69, 0x1F69},
    {0x1F62, 0x1F6A, 0x1F6A},
    {0x1F63, 0x1F6B, 0x1F6B},
    {0x1F64, 0x1F6C, 0x1F6C},
    {0x1F65, 0x1F6D, 0x1F6D},
    {0x1F66, 0x1F6E, 0x1F6E},
    {0x1F67, 0x1F6F, 0x1F6F},
    {0x1FBA, 0x1F70, 0x1F70},
    {0x1FBB, 0x1F71, 0x1F71},
    {0x1FC8, 0x1F72, 0x1F72},
    {0x1FC9, 0x1F73, 0x1F73},
    {0x1FCA, 0x1F74, 0x1F74},
    {0x1FCB, 0x1F75, 0x1F75},
    {0x1FDA, 0x1F76, 0x1F76},
    {0x1FDB, 0x1F77, 0x1F77},
    {0x1FF8, 0x1F78, 0x1F78},
    {0x1FF9, 0x1F79, 0x1F79},
    {0x1FEA, 0x1F7A, 0x1F7A},
    {0x1FEB, 0x1F7B, 0x1F7B},
    {0x1FFA, 0x1F7C, 0x1F7C},
    {0x1FFB, 0x1F7D, 0x1F7D},
    {0x1F88, 0x1F80, 0x1F80},
    {0x1F89, 0x1F81, 0x1F81},
    {0x1F8A, 0x1F82, 0x1F82},
    {0x1F8B, 0x1F83, 0x1F83},
    {0x1F8C, 0x1F84, 0x1F84},
    {0x1F8D, 0x1F85, 0x1F85},
    {0x1F8E, 0x1F86, 0x1F86},
    {0x1F8F, 0x1F87, 0x1F87},
    {0x1F80, 0x1F88, 0x1F88},
    {0x1F81, 0x1F89, 0x1F89},
    {0x1F82, 0x1F8A, 0x1F8A},
    {0x1F83, 0x1F8B, 0x1F8B},
    {0x1F84, 0x1F8C, 0x1F8C},
    {0x1F85, 0x1F8D, 0x1F8D},
    {0x1F86, 0x1F8E, 0x1F8E},
    {0x1F87, 0x1F8F, 0x1F8F},
    {0x1F98, 0x1F90, 0x1F90},
    {0x1F99, 0x1F91, 0x1F91},
    {0x1F9A, 0x1F92, 0x1F92},
    {0x1F9B, 0x1F93, 0x1F93},
    {0x1F9C, 0x1F94, 0x1F94},
    {0x1F9D, 0x1F95, 0x1F95},
    {0x1F9E, 0x1F96, 0x1F96},
    {0x1F9F, 0x1F97, 0x1F97},
    {0x1F90, 0x1F98, 0x1F98},
    {0x1F91, 0x1F99, 0x1F99},
    {0x1F92, 0x1F9A, 0x1F9A},
    {0x1F93, 0x1F9B, 0x1F9B},
    {0x1F94, 0x1F9C, 0x1F9C},
    {0x1F95, 0x1F9D, 0x1F9D},
    {0x1F96, 0x1F9E, 0x1F9E},
    {0x1F97, 0x1F9F, 0x1F9F},
    {0x1FA8, 0x1FA0, 0x1FA0},
    {0x1FA9, 0x1FA1, 0x1FA1},
    {0x1FAA, 0x1FA2, 0x1FA2},
    {0x1FAB, 0x1FA3, 0x1FA3},
    {0x1FAC, 0x1FA4, 0x1FA4},
    {0x1FAD, 0x1FA5, 0x1FA5},
    {0x1FAE, 0x1FA6, 0x1FA6},
    {0x1FAF, 0x1FA7, 0x1FA7},
    {0x1FA0, 0x1FA8, 0x1FA8},
    {0x1FA1, 0x1FA9, 0x1FA9},
    {0x1FA2, 0x1FAA, 0x1FAA},
    {0x1FA3, 0x1FAB, 0x1FAB},
    {0x1FA4, 0x1FAC, 0x1FAC},
    {0x1FA5, 0x1FAD, 0x1FAD},
    {0x1FA6, 0x1FAE, 0x1FAE},
    {0x1FA7, 0x1FAF, 0x1FAF},
    {0x1FB8, 0x1FB0, 0x1FB0},
    {0x1FB9, 0x1FB1, 0x1FB1},
    {0x1FBC, 0x1FB3, 0x1FB3},
    {0x1FB0, 0x1FB8, 0x1FB8},
    {0x1FB1, 0x1FB9, 0x1FB9},
    {0x1F70, 0x1FBA, 0x1FBA},
    {0x1F71, 0x1FBB, 0x1FBB},
    {0x1FB3, 0x1FBC, 0x1FBC},
    {0x399, 0x1FBE, 0x1FBE},
    {0x1FCC, 0x1FC3, 0x1FC3},
    {0x1F72, 0x1FC8, 0x1FC8},
    {0x1F73, 0x1FC9, 0x1FC9},
    {0x1F74, 0x1FCA, 0x1FCA},
    {0x1F75, 0x1FCB, 0x1FCB},
    {0x1FC3, 0x1FCC, 0x1FCC},
    {0x1FD8, 0x1FD0, 0x1FD0},
    {0x1FD9, 0x1FD1, 0x1FD1},
    {0x1FD0, 0x1FD8, 0x1FD8},
    {0x1FD1, 0x1FD9, 0x1FD9},
    {0x1F76, 0x1FDA, 0x1FDA},
    {0x1F77, 0x1FDB, 0x1FDB},
    {0x1FE8, 0x1FE0, 0x1FE0},
    {0x1FE9, 0x1FE1, 0x1FE1},
    {0x1FEC, 0x1FE5, 0x1FE5},
    {0x1FE0, 0x1FE8, 0x1FE8},
    {0x1FE1, 0x1FE9, 0x1FE9},
    {0x1F7A, 0x1FEA, 0x1FEA},
    {0x1F7B, 0x1FEB, 0x1FEB},
    {0x1FE5, 0x1FEC, 0x1FEC},
    {0x1FFC, 0x1FF3, 0x1FF3},
    {0x1F78, 0x1FF8, 0x1FF8},
    {0x1F79, 0x1FF9, 0x1FF9},
    {0x1F7C, 0x1FFA, 0x1FFA},
    {0x1F7D, 0x1FFB, 0x1FFB},
    {0x1FF3, 0x1FFC, 0x1FFC},
    {0x3C9, 0x2126, 0x2126},
    {0x6B, 0x212A, 0x212A},
    {0xE5, 0x212B, 0x212B},
    {0x214E, 0x2132, 0x2132},
    {0x2132, 0x214E, 0x214E},
    {0x2170, 0x2160, 0x2160},
    {0x2171, 0x2161, 0x2161},
    {0x2172, 0x2162, 0x2162},
    {0x2173, 0x2163, 0x2163},
    {0x2174, 0x2164, 0x2164},
    {0x2175, 0x2165, 0x2165},
    {0x2176, 0x2166, 0x2166},
    {0x2177, 0x2167, 0x2167},
    {0x2178, 0x2168, 0x2168},
    {0x2179, 0x2169, 0x2169},
    {0x217A, 0x216A, 0x216A},
    {0x217B, 0x216B, 0x216B},
    {0x217C, 0x216C, 0x216C},
    {0x217D, 0x216D, 0x216D},
    {0x217E, 0x216E, 0x216E},
    {0x217F, 0x216F, 0x216F},
    {0x2160, 0x2170, 0x2170},
    {0x2161, 0x2171, 0x2171},
    {0x2162, 0x2172, 0x2172},
    {0x2163, 0x2173, 0x2173},
    {0x2164, 0x2174, 0x2174},
    {0x2165, 0x2175, 0x2175},
    {0x2166, 0x2176, 0x2176},
    {0x2167, 0x2177, 0x2177},
    {0x2168, 0x2178, 0x2178},
    {0x2169, 0x2179, 0x2179},
    {0x216A, 0x217A, 0x217A},
    {0x216B, 0x217B, 0x217B},
    {0x216C, 0x217C, 0x217C},
    {0x216D, 0x217D, 0x217D},
    {0x216E, 0x217E, 0x217E},
    {0x216F, 0x217F, 0x217F},
    {0x2184, 0x2183, 0x2183},
    {0x2183, 0x2184, 0x2184},
    {0x24D0, 0x24B6, 0x24B6},
    {0x24D1, 0x24B7, 0x24B7},
    {0x24D2, 0x24B8, 0x24B8},
    {0x24D3, 0x24B9, 0x24B9},
    {0x24D4, 0x24BA, 0x24BA},
    {0x24D5, 0x24BB, 0x24BB},
    {0x24D6, 0x24BC, 0x24BC},
    {0x24D7, 0x24BD, 0x24BD},
    {0x24D8, 0x24BE, 0x24BE},
    {0x24D9, 0x24BF, 0x24BF},
    {0x24DA, 0x24C0, 0x24C0},
    {0x24DB, 0x24C1, 0x24C1},
    {0x24DC, 0x24C2, 0x24C2},
    {0x24DD, 0x24C3, 0x24C3},
    {0x24DE, 0x24C4, 0x24C4},
    {0x24DF, 0x24C5, 0x24C5},
    {0x24E0, 0x24C6, 0x24C6},
    {0x24E1, 0x24C7, 0x24C7},
    {0x24E2, 0x24C8, 0x24C8},
    {0x24E3, 0x24C9, 0x24C9},
    {0x24E4, 0x24CA, 0x24CA},
    {0x24E5, 0x24CB, 0x24CB},
    {0x24E6, 0x24CC, 0x24CC},
    {0x24E7, 0x24CD, 0x24CD},
    {0x24E8, 0x24CE, 0x24CE},
    {0x24E9, 0x24CF, 0x24CF},
    {0x24B6, 0x24D0, 0x24D0},
    {0x24B7, 0x24D1, 0x24D1},
    {0x24B8, 0x24D2, 0x24D2},
    {0x24B9, 0x24D3, 0x24D3},
    {0x24BA, 0x24D4, 0x24D4},
    {0x24BB, 0x24D5, 0x24D5},
    {0x24BC, 0x24D6, 0x24D6},
    {0x24BD, 0x24D7, 0x24D7},
    {0x24BE, 0x24D8, 0x24D8},
    {0x24BF, 0x24D9, 0x24D9},
    {0x24C0, 0x24DA, 0x24DA},
    {0x24C1, 0x24DB, 0x24DB},
    {0x24C2, 0x24DC, 0x24DC},
    {0x24C3, 0x24DD, 0x24DD},
    {0x24C4, 0x24DE, 0x24DE},
    {0x24C5, 0x24DF, 0x24DF},
    {0x24C6, 0x24E0, 0x24E0},
    {0x24C7, 0x24E1, 0x24E1},
    {0x24C8, 0x24E2, 0x24E2},
    {0x24C9, 0x24E3, 0x24E3},
    {0x24CA, 0x24E4, 0x24E4},
    {0x24CB, 0x24E5, 0x24E5},
    {0x24CC, 0x24E6, 0x24E6},
    {0x24CD, 0x24E7, 0x24E7},
    {0x24CE, 0x24E8, 0x24E8},
    {0x24CF, 0x24E9, 0x24E9},
    {0x2C30, 0x2C00, 0x2C00},
    {0x2C31, 0x2C01, 0x2C01},
    {0x2C32, 0x2C02, 0x2C02},
    {0x2C33, 0x2C03, 0x2C03},
    {0x2C34, 0x2C04, 0x2C04},
    {0x2C35, 0x2C05, 0x2C05},
    {0x2C36, 0x2C06, 0x2C06},
    {0x2C37, 0x2C07, 0x2C07},
    {0x2C38, 0x2C08, 0x2C08},
    {0x2C39, 0x2C09, 0x2C09},
    {0x2C3A, 0x2C0A, 0x2C0A},
    {0x2C3B, 0x2C0B, 0x2C0B},
    {0x2C3C, 0x2C0C, 0x2C0C},
    {0x2C3D, 0x2C0D, 0x2C0D},
    {0x2C3E, 0x2C0E, 0x2C0E},
    {0x2C3F, 0x2C0F, 0x2C0F},
    {0x2C40, 0x2C10, 0x2C10},
    {0x2C41, 0x2C11, 0x2C11},
    {0x2C42, 0x2C12, 0x2C12},
    {0x2C43, 0x2C13, 0x2C13},
    {0x2C44, 0x2C14, 0x2C14},
    {0x2C45, 0x2C15, 0x2C15},
    {0x2C46, 0x2C16, 0x2C16},
    {0x2C47, 0x2C17, 0x2C17},
    {0x2C48, 0x2C18, 0x2C18},
    {0x2C49, 0x2C19, 0x2C19},
    {0x2C4A, 0x2C1A, 0x2C1A},
    {0x2C4B, 0x2C1B, 0x2C1B},
    {0x2C4C, 0x2C1C, 0x2C1C},
    {0x2C4D, 0x2C1D, 0x2C1D},
    {0x2C4E, 0x2C1E, 0x2C1E},
    {0x2C4F, 0x2C1F, 0x2C1F},
    {0x2C50, 0x2C20, 0x2C20},
    {0x2C51, 0x2C21, 0x2C21},
    {0x2C52, 0x2C22, 0x2C22},
    {0x2C53, 0x2C23, 0x2C23},
    {0x2C54, 0x2C24, 0x2C24},
    {0x2C55, 0x2C25, 0x2C25},
    {0x2C56, 0x2C26, 0x2C26},
    {0x2C57, 0x2C27, 0x2C27},
    {0x2C58, 0x2C28, 0x2C28},
    {0x2C59, 0x2C29, 0x2C29},
    {0x2C5A, 0x2C2A, 0x2C2A},
    {0x2C5B, 0x2C2B, 0x2C2B},
    {0x2C5C, 0x2C2C, 0x2C2C},
    {0x2C5D, 0x2C2D, 0x2C2D},
    {0x2C5E, 0x2C2E, 0x2C2E},
    {0x2C00, 0x2C30, 0x2C30},
    {0x2C01, 0x2C31, 0x2C31},
    {0x2C02, 0x2C32, 0x2C32},
    {0x2C03, 0x2C33, 0x2C33},
    {0x2C04, 0x2C34, 0x2C34},
    {0x2C05, 0x2C35, 0x2C35},
    {0x2C06, 0x2C36, 0x2C36},
    {0x2C07, 0x2C37, 0x2C37},
    {0x2C08, 0x2C38, 0x2C38},
    {0x2C09, 0x2C39, 0x2C39},
    {0x2C0A, 0x2C3A, 0x2C3A},
    {0x2C0B, 0x2C3B, 0x2C3B},
    {0x2C0C, 0x2C3C, 0x2C3C},
    {0x2C0D, 0x2C3D, 0x2C3D},
    {0x2C0E, 0x2C3E, 0x2C3E},
    {0x2C0F, 0x2C3F, 0x2C3F},
    {0x2C10, 0x2C40, 0x2C40},
    {0x2C11, 0x2C41, 0x2C41},
    {0x2C12, 0x2C42, 0x2C42},
    {0x2C13, 0x2C43, 0x2C43},
    {0x2C14, 0x2C44, 0x2C44},
    {0x2C15, 0x2C45, 0x2C45},
    {0x2C16, 0x2C46, 0x2C46},
    {0x2C17, 0x2C47, 0x2C47},
    {0x2C18, 0x2C48, 0x2C48},
    {0x2C19, 0x2C49, 0x2C49},
    {0x2C1A, 0x2C4A, 0x2C4A},
    {0x2C1B, 0x2C4B, 0x2C4B},
    {0x2C1C, 0x2C4C, 0x2C4C},
    {0x2C1D, 0x2C4D, 0x2C4D},
    {0x2C1E, 0x2C4E, 0x2C4E},
    {0x2C1F, 0x2C4F, 0x2C4F},
    {0x2C20, 0x2C50, 0x2C50},
    {0x2C21, 0x2C51, 0x2C51},
    {0x2C22, 0x2C52, 0x2C52},
    {0x2C23, 0x2C53, 0x2C53},
    {0x2C24, 0x2C54, 0x2C54},
    {0x2C25, 0x2C55, 0x2C55},
    {0x2C26, 0x2C56, 0x2C56},
    {0x2C27, 0x2C57, 0x2C57},
    {0x2C28, 0x2C58, 0x2C58},
    {0x2C29, 0x2C59, 0x2C59},
    {0x2C2A, 0x2C5A, 0x2C5A},
    {0x2C2B, 0x2C5B, 0x2C5B},
    {0x2C2C, 0x2C5C, 0x2C5C},
    {0x2C2D, 0x2C5D, 0x2C5D},
    {0x2C2E, 0x2C5E, 0x2C5E},
    {0x2C61, 0x2C60, 0x2C60},
    {0x2C60, 0x2C61, 0x2C61},
    {0x26B, 0x2C62, 0x2C62},
    {0x1D7D, 0x2C63, 0x2C63},
    {0x27D, 0x2C64, 0x2C64},
    {0x23A, 0x2C65, 0x2C65},
    {0x23E, 0x2C66, 0x2C66},
    {0x2C68, 0x2C67, 0x2C67},
    {0x2C67, 0x2C68, 0x2C68},
    {0x2C6A, 0x2C69, 0x2C69},
    {0x2C69, 0x2C6A, 0x2C6A},
    {0x2C6C, 0x2C6B, 0x2C6B},
    {0x2C6B, 0x2C6C, 0x2C6C},
    {0x251, 0x2C6D, 0x2C6D},
    {0x271, 0x2C6E, 0x2C6E},
    {0x250, 0x2C6F, 0x2C6F},
    {0x252, 0x2C70, 0x2C70},
    {0x2C73, 0x2C72, 0x2C72},
    {0x2C72, 0x2C73, 0x2C73},
    {0x2C76, 0x2C75, 0x2C75},
    {0x2C75, 0x2C76, 0x2C76},
    {0x23F, 0x2C7E, 0x2C7E},
    {0x240, 0x2C7F, 0x2C7F},
    {0x2C81, 0x2C80, 0x2C80},
    {0x2C80, 0x2C81, 0x2C81},
    {0x2C83, 0x2C82, 0x2C82},
    {0x2C82, 0x2C83, 0x2C83},
    {0x2C85, 0x2C84, 0x2C84},
    {0x2C84, 0x2C85, 0x2C85},
    {0x2C87, 0x2C86, 0x2C86},
    {0x2C86, 0x2C87, 0x2C87},
    {0x2C89, 0x2C88, 0x2C88},
    {0x2C88, 0x2C89, 0x2C89},
    {0x2C8B, 0x2C8A, 0x2C8A},
    {0x2C8A, 0x2C8B, 0x2C8B},
    {0x2C8D, 0x2C8C, 0x2C8C},
    {0x2C8C, 0x2C8D, 0x2C8D},
    {0x2C8F, 0x2C8E, 0x2C8E},
    {0x2C8E, 0x2C8F, 0x2C8F},
    {0x2C91, 0x2C90, 0x2C90},
    {0x2C90, 0x2C91, 0x2C91},
    {0x2C93, 0x2C92, 0x2C92},
    {0x2C92, 0x2C93, 0x2C93},
    {0x2C95, 0x2C94, 0x2C94},
    {0x2C94, 0x2C95, 0x2C95},
    {0x2C97, 0x2C96, 0x2C96},
    {0x2C96, 0x2C97, 0x2C97},
    {0x2C99, 0x2C98, 0x2C98},
    {0x2C98, 0x2C99, 0x2C99},
    {0x2C9B, 0x2C9A, 0x2C9A},
    {0x2C9A, 0x2C9B, 0x2C9B},
    {0x2C9D, 0x2C9C, 0x2C9C},
    {0x2C9C, 0x2C9D, 0x2C9D},
    {0x2C9F, 0x2C9E, 0x2C9E},
    {0x2C9E, 0x2C9F, 0x2C9F},
    {0x2CA1, 0x2CA0, 0x2CA0},
    {0x2CA0, 0x2CA1, 0x2CA1},
    {0x2CA3, 0x2CA2, 0x2CA2},
    {0x2CA2, 0x2CA3, 0x2CA3},
    {0x2CA5, 0x2CA4, 0x2CA4},
    {0x2CA4, 0x2CA5, 0x2CA5},
    {0x2CA7, 0x2CA6, 0x2CA6},
    {0x2CA6, 0x2CA7, 0x2CA7},
    {0x2CA9, 0x2CA8, 0x2CA8},
    {0x2CA8, 0x2CA9, 0x2CA9},
    {0x2CAB, 0x2CAA, 0x2CAA},
    {0x2CAA, 0x2CAB, 0x2CAB},
    {0x2CAD, 0x2CAC, 0x2CAC},
    {0x2CAC, 0x2CAD, 0x2CAD},
    {0x2CAF, 0x2CAE, 0x2CAE},
    {0x2CAE, 0x2CAF, 0x2CAF},
    {0x2CB1, 0x2CB0, 0x2CB0},
    {0x2CB0, 0x2CB1, 0x2CB1},
    {0x2CB3, 0x2CB2, 0x2CB2},
    {0x2CB2, 0x2CB3, 0x2CB3},
    {0x2CB5, 0x2CB4, 0x2CB4},
    {0x2CB4, 0x2CB5, 0x2CB5},
    {0x2CB7, 0x2CB6, 0x2CB6},
    {0x2CB6, 0x2CB7, 0x2CB7},
    {0x2CB9, 0x2CB8, 0x2CB8},
    {0x2CB8, 0x2CB9, 0x2CB9},
    {0x2CBB, 0x2CBA, 0x2CBA},
    {0x2CBA, 0x2CBB, 0x2CBB},
    {0x2CBD, 0x2CBC, 0x2CBC},
    {0x2CBC, 0x2CBD, 0x2CBD},
    {0x2CBF, 0x2CBE, 0x2CBE},
    {0x2CBE, 0x2CBF, 0x2CBF},
    {0x2CC1, 0x2CC0, 0x2CC0},
    {0x2CC0, 0x2CC1, 0x2CC1},
    {0x2CC3, 0x2CC2, 0x2CC2},
    {0x2CC2, 0x2CC3, 0x2CC3},
    {0x2CC5, 0x2CC4, 0x2CC4},
    {0x2CC4, 0x2CC5, 0x2CC5},
    {0x2CC7, 0x2CC6, 0x2CC6},
    {0x2CC6, 0x2CC7, 0x2CC7},
    {0x2CC9, 0x2CC8, 0x2CC8},
    {0x2CC8, 0x2CC9, 0x2CC9},
    {0x2CCB, 0x2CCA, 0x2CCA},
    {0x2CCA, 0x2CCB, 0x2CCB},
    {0x2CCD, 0x2CCC, 0x2CCC},
    {0x2CCC, 0x2CCD, 0x2CCD},
    {0x2CCF, 0x2CCE, 0x2CCE},
    {0x2CCE, 0x2CCF, 0x2CCF},
    {0x2CD1, 0x2CD0, 0x2CD0},
    {0x2CD0, 0x2CD1, 0x2CD1},
    {0x2CD3, 0x2CD2, 0x2CD2},
    {0x2CD2, 0x2CD3, 0x2CD3},
    {0x2CD5, 0x2CD4, 0x2CD4},
    {0x2CD4, 0x2CD5, 0x2CD5},
    {0x2CD7, 0x2CD6, 0x2CD6},
    {0x2CD6, 0x2CD7, 0x2CD7},
    {0x2CD9, 0x2CD8, 0x2CD8},
    {0x2CD8, 0x2CD9, 0x2CD9},
    {0x2CDB, 0x2CDA, 0x2CDA},
    {0x2CDA, 0x2CDB, 0x2CDB},
    {0x2CDD, 0x2CDC, 0x2CDC},
    {0x2CDC, 0x2CDD, 0x2CDD},
    {0x2CDF, 0x2CDE, 0x2CDE},
    {0x2CDE, 0x2CDF, 0x2CDF},
    {0x2CE1, 0x2CE0, 0x2CE0},
    {0x2CE0, 0x2CE1, 0x2CE1},
    {0x2CE3, 0x2CE2, 0x2CE2},
    {0x2CE2, 0x2CE3, 0x2CE3},
    {0x2CEC, 0x2CEB, 0x2CEB},
    {0x2CEB, 0x2CEC, 0x2CEC},
    {0x2CEE, 0x2CED, 0x2CED},
    {0x2CED, 0x2CEE, 0x2CEE},
    {0x10A0, 0x2D00, 0x2D00},
    {0x10A1, 0x2D01, 0x2D01},
    {0x10A2, 0x2D02, 0x2D02},
    {0x10A3, 0x2D03, 0x2D03},
    {0x10A4, 0x2D04, 0x2D04},
    {0x10A5, 0x2D05, 0x2D05},
    {0x10A6, 0x2D06, 0x2D06},
    {0x10A7, 0x2D07, 0x2D07},
    {0x10A8, 0x2D08, 0x2D08},
    {0x10A9, 0x2D09, 0x2D09},
    {0x10AA, 0x2D0A, 0x2D0A},
    {0x10AB, 0x2D0B, 0x2D0B},
    {0x10AC, 0x2D0C, 0x2D0C},
    {0x10AD, 0x2D0D, 0x2D0D},
    {0x10AE, 0x2D0E, 0x2D0E},
    {0x10AF, 0x2D0F, 0x2D0F},
    {0x10B0, 0x2D10, 0x2D10},
    {0x10B1, 0x2D11, 0x2D11},
    {0x10B2, 0x2D12, 0x2D12},
    {0x10B3, 0x2D13, 0x2D13},
    {0x10B4, 0x2D14, 0x2D14},
    {0x10B5, 0x2D15, 0x2D15},
    {0x10B6, 0x2D16, 0x2D16},
    {0x10B7, 0x2D17, 0x2D17},
    {0x10B8, 0x2D18, 0x2D18},
    {0x10B9, 0x2D19, 0x2D19},
    {0x10BA, 0x2D1A, 0x2D1A},
    {0x10BB, 0x2D1B, 0x2D1B},
    {0x10BC, 0x2D1C, 0x2D1C},
    {0x10BD, 0x2D1D, 0x2D1D},
    {0x10BE, 0x2D1E, 0x2D1E},
    {0x10BF, 0x2D1F, 0x2D1F},
    {0x10C0, 0x2D20, 0x2D20},
    {0x10C1, 0x2D21, 0x2D21},
    {0x10C2, 0x2D22, 0x2D22},
    {0x10C3, 0x2D23, 0x2D23},
    {0x10C4, 0x2D24, 0x2D24},
    {0x10C5, 0x2D25, 0x2D25},
    {0xA641, 0xA640, 0xA640},
    {0xA640, 0xA641, 0xA641},
    {0xA643, 0xA642, 0xA642},
    {0xA642, 0xA643, 0xA643},
    {0xA645, 0xA644, 0xA644},
    {0xA644, 0xA645, 0xA645},
    {0xA647, 0xA646, 0xA646},
    {0xA646, 0xA647, 0xA647},
    {0xA649, 0xA648, 0xA648},
    {0xA648, 0xA649, 0xA649},
    {0xA64B, 0xA64A, 0xA64A},
    {0xA64A, 0xA64B, 0xA64B},
    {0xA64D, 0xA64C, 0xA64C},
    {0xA64C, 0xA64D, 0xA64D},
    {0xA64F, 0xA64E, 0xA64E},
    {0xA64E, 0xA64F, 0xA64F},
    {0xA651, 0xA650, 0xA650},
    {0xA650, 0xA651, 0xA651},
    {0xA653, 0xA652, 0xA652},
    {0xA652, 0xA653, 0xA653},
    {0xA655, 0xA654, 0xA654},
    {0xA654, 0xA655, 0xA655},
    {0xA657, 0xA656, 0xA656},
    {0xA656, 0xA657, 0xA657},
    {0xA659, 0xA658, 0xA658},
    {0xA658, 0xA659, 0xA659},
    {0xA65B, 0xA65A, 0xA65A},
    {0xA65A, 0xA65B, 0xA65B},
    {0xA65D, 0xA65C, 0xA65C},
    {0xA65C, 0xA65D, 0xA65D},
    {0xA65F, 0xA65E, 0xA65E},
    {0xA65E, 0xA65F, 0xA65F},
    {0xA661, 0xA660, 0xA660},
    {0xA660, 0xA661, 0xA661},
    {0xA663, 0xA662, 0xA662},
    {0xA662, 0xA663, 0xA663},
    {0xA665, 0xA664, 0xA664},
    {0xA664, 0xA665, 0xA665},
    {0xA667, 0xA666, 0xA666},
    {0xA666, 0xA667, 0xA667},
    {0xA669, 0xA668, 0xA668},
    {0xA668, 0xA669, 0xA669},
    {0xA66B, 0xA66A, 0xA66A},
    {0xA66A, 0xA66B, 0xA66B},
    {0xA66D, 0xA66C, 0xA66C},
    {0xA66C, 0xA66D, 0xA66D},
    {0xA681, 0xA680, 0xA680},
    {0xA680, 0xA681, 0xA681},
    {0xA683, 0xA682, 0xA682},
    {0xA682, 0xA683, 0xA683},
    {0xA685, 0xA684, 0xA684},
    {0xA684, 0xA685, 0xA685},
    {0xA687, 0xA686, 0xA686},
    {0xA686, 0xA687, 0xA687},
    {0xA689, 0xA688, 0xA688},
    {0xA688, 0xA689, 0xA689},
    {0xA68B, 0xA68A, 0xA68A},
    {0xA68A, 0xA68B, 0xA68B},
    {0xA68D, 0xA68C, 0xA68C},
    {0xA68C, 0xA68D, 0xA68D},
    {0xA68F, 0xA68E, 0xA68E},
    {0xA68E, 0xA68F, 0xA68F},
    {0xA691, 0xA690, 0xA690},
    {0xA690, 0xA691, 0xA691},
    {0xA693, 0xA692, 0xA692},
    {0xA692, 0xA693, 0xA693},
    {0xA695, 0xA694, 0xA694},
    {0xA694, 0xA695, 0xA695},
    {0xA697, 0xA696, 0xA696},
    {0xA696, 0xA697, 0xA697},
    {0xA723, 0xA722, 0xA722},
    {0xA722, 0xA723, 0xA723},
    {0xA725, 0xA724, 0xA724},
    {0xA724, 0xA725, 0xA725},
    {0xA727, 0xA726, 0xA726},
    {0xA726, 0xA727, 0xA727},
    {0xA729, 0xA728, 0xA728},
    {0xA728, 0xA729, 0xA729},
    {0xA72B, 0xA72A, 0xA72A},
    {0xA72A, 0xA72B, 0xA72B},
    {0xA72D, 0xA72C, 0xA72C},
    {0xA72C, 0xA72D, 0xA72D},
    {0xA72F, 0xA72E, 0xA72E},
    {0xA72E, 0xA72F, 0xA72F},
    {0xA733, 0xA732, 0xA732},
    {0xA732, 0xA733, 0xA733},
    {0xA735, 0xA734, 0xA734},
    {0xA734, 0xA735, 0xA735},
    {0xA737, 0xA736, 0xA736},
    {0xA736, 0xA737, 0xA737},
    {0xA739, 0xA738, 0xA738},
    {0xA738, 0xA739, 0xA739},
    {0xA73B, 0xA73A, 0xA73A},
    {0xA73A, 0xA73B, 0xA73B},
    {0xA73D, 0xA73C, 0xA73C},
    {0xA73C, 0xA73D, 0xA73D},
    {0xA73F, 0xA73E, 0xA73E},
    {0xA73E, 0xA73F, 0xA73F},
    {0xA741, 0xA740, 0xA740},
    {0xA740, 0xA741, 0xA741},
    {0xA743, 0xA742, 0xA742},
    {0xA742, 0xA743, 0xA743},
    {0xA745, 0xA744, 0xA744},
    {0xA744, 0xA745, 0xA745},
    {0xA747, 0xA746, 0xA746},
    {0xA746, 0xA747, 0xA747},
    {0xA749, 0xA748, 0xA748},
    {0xA748, 0xA749, 0xA749},
    {0xA74B, 0xA74A, 0xA74A},
    {0xA74A, 0xA74B, 0xA74B},
    {0xA74D, 0xA74C, 0xA74C},
    {0xA74C, 0xA74D, 0xA74D},
    {0xA74F, 0xA74E, 0xA74E},
    {0xA74E, 0xA74F, 0xA74F},
    {0xA751, 0xA750, 0xA750},
    {0xA750, 0xA751, 0xA751},
    {0xA753, 0xA752, 0xA752},
    {0xA752, 0xA753, 0xA753},
    {0xA755, 0xA754, 0xA754},
    {0xA754, 0xA755, 0xA755},
    {0xA757, 0xA756, 0xA756},
    {0xA756, 0xA757, 0xA757},
    {0xA759, 0xA758, 0xA758},
    {0xA758, 0xA759, 0xA759},
    {0xA75B, 0xA75A, 0xA75A},
    {0xA75A, 0xA75B, 0xA75B},
    {0xA75D, 0xA75C, 0xA75C},
    {0xA75C, 0xA75D, 0xA75D},
    {0xA75F, 0xA75E, 0xA75E},
    {0xA75E, 0xA75F, 0xA75F},
    {0xA761, 0xA760, 0xA760},
    {0xA760, 0xA761, 0xA761},
    {0xA763, 0xA762, 0xA762},
    {0xA762, 0xA763, 0xA763},
    {0xA765, 0xA764, 0xA764},
    {0xA764, 0xA765, 0xA765},
    {0xA767, 0xA766, 0xA766},
    {0xA766, 0xA767, 0xA767},
    {0xA769, 0xA768, 0xA768},
    {0xA768, 0xA769, 0xA769},
    {0xA76B, 0xA76A, 0xA76A},
    {0xA76A, 0xA76B, 0xA76B},
    {0xA76D, 0xA76C, 0xA76C},
    {0xA76C, 0xA76D, 0xA76D},
    {0xA76F, 0xA76E, 0xA76E},
    {0xA76E, 0xA76F, 0xA76F},
    {0xA77A, 0xA779, 0xA779},
    {0xA779, 0xA77A, 0xA77A},
    {0xA77C, 0xA77B, 0xA77B},
    {0xA77B, 0xA77C, 0xA77C},
    {0x1D79, 0xA77D, 0xA77D},
    {0xA77F, 0xA77E, 0xA77E},
    {0xA77E, 0xA77F, 0xA77F},
    {0xA781, 0xA780, 0xA780},
    {0xA780, 0xA781, 0xA781},
    {0xA783, 0xA782, 0xA782},
    {0xA782, 0xA783, 0xA783},
    {0xA785, 0xA784, 0xA784},
    {0xA784, 0xA785, 0xA785},
    {0xA787, 0xA786, 0xA786},
    {0xA786, 0xA787, 0xA787},
    {0xA78C, 0xA78B, 0xA78B},
    {0xA78B, 0xA78C, 0xA78C},
    {0x265, 0xA78D, 0xA78D},
    {0xA791, 0xA790, 0xA790},
    {0xA790, 0xA791, 0xA791},
    {0xA7A1, 0xA7A0, 0xA7A0},
    {0xA7A0, 0xA7A1, 0xA7A1},
    {0xA7A3, 0xA7A2, 0xA7A2},
    {0xA7A2, 0xA7A3, 0xA7A3},
    {0xA7A5, 0xA7A4, 0xA7A4},
    {0xA7A4, 0xA7A5, 0xA7A5},
    {0xA7A7, 0xA7A6, 0xA7A6},
    {0xA7A6, 0xA7A7, 0xA7A7},
    {0xA7A9, 0xA7A8, 0xA7A8},
    {0xA7A8, 0xA7A9, 0xA7A9},
    {0xFF41, 0xFF21, 0xFF21},
    {0xFF42, 0xFF22, 0xFF22},
    {0xFF43, 0xFF23, 0xFF23},
    {0xFF44, 0xFF24, 0xFF24},
    {0xFF45, 0xFF25, 0xFF25},
    {0xFF46, 0xFF26, 0xFF26},
    {0xFF47, 0xFF27, 0xFF27},
    {0xFF48, 0xFF28, 0xFF28},
    {0xFF49, 0xFF29, 0xFF29},
    {0xFF4A, 0xFF2A, 0xFF2A},
    {0xFF4B, 0xFF2B, 0xFF2B},
    {0xFF4C, 0xFF2C, 0xFF2C},
    {0xFF4D, 0xFF2D, 0xFF2D},
    {0xFF4E, 0xFF2E, 0xFF2E},
    {0xFF4F, 0xFF2F, 0xFF2F},
    {0xFF50, 0xFF30, 0xFF30},
    {0xFF51, 0xFF31, 0xFF31},
    {0xFF52, 0xFF32, 0xFF32},
    {0xFF53, 0xFF33, 0xFF33},
    {0xFF54, 0xFF34, 0xFF34},
    {0xFF55, 0xFF35, 0xFF35},
    {0xFF56, 0xFF36, 0xFF36},
    {0xFF57, 0xFF37, 0xFF37},
    {0xFF58, 0xFF38, 0xFF38},
    {0xFF59, 0xFF39, 0xFF39},
    {0xFF5A, 0xFF3A, 0xFF3A},
    {0xFF21, 0xFF41, 0xFF41},
    {0xFF22, 0xFF42, 0xFF42},
    {0xFF23, 0xFF43, 0xFF43},
    {0xFF24, 0xFF44, 0xFF44},
    {0xFF25, 0xFF45, 0xFF45},
    {0xFF26, 0xFF46, 0xFF46},
    {0xFF27, 0xFF47, 0xFF47},
    {0xFF28, 0xFF48, 0xFF48},
    {0xFF29, 0xFF49, 0xFF49},
    {0xFF2A, 0xFF4A, 0xFF4A},
    {0xFF2B, 0xFF4B, 0xFF4B},
    {0xFF2C, 0xFF4C, 0xFF4C},
    {0xFF2D, 0xFF4D, 0xFF4D},
    {0xFF2E, 0xFF4E, 0xFF4E},
    {0xFF2F, 0xFF4F, 0xFF4F},
    {0xFF30, 0xFF50, 0xFF50},
    {0xFF31, 0xFF51, 0xFF51},
    {0xFF32, 0xFF52, 0xFF52},
    {0xFF33, 0xFF53, 0xFF53},
    {0xFF34, 0xFF54, 0xFF54},
    {0xFF35, 0xFF55, 0xFF55},
    {0xFF36, 0xFF56, 0xFF56},
    {0xFF37, 0xFF57, 0xFF57},
    {0xFF38, 0xFF58, 0xFF58},
    {0xFF39, 0xFF59, 0xFF59},
    {0xFF3A, 0xFF5A, 0xFF5A},
    {0x10428, 0x10400, 0x10400},
    {0x10429, 0x10401, 0x10401},
    {0x1042A, 0x10402, 0x10402},
    {0x1042B, 0x10403, 0x10403},
    {0x1042C, 0x10404, 0x10404},
    {0x1042D, 0x10405, 0x10405},
    {0x1042E, 0x10406, 0x10406},
    {0x1042F, 0x10407, 0x10407},
    {0x10430, 0x10408, 0x10408},
    {0x10431, 0x10409, 0x10409},
    {0x10432, 0x1040A, 0x1040A},
    {0x10433, 0x1040B, 0x1040B},
    {0x10434, 0x1040C, 0x1040C},
    {0x10435, 0x1040D, 0x1040D},
    {0x10436, 0x1040E, 0x1040E},
    {0x10437, 0x1040F, 0x1040F},
    {0x10438, 0x10410, 0x10410},
    {0x10439, 0x10411, 0x10411},
    {0x1043A, 0x10412, 0x10412},
    {0x1043B, 0x10413, 0x10413},
    {0x1043C, 0x10414, 0x10414},
    {0x1043D, 0x10415, 0x10415},
    {0x1043E, 0x10416, 0x10416},
    {0x1043F, 0x10417, 0x10417},
    {0x10440, 0x10418, 0x10418},
    {0x10441, 0x10419, 0x10419},
    {0x10442, 0x1041A, 0x1041A},
    {0x10443, 0x1041B, 0x1041B},
    {0x10444, 0x1041C, 0x1041C},
    {0x10445, 0x1041D, 0x1041D},
    {0x10446, 0x1041E, 0x1041E},
    {0x10447, 0x1041F, 0x1041F},
    {0x10448, 0x10420, 0x10420},
    {0x10449, 0x10421, 0x10421},
    {0x1044A, 0x10422, 0x10422},
    {0x1044B, 0x10423, 0x10423},
    {0x1044C, 0x10424, 0x10424},
    {0x1044D, 0x10425, 0x10425},
    {0x1044E, 0x10426, 0x10426},
    {0x1044F, 0x10427, 0x10427},
    {0x10400, 0x10428, 0x10428},
    {0x10401, 0x10429, 0x10429},
    {0x10402, 0x1042A, 0x1042A},
    {0x10403, 0x1042B, 0x1042B},
    {0x10404, 0x1042C, 0x1042C},
    {0x10405, 0x1042D, 0x1042D},
    {0x10406, 0x1042E, 0x1042E},
    {0x10407, 0x1042F, 0x1042F},
    {0x10408, 0x10430, 0x10430},
    {0x10409, 0x10431, 0x10431},
    {0x1040A, 0x10432, 0x10432},
    {0x1040B, 0x10433, 0x10433},
    {0x1040C, 0x10434, 0x10434},
    {0x1040D, 0x10435, 0x10435},
    {0x1040E, 0x10436, 0x10436},
    {0x1040F, 0x10437, 0x10437},
    {0x10410, 0x10438, 0x10438},
    {0x10411, 0x10439, 0x10439},
    {0x10412, 0x1043A, 0x1043A},
    {0x10413, 0x1043B, 0x1043B},
    {0x10414, 0x1043C, 0x1043C},
    {0x10415, 0x1043D, 0x1043D},
    {0x10416, 0x1043E, 0x1043E},
    {0x10417, 0x1043F, 0x1043F},
    {0x10418, 0x10440, 0x10440},
    {0x10419, 0x10441, 0x10441},
    {0x1041A, 0x10442, 0x10442},
    {0x1041B, 0x10443, 0x10443},
    {0x1041C, 0x10444, 0x10444},
    {0x1041D, 0x10445, 0x10445},
    {0x1041E, 0x10446, 0x10446},
    {0x1041F, 0x10447, 0x10447},
    {0x10420, 0x10448, 0x10448},
    {0x10421, 0x10449, 0x10449},
    {0x10422, 0x1044A, 0x1044A},
    {0x10423, 0x1044B, 0x1044B},
    {0x10424, 0x1044C, 0x1044C},
    {0x10425, 0x1044D, 0x1044D},
    {0x10426, 0x1044E, 0x1044E},
    {0x10427, 0x1044F, 0x1044F},
};

/* ASCII character properties. */
#define RE_MASK_DIGIT 0x1
#define RE_MASK_LOWER 0x2
#define RE_MASK_PUNCT 0x4
#define RE_MASK_SPACE 0x8
#define RE_MASK_UPPER 0x10
#define RE_MASK_XDIGIT 0x20

/* alpha = upper | lower */
#define RE_MASK_ALPHA (RE_MASK_UPPER | RE_MASK_LOWER)
/* alnum = alpha | digit */
#define RE_MASK_ALNUM (RE_MASK_ALPHA | RE_MASK_DIGIT)

unsigned char re_ascii_property[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
    0x21, 0x21, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x00,
};

#define RE_FLAG_ASCII 0x80
#define RE_FLAG_DEBUG 0x200
#define RE_FLAG_DOTALL 0x10
#define RE_FLAG_IGNORECASE 0x2
#define RE_FLAG_LOCALE 0x4
#define RE_FLAG_MULTILINE 0x8
#define RE_FLAG_NEW 0x100
#define RE_FLAG_REVERSE 0x400
#define RE_FLAG_TEMPLATE 0x1
#define RE_FLAG_UNICODE 0x20
#define RE_FLAG_VERBOSE 0x40
#define RE_FLAG_WORD 0x800
