/*
 * Secret Labs' Regular Expression Engine
 *
 * regular expression matching engine
 *
 * Copyright (c) 1997-2001 by Secret Labs AB.  All rights reserved.
 *
 * NOTE: This file is generated by regex.py.  If you need
 * to change anything in here, edit regex.py and run it.
 *
 * 2010-01-16 mrab Re-written
 */

/* Supports Unicode version 6.0.0. */

#define RE_MAGIC 20100116

/* Size of a code word (must be unsigned short or larger, and large enough to
 * hold a Py_UNICODE character).
 */
#if SIZEOF_INT >= 4
#define RE_CODE unsigned int
#else
#define RE_CODE SIZEOF_LONG
#define RE_CODE unsigned long
#endif

/* Unlimited repeat count. */
#define RE_UNLIMITED (~(RE_CODE)0)

/* Operators. */
#define RE_OP_FAILURE 0
#define RE_OP_SUCCESS 1
#define RE_OP_ANY 2
#define RE_OP_ANY_ALL 3
#define RE_OP_ANY_ALL_REV 4
#define RE_OP_ANY_REV 5
#define RE_OP_ATOMIC 6
#define RE_OP_BIG_BITSET 7
#define RE_OP_BIG_BITSET_REV 8
#define RE_OP_BOUNDARY 9
#define RE_OP_BRANCH 10
#define RE_OP_CHARACTER 11
#define RE_OP_CHARACTER_IGN 12
#define RE_OP_CHARACTER_IGN_REV 13
#define RE_OP_CHARACTER_REV 14
#define RE_OP_DEFAULT_BOUNDARY 15
#define RE_OP_END 16
#define RE_OP_END_GREEDY_REPEAT 17
#define RE_OP_END_GROUP 18
#define RE_OP_END_LAZY_REPEAT 19
#define RE_OP_END_OF_LINE 20
#define RE_OP_END_OF_STRING 21
#define RE_OP_END_OF_STRING_LINE 22
#define RE_OP_GREEDY_REPEAT 23
#define RE_OP_GREEDY_REPEAT_ONE 24
#define RE_OP_GROUP 25
#define RE_OP_GROUP_EXISTS 26
#define RE_OP_LAZY_REPEAT 27
#define RE_OP_LAZY_REPEAT_ONE 28
#define RE_OP_LOOKAROUND 29
#define RE_OP_NEXT 30
#define RE_OP_PROPERTY 31
#define RE_OP_PROPERTY_REV 32
#define RE_OP_REF_GROUP 33
#define RE_OP_REF_GROUP_IGN 34
#define RE_OP_REF_GROUP_IGN_REV 35
#define RE_OP_REF_GROUP_REV 36
#define RE_OP_SEARCH_ANCHOR 37
#define RE_OP_SET 38
#define RE_OP_SET_REV 39
#define RE_OP_SMALL_BITSET 40
#define RE_OP_SMALL_BITSET_REV 41
#define RE_OP_START_GROUP 42
#define RE_OP_START_OF_LINE 43
#define RE_OP_START_OF_STRING 44
#define RE_OP_STRING 45
#define RE_OP_STRING_IGN 46
#define RE_OP_STRING_IGN_REV 47
#define RE_OP_STRING_REV 48
#define RE_OP_TAIL_GUARD 49

char* re_op_text[] = {
    "RE_OP_FAILURE",
    "RE_OP_SUCCESS",
    "RE_OP_ANY",
    "RE_OP_ANY_ALL",
    "RE_OP_ANY_ALL_REV",
    "RE_OP_ANY_REV",
    "RE_OP_ATOMIC",
    "RE_OP_BIG_BITSET",
    "RE_OP_BIG_BITSET_REV",
    "RE_OP_BOUNDARY",
    "RE_OP_BRANCH",
    "RE_OP_CHARACTER",
    "RE_OP_CHARACTER_IGN",
    "RE_OP_CHARACTER_IGN_REV",
    "RE_OP_CHARACTER_REV",
    "RE_OP_DEFAULT_BOUNDARY",
    "RE_OP_END",
    "RE_OP_END_GREEDY_REPEAT",
    "RE_OP_END_GROUP",
    "RE_OP_END_LAZY_REPEAT",
    "RE_OP_END_OF_LINE",
    "RE_OP_END_OF_STRING",
    "RE_OP_END_OF_STRING_LINE",
    "RE_OP_GREEDY_REPEAT",
    "RE_OP_GREEDY_REPEAT_ONE",
    "RE_OP_GROUP",
    "RE_OP_GROUP_EXISTS",
    "RE_OP_LAZY_REPEAT",
    "RE_OP_LAZY_REPEAT_ONE",
    "RE_OP_LOOKAROUND",
    "RE_OP_NEXT",
    "RE_OP_PROPERTY",
    "RE_OP_PROPERTY_REV",
    "RE_OP_REF_GROUP",
    "RE_OP_REF_GROUP_IGN",
    "RE_OP_REF_GROUP_IGN_REV",
    "RE_OP_REF_GROUP_REV",
    "RE_OP_SEARCH_ANCHOR",
    "RE_OP_SET",
    "RE_OP_SET_REV",
    "RE_OP_SMALL_BITSET",
    "RE_OP_SMALL_BITSET_REV",
    "RE_OP_START_GROUP",
    "RE_OP_START_OF_LINE",
    "RE_OP_START_OF_STRING",
    "RE_OP_STRING",
    "RE_OP_STRING_IGN",
    "RE_OP_STRING_IGN_REV",
    "RE_OP_STRING_REV",
    "RE_OP_TAIL_GUARD",
};

/* Character/codepoint properties. */
#define RE_PROP_CN 0
#define RE_PROP_LU 1
#define RE_PROP_LL 2
#define RE_PROP_LT 3
#define RE_PROP_MN 4
#define RE_PROP_MC 5
#define RE_PROP_ME 6
#define RE_PROP_ND 7
#define RE_PROP_NL 8
#define RE_PROP_NO 9
#define RE_PROP_ZS 10
#define RE_PROP_ZL 11
#define RE_PROP_ZP 12
#define RE_PROP_CC 13
#define RE_PROP_CF 14
#define RE_PROP_CS 15
#define RE_PROP_CO 16
#define RE_PROP_LM 18
#define RE_PROP_LO 19
#define RE_PROP_PC 20
#define RE_PROP_PD 21
#define RE_PROP_PS 22
#define RE_PROP_PE 23
#define RE_PROP_PI 24
#define RE_PROP_PF 25
#define RE_PROP_PO 26
#define RE_PROP_SM 27
#define RE_PROP_SC 28
#define RE_PROP_SK 29
#define RE_PROP_SO 30
#define RE_PROP_L 32
#define RE_PROP_M 33
#define RE_PROP_Z 34
#define RE_PROP_S 35
#define RE_PROP_N 36
#define RE_PROP_P 37
#define RE_PROP_C 38
#define RE_PROP_ALPHA 39
#define RE_PROP_ALNUM 40
#define RE_PROP_ASCII 41
#define RE_PROP_BLANK 42
#define RE_PROP_CNTRL 43
#define RE_PROP_DIGIT 44
#define RE_PROP_GRAPH 45
#define RE_PROP_LINEBREAK 46
#define RE_PROP_LOWER 47
#define RE_PROP_PRINT 48
#define RE_PROP_PUNCT 49
#define RE_PROP_SPACE 50
#define RE_PROP_UPPER 51
#define RE_PROP_WORD 52
#define RE_PROP_XDIGIT 53

/* Unicode character properties. */
#define RE_PROP_MASK_CN 0x00020001
#define RE_PROP_MASK_LU 0x00000002
#define RE_PROP_MASK_LL 0x00000004
#define RE_PROP_MASK_LT 0x00000008
#define RE_PROP_MASK_MN 0x00000010
#define RE_PROP_MASK_MC 0x00000020
#define RE_PROP_MASK_ME 0x00000040
#define RE_PROP_MASK_ND 0x00000080
#define RE_PROP_MASK_NL 0x00000100
#define RE_PROP_MASK_NO 0x00000200
#define RE_PROP_MASK_ZS 0x00000400
#define RE_PROP_MASK_ZL 0x00000800
#define RE_PROP_MASK_ZP 0x00001000
#define RE_PROP_MASK_CC 0x00002000
#define RE_PROP_MASK_CF 0x00004000
#define RE_PROP_MASK_CS 0x00008000
#define RE_PROP_MASK_CO 0x00010000
#define RE_PROP_MASK_LM 0x00040000
#define RE_PROP_MASK_LO 0x00080000
#define RE_PROP_MASK_PC 0x00100000
#define RE_PROP_MASK_PD 0x00200000
#define RE_PROP_MASK_PS 0x00400000
#define RE_PROP_MASK_PE 0x00800000
#define RE_PROP_MASK_PI 0x01000000
#define RE_PROP_MASK_PF 0x02000000
#define RE_PROP_MASK_PO 0x04000000
#define RE_PROP_MASK_SM 0x08000000
#define RE_PROP_MASK_SC 0x10000000
#define RE_PROP_MASK_SK 0x20000000
#define RE_PROP_MASK_SO 0x40000000
#define RE_PROP_MASK_L 0x000C000E
#define RE_PROP_MASK_M 0x00000070
#define RE_PROP_MASK_Z 0x00001C00
#define RE_PROP_MASK_S 0x78000000
#define RE_PROP_MASK_N 0x00000380
#define RE_PROP_MASK_P 0x07F00000
#define RE_PROP_MASK_C 0x0003E001

#define RE_PROP_MASK_ALNUM (RE_PROP_MASK_L | RE_PROP_MASK_ND)
#define RE_PROP_MASK_NONGRAPH (RE_PROP_MASK_Z | RE_PROP_MASK_C)
#define RE_PROP_MASK_PUNCT (RE_PROP_MASK_P | RE_PROP_MASK_S)
#define RE_PROP_MASK_SPACE (RE_PROP_MASK_ZL | RE_PROP_MASK_ZP | \
  RE_PROP_MASK_CC | RE_PROP_MASK_CF)
#define RE_PROP_MASK_WORD (RE_PROP_MASK_L | RE_PROP_MASK_M | RE_PROP_MASK_N | \
  RE_PROP_MASK_PC)

/* Unicode block ranges. */
#define RE_MIN_BLOCK 55
#define RE_MAX_BLOCK 263

/* Unicode script ranges. */
#define RE_MIN_SCRIPT 265
#define RE_MAX_SCRIPT 359

/* Minimum Unicode word break. */
#define RE_MIN_WORD_BREAK 361

/* Unicode cases. */
#define RE_MIN_CASE 65
#define RE_MAX_CASE 66639

/* Forms of Unicode word break. */
#define RE_BREAK_OTHER 360
#define RE_BREAK_CR 361
#define RE_BREAK_LF 362
#define RE_BREAK_NEWLINE 363
#define RE_BREAK_EXTEND 364
#define RE_BREAK_FORMAT 365
#define RE_BREAK_KATAKANA 366
#define RE_BREAK_ALETTER 367
#define RE_BREAK_MIDLETTER 368
#define RE_BREAK_MIDNUM 369
#define RE_BREAK_MIDNUMLET 370
#define RE_BREAK_NUMERIC 371
#define RE_BREAK_EXTENDNUMLET 372

/* A Unicode character can have up to 3 different alternatives when it comes to
 * case-insensitive comparisons.
 *
 * In order to reduce the size of the tables, a number of techniques are used:
 *
 * 1. The tables contain only those codepoints having different cases.
 *
 * 2. The cases are stored as numeric differences from the given codepoint, and
 *    the tables contain an index into a table of non-negative differences. If
 *    the index is negative then the difference is subtracted.
 *
 * 3. The entries are ranges of codepoints having the same set of differences,
 *    enabling adjacent codepoints to be merged.
 *
 * 4. There are separate tables for even and odd codepoints, which allows more
 *    adjacent codepoints to be merged.
 *
 * 5. The high codepoint is stored as an offset from the low codepoint. 
 *
 * Also, searching the tables is reduced by determining whether the codepoint
 * can be represented in 8-bit, 12-bit, 16-bit or 32-bit widths.
 *
 * There are separate tables for the blocks, scripts and word break properties:
 *
 * 1. The tables contain only those codepoints having a non-default property
 *    value. The default value is the minimum.
 *
 * 2. The property values are stored as the difference from the minimum.
 *
 * 3. The entries are stored as ranges of codepoints.
 *
 * 4. The high codepoint is stored as an offset from the low codepoint.
 */

typedef struct RE_PropertyRange {
    unsigned int min_char;
    unsigned short max_char_offset;
    unsigned char property_offset;
} RE_PropertyRange;

typedef struct RE_CaseBounds {
    unsigned char lo;
    unsigned char hi;
} RE_CaseBounds;

typedef struct RE_CaseRange {
    unsigned short min_char;
    unsigned char max_char_offset;
    signed char diffs[3];
} RE_CaseRange;

/* The codepoint block table. */
RE_PropertyRange re_block_ranges[] = {
    {0x80, 0x7F, 1},
    {0x100, 0x7F, 2},
    {0x180, 0xCF, 3},
    {0x250, 0x5F, 4},
    {0x2B0, 0x4F, 5},
    {0x300, 0x6F, 6},
    {0x370, 0x8F, 7},
    {0x400, 0xFF, 8},
    {0x500, 0x2F, 9},
    {0x530, 0x5F, 10},
    {0x590, 0x6F, 11},
    {0x600, 0xFF, 12},
    {0x700, 0x4F, 13},
    {0x750, 0x2F, 14},
    {0x780, 0x3F, 15},
    {0x7C0, 0x3F, 16},
    {0x800, 0x3F, 17},
    {0x840, 0x1F, 18},
    {0x900, 0x7F, 19},
    {0x980, 0x7F, 20},
    {0xA00, 0x7F, 21},
    {0xA80, 0x7F, 22},
    {0xB00, 0x7F, 23},
    {0xB80, 0x7F, 24},
    {0xC00, 0x7F, 25},
    {0xC80, 0x7F, 26},
    {0xD00, 0x7F, 27},
    {0xD80, 0x7F, 28},
    {0xE00, 0x7F, 29},
    {0xE80, 0x7F, 30},
    {0xF00, 0xFF, 31},
    {0x1000, 0x9F, 32},
    {0x10A0, 0x5F, 33},
    {0x1100, 0xFF, 34},
    {0x1200, 0x17F, 35},
    {0x1380, 0x1F, 36},
    {0x13A0, 0x5F, 37},
    {0x1400, 0x27F, 38},
    {0x1680, 0x1F, 39},
    {0x16A0, 0x5F, 40},
    {0x1700, 0x1F, 41},
    {0x1720, 0x1F, 42},
    {0x1740, 0x1F, 43},
    {0x1760, 0x1F, 44},
    {0x1780, 0x7F, 45},
    {0x1800, 0xAF, 46},
    {0x18B0, 0x4F, 47},
    {0x1900, 0x4F, 48},
    {0x1950, 0x2F, 49},
    {0x1980, 0x5F, 50},
    {0x19E0, 0x1F, 51},
    {0x1A00, 0x1F, 52},
    {0x1A20, 0x8F, 53},
    {0x1B00, 0x7F, 54},
    {0x1B80, 0x3F, 55},
    {0x1BC0, 0x3F, 56},
    {0x1C00, 0x4F, 57},
    {0x1C50, 0x2F, 58},
    {0x1CD0, 0x2F, 59},
    {0x1D00, 0x7F, 60},
    {0x1D80, 0x3F, 61},
    {0x1DC0, 0x3F, 62},
    {0x1E00, 0xFF, 63},
    {0x1F00, 0xFF, 64},
    {0x2000, 0x6F, 65},
    {0x2070, 0x2F, 66},
    {0x20A0, 0x2F, 67},
    {0x20D0, 0x2F, 68},
    {0x2100, 0x4F, 69},
    {0x2150, 0x3F, 70},
    {0x2190, 0x6F, 71},
    {0x2200, 0xFF, 72},
    {0x2300, 0xFF, 73},
    {0x2400, 0x3F, 74},
    {0x2440, 0x1F, 75},
    {0x2460, 0x9F, 76},
    {0x2500, 0x7F, 77},
    {0x2580, 0x1F, 78},
    {0x25A0, 0x5F, 79},
    {0x2600, 0xFF, 80},
    {0x2700, 0xBF, 81},
    {0x27C0, 0x2F, 82},
    {0x27F0, 0xF, 83},
    {0x2800, 0xFF, 84},
    {0x2900, 0x7F, 85},
    {0x2980, 0x7F, 86},
    {0x2A00, 0xFF, 87},
    {0x2B00, 0xFF, 88},
    {0x2C00, 0x5F, 89},
    {0x2C60, 0x1F, 90},
    {0x2C80, 0x7F, 91},
    {0x2D00, 0x2F, 92},
    {0x2D30, 0x4F, 93},
    {0x2D80, 0x5F, 94},
    {0x2DE0, 0x1F, 95},
    {0x2E00, 0x7F, 96},
    {0x2E80, 0x7F, 97},
    {0x2F00, 0xDF, 98},
    {0x2FF0, 0xF, 99},
    {0x3000, 0x3F, 100},
    {0x3040, 0x5F, 101},
    {0x30A0, 0x5F, 102},
    {0x3100, 0x2F, 103},
    {0x3130, 0x5F, 104},
    {0x3190, 0xF, 105},
    {0x31A0, 0x1F, 106},
    {0x31C0, 0x2F, 107},
    {0x31F0, 0xF, 108},
    {0x3200, 0xFF, 109},
    {0x3300, 0xFF, 110},
    {0x3400, 0x19BF, 111},
    {0x4DC0, 0x3F, 112},
    {0x4E00, 0x51FF, 113},
    {0xA000, 0x48F, 114},
    {0xA490, 0x3F, 115},
    {0xA4D0, 0x2F, 116},
    {0xA500, 0x13F, 117},
    {0xA640, 0x5F, 118},
    {0xA6A0, 0x5F, 119},
    {0xA700, 0x1F, 120},
    {0xA720, 0xDF, 121},
    {0xA800, 0x2F, 122},
    {0xA830, 0xF, 123},
    {0xA840, 0x3F, 124},
    {0xA880, 0x5F, 125},
    {0xA8E0, 0x1F, 126},
    {0xA900, 0x2F, 127},
    {0xA930, 0x2F, 128},
    {0xA960, 0x1F, 129},
    {0xA980, 0x5F, 130},
    {0xAA00, 0x5F, 131},
    {0xAA60, 0x1F, 132},
    {0xAA80, 0x5F, 133},
    {0xAB00, 0x2F, 134},
    {0xABC0, 0x3F, 135},
    {0xAC00, 0x2BAF, 136},
    {0xD7B0, 0x4F, 137},
    {0xD800, 0x37F, 138},
    {0xDB80, 0x7F, 139},
    {0xDC00, 0x3FF, 140},
    {0xE000, 0x18FF, 141},
    {0xF900, 0x1FF, 142},
    {0xFB00, 0x4F, 143},
    {0xFB50, 0x2AF, 144},
    {0xFE00, 0xF, 145},
    {0xFE10, 0xF, 146},
    {0xFE20, 0xF, 147},
    {0xFE30, 0x1F, 148},
    {0xFE50, 0x1F, 149},
    {0xFE70, 0x8F, 150},
    {0xFF00, 0xEF, 151},
    {0xFFF0, 0xF, 152},
    {0x10000, 0x7F, 153},
    {0x10080, 0x7F, 154},
    {0x10100, 0x3F, 155},
    {0x10140, 0x4F, 156},
    {0x10190, 0x3F, 157},
    {0x101D0, 0x2F, 158},
    {0x10280, 0x1F, 159},
    {0x102A0, 0x3F, 160},
    {0x10300, 0x2F, 161},
    {0x10330, 0x1F, 162},
    {0x10380, 0x1F, 163},
    {0x103A0, 0x3F, 164},
    {0x10400, 0x4F, 165},
    {0x10450, 0x2F, 166},
    {0x10480, 0x2F, 167},
    {0x10800, 0x3F, 168},
    {0x10840, 0x1F, 169},
    {0x10900, 0x1F, 170},
    {0x10920, 0x1F, 171},
    {0x10A00, 0x5F, 172},
    {0x10A60, 0x1F, 173},
    {0x10B00, 0x3F, 174},
    {0x10B40, 0x1F, 175},
    {0x10B60, 0x1F, 176},
    {0x10C00, 0x4F, 177},
    {0x10E60, 0x1F, 178},
    {0x11000, 0x7F, 179},
    {0x11080, 0x4F, 180},
    {0x12000, 0x3FF, 181},
    {0x12400, 0x7F, 182},
    {0x13000, 0x42F, 183},
    {0x16800, 0x23F, 184},
    {0x1B000, 0xFF, 185},
    {0x1D000, 0xFF, 186},
    {0x1D100, 0xFF, 187},
    {0x1D200, 0x4F, 188},
    {0x1D300, 0x5F, 189},
    {0x1D360, 0x1F, 190},
    {0x1D400, 0x3FF, 191},
    {0x1F000, 0x2F, 192},
    {0x1F030, 0x6F, 193},
    {0x1F0A0, 0x5F, 194},
    {0x1F100, 0xFF, 195},
    {0x1F200, 0xFF, 196},
    {0x1F300, 0x2FF, 197},
    {0x1F600, 0x4F, 198},
    {0x1F680, 0x7F, 199},
    {0x1F700, 0x7F, 200},
    {0x20000, 0xA6DF, 201},
    {0x2A700, 0x103F, 202},
    {0x2B740, 0xDF, 203},
    {0x2F800, 0x21F, 204},
    {0xE0000, 0x7F, 205},
    {0xE0100, 0xEF, 206},
    {0xF0000, 0xFFFF, 207},
    {0x100000, 0xFFFF, 208},
};

/* The codepoint script table. */
RE_PropertyRange re_script_ranges[] = {
    {0x41, 0x19, 1},
    {0x61, 0x19, 1},
    {0xAA, 0x0, 1},
    {0xBA, 0x0, 1},
    {0xC0, 0x16, 1},
    {0xD8, 0x1E, 1},
    {0xF8, 0x1C0, 1},
    {0x2E0, 0x4, 1},
    {0x2EA, 0x1, 34},
    {0x300, 0x6F, 40},
    {0x370, 0x3, 2},
    {0x375, 0x2, 2},
    {0x37A, 0x3, 2},
    {0x384, 0x0, 2},
    {0x386, 0x0, 2},
    {0x388, 0x2, 2},
    {0x38C, 0x0, 2},
    {0x38E, 0x13, 2},
    {0x3A3, 0x3E, 2},
    {0x3E2, 0xD, 54},
    {0x3F0, 0xF, 2},
    {0x400, 0x84, 3},
    {0x485, 0x1, 40},
    {0x487, 0xA0, 3},
    {0x531, 0x25, 4},
    {0x559, 0x6, 4},
    {0x561, 0x26, 4},
    {0x58A, 0x0, 4},
    {0x591, 0x36, 5},
    {0x5D0, 0x1A, 5},
    {0x5F0, 0x4, 5},
    {0x600, 0x3, 6},
    {0x606, 0x5, 6},
    {0x60D, 0xD, 6},
    {0x61E, 0x0, 6},
    {0x620, 0x1F, 6},
    {0x641, 0x9, 6},
    {0x64B, 0xA, 40},
    {0x656, 0x8, 6},
    {0x65F, 0x0, 40},
    {0x66A, 0x5, 6},
    {0x670, 0x0, 40},
    {0x671, 0x6B, 6},
    {0x6DE, 0x21, 6},
    {0x700, 0xD, 7},
    {0x70F, 0x3B, 7},
    {0x74D, 0x2, 7},
    {0x750, 0x2F, 6},
    {0x780, 0x31, 8},
    {0x7C0, 0x3A, 65},
    {0x800, 0x2D, 81},
    {0x830, 0xE, 81},
    {0x840, 0x1B, 94},
    {0x85E, 0x0, 94},
    {0x900, 0x50, 9},
    {0x951, 0x1, 40},
    {0x953, 0x10, 9},
    {0x966, 0x9, 9},
    {0x971, 0x6, 9},
    {0x979, 0x6, 9},
    {0x981, 0x2, 10},
    {0x985, 0x7, 10},
    {0x98F, 0x1, 10},
    {0x993, 0x15, 10},
    {0x9AA, 0x6, 10},
    {0x9B2, 0x0, 10},
    {0x9B6, 0x3, 10},
    {0x9BC, 0x8, 10},
    {0x9C7, 0x1, 10},
    {0x9CB, 0x3, 10},
    {0x9D7, 0x0, 10},
    {0x9DC, 0x1, 10},
    {0x9DF, 0x4, 10},
    {0x9E6, 0x15, 10},
    {0xA01, 0x2, 11},
    {0xA05, 0x5, 11},
    {0xA0F, 0x1, 11},
    {0xA13, 0x15, 11},
    {0xA2A, 0x6, 11},
    {0xA32, 0x1, 11},
    {0xA35, 0x1, 11},
    {0xA38, 0x1, 11},
    {0xA3C, 0x0, 11},
    {0xA3E, 0x4, 11},
    {0xA47, 0x1, 11},
    {0xA4B, 0x2, 11},
    {0xA51, 0x0, 11},
    {0xA59, 0x3, 11},
    {0xA5E, 0x0, 11},
    {0xA66, 0xF, 11},
    {0xA81, 0x2, 12},
    {0xA85, 0x8, 12},
    {0xA8F, 0x2, 12},
    {0xA93, 0x15, 12},
    {0xAAA, 0x6, 12},
    {0xAB2, 0x1, 12},
    {0xAB5, 0x4, 12},
    {0xABC, 0x9, 12},
    {0xAC7, 0x2, 12},
    {0xACB, 0x2, 12},
    {0xAD0, 0x0, 12},
    {0xAE0, 0x3, 12},
    {0xAE6, 0x9, 12},
    {0xAF1, 0x0, 12},
    {0xB01, 0x2, 13},
    {0xB05, 0x7, 13},
    {0xB0F, 0x1, 13},
    {0xB13, 0x15, 13},
    {0xB2A, 0x6, 13},
    {0xB32, 0x1, 13},
    {0xB35, 0x4, 13},
    {0xB3C, 0x8, 13},
    {0xB47, 0x1, 13},
    {0xB4B, 0x2, 13},
    {0xB56, 0x1, 13},
    {0xB5C, 0x1, 13},
    {0xB5F, 0x4, 13},
    {0xB66, 0x11, 13},
    {0xB82, 0x1, 14},
    {0xB85, 0x5, 14},
    {0xB8E, 0x2, 14},
    {0xB92, 0x3, 14},
    {0xB99, 0x1, 14},
    {0xB9C, 0x0, 14},
    {0xB9E, 0x1, 14},
    {0xBA3, 0x1, 14},
    {0xBA8, 0x2, 14},
    {0xBAE, 0xB, 14},
    {0xBBE, 0x4, 14},
    {0xBC6, 0x2, 14},
    {0xBCA, 0x3, 14},
    {0xBD0, 0x0, 14},
    {0xBD7, 0x0, 14},
    {0xBE6, 0x14, 14},
    {0xC01, 0x2, 15},
    {0xC05, 0x7, 15},
    {0xC0E, 0x2, 15},
    {0xC12, 0x16, 15},
    {0xC2A, 0x9, 15},
    {0xC35, 0x4, 15},
    {0xC3D, 0x7, 15},
    {0xC46, 0x2, 15},
    {0xC4A, 0x3, 15},
    {0xC55, 0x1, 15},
    {0xC58, 0x1, 15},
    {0xC60, 0x3, 15},
    {0xC66, 0x9, 15},
    {0xC78, 0x7, 15},
    {0xC82, 0x1, 16},
    {0xC85, 0x7, 16},
    {0xC8E, 0x2, 16},
    {0xC92, 0x16, 16},
    {0xCAA, 0x9, 16},
    {0xCB5, 0x4, 16},
    {0xCBC, 0x8, 16},
    {0xCC6, 0x2, 16},
    {0xCCA, 0x3, 16},
    {0xCD5, 0x1, 16},
    {0xCDE, 0x0, 16},
    {0xCE0, 0x3, 16},
    {0xCE6, 0x9, 16},
    {0xCF1, 0x1, 16},
    {0xD02, 0x1, 17},
    {0xD05, 0x7, 17},
    {0xD0E, 0x2, 17},
    {0xD12, 0x28, 17},
    {0xD3D, 0x7, 17},
    {0xD46, 0x2, 17},
    {0xD4A, 0x4, 17},
    {0xD57, 0x0, 17},
    {0xD60, 0x3, 17},
    {0xD66, 0xF, 17},
    {0xD79, 0x6, 17},
    {0xD82, 0x1, 18},
    {0xD85, 0x11, 18},
    {0xD9A, 0x17, 18},
    {0xDB3, 0x8, 18},
    {0xDBD, 0x0, 18},
    {0xDC0, 0x6, 18},
    {0xDCA, 0x0, 18},
    {0xDCF, 0x5, 18},
    {0xDD6, 0x0, 18},
    {0xDD8, 0x7, 18},
    {0xDF2, 0x2, 18},
    {0xE01, 0x39, 19},
    {0xE40, 0x1B, 19},
    {0xE81, 0x1, 20},
    {0xE84, 0x0, 20},
    {0xE87, 0x1, 20},
    {0xE8A, 0x0, 20},
    {0xE8D, 0x0, 20},
    {0xE94, 0x3, 20},
    {0xE99, 0x6, 20},
    {0xEA1, 0x2, 20},
    {0xEA5, 0x0, 20},
    {0xEA7, 0x0, 20},
    {0xEAA, 0x1, 20},
    {0xEAD, 0xC, 20},
    {0xEBB, 0x2, 20},
    {0xEC0, 0x4, 20},
    {0xEC6, 0x0, 20},
    {0xEC8, 0x5, 20},
    {0xED0, 0x9, 20},
    {0xEDC, 0x1, 20},
    {0xF00, 0x47, 21},
    {0xF49, 0x23, 21},
    {0xF71, 0x26, 21},
    {0xF99, 0x23, 21},
    {0xFBE, 0xE, 21},
    {0xFCE, 0x6, 21},
    {0xFD9, 0x1, 21},
    {0x1000, 0x9F, 22},
    {0x10A0, 0x25, 23},
    {0x10D0, 0x2A, 23},
    {0x10FC, 0x0, 23},
    {0x1100, 0xFF, 24},
    {0x1200, 0x48, 25},
    {0x124A, 0x3, 25},
    {0x1250, 0x6, 25},
    {0x1258, 0x0, 25},
    {0x125A, 0x3, 25},
    {0x1260, 0x28, 25},
    {0x128A, 0x3, 25},
    {0x1290, 0x20, 25},
    {0x12B2, 0x3, 25},
    {0x12B8, 0x6, 25},
    {0x12C0, 0x0, 25},
    {0x12C2, 0x3, 25},
    {0x12C8, 0xE, 25},
    {0x12D8, 0x38, 25},
    {0x1312, 0x3, 25},
    {0x1318, 0x42, 25},
    {0x135D, 0x1F, 25},
    {0x1380, 0x19, 25},
    {0x13A0, 0x54, 26},
    {0x1400, 0x27F, 27},
    {0x1680, 0x1C, 28},
    {0x16A0, 0x4A, 29},
    {0x16EE, 0x2, 29},
    {0x1700, 0xC, 41},
    {0x170E, 0x6, 41},
    {0x1720, 0x14, 42},
    {0x1740, 0x13, 43},
    {0x1760, 0xC, 44},
    {0x176E, 0x2, 44},
    {0x1772, 0x1, 44},
    {0x1780, 0x5D, 30},
    {0x17E0, 0x9, 30},
    {0x17F0, 0x9, 30},
    {0x1800, 0x1, 31},
    {0x1804, 0x0, 31},
    {0x1806, 0x8, 31},
    {0x1810, 0x9, 31},
    {0x1820, 0x57, 31},
    {0x1880, 0x2A, 31},
    {0x18B0, 0x45, 27},
    {0x1900, 0x1C, 45},
    {0x1920, 0xB, 45},
    {0x1930, 0xB, 45},
    {0x1940, 0x0, 45},
    {0x1944, 0xB, 45},
    {0x1950, 0x1D, 46},
    {0x1970, 0x4, 46},
    {0x1980, 0x2B, 55},
    {0x19B0, 0x19, 55},
    {0x19D0, 0xA, 55},
    {0x19DE, 0x1, 55},
    {0x19E0, 0x1F, 30},
    {0x1A00, 0x1B, 53},
    {0x1A1E, 0x1, 53},
    {0x1A20, 0x3E, 77},
    {0x1A60, 0x1C, 77},
    {0x1A7F, 0xA, 77},
    {0x1A90, 0x9, 77},
    {0x1AA0, 0xD, 77},
    {0x1B00, 0x4B, 61},
    {0x1B50, 0x2C, 61},
    {0x1B80, 0x2A, 66},
    {0x1BAE, 0xB, 66},
    {0x1BC0, 0x33, 92},
    {0x1BFC, 0x3, 92},
    {0x1C00, 0x37, 67},
    {0x1C3B, 0xE, 67},
    {0x1C4D, 0x2, 67},
    {0x1C50, 0x2F, 68},
    {0x1CD0, 0x2, 40},
    {0x1CD4, 0xC, 40},
    {0x1CE2, 0x6, 40},
    {0x1CED, 0x0, 40},
    {0x1D00, 0x25, 1},
    {0x1D26, 0x4, 2},
    {0x1D2B, 0x0, 3},
    {0x1D2C, 0x30, 1},
    {0x1D5D, 0x4, 2},
    {0x1D62, 0x3, 1},
    {0x1D66, 0x4, 2},
    {0x1D6B, 0xC, 1},
    {0x1D78, 0x0, 3},
    {0x1D79, 0x45, 1},
    {0x1DBF, 0x0, 2},
    {0x1DC0, 0x26, 40},
    {0x1DFC, 0x3, 40},
    {0x1E00, 0xFF, 1},
    {0x1F00, 0x15, 2},
    {0x1F18, 0x5, 2},
    {0x1F20, 0x25, 2},
    {0x1F48, 0x5, 2},
    {0x1F50, 0x7, 2},
    {0x1F59, 0x0, 2},
    {0x1F5B, 0x0, 2},
    {0x1F5D, 0x0, 2},
    {0x1F5F, 0x1E, 2},
    {0x1F80, 0x34, 2},
    {0x1FB6, 0xE, 2},
    {0x1FC6, 0xD, 2},
    {0x1FD6, 0x5, 2},
    {0x1FDD, 0x12, 2},
    {0x1FF2, 0x2, 2},
    {0x1FF6, 0x8, 2},
    {0x200C, 0x1, 40},
    {0x2071, 0x0, 1},
    {0x207F, 0x0, 1},
    {0x2090, 0xC, 1},
    {0x20D0, 0x20, 40},
    {0x2126, 0x0, 2},
    {0x212A, 0x1, 1},
    {0x2132, 0x0, 1},
    {0x214E, 0x0, 1},
    {0x2160, 0x28, 1},
    {0x2800, 0xFF, 52},
    {0x2C00, 0x2E, 56},
    {0x2C30, 0x2E, 56},
    {0x2C60, 0x1F, 1},
    {0x2C80, 0x71, 54},
    {0x2CF9, 0x6, 54},
    {0x2D00, 0x25, 23},
    {0x2D30, 0x35, 57},
    {0x2D6F, 0x1, 57},
    {0x2D7F, 0x0, 57},
    {0x2D80, 0x16, 25},
    {0x2DA0, 0x6, 25},
    {0x2DA8, 0x6, 25},
    {0x2DB0, 0x6, 25},
    {0x2DB8, 0x6, 25},
    {0x2DC0, 0x6, 25},
    {0x2DC8, 0x6, 25},
    {0x2DD0, 0x6, 25},
    {0x2DD8, 0x6, 25},
    {0x2DE0, 0x1F, 3},
    {0x2E80, 0x19, 35},
    {0x2E9B, 0x58, 35},
    {0x2F00, 0xD5, 35},
    {0x3005, 0x0, 35},
    {0x3007, 0x0, 35},
    {0x3021, 0x8, 35},
    {0x302A, 0x3, 40},
    {0x302E, 0x1, 24},
    {0x3038, 0x3, 35},
    {0x3041, 0x55, 32},
    {0x3099, 0x1, 40},
    {0x309D, 0x2, 32},
    {0x30A1, 0x59, 33},
    {0x30FD, 0x2, 33},
    {0x3105, 0x28, 34},
    {0x3131, 0x5D, 24},
    {0x31A0, 0x1A, 34},
    {0x31F0, 0xF, 33},
    {0x3200, 0x1E, 24},
    {0x3260, 0x1E, 24},
    {0x32D0, 0x2E, 33},
    {0x3300, 0x57, 33},
    {0x3400, 0x19B5, 35},
    {0x4E00, 0x51CB, 35},
    {0xA000, 0x48C, 36},
    {0xA490, 0x36, 36},
    {0xA4D0, 0x2F, 82},
    {0xA500, 0x12B, 69},
    {0xA640, 0x33, 3},
    {0xA67C, 0x1B, 3},
    {0xA6A0, 0x57, 83},
    {0xA722, 0x65, 1},
    {0xA78B, 0x3, 1},
    {0xA790, 0x1, 1},
    {0xA7A0, 0x9, 1},
    {0xA7FA, 0x5, 1},
    {0xA800, 0x2B, 58},
    {0xA840, 0x37, 64},
    {0xA880, 0x44, 70},
    {0xA8CE, 0xB, 70},
    {0xA8E0, 0x1B, 9},
    {0xA900, 0x2F, 71},
    {0xA930, 0x23, 72},
    {0xA95F, 0x0, 72},
    {0xA960, 0x1C, 24},
    {0xA980, 0x4D, 84},
    {0xA9CF, 0xA, 84},
    {0xA9DE, 0x1, 84},
    {0xAA00, 0x36, 76},
    {0xAA40, 0xD, 76},
    {0xAA50, 0x9, 76},
    {0xAA5C, 0x3, 76},
    {0xAA60, 0x1B, 22},
    {0xAA80, 0x42, 78},
    {0xAADB, 0x4, 78},
    {0xAB01, 0x5, 25},
    {0xAB09, 0x5, 25},
    {0xAB11, 0x5, 25},
    {0xAB20, 0x6, 25},
    {0xAB28, 0x6, 25},
    {0xABC0, 0x2D, 85},
    {0xABF0, 0x9, 85},
    {0xAC00, 0x2BA3, 24},
    {0xD7B0, 0x16, 24},
    {0xD7CB, 0x30, 24},
    {0xF900, 0x12D, 35},
    {0xFA30, 0x3D, 35},
    {0xFA70, 0x69, 35},
    {0xFB00, 0x6, 1},
    {0xFB13, 0x4, 4},
    {0xFB1D, 0x19, 5},
    {0xFB38, 0x4, 5},
    {0xFB3E, 0x0, 5},
    {0xFB40, 0x1, 5},
    {0xFB43, 0x1, 5},
    {0xFB46, 0x9, 5},
    {0xFB50, 0x71, 6},
    {0xFBD3, 0x16A, 6},
    {0xFD50, 0x3F, 6},
    {0xFD92, 0x35, 6},
    {0xFDF0, 0xC, 6},
    {0xFE00, 0xF, 40},
    {0xFE20, 0x6, 40},
    {0xFE70, 0x4, 6},
    {0xFE76, 0x86, 6},
    {0xFF21, 0x19, 1},
    {0xFF41, 0x19, 1},
    {0xFF66, 0x9, 33},
    {0xFF71, 0x2C, 33},
    {0xFFA0, 0x1E, 24},
    {0xFFC2, 0x5, 24},
    {0xFFCA, 0x5, 24},
    {0xFFD2, 0x5, 24},
    {0xFFDA, 0x2, 24},
    {0x10000, 0xB, 47},
    {0x1000D, 0x19, 47},
    {0x10028, 0x12, 47},
    {0x1003C, 0x1, 47},
    {0x1003F, 0xE, 47},
    {0x10050, 0xD, 47},
    {0x10080, 0x7A, 47},
    {0x10140, 0x4A, 2},
    {0x101FD, 0x0, 40},
    {0x10280, 0x1C, 73},
    {0x102A0, 0x30, 74},
    {0x10300, 0x1E, 37},
    {0x10320, 0x3, 37},
    {0x10330, 0x1A, 38},
    {0x10380, 0x1D, 48},
    {0x1039F, 0x0, 48},
    {0x103A0, 0x23, 59},
    {0x103C8, 0xD, 59},
    {0x10400, 0x4F, 39},
    {0x10450, 0x2F, 49},
    {0x10480, 0x1D, 50},
    {0x104A0, 0x9, 50},
    {0x10800, 0x5, 51},
    {0x10808, 0x0, 51},
    {0x1080A, 0x2B, 51},
    {0x10837, 0x1, 51},
    {0x1083C, 0x0, 51},
    {0x1083F, 0x0, 51},
    {0x10840, 0x15, 86},
    {0x10857, 0x8, 86},
    {0x10900, 0x1B, 63},
    {0x1091F, 0x0, 63},
    {0x10920, 0x19, 75},
    {0x1093F, 0x0, 75},
    {0x10A00, 0x3, 60},
    {0x10A05, 0x1, 60},
    {0x10A0C, 0x7, 60},
    {0x10A15, 0x2, 60},
    {0x10A19, 0x1A, 60},
    {0x10A38, 0x2, 60},
    {0x10A3F, 0x8, 60},
    {0x10A50, 0x8, 60},
    {0x10A60, 0x1F, 87},
    {0x10B00, 0x35, 79},
    {0x10B39, 0x6, 79},
    {0x10B40, 0x15, 88},
    {0x10B58, 0x7, 88},
    {0x10B60, 0x12, 89},
    {0x10B78, 0x7, 89},
    {0x10C00, 0x48, 90},
    {0x10E60, 0x1E, 6},
    {0x11000, 0x4D, 93},
    {0x11052, 0x1D, 93},
    {0x11080, 0x41, 91},
    {0x12000, 0x36E, 62},
    {0x12400, 0x62, 62},
    {0x12470, 0x3, 62},
    {0x13000, 0x42E, 80},
    {0x16800, 0x238, 83},
    {0x1B000, 0x0, 33},
    {0x1B001, 0x0, 32},
    {0x1D167, 0x2, 40},
    {0x1D17B, 0x7, 40},
    {0x1D185, 0x6, 40},
    {0x1D1AA, 0x3, 40},
    {0x1D200, 0x45, 2},
    {0x1F200, 0x0, 32},
    {0x20000, 0xA6D6, 35},
    {0x2A700, 0x1034, 35},
    {0x2B740, 0xDD, 35},
    {0x2F800, 0x21D, 35},
    {0xE0100, 0xEF, 40},
};

/* The codepoint word break table. */
RE_PropertyRange re_word_break_ranges[] = {
    {0xA, 0x0, 1},
    {0xB, 0x1, 2},
    {0x27, 0x0, 9},
    {0x2C, 0x0, 8},
    {0x2E, 0x0, 9},
    {0x30, 0x9, 10},
    {0x3A, 0x0, 7},
    {0x3B, 0x0, 8},
    {0x41, 0x19, 6},
    {0x5F, 0x0, 11},
    {0x61, 0x19, 6},
    {0x85, 0x0, 2},
    {0xAA, 0x0, 6},
    {0xAD, 0x0, 4},
    {0xB5, 0x0, 6},
    {0xB7, 0x0, 7},
    {0xBA, 0x0, 6},
    {0xC0, 0x16, 6},
    {0xD8, 0x1E, 6},
    {0xF8, 0x1C9, 6},
    {0x2C6, 0xB, 6},
    {0x2E0, 0x4, 6},
    {0x2EC, 0x0, 6},
    {0x2EE, 0x0, 6},
    {0x300, 0x6F, 3},
    {0x370, 0x4, 6},
    {0x376, 0x1, 6},
    {0x37A, 0x3, 6},
    {0x37E, 0x0, 8},
    {0x386, 0x0, 6},
    {0x387, 0x0, 7},
    {0x388, 0x2, 6},
    {0x38C, 0x0, 6},
    {0x38E, 0x13, 6},
    {0x3A3, 0x52, 6},
    {0x3F7, 0x8A, 6},
    {0x483, 0x6, 3},
    {0x48A, 0x9D, 6},
    {0x531, 0x25, 6},
    {0x559, 0x0, 6},
    {0x561, 0x26, 6},
    {0x589, 0x0, 8},
    {0x591, 0x2C, 3},
    {0x5BF, 0x0, 3},
    {0x5C1, 0x1, 3},
    {0x5C4, 0x1, 3},
    {0x5C7, 0x0, 3},
    {0x5D0, 0x1A, 6},
    {0x5F0, 0x3, 6},
    {0x5F4, 0x0, 7},
    {0x600, 0x3, 4},
    {0x60C, 0x1, 8},
    {0x610, 0xA, 3},
    {0x620, 0x2A, 6},
    {0x64B, 0x14, 3},
    {0x660, 0x9, 10},
    {0x66B, 0x0, 10},
    {0x66C, 0x0, 8},
    {0x66E, 0x1, 6},
    {0x670, 0x0, 3},
    {0x671, 0x62, 6},
    {0x6D5, 0x0, 6},
    {0x6D6, 0x6, 3},
    {0x6DD, 0x0, 4},
    {0x6DF, 0x5, 3},
    {0x6E5, 0x1, 6},
    {0x6E7, 0x1, 3},
    {0x6EA, 0x3, 3},
    {0x6EE, 0x1, 6},
    {0x6F0, 0x9, 10},
    {0x6FA, 0x2, 6},
    {0x6FF, 0x0, 6},
    {0x70F, 0x0, 4},
    {0x710, 0x0, 6},
    {0x711, 0x0, 3},
    {0x712, 0x1D, 6},
    {0x730, 0x1A, 3},
    {0x74D, 0x58, 6},
    {0x7A6, 0xA, 3},
    {0x7B1, 0x0, 6},
    {0x7C0, 0x9, 10},
    {0x7CA, 0x20, 6},
    {0x7EB, 0x8, 3},
    {0x7F4, 0x1, 6},
    {0x7F8, 0x0, 8},
    {0x7FA, 0x0, 6},
    {0x800, 0x15, 6},
    {0x816, 0x3, 3},
    {0x81A, 0x0, 6},
    {0x81B, 0x8, 3},
    {0x824, 0x0, 6},
    {0x825, 0x2, 3},
    {0x828, 0x0, 6},
    {0x829, 0x4, 3},
    {0x840, 0x18, 6},
    {0x859, 0x2, 3},
    {0x900, 0x3, 3},
    {0x904, 0x35, 6},
    {0x93A, 0x2, 3},
    {0x93D, 0x0, 6},
    {0x93E, 0x11, 3},
    {0x950, 0x0, 6},
    {0x951, 0x6, 3},
    {0x958, 0x9, 6},
    {0x962, 0x1, 3},
    {0x966, 0x9, 10},
    {0x971, 0x6, 6},
    {0x979, 0x6, 6},
    {0x981, 0x2, 3},
    {0x985, 0x7, 6},
    {0x98F, 0x1, 6},
    {0x993, 0x15, 6},
    {0x9AA, 0x6, 6},
    {0x9B2, 0x0, 6},
    {0x9B6, 0x3, 6},
    {0x9BC, 0x0, 3},
    {0x9BD, 0x0, 6},
    {0x9BE, 0x6, 3},
    {0x9C7, 0x1, 3},
    {0x9CB, 0x2, 3},
    {0x9CE, 0x0, 6},
    {0x9D7, 0x0, 3},
    {0x9DC, 0x1, 6},
    {0x9DF, 0x2, 6},
    {0x9E2, 0x1, 3},
    {0x9E6, 0x9, 10},
    {0x9F0, 0x1, 6},
    {0xA01, 0x2, 3},
    {0xA05, 0x5, 6},
    {0xA0F, 0x1, 6},
    {0xA13, 0x15, 6},
    {0xA2A, 0x6, 6},
    {0xA32, 0x1, 6},
    {0xA35, 0x1, 6},
    {0xA38, 0x1, 6},
    {0xA3C, 0x0, 3},
    {0xA3E, 0x4, 3},
    {0xA47, 0x1, 3},
    {0xA4B, 0x2, 3},
    {0xA51, 0x0, 3},
    {0xA59, 0x3, 6},
    {0xA5E, 0x0, 6},
    {0xA66, 0x9, 10},
    {0xA70, 0x1, 3},
    {0xA72, 0x2, 6},
    {0xA75, 0x0, 3},
    {0xA81, 0x2, 3},
    {0xA85, 0x8, 6},
    {0xA8F, 0x2, 6},
    {0xA93, 0x15, 6},
    {0xAAA, 0x6, 6},
    {0xAB2, 0x1, 6},
    {0xAB5, 0x4, 6},
    {0xABC, 0x0, 3},
    {0xABD, 0x0, 6},
    {0xABE, 0x7, 3},
    {0xAC7, 0x2, 3},
    {0xACB, 0x2, 3},
    {0xAD0, 0x0, 6},
    {0xAE0, 0x1, 6},
    {0xAE2, 0x1, 3},
    {0xAE6, 0x9, 10},
    {0xB01, 0x2, 3},
    {0xB05, 0x7, 6},
    {0xB0F, 0x1, 6},
    {0xB13, 0x15, 6},
    {0xB2A, 0x6, 6},
    {0xB32, 0x1, 6},
    {0xB35, 0x4, 6},
    {0xB3C, 0x0, 3},
    {0xB3D, 0x0, 6},
    {0xB3E, 0x6, 3},
    {0xB47, 0x1, 3},
    {0xB4B, 0x2, 3},
    {0xB56, 0x1, 3},
    {0xB5C, 0x1, 6},
    {0xB5F, 0x2, 6},
    {0xB62, 0x1, 3},
    {0xB66, 0x9, 10},
    {0xB71, 0x0, 6},
    {0xB82, 0x0, 3},
    {0xB83, 0x0, 6},
    {0xB85, 0x5, 6},
    {0xB8E, 0x2, 6},
    {0xB92, 0x3, 6},
    {0xB99, 0x1, 6},
    {0xB9C, 0x0, 6},
    {0xB9E, 0x1, 6},
    {0xBA3, 0x1, 6},
    {0xBA8, 0x2, 6},
    {0xBAE, 0xB, 6},
    {0xBBE, 0x4, 3},
    {0xBC6, 0x2, 3},
    {0xBCA, 0x3, 3},
    {0xBD0, 0x0, 6},
    {0xBD7, 0x0, 3},
    {0xBE6, 0x9, 10},
    {0xC01, 0x2, 3},
    {0xC05, 0x7, 6},
    {0xC0E, 0x2, 6},
    {0xC12, 0x16, 6},
    {0xC2A, 0x9, 6},
    {0xC35, 0x4, 6},
    {0xC3D, 0x0, 6},
    {0xC3E, 0x6, 3},
    {0xC46, 0x2, 3},
    {0xC4A, 0x3, 3},
    {0xC55, 0x1, 3},
    {0xC58, 0x1, 6},
    {0xC60, 0x1, 6},
    {0xC62, 0x1, 3},
    {0xC66, 0x9, 10},
    {0xC82, 0x1, 3},
    {0xC85, 0x7, 6},
    {0xC8E, 0x2, 6},
    {0xC92, 0x16, 6},
    {0xCAA, 0x9, 6},
    {0xCB5, 0x4, 6},
    {0xCBC, 0x0, 3},
    {0xCBD, 0x0, 6},
    {0xCBE, 0x6, 3},
    {0xCC6, 0x2, 3},
    {0xCCA, 0x3, 3},
    {0xCD5, 0x1, 3},
    {0xCDE, 0x0, 6},
    {0xCE0, 0x1, 6},
    {0xCE2, 0x1, 3},
    {0xCE6, 0x9, 10},
    {0xCF1, 0x1, 6},
    {0xD02, 0x1, 3},
    {0xD05, 0x7, 6},
    {0xD0E, 0x2, 6},
    {0xD12, 0x28, 6},
    {0xD3D, 0x0, 6},
    {0xD3E, 0x6, 3},
    {0xD46, 0x2, 3},
    {0xD4A, 0x3, 3},
    {0xD4E, 0x0, 6},
    {0xD57, 0x0, 3},
    {0xD60, 0x1, 6},
    {0xD62, 0x1, 3},
    {0xD66, 0x9, 10},
    {0xD7A, 0x5, 6},
    {0xD82, 0x1, 3},
    {0xD85, 0x11, 6},
    {0xD9A, 0x17, 6},
    {0xDB3, 0x8, 6},
    {0xDBD, 0x0, 6},
    {0xDC0, 0x6, 6},
    {0xDCA, 0x0, 3},
    {0xDCF, 0x5, 3},
    {0xDD6, 0x0, 3},
    {0xDD8, 0x7, 3},
    {0xDF2, 0x1, 3},
    {0xE31, 0x0, 3},
    {0xE34, 0x6, 3},
    {0xE47, 0x7, 3},
    {0xE50, 0x9, 10},
    {0xEB1, 0x0, 3},
    {0xEB4, 0x5, 3},
    {0xEBB, 0x1, 3},
    {0xEC8, 0x5, 3},
    {0xED0, 0x9, 10},
    {0xF00, 0x0, 6},
    {0xF18, 0x1, 3},
    {0xF20, 0x9, 10},
    {0xF35, 0x0, 3},
    {0xF37, 0x0, 3},
    {0xF39, 0x0, 3},
    {0xF3E, 0x1, 3},
    {0xF40, 0x7, 6},
    {0xF49, 0x23, 6},
    {0xF71, 0x13, 3},
    {0xF86, 0x1, 3},
    {0xF88, 0x4, 6},
    {0xF8D, 0xA, 3},
    {0xF99, 0x23, 3},
    {0xFC6, 0x0, 3},
    {0x102B, 0x13, 3},
    {0x1040, 0x9, 10},
    {0x1056, 0x3, 3},
    {0x105E, 0x2, 3},
    {0x1062, 0x2, 3},
    {0x1067, 0x6, 3},
    {0x1071, 0x3, 3},
    {0x1082, 0xB, 3},
    {0x108F, 0x0, 3},
    {0x1090, 0x9, 10},
    {0x109A, 0x3, 3},
    {0x10A0, 0x25, 6},
    {0x10D0, 0x2A, 6},
    {0x10FC, 0x0, 6},
    {0x1100, 0x148, 6},
    {0x124A, 0x3, 6},
    {0x1250, 0x6, 6},
    {0x1258, 0x0, 6},
    {0x125A, 0x3, 6},
    {0x1260, 0x28, 6},
    {0x128A, 0x3, 6},
    {0x1290, 0x20, 6},
    {0x12B2, 0x3, 6},
    {0x12B8, 0x6, 6},
    {0x12C0, 0x0, 6},
    {0x12C2, 0x3, 6},
    {0x12C8, 0xE, 6},
    {0x12D8, 0x38, 6},
    {0x1312, 0x3, 6},
    {0x1318, 0x42, 6},
    {0x135D, 0x2, 3},
    {0x1380, 0xF, 6},
    {0x13A0, 0x54, 6},
    {0x1401, 0x26B, 6},
    {0x166F, 0x10, 6},
    {0x1681, 0x19, 6},
    {0x16A0, 0x4A, 6},
    {0x16EE, 0x2, 6},
    {0x1700, 0xC, 6},
    {0x170E, 0x3, 6},
    {0x1712, 0x2, 3},
    {0x1720, 0x11, 6},
    {0x1732, 0x2, 3},
    {0x1740, 0x11, 6},
    {0x1752, 0x1, 3},
    {0x1760, 0xC, 6},
    {0x176E, 0x2, 6},
    {0x1772, 0x1, 3},
    {0x17B4, 0x1, 4},
    {0x17B6, 0x1D, 3},
    {0x17DD, 0x0, 3},
    {0x17E0, 0x9, 10},
    {0x180B, 0x2, 3},
    {0x1810, 0x9, 10},
    {0x1820, 0x57, 6},
    {0x1880, 0x28, 6},
    {0x18A9, 0x0, 3},
    {0x18AA, 0x0, 6},
    {0x18B0, 0x45, 6},
    {0x1900, 0x1C, 6},
    {0x1920, 0xB, 3},
    {0x1930, 0xB, 3},
    {0x1946, 0x9, 10},
    {0x19B0, 0x10, 3},
    {0x19C8, 0x1, 3},
    {0x19D0, 0x9, 10},
    {0x1A00, 0x16, 6},
    {0x1A17, 0x4, 3},
    {0x1A55, 0x9, 3},
    {0x1A60, 0x1C, 3},
    {0x1A7F, 0x0, 3},
    {0x1A80, 0x9, 10},
    {0x1A90, 0x9, 10},
    {0x1B00, 0x4, 3},
    {0x1B05, 0x2E, 6},
    {0x1B34, 0x10, 3},
    {0x1B45, 0x6, 6},
    {0x1B50, 0x9, 10},
    {0x1B6B, 0x8, 3},
    {0x1B80, 0x2, 3},
    {0x1B83, 0x1D, 6},
    {0x1BA1, 0x9, 3},
    {0x1BAE, 0x1, 6},
    {0x1BB0, 0x9, 10},
    {0x1BC0, 0x25, 6},
    {0x1BE6, 0xD, 3},
    {0x1C00, 0x23, 6},
    {0x1C24, 0x13, 3},
    {0x1C40, 0x9, 10},
    {0x1C4D, 0x2, 6},
    {0x1C50, 0x9, 10},
    {0x1C5A, 0x23, 6},
    {0x1CD0, 0x2, 3},
    {0x1CD4, 0x14, 3},
    {0x1CE9, 0x3, 6},
    {0x1CED, 0x0, 3},
    {0x1CEE, 0x3, 6},
    {0x1CF2, 0x0, 3},
    {0x1D00, 0xBF, 6},
    {0x1DC0, 0x26, 3},
    {0x1DFC, 0x3, 3},
    {0x1E00, 0x115, 6},
    {0x1F18, 0x5, 6},
    {0x1F20, 0x25, 6},
    {0x1F48, 0x5, 6},
    {0x1F50, 0x7, 6},
    {0x1F59, 0x0, 6},
    {0x1F5B, 0x0, 6},
    {0x1F5D, 0x0, 6},
    {0x1F5F, 0x1E, 6},
    {0x1F80, 0x34, 6},
    {0x1FB6, 0x6, 6},
    {0x1FBE, 0x0, 6},
    {0x1FC2, 0x2, 6},
    {0x1FC6, 0x6, 6},
    {0x1FD0, 0x3, 6},
    {0x1FD6, 0x5, 6},
    {0x1FE0, 0xC, 6},
    {0x1FF2, 0x2, 6},
    {0x1FF6, 0x6, 6},
    {0x200C, 0x1, 3},
    {0x200E, 0x1, 4},
    {0x2018, 0x1, 9},
    {0x2024, 0x0, 9},
    {0x2027, 0x0, 7},
    {0x2028, 0x1, 2},
    {0x202A, 0x4, 4},
    {0x203F, 0x1, 11},
    {0x2044, 0x0, 8},
    {0x2054, 0x0, 11},
    {0x2060, 0x4, 4},
    {0x206A, 0x5, 4},
    {0x2071, 0x0, 6},
    {0x207F, 0x0, 6},
    {0x2090, 0xC, 6},
    {0x20D0, 0x20, 3},
    {0x2102, 0x0, 6},
    {0x2107, 0x0, 6},
    {0x210A, 0x9, 6},
    {0x2115, 0x0, 6},
    {0x2119, 0x4, 6},
    {0x2124, 0x0, 6},
    {0x2126, 0x0, 6},
    {0x2128, 0x0, 6},
    {0x212A, 0x3, 6},
    {0x212F, 0xA, 6},
    {0x213C, 0x3, 6},
    {0x2145, 0x4, 6},
    {0x214E, 0x0, 6},
    {0x2160, 0x28, 6},
    {0x24B6, 0x33, 6},
    {0x2C00, 0x2E, 6},
    {0x2C30, 0x2E, 6},
    {0x2C60, 0x84, 6},
    {0x2CEB, 0x3, 6},
    {0x2CEF, 0x2, 3},
    {0x2D00, 0x25, 6},
    {0x2D30, 0x35, 6},
    {0x2D6F, 0x0, 6},
    {0x2D7F, 0x0, 3},
    {0x2D80, 0x16, 6},
    {0x2DA0, 0x6, 6},
    {0x2DA8, 0x6, 6},
    {0x2DB0, 0x6, 6},
    {0x2DB8, 0x6, 6},
    {0x2DC0, 0x6, 6},
    {0x2DC8, 0x6, 6},
    {0x2DD0, 0x6, 6},
    {0x2DD8, 0x6, 6},
    {0x2DE0, 0x1F, 3},
    {0x2E2F, 0x0, 6},
    {0x3005, 0x0, 6},
    {0x302A, 0x5, 3},
    {0x3031, 0x4, 5},
    {0x303B, 0x1, 6},
    {0x3099, 0x1, 3},
    {0x309B, 0x1, 5},
    {0x30A0, 0x5A, 5},
    {0x30FC, 0x3, 5},
    {0x3105, 0x28, 6},
    {0x3131, 0x5D, 6},
    {0x31A0, 0x1A, 6},
    {0x31F0, 0xF, 5},
    {0x32D0, 0x2E, 5},
    {0x3300, 0x57, 5},
    {0xA000, 0x48C, 6},
    {0xA4D0, 0x2D, 6},
    {0xA500, 0x10C, 6},
    {0xA610, 0xF, 6},
    {0xA620, 0x9, 10},
    {0xA62A, 0x1, 6},
    {0xA640, 0x2E, 6},
    {0xA66F, 0x3, 3},
    {0xA67C, 0x1, 3},
    {0xA67F, 0x18, 6},
    {0xA6A0, 0x4F, 6},
    {0xA6F0, 0x1, 3},
    {0xA717, 0x8, 6},
    {0xA722, 0x66, 6},
    {0xA78B, 0x3, 6},
    {0xA790, 0x1, 6},
    {0xA7A0, 0x9, 6},
    {0xA7FA, 0x7, 6},
    {0xA802, 0x0, 3},
    {0xA803, 0x2, 6},
    {0xA806, 0x0, 3},
    {0xA807, 0x3, 6},
    {0xA80B, 0x0, 3},
    {0xA80C, 0x16, 6},
    {0xA823, 0x4, 3},
    {0xA840, 0x33, 6},
    {0xA880, 0x1, 3},
    {0xA882, 0x31, 6},
    {0xA8B4, 0x10, 3},
    {0xA8D0, 0x9, 10},
    {0xA8E0, 0x11, 3},
    {0xA8F2, 0x5, 6},
    {0xA8FB, 0x0, 6},
    {0xA900, 0x9, 10},
    {0xA90A, 0x1B, 6},
    {0xA926, 0x7, 3},
    {0xA930, 0x16, 6},
    {0xA947, 0xC, 3},
    {0xA960, 0x1C, 6},
    {0xA980, 0x3, 3},
    {0xA984, 0x2E, 6},
    {0xA9B3, 0xD, 3},
    {0xA9CF, 0x0, 6},
    {0xA9D0, 0x9, 10},
    {0xAA00, 0x28, 6},
    {0xAA29, 0xD, 3},
    {0xAA40, 0x2, 6},
    {0xAA43, 0x0, 3},
    {0xAA44, 0x7, 6},
    {0xAA4C, 0x1, 3},
    {0xAA50, 0x9, 10},
    {0xAA7B, 0x0, 3},
    {0xAAB0, 0x0, 3},
    {0xAAB2, 0x2, 3},
    {0xAAB7, 0x1, 3},
    {0xAABE, 0x1, 3},
    {0xAAC1, 0x0, 3},
    {0xAB01, 0x5, 6},
    {0xAB09, 0x5, 6},
    {0xAB11, 0x5, 6},
    {0xAB20, 0x6, 6},
    {0xAB28, 0x6, 6},
    {0xABC0, 0x22, 6},
    {0xABE3, 0x7, 3},
    {0xABEC, 0x1, 3},
    {0xABF0, 0x9, 10},
    {0xAC00, 0x2BA3, 6},
    {0xD7B0, 0x16, 6},
    {0xD7CB, 0x30, 6},
    {0xFB00, 0x6, 6},
    {0xFB13, 0x4, 6},
    {0xFB1D, 0x0, 6},
    {0xFB1E, 0x0, 3},
    {0xFB1F, 0x9, 6},
    {0xFB2A, 0xC, 6},
    {0xFB38, 0x4, 6},
    {0xFB3E, 0x0, 6},
    {0xFB40, 0x1, 6},
    {0xFB43, 0x1, 6},
    {0xFB46, 0x6B, 6},
    {0xFBD3, 0x16A, 6},
    {0xFD50, 0x3F, 6},
    {0xFD92, 0x35, 6},
    {0xFDF0, 0xB, 6},
    {0xFE00, 0xF, 3},
    {0xFE10, 0x0, 8},
    {0xFE13, 0x0, 7},
    {0xFE14, 0x0, 8},
    {0xFE20, 0x6, 3},
    {0xFE33, 0x1, 11},
    {0xFE4D, 0x2, 11},
    {0xFE50, 0x0, 8},
    {0xFE52, 0x0, 9},
    {0xFE54, 0x0, 8},
    {0xFE55, 0x0, 7},
    {0xFE70, 0x4, 6},
    {0xFE76, 0x86, 6},
    {0xFEFF, 0x0, 4},
    {0xFF07, 0x0, 9},
    {0xFF0C, 0x0, 8},
    {0xFF0E, 0x0, 9},
    {0xFF1A, 0x0, 7},
    {0xFF1B, 0x0, 8},
    {0xFF21, 0x19, 6},
    {0xFF3F, 0x0, 11},
    {0xFF41, 0x19, 6},
    {0xFF66, 0x37, 5},
    {0xFF9E, 0x1, 3},
    {0xFFA0, 0x1E, 6},
    {0xFFC2, 0x5, 6},
    {0xFFCA, 0x5, 6},
    {0xFFD2, 0x5, 6},
    {0xFFDA, 0x2, 6},
    {0xFFF9, 0x2, 4},
    {0x10000, 0xB, 6},
    {0x1000D, 0x19, 6},
    {0x10028, 0x12, 6},
    {0x1003C, 0x1, 6},
    {0x1003F, 0xE, 6},
    {0x10050, 0xD, 6},
    {0x10080, 0x7A, 6},
    {0x10140, 0x34, 6},
    {0x101FD, 0x0, 3},
    {0x10280, 0x1C, 6},
    {0x102A0, 0x30, 6},
    {0x10300, 0x1E, 6},
    {0x10330, 0x1A, 6},
    {0x10380, 0x1D, 6},
    {0x103A0, 0x23, 6},
    {0x103C8, 0x7, 6},
    {0x103D1, 0x4, 6},
    {0x10400, 0x9D, 6},
    {0x104A0, 0x9, 10},
    {0x10800, 0x5, 6},
    {0x10808, 0x0, 6},
    {0x1080A, 0x2B, 6},
    {0x10837, 0x1, 6},
    {0x1083C, 0x0, 6},
    {0x1083F, 0x16, 6},
    {0x10900, 0x15, 6},
    {0x10920, 0x19, 6},
    {0x10A00, 0x0, 6},
    {0x10A01, 0x2, 3},
    {0x10A05, 0x1, 3},
    {0x10A0C, 0x3, 3},
    {0x10A10, 0x3, 6},
    {0x10A15, 0x2, 6},
    {0x10A19, 0x1A, 6},
    {0x10A38, 0x2, 3},
    {0x10A3F, 0x0, 3},
    {0x10A60, 0x1C, 6},
    {0x10B00, 0x35, 6},
    {0x10B40, 0x15, 6},
    {0x10B60, 0x12, 6},
    {0x10C00, 0x48, 6},
    {0x11000, 0x2, 3},
    {0x11003, 0x34, 6},
    {0x11038, 0xE, 3},
    {0x11066, 0x9, 10},
    {0x11080, 0x2, 3},
    {0x11083, 0x2C, 6},
    {0x110B0, 0xA, 3},
    {0x110BD, 0x0, 4},
    {0x12000, 0x36E, 6},
    {0x12400, 0x62, 6},
    {0x13000, 0x42E, 6},
    {0x16800, 0x238, 6},
    {0x1B000, 0x0, 5},
    {0x1D165, 0x4, 3},
    {0x1D16D, 0x5, 3},
    {0x1D173, 0x7, 4},
    {0x1D17B, 0x7, 3},
    {0x1D185, 0x6, 3},
    {0x1D1AA, 0x3, 3},
    {0x1D242, 0x2, 3},
    {0x1D400, 0x54, 6},
    {0x1D456, 0x46, 6},
    {0x1D49E, 0x1, 6},
    {0x1D4A2, 0x0, 6},
    {0x1D4A5, 0x1, 6},
    {0x1D4A9, 0x3, 6},
    {0x1D4AE, 0xB, 6},
    {0x1D4BB, 0x0, 6},
    {0x1D4BD, 0x6, 6},
    {0x1D4C5, 0x40, 6},
    {0x1D507, 0x3, 6},
    {0x1D50D, 0x7, 6},
    {0x1D516, 0x6, 6},
    {0x1D51E, 0x1B, 6},
    {0x1D53B, 0x3, 6},
    {0x1D540, 0x4, 6},
    {0x1D546, 0x0, 6},
    {0x1D54A, 0x6, 6},
    {0x1D552, 0x153, 6},
    {0x1D6A8, 0x18, 6},
    {0x1D6C2, 0x18, 6},
    {0x1D6DC, 0x1E, 6},
    {0x1D6FC, 0x18, 6},
    {0x1D716, 0x1E, 6},
    {0x1D736, 0x18, 6},
    {0x1D750, 0x1E, 6},
    {0x1D770, 0x18, 6},
    {0x1D78A, 0x1E, 6},
    {0x1D7AA, 0x18, 6},
    {0x1D7C4, 0x7, 6},
    {0x1D7CE, 0x31, 10},
    {0xE0001, 0x0, 4},
    {0xE0020, 0x5F, 4},
    {0xE0100, 0xEF, 3},
};

/* The codepoint case bounds tables. */
RE_CaseBounds re_even_case_bounds[] = {
    {0, 4},
    {4, 114},
    {114, 196},
    {196, 198},
};

RE_CaseBounds re_odd_case_bounds[] = {
    {0, 18},
    {18, 126},
    {126, 207},
    {207, 209},
};

/* The case difference table. */
unsigned short re_case_diffs[] = {
        0,     1,     2,     7,     8,     9,    15,    16,
       26,    28,    31,    32,    37,    38,    40,    47,
       48,    54,    56,    57,    59,    60,    62,    63,
       64,    69,    71,    74,    79,    80,    84,    86,
       96,    97,   100,   112,   121,   126,   128,   130,
      163,   195,   199,   202,   203,   205,   206,   207,
      209,   210,   211,   213,   214,   217,   218,   219,
      232,   300,   743,  3814,  7205,  7264,  7517,  7615,
     8262,  8383, 10727, 10743, 10749, 10780, 10782, 10783,
    10792, 10795, 10815, 35332, 42280,
};

/* The case ranges tables. */
RE_CaseRange re_even_case_ranges[] = {
    {0x21, 0xC, 11, 0, 0},
    {0x31, 0xC, -11, 0, 0},
    {0x60, 0xF, 11, 0, 0},
    {0x70, 0xF, -11, 0, 0},
    {0x80, 0x17, 1, 0, 0},
    {0x98, 0x0, -42, 0, 0},
    {0x99, 0x2, 1, 0, 0},
    {0x9D, 0x7, -1, 0, 0},
    {0xA5, 0x16, 1, 0, 0},
    {0xBC, 0x0, -36, 0, 0},
    {0xBD, 0x2, -1, 0, 0},
    {0xC0, 0x0, 41, 0, 0},
    {0xC1, 0x1, 1, 0, 0},
    {0xC3, 0x0, 46, 0, 0},
    {0xC4, 0x0, -1, 0, 0},
    {0xC5, 0x0, 45, 0, 0},
    {0xC6, 0x0, -1, 0, 0},
    {0xC7, 0x0, 28, 0, 0},
    {0xC8, 0x0, 44, 0, 0},
    {0xC9, 0x0, -1, 0, 0},
    {0xCA, 0x0, 47, 0, 0},
    {0xCB, 0x0, 50, 0, 0},
    {0xCC, 0x0, 1, 0, 0},
    {0xCD, 0x0, 40, 0, 0},
    {0xCE, 0x0, 50, 0, 0},
    {0xCF, 0x0, 39, 0, 0},
    {0xD0, 0x2, 1, 0, 0},
    {0xD3, 0x0, 54, 0, 0},
    {0xD4, 0x0, -1, 0, 0},
    {0xD6, 0x0, 1, 0, 0},
    {0xD7, 0x0, 54, 0, 0},
    {0xD8, 0x0, -1, 0, 0},
    {0xD9, 0x0, 53, 0, 0},
    {0xDA, 0x1, -1, 0, 0},
    {0xDC, 0x0, 1, 0, 0},
    {0xDE, 0x0, 1, 0, 0},
    {0xE2, 0x0, 1, 2, 0},
    {0xE3, 0x0, -2, -1, 0},
    {0xE4, 0x0, -1, 1, 0},
    {0xE5, 0x0, 1, 2, 0},
    {0xE6, 0x0, -2, -1, 0},
    {0xE7, 0x7, -1, 0, 0},
    {0xEF, 0x8, 1, 0, 0},
    {0xF9, 0x0, -1, 1, 0},
    {0xFA, 0x0, 1, 0, 0},
    {0xFB, 0x0, -33, 0, 0},
    {0xFC, 0x13, 1, 0, 0},
    {0x110, 0x0, -39, 0, 0},
    {0x111, 0x8, 1, 0, 0},
    {0x11D, 0x0, 73, 0, 0},
    {0x11E, 0x0, -1, 0, 0},
    {0x11F, 0x0, 72, 0, 0},
    {0x120, 0x0, 74, 0, 0},
    {0x121, 0x0, -1, 0, 0},
    {0x122, 0x0, 25, 0, 0},
    {0x123, 0x4, 1, 0, 0},
    {0x128, 0x0, 71, 0, 0},
    {0x129, 0x0, 70, 0, 0},
    {0x12A, 0x0, -46, 0, 0},
    {0x12B, 0x0, -45, 0, 0},
    {0x130, 0x0, -45, 0, 0},
    {0x134, 0x0, -48, 0, 0},
    {0x139, 0x0, -51, 0, 0},
    {0x140, 0x0, -54, 0, 0},
    {0x144, 0x0, -54, 0, 0},
    {0x145, 0x0, -53, 0, 0},
    {0x146, 0x0, -26, 0, 0},
    {0x149, 0x0, -55, 0, 0},
    {0x1B8, 0x1, 1, 0, 0},
    {0x1BB, 0x0, 1, 0, 0},
    {0x1BE, 0x0, 39, 0, 0},
    {0x1C3, 0x0, 13, 0, 0},
    {0x1C4, 0x1, 12, 0, 0},
    {0x1C6, 0x0, 24, 0, 0},
    {0x1C7, 0x0, 23, 0, 0},
    {0x1C9, 0x0, 11, 22, 0},
    {0x1CA, 0x1, 11, 0, 0},
    {0x1CC, 0x0, 11, 19, 0},
    {0x1CD, 0x0, 11, 31, 0},
    {0x1CE, 0x0, -58, 11, 0},
    {0x1CF, 0x0, 11, 0, 0},
    {0x1D0, 0x0, 11, 17, 0},
    {0x1D2, 0x0, 11, 0, 0},
    {0x1D3, 0x0, 11, 15, 0},
    {0x1D4, 0x1, 11, 0, 0},
    {0x1D6, 0x0, -13, 0, 0},
    {0x1D7, 0x0, -12, 0, 0},
    {0x1D9, 0x2, -11, 0, 0},
    {0x1DC, 0x0, -11, 21, 0},
    {0x1DD, 0x3, -11, 0, 0},
    {0x1E1, 0x0, -10, 0, 0},
    {0x1E2, 0x3, -11, 0, 0},
    {0x1E6, 0x0, -24, 0, 0},
    {0x1E7, 0x0, -23, 0, 0},
    {0x1E8, 0x0, -22, 0, 0},
    {0x1EB, 0x0, -17, 0, 0},
    {0x1EC, 0xB, 1, 0, 0},
    {0x1F8, 0x0, -31, 0, 0},
    {0x1F9, 0x0, 3, 0, 0},
    {0x1FA, 0x0, -21, 0, 0},
    {0x1FC, 0x0, -1, 0, 0},
    {0x1FD, 0x0, 1, 0, 0},
    {0x1FF, 0x0, -39, 0, 0},
    {0x200, 0x7, 29, 0, 0},
    {0x208, 0xF, 11, 0, 0},
    {0x218, 0xF, -11, 0, 0},
    {0x228, 0x7, -29, 0, 0},
    {0x230, 0x10, 1, 0, 0},
    {0x245, 0x1A, 1, 0, 0},
    {0x260, 0x0, 6, 0, 0},
    {0x261, 0x6, -1, 0, 0},
    {0x268, 0x2B, 1, 0, 0},
    {0x299, 0x12, 16, 0, 0},
    {0x2B1, 0x12, -16, 0, 0},
    {0x850, 0x12, 61, 0, 0},
    {0xF00, 0x2F, 1, 0, 0},
    {0xF30, 0x0, 1, 20, 0},
    {0xF31, 0x19, 1, 0, 0},
    {0xF4F, 0x0, -63, 0, 0},
    {0xF50, 0x2F, 1, 0, 0},
    {0xF80, 0x3, 4, 0, 0},
    {0xF84, 0x3, -4, 0, 0},
    {0xF88, 0x2, 4, 0, 0},
    {0xF8C, 0x2, -4, 0, 0},
    {0xF90, 0x3, 4, 0, 0},
    {0xF94, 0x3, -4, 0, 0},
    {0xF98, 0x3, 4, 0, 0},
    {0xF9C, 0x3, -4, 0, 0},
    {0xFA0, 0x2, 4, 0, 0},
    {0xFA4, 0x2, -4, 0, 0},
    {0xFB0, 0x3, 4, 0, 0},
    {0xFB4, 0x3, -4, 0, 0},
    {0xFB8, 0x0, 27, 0, 0},
    {0xFB9, 0x1, 31, 0, 0},
    {0xFBB, 0x0, 34, 0, 0},
    {0xFBC, 0x0, 38, 0, 0},
    {0xFBD, 0x0, 35, 0, 0},
    {0xFBE, 0x0, 37, 0, 0},
    {0xFC0, 0x3, 4, 0, 0},
    {0xFC4, 0x3, -4, 0, 0},
    {0xFC8, 0x3, 4, 0, 0},
    {0xFCC, 0x3, -4, 0, 0},
    {0xFD0, 0x3, 4, 0, 0},
    {0xFD4, 0x3, -4, 0, 0},
    {0xFD8, 0x0, 4, 0, 0},
    {0xFDC, 0x0, -4, 0, 0},
    {0xFDD, 0x0, -27, 0, 0},
    {0xFDE, 0x0, -5, 0, 0},
    {0xFDF, 0x0, -60, 0, 0},
    {0xFE4, 0x1, -31, 0, 0},
    {0xFE6, 0x0, -5, 0, 0},
    {0xFE8, 0x0, 4, 0, 0},
    {0xFEC, 0x0, -4, 0, 0},
    {0xFED, 0x0, -34, 0, 0},
    {0xFF0, 0x0, 4, 0, 0},
    {0xFF4, 0x0, -4, 0, 0},
    {0xFF5, 0x0, -35, 0, 0},
    {0xFF6, 0x0, -3, 0, 0},
    {0xFFC, 0x0, -38, 0, 0},
    {0xFFD, 0x0, -37, 0, 0},
    {0xFFE, 0x0, -5, 0, 0},
    {0x1093, 0x0, -62, 0, 0},
    {0x1095, 0x0, -65, 0, 0},
    {0x1099, 0x0, 9, 0, 0},
    {0x10A7, 0x0, -9, 0, 0},
    {0x10B0, 0x7, 7, 0, 0},
    {0x10B8, 0x7, -7, 0, 0},
    {0x10C2, 0x0, -1, 0, 0},
    {0x125B, 0xC, 8, 0, 0},
    {0x1268, 0xC, -8, 0, 0},
    {0x1600, 0x17, 16, 0, 0},
    {0x1618, 0x17, -16, 0, 0},
    {0x1630, 0x0, 1, 0, 0},
    {0x1631, 0x0, -67, 0, 0},
    {0x1632, 0x0, -66, 0, 0},
    {0x1633, 0x0, -72, 0, 0},
    {0x1634, 0x2, -1, 0, 0},
    {0x1637, 0x0, -68, 0, 0},
    {0x1638, 0x0, -70, 0, 0},
    {0x1639, 0x0, 1, 0, 0},
    {0x163B, 0x0, -1, 0, 0},
    {0x163F, 0x0, -74, 0, 0},
    {0x1640, 0x31, 1, 0, 0},
    {0x1676, 0x1, -1, 0, 0},
    {0x1680, 0x12, -61, 0, 0},
    {0x5320, 0x16, 1, 0, 0},
    {0x5340, 0xB, 1, 0, 0},
    {0x5391, 0x6, 1, 0, 0},
    {0x5399, 0x1E, 1, 0, 0},
    {0x53BD, 0x1, -1, 0, 0},
    {0x53BF, 0x4, 1, 0, 0},
    {0x53C6, 0x0, -1, 0, 0},
    {0x53C8, 0x0, 1, 0, 0},
    {0x53D0, 0x4, 1, 0, 0},
    {0x7F91, 0xC, 11, 0, 0},
    {0x7FA1, 0xC, -11, 0, 0},
    {0x8200, 0x13, 14, 0, 0},
    {0x8214, 0x13, -14, 0, 0},
};

RE_CaseRange re_odd_case_ranges[] = {
    {0x20, 0x3, 11, 0, 0},
    {0x24, 0x0, 11, 56, 0},
    {0x25, 0x3, 11, 0, 0},
    {0x29, 0x0, 11, 57, 0},
    {0x2A, 0x2, 11, 0, 0},
    {0x30, 0x3, -11, 0, 0},
    {0x34, 0x0, -11, 42, 0},
    {0x35, 0x0, -11, 65, 0},
    {0x36, 0x6, -11, 0, 0},
    {0x5A, 0x0, 58, 0, 0},
    {0x60, 0xA, 11, 0, 0},
    {0x6C, 0x2, 11, 0, 0},
    {0x6F, 0x0, 63, 0, 0},
    {0x70, 0x1, -11, 0, 0},
    {0x72, 0x0, -11, 64, 0},
    {0x73, 0x7, -11, 0, 0},
    {0x7C, 0x2, -11, 0, 0},
    {0x7F, 0x0, 36, 0, 0},
    {0x80, 0x17, -1, 0, 0},
    {0x98, 0x0, -56, 0, 0},
    {0x99, 0x2, -1, 0, 0},
    {0x9C, 0x7, 1, 0, 0},
    {0xA5, 0x16, -1, 0, 0},
    {0xBC, 0x2, 1, 0, 0},
    {0xBF, 0x0, -57, 0, 0},
    {0xC0, 0x0, 49, 0, 0},
    {0xC1, 0x1, -1, 0, 0},
    {0xC3, 0x0, 1, 0, 0},
    {0xC4, 0x0, 45, 0, 0},
    {0xC5, 0x0, 1, 0, 0},
    {0xC7, 0x0, 43, 0, 0},
    {0xC8, 0x0, 1, 0, 0},
    {0xC9, 0x0, 45, 0, 0},
    {0xCA, 0x0, 33, 0, 0},
    {0xCB, 0x0, 48, 0, 0},
    {0xCC, 0x0, -1, 0, 0},
    {0xCE, 0x0, 51, 0, 0},
    {0xCF, 0x0, 52, 0, 0},
    {0xD0, 0x2, -1, 0, 0},
    {0xD3, 0x0, 1, 0, 0},
    {0xD4, 0x0, 54, 0, 0},
    {0xD6, 0x0, -1, 0, 0},
    {0xD7, 0x0, 1, 0, 0},
    {0xD8, 0x0, 53, 0, 0},
    {0xD9, 0x1, 1, 0, 0},
    {0xDB, 0x0, 55, 0, 0},
    {0xDC, 0x0, -1, 0, 0},
    {0xDE, 0x0, -1, 0, 0},
    {0xDF, 0x0, 18, 0, 0},
    {0xE2, 0x0, -1, 1, 0},
    {0xE3, 0x0, 1, 2, 0},
    {0xE4, 0x0, -2, -1, 0},
    {0xE5, 0x0, -1, 1, 0},
    {0xE6, 0x7, 1, 0, 0},
    {0xEE, 0x0, -28, 0, 0},
    {0xEF, 0x8, -1, 0, 0},
    {0xF8, 0x0, 1, 2, 0},
    {0xF9, 0x0, -2, -1, 0},
    {0xFA, 0x0, -1, 0, 0},
    {0xFB, 0x0, -18, 0, 0},
    {0xFC, 0x13, -1, 0, 0},
    {0x111, 0x8, -1, 0, 0},
    {0x11D, 0x0, 1, 0, 0},
    {0x11E, 0x0, -40, 0, 0},
    {0x11F, 0x0, 74, 0, 0},
    {0x120, 0x0, 1, 0, 0},
    {0x121, 0x0, -41, 0, 0},
    {0x122, 0x0, 26, 0, 0},
    {0x123, 0x4, -1, 0, 0},
    {0x128, 0x0, 69, 0, 0},
    {0x129, 0x0, -49, 0, 0},
    {0x12B, 0x0, -45, 0, 0},
    {0x12C, 0x0, -43, 0, 0},
    {0x12D, 0x0, -44, 0, 0},
    {0x131, 0x0, -47, 0, 0},
    {0x132, 0x0, 76, 0, 0},
    {0x134, 0x0, -50, 0, 0},
    {0x135, 0x0, 67, 0, 0},
    {0x137, 0x0, -50, 0, 0},
    {0x138, 0x0, 68, 0, 0},
    {0x13A, 0x0, -52, 0, 0},
    {0x13E, 0x0, 66, 0, 0},
    {0x141, 0x0, -54, 0, 0},
    {0x144, 0x0, -25, 0, 0},
    {0x145, 0x0, -53, 0, 0},
    {0x1A2, 0x0, 30, 0, 0},
    {0x1B8, 0x1, -1, 0, 0},
    {0x1BB, 0x0, -1, 0, 0},
    {0x1BD, 0x1, 39, 0, 0},
    {0x1C4, 0x0, 12, 0, 0},
    {0x1C7, 0x0, 23, 0, 0},
    {0x1C8, 0x1, 11, 0, 0},
    {0x1CA, 0x0, 11, 32, 0},
    {0x1CB, 0x0, 11, 0, 0},
    {0x1CC, 0x0, -30, 11, 60},
    {0x1CD, 0x2, 11, 0, 0},
    {0x1D0, 0x0, 11, 29, 0},
    {0x1D1, 0x0, 10, 11, 0},
    {0x1D2, 0x3, 11, 0, 0},
    {0x1D6, 0x1, -12, 0, 0},
    {0x1D8, 0xB, -11, 0, 0},
    {0x1E4, 0x0, -11, 62, 0},
    {0x1E5, 0x0, -11, 0, 0},
    {0x1E6, 0x0, -23, 0, 0},
    {0x1E7, 0x0, 4, 0, 0},
    {0x1E8, 0x0, -19, 0, 0},
    {0x1EA, 0x0, -15, 0, 0},
    {0x1EB, 0x0, -4, 0, 0},
    {0x1EC, 0xB, -1, 0, 0},
    {0x1F8, 0x0, -29, 0, 0},
    {0x1FA, 0x0, -32, 0, 0},
    {0x1FB, 0x0, 1, 0, 0},
    {0x1FC, 0x0, -3, 0, 0},
    {0x1FD, 0x0, -1, 0, 0},
    {0x1FE, 0x1, -39, 0, 0},
    {0x200, 0x7, 29, 0, 0},
    {0x208, 0xF, 11, 0, 0},
    {0x218, 0xF, -11, 0, 0},
    {0x228, 0x7, -29, 0, 0},
    {0x230, 0x10, -1, 0, 0},
    {0x245, 0x1A, -1, 0, 0},
    {0x260, 0x6, 1, 0, 0},
    {0x267, 0x0, -6, 0, 0},
    {0x268, 0x2B, -1, 0, 0},
    {0x298, 0x12, 16, 0, 0},
    {0x2B0, 0x12, -16, 0, 0},
    {0x850, 0x12, 61, 0, 0},
    {0xEBC, 0x0, 75, 0, 0},
    {0xEBE, 0x0, 59, 0, 0},
    {0xF00, 0x4A, -1, 0, 0},
    {0xF4D, 0x0, -20, 0, 0},
    {0xF50, 0x2F, -1, 0, 0},
    {0xF80, 0x3, 4, 0, 0},
    {0xF84, 0x3, -4, 0, 0},
    {0xF88, 0x2, 4, 0, 0},
    {0xF8C, 0x2, -4, 0, 0},
    {0xF90, 0x3, 4, 0, 0},
    {0xF94, 0x3, -4, 0, 0},
    {0xF98, 0x3, 4, 0, 0},
    {0xF9C, 0x3, -4, 0, 0},
    {0xFA0, 0x2, 4, 0, 0},
    {0xFA4, 0x2, -4, 0, 0},
    {0xFA8, 0x3, 4, 0, 0},
    {0xFAC, 0x3, -4, 0, 0},
    {0xFB0, 0x3, 4, 0, 0},
    {0xFB4, 0x3, -4, 0, 0},
    {0xFB8, 0x0, 27, 0, 0},
    {0xFB9, 0x1, 31, 0, 0},
    {0xFBB, 0x0, 34, 0, 0},
    {0xFBC, 0x0, 38, 0, 0},
    {0xFBD, 0x0, 35, 0, 0},
    {0xFBE, 0x0, 37, 0, 0},
    {0xFC0, 0x3, 4, 0, 0},
    {0xFC4, 0x3, -4, 0, 0},
    {0xFC8, 0x3, 4, 0, 0},
    {0xFCC, 0x3, -4, 0, 0},
    {0xFD0, 0x3, 4, 0, 0},
    {0xFD4, 0x3, -4, 0, 0},
    {0xFD8, 0x0, 4, 0, 0},
    {0xFD9, 0x0, 5, 0, 0},
    {0xFDC, 0x0, -4, 0, 0},
    {0xFDD, 0x0, -27, 0, 0},
    {0xFE1, 0x0, 5, 0, 0},
    {0xFE4, 0x1, -31, 0, 0},
    {0xFE8, 0x0, 4, 0, 0},
    {0xFEC, 0x0, -4, 0, 0},
    {0xFED, 0x0, -34, 0, 0},
    {0xFF0, 0x0, 4, 0, 0},
    {0xFF2, 0x0, 3, 0, 0},
    {0xFF4, 0x0, -4, 0, 0},
    {0xFF5, 0x0, -35, 0, 0},
    {0xFF9, 0x0, 5, 0, 0},
    {0xFFC, 0x0, -38, 0, 0},
    {0xFFD, 0x0, -37, 0, 0},
    {0x1095, 0x0, -64, 0, 0},
    {0x10B0, 0x7, 7, 0, 0},
    {0x10B8, 0x7, -7, 0, 0},
    {0x10C1, 0x0, 1, 0, 0},
    {0x125B, 0xC, 8, 0, 0},
    {0x1268, 0xC, -8, 0, 0},
    {0x1600, 0x16, 16, 0, 0},
    {0x1618, 0x16, -16, 0, 0},
    {0x1630, 0x0, -1, 0, 0},
    {0x1631, 0x0, -59, 0, 0},
    {0x1632, 0x0, -73, 0, 0},
    {0x1633, 0x2, 1, 0, 0},
    {0x1636, 0x0, -69, 0, 0},
    {0x1637, 0x0, -71, 0, 0},
    {0x1639, 0x0, -1, 0, 0},
    {0x163A, 0x0, 1, 0, 0},
    {0x163F, 0x0, -74, 0, 0},
    {0x1640, 0x31, -1, 0, 0},
    {0x1675, 0x1, 1, 0, 0},
    {0x1680, 0x12, -61, 0, 0},
    {0x5320, 0x16, -1, 0, 0},
    {0x5340, 0xB, -1, 0, 0},
    {0x5391, 0x6, -1, 0, 0},
    {0x5399, 0x1E, -1, 0, 0},
    {0x53BC, 0x1, 1, 0, 0},
    {0x53BE, 0x0, -75, 0, 0},
    {0x53BF, 0x4, -1, 0, 0},
    {0x53C5, 0x0, 1, 0, 0},
    {0x53C6, 0x0, -76, 0, 0},
    {0x53C8, 0x0, -1, 0, 0},
    {0x53D0, 0x4, -1, 0, 0},
    {0x7F90, 0xC, 11, 0, 0},
    {0x7FA0, 0xC, -11, 0, 0},
    {0x8200, 0x13, 14, 0, 0},
    {0x8214, 0x13, -14, 0, 0},
};

/* ASCII character properties. */
#define RE_MASK_DIGIT 0x1
#define RE_MASK_LOWER 0x2
#define RE_MASK_PUNCT 0x4
#define RE_MASK_SPACE 0x8
#define RE_MASK_UPPER 0x10
#define RE_MASK_XDIGIT 0x20

/* alpha = upper | lower */
#define RE_MASK_ALPHA (RE_MASK_UPPER | RE_MASK_LOWER)
/* alnum = alpha | digit */
#define RE_MASK_ALNUM (RE_MASK_ALPHA | RE_MASK_DIGIT)

unsigned char re_ascii_property[128] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x08, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21, 0x21,
    0x21, 0x21, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10,
    0x10, 0x10, 0x10, 0x04, 0x04, 0x04, 0x04, 0x04,
    0x04, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
    0x02, 0x02, 0x02, 0x04, 0x04, 0x04, 0x04, 0x00,
};

#define RE_FLAG_ASCII 0x80
#define RE_FLAG_DEBUG 0x200
#define RE_FLAG_DOTALL 0x10
#define RE_FLAG_IGNORECASE 0x2
#define RE_FLAG_LOCALE 0x4
#define RE_FLAG_MULTILINE 0x8
#define RE_FLAG_NEW 0x100
#define RE_FLAG_REVERSE 0x400
#define RE_FLAG_TEMPLATE 0x1
#define RE_FLAG_UNICODE 0x20
#define RE_FLAG_VERBOSE 0x40
#define RE_FLAG_WORD 0x800
