/*
 * Secret Labs' Regular Expression Engine
 *
 * regular expression matching engine
 *
 * Copyright (c) 1997-2001 by Secret Labs AB.  All rights reserved.
 *
 * NOTE: This file is generated by regex.py.  If you need
 * to change anything in here, edit regex.py and run it.
 *
 * 2010-01-16 mrab Re-written
 */

/* Supports Unicode version 6.0.0. */

#define RE_MAGIC 20100116

#include "_regex_unicode.h"

/* Operators. */
#define RE_OP_FAILURE 0
#define RE_OP_SUCCESS 1
#define RE_OP_ANY 2
#define RE_OP_ANY_ALL 3
#define RE_OP_ANY_ALL_REV 4
#define RE_OP_ANY_REV 5
#define RE_OP_ANY_U 6
#define RE_OP_ANY_U_REV 7
#define RE_OP_ATOMIC 8
#define RE_OP_BOUNDARY 9
#define RE_OP_BRANCH 10
#define RE_OP_CHARACTER 11
#define RE_OP_CHARACTER_IGN 12
#define RE_OP_CHARACTER_IGN_REV 13
#define RE_OP_CHARACTER_REV 14
#define RE_OP_DEFAULT_BOUNDARY 15
#define RE_OP_DEFAULT_END_OF_WORD 16
#define RE_OP_DEFAULT_START_OF_WORD 17
#define RE_OP_END 18
#define RE_OP_END_FUZZY 19
#define RE_OP_END_GREEDY_REPEAT 20
#define RE_OP_END_GROUP 21
#define RE_OP_END_LAZY_REPEAT 22
#define RE_OP_END_OF_LINE 23
#define RE_OP_END_OF_LINE_U 24
#define RE_OP_END_OF_STRING 25
#define RE_OP_END_OF_STRING_LINE 26
#define RE_OP_END_OF_STRING_LINE_U 27
#define RE_OP_END_OF_WORD 28
#define RE_OP_FUZZY 29
#define RE_OP_GRAPHEME_BOUNDARY 30
#define RE_OP_GREEDY_REPEAT 31
#define RE_OP_GREEDY_REPEAT_ONE 32
#define RE_OP_GROUP 33
#define RE_OP_GROUP_EXISTS 34
#define RE_OP_LAZY_REPEAT 35
#define RE_OP_LAZY_REPEAT_ONE 36
#define RE_OP_LOOKAROUND 37
#define RE_OP_NEXT 38
#define RE_OP_PROPERTY 39
#define RE_OP_PROPERTY_IGN 40
#define RE_OP_PROPERTY_IGN_REV 41
#define RE_OP_PROPERTY_REV 42
#define RE_OP_RANGE 43
#define RE_OP_RANGE_IGN 44
#define RE_OP_RANGE_IGN_REV 45
#define RE_OP_RANGE_REV 46
#define RE_OP_REF_GROUP 47
#define RE_OP_REF_GROUP_IGN 48
#define RE_OP_REF_GROUP_IGN_REV 49
#define RE_OP_REF_GROUP_REV 50
#define RE_OP_SEARCH_ANCHOR 51
#define RE_OP_SET_DIFF 52
#define RE_OP_SET_DIFF_IGN 53
#define RE_OP_SET_DIFF_IGN_REV 54
#define RE_OP_SET_DIFF_REV 55
#define RE_OP_SET_INTER 56
#define RE_OP_SET_INTER_IGN 57
#define RE_OP_SET_INTER_IGN_REV 58
#define RE_OP_SET_INTER_REV 59
#define RE_OP_SET_SYM_DIFF 60
#define RE_OP_SET_SYM_DIFF_IGN 61
#define RE_OP_SET_SYM_DIFF_IGN_REV 62
#define RE_OP_SET_SYM_DIFF_REV 63
#define RE_OP_SET_UNION 64
#define RE_OP_SET_UNION_IGN 65
#define RE_OP_SET_UNION_IGN_REV 66
#define RE_OP_SET_UNION_REV 67
#define RE_OP_START_GROUP 68
#define RE_OP_START_OF_LINE 69
#define RE_OP_START_OF_LINE_U 70
#define RE_OP_START_OF_STRING 71
#define RE_OP_START_OF_WORD 72
#define RE_OP_STRING 73
#define RE_OP_STRING_IGN 74
#define RE_OP_STRING_IGN_REV 75
#define RE_OP_STRING_REV 76
#define RE_OP_STRING_SET 77
#define RE_OP_STRING_SET_IGN 78
#define RE_OP_STRING_SET_IGN_REV 79
#define RE_OP_STRING_SET_REV 80

char* re_op_text[] = {
    "RE_OP_FAILURE",
    "RE_OP_SUCCESS",
    "RE_OP_ANY",
    "RE_OP_ANY_ALL",
    "RE_OP_ANY_ALL_REV",
    "RE_OP_ANY_REV",
    "RE_OP_ANY_U",
    "RE_OP_ANY_U_REV",
    "RE_OP_ATOMIC",
    "RE_OP_BOUNDARY",
    "RE_OP_BRANCH",
    "RE_OP_CHARACTER",
    "RE_OP_CHARACTER_IGN",
    "RE_OP_CHARACTER_IGN_REV",
    "RE_OP_CHARACTER_REV",
    "RE_OP_DEFAULT_BOUNDARY",
    "RE_OP_DEFAULT_END_OF_WORD",
    "RE_OP_DEFAULT_START_OF_WORD",
    "RE_OP_END",
    "RE_OP_END_FUZZY",
    "RE_OP_END_GREEDY_REPEAT",
    "RE_OP_END_GROUP",
    "RE_OP_END_LAZY_REPEAT",
    "RE_OP_END_OF_LINE",
    "RE_OP_END_OF_LINE_U",
    "RE_OP_END_OF_STRING",
    "RE_OP_END_OF_STRING_LINE",
    "RE_OP_END_OF_STRING_LINE_U",
    "RE_OP_END_OF_WORD",
    "RE_OP_FUZZY",
    "RE_OP_GRAPHEME_BOUNDARY",
    "RE_OP_GREEDY_REPEAT",
    "RE_OP_GREEDY_REPEAT_ONE",
    "RE_OP_GROUP",
    "RE_OP_GROUP_EXISTS",
    "RE_OP_LAZY_REPEAT",
    "RE_OP_LAZY_REPEAT_ONE",
    "RE_OP_LOOKAROUND",
    "RE_OP_NEXT",
    "RE_OP_PROPERTY",
    "RE_OP_PROPERTY_IGN",
    "RE_OP_PROPERTY_IGN_REV",
    "RE_OP_PROPERTY_REV",
    "RE_OP_RANGE",
    "RE_OP_RANGE_IGN",
    "RE_OP_RANGE_IGN_REV",
    "RE_OP_RANGE_REV",
    "RE_OP_REF_GROUP",
    "RE_OP_REF_GROUP_IGN",
    "RE_OP_REF_GROUP_IGN_REV",
    "RE_OP_REF_GROUP_REV",
    "RE_OP_SEARCH_ANCHOR",
    "RE_OP_SET_DIFF",
    "RE_OP_SET_DIFF_IGN",
    "RE_OP_SET_DIFF_IGN_REV",
    "RE_OP_SET_DIFF_REV",
    "RE_OP_SET_INTER",
    "RE_OP_SET_INTER_IGN",
    "RE_OP_SET_INTER_IGN_REV",
    "RE_OP_SET_INTER_REV",
    "RE_OP_SET_SYM_DIFF",
    "RE_OP_SET_SYM_DIFF_IGN",
    "RE_OP_SET_SYM_DIFF_IGN_REV",
    "RE_OP_SET_SYM_DIFF_REV",
    "RE_OP_SET_UNION",
    "RE_OP_SET_UNION_IGN",
    "RE_OP_SET_UNION_IGN_REV",
    "RE_OP_SET_UNION_REV",
    "RE_OP_START_GROUP",
    "RE_OP_START_OF_LINE",
    "RE_OP_START_OF_LINE_U",
    "RE_OP_START_OF_STRING",
    "RE_OP_START_OF_WORD",
    "RE_OP_STRING",
    "RE_OP_STRING_IGN",
    "RE_OP_STRING_IGN_REV",
    "RE_OP_STRING_REV",
    "RE_OP_STRING_SET",
    "RE_OP_STRING_SET_IGN",
    "RE_OP_STRING_SET_IGN_REV",
    "RE_OP_STRING_SET_REV",
};

#define RE_FLAG_ASCII 0x80
#define RE_FLAG_BESTMATCH 0x1000
#define RE_FLAG_DEBUG 0x200
#define RE_FLAG_DOTALL 0x10
#define RE_FLAG_IGNORECASE 0x2
#define RE_FLAG_LOCALE 0x4
#define RE_FLAG_MULTILINE 0x8
#define RE_FLAG_REVERSE 0x400
#define RE_FLAG_TEMPLATE 0x1
#define RE_FLAG_UNICODE 0x20
#define RE_FLAG_VERBOSE 0x40
#define RE_FLAG_VERSION0 0x2000
#define RE_FLAG_VERSION1 0x100
#define RE_FLAG_WORD 0x800
