/*
 * Secret Labs' Regular Expression Engine
 *
 * regular expression matching engine
 *
 * Copyright (c) 1997-2001 by Secret Labs AB.  All rights reserved.
 *
 * NOTE: This file is generated by regex.py.  If you need
 * to change anything in here, edit regex.py and run it.
 *
 * 2010-01-16 mrab Re-written
 */

/* Supports Unicode version 6.0.0. */

#define RE_MAGIC 20100116

#include "_regex_unicode.h"

/* Operators. */
#define RE_OP_FAILURE 0
#define RE_OP_SUCCESS 1
#define RE_OP_ANY 2
#define RE_OP_ANY_ALL 3
#define RE_OP_ANY_ALL_REV 4
#define RE_OP_ANY_REV 5
#define RE_OP_ANY_U 6
#define RE_OP_ANY_U_REV 7
#define RE_OP_ATOMIC 8
#define RE_OP_BOUNDARY 9
#define RE_OP_BRANCH 10
#define RE_OP_CALL_REF 11
#define RE_OP_CHARACTER 12
#define RE_OP_CHARACTER_IGN 13
#define RE_OP_CHARACTER_IGN_REV 14
#define RE_OP_CHARACTER_REV 15
#define RE_OP_DEFAULT_BOUNDARY 16
#define RE_OP_DEFAULT_END_OF_WORD 17
#define RE_OP_DEFAULT_START_OF_WORD 18
#define RE_OP_END 19
#define RE_OP_END_FUZZY 20
#define RE_OP_END_GREEDY_REPEAT 21
#define RE_OP_END_GROUP 22
#define RE_OP_END_LAZY_REPEAT 23
#define RE_OP_END_OF_LINE 24
#define RE_OP_END_OF_LINE_U 25
#define RE_OP_END_OF_STRING 26
#define RE_OP_END_OF_STRING_LINE 27
#define RE_OP_END_OF_STRING_LINE_U 28
#define RE_OP_END_OF_WORD 29
#define RE_OP_FUZZY 30
#define RE_OP_GRAPHEME_BOUNDARY 31
#define RE_OP_GREEDY_REPEAT 32
#define RE_OP_GREEDY_REPEAT_ONE 33
#define RE_OP_GROUP 34
#define RE_OP_GROUP_CALL 35
#define RE_OP_GROUP_EXISTS 36
#define RE_OP_GROUP_RETURN 37
#define RE_OP_LAZY_REPEAT 38
#define RE_OP_LAZY_REPEAT_ONE 39
#define RE_OP_LOOKAROUND 40
#define RE_OP_NEXT 41
#define RE_OP_PROPERTY 42
#define RE_OP_PROPERTY_IGN 43
#define RE_OP_PROPERTY_IGN_REV 44
#define RE_OP_PROPERTY_REV 45
#define RE_OP_RANGE 46
#define RE_OP_RANGE_IGN 47
#define RE_OP_RANGE_IGN_REV 48
#define RE_OP_RANGE_REV 49
#define RE_OP_REF_GROUP 50
#define RE_OP_REF_GROUP_FLD 51
#define RE_OP_REF_GROUP_FLD_REV 52
#define RE_OP_REF_GROUP_IGN 53
#define RE_OP_REF_GROUP_IGN_REV 54
#define RE_OP_REF_GROUP_REV 55
#define RE_OP_SEARCH_ANCHOR 56
#define RE_OP_SET_DIFF 57
#define RE_OP_SET_DIFF_IGN 58
#define RE_OP_SET_DIFF_IGN_REV 59
#define RE_OP_SET_DIFF_REV 60
#define RE_OP_SET_INTER 61
#define RE_OP_SET_INTER_IGN 62
#define RE_OP_SET_INTER_IGN_REV 63
#define RE_OP_SET_INTER_REV 64
#define RE_OP_SET_SYM_DIFF 65
#define RE_OP_SET_SYM_DIFF_IGN 66
#define RE_OP_SET_SYM_DIFF_IGN_REV 67
#define RE_OP_SET_SYM_DIFF_REV 68
#define RE_OP_SET_UNION 69
#define RE_OP_SET_UNION_IGN 70
#define RE_OP_SET_UNION_IGN_REV 71
#define RE_OP_SET_UNION_REV 72
#define RE_OP_START_GROUP 73
#define RE_OP_START_OF_LINE 74
#define RE_OP_START_OF_LINE_U 75
#define RE_OP_START_OF_STRING 76
#define RE_OP_START_OF_WORD 77
#define RE_OP_STRING 78
#define RE_OP_STRING_FLD 79
#define RE_OP_STRING_FLD_REV 80
#define RE_OP_STRING_IGN 81
#define RE_OP_STRING_IGN_REV 82
#define RE_OP_STRING_REV 83
#define RE_OP_STRING_SET 84
#define RE_OP_STRING_SET_FLD 85
#define RE_OP_STRING_SET_FLD_REV 86
#define RE_OP_STRING_SET_IGN 87
#define RE_OP_STRING_SET_IGN_REV 88
#define RE_OP_STRING_SET_REV 89

char* re_op_text[] = {
    "RE_OP_FAILURE",
    "RE_OP_SUCCESS",
    "RE_OP_ANY",
    "RE_OP_ANY_ALL",
    "RE_OP_ANY_ALL_REV",
    "RE_OP_ANY_REV",
    "RE_OP_ANY_U",
    "RE_OP_ANY_U_REV",
    "RE_OP_ATOMIC",
    "RE_OP_BOUNDARY",
    "RE_OP_BRANCH",
    "RE_OP_CALL_REF",
    "RE_OP_CHARACTER",
    "RE_OP_CHARACTER_IGN",
    "RE_OP_CHARACTER_IGN_REV",
    "RE_OP_CHARACTER_REV",
    "RE_OP_DEFAULT_BOUNDARY",
    "RE_OP_DEFAULT_END_OF_WORD",
    "RE_OP_DEFAULT_START_OF_WORD",
    "RE_OP_END",
    "RE_OP_END_FUZZY",
    "RE_OP_END_GREEDY_REPEAT",
    "RE_OP_END_GROUP",
    "RE_OP_END_LAZY_REPEAT",
    "RE_OP_END_OF_LINE",
    "RE_OP_END_OF_LINE_U",
    "RE_OP_END_OF_STRING",
    "RE_OP_END_OF_STRING_LINE",
    "RE_OP_END_OF_STRING_LINE_U",
    "RE_OP_END_OF_WORD",
    "RE_OP_FUZZY",
    "RE_OP_GRAPHEME_BOUNDARY",
    "RE_OP_GREEDY_REPEAT",
    "RE_OP_GREEDY_REPEAT_ONE",
    "RE_OP_GROUP",
    "RE_OP_GROUP_CALL",
    "RE_OP_GROUP_EXISTS",
    "RE_OP_GROUP_RETURN",
    "RE_OP_LAZY_REPEAT",
    "RE_OP_LAZY_REPEAT_ONE",
    "RE_OP_LOOKAROUND",
    "RE_OP_NEXT",
    "RE_OP_PROPERTY",
    "RE_OP_PROPERTY_IGN",
    "RE_OP_PROPERTY_IGN_REV",
    "RE_OP_PROPERTY_REV",
    "RE_OP_RANGE",
    "RE_OP_RANGE_IGN",
    "RE_OP_RANGE_IGN_REV",
    "RE_OP_RANGE_REV",
    "RE_OP_REF_GROUP",
    "RE_OP_REF_GROUP_FLD",
    "RE_OP_REF_GROUP_FLD_REV",
    "RE_OP_REF_GROUP_IGN",
    "RE_OP_REF_GROUP_IGN_REV",
    "RE_OP_REF_GROUP_REV",
    "RE_OP_SEARCH_ANCHOR",
    "RE_OP_SET_DIFF",
    "RE_OP_SET_DIFF_IGN",
    "RE_OP_SET_DIFF_IGN_REV",
    "RE_OP_SET_DIFF_REV",
    "RE_OP_SET_INTER",
    "RE_OP_SET_INTER_IGN",
    "RE_OP_SET_INTER_IGN_REV",
    "RE_OP_SET_INTER_REV",
    "RE_OP_SET_SYM_DIFF",
    "RE_OP_SET_SYM_DIFF_IGN",
    "RE_OP_SET_SYM_DIFF_IGN_REV",
    "RE_OP_SET_SYM_DIFF_REV",
    "RE_OP_SET_UNION",
    "RE_OP_SET_UNION_IGN",
    "RE_OP_SET_UNION_IGN_REV",
    "RE_OP_SET_UNION_REV",
    "RE_OP_START_GROUP",
    "RE_OP_START_OF_LINE",
    "RE_OP_START_OF_LINE_U",
    "RE_OP_START_OF_STRING",
    "RE_OP_START_OF_WORD",
    "RE_OP_STRING",
    "RE_OP_STRING_FLD",
    "RE_OP_STRING_FLD_REV",
    "RE_OP_STRING_IGN",
    "RE_OP_STRING_IGN_REV",
    "RE_OP_STRING_REV",
    "RE_OP_STRING_SET",
    "RE_OP_STRING_SET_FLD",
    "RE_OP_STRING_SET_FLD_REV",
    "RE_OP_STRING_SET_IGN",
    "RE_OP_STRING_SET_IGN_REV",
    "RE_OP_STRING_SET_REV",
};

#define RE_FLAG_ASCII 0x80
#define RE_FLAG_BESTMATCH 0x1000
#define RE_FLAG_DEBUG 0x200
#define RE_FLAG_DOTALL 0x10
#define RE_FLAG_FULLCASE 0x4000
#define RE_FLAG_IGNORECASE 0x2
#define RE_FLAG_LOCALE 0x4
#define RE_FLAG_MULTILINE 0x8
#define RE_FLAG_REVERSE 0x400
#define RE_FLAG_TEMPLATE 0x1
#define RE_FLAG_UNICODE 0x20
#define RE_FLAG_VERBOSE 0x40
#define RE_FLAG_VERSION0 0x2000
#define RE_FLAG_VERSION1 0x100
#define RE_FLAG_WORD 0x800
