##############################################################################
#
# Copyright (c) 2008 Agendaless Consulting and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the BSD-like license at
# http://www.repoze.org/LICENSE.txt.  A copy of the license should accompany
# this distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO,
# THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND
# FITNESS FOR A PARTICULAR PURPOSE
#
##############################################################################

__version__ = '1.0b1'

import os

from setuptools import setup, find_packages

here = os.path.abspath(os.path.dirname(__file__))

def _read_file(name):
    try:
        with open(os.path.join(here, 'README.rst')) as f:
            return f.read()
    except IOError:  # Travis??? 
        return ''

README = _read_file('README.rst')
CHANGES = _read_file('CHANGES.rst')


requires = [
    'setuptools',
    'repoze.zcml',
    'zope.component',
    'zope.interface',
    'zope.configuration>=3.8.0',
    ]

tests_require = [
    'zope.testing',
    ]

testing_extras = tests_require + ['nose', 'coverage']

setup(
    name='repoze.workflow',
    version=__version__,
    description='Content workflow for repoze.bfg',
    long_description=README + '\n\n' +  CHANGES,
    classifiers=[
        "Programming Language :: Python",
        "Programming Language :: Python :: 2",
        "Programming Language :: Python :: 2.6",
        "Programming Language :: Python :: 2.7",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.2",
        "Programming Language :: Python :: 3.3",
        "Programming Language :: Python :: 3.4",
        "Programming Language :: Python :: Implementation :: CPython",
        "Programming Language :: Python :: Implementation :: PyPy",
        "Development Status :: 3 - Alpha",
        "Intended Audience :: Developers",
    ],
    keywords='web repoze workflow',
    author="Agendaless Consulting",
    author_email="repoze-dev@lists.repoze.org",
    url="http://www.repoze.org",
    license="BSD-derived (http://www.repoze.org/LICENSE.txt)",
    packages=find_packages(),
    include_package_data=True,
    namespace_packages=['repoze'],
    zip_safe=False,
    tests_require = tests_require,
    install_requires= requires,
    test_suite="repoze.workflow",
    entry_points = """
    """,
    extras_require={
        'docs': ['Sphinx', 'repoze.sphinx.autointerface'],
        'testing': testing_extras,
    },
)
