import csv
from .renderers import StringIO


def parse_csv(string):
    """
    Rough port of wq/pandas.js to Python.  Useful for validating CSV output
    generated by Django REST Pandas.
    """
    reader = csv.reader(StringIO(string))
    val_cols = None
    id_cols = None
    for row in reader:
        if row[0] == '':
            val_cols = row[row.count(''):]
            col_meta = [{} for v in val_cols]
        elif row[-1] != '' and val_cols and not id_cols:
            key = row[0]
            for i, meta in enumerate(row[1:]):
                col_meta[i].update(**{key: meta})
        elif row[-1] == '':
            id_cols = row[:row.index('')]
            meta_index = {}
            meta_i = 0
            datasets = []
            for i, ds1 in enumerate(col_meta):
                if i in meta_index:
                    continue
                meta_index[i] = meta_i
                meta_i += 1
                datasets.append(ds1)
                if i < len(col_meta):
                    for j, ds2 in enumerate(col_meta[i + 1:]):
                        if ds1 == ds2:
                            meta_index[i + j + 1] = i
            for d in datasets:
                d['data'] = []
        elif val_cols and id_cols:
            ids = {
                key: val
                for key, val in zip(id_cols, row[:len(id_cols)])
            }
            records = {}
            for i, val in enumerate(row[len(id_cols):]):
                mi = meta_index[i]
                if mi not in records:
                    data = ids.copy()
                else:
                    data = records[mi]
                try:
                    val = float(val)
                except ValueError:
                    pass
                data[val_cols[i]] = val
                records[mi] = data
            for mi, data in records.items():
                datasets[mi]['data'].append(data)
    return datasets
