# This file was generated by _scripts/gen_python.py from the rethinkdb documentation in http://github.com/rethinkdb/docs
# hash: "eab0e7931cf115ee0e52e08c6aa8234ba13b3087"

import rethinkdb

docsSource = [

	(rethinkdb.net.Connection.close, b'conn.close(noreply_wait=True)\n\nClose an open connection. Closing a connection waits until all\noutstanding requests have finished and then frees any open resources\nassociated with the connection.  If `noreply_wait` is set to `false`,\nall outstanding requests are canceled immediately.\n\nClosing a connection cancels all outstanding requests and frees the\nmemory associated with any open cursors.\n\n*Example* Close an open connection, waiting for noreply writes to finish.\n\n    conn.close()\n\n*Example* Close an open connection immediately.\n\n    conn.close(noreply_wait=False)\n'),
	(rethinkdb.connect, b'r.connect(host="localhost", port=28015, db="test", auth_key="", timeout=20) -> connection\nr.connect(host) -> connection\n\nCreate a new connection to the database server. The keyword arguments are:\n\n- `host`: host of the RethinkDB instance. The default value is `localhost`.\n- `port`: the driver port, by default `28015`.\n- `db`: the database used if not explicitly specified in a query, by default `test`.\n- `auth_key`: the authentication key, by default the empty string.\n- `timeout`: timeout period in seconds for the connection to be opened (default `20`).\n\nIf the connection cannot be established, a `RqlDriverError` exception will be thrown.\n\n__Note:__ Currently, the Python driver is not thread-safe. Each thread or multiprocessing PID should be given its own connection object. (This is likely to change in a future release of RethinkDB; you can track issue [#2427](https://github.com/rethinkdb/rethinkdb/issues/2427) for progress.)\n\n*Example* Opens a connection using the default host and port but specifying the default database.\n\n    conn = r.connect(db=\'marvel\')\n\n*Example* Opens a new connection to the database.\n\n    conn = r.connect(host = \'localhost\',\n                     port = 28015,\n                     db = \'heroes\',\n                     auth_key = \'hunter2\')\n\n'),
	(rethinkdb.net.Connection.noreply_wait, b'conn.noreply_wait()\n\n`noreply_wait` ensures that previous queries with the `noreply` flag have been processed\nby the server. Note that this guarantee only applies to queries run on the given connection.\n\n*Example* We have previously run queries with the `noreply` argument set to `True`. Now\nwait until the server has processed them.\n\n    conn.noreply_wait()\n\n'),
	(rethinkdb, b'r -> r\n\nThe top-level ReQL namespace.\n\n*Example* Setup your top-level namespace.\n\n    import rethinkdb as r\n\n'),
	(rethinkdb.net.Connection.reconnect, b'conn.reconnect(noreply_wait=True)\n\nClose and reopen a connection. Closing a connection waits until all\noutstanding requests have finished.  If `noreply_wait` is set to\n`false`, all outstanding requests are canceled immediately.\n\n*Example* Cancel outstanding requests/queries that are no longer needed.\n\n    conn.reconnect(noreply_wait=False)\n'),
	(rethinkdb.net.Connection.repl, b"conn.repl()\n\nSet the default connection to make REPL use easier. Allows calling\n`.run()` on queries without specifying a connection.\n\nConnection objects are not thread-safe and REPL connections should not\nbe used in multi-threaded environments.\n\n*Example* Set the default connection for the REPL, then call\n`run()` without specifying the connection.\n\n    r.connect(db='marvel').repl()\n    r.table('heroes').run()\n"),
	(rethinkdb.ast.RqlQuery.run, b'query.run(conn, use_outdated=False, time_format=\'native\', profile=False, durability="hard") -> cursor\nquery.run(conn, use_outdated=False, time_format=\'native\', profile=False, durability="hard") -> object\n\nRun a query on a connection, returning either a single JSON result or\na cursor, depending on the query.\n\nThe optional arguments are:\n\n- `use_outdated`: whether or not outdated reads are OK (default: `False`).\n- `time_format`: what format to return times in (default: `\'native\'`).\n  Set this to `\'raw\'` if you want times returned as JSON objects for exporting.\n- `profile`: whether or not to return a profile of the query\'s\n  execution (default: `False`).\n- `durability`: possible values are `\'hard\'` and `\'soft\'`. In soft durability mode RethinkDB\nwill acknowledge the write immediately after receiving it, but before the write has\nbeen committed to disk.\n- `group_format`: what format to return `grouped_data` and `grouped_streams` in (default: `\'native\'`).\n  Set this to `\'raw\'` if you want the raw pseudotype.\n- `noreply`: set to `True` to not receive the result object or cursor and return immediately.\n- `db`: the database to run this query against as a string. The default is the database specified in the `db` parameter to [connect](/api/python/connect/) (which defaults to `test`). The database may also be specified with the [db](/api/python/db/) command.\n- `array_limit`: the maximum numbers of array elements that can be returned by a query (default: 100,000). This affects all ReQL commands that return arrays. Note that it has no effect on the size of arrays being _written_ to the database; those always have an upper limit of 100,000 elements.\n- `binary_format`: what format to return binary data in (default: `\'native\'`). Set this to `\'raw\'` if you want the raw pseudotype.\n\n*Example* Run a query on the connection `conn` and print out every\nrow in the result.\n\n    for doc in r.table(\'marvel\').run(conn):\n        print doc\n\n*Example* If you are OK with potentially out of date data from all\nthe tables involved in this query and want potentially faster reads,\npass a flag allowing out of date data in an options object. Settings\nfor individual tables will supercede this global setting for all\ntables in the query.\n\n    r.table(\'marvel\').run(conn, use_outdated=True)\n\n*Example* If you just want to send a write and forget about it, you\ncan set `noreply` to true in the options. In this case `run` will\nreturn immediately.\n\n    r.table(\'marvel\').run(conn, noreply=True)\n\n*Example* If you want to specify whether to wait for a write to be\nwritten to disk (overriding the table\'s default settings), you can set\n`durability` to `\'hard\'` or `\'soft\'` in the options.\n\n    r.table(\'marvel\')\n        .insert({ \'superhero\': \'Iron Man\', \'superpower\': \'Arc Reactor\' })\n        .run(conn, noreply=True, durability=\'soft\')\n\n*Example* If you do not want a time object to be converted to a\nnative date object, you can pass a `time_format` flag to prevent it\n(valid flags are "raw" and "native"). This query returns an object\nwith two fields (`epoch_time` and `$reql_type$`) instead of a native date\nobject.\n\n    r.now().run(conn, time_format="raw")\n\n*Example* Specify the database to use for the query.\n\n    for doc in r.table(\'marvel\').run(conn, db=\'heroes\'):\n        print doc\n\nThis is equivalent to using the `db` command to specify the database:\n\n    r.db(\'heroes\').table(\'marvel\').run(conn) ...\n'),
	(rethinkdb.net.Connection.use, b"conn.use(db_name)\n\nChange the default database on this connection.\n\n*Example* Change the default database so that we don't need to\nspecify the database when referencing a table.\n\n    conn.use('marvel')\n    r.table('heroes').run(conn) # refers to r.db('marvel').table('heroes')\n"),
	(rethinkdb.ast.RqlQuery.avg, b"sequence.avg([field_or_function]) -> number\n\nAverages all the elements of a sequence.  If called with a field name,\naverages all the values of that field in the sequence, skipping\nelements of the sequence that lack that field.  If called with a\nfunction, calls that function on every element of the sequence and\naverages the results, skipping elements of the sequence where that\nfunction returns `None` or a non-existence error.\n\nProduces a non-existence error when called on an empty sequence.  You\ncan handle this case with `default`.\n\n*Example* What's the average of 3, 5, and 7?\n\n    r.expr([3, 5, 7]).avg().run(conn)\n\n*Example* What's the average number of points scored in a game?\n\n    r.table('games').avg('points').run(conn)\n\n*Example* What's the average number of points scored in a game,\ncounting bonus points?\n\n    r.table('games').avg(lambda game:\n        game['points'] + game['bonus_points']\n    ).run(conn)\n\n*Example* What's the average number of points scored in a game?\n(But return `None` instead of erroring of there are no games where\npoints have been scored.)\n\n    r.table('games').avg('points').default(None).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.contains, b"sequence.contains(value1[, value2...]) -> bool\nsequence.contains(predicate1[, predicate2...]) -> bool\n\nWhen called with values, returns `True` if a sequence contains all the\nspecified values.  When called with predicate functions, returns `True`\nif for each predicate there exists at least one element of the stream\nwhere that predicate returns `True`.\n\n*Example* Has Iron Man ever fought Superman?\n\n    r.table('marvel').get('ironman')['opponents'].contains('superman').run(conn)\n\n*Example* Has Iron Man ever defeated Superman in battle?\n\n    r.table('marvel').get('ironman')['battles'].contains(lambda battle:\n        (battle['winner'] == 'ironman') & (battle['loser'] == 'superman')\n    ).run(conn)\n\n*Example* Use `contains` with a predicate function to simulate an `or`. Return the Marvel superheroes who live in Detroit, Chicago or Hoboken.\n\n    r.table('marvel').filter(\n        lambda hero: r.expr(['Detroit', 'Chicago', 'Hoboken']).contains(hero['city'])\n    ).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.count, b"sequence.count([value_or_predicate]) -> number\nbinary.count() -> number\n\nCounts the number of elements in a sequence.  If called with a value,\ncounts the number of times that value occurs in the sequence.  If\ncalled with a predicate function, counts the number of elements in the\nsequence where that function returns `True`.\n\nIf `count` is called on a [binary](/api/python/binary) object, it will return the size of the object in bytes.\n\n*Example* Count the number of users.\n\n    r.table('users').count().run(conn)\n\n*Example* Count the number of 18 year old users.\n\n    r.table('users')['age'].count(18).run(conn)\n\n*Example* Count the number of users over 18.\n\n    r.table('users')['age'].count(lambda age: age > 18).run(conn)\n\n    r.table('users').count(lambda user: user['age'] > 18).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.distinct, b"sequence.distinct() -> array\ntable.distinct() -> stream\ntable.distinct(index=<indexname>) -> stream\n\nRemoves duplicate elements from a sequence.\n\nThe `distinct` command can be called on any sequence, a table, or called on a table with an index.\n\n*Example* Which unique villains have been vanquished by marvel heroes?\n\n    r.table('marvel').concat_map(\n        lambda hero: hero['villain_list']).distinct().run(conn)\n\n*Example* Topics in a table of messages have a secondary index on them, and more than one message can have the same topic. What are the unique topics in the table?\n\n    r.table('messages').distinct(index='topics').run(conn)\n\nThe above structure is functionally identical to:\n\n    r.table('messages')['topics'].distinct().run(conn)\n\nHowever, the first form (passing the index as an argument to `distinct`) is faster, and won't run into array limit issues since it's returning a stream.\n"),
	(rethinkdb.ast.RqlQuery.group, b'sequence.group(field_or_function..., [index=\'index_name\']) -> grouped_stream\n\nTakes a stream and partitions it into multiple groups based on the\nfields or functions provided.\n\n*Example* Grouping games by player.\n\nSuppose that the table `games` has the following data:\n\n    [\n        {"id": 2, "player": "Bob", "points": 15, "type": "ranked"},\n        {"id": 5, "player": "Alice", "points": 7, "type": "free"},\n        {"id": 11, "player": "Bob", "points": 10, "type": "free"},\n        {"id": 12, "player": "Alice", "points": 2, "type": "free"}\n    ]\n\nGrouping games by player can be done with:\n\n    > r.table(\'games\').group(\'player\').run(conn)\n    \n    {\n        "Alice": [\n            {"id": 5, "player": "Alice", "points": 7, "type": "free"},\n            {"id": 12, "player": "Alice", "points": 2, "type": "free"}\n        ],\n        "Bob": [\n            {"id": 2, "player": "Bob", "points": 15, "type": "ranked"},\n            {"id": 11, "player": "Bob", "points": 10, "type": "free"}\n        ]\n    }\n\nCommands chained after `group` will be called on each of these grouped\nsub-streams, producing grouped data.\n\n*Example* What is each player\'s best game?\n\n    > r.table(\'games\').group(\'player\').max(\'points\').run(conn)\n    \n    {\n        "Alice": {"id": 5, "player": "Alice", "points": 7, "type": "free"},\n        "Bob": {"id": 2, "player": "Bob", "points": 15, "type": "ranked"}\n    }\n\nCommands chained onto grouped data will operate on each grouped datum,\nproducing more grouped data.\n\n*Example* What is the maximum number of points scored by each player?\n\n    > r.table(\'games\').group(\'player\').max(\'points\')[\'points\'].run(conn)\n    \n    {\n        "Alice": 7,\n        "Bob": 15\n    }\n\nYou can also group by more than one field.\n\n*Example* What is the maximum number of points scored by each\nplayer for each game type?\n\n    > r.table(\'games\').group(\'player\', \'type\').max(\'points\')[\'points\'].run(conn)\n    \n    {\n        ("Alice", "free"): 7,\n        ("Bob", "free"): 10,\n        ("Bob", "ranked"): 15\n    }\n\nYou can also group by a function.\n\n*Example* What is the maximum number of points scored by each\nplayer for each game type?\n\n    > r.table(\'games\')\n        .group(lambda game:\n            game.pluck(\'player\', \'type\')\n        ).max(\'points\')[\'points\'].run(conn)\n    \n    {\n        frozenset([(\'player\', \'Alice\'), (\'type\', \'free\')]): 7,\n        frozenset([(\'player\', \'Bob\'), (\'type\', \'free\')]): 10,\n        frozenset([(\'player\', \'Bob\'), (\'type\', \'ranked\')]): 15,\n    }\n\nYou can also group by an index.\n\n*Example* What is the maximum number of points scored by game type?\n\n    > r.table(\'games\').group(index=\'type\').max(\'points\')[\'points\'].run(conn)\n    \n    {\n        "free": 10,\n        "ranked": 15\n    }\n\nIf you want to operate on all the groups rather than operating on each\ngroup (e.g. if you want to order the groups by their reduction), you\ncan use [ungroup](/api/python/ungroup/) to turn a grouped stream or\ngrouped data into an array of objects representing the groups.\n\n*Example* Ungrouping grouped data.\n\n    > r.table(\'games\').group(\'player\').max(\'points\')[\'points\'].ungroup().run(conn)\n    \n    [\n        {\n            "group": "Alice",\n            "reduction": 7\n        },\n        {\n            "group": "Bob",\n            "reduction": 15\n        }\n    ]\n\nUngrouping is useful e.g. for ordering grouped data, or for inserting\ngrouped data into a table.\n\n*Example* What is the maximum number of points scored by each\nplayer, with the highest scorers first?\n\n    > r.table(\'games\').group(\'player\').max(\'points\')[\'points\'].ungroup().order_by(\n            r.desc(\'reduction\')).run(conn)\n    \n    [\n        {\n            "group": "Bob",\n            "reduction": 15\n        },\n        {\n            "group": "Alice",\n            "reduction": 7\n        }\n    ]\n\nWhen grouped data are returned to the client, they are transformed\ninto a client-specific native type.  (Something similar is done with\n[times](/docs/dates-and-times/).)  In Python, grouped data are\ntransformed into a `dictionary`. If the group value is an `array`, the\nkey is converted to a `tuple`. If the group value is a `dictionary`,\nit will be converted to a `frozenset`.\n\nIf you instead want to receive the raw\npseudotype from the server (e.g. if you\'re planning to serialize the\nresult as JSON), you can specify `group_format: \'raw\'` as an optional\nargument to `run`:\n\n*Example* Get back the raw `GROUPED_DATA` pseudotype.\n\n    > r.table(\'games\').group(\'player\').avg(\'points\').run(conn, group_format=\'raw\')\n    \n    {\n        "$reql_type$": "GROUPED_DATA",\n        "data": [\n            ["Alice", 4.5],\n            ["Bob", 12.5]\n        ]\n    }\n\nNot passing the `group_format` flag would return:\n\n    {\n        "Alice": 4.5,\n        "Bob": 12.5\n    }\n\nYou might also want to use the [ungroup](/api/python/ungroup/)\ncommand (see above), which will turn the grouped data into an array of\nobjects on the server.\n\nIf you run a query that returns a grouped stream, it will be\nautomatically converted to grouped data before being sent back to you\n(there is currently no efficient way to stream groups from RethinkDB).\nThis grouped data is subject to the array size limit (see [run](/api/python/run)).\n\nIn general, operations on grouped streams will be efficiently\ndistributed, and operations on grouped data won\'t be.  You can figure\nout what you\'re working with by putting `type_of` on the end of your\nquery.  Below are efficient and inefficient examples.\n\n*Example* Efficient operation.\n\n    # r.table(\'games\').group(\'player\').type_of().run(conn)\n    # Returns "GROUPED_STREAM"\n    r.table(\'games\').group(\'player\').min(\'points\').run(conn) # EFFICIENT\n\n*Example* Inefficient operation.\n\n    # r.table(\'games\').group(\'player\').order_by(\'score\').type_of().run(conn)\n    # Returns "GROUPED_DATA"\n    r.table(\'games\').group(\'player\').order_by(\'score\').nth(0).run(conn) # INEFFICIENT\n\nWhat does it mean to be inefficient here?  When operating on grouped\ndata rather than a grouped stream, *all* of the data has to be\navailable on the node processing the query.  This means that the\noperation will only use one machine\'s resources, and will require\nmemory proportional to the size of the grouped data it\'s operating\non.  (In the case of the `order_by` in the inefficient example, that\nmeans memory proportional **to the size of the table**.)  The array\nlimit is also enforced for grouped data, so the `order_by` example\nwould fail for tables with more than 100,000 rows unless you used the `array_limit` option with `run`.\n\n*Example* What is the maximum number of points scored by each\nplayer in free games?\n\n    > r.table(\'games\').filter(lambda game:\n            game[\'type\'] = \'free\'\n        ).group(\'player\').max(\'points\')[\'points\'].run(conn)\n    \n    {\n        "Alice": 7,\n        "Bob": 10\n    }\n\n*Example* What is each player\'s highest even and odd score?\n\n    > r.table(\'games\')\n        .group(\'name\', lambda game:\n            game[\'points\'] % 2\n        ).max(\'points\')[\'points\'].run(conn)\n    \n    {\n        ("Alice", 1): 7,\n        ("Bob", 0): 10,\n        ("Bob", 1): 15\n    }\n'),
	(rethinkdb.ast.RqlQuery.max, b"sequence.max([field_or_function]) -> element\n\nFinds the maximum of a sequence.  If called with a field name, finds\nthe element of that sequence with the largest value in that field.  If\ncalled with a function, calls that function on every element of the\nsequence and returns the element which produced the largest value,\nignoring any elements where the function returns `None` or produces a\nnon-existence error.\n\nProduces a non-existence error when called on an empty sequence.  You\ncan handle this case with `default`.\n\n*Example* What's the maximum of 3, 5, and 7?\n\n    r.expr([3, 5, 7]).max().run(conn)\n\n*Example* Which user has scored the most points?\n\n    r.table('users').max('points').run(conn)\n\n*Example* Which user has scored the most points, counting bonus points?\n\n    r.table('users').max(lambda user:\n        user['points'] + user['bonus_points']\n    ).run(conn)\n\n*Example* What is the largest number of points any user has ever scored?\n\n    r.table('users').max('points')['points'].run(conn)\n\n*Example* Which user has scored the most points?  (But return\n`None` instead of erroring if no users have ever scored points.)\n\n    r.table('users').max('points').default(None).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.min, b"sequence.min([field_or_function]) -> element\n\nFinds the minimum of a sequence.  If called with a field name, finds\nthe element of that sequence with the smallest value in that field.\nIf called with a function, calls that function on every element of the\nsequence and returns the element which produced the smallest value,\nignoring any elements where the function returns `None` or produces a\nnon-existence error.\n\nProduces a non-existence error when called on an empty sequence.  You\ncan handle this case with `default`.\n\n*Example* What's the minimum of 3, 5, and 7?\n\n    r.expr([3, 5, 7]).min().run(conn)\n\n*Example* Which user has scored the fewest points?\n\n    r.table('users').min('points').run(conn)\n\n*Example* Which user has scored the fewest points, counting bonus points?\n\n    r.table('users').min(lambda user:\n        user['points'] + user['bonus_points']\n    ).run(conn)\n\n*Example* What is the smallest number of points any user has ever scored?\n\n    r.table('users').min('points')['points'].run(conn)\n\n*Example* Which user has scored the fewest points?  (But return\n`None` instead of erroring if no users have ever scored points.)\n\n    r.table('users').min('points').default(None).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.reduce, b'sequence.reduce(reduction_function) -> value\n\nProduce a single value from a sequence through repeated application of a reduction\nfunction.  \nThe reduction function can be called on:\n\n- two elements of the sequence\n- one element of the sequence and one result of a previous reduction\n- two results of previous reductions\n\nThe reduction function can be called on the results of two previous reductions because the\n`reduce` command is distributed and parallelized across shards and CPU cores. A common\nmistaken when using the `reduce` command is to suppose that the reduction is executed\nfrom left to right. Read the [map-reduce in RethinkDB](/docs/map-reduce/) article to\nsee an example.\n\nIf the sequence is empty, the server will produce a `RqlRuntimeError` that can be\ncaught with `default`.  \nIf the sequence has only one element, the first element will be returned.\n\n*Example* Return the number of documents in the table `posts`.\n\n    r.table("posts").map(lambda doc: 1)\n        .reduce(lambda left, right: left+right)\n        .default(0).run(conn)\n\nA shorter way to execute this query is to use [count](/api/python/count).\n\n*Example* Suppose that each `post` has a field `comments` that is an array of\ncomments.  \nReturn the number of comments for all posts.\n\n    r.table("posts").map(lambda doc:\n        doc["comments"].count()\n    ).reduce(lambda left, right:\n        left+right\n    ).default(0).run(conn)\n\n*Example* Suppose that each `post` has a field `comments` that is an array of\ncomments.  \nReturn the maximum number comments per post.\n\n    r.table("posts").map(lambda doc:\n        doc["comments"].count()\n    ).reduce(lambda left, right:\n        r.branch(\n            left > right,\n            left,\n            right\n        )\n    ).default(0).run(conn)\n\nA shorter way to execute this query is to use [max](/api/python/max).\n'),
	(rethinkdb.ast.RqlQuery.sum, b"sequence.sum([field_or_function]) -> number\n\nSums all the elements of a sequence.  If called with a field name,\nsums all the values of that field in the sequence, skipping elements\nof the sequence that lack that field.  If called with a function,\ncalls that function on every element of the sequence and sums the\nresults, skipping elements of the sequence where that function returns\n`None` or a non-existence error.\n\nReturns `0` when called on an empty sequence.\n\n*Example* What's 3 + 5 + 7?\n\n    r.expr([3, 5, 7]).sum().run(conn)\n\n*Example* How many points have been scored across all games?\n\n    r.table('games').sum('points').run(conn)\n\n*Example* How many points have been scored across all games,\ncounting bonus points?\n\n    r.table('games').sum(lambda game:\n        game['points'] + game['bonus_points']\n    ).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.ungroup, b'grouped_stream.ungroup() -> array\ngrouped_data.ungroup() -> array\n\nTakes a grouped stream or grouped data and turns it into an array of\nobjects representing the groups.  Any commands chained after `ungroup`\nwill operate on this array, rather than operating on each group\nindividually.  This is useful if you want to e.g. order the groups by\nthe value of their reduction.\n\nThe format of the array returned by `ungroup` is the same as the\ndefault native format of grouped data in the JavaScript driver and\ndata explorer.\n\n*Example* What is the maximum number of points scored by each\nplayer, with the highest scorers first?\n\nSuppose that the table `games` has the following data:\n\n    [\n        {"id": 2, "player": "Bob", "points": 15, "type": "ranked"},\n        {"id": 5, "player": "Alice", "points": 7, "type": "free"},\n        {"id": 11, "player": "Bob", "points": 10, "type": "free"},\n        {"id": 12, "player": "Alice", "points": 2, "type": "free"}\n    ]\n\nWe can use this query:\n\n    r.table(\'games\')\n       .group(\'player\').max(\'points\')[\'points\']\n       .ungroup().order_by(r.desc(\'reduction\')).run(conn)\n\nResult: \n\n    [\n        {\n            "group": "Bob",\n            "reduction": 15\n        },\n        {\n            "group": "Alice",\n            "reduction": 7\n        }\n    ]\n\n*Example* Select one random player and all their games.\n\n    r.table(\'games\').group(\'player\').ungroup().sample(1).run(conn)\n\nResult:\n\n    [\n        {\n            "group": "Bob",\n            "reduction": [\n                {"id": 2, "player": "Bob", "points": 15, "type": "ranked"},\n                {"id": 11, "player": "Bob", "points": 10, "type": "free"}\n            ]\n        }\n    ]\n\nNote that if you didn\'t call `ungroup`, you would instead select one\nrandom game from each player:\n\n    r.table(\'games\').group(\'player\').sample(1).run(conn)\n\nResult:\n\n    {\n        "Alice": [\n            {"id": 5, "player": "Alice", "points": 7, "type": "free"}\n        ],\n        "Bob": [\n            {"id": 11, "player": "Bob", "points": 10, "type": "free"}\n        ]\n    }\n\n*Example* Types!\n\n    r.table(\'games\').group(\'player\').type_of().run(conn) # Returns "GROUPED_STREAM"\n    r.table(\'games\').group(\'player\').ungroup().type_of().run(conn) # Returns "ARRAY"\n    r.table(\'games\').group(\'player\').avg(\'points\').run(conn) # Returns "GROUPED_DATA"\n    r.table(\'games\').group(\'player\').avg(\'points\').ungroup().run(conn) #Returns "ARRAY"\n'),
	(rethinkdb.args, b"r.args(array) -> special\n\n`r.args` is a special term that's used to splice an array of arguments\ninto another term.  This is useful when you want to call a variadic\nterm such as `get_all` with a set of arguments produced at runtime.\n\nThis is analogous to unpacking argument lists in Python.\n\n*Example* Get Alice and Bob from the table `people`.\n\n    r.table('people').get_all('Alice', 'Bob').run(conn)\n    # or\n    r.table('people').get_all(r.args(['Alice', 'Bob'])).run(conn)\n\n*Example* Get all of Alice's children from the table `people`.\n\n    # r.table('people').get('Alice') returns {'id': 'Alice', 'children': ['Bob', 'Carol']}\n    r.table('people').get_all(r.args(r.table('people').get('Alice')['children'])).run(conn)\n"),
	(rethinkdb.binary, b'r.binary(data) -> binary\n\nEncapsulate binary data within a query.\n\nThe type of data `binary` accepts depends on the client language. In Python, it expects a parameter of `bytes` type. Using a `bytes` object within a query implies the use of `binary` and the ReQL driver will automatically perform the coercion (in Python 3 only).\n\nBinary objects returned to the client in JavaScript will also be of the `bytes` type. This can be changed with the `binary_format` option provided to [run](/api/python/run) to return "raw" objects.\n\nOnly a limited subset of ReQL commands may be chained after `binary`:\n\n* [coerce_to](/api/python/coerce_to/) can coerce `binary` objects to `string` types\n* [count](/api/python/count/) will return the number of bytes in the object\n* [slice](/api/python/slice/) will treat bytes like array indexes (i.e., `slice(10,20)` will return bytes 10&ndash;19)\n* [type_of](/api/python/type_of) returns `PTYPE<BINARY>`\n* [info](/api/python/info) will return information on a binary object.\n\n*Example* Save an avatar image to a existing user record.\n\n    f = open(\'./default_avatar.png\', \'rb\')\n    avatar_image = f.read()\n    f.close()\n    r.table(\'users\').get(100).update({\'avatar\': r.binary(avatar_image)}).run(conn)\n\n*Example* Get the size of an existing avatar image.\n\n    r.table(\'users\').get(100)[\'avatar\'].count().run(conn)\n    \n    14156\n'),
	(rethinkdb.branch, b'r.branch(test, true_branch, false_branch) -> any\n\nIf the `test` expression returns `False` or `None`, the `false_branch` will be evaluated.\nOtherwise, the `true_branch` will be evaluated.\n   \nThe `branch` command is effectively an `if` renamed due to language constraints.\n\n*Example* Return heroes and superheroes.\n\n    r.table(\'marvel\').map(\n        r.branch(\n            r.row[\'victories\'] > 100,\n            r.row[\'name\'] + \' is a superhero\',\n            r.row[\'name\'] + \' is a hero\'\n        )\n    ).run(conn)\n\nIf the documents in the table `marvel` are:\n\n    [{\n        "name": "Iron Man",\n        "victories": 214\n    },\n    {\n        "name": "Jubilee",\n        "victories": 9\n    }]\n\nThe results will be:\n\n    [\n        "Iron Man is a superhero",\n        "Jubilee is a hero"\n    ]\n'),
	(rethinkdb.ast.RqlQuery.coerce_to, b"sequence.coerce_to('array') -> array\nvalue.coerce_to('string') -> string\nstring.coerce_to('number') -> number\narray.coerce_to('object') -> object\nobject.coerce_to('array') -> array\nbinary.coerce_to('string') -> string\nstring.coerce_to('binary') -> binary\n\nConvert a value of one type into another.\n\n* a sequence, selection or object can be coerced to an array\n* an array of key-value pairs can be coerced to an object\n* a string can be coerced to a number\n* any datum (single value) can be coerced to a string\n* a binary object can be coerced to a string and vice-versa\n\n*Example* Coerce a stream to an array to store its output in a field. (A stream cannot be stored in a field directly.)\n\n    r.table('posts').map(lambda post: post.merge(\n        { 'comments': r.table('comments').get_all(post['id'], index='post_id').coerce_to('array') }\n    )).run(conn)\n\n*Example* Coerce an array of pairs into an object.\n\n    r.expr([['name', 'Ironman'], ['victories', 2000]]).coerce_to('object').run(conn)\n\n__Note:__ To coerce a list of key-value pairs like `['name', 'Ironman', 'victories', 2000]` to an object, use the [object](/api/python/object) command.\n\n*Example* Coerce a number to a string.\n\n    r.expr(1).coerce_to('string').run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.default, b'value.default(default_value) -> any\nsequence.default(default_value) -> any\n\nHandle non-existence errors. Tries to evaluate and return its first argument. If an\nerror related to the absence of a value is thrown in the process, or if its first\nargument returns `None`, returns its second argument. (Alternatively, the second argument\nmay be a function which will be called with either the text of the non-existence error\nor `None`.)\n\n*Example* Suppose we want to retrieve the titles and authors of the table `posts`.\nIn the case where the author field is missing or `None`, we want to retrieve the string\n`Anonymous`.\n\n    r.table("posts").map(lambda post:\n        {\n            "title": post["title"],\n            "author": post["author"].default("Anonymous")\n        }\n    ).run(conn)\n\nWe can rewrite the previous query with `r.branch` too.\n\n    r.table("posts").map(lambda post:\n        r.branch(\n            post.has_fields("author"),\n            {\n                "title": post["title"],\n                "author": post["author"]\n            },\n            {\n                "title": post["title"],\n                "author": "Anonymous" \n            }\n        )\n    ).run(conn)\n\n*Example* The `default` command can be useful to filter documents too. Suppose\nwe want to retrieve all our users who are not grown-ups or whose age is unknown\n(i.e the field `age` is missing or equals `None`). We can do it with this query:\n\n    r.table("users").filter(lambda user:\n        (user["age"] < 18).default(True)\n    ).run(conn)\n\nOne more way to write the previous query is to set the age to be `-1` when the\nfield is missing.\n\n    r.table("users").filter(lambda user:\n        user["age"].default(-1) < 18\n    ).run(conn)\n\nOne last way to do the same query is to use `has_fields`.\n\n    r.table("users").filter(lambda user:\n        user.has_fields("age").not_() | (user["age"] < 18)\n    ).run(conn)\n\nThe body of every `filter` is wrapped in an implicit `.default(False)`. You can overwrite\nthe value `False` by passing an option in filter, so the previous query can also be\nwritten like this.\n\n    r.table("users").filter(\n        lambda user: (user["age"] < 18).default(True),\n        default=True\n    ).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.do, b"any.do(function) -> any\nr.do([args]*, function) -> any\nany.do(expr) -> any\nr.do([args]*, expr) -> any\n\nEvaluate an expression and pass its values as arguments to a function or to an expression.\n\nThe last argument to `do` (or, in some forms, the only argument) is an expression or an anonymous function which receives values from either the previous arguments or from prefixed commands chained before `do`. A common use, for example, would be to retrieve a document with `get` and pass it to a function via `do`. The type of `do`'s result is the type of the value returned from the function or last expression.\n\nArguments passed to the `do` function must be basic data types, and cannot be streams or selections. (Read about [ReQL data types](/docs/data-types/).) While the arguments will all be evaluated before the function is executed, they may be evaluated in any order, so their values should not be dependent on one another.\n\n*Example* Compute a golfer's net score for a game.\n\n    r.table('players').get('86be93eb-a112-48f5-a829-15b2cb49de1d').do(\n        lambda player: player['gross_score'] - player['course_handicap']\n    ).run(conn)\n\n*Example* Return the name of the best scoring player in a two-player golf match.\n\n    r.do(r.table('players').get(id1), r.table('players').get(id2),\n        (lambda player1, player2:\n            r.branch(player1['gross_score'].lt(player2['gross_score']),\n            player1, player2))\n    ).run(conn)\n    \n\nNote that `branch`, the ReQL conditional command, must be used instead of `if`. See the `branch` [documentation](/api/python/branch) for more.\n"),
	(rethinkdb.error, b"r.error(message) -> error\n\nThrow a runtime error. If called with no arguments inside the second argument to `default`, re-throw the current error.\n\n*Example* Iron Man can't possibly have lost a battle:\n\n    r.table('marvel').get('IronMan').do(\n        lambda ironman: r.branch(ironman['victories'] < ironman['battles'],\n                                 r.error('impossible code path'),\n                                 ironman)\n    ).run(conn)\n\n"),
	(rethinkdb.expr, b"r.expr(value) -> value\n\nConstruct a ReQL JSON object from a native object.\n\nIf the native object is of the `bytes` type, then `expr` will return a binary object. See [binary](/api/python/binary) for more information.\n\n*Example* Objects wrapped with expr can then be manipulated by ReQL API functions.\n\n    r.expr({'a':'b'}).merge({'b':[1,2,3]}).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.for_each, b"sequence.for_each(write_query) -> object\n\nLoop over a sequence, evaluating the given write query for each element.\n\n*Example* Now that our heroes have defeated their villains, we can safely remove them from the villain table.\n\n    r.table('marvel').for_each(\n        lambda hero: r.table('villains').get(hero['villainDefeated']).delete()\n    ).run(conn)\n\n"),
	(rethinkdb.http, b'r.http(url[, options]) -> value\nr.http(url[, options]) -> stream\n\nRetrieve data from the specified URL over HTTP.  The return type depends on the `result_format` option, which checks the `Content-Type` of the response by default.\n\n*Example* Perform an HTTP `GET` and store the result in a table.\n\n    r.table(\'posts\').insert(r.http(\'httpbin.org/get\')).run(conn)\n\nSee [the tutorial](/docs/external-api-access/) on `r.http` for more examples on how to use this command.\n\n* `timeout`: Number of seconds to wait before timing out and aborting the operation. Default: 30.\n\n* `reattempts`: An integer giving the number of attempts to make in cast of connection errors or potentially-temporary HTTP errors. Default: 5.\n\n* `redirects`: An integer giving the number of redirects and location headers to follow. Default: 1.\n\n* `verify`: Verify the server\'s SSL certificate, specified as a boolean. Default: True.\n\n* `result_format`: The format the result should be returned in. The values can be `\'text\'` (always return as a string), `\'json\'` (parse the result as JSON, raising an error if the parsing fails), `\'jsonp\'` (parse the result as [padded JSON](http://www.json-p.org/)), `\'binary\'` (return a binary object), or `\'auto\'` . The default is `\'auto\'`.\n\n    When `result_format` is `\'auto\'`, the response body will be parsed according to the `Content-Type` of the response:\n    * `application/json`: parse as `\'json\'`\n    * `application/json-p`, `text/json-p`, `text/javascript`: parse as `\'jsonp\'`\n    * `audio/*`, `video/*`, `image/*`, `application/octet-stream`: return a binary object\n    * Anything else: parse as `\'text\'`\n\n* `method`: HTTP method to use for the request. One of `GET`, `POST`, `PUT`, `PATCH`, `DELETE` or `HEAD`. Default: `GET`.\n\n* `auth`: Authentication information in the form of an object with key/value pairs indicating the authentication type (in the `type` key) and any required information. Types currently supported are `basic` and `digest` for HTTP Basic and HTTP Digest authentication respectively. If `type` is omitted, `basic` is assumed. Example:\n\n\t```py\n\tr.http(\'httpbin.org/basic-auth/fred/mxyzptlk\',\n           auth={ \'type\': \'basic\', \'user\': \'fred\', \'pass\': \'mxyzptlk\' }).run(conn)\n\t```\n\n* `params`: URL parameters to append to the URL as encoded key/value pairs, specified as an object. For example, `{ \'query\': \'banana\', \'limit\': 2 }` will be appended as `?query=banana&limit=2`. Default: none.\n\n* `header`: Extra header lines to include. The value may be an array of strings or an object. Default: none.\n\n    Unless specified otherwise, `r.http` will by default use the headers `Accept-Encoding: deflate=1;gzip=0.5` and `User-Agent: RethinkDB/VERSION`.\n\n* `data`: Data to send to the server on a `POST`, `PUT`, `PATCH`, or `DELETE` request.\n\n    For `PUT`, `PATCH` and `DELETE` requests, the value will be serialized to JSON and placed in the request body, and the `Content-Type` will be set to `application/json`.\n\n\tFor `POST` requests, data may be either an object or a string. Objects will be written to the body as form-encoded key/value pairs (values must be numbers, strings, or `None`). Strings will be put directly into the body.  If `data` is not a string or an object, an error will be thrown.\n\n    If `data` is not specified, no data will be sent.\n\n`r.http` supports depagination, which will request multiple pages in a row and aggregate the results into a stream.  The use of this feature is controlled by the optional arguments `page` and `page_limit`.  Either none or both of these arguments must be provided.\n\n* `page`: This option may specify either a built-in pagination strategy (as a string), or a function to provide the next URL and/or `params` to request.\n\n    At the moment, the only supported built-in is `\'link-next\'`, which is equivalent to `lambda info: info[\'header\'][\'link\'][\'rel="next"\'].default(None)`.\n\n    *Example* Perform a GitHub search and collect up to 3 pages of results.\n\n    ```py\n    r.http("https://api.github.com/search/code?q=addClass+user:mozilla",\n           page=\'link-next\', page_limit=3).run(conn)\n    ```\n\n    As a function, `page` takes one parameter, an object of the format:\n\n    ```py\n    {\n        \'params\': object, # the URL parameters used in the last request\n        \'header\': object, # the HTTP headers of the last response as key/value pairs\n        \'body\': value # the body of the last response in the format specified by `result_format`\n    }\n    ```\n\n    The `header` field will be a parsed version of the header with fields lowercased, like so:\n\n    ```py\n    {\n        \'content-length\': \'1024\',\n        \'content-type\': \'application/json\',\n        \'date\': \'Thu, 1 Jan 1970 00:00:00 GMT\',\n        \'link\': {\n            \'rel="last"\': \'http://example.com/?page=34\',\n            \'rel="next"\': \'http://example.com/?page=2\'\n        }\n    }\n    ```\n\n    The `page` function may return a string corresponding to the next URL to request, `None` indicating that there is no more to get, or an object of the format:\n\n    ```py\n    {\n        \'url\': string, # the next URL to request, or None for no more pages\n        \'params\': object # new URL parameters to use, will be merged with the previous request\'s params\n    }\n    ```\n\n* `page_limit`: An integer specifying the maximum number of requests to issue using the `page` functionality.  This is to prevent overuse of API quotas, and must be specified with `page`.\n    * `-1`: no limit\n    * `0`: no requests will be made, an empty stream will be returned\n    * `n`: `n` requests will be made\n\n# Examples\n\n*Example* Perform multiple requests with different parameters.\n\n    r.expr([1, 2, 3]).map(lambda i: r.http(\'httpbin.org/get\',\n                                           params={ \'user\': i })).run(conn)\n\n*Example* Perform a `PUT` request for each item in a table.\n\n    r.table(\'data\').map(lambda row: r.http(\'httpbin.org/put\',\n                                           method=\'PUT\', data=row)).run(conn)\n\n*Example* Perform a `POST` request with accompanying data.\n\nUsing form-encoded data:\n\n    r.http(\'httpbin.org/post\',\n           method=\'POST\',\n           data={ \'player\': \'Bob\', \'game\': \'tic tac toe\' }).run(conn)\n\nUsing JSON data:\n\n    r.http(\'httpbin.org/post\',\n           method=\'POST\',\n           data=r.expr(value).coerce_to(\'string\'),\n           header={ \'Content-Type\': \'application/json\' }).run(conn)\n\n*Example* Perform depagination with a custom `page` function.\n\n    r.http(\'example.com/pages\',\n           page=lambda info: info[\'body\'][\'meta\'][\'next\'].default(None),\n           page_limit=5).run(conn)\n\n# Learn more\n\nSee [the tutorial](/docs/external-api-access/) on `r.http` for more examples on how to use this command.\n'),
	(rethinkdb.ast.RqlQuery.info, b"any.info() -> object\n\nGet information about a ReQL value.\n\n*Example* Get information about a table such as primary key, or cache size.\n\n    r.table('marvel').info().run(conn)\n\n"),
	(rethinkdb.js, b'r.js(js_string[, timeout=<number>]) -> value\n\nCreate a javascript expression.\n\n*Example* Concatenate two strings using Javascript\'\n\n`timeout` is the number of seconds before `r.js` times out. The default value is 5 seconds.\n\n    r.js("\'str1\' + \'str2\'").run(conn)\n\n*Example* Select all documents where the \'magazines\' field is greater than 5 by running Javascript on the server.\n\n    r.table(\'marvel\').filter(\n        r.js(\'(function (row) { return row.magazines.length > 5; })\')\n    ).run(conn)\n\n*Example* You may also specify a timeout in seconds (defaults to 5).\n\n    r.js(\'while(true) {}\', timeout=1.3).run(conn)\n\n'),
	(rethinkdb.json, b'r.json(json_string) -> value\n\nParse a JSON string on the server.\n\n*Example* Send an array to the server\'\n\n    r.json("[1,2,3]").run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.type_of, b'any.type_of() -> string\n\nGets the type of a value.\n\n*Example* Get the type of a string.\n\n    r.expr("foo").type_of().run(conn)\n\n'),
	(rethinkdb.net.Cursor.close, b'cursor.close()\n\nClose a cursor. Closing a cursor cancels the corresponding query and frees the memory\nassociated with the open request.\n\n*Example* Close a cursor.\n\n    cursor.close()\n'),
	(rethinkdb.ast.RqlQuery.date, b'time.date() -> time\n\nReturn a new time object only based on the day, month and year (ie. the same day at 00:00).\n\n*Example* Retrieve all the users whose birthday is today\n\n    r.table("users").filter(lambda user:\n        user["birthdate"].date() == r.now().date()\n    ).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.day, b'time.day() -> number\n\nReturn the day of a time object as a number between 1 and 31.\n\n*Example* Return the users born on the 24th of any month.\n\n    r.table("users").filter(\n        r.row["birthdate"].day() == 24\n    )\n\n'),
	(rethinkdb.ast.RqlQuery.day_of_week, b'time.day_of_week() -> number\n\nReturn the day of week of a time object as a number between 1 and 7 (following ISO 8601 standard). For your convenience, the terms r.monday, r.tuesday etc. are defined and map to the appropriate integer.\n\n*Example* Return today\'s day of week.\n\n    r.now().day_of_week().run(conn)\n\n*Example* Retrieve all the users who were born on a Tuesday.\n\n    r.table("users").filter{ |user|\n        user["birthdate"].day_of_week().eq(r.tuesday)\n    }\n\n'),
	(rethinkdb.ast.RqlQuery.day_of_year, b'time.day_of_year() -> number\n\nReturn the day of the year of a time object as a number between 1 and 366 (following ISO 8601 standard).\n\n*Example* Retrieve all the users who were born the first day of a year.\n\n    r.table("users").filter(\n        r.row["birthdate"].day_of_year() == 1\n    ).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.during, b'time.during(start_time, end_time[, left_bound="closed", right_bound="open"])\n    -> bool\n\nReturn whether a time is between two other times. By default, this is inclusive of the start time and exclusive of the end time. Set `left_bound` and `right_bound` to explicitly include (`closed`) or exclude (`open`) that endpoint of the range.\n\n*Example* Retrieve all the posts that were posted between December 1st, 2013 (inclusive) and December 10th, 2013 (exclusive).\n\n    r.table("posts").filter(\n        r.row[\'date\'].during(r.time(2013, 12, 1, "Z"), r.time(2013, 12, 10, "Z"))\n    ).run(conn)\n\n*Example* Retrieve all the posts that were posted between December 1st, 2013 (exclusive) and December 10th, 2013 (inclusive).\n\n    r.table("posts").filter(\n        r.row[\'date\'].during(r.time(2013, 12, 1, "Z"), r.time(2013, 12, 10, "Z"), left_bound="open", right_bound="closed")\n    ).run(conn)\n\n'),
	(rethinkdb.epoch_time, b'r.epoch_time(epoch_time) -> time\n\nCreate a time object based on seconds since epoch. The first argument is a double and\nwill be rounded to three decimal places (millisecond-precision).\n\n*Example* Update the birthdate of the user "John" to November 3rd, 1986.\n\n    r.table("user").get("John").update({"birthdate": r.epoch_time(531360000)}).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.hours, b'time.hours() -> number\n\nReturn the hour in a time object as a number between 0 and 23.\n\n*Example* Return all the posts submitted after midnight and before 4am.\n\n    r.table("posts").filter(lambda post:\n        post["date"].hours() < 4\n    ).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.in_timezone, b"time.in_timezone(timezone) -> time\n\nReturn a new time object with a different timezone. While the time stays the same, the results returned by methods such as hours() will change since they take the timezone into account. The timezone argument has to be of the ISO 8601 format.\n\n*Example* Hour of the day in San Francisco (UTC/GMT -8, without daylight saving time).\n\n    r.now().in_timezone('-08:00').hours().run(conn)\n"),
	(rethinkdb.iso8601, b'r.iso8601(iso8601Date[, default_timezone=\'\']) -> time\n\nCreate a time object based on an ISO 8601 date-time string (e.g. \'2013-01-01T01:01:01+00:00\'). We support all valid ISO 8601 formats except for week dates. If you pass an ISO 8601 date-time without a time zone, you must specify the time zone with the `default_timezone` argument. Read more about the ISO 8601 format at [Wikipedia](http://en.wikipedia.org/wiki/ISO_8601).\n\n*Example* Update the time of John\'s birth.\n\n    r.table("user").get("John").update({"birth": r.iso8601(\'1986-11-03T08:30:00-07:00\')}).run(conn)\n'),
	(rethinkdb.ast.RqlQuery.minutes, b'time.minutes() -> number\n\nReturn the minute in a time object as a number between 0 and 59.\n\n*Example* Return all the posts submitted during the first 10 minutes of every hour.\n\n    r.table("posts").filter(lambda post:\n        post["date"].minutes() < 10\n    ).run(conn)\n'),
	(rethinkdb.ast.RqlQuery.month, b'time.month() -> number\n\nReturn the month of a time object as a number between 1 and 12. For your convenience, the terms r.january, r.february etc. are defined and map to the appropriate integer.\n\n*Example* Retrieve all the users who were born in November.\n\n    r.table("users").filter(\n        r.row["birthdate"].month() == 11\n    )\n\n*Example* Retrieve all the users who were born in November.\n\n    r.table("users").filter(\n        r.row["birthdate"].month() == r.november\n    )\n\n'),
	(rethinkdb.now, b'r.now() -> time\n\nReturn a time object representing the current time in UTC. The command now() is computed once when the server receives the query, so multiple instances of r.now() will always return the same time inside a query.\n\n*Example* Add a new user with the time at which he subscribed.\n\n    r.table("users").insert({\n        "name": "John",\n        "subscription_date": r.now()\n    }).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.seconds, b'time.seconds() -> number\n\nReturn the seconds in a time object as a number between 0 and 59.999 (double precision).\n\n*Example* Return the post submitted during the first 30 seconds of every minute.\n\n    r.table("posts").filter(lambda post:\n        post["date"].seconds() < 30\n    ).run(conn)\n\n'),
	(rethinkdb.time, b'r.time(year, month, day[, hour, minute, second], timezone)\n    -> time\n\nCreate a time object for a specific time.\n\nA few restrictions exist on the arguments:\n\n- `year` is an integer between 1400 and 9,999.\n- `month` is an integer between 1 and 12.\n- `day` is an integer between 1 and 31.\n- `hour` is an integer.\n- `minutes` is an integer.\n- `seconds` is a double. Its value will be rounded to three decimal places\n(millisecond-precision).\n- `timezone` can be `\'Z\'` (for UTC) or a string with the format `\xc2\xb1[hh]:[mm]`.\n\n*Example* Update the birthdate of the user "John" to November 3rd, 1986 UTC.\n\n    r.table("user").get("John").update({"birthdate": r.time(1986, 11, 3, \'Z\')}).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.time_of_day, b'time.time_of_day() -> number\n\nReturn the number of seconds elapsed since the beginning of the day stored in the time object.\n\n*Example* Retrieve posts that were submitted before noon.\n\n    r.table("posts").filter(\n        r.row["date"].time_of_day() <= 12*60*60\n    ).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.timezone, b'time.timezone() -> string\n\nReturn the timezone of the time object.\n\n*Example* Return all the users in the "-07:00" timezone.\n\n    r.table("users").filter(lambda user:\n        user["subscriptionDate"].timezone() == "-07:00"\n    )\n\n'),
	(rethinkdb.ast.RqlQuery.to_epoch_time, b'time.to_epoch_time() -> number\n\nConvert a time object to its epoch time.\n\n*Example* Return the current time in seconds since the Unix Epoch with millisecond-precision.\n\n    r.now().to_epoch_time()\n\n'),
	(rethinkdb.ast.RqlQuery.to_iso8601, b'time.to_iso8601() -> number\n\nConvert a time object to its iso 8601 format.\n\n*Example* Return the current time in an ISO8601 format.\n\n    r.now().to_iso8601()\n\n'),
	(rethinkdb.ast.RqlQuery.year, b'time.year() -> number\n\nReturn the year of a time object.\n\n*Example* Retrieve all the users born in 1986.\n\n    r.table("users").filter(lambda user:\n        user["birthdate"].year() == 1986\n    ).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.append, b"array.append(value) -> array\n\nAppend a value to an array.\n\n*Example* Retrieve Iron Man's equipment list with the addition of some new boots.\n\n    r.table('marvel').get('IronMan')['equipment'].append('newBoots').run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.change_at, b'array.change_at(index, value) -> array\n\nChange a value in an array at a given index. Returns the modified array.\n\n*Example* Bruce Banner hulks out.\n\n    r.expr(["Iron Man", "Bruce", "Spider-Man"]).change_at(1, "Hulk").run(conn)\n'),
	(rethinkdb.ast.RqlQuery.delete_at, b"array.delete_at(index [,endIndex]) -> array\n\nRemove one or more elements from an array at a given index. Returns the modified array. (Note: `delete_at` operates on arrays, not documents; to delete documents, see the [delete](/api/python/delete) command.)\n\nIf only `index` is specified, `delete_at` removes the element at that index. If both `index` and `end_index` are specified, `delete_at` removes the range of elements between `index` and `end_index`, inclusive of `index` but not inclusive of `end_index`.\n\nIf `end_index` is specified, it must not be less than `index`. Both `index` and `end_index` must be within the array's bounds (i.e., if the array has 10 elements, an `index` or `end_index` of 10 or higher is invalid).\n\nBy using a negative `index` you can delete from the end of the array. `-1` is the last element in the array, `-2` is the second-to-last element, and so on. You may specify a negative `end_index`, although just as with a positive value, this will not be inclusive. The range `(2,-1)` specifies the third element through the next-to-last element.\n\n*Example* Delete the second element of an array.\n\n    > r.expr(['a','b','c','d','e','f']).delete_at(1).run(conn)\n    \n    ['a', 'c', 'd', 'e', 'f']\n\n*Example* Delete the second and third elements of an array.\n\n    > r.expr(['a','b','c','d','e','f']).delete_at(1,3).run(conn)\n    \n    ['a', 'd', 'e', 'f']\n\n*Example* Delete the next-to-last element of an array.\n\n    > r.expr(['a','b','c','d','e','f']).delete_at(-2).run(conn)\n    \n    ['a', 'b', 'c', 'd', 'f']\n\n*Example* Delete a comment on a post.\n\nGiven a post document such as:\n\n{\n    id: '4cf47834-b6f9-438f-9dec-74087e84eb63',\n    title: 'Post title',\n    author: 'Bob',\n    comments: [\n        { author: 'Agatha', text: 'Comment 1' },\n        { author: 'Fred', text: 'Comment 2' }\n    ]\n}\n\nThe second comment can be deleted by using `update` and `delete_at` together.\n\n    r.table('posts').get('4cf47834-b6f9-438f-9dec-74087e84eb63').update(\n        lambda post: { 'comments': post['comments'].delete_at(1) }\n    ).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.difference, b"array.difference(array) -> array\n\nRemove the elements of one array from another array.\n\n*Example* Retrieve Iron Man's equipment list without boots.\n\n    r.table('marvel').get('IronMan')['equipment'].difference(['Boots']).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.__getitem__, b"sequence[attr] -> sequence\nsingleSelection[attr] -> value\nobject[attr] -> value\n\nGet a single field from an object. If called on a sequence, gets that field from every\nobject in the sequence, skipping objects that lack it.\n\n*Example* What was Iron Man's first appearance in a comic?\n\n    r.table('marvel').get('IronMan')['firstAppearance'].run(conn)\n"),
	(rethinkdb.ast.RqlQuery.has_fields, b'sequence.has_fields([selector1, selector2...]) -> stream\narray.has_fields([selector1, selector2...]) -> array\nobject.has_fields([selector1, selector2...]) -> boolean\n\nTest if an object has one or more fields. An object has a field if it has that key and the key has a non-null value. For instance, the object `{\'a\': 1,\'b\': 2,\'c\': null}` has the fields `a` and `b`.\n\nWhen applied to a single object, `has_fields` returns `true` if the object has the fields and `false` if it does not. When applied to a sequence, it will return a new sequence (an array or stream) containing the elements that have the specified fields.\n\n*Example* Return the players who have won games.\n\n    r.table(\'players\').has_fields(\'games_won\').run(conn)\n\n*Example* Test if a specific player has won any games.\n\n    r.table(\'players\').get(\n        \'b5ec9714-837e-400c-aa74-dbd35c9a7c4c\').has_fields(\'games_won\').run(conn)\n\n**Nested Fields**\n\n`has_fields` lets you test for nested fields in objects. If the value of a field is itself a set of key/value pairs, you can test for the presence of specific keys.\n\n*Example* In the `players` table, the `games_won` field contains one or more fields for kinds of games won:\n\n    {\n        \'games_won\': {\n            \'playoffs\': 2,\n            \'championships\': 1\n        }\n    }\n\nReturn players who have the "championships" field.\n\n    r.table(\'players\').has_fields({\'games_won\': {\'championships\': true}}).run(conn)\n\nNote that `true` in the example above is testing for the existence of `championships` as a field, not testing to see if the value of the `championships` field is set to `true`. There\'s a more convenient shorthand form available. (See [pluck](/api/python/pluck) for more details on this.)\n\n    r.table(\'players\').has_fields({\'games_won\': \'championships\'}).run(conn)\n'),
	(rethinkdb.ast.RqlQuery.insert_at, b'array.insert_at(index, value) -> array\n\nInsert a value in to an array at a given index. Returns the modified array.\n\n*Example* Hulk decides to join the avengers.\n\n    r.expr(["Iron Man", "Spider-Man"]).insert_at(1, "Hulk").run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.keys, b"singleSelection.keys() -> array\nobject.keys() -> array\n\nReturn an array containing all of the object's keys.\n\n*Example* Get all the keys of a row.\n\n    r.table('marvel').get('ironman').keys().run(conn)\n\n"),
	(rethinkdb.literal, b'r.literal(object) -> special\n\nReplace an object in a field instead of merging it with an existing object in a `merge` or `update` operation.\n\n*Example* Replace one nested document with another rather than merging the fields.\n\nAssume your users table has this structure:\n\n    [\n        {\n            "id": 1,\n            "name": "Alice",\n            "data": {\n                "age": 18,\n                "city": "Dallas"\n            }\n        }       \n        ...\n    ]\n\nUsing `update` to modify the `data` field will normally merge the nested documents:\n\n    r.table(\'users\').get(1).update({ \'data\': { \'age\': 19, \'job\': \'Engineer\' } }).run(conn)\n\nResult:\n\n    {\n        "id": 1,\n        "name": "Alice",\n        "data": {\n            "age": 19,\n            "city": "Dallas",\n            "job": "Engineer"\n        }\n    }       \n\nThat will preserve `city` and other existing fields. But to replace the entire `data` document with a new object, use `literal`:\n\n    r.table(\'users\').get(1).update({ \'data\': r.literal({ \'age\': 19, \'job\': \'Engineer\' }) }).run(conn)\n\nResult:\n\n    {\n        "id": 1,\n        "name": "Alice",\n        "data": {\n            "age": 19,\n            "job": "Engineer"\n        }\n    }       \n'),
	(rethinkdb.ast.RqlQuery.merge, b"singleSelection.merge(object) -> object\nobject.merge(object) -> object\nsequence.merge(object) -> stream\narray.merge(object) -> array\n\nMerge two objects together to construct a new object with properties from both. Gives preference to attributes from other when there is a conflict.\n\n*Example* Equip IronMan for battle.\n\n    r.table('marvel').get('IronMan').merge(\n        r.table('loadouts').get('alienInvasionKit')\n    ).run(conn)\n\n*Example* Merge can be used recursively to modify object within objects.\n\n    r.expr({'weapons' : {'spectacular graviton beam' : {'dmg' : 10, 'cooldown' : 20}}}).merge(\n        {'weapons' : {'spectacular graviton beam' : {'dmg' : 10}}}\n    ).run(conn)\n\n*Example* To replace a nested object with another object you can use the literal keyword.\n\n    r.expr({'weapons' : {'spectacular graviton beam' : {'dmg' : 10, 'cooldown' : 20}}}).merge(\n        {'weapons' : r.literal({'repulsor rays' : {'dmg' : 3, 'cooldown' : 0}})}\n    ).run(conn)\n\n*Example* Literal can be used to remove keys from an object as well.\n\n    r.expr({'weapons' : {'spectacular graviton beam' : {'dmg' : 10, 'cooldown' : 20}}}).merge(\n        {'weapons' : {'spectacular graviton beam' : r.literal()}}\n    ).run(conn)\n\n"),
	(rethinkdb.object, b'r.object([key, value,]...) -> object\n\nCreates an object from a list of key-value pairs, where the keys must\nbe strings.  `r.object(A, B, C, D)` is equivalent to\n`r.expr([[A, B], [C, D]]).coerce_to(\'OBJECT\')`.\n\n*Example* Create a simple object.\n\n    > r.object(\'id\', 5, \'data\', [\'foo\', \'bar\']).run(conn)\n    {\'data\': ["foo", "bar"], \'id\': 5}\n'),
	(rethinkdb.ast.RqlQuery.pluck, b"sequence.pluck([selector1, selector2...]) -> stream\narray.pluck([selector1, selector2...]) -> array\nobject.pluck([selector1, selector2...]) -> object\nsingleSelection.pluck([selector1, selector2...]) -> object\n\nPlucks out one or more attributes from either an object or a sequence of objects\n(projection).\n\n*Example* We just need information about IronMan's reactor and not the rest of the\ndocument.\n\n    r.table('marvel').get('IronMan').pluck('reactorState', 'reactorPower').run(conn)\n\n*Example* For the hero beauty contest we only care about certain qualities.\n\n    r.table('marvel').pluck('beauty', 'muscleTone', 'charm').run(conn)\n\n*Example* Pluck can also be used on nested objects.\n\n    r.table('marvel').pluck({'abilities' : {'damage' : True, 'mana_cost' : True}, 'weapons' : True}).run(conn)\n\n*Example* The nested syntax can quickly become overly verbose so there's a shorthand\nfor it.\n\n    r.table('marvel').pluck({'abilities' : ['damage', 'mana_cost']}, 'weapons').run(conn)\n\nFor more information read the [nested field documentation](/docs/nested-fields/).\n"),
	(rethinkdb.ast.RqlQuery.prepend, b"array.prepend(value) -> array\n\nPrepend a value to an array.\n\n*Example* Retrieve Iron Man's equipment list with the addition of some new boots.\n\n    r.table('marvel').get('IronMan')['equipment'].prepend('newBoots').run(conn)\n"),
	(rethinkdb.row, b"r.row -> value\n\nReturns the currently visited document.\n\n*Example* Get all users whose age is greater than 5.\n\n    r.table('users').filter(r.row['age'] > 5).run(conn)\n\n*Example* Accessing the attribute 'child' of an embedded document.\n\n    r.table('users').filter(r.row['embedded_doc']['child'] > 5).run(conn)\n\n*Example* Add 1 to every element of an array.\n\n    r.expr([1, 2, 3]).map(r.row + 1).run(conn)\n\n*Example* For nested queries functions should be used instead of r.row.\n\n    r.table('users').filter(\n        lambda doc: doc['name'] == r.table('prizes').get('winner')\n    ).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.set_difference, b"array.set_difference(array) -> array\n\nRemove the elements of one array from another and return them as a set (an array with\ndistinct values).\n\n*Example* Check which pieces of equipment Iron Man has, excluding a fixed list.\n\n    r.table('marvel').get('IronMan')['equipment'].set_difference(['newBoots', 'arc_reactor']).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.set_insert, b"array.set_insert(value) -> array\n\nAdd a value to an array and return it as a set (an array with distinct values).\n\n*Example* Retrieve Iron Man's equipment list with the addition of some new boots.\n\n    r.table('marvel').get('IronMan')['equipment'].set_insert('newBoots').run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.set_intersection, b"array.set_intersection(array) -> array\n\nIntersect two arrays returning values that occur in both of them as a set (an array with\ndistinct values).\n\n*Example* Check which pieces of equipment Iron Man has from a fixed list.\n\n    r.table('marvel').get('IronMan')['equipment'].set_intersection(['newBoots', 'arc_reactor']).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.set_union, b"array.set_union(array) -> array\n\nAdd a several values to an array and return it as a set (an array with distinct values).\n\n*Example* Retrieve Iron Man's equipment list with the addition of some new boots and an arc reactor.\n\n    r.table('marvel').get('IronMan')['equipment'].set_union(['newBoots', 'arc_reactor']).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.splice_at, b'array.splice_at(index, array) -> array\n\nInsert several values in to an array at a given index. Returns the modified array.\n\n*Example* Hulk and Thor decide to join the avengers.\n\n    r.expr(["Iron Man", "Spider-Man"]).splice_at(1, ["Hulk", "Thor"]).run(conn)\n'),
	(rethinkdb.ast.RqlQuery.without, b"sequence.without([selector1, selector2...]) -> stream\narray.without([selector1, selector2...]) -> array\nsingleSelection.without([selector1, selector2...]) -> object\nobject.without([selector1, selector2...]) -> object\n\nThe opposite of pluck; takes an object or a sequence of objects, and returns them with\nthe specified paths removed.\n\n*Example* Since we don't need it for this computation we'll save bandwidth and leave\nout the list of IronMan's romantic conquests.\n\n    r.table('marvel').get('IronMan').without('personalVictoriesList').run(conn)\n\n*Example* Without their prized weapons, our enemies will quickly be vanquished.\n\n    r.table('enemies').without('weapons').run(conn)\n\n*Example* Nested objects can be used to remove the damage subfield from the weapons and abilities fields.\n\n    r.table('marvel').without({'weapons' : {'damage' : True}, 'abilities' : {'damage' : True}}).run(conn)\n\n*Example* The nested syntax can quickly become overly verbose so there's a shorthand for it.\n\n    r.table('marvel').without({'weapons' : 'damage', 'abilities' : 'damage'}).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.eq_join, b'sequence.eq_join(left_field, right_table[, index=\'id\']) -> sequence\n\nJoin tables using a field on the left-hand sequence matching primary keys or secondary indexes on the right-hand table. `eq_join` is more efficient than other Re_qL join types, and operates much faster. Documents in the result set consist of pairs of left-hand and right-hand documents, matched when the field on the left-hand side exists and is non-null and an entry with that field\'s value exists in the specified index on the right-hand side.\n\nThe result set of `eq_join` is a stream or array of objects. Each object in the returned set will be an object of the form `{ left: <left-document>, right: <right-document> }`, where the values of `left` and `right` will be the joined documents. Use the <code><a href="/api/python/zip/">zip</a></code> command to merge the `left` and `right` fields together.\n\n**Example:** Match players with the games they\'ve played against one another.\n\nThe players table contains these documents:\n\n    [\n        { \'id\': 1, \'player\': \'George\', \'gameId\': 1 },\n        { \'id\': 2, \'player\': \'Agatha\', \'gameId\': 3 },\n        { \'id\': 3, \'player\': \'Fred\', \'gameId\': 2 },\n        { \'id\': 4, \'player\': \'Marie\', \'gameId\': 2 },\n        { \'id\': 5, \'player\': \'Earnest\', \'gameId\': 1 },\n        { \'id\': 6, \'player\': \'Beth\', \'gameId\': 3 }\n    ]\n\nThe games table contains these documents:\n\n    [\n        { \'id\': 1, \'field\': \'Little Delving\' },\n        { \'id\': 2, \'field\': \'Rushock Bog\' },\n        { \'id\': 3, \'field\': \'Bucklebury\' }\n    ]\n\nJoin these tables using `game_id` on the player table and `id` on the games table:\n\n    r.table(\'players\').eq_join(\'game_id\', r.table(\'games\')).run(conn)\n\nThis will return a result set such as the following:\n\n    [\n        {\n            "left" : { "gameId" : 3, "id" : 2, "player" : "Agatha" },\n            "right" : { "id" : 3, "field" : "Bucklebury" }\n        },\n        {\n            "left" : { "gameId" : 2, "id" : 3, "player" : "Fred" },\n            "right" : { "id" : 2, "field" : "Rushock Bog" }\n        },\n        ...\n    ]\n\nWhat you likely want is the result of using `zip` with that. For clarity, we\'ll use `without` to drop the `id` field from the games table (it conflicts with the `id` field for the players and it\'s redundant anyway), and we\'ll order it by the games.\n\n    r.table(\'players\').eq_join(\'game_id\', r.table(\'games\')).without({\'right\': "id"}).zip().order_by(\'game_id\').run(conn)\n    \n    [\n        { "field": "Little Delving", "gameId": 1, "id": 5, "player": "Earnest" },\n        { "field": "Little Delving", "gameId": 1, "id": 1, "player": "George" },\n        { "field": "Rushock Bog", "gameId": 2, "id": 3, "player": "Fred" },\n        { "field": "Rushock Bog", "gameId": 2, "id": 4, "player": "Marie" },\n        { "field": "Bucklebury", "gameId": 3, "id": 6, "player": "Beth" },\n        { "field": "Bucklebury", "gameId": 3, "id": 2, "player": "Agatha" }\n    ]\n\nFor more information, see [Table joins in Rethink_dB](/docs/table-joins/).\n\n**Example:** Use a secondary index on the right table rather than the primary key. If players have a secondary index on their cities, we can get a list of arenas with players in the same area.\n\n    r.table(\'arenas\').eq_join(\'city_id\', r.table(\'arenas\'), index=\'city_id\').run(conn)\n\n**Example:** Use a nested key as the join field. Suppose the documents in the players table were structured like this:\n\n    { \'id\': 1, \'player\': \'George\', \'game\': {\'id\': 1} },\n    { \'id\': 2, \'player\': \'Agatha\', \'game\': {\'id\': 3} },\n    ...\n\nSimply specify the field using the `row` command instead of a string.\n\n    r.table(\'players\').eq_join(r.row[\'game\'][\'id\'], r.table(\'games\')).without({\'right\': \'id\'}).zip().run(conn)\n    \n    [\n        { "field": "Little Delving", "game": { "id": 1 }, "id": 5, "player": "Earnest" },\n        { "field": "Little Delving", "game": { "id": 1 }, "id": 1, "player": "George" },\n        ...\n    ]\n\n**Example:** Use a function instead of a field to join on a more complicated expression. Suppose the players have lists of favorite games ranked in order in a field such as `"favorites": [3, 2, 1]`. Get a list of players and their top favorite:\n\n    r.table(\'players3\').eq_join(\n        lambda player: player[\'favorites\'].nth(0),\n        r.table(\'games\')\n    ).without([{\'left\': [\'favorites\', \'game_id\', \'id\']}, {\'right\': \'id\'}]).zip()\n\nResult:\n\n    [\n    \t{ "field": "Rushock Bog", "name": "Fred" },\n    \t{ "field": "Little Delving", "name": "George" },\n    \t...\n    ]\n'),
	(rethinkdb.ast.RqlQuery.inner_join, b"sequence.inner_join(other_sequence, predicate) -> stream\narray.inner_join(other_sequence, predicate) -> array\n\nReturns the inner product of two sequences (e.g. a table, a filter result) filtered by the predicate function. The query compares each row of the left sequence with each row of the right sequence to find all pairs of rows which satisfy the predicate. When the predicate is satisfied, each matched pair of rows of both sequences are combined into a result row. In most cases, you will want to follow the join with [zip](/api/python/zip) to combine the left and right results.\n\nNote that `inner_join` is slower and much less efficient than using [eq_join](/api/python/eq_join/) or [concat_map](/api/python/concat_map/) with [get_all](/api/python/get_all/). You should avoid using `inner_join` in commands when possible.\n\n*Example* Construct a sequence of documents containing all cross-universe matchups where a marvel hero would lose.\n\n    r.table('marvel').inner_join(r.table('dc'), lambda marvelRow, dcRow:\n        marvelRow['strength'] < dcRow['strength']).zip().run(conn)\n"),
	(rethinkdb.ast.RqlQuery.outer_join, b"sequence.outer_join(other_sequence, predicate) -> stream\narray.outer_join(other_sequence, predicate) -> array\n\nReturns the outer product of two sequences (e.g. a table, a filter result). The query returns each row of the left sequence paired with each row of the right sequence that satisfies the predicate function. In most cases, you will want to follow the join with [zip](/api/python/zip) to combine the left and right results.\n\nNote that `outer_join` is slower and much less efficient than using [concat_map](/api/python/concat_map/) with [get_all](/api/python/get_all). You should avoid using `outer_join` in commands when possible.\n\n*Example* Construct a sequence of documents containing all cross-universe matchups\nwhere a Marvel hero would lose, but keep Marvel heroes who would never lose a matchup in\nthe sequence.\n\n    r.table('marvel').outer_join(r.table('dc'),\n      lambda marvelRow, dcRow: marvelRow['strength'] < dcRow['strength']).zip().run(conn)\n"),
	(rethinkdb.ast.RqlQuery.zip, b"stream.zip() -> stream\narray.zip() -> array\n\nUsed to 'zip' up the result of a join by merging the 'right' fields into 'left' fields of each member of the sequence.\n\n*Example* 'zips up' the sequence by merging the left and right fields produced by a join.\n\n    r.table('marvel').eq_join('main_dc_collaborator', r.table('dc')).zip().run(conn)\n"),
	(rethinkdb.db_create, b'r.db_create(db_name) -> object\n\nCreate a database. A RethinkDB database is a collection of tables, similar to\nrelational databases.\n\nIf successful, the operation returns an object: `{"created": 1}`. If a database with the\nsame name already exists the operation throws `RqlRuntimeError`.\n\nNote: that you can only use alphanumeric characters and underscores for the database name.\n\n*Example* Create a database named \'superheroes\'.\n\n    r.db_create(\'superheroes\').run(conn)\n\n'),
	(rethinkdb.db_drop, b'r.db_drop(db_name) -> object\n\nDrop a database. The database, all its tables, and corresponding data will be deleted.\n\nIf successful, the operation returns the object `{"dropped": 1}`. If the specified database\ndoesn\'t exist a `RqlRuntimeError` is thrown.\n\n*Example* Drop a database named \'superheroes\'.\n\n    r.db_drop(\'superheroes\').run(conn)\n\n'),
	(rethinkdb.db_list, b'r.db_list() -> array\n\nList all database names in the system. The result is a list of strings.\n\n*Example* List all databases.\n\n    r.db_list().run(conn)\n\n'),
	(rethinkdb.ast.Table.changes, b'table.changes() -> stream\n\nReturn an infinite stream of objects representing changes to a table. Whenever an `insert`, `delete`, `update` or `replace` is performed on the table, an object of the form `{\'old_val\': ..., \'new_val\': ...}` will be appended to the stream. For an `insert`, `old_val` will be `null`, and for a `delete`, `new_val` will be `null`.\n\nThe server will buffer up to 100,000 elements. If the buffer limit is hit, early changes will be discarded, and the client will receive an object of the form `{error: "Changefeed cache over array size limit, skipped X elements."}` where `X` is the number of elements skipped.\n\nIf the table becomes unavailable, the changefeed will be disconnected, and a runtime exception will be thrown by the driver.\n\nCommands that operate on streams (such as `filter` or `map`) can usually be chained after `changes`.  However, since the stream produced by `changes` has no ending, commands that need to consume the entire stream before returning (such as `reduce` or `count`) cannot.\n\nIt\'s a good idea to open changefeeds on their own connection. If you don\'t, other queries run on the same connection will experience unpredictable latency spikes while the connection blocks on more changes.\n\n*Example* Subscribe to the changes on a table.\n\nStart monitoring the change feed in one client:\n\n    for change in r.table(\'games\').changes().run(conn):\n      print change\n\nAs these queries are performed in a second client, the first client would receive and print the following objects:\n\n    > r.table(\'games\').insert({\'id\': 1}).run(conn)\n    {\'old_val\': None, \'new_val\': {\'id\': 1}}\n    \n    > r.table(\'games\').get(1).update({\'player1\': \'Bob\'}).run(conn)\n    {\'old_val\': {\'id\': 1}, \'new_val\': {\'id\': 1, \'player1\': \'Bob\'}}\n    \n    > r.table(\'games\').get(1).replace({\'id\': 1, \'player1\': \'Bob\', \'player2\': \'Alice\'}).run(conn)\n    {\'old_val\': {\'id\': 1, \'player1\': \'Bob\'},\n     \'new_val\': {\'id\': 1, \'player1\': \'Bob\', \'player2\': \'Alice\'}}\n    \n    > r.table(\'games\').get(1).delete().run(conn)\n    {\'old_val\': {\'id\': 1, \'player1\': \'Bob\', \'player2\': \'Alice\'}, \'new_val\': None}\n    \n    > r.table_drop(\'games\').run(conn)\n    RqlRuntimeError: Changefeed aborted (table unavailable)\n\n*Example* Return all the changes that increase a player\'s score.\n\n    r.table(\'test\').changes().filter(\n      r.row[\'new_val\'][\'score\'] > r.row[\'old_val\'][\'score\']\n    ).run(conn)\n\n*Example* Return all the changes to Bob\'s score.\n\n    # Note that this will have to look at and discard all the changes to\n    # rows besides Bob\'s.  This is currently no way to filter with an index\n    # on change feeds.\n    r.table(\'test\').changes().filter(r.row[\'new_val\'][\'name\'].eq(\'Bob\')).run(conn)\n\n*Example* Return all the inserts on a table.\n\n    r.table(\'test\').changes().filter(r.row[\'old_val\'].eq(None)).run(conn)\n'),
	(rethinkdb.ast.Table.index_create, b'table.index_create(index_name[, index_function][, multi=False]) -> object\n\nCreate a new secondary index on a table. Secondary indexes improve the speed of many read queries at the slight cost of increased storage space and decreased write performance. For more information about secondary indexes, read the article "[Using secondary indexes in RethinkDB](/docs/secondary-indexes/)."\n\nRethinkDB supports different types of secondary indexes:\n\n- *Simple indexes* based on the value of a single field.\n- *Compound indexes* based on multiple fields.\n- *Multi indexes* based on arrays of values.\n- Indexes based on *arbitrary expressions*.\n\nThe `index_function` can be an anonymous function or a binary representation obtained from the `function` field of [index_status](/api/python/index_status).\n\n*Example* Create a simple index based on the field `post_id`.\n\n    r.table(\'comments\').index_create(\'post_id\').run(conn)\n*Example* Create a simple index based on the nested field `author > name`.\n\n    r.table(\'comments\').index_create(\'author_name\', r.row["author"]["name"]).run(conn)\n\n*Example* Create a compound index based on the fields `post_id` and `date`.\n\n    r.table(\'comments\').index_create(\'post_and_date\', [r.row["post_id"], r.row["date"]]).run(conn)\n*Example* Create a multi index based on the field `authors`.\n\n    r.table(\'posts\').index_create(\'authors\', multi=True).run(conn)\n\n*Example* Create an index based on an arbitrary expression.\n\n    r.table(\'posts\').index_create(\'authors\', lambda doc:\n        r.branch(\n            doc.has_fields("updated_at"),\n            doc["updated_at"],\n            doc["created_at"]\n        )\n    ).run(conn)\n\n*Example* Create a new secondary index based on an existing one.\n\n    index = r.table(\'posts\').index_status(\'authors\').nth(0)[\'function\'].run(conn)\n    r.table(\'new_posts\').index_create(\'authors\', index).run(conn)\n\n*Example* Rebuild an outdated secondary index on a table.\n\n    old_index = r.table(\'posts\').index_status(\'old_index\').nth(0)[\'function\'].run(conn)\n    r.table(\'posts\').index_create(\'new_index\', old_index).run(conn)\n    r.table(\'posts\').index_wait(\'new_index\').run(conn)\n    r.table(\'posts\').index_rename(\'new_index\', \'old_index\', overwrite=True).run(conn)\n'),
	(rethinkdb.ast.Table.index_drop, b"table.index_drop(index_name) -> object\n\nDelete a previously created secondary index of this table.\n\n*Example* Drop a secondary index named 'code_name'.\n\n    r.table('dc').index_drop('code_name').run(conn)\n\n"),
	(rethinkdb.ast.Table.index_list, b"table.index_list() -> array\n\nList all the secondary indexes of this table.\n\n*Example* List the available secondary indexes for this table.\n\n    r.table('marvel').index_list().run(conn)\n"),
	(rethinkdb.ast.Table.index_rename, b"table.index_rename(old_index_name, new_index_name[, overwrite=False]) -> object\n\nRename an existing secondary index on a table. If the optional argument `overwrite` is specified as `True`, a previously existing index with the new name will be deleted and the index will be renamed. If `overwrite` is `False` (the default) an error will be raised if the new index name already exists.\n\nThe return value on success will be an object of the format `{'renamed': 1}`, or `{'renamed': 0}` if the old and new names are the same.\n\nAn error will be raised if the old index name does not exist, if the new index name is already in use and `overwrite` is `False`, or if either the old or new index name are the same as the primary key field name.\n\n*Example* Rename an index on the comments table.\n\n    r.table('comments').index_rename('post_id', 'message_id').run(conn)\n"),
	(rethinkdb.ast.Table.index_status, b'table.index_status([, index...]) -> array\n\nGet the status of the specified indexes on this table, or the status\nof all indexes on this table if no indexes are specified.\n\nThe result is an array where for each index, there will be an object like this one:\n\n    {\n        "index": <index_name>,\n        "ready": True,\n        "function": <binary>,\n        "multi": <bool>,\n        "outdated": <bool>\n    }\n\nor this one:\n\n    {\n        "index": <index_name>,\n        "ready": False,\n        "blocks_processed": <int>,\n        "blocks_total": <int>,\n        "function": <binary>,\n        "multi": <bool>,\n        "outdated": <bool>\n    }\n\nThe `multi` field will be `true` or `false` depending on whether this index was created as a multi index (see [index_create](/api/python/index_create/) for details). The `outdated` field will be true if the index is outdated in the current version of RethinkDB and needs to be rebuilt.\n\nThe `function` field is a binary object containing an opaque representation of the secondary index (including the `multi` argument if specified). It can be passed as the second argument to [index_create](/api/python/index_create/) to create a new index with the same function; see `index_create` for more information.\n\n*Example* Get the status of all the indexes on `test`:\n\n    r.table(\'test\').index_status().run(conn)\n\n*Example* Get the status of the `timestamp` index:\n\n    r.table(\'test\').index_status(\'timestamp\').run(conn)\n\n*Example* Save the binary representation of the index:\n\n    func = r.table(\'test\').index_status(\'timestamp\').nth(0)[\'function\'].run(conn)\n'),
	(rethinkdb.ast.Table.index_wait, b"table.index_wait([, index...]) -> array\n\nWait for the specified indexes on this table to be ready, or for all\nindexes on this table to be ready if no indexes are specified.\n\nThe result is an array where for each index, there will be an object like:\n\n    {\n        index: <index_name>,\n        ready: True,\n        multi: <bool>,\n        outdated: <bool>\n    }\n\nThe `multi` field will be `true` or `false` depending on whether this index was created as a multi index (see [index_create](/api/python/index_create/) for details). The `outdated` field will be true if the index is outdated in the current version of RethinkDB and needs to be rebuilt.\n\n*Example* Wait for all indexes on the table `test` to be ready:\n\n    r.table('test').index_wait().run(conn)\n\n*Example* Wait for the index `timestamp` to be ready:\n\n    r.table('test').index_wait('timestamp').run(conn)\n"),
	(rethinkdb.ast.DB.table_create, b"db.table_create(table_name[, options]) -> object\n\nCreate a table. A RethinkDB table is a collection of JSON documents.\n\nIf successful, the operation returns an object: `{created: 1}`. If a table with the same\nname already exists, the operation throws `RqlRuntimeError`.\n\nNote: that you can only use alphanumeric characters and underscores for the table name.\n\nWhen creating a table you can specify the following options:\n\n- `primary_key`: the name of the primary key. The default primary key is id;\n- `durability`: if set to `'soft'`, this enables _soft durability_ on this table:\nwrites will be acknowledged by the server immediately and flushed to disk in the\nbackground. Default is `'hard'` (acknowledgement of writes happens after data has been\nwritten to disk);\n- `datacenter`: the name of the datacenter this table should be assigned to.\n\n*Example* Create a table named 'dc_universe' with the default settings.\n\n    r.db('test').table_create('dc_universe').run(conn)\n\n*Example* Create a table named 'dc_universe' using the field 'name' as primary key.\n\n    r.db('test').table_create('dc_universe', primary_key='name').run(conn)\n\n*Example* Create a table to log the very fast actions of the heroes.\n\n    r.db('test').table_create('hero_actions', durability='soft').run(conn)\n\n"),
	(rethinkdb.ast.DB.table_drop, b'db.table_drop(table_name) -> object\n\nDrop a table. The table and all its data will be deleted.\n\nIf successful, the operation returns an object: {"dropped": 1}. If the specified table\ndoesn\'t exist a `RqlRuntimeError` is thrown.\n\n*Example* Drop a table named \'dc_universe\'.\n\n    r.db(\'test\').table_drop(\'dc_universe\').run(conn)\n\n'),
	(rethinkdb.ast.DB.table_list, b"db.table_list() -> array\n\nList all table names in a database. The result is a list of strings.\n\n*Example* List all tables of the 'test' database.\n\n    r.db('test').table_list().run(conn)\n    \n"),
	(rethinkdb.ast.RqlQuery.__add__, b'number + number -> number\nstring + string -> string\narray + array -> array\ntime + number -> time\n\nSum two numbers, concatenate two strings, or concatenate 2 arrays.\n\n*Example* It\'s as easy as 2 + 2 = 4.\n\n    (r.expr(2) + 2).run(conn)\n\n*Example* Strings can be concatenated too.\n\n    (r.expr("foo") + "bar").run(conn)\n\n*Example* Arrays can be concatenated too.\n\n    (r.expr(["foo", "bar"]) + ["buzz"]).run(conn)\n\n*Example* Create a date one year from now.\n\n    r.now() + 365*24*60*60\n\n'),
	(rethinkdb.add, b'number + number -> number\nstring + string -> string\narray + array -> array\ntime + number -> time\n\nSum two numbers, concatenate two strings, or concatenate 2 arrays.\n\n*Example* It\'s as easy as 2 + 2 = 4.\n\n    (r.expr(2) + 2).run(conn)\n\n*Example* Strings can be concatenated too.\n\n    (r.expr("foo") + "bar").run(conn)\n\n*Example* Arrays can be concatenated too.\n\n    (r.expr(["foo", "bar"]) + ["buzz"]).run(conn)\n\n*Example* Create a date one year from now.\n\n    r.now() + 365*24*60*60\n\n'),
	(rethinkdb.ast.RqlQuery.__and__, b'bool & bool -> bool\nr.and_(bool, bool) -> bool\nbool.and_(bool) -> bool\n\nCompute the logical "and" of two or more values. The `and_` command can be used as an infix operator after its first argument (`r.expr(True).and_(False)`) or given all of its arguments as parameters (`r.and_(True, False)`). The standard Python and operator, `&`, may also be used with ReQL.\n\n*Example* Return whether both `a` and `b` evaluate to true.\n\n    > a = True\n    > b = False\n    > (r.expr(a) & b).run(conn)\n    \n    False\n*Example* Return whether all of `x`, `y` and `z` evaluate to true.\n\n    > x = True\n    > y = True\n    > z = True\n    > r.and_(x, y, z).run(conn)\n    \n    True\n'),
	(rethinkdb.and_, b'bool & bool -> bool\nr.and_(bool, bool) -> bool\nbool.and_(bool) -> bool\n\nCompute the logical "and" of two or more values. The `and_` command can be used as an infix operator after its first argument (`r.expr(True).and_(False)`) or given all of its arguments as parameters (`r.and_(True, False)`). The standard Python and operator, `&`, may also be used with ReQL.\n\n*Example* Return whether both `a` and `b` evaluate to true.\n\n    > a = True\n    > b = False\n    > (r.expr(a) & b).run(conn)\n    \n    False\n*Example* Return whether all of `x`, `y` and `z` evaluate to true.\n\n    > x = True\n    > y = True\n    > z = True\n    > r.and_(x, y, z).run(conn)\n    \n    True\n'),
	(rethinkdb.ast.RqlQuery.__div__, b"number / number -> number\n\nDivide two numbers.\n\n*Example* It's as easy as 2 / 2 = 1.\n\n    (r.expr(2) / 2).run(conn)\n"),
	(rethinkdb.div, b"number / number -> number\n\nDivide two numbers.\n\n*Example* It's as easy as 2 / 2 = 1.\n\n    (r.expr(2) / 2).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.__eq__, b'value == value -> bool\nvalue.eq(value) -> bool\n\nTest if two values are equal.\n\n*Example* Does 2 equal 2?\n\n    (r.expr(2) == 2).run(conn)\n    r.expr(2).eq(2).run(conn)\n'),
	(rethinkdb.ast.RqlQuery.eq, b'value == value -> bool\nvalue.eq(value) -> bool\n\nTest if two values are equal.\n\n*Example* Does 2 equal 2?\n\n    (r.expr(2) == 2).run(conn)\n    r.expr(2).eq(2).run(conn)\n'),
	(rethinkdb.ast.RqlQuery.__ge__, b'value >= value -> bool\nvalue.ge(value) -> bool\n\nTest if the first value is greater than or equal to other.\n\n*Example* Is 2 greater than or equal to 2?\n\n    (r.expr(2) >= 2).run(conn)\n    r.expr(2).ge(2).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.ge, b'value >= value -> bool\nvalue.ge(value) -> bool\n\nTest if the first value is greater than or equal to other.\n\n*Example* Is 2 greater than or equal to 2?\n\n    (r.expr(2) >= 2).run(conn)\n    r.expr(2).ge(2).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.__gt__, b'value > value -> bool\nvalue.gt(value) -> bool\n\nTest if the first value is greater than other.\n\n*Example* Is 2 greater than 2?\n\n    (r.expr(2) > 2).run(conn)\n    r.expr(2).gt(2).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.gt, b'value > value -> bool\nvalue.gt(value) -> bool\n\nTest if the first value is greater than other.\n\n*Example* Is 2 greater than 2?\n\n    (r.expr(2) > 2).run(conn)\n    r.expr(2).gt(2).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.__le__, b'value <= value -> bool\nvalue.le(value) -> bool\n\nTest if the first value is less than or equal to other.\n\n*Example* Is 2 less than or equal to 2?\n\n    (r.expr(2) <= 2).run(conn)\n    r.expr(2).le(2).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.le, b'value <= value -> bool\nvalue.le(value) -> bool\n\nTest if the first value is less than or equal to other.\n\n*Example* Is 2 less than or equal to 2?\n\n    (r.expr(2) <= 2).run(conn)\n    r.expr(2).le(2).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.__lt__, b'value < value -> bool\nvalue.lt(value) -> bool\n\nTest if the first value is less than other.\n\n*Example* Is 2 less than 2?\n\n    (r.expr(2) < 2).run(conn)\n    r.expr(2).lt(2).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.lt, b'value < value -> bool\nvalue.lt(value) -> bool\n\nTest if the first value is less than other.\n\n*Example* Is 2 less than 2?\n\n    (r.expr(2) < 2).run(conn)\n    r.expr(2).lt(2).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.__mod__, b"number % number -> number\n\nFind the remainder when dividing two numbers.\n\n*Example* It's as easy as 2 % 2 = 0.\n\n    (r.expr(2) % 2).run(conn)\n\n`\n"),
	(rethinkdb.mod, b"number % number -> number\n\nFind the remainder when dividing two numbers.\n\n*Example* It's as easy as 2 % 2 = 0.\n\n    (r.expr(2) % 2).run(conn)\n\n`\n"),
	(rethinkdb.ast.RqlQuery.__mul__, b'number * number -> number\narray * number -> array\n\nMultiply two numbers, or make a periodic array.\n\n*Example* It\'s as easy as 2 * 2 = 4.\n\n    (r.expr(2) * 2).run(conn)\n\n*Example* Arrays can be multiplied by numbers as well.\n\n    (r.expr(["This", "is", "the", "song", "that", "never", "ends."]) * 100).run(conn)\n\n'),
	(rethinkdb.mul, b'number * number -> number\narray * number -> array\n\nMultiply two numbers, or make a periodic array.\n\n*Example* It\'s as easy as 2 * 2 = 4.\n\n    (r.expr(2) * 2).run(conn)\n\n*Example* Arrays can be multiplied by numbers as well.\n\n    (r.expr(["This", "is", "the", "song", "that", "never", "ends."]) * 100).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.__ne__, b'value != value -> bool\nvalue.ne(value) -> bool\n\nTest if two values are not equal.\n\n*Example* Does 2 not equal 2?\n\n    (r.expr(2) != 2).run(conn)\n    r.expr(2).ne(2).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.ne, b'value != value -> bool\nvalue.ne(value) -> bool\n\nTest if two values are not equal.\n\n*Example* Does 2 not equal 2?\n\n    (r.expr(2) != 2).run(conn)\n    r.expr(2).ne(2).run(conn)\n\n'),
	(rethinkdb.ast.RqlQuery.__invert__, b'bool.not_() -> bool\nnot_(bool) -> bool\n(~bool) -> bool\n\nCompute the logical inverse (not) of an expression.\n\n`not_` can be called either via method chaining, immediately after an expression that evaluates as a boolean value, or by passing the expression as a parameter to `not_`.  All values that are not `False` or `None` will be converted to `True`.\n\nYou may also use `~` as a shorthand operator.\n\n*Example* Not true is false.\n\n    r.not_(True).run(conn)\n    r.expr(True).not_().run(conn)\n    (~r.expr(True)).run(conn)\n\nThese evaluate to `false`.\n\nNote that when using `~` the expression is wrapped in parentheses. Without this, Python will evaluate `r.expr(True)` *first* rather than using the ReQL operator and return an incorrect value. (`~True` evaluates to &minus;2 in Python.)\n\n*Example* Return all the users that do not have a "flag" field.\n\n    r.table(\'users\').filter(\n        lambda users: (~users.has_fields(\'flag\'))\n    ).run(conn)\n\n*Example* As above, but prefix-style.\n\n    r.table(\'users\').filter(\n        lambda users: r.not_(users.has_fields(\'flag\'))\n    ).run(conn)\n'),
	(rethinkdb.ast.RqlQuery.not_, b'bool.not_() -> bool\nnot_(bool) -> bool\n(~bool) -> bool\n\nCompute the logical inverse (not) of an expression.\n\n`not_` can be called either via method chaining, immediately after an expression that evaluates as a boolean value, or by passing the expression as a parameter to `not_`.  All values that are not `False` or `None` will be converted to `True`.\n\nYou may also use `~` as a shorthand operator.\n\n*Example* Not true is false.\n\n    r.not_(True).run(conn)\n    r.expr(True).not_().run(conn)\n    (~r.expr(True)).run(conn)\n\nThese evaluate to `false`.\n\nNote that when using `~` the expression is wrapped in parentheses. Without this, Python will evaluate `r.expr(True)` *first* rather than using the ReQL operator and return an incorrect value. (`~True` evaluates to &minus;2 in Python.)\n\n*Example* Return all the users that do not have a "flag" field.\n\n    r.table(\'users\').filter(\n        lambda users: (~users.has_fields(\'flag\'))\n    ).run(conn)\n\n*Example* As above, but prefix-style.\n\n    r.table(\'users\').filter(\n        lambda users: r.not_(users.has_fields(\'flag\'))\n    ).run(conn)\n'),
	(rethinkdb.not_, b'bool.not_() -> bool\nnot_(bool) -> bool\n(~bool) -> bool\n\nCompute the logical inverse (not) of an expression.\n\n`not_` can be called either via method chaining, immediately after an expression that evaluates as a boolean value, or by passing the expression as a parameter to `not_`.  All values that are not `False` or `None` will be converted to `True`.\n\nYou may also use `~` as a shorthand operator.\n\n*Example* Not true is false.\n\n    r.not_(True).run(conn)\n    r.expr(True).not_().run(conn)\n    (~r.expr(True)).run(conn)\n\nThese evaluate to `false`.\n\nNote that when using `~` the expression is wrapped in parentheses. Without this, Python will evaluate `r.expr(True)` *first* rather than using the ReQL operator and return an incorrect value. (`~True` evaluates to &minus;2 in Python.)\n\n*Example* Return all the users that do not have a "flag" field.\n\n    r.table(\'users\').filter(\n        lambda users: (~users.has_fields(\'flag\'))\n    ).run(conn)\n\n*Example* As above, but prefix-style.\n\n    r.table(\'users\').filter(\n        lambda users: r.not_(users.has_fields(\'flag\'))\n    ).run(conn)\n'),
	(rethinkdb.ast.RqlQuery.__or__, b'bool | bool -> bool\nbool.or_(bool[, bool, ...]) -> bool\nr.or_(bool, bool) -> bool\n\nCompute the logical "or" of two or more values. The `or_` command can be used as an infix operator after its first argument (`r.expr(True).or_(False)`) or given all of its arguments as parameters (`r.or_(True, False)`). The standard Python or operator, `|`, may also be used with ReQL.\n\n*Example* Return whether either `a` or `b` evaluate to true.\n\n    > a = True\n    > b = False\n    > (r.expr(a) | b).run(conn)\n    \n    True\n\n*Example* Return whether any of `x`, `y` or `z` evaluate to true.\n\n    > x = False\n    > y = False\n    > z = False\n    > r.or_(x, y, z).run(conn)\n    \n    False\n'),
	(rethinkdb.or_, b'bool | bool -> bool\nbool.or_(bool[, bool, ...]) -> bool\nr.or_(bool, bool) -> bool\n\nCompute the logical "or" of two or more values. The `or_` command can be used as an infix operator after its first argument (`r.expr(True).or_(False)`) or given all of its arguments as parameters (`r.or_(True, False)`). The standard Python or operator, `|`, may also be used with ReQL.\n\n*Example* Return whether either `a` or `b` evaluate to true.\n\n    > a = True\n    > b = False\n    > (r.expr(a) | b).run(conn)\n    \n    True\n\n*Example* Return whether any of `x`, `y` or `z` evaluate to true.\n\n    > x = False\n    > y = False\n    > z = False\n    > r.or_(x, y, z).run(conn)\n    \n    False\n'),
	(rethinkdb.random, b"r.random() -> number\nr.random(number[, number], float=True) -> number\nr.random(integer[, integer]) -> integer\n\nGenerate a random number between given (or implied) bounds. `random` takes zero, one or two arguments.\n\n- With __zero__ arguments, the result will be a floating-point number in the range `[0,1)` (from 0 up to but not including 1).\n- With __one__ argument _x,_ the result will be in the range `[0,x)`, and will be integer unless `float=True` is given as an option. Specifying a floating point number without the `float` option will raise an error.\n- With __two__ arguments _x_ and _y,_ the result will be in the range `[x,y)`, and will be integer unless `float=True` is given as an option.  If _x_ and _y_ are equal an error will occur, unless the floating-point option has been specified, in which case _x_ will be returned. Specifying a floating point number without the `float` option will raise an error.\n\nNote: The last argument given will always be the 'open' side of the range, but when\ngenerating a floating-point number, the 'open' side may be less than the 'closed' side.\n\n*Example* Generate a random number in the range `[0,1)`\n\n    r.random().run(conn)\n\n*Example* Generate a random integer in the range `[0,100)`\n\n    r.random(100).run(conn)\n    r.random(0, 100).run(conn)\n\n*Example* Generate a random number in the range `(-2.24,1.59]`\n\n    r.random(1.59, -2.24, float=True).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.__sub__, b"number - number -> number\ntime - time -> number\ntime - number -> time\n\nSubtract two numbers.\n\n*Example* It's as easy as 2 - 2 = 0.\n\n    (r.expr(2) - 2).run(conn)\n\n*Example* Create a date one year ago today.\n\n    r.now() - 365*24*60*60\n\n*Example* Retrieve how many seconds elapsed between today and date\n\n    r.now() - date\n\n"),
	(rethinkdb.sub, b"number - number -> number\ntime - time -> number\ntime - number -> time\n\nSubtract two numbers.\n\n*Example* It's as easy as 2 - 2 = 0.\n\n    (r.expr(2) - 2).run(conn)\n\n*Example* Create a date one year ago today.\n\n    r.now() - 365*24*60*60\n\n*Example* Retrieve how many seconds elapsed between today and date\n\n    r.now() - date\n\n"),
	(rethinkdb.ast.Table.between, b'table.between(lower_key, upper_key[, index=\'id\', left_bound=\'closed\', right_bound=\'open\'])\n    -> selection\n\nGet all documents between two keys. Accepts three optional arguments: `index`,\n`left_bound`, and `right_bound`. If `index` is set to the name of a secondary index,\n`between` will return all documents where that index\'s value is in the specified range\n(it uses the primary key by default). `left_bound` or `right_bound` may be set to `open`\nor `closed` to indicate whether or not to include that endpoint of the range (by default,\n`left_bound` is closed and `right_bound` is open).\n\n*Example* Find all users with primary key >= 10 and < 20 (a normal half-open interval).\n\n    r.table(\'marvel\').between(10, 20).run(conn)\n\n*Example* Find all users with primary key >= 10 and <= 20 (an interval closed on\nboth sides).\n\n    r.table(\'marvel\').between(10, 20, right_bound=\'closed\').run(conn)\n\n*Example* Find all users with primary key < 20. (You can use `None` to mean\n"unbounded" for either endpoint.)\n\n    r.table(\'marvel\').between(None, 20, right_bound=\'closed\').run(conn)\n\n*Example* Between can be used on secondary indexes too. Just pass an optional index\nargument giving the secondary index to query.\n\n    r.table(\'dc\').between(\'dark_knight\', \'man_of_steel\', index=\'code_name\').run(conn)\n\n__Note:__ To filter all documents between *times* (and dates), do not use `between`. Instead, use the [during](/api/python/during) command.'),
	(rethinkdb.db, b"r.db(db_name) -> db\n\nReference a database.\n\n*Example* Before we can query a table we have to select the correct database.\n\n    r.db('heroes').table('marvel').run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.filter, b'selection.filter(predicate[, default=False]) -> selection\nstream.filter(predicate[, default=False]) -> stream\narray.filter(predicate[, default=False]) -> array\n\nGet all the documents for which the given predicate is true.\n\n`filter` can be called on a sequence, selection, or array. The type of the return value will be the same as the input.\n\nThe body of every filter is wrapped in an implicit `.default(False)`, which means that if a non-existence error is thrown (when you try to access a field that does not exist in a document) RethinkDB will just ignore the document. The `default` value can be changed by passing an object with a `default` field. Setting this optional argument to `r.error()` will cause non-existence errors to return a `RqlRuntimeError`.\n\n*Example* Get all the users that are 30 years old.\n\n    r.table(\'users\').filter({"age": 30}).run(conn)\n\nA more general way to write the previous query is to use `r.row`.\n\n    r.table(\'users\').filter(r.row["age"] == 30).run(conn)\n\nHere the predicate is `r.row["age"] == 30`.\n\n- `r.row` refers to the current document\n- `r.row["age"]` refers to the field `age` of the current document\n- `r.row["age"] == 30` returns `True` if the field `age` is 30\n\nAn even more general way to write the same query is to use a lambda function.\nRead the documentation about [r.row](../row/) to know more about the differences\nbetween `r.row` and lambda functions in ReQL.\n\n    r.table(\'users\').filter(lambda user:\n        user["age"] == 30\n    ).run(conn)\n\n*Example* Get all the users that are more than 18 years old.\n\n    r.table("users").filter(r.row["age"] > 18).run(conn)\n\n*Example* Get all the users that are less than 18 years old and more than 13 years old.\n\n    r.table("users").filter((r.row["age"] < 18) & (r.row["age"] > 13)).run(conn)\n\n*Example* Get all the users that are more than 18 years old or have their parental consent.\n\n    r.table("users").filter(r.row["age"] < 18) | (r.row["hasParentalConsent"])).run(conn)\n\n*Example* Get all the users that are less than 18 years old or whose age is unknown\n(field `age` missing).\n\n    r.table("users").filter(r.row["age"] < 18, default=True).run(conn)\n\n*Example* Get all the users that are more than 18 years old. Throw an error if a\ndocument is missing the field `age`.\n\n    r.table("users").filter(r.row["age"] > 18, default=r.error()).run(conn)\n\n*Example* Select all users who have given their phone number (all the documents\nwhose field `phone_number` is defined and not `None`).\n\n    r.table(\'users\').filter(lambda user:\n        user.has_fields(\'phone_number\')\n    ).run(conn)\n\n*Example* Retrieve all the users who subscribed between January 1st, 2012\n(included) and January 1st, 2013 (excluded).\n\n    r.table("users").filter(lambda user:\n        user["subscription_date"].during(r.time(2012, 1, 1, \'Z\'), r.time(2013, 1, 1, \'Z\') )\n    ).run(conn)\n\n*Example* Retrieve all the users who have a gmail account (whose field `email` ends\nwith `@gmail.com`).\n\n    r.table("users").filter(lambda user:\n        user["email"].match("@gmail.com$")\n    ).run(conn)\n\n*Example* Filter based on the presence of a value in an array.\n\nSuppose the table `users` has the following schema\n\n    {\n        "name": <type \'str\'>\n        "places_visited": [<type \'str\'>]\n    }\n\nRetrieve all the users whose field `places_visited` contains `France`.\n\n    r.table("users").filter(lambda user:\n        user["places_visited"].contains("France")\n    ).run(conn)\n\n*Example* Filter based on nested fields.\n\nSuppose we have a table `users` containing documents with the following schema.\n\n    {\n        "id": <type \'str\'>\n        "name": {\n            "first": <type \'str\'>,\n            "middle": <type \'str\'>,\n            "last": <type \'str\'>\n        }\n    }\n\nRetrieve all users named "William Adama" (first name "William", last name\n"Adama"), with any middle name.\n\n    r.table("users").filter({\n        "name":{\n            "first": "William",\n            "last": "Adama"\n        }\n    }).run(conn)\n\nIf you want an exact match for a field that is an object, you will have to use `r.literal`.\n\nRetrieve all users named "William Adama" (first name "William", last name\n"Adama"), and who do not have a middle name.\n\n    r.table("users").filter(r.literal({\n        "name":{\n            "first": "William",\n            "last": "Adama"\n        }\n    })).run(conn)\n\nThe equivalent queries with a lambda function.\n\n    r.table("users").filter(lambda user:\n        (user["name"]["first"] == "William")\n            & (user["name"]["last"] == "Adama")\n    ).run(conn)\n\n    r.table("users").filter(lambda user:\n        user["name"] == {\n            "first": "William",\n            "last": "Adama"\n        }\n    ).run(conn)\n'),
	(rethinkdb.ast.Table.get, b"table.get(key) -> singleRowSelection\n\nGet a document by primary key.\n\nIf no document exists with that primary key, `get` will return `None`.\n\n*Example* Find a document by UUID.\n\n    r.table('posts').get('a9849eef-7176-4411-935b-79a6e3c56a74').run(conn)\n\n*Example* Find a document and merge another document with it.\n\n    r.table('heroes').get(3).merge(\n        { 'powers': ['invisibility', 'speed'] }\n    ).run(conn)\n"),
	(rethinkdb.ast.Table.get_all, b'table.get_all(key1[, key2...], [, index=\'id\']) -> selection\n\nGet all documents where the given value matches the value of the requested index.\n\n*Example* Secondary index keys are not guaranteed to be unique so we cannot query via\n"get" when using a secondary index.\n\n    r.table(\'marvel\').get_all(\'man_of_steel\', index=\'code_name\').run(conn)\n\n*Example* Without an index argument, we default to the primary index. While `get` will either return the document or `None` when no document with such a primary key value exists, this will return either a one or zero length stream.\n\n    r.table(\'dc\').get_all(\'superman\').run(conn)\n\n*Example* You can get multiple documents in a single call to `get_all`.\n\n    r.table(\'dc\').get_all(\'superman\', \'ant man\').run(conn)\n\n'),
	(rethinkdb.ast.DB.table, b"db.table(name[, use_outdated=False]) -> table\n\nSelect all documents in a table. This command can be chained with other commands to do\nfurther processing on the data.\n\n*Example* Return all documents in the table 'marvel' of the default database.\n\n    r.table('marvel').run(conn)\n\n*Example* Return all documents in the table 'marvel' of the database 'heroes'.\n\n    r.db('heroes').table('marvel').run(conn)\n\n*Example* If you are OK with potentially out of date data from this table and want\npotentially faster reads, pass a flag allowing out of date data.\n\n    r.db('heroes').table('marvel', True).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.downcase, b'string.downcase() -> string\n\nLowercases a string.\n\n*Example*\n\n    > r.expr("Sentence about LaTeX.").downcase().run(conn)\n    "sentence about latex."\n'),
	(rethinkdb.ast.RqlQuery.match, b'string.match(regexp) -> None/object\n\nMatches against a regular expression. If there is a match, returns an object with the fields:\n\n- `str`: The matched string\n- `start`: The matched string\'s start\n- `end`: The matched string\'s end\n- `groups`: The capture groups defined with parentheses\n\nIf no match is found, returns `None`.\n\nAccepts RE2 syntax\n([https://code.google.com/p/re2/wiki/Syntax](https://code.google.com/p/re2/wiki/Syntax)).\nYou can enable case-insensitive matching by prefixing the regular expression with\n`(?i)`. See the linked RE2 documentation for more flags.\n\nThe `match` command does not support backreferences.\n\n*Example* Get all users whose name starts with "A". Because `None` evaluates to `false` in\n`filter`, you can just use the result of `match` for the predicate.\n\n    r.table(\'users\').filter(lambda doc:\n        doc[\'name\'].match("^A")\n    ).run(conn)\n\n*Example* Get all users whose name ends with "n".\n\n    r.table(\'users\').filter(lambda doc:\n        doc[\'name\'].match("n$")\n    ).run(conn)\n\n*Example* Get all users whose name has "li" in it\n\n    r.table(\'users\').filter(lambda doc:\n        doc[\'name\'].match("li")\n    ).run(conn)\n\n*Example* Get all users whose name is "John" with a case-insensitive search.\n\n    r.table(\'users\').filter(lambda doc:\n        doc[\'name\'].match("(?i)^john$")\n    ).run(conn)\n\n*Example* Get all users whose name is composed of only characters between "a" and "z".\n\n    r.table(\'users\').filter(lambda doc:\n        doc[\'name\'].match("(?i)^[a-z]+$")\n    ).run(conn)\n\n*Example* Get all users where the zipcode is a string of 5 digits.\n\n    r.table(\'users\').filter(lambda doc:\n        doc[\'zipcode\'].match("\\d{5}")\n    ).run(conn)\n\n*Example* Retrieve the domain of a basic email\n\n    r.expr("name@domain.com").match(".*@(.*)").run(conn)\n\nResult:\n\n    {\n        "start": 0,\n        "end": 20,\n        "str": "name@domain.com",\n        "groups":[\n            {\n                "end": 17,\n                "start": 7,\n                "str": "domain.com"\n            }\n        ]\n    }\n\nYou can then retrieve only the domain with the [\\[\\]](/api/python/get_field) selector.\n\n    r.expr("name@domain.com").match(".*@(.*)")["groups"][0]["str"].run(conn)\n\nReturns `\'domain.com\'`\n\n*Example* Fail to parse out the domain and returns `None`.\n\n    r.expr("name[at]domain.com").match(".*@(.*)").run(conn)\n'),
	(rethinkdb.ast.RqlQuery.split, b'string.split([separator, [max_splits]]) -> array\n\nSplits a string into substrings.  Splits on whitespace when called\nwith no arguments.  When called with a separator, splits on that\nseparator.  When called with a separator and a maximum number of\nsplits, splits on that separator at most `max_splits` times.  (Can be\ncalled with `None` as the separator if you want to split on whitespace\nwhile still specifying `max_splits`.)\n\nMimics the behavior of Python\'s `string.split` in edge cases, except\nfor splitting on the empty string, which instead produces an array of\nsingle-character strings.\n\n*Example* Split on whitespace.\n\n    > r.expr("foo  bar bax").split().run(conn)\n    ["foo", "bar", "bax"]\n\n*Example* Split the entries in a CSV file.\n\n    > r.expr("12,37,,22,").split(",").run(conn)\n    ["12", "37", "", "22", ""]\n\n*Example* Split a string into characters.\n\n    > r.expr("mlucy").split("").run(conn)\n    ["m", "l", "u", "c", "y"]\n\n*Example* Split the entries in a CSV file, but only at most 3\ntimes.\n\n    > r.expr("12,37,,22,").split(",", 3).run(conn)\n    ["12", "37", "", "22,"]\n\n*Example* Split on whitespace at most once (i.e. get the first word).\n\n    > r.expr("foo  bar bax").split(None, 1).run(conn)\n    ["foo", "bar bax"]\n'),
	(rethinkdb.ast.RqlQuery.upcase, b'string.upcase() -> string\n\nUppercases a string.\n\n*Example*\n\n    > r.expr("Sentence about LaTeX.").upcase().run(conn)\n    "SENTENCE ABOUT LATEX."\n'),
	(rethinkdb.ast.RqlQuery.concat_map, b'stream.concat_map(mapping_function) -> stream\narray.concat_map(mapping_function) -> array\n\nConcatenate one or more elements into a single sequence using a mapping function.\n\n`concat_map` works in a similar fashion to `map`, applying the given function to each element in a sequence, but it will always return a single sequence. If the mapping function returns a sequence, `map` would produce a sequence of sequences:\n\n    r.expr([1, 2, 3]).map(lambda x: [x, x.mul(2)]).run(conn)\n\nResult:\n\n[[1, 2], [2, 4], [3, 6]]\n\nWhereas `concat_map` with the same mapping function would merge those sequences into one:\n\n    r.expr([1, 2, 3]).concat_map(lambda x: [x, x.mul(2)]).run(conn)\n\nResult:\n\n[1, 2, 2, 4, 3, 6]\n\nThe return value, array or stream, will be the same type as the input.\n\n*Example* Construct a sequence of all monsters defeated by Marvel heroes. The field "defeatedMonsters" is an array of one or more monster names.\n\n    r.table(\'marvel\').concat_map(lambda hero: hero[\'defeatedMonsters\']).run(conn)\n\n*Example* Simulate an [eq_join](/api/python/eq_join/) using `concat_map`. (This is how ReQL joins are implemented internally.)\n\n    r.table(\'posts\').concat_map(\n        lambda post: r.table(\'comments\').get_all(\n            post[\'id\'], index=\'post_id\'\n        ).map(\n            lambda comment: { \'left\': post, \'right\': comment}\n        )\n    ).run(conn)\n'),
	(rethinkdb.ast.RqlQuery.indexes_of, b"sequence.indexes_of(datum | predicate) -> array\n\nGet the indexes of an element in a sequence. If the argument is a predicate, get the indexes of all elements matching it.\n\n*Example* Find the position of the letter 'c'.\n\n    r.expr(['a','b','c']).indexes_of('c').run(conn)\n\n*Example* Find the popularity ranking of invisible heroes.\n\n    r.table('marvel').union(r.table('dc')).order_by('popularity').indexes_of(\n        r.row['superpowers'].contains('invisibility')\n    ).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.is_empty, b"sequence.is_empty() -> bool\n\nTest if a sequence is empty.\n\n*Example* Are there any documents in the marvel table?\n\n    r.table('marvel').is_empty().run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.limit, b"sequence.limit(n) -> stream\narray.limit(n) -> array\n\nEnd the sequence after the given number of elements.\n\n*Example* Only so many can fit in our Pantheon of heroes.\n\n    r.table('marvel').order_by('belovedness').limit(10).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.map, b"sequence.map(mapping_function) -> stream\narray.map(mapping_function) -> array\n\nTransform each element of the sequence by applying the given mapping function.\n\n*Example* Construct a sequence of hero power ratings.\n\n    r.table('marvel').map(lambda hero:\n        hero['combatPower'] + hero['compassionPower'] * 2\n    ).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.nth, b"sequence.nth(index) -> object\nselection.nth(index) -> selection&lt;object&gt;\n\nGet the *nth* element of a sequence.\n\nIn Python, you can use `[]` with an integer as a shorthand for `nth`.\n\n*Example* Select the second element in the array.\n\n    r.expr([1,2,3]).nth(1).run(conn)\n    r.expr([1,2,3])[1].run(conn)\n\n**Example:** Select the bronze medalist from the competitors.\n\n    r.table('players').order_by(index=r.desc('score')).nth(3).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.order_by, b'table.order_by([key1...], index=index_name) -> selection<stream>\nselection.order_by(key1, [key2...]) -> selection<array>\nsequence.order_by(key1, [key2...]) -> array\n\nSort the sequence by document values of the given key(s). To specify\nthe ordering, wrap the attribute with either `r.asc` or `r.desc`\n(defaults to ascending).\n\nSorting without an index requires the server to hold the sequence in\nmemory, and is limited to 100,000 documents (or the setting of the `arrayLimit` option for [run](/api/python/run)). Sorting with an index can\nbe done on arbitrarily large tables, or after a `between` command\nusing the same index.\n\n*Example* Order all the posts using the index `date`.   \n\n    r.table(\'posts\').order_by(index=\'date\').run(conn)\n\nThe index must have been previously created with [index_create](/api/python/index_create/).\n\n    r.table(\'posts\').index_create(\'date\').run(conn)\n\nYou can also select a descending ordering:\n\n    r.table(\'posts\').order_by(index=r.desc(\'date\')).run(conn, callback)\n\n*Example* Order a sequence without an index.\n\n    r.table(\'posts\').get(1)[\'comments\'].order_by(\'date\')\n\nYou can also select a descending ordering:\n\n    r.table(\'posts\').get(1)[\'comments\'].order_by(r.desc(\'date\'))\n\nIf you\'re doing ad-hoc analysis and know your table won\'t have more then 100,000\nelements (or you\'ve changed the setting of the `arrayLimit` option for [run](/api/python/run)) you can run `order_by` without an index:\n\n    r.table(\'small_table\').order_by(\'date\')\n\n*Example* You can efficiently order using multiple fields by using a\n[compound index](http://www.rethinkdb.com/docs/secondary-indexes/python/).\n\nOrder by date and title.\n\n    r.table(\'posts\').order_by(index=\'date_and_title\').run(conn)\n\nThe index must have been previously created with [index_create](/api/python/index_create/).\n\n    r.table(\'posts\').index_create(\'date_and_title\', lambda post:\n        [post["date"], post["title"]]).run(conn)\n\n_Note_: You cannot specify multiple orders in a compound index. See [issue #2306](https://github.com/rethinkdb/rethinkdb/issues/2306)\nto track progress.\n\n*Example* If you have a sequence with fewer documents than the `array_limit`, you can order it\nby multiple fields without an index.\n\nr.table(\'small_table\').orderBy(\'date\', r.desc(\'title\'))\n\n*Example* Notice that an index ordering always has highest\nprecedence. The following query orders posts by date, and if multiple\nposts were published on the same date, they will be ordered by title.\n\n    r.table(\'post\').order_by(\'title\', index=\'date\').run(conn)\n*Example* You can use [nested field](/docs/cookbook/python/#filtering-based-on-nested-fields) syntax to sort on fields from subdocuments. (You can also create indexes on nested fields using this syntax with `index_create`.)\n\n    r.table(\'user\').order_by(lambda user: user[\'group\'][\'id\']).run(conn)\n\n*Example* You can efficiently order data on arbitrary expressions using indexes.\n\n    r.table(\'posts\').order_by(index=\'votes\').run(conn)\n\nThe index must have been previously created with [index_create](/api/ruby/index_create/).\n\n    r.table(\'posts\').index_create(\'votes\', lambda post:\n        post["upvotes"]-post["downvotes"]\n    ).run(conn)\n\n*Example* If you have a sequence with fewer documents than the `array_limit`, you can order it with an arbitrary function directly.\n\n    r.table(\'small_table\').order_by(lambda doc:\n        doc[\'upvotes\']-doc[\'downvotes\']\n    );\n\nYou can also select a descending ordering:\n\n    r.table(\'small_table\').order_by(r.desc(lambda doc:\n        doc[\'upvotes\']-doc[\'downvotes\']\n    ));\n\n*Example* Ordering after a `between` command can be done as long as the same index is being used.\n\n    r.table("posts").between(r.time(2013, 1, 1, \'+00:00\'), r.time(2013, 1, 1, \'+00:00\'), index=\'date\')\n        .order_by(index=\'date\').run(conn);\n\n'),
	(rethinkdb.ast.RqlQuery.sample, b"sequence.sample(number) -> selection\nstream.sample(number) -> array\narray.sample(number) -> array\n\nSelect a given number of elements from a sequence with uniform random distribution. Selection is done without replacement.\n\nIf the sequence has less than the requested number of elements (i.e., calling `sample(10)` on a sequence with only five elements), `sample` will return the entire sequence in a random order.\n\n*Example* Select 3 random heroes.\n\n    r.table('marvel').sample(3).run(conn)\n"),
	(rethinkdb.ast.RqlQuery.skip, b"sequence.skip(n) -> stream\narray.skip(n) -> array\n\nSkip a number of elements from the head of the sequence.\n\n*Example* Here in conjunction with `order_by` we choose to ignore the most successful heroes.\n\n    r.table('marvel').order_by('successMetric').skip(10).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.slice, b"selection.slice(start_index[, end_index, left_bound='closed', right_bound='open']) -> selection\nstream.slice(start_index[, end_index, left_bound='closed', right_bound='open']) -> stream\narray.slice(start_index[, end_index, left_bound='closed', right_bound='open']) -> array\nbinary.slice(start_index[, end_index, left_bound='closed', right_bound='open']) -> binary\n\nReturn the elements of a sequence within the specified range.\n\n`slice` returns the range between `start_index` and `end_index`. If only `start_index` is specified, `slice` returns the range from that index to the end of the sequence. Specify `left_bound` or `right_bound` as `open` or `closed` to indicate whether to include that endpoint of the range by default: `closed` returns that endpoint, while `open` does not. By default, `left_bound` is closed and `right_bound` is open, so the range `(10,13)` will return the tenth, eleventh and twelfth elements in the sequence.\n\nIf `end_index` is past the end of the sequence, all elements from `start_index` to the end of the sequence will be returned. If `start_index` is past the end of the sequence or `end_index` is less than `start_index`, a zero-element sequence will be returned (although see below for negative `end_index` values). An error will be raised on a negative `start_index`.\n\nA negative `end_index` is allowed with arrays; in that case, the returned range counts backward from the array's end. That is, the range of `(2,-1)` returns the second element through the next-to-last element of the range. A negative `end_index` is not allowed with a stream. (An `end_index` of &minus;1 *is* allowed with a stream if `right_bound` is closed; this behaves as if no `end_index` was specified.)\n\nIf `slice` is used with a [binary](/api/python/binary) object, the indexes refer to byte positions within the object. That is, the range `(10,20)` will refer to the 10th byte through the 19th byte.\n\nIf you are only specifying the indexes and not the bounding options, you may use Python's slice operator as a shorthand: `[start_index:end_index]`.\n\n**Example:** Return the fourth, fifth and sixth youngest players. (The youngest player is at index 0, so those are elements 3&ndash;5.)\n\n    r.table('players').order_by(index='age').slice(3,6).run(conn)\n\nOr, using Python's slice operator:\n\n    r.table('players').filter({'class': 'amateur'})[10:20].run(conn)\n\n**Example:** Return all but the top three players who have a red flag.\n\n    r.table('players').filter({'flag': 'red'}).order_by(index=r.desc('score')).slice(3).run(conn)\n\n**Example:** Return holders of tickets `X` through `Y`, assuming tickets are numbered sequentially. We want to include ticket `Y`.\n\n    r.table('users').order_by(index='ticket').slice(x, y, right_bound='closed').run(conn)\n\n**Example:** Return the elements of an array from the second through two from the end (that is, not including the last two).\n\n    r.expr([0,1,2,3,4,5]).slice(2,-2).run(conn)\n\nResult:\n\n    [2,3]\n"),
	(rethinkdb.ast.RqlQuery.union, b"sequence.union(sequence) -> array\n\nConcatenate two sequences.\n\n*Example* Construct a stream of all heroes.\n\n    r.table('marvel').union(r.table('dc')).run(conn)\n\n"),
	(rethinkdb.ast.RqlQuery.with_fields, b"sequence.with_fields([selector1, selector2...]) -> stream\narray.with_fields([selector1, selector2...]) -> array\n\nPlucks one or more attributes from a sequence of objects, filtering out any objects in the sequence that do not have the specified fields. Functionally, this is identical to `has_fields` followed by `pluck` on a sequence.\n\n*Example* Get a list of users and their posts, excluding any users who have not made any posts.\n\nExisting table structure:\n\n    [\n        { 'id': 1, 'user': 'bob', 'email': 'bob@foo.com', 'posts': [ 1, 4, 5 ] },\n        { 'id': 2, 'user': 'george', 'email': 'george@foo.com' },\n        { 'id': 3, 'user': 'jane', 'email': 'jane@foo.com', 'posts': [ 2, 3, 6 ] }\n    ]\n\nCommand and output:\n\n    r.table('users').with_fields('id', 'user', 'posts').run(conn)\n    \n    [\n        { 'id': 1, 'user': 'bob', 'posts': [ 1, 4, 5 ] },\n        { 'id': 3, 'user': 'jane', 'posts': [ 2, 3, 6 ] }\n    ]\n\n*Example* Use the [nested field syntax](/docs/nested-fields/) to get a list of users with cell phone numbers in their contacts.\n\n    r.table('users').with_fields('id', 'user', {contact: {'phone': 'work'}).run(conn)\n"),
	(rethinkdb.ast.Table.delete, b'table.delete([durability="hard", return_changes=False])\n    -> object\nselection.delete([durability="hard", return_changes=False])\n    -> object\nsingleSelection.delete([durability="hard", return_changes=False])\n    -> object\n\nDelete one or more documents from a table.\n\nThe optional arguments are:\n\n- `durability`: possible values are `hard` and `soft`. This option will override the\ntable or query\'s durability setting (set in [run](/api/python/run/)).  \nIn soft durability mode RethinkDB will acknowledge the write immediately after\nreceiving it, but before the write has been committed to disk.\n- `return_changes`: if set to `True`, return a `changes` array consisting of `old_val`/`new_val` objects describing the changes made.\n\nDelete returns an object that contains the following attributes:\n\n- `deleted`: the number of documents that were deleted.\n- `skipped`: the number of documents that were skipped.  \nFor example, if you attempt to delete a batch of documents, and another concurrent query\ndeletes some of those documents first, they will be counted as skipped.\n- `errors`: the number of errors encountered while performing the delete.\n- `first_error`: If errors were encountered, contains the text of the first error.\n- `inserted`, `replaced`, and `unchanged`: all 0 for a delete operation.\n- `changes`: if `return_changes` is set to `True`, this will be an array of objects, one for each objected affected by the `delete` operation. Each object will have two keys: `{"new_val": None, "old_val": <old value>}`.\n\n*Example* Delete a single document from the table `comments`.\n\n    r.table("comments").get("7eab9e63-73f1-4f33-8ce4-95cbea626f59").delete().run(conn)\n\n*Example* Delete all documents from the table `comments`.\n\n    r.table("comments").delete().run(conn)\n\n*Example* Delete all comments where the field `id_post` is `3`.\n\n    r.table("comments").filter({"id_post": 3}).delete().run(conn)\n\n*Example* Delete a single document from the table `comments` and return its value.\n\n    r.table("comments").get("7eab9e63-73f1-4f33-8ce4-95cbea626f59").delete(return_changes=True).run(conn)\n\nThe result will look like:\n\n    {\n        "deleted": 1,\n        "errors": 0,\n        "inserted": 0,\n        "changes": [\n            {\n                "new_val": None,\n                "old_val": {\n                    "id": "7eab9e63-73f1-4f33-8ce4-95cbea626f59",\n                    "author": "William",\n                    "comment": "Great post",\n                    "id_post": 3\n                }\n            }\n        ],\n        "replaced": 0,\n        "skipped": 0,\n        "unchanged": 0\n    }\n\n*Example* Delete all documents from the table `comments` without waiting for the\noperation to be flushed to disk.\n\n    r.table("comments").delete(durability="soft"}).run(conn)\n'),
	(rethinkdb.ast.Table.insert, b'table.insert(json | [json][, durability="hard", return_changes=False, conflict="error"])\n    -> object\n\nInsert documents into a table. Accepts a single document or an array of\ndocuments.\n\nThe optional arguments are:\n\n- `durability`: possible values are `hard` and `soft`. This option will override the table or query\'s durability setting (set in [run](/api/python/run/)). In soft durability mode Rethink_dB will acknowledge the write immediately after receiving and caching it, but before the write has been committed to disk.\n- `return_changes`: if set to `True`, return a `changes` array consisting of `old_val`/`new_val` objects describing the changes made.\n- `conflict`: Determine handling of inserting documents with the same primary key as existing entries. Possible values are `"error"`, `"replace"` or `"update"`.\n    - `"error"`: Do not insert the new document and record the conflict as an error. This is the default.\n    - `"replace"`: [Replace](/api/python/replace/) the old document in its entirety with the new one.\n    - `"update"`: [Update](/api/python/update/) fields of the old document with fields from the new one.\n\nInsert returns an object that contains the following attributes:\n\n- `inserted`: the number of documents successfully inserted.\n- `replaced`: the number of documents updated when `conflict` is set to `"replace"` or `"update"`.\n- `unchanged`: the number of documents whose fields are identical to existing documents with the same primary key when `conflict` is set to `"replace"` or `"update"`.\n- `errors`: the number of errors encountered while performing the insert.\n- `first_error`: If errors were encountered, contains the text of the first error.\n- `deleted` and `skipped`: 0 for an insert operation.\n- `generated_keys`: a list of generated primary keys for inserted documents whose primary keys were not specified (capped to 100,000).\n- `warnings`: if the field `generated_keys` is truncated, you will get the warning _"Too many generated keys (&lt;X&gt;), array truncated to 100000."_.\n- `changes`: if `return_changes` is set to `True`, this will be an array of objects, one for each objected affected by the `delete` operation. Each object will have two keys: `{"new_val": <new value>, "old_val": None}`.\n\n*Example* Insert a document into the table `posts`.\n\n    r.table("posts").insert({\n        "id": 1,\n        "title": "Lorem ipsum",\n        "content": "Dolor sit amet"\n    }).run(conn)\n\nThe result will be:\n\n    {\n        "deleted": 0,\n        "errors": 0,\n        "inserted": 1,\n        "replaced": 0,\n        "skipped": 0,\n        "unchanged": 0\n    }\n\n*Example* Insert a document without a defined primary key into the table `posts` where the\nprimary key is `id`.\n\n    r.table("posts").insert({\n        "title": "Lorem ipsum",\n        "content": "Dolor sit amet"\n    }).run(conn)\n\nRethinkDB will generate a primary key and return it in `generated_keys`.\n\n    {\n        "deleted": 0,\n        "errors": 0,\n        "generated_keys": [\n            "dd782b64-70a7-43e4-b65e-dd14ae61d947"\n        ],\n        "inserted": 1,\n        "replaced": 0,\n        "skipped": 0,\n        "unchanged": 0\n    }\n\nRetrieve the document you just inserted with:\n\n    r.table("posts").get("dd782b64-70a7-43e4-b65e-dd14ae61d947").run(conn)\n\nAnd you will get back:\n\n    {\n        "id": "dd782b64-70a7-43e4-b65e-dd14ae61d947",\n        "title": "Lorem ipsum",\n        "content": "Dolor sit amet",\n    }\n\n*Example* Insert multiple documents into the table `users`.\n\n    r.table("users").insert([\n        {"id": "william", "email": "william@rethinkdb.com"},\n        {"id": "lara", "email": "lara@rethinkdb.com"}\n    ]).run(conn)\n\n*Example* Insert a document into the table `users`, replacing the document if the document\nalready exists.  \n\n    r.table("users").insert(\n        {"id": "william", "email": "william@rethinkdb.com"},\n        conflict="error"\n    ).run(conn)\n\n*Example* Copy the documents from `posts` to `posts_backup`.\n\n    r.table("posts_backup").insert( r.table("posts") ).run(conn)\n\n*Example* Get back a copy of the inserted document (with its generated primary key).\n\n    r.table("posts").insert(\n        {"title": "Lorem ipsum", "content": "Dolor sit amet"},\n        return_changes=True\n    ).run(conn)\n\nThe result will be\n\n    {\n        "deleted": 0,\n        "errors": 0,\n        "generated_keys": [\n            "dd782b64-70a7-43e4-b65e-dd14ae61d947"\n        ],\n        "inserted": 1,\n        "replaced": 0,\n        "skipped": 0,\n        "unchanged": 0,\n        "changes": [\n            {\n                "old_val": None,\n                "new_val": {\n                    "id": "dd782b64-70a7-43e4-b65e-dd14ae61d947",\n                    "title": "Lorem ipsum",\n                    "content": "Dolor sit amet"\n                }\n            }\n        ]\n    }\n'),
	(rethinkdb.ast.Table.replace, b'table.replace(json | expr[, durability="hard", return_changes=False, non_atomic=False])\n    -> object\nselection.replace(json | expr[, durability="hard", return_changes=False, non_atomic=False])\n    -> object\nsingleSelection.replace(json | expr[, durability="hard", return_changes=False, non_atomic=False])\n    -> object\n\nReplace documents in a table. Accepts a JSON document or a ReQL expression, and replaces\nthe original document with the new one. The new document must have the same primary key\nas the original document.\n\nThe optional arguments are:\n\n- `durability`: possible values are `hard` and `soft`. This option will override the\ntable or query\'s durability setting (set in [run](/api/python/run/)).  \nIn soft durability mode RethinkDB will acknowledge the write immediately after\nreceiving it, but before the write has been committed to disk.\n- `return_changes`: if set to `True`, return a `changes` array consisting of `old_val`/`new_val` objects describing the changes made.\n- `non_atomic`: set to `True` if you want to perform non-atomic replaces (replaces that\nrequire fetching data from another document).\n\nReplace returns an object that contains the following attributes:\n\n- `replaced`: the number of documents that were replaced\n- `unchanged`: the number of documents that would have been modified, except that the\nnew value was the same as the old value\n- `inserted`: the number of new documents added. You can have new documents inserted if\nyou do a point-replace on a key that isn\'t in the table or you do a replace on a\nselection and one of the documents you are replacing has been deleted\n- `deleted`: the number of deleted documents when doing a replace with `None`\n- `errors`: the number of errors encountered while performing the replace.\n- `first_error`: If errors were encountered, contains the text of the first error.\n- `skipped`: 0 for a replace operation\n- `changes`: if `return_changes` is set to `True`, this will be an array of objects, one for each objected affected by the `delete` operation. Each object will have two keys: `{"new_val": <new value>, "old_val": <old value>}`.\n\n*Example* Replace the document with the primary key `1`.\n\n    r.table("posts").get(1).replace({\n        "id": 1,\n        "title": "Lorem ipsum",\n        "content": "Aleas jacta est",\n        "status": "draft"\n    }).run(conn)\n\n*Example* Remove the field `status` from all posts.\n\n    r.table("posts").replace(lambda post:\n        post.without("status")\n    ).run(conn)\n\n*Example* Remove all the fields that are not `id`, `title` or `content`.\n\n    r.table("posts").replace(lambda post:\n        post.pluck("id", "title", "content")\n    ).run(conn)\n\n*Example* Replace the document with the primary key `1` using soft durability.\n\n    r.table("posts").get(1).replace({\n        "id": 1,\n        "title": "Lorem ipsum",\n        "content": "Aleas jacta est",\n        "status": "draft"\n    }, durability="soft").run(conn)\n\n*Example* Replace the document with the primary key `1` and return the values of the document before\nand after the replace operation.\n\n    r.table("posts").get(1).replace({\n        "id": 1,\n        "title": "Lorem ipsum",\n        "content": "Aleas jacta est",\n        "status": "published"\n    }, return_changes=True).run(conn)\n\nThe result will have a `changes` field:\n\n    {\n        "deleted": 0,\n        "errors":  0,\n        "inserted": 0,\n        "changes": [\n            {\n                "new_val": {\n                    "id":1,\n                    "title": "Lorem ipsum"\n                    "content": "Aleas jacta est",\n                    "status": "published",\n                },\n                "old_val": {\n                    "id":1,\n                    "title": "Lorem ipsum"\n                    "content": "TODO",\n                    "status": "draft",\n                    "author": "William",\n                }\n            }\n        ],   \n        "replaced": 1,\n        "skipped": 0,\n        "unchanged": 0\n    }\n'),
	(rethinkdb.ast.Table.sync, b'table.sync() -> object\n\n`sync` ensures that writes on a given table are written to permanent storage. Queries\nthat specify soft durability (`durability=\'soft\'`) do not give such guarantees, so\n`sync` can be used to ensure the state of these queries. A call to `sync` does not return\nuntil all previous writes to the table are persisted.\n\nIf successful, the operation returns an object: `{"synced": 1}`.\n\n*Example* After having updated multiple heroes with soft durability, we now want to wait\nuntil these changes are persisted.\n\n    r.table(\'marvel\').sync().run(conn)\n\n'),
	(rethinkdb.ast.Table.update, b'table.update(json | expr[, durability="hard", return_changes=False, non_atomic=False])\n    -> object\nselection.update(json | expr[, durability="hard", return_changes=False, non_atomic=False])\n    -> object\nsingleSelection.update(json | expr[, durability="hard", return_changes=False, non_atomic=False])\n    -> object\n\nUpdate JSON documents in a table. Accepts a JSON document, a ReQL expression, or a\ncombination of the two.\n\nThe optional arguments are:\n\n- `durability`: possible values are `hard` and `soft`. This option will override the\ntable or query\'s durability setting (set in [run](/api/python/run/)).  \nIn soft durability mode RethinkDB will acknowledge the write immediately after\nreceiving it, but before the write has been committed to disk.\n- `return_changes`: if set to `True`, return a `changes` array consisting of `old_val`/`new_val` objects describing the changes made.\n- `non_atomic`: set to `True` if you want to perform non-atomic updates (updates that\nrequire fetching data from another document).\n\nUpdate returns an object that contains the following attributes:\n\n- `replaced`: the number of documents that were updated.\n- `unchanged`: the number of documents that would have been modified except the new\nvalue was the same as the old value.\n- `skipped`: the number of documents that were skipped because the document didn\'t exist.\n- `errors`: the number of errors encountered while performing the update.\n- `first_error`: If errors were encountered, contains the text of the first error.\n- `deleted` and `inserted`: 0 for an update operation.\n- `changes`: if `return_changes` is set to `True`, this will be an array of objects, one for each objected affected by the `delete` operation. Each object will have two keys: `{"new_val": <new value>, "old_val": <old value>}`.\n\n*Example* Update the status of the post with `id` of `1` to `published`.\n\n    r.table("posts").get(1).update({"status": "published"}).run(conn)\n\n*Example* Update the status of all posts to `published`.\n\n    r.table("posts").update({"status": "published"}).run(conn)\n\n*Example* Update the status of all the post written by William.\n\n    r.table("posts").filter({"author": "William"}).update({"status": "published"}).run(conn)\n\n*Example* Increment the field `view` with `id` of `1`.\nThis query will throw an error if the field `views` doesn\'t exist.\n\n    r.table("posts").get(1).update({\n        "views": r.row["views"]+1\n    }).run(conn)\n\n*Example* Increment the field `view` of the post with `id` of `1`.\nIf the field `views` does not exist, it will be set to `0`.\n\n    r.table("posts").update({\n        "views": (r.row["views"]+1).default(0)\n    }).run(conn)\n\n*Example* Perform a conditional update.  \nIf the post has more than 100 views, set the `type` of a post to `hot`, else set it to `normal`.\n\n    r.table("posts").get(1).update(lambda post:\n        r.branch(\n            post["views"] > 100,\n            {"type": "hot"},\n            {"type": "normal"}\n        )\n    ).run(conn)\n\n*Example* Update the field `num_comments` with the result of a sub-query. Because\nthis update is not atomic, you must pass the `non_atomic` flag.\n\n    r.table("posts").get(1).update({\n        "num_comments": r.table("comments").filter({"id_post": 1}).count()\n    }, non_atomic=True ).run(conn)\n\nIf you forget to specify the `non_atomic` flag, you will get a `RqlRuntimeError`.\n\nRqlRuntimeError: Could not prove function deterministic.  Maybe you want to use the non_atomic flag? \n\n*Example* Update the field `num_comments` with a random value between 0 and 100.  \nThis update cannot be proven deterministic because of `r.js` (and in fact is not), so you\nmust pass the `non_atomic` flag.\n\n    r.table("posts").get(1).update({\n        "num_comments": r.js("Math.floor(Math.random()*100)")\n    }, non_atomic=True ).run(conn)\n\n*Example* Update the status of the post with `id` of `1` using soft durability.\n\n    r.table("posts").get(1).update({status: "published"}, durability="soft").run(conn)\n\n*Example* Increment the field `views` and return the values of the document before\nand after the update operation.\n\n    r.table("posts").get(1).update({\n        "views": r.row["views"]+1\n    }, return_changes=True).run(conn)\n\nThe result will have a `changes` field:\n\n    {\n        "deleted": 1,\n        "errors": 0,\n        "inserted": 0,\n        "changes": [\n            {\n                "new_val": {\n                    "id": 1,\n                    "author": "Julius_Caesar",\n                    "title": "Commentarii de Bello Gallico",\n                    "content": "Aleas jacta est",\n                    "views": 207\n                },\n                "old_val": {\n                    "id": 1,\n                    "author": "Julius_Caesar",\n                    "title": "Commentarii de Bello Gallico",\n                    "content": "Aleas jacta est",\n                    "views": 206\n                }\n            }\n        ],\n        "replaced": 0,\n        "skipped": 0,\n        "unchanged": 0\n    }\n\n'),
]

for function, text in docsSource:
	try:
		text = str(text.decode('utf-8'))
	except UnicodeEncodeError:
		pass
	if hasattr(function, "__func__"):
		function.__func__.__doc__ = text
	else:
		function.__doc__ = text
