#! /usr/bin/env python

from setuptools import setup

def linelist(text):
    """
    Returns each non-blank line in text enclosed in a list.
    """
    return [ l.strip() for l in text.strip().splitlines() if l.split() ]
    
    # The double-mention of l.strip() is yet another fine example of why
    # Python needs en passant aliasing.

setup(
    name='richxerox',
    version='0.01',
    author='Jonathan Eunice',
    author_email='jonathan.eunice@gmail.com',
    description='copy/paste for Mac OS X for rich text (HTML/RTF) rather than plain text',
    long_description=open('README.rst').read(),
    url='',
    py_modules=['richxerox'],
    install_requires=[],
    classifiers=linelist("""
        Development Status :: 3 - Alpha
        Environment :: MacOS X :: Cocoa
        License :: OSI Approved :: BSD License
        Intended Audience :: Developers
        Programming Language :: Python
        Topic :: Software Development :: Libraries :: Python Modules
    """)
)
