#! /usr/bin/env python

from setuptools import setup
from decimal import Decimal
import re

def verno(s):
    """
    Update the version number passed in by extending it to the 
    thousands place and adding 1/1000, then returning that result
    and as a side-effect updating setup.py

    Dangerous, self-modifying, and also, helps keep version numbers
    ascending without human intervention.
    """
    d = Decimal(s)
    increment = Decimal('0.001')
    d = d.quantize(increment) + increment
    dstr = str(d)
    setup = open('setup.py', 'r').read()
    setup = re.sub('verno\(\w*[\'"]([\d\.]+)[\'"]', 'verno("' + dstr + '"', setup)
    open('setup.py', 'w').write(setup)
    return dstr


def linelist(text):
    """
    Returns each non-blank line in text enclosed in a list.
    """
    return [ l.strip() for l in text.strip().splitlines() if l.split() ]
    
    # The double-mention of l.strip() is yet another fine example of why
    # Python needs en passant aliasing.

setup(
    name='richxerox',
    version=verno("0.127"),
    author='Jonathan Eunice',
    author_email='jonathan.eunice@gmail.com',
    description='copy/paste for Mac OS X for rich text (HTML/RTF) rather than plain text',
    long_description=open('README.rst').read(),
    url='https://bitbucket.org/jeunice/richxerox',
    py_modules=['richxerox'],
    install_requires=[],
    classifiers=linelist("""
        Development Status :: 3 - Alpha
        Environment :: MacOS X :: Cocoa
        License :: OSI Approved :: BSD License
        Intended Audience :: Developers
        Programming Language :: Python
        Topic :: Software Development :: Libraries :: Python Modules
    """)
)
