#version=DEVEL
# Firewall configuration
firewall --enabled --service=mdns
# X Window System configuration information
xconfig  --startxonboot
repo --name="fedora" --mirrorlist=http://mirrors.fedoraproject.org/mirrorlist?repo=fedora-$releasever&arch=$basearch
repo --name="updates" --mirrorlist=http://mirrors.fedoraproject.org/mirrorlist?repo=updates-released-f$releasever&arch=$basearch
# System authorization information
auth --useshadow --enablemd5
# System keyboard
keyboard us
# System language
lang en_US
# SELinux configuration
selinux --enforcing
# Installation logging level
logging --level=info

# System services
services --disabled="network,sshd" --enabled="NetworkManager"
# System timezone
timezone  America/New_York
# Disk partitioning information
part / --size=4096

%post
# FIXME: it'd be better to get this installed from a package
cat > /etc/rc.d/init.d/livesys << EOF
#!/bin/bash
#
# live: Init script for live image
#
# chkconfig: 345 00 99
# description: Init script for live image.

. /etc/init.d/functions

if ! strstr "\`cat /proc/cmdline\`" liveimg || [ "\$1" != "start" ]; then
    exit 0
fi

if [ -e /.liveimg-configured ] ; then
    configdone=1
fi

exists() {
    which \$1 >/dev/null 2>&1 || return
    \$*
}

touch /.liveimg-configured

# Make sure we don't mangle the hardware clock on shutdown
ln -sf /dev/null /etc/systemd/system/hwclock-save.service

# mount live image
if [ -b \`readlink -f /dev/live\` ]; then
   mkdir -p /mnt/live
   mount -o ro /dev/live /mnt/live 2>/dev/null || mount /dev/live /mnt/live
fi

livedir="LiveOS"
for arg in \`cat /proc/cmdline\` ; do
  if [ "\${arg##live_dir=}" != "\${arg}" ]; then
    livedir=\${arg##live_dir=}
    return
  fi
done

# enable swaps unless requested otherwise
swaps=\`blkid -t TYPE=swap -o device\`
if ! strstr "\`cat /proc/cmdline\`" noswap && [ -n "\$swaps" ] ; then
  for s in \$swaps ; do
    action "Enabling swap partition \$s" swapon \$s
  done
fi
if ! strstr "\`cat /proc/cmdline\`" noswap && [ -f /mnt/live/\${livedir}/swap.img ] ; then
  action "Enabling swap file" swapon /mnt/live/\${livedir}/swap.img
fi

mountPersistentHome() {
  # support label/uuid
  if [ "\${homedev##LABEL=}" != "\${homedev}" -o "\${homedev##UUID=}" != "\${homedev}" ]; then
    homedev=\`/sbin/blkid -o device -t "\$homedev"\`
  fi

  # if we're given a file rather than a blockdev, loopback it
  if [ "\${homedev##mtd}" != "\${homedev}" ]; then
    # mtd devs don't have a block device but get magic-mounted with -t jffs2
    mountopts="-t jffs2"
  elif [ ! -b "\$homedev" ]; then
    loopdev=\`losetup -f\`
    if [ "\${homedev##/mnt/live}" != "\${homedev}" ]; then
      action "Remounting live store r/w" mount -o remount,rw /mnt/live
    fi
    losetup \$loopdev \$homedev
    homedev=\$loopdev
  fi

  # if it's encrypted, we need to unlock it
  if [ "\$(/sbin/blkid -s TYPE -o value \$homedev 2>/dev/null)" = "crypto_LUKS" ]; then
    echo
    echo "Setting up encrypted /home device"
    plymouth ask-for-password --command="cryptsetup luksOpen \$homedev EncHome"
    homedev=/dev/mapper/EncHome
  fi

  # and finally do the mount
  mount \$mountopts \$homedev /home
  # if we have /home under what's passed for persistent home, then
  # we should make that the real /home.  useful for mtd device on olpc
  if [ -d /home/home ]; then mount --bind /home/home /home ; fi
  [ -x /sbin/restorecon ] && /sbin/restorecon /home
  if [ -d /home/liveuser ]; then USERADDARGS="-M" ; fi
}

findPersistentHome() {
  for arg in \`cat /proc/cmdline\` ; do
    if [ "\${arg##persistenthome=}" != "\${arg}" ]; then
      homedev=\${arg##persistenthome=}
      return
    fi
  done
}

if strstr "\`cat /proc/cmdline\`" persistenthome= ; then
  findPersistentHome
elif [ -e /mnt/live/\${livedir}/home.img ]; then
  homedev=/mnt/live/\${livedir}/home.img
fi

# if we have a persistent /home, then we want to go ahead and mount it
if ! strstr "\`cat /proc/cmdline\`" nopersistenthome && [ -n "\$homedev" ] ; then
  action "Mounting persistent /home" mountPersistentHome
fi

# make it so that we don't do writing to the overlay for things which
# are just tmpdirs/caches
mount -t tmpfs -o mode=0755 varcacheyum /var/cache/yum
mount -t tmpfs tmp /tmp
mount -t tmpfs vartmp /var/tmp
[ -x /sbin/restorecon ] && /sbin/restorecon /var/cache/yum /tmp /var/tmp >/dev/null 2>&1

if [ -n "\$configdone" ]; then
  exit 0
fi

# add fedora user with no passwd
action "Adding live user" useradd \$USERADDARGS -c "Live System User" liveuser
passwd -d liveuser > /dev/null

# turn off firstboot for livecd boots
systemctl --no-reload disable firstboot-text.service 2> /dev/null || :
systemctl --no-reload disable firstboot-graphical.service 2> /dev/null || :
systemctl stop firstboot-text.service 2> /dev/null || :
systemctl stop firstboot-graphical.service 2> /dev/null || :

# don't use prelink on a running live image
sed -i 's/PRELINKING=yes/PRELINKING=no/' /etc/sysconfig/prelink &>/dev/null || :

# turn off mdmonitor by default
systemctl --no-reload disable mdmonitor.service 2> /dev/null || :
systemctl --no-reload disable mdmonitor-takeover.service 2> /dev/null || :
systemctl stop mdmonitor.service 2> /dev/null || :
systemctl stop mdmonitor-takeover.service 2> /dev/null || :

# don't enable the gnome-settings-daemon packagekit plugin
gsettings set org.gnome.settings-daemon.plugins.updates active 'false' || :

# don't start cron/at as they tend to spawn things which are
# disk intensive that are painful on a live image
systemctl --no-reload disable crond.service 2> /dev/null || :
systemctl --no-reload disable atd.service 2> /dev/null || :
systemctl stop crond.service 2> /dev/null || :
systemctl stop atd.service 2> /dev/null || :

# and hack so that we eject the cd on shutdown if we're using a CD...
if strstr "\`cat /proc/cmdline\`" CDLABEL= ; then
  cat >> /sbin/halt.local << FOE
#!/bin/bash
# XXX: This often gets stuck during shutdown because /etc/init.d/halt
#      (or something else still running) wants to read files from the block\
#      device that was ejected.  Disable for now.  Bug #531924
# we want to eject the cd on halt, but let's also try to avoid
# io errors due to not being able to get files...
#cat /sbin/halt > /dev/null
#cat /sbin/reboot > /dev/null
#/usr/sbin/eject -p -m \$(readlink -f /dev/live) >/dev/null 2>&1
#echo "Please remove the CD from your drive and press Enter to finish restarting"
#read -t 30 < /dev/console
FOE
chmod +x /sbin/halt.local
fi

EOF

# bah, hal starts way too late
cat > /etc/rc.d/init.d/livesys-late << EOF
#!/bin/bash
#
# live: Late init script for live image
#
# chkconfig: 345 99 01
# description: Late init script for live image.

. /etc/init.d/functions

if ! strstr "\`cat /proc/cmdline\`" liveimg || [ "\$1" != "start" ] || [ -e /.liveimg-late-configured ] ; then
    exit 0
fi

exists() {
    which \$1 >/dev/null 2>&1 || return
    \$*
}

touch /.liveimg-late-configured

# read some variables out of /proc/cmdline
for o in \`cat /proc/cmdline\` ; do
    case \$o in
    ks=*)
        ks="--kickstart=\${o#ks=}"
        ;;
    xdriver=*)
        xdriver="\${o#xdriver=}"
        ;;
    esac
done

# if liveinst or textinst is given, start anaconda
if strstr "\`cat /proc/cmdline\`" liveinst ; then
   plymouth --quit
   /usr/sbin/liveinst \$ks
fi
if strstr "\`cat /proc/cmdline\`" textinst ; then
   plymouth --quit
   /usr/sbin/liveinst --text \$ks
fi

# configure X, allowing user to override xdriver
if [ -n "\$xdriver" ]; then
   cat > /etc/X11/xorg.conf.d/00-xdriver.conf <<FOE
Section "Device"
	Identifier	"Videocard0"
	Driver	"\$xdriver"
EndSection
FOE
fi

EOF

chmod 755 /etc/rc.d/init.d/livesys
/sbin/restorecon /etc/rc.d/init.d/livesys
/sbin/chkconfig --add livesys

chmod 755 /etc/rc.d/init.d/livesys-late
/sbin/restorecon /etc/rc.d/init.d/livesys-late
/sbin/chkconfig --add livesys-late

# work around for poor key import UI in PackageKit
rm -f /var/lib/rpm/__db*
rpm --import /etc/pki/rpm-gpg/RPM-GPG-KEY-fedora
echo "Packages within this LiveCD"
rpm -qa
# Note that running rpm recreates the rpm db files which aren't needed or wanted
rm -f /var/lib/rpm/__db*

# go ahead and pre-make the man -k cache (#455968)
/usr/bin/mandb

# save a little bit of space at least...
rm -f /boot/initramfs*
# make sure there aren't core files lying around
rm -f /core*

# convince readahead not to collect
# FIXME: for systemd

%end

%post --nochroot
cp $INSTALL_ROOT/usr/share/doc/*-release-*/GPL $LIVE_ROOT/GPL

# only works on x86, x86_64
if [ "$(uname -i)" = "i386" -o "$(uname -i)" = "x86_64" ]; then
  if [ ! -d $LIVE_ROOT/LiveOS ]; then mkdir -p $LIVE_ROOT/LiveOS ; fi
  cp /usr/bin/livecd-iso-to-disk $LIVE_ROOT/LiveOS
fi
%end

%post
cat >> /etc/rc.d/init.d/livesys << EOF
# disable screensaver locking
cat >> /usr/share/glib-2.0/schemas/org.gnome.desktop.screensaver.gschema.override << FOE
[org.gnome.desktop.screensaver]
lock-enabled=false
FOE

# and hide the lock screen option
cat >> /usr/share/glib-2.0/schemas/org.gnome.desktop.lockdown.gschema.override << FOE
[org.gnome.desktop.lockdown]
disable-lock-screen=true
FOE

# disable updates plugin
cat >> /usr/share/glib-2.0/schemas/org.gnome.settings-daemon.plugins.updates.gschema.override << FOE
[org.gnome.settings-daemon.plugins.updates]
active=false
FOE

# make the installer show up
if [ -f /usr/share/applications/liveinst.desktop ]; then
  # Show harddisk install in shell dash
  sed -i -e 's/NoDisplay=true/NoDisplay=false/' /usr/share/applications/liveinst.desktop ""
  # need to move it to anaconda.desktop to make shell happy
  mv /usr/share/applications/liveinst.desktop /usr/share/applications/anaconda.desktop

  cat >> /usr/share/glib-2.0/schemas/org.gnome.shell.gschema.override << FOE
[org.gnome.shell]
favorite-apps=['mozilla-firefox.desktop', 'evolution.desktop', 'empathy.desktop', 'rhythmbox.desktop', 'shotwell.desktop', 'openoffice.org-writer.desktop', 'nautilus.desktop', 'anaconda.desktop']
FOE

fi

# rebuild schema cache with any overrides we installed
glib-compile-schemas /usr/share/glib-2.0/schemas

# set up auto-login
cat >> /etc/gdm/custom.conf << FOE
[daemon]
AutomaticLoginEnable=True
AutomaticLogin=liveuser
FOE

# Turn off PackageKit-command-not-found while uninstalled
if [ -f /etc/PackageKit/CommandNotFound.conf ]; then
  sed -i -e 's/^SoftwareSourceSearch=true/SoftwareSourceSearch=false/' /etc/PackageKit/CommandNotFound.conf
fi

EOF

%end

#%post --nochroot
%post

# This will remove duplicate omni.jar archives created from previous builds
rm -rf /tmp/firefox-omni

#unzip omni.jar
mkdir -p /tmp/firefox-omni
pushd /tmp/firefox-omni
unzip /usr/lib*/firefox/omni.jar

# Create the custom browserconfig.properties file
cat > /tmp/firefox-omni/chrome/en-US/locale/branding/browserconfig.properties <<EOF
browser.startup.homepage=http://foss.rit.edu/ritfedoraspin/spinwelcome.html
EOF

# Create the custom bookmarks.html file
cat > /tmp/firefox-omni/defaults/profile/bookmarks.html <<EOF
<!DOCTYPE NETSCAPE-Bookmark-file-1>
<!-- This is an automatically generated file.
     It will be read and overwritten.
     DO NOT EDIT! -->
<META HTTP-EQUIV="Content-Type" CONTENT="text/html; charset=UTF-8">
<TITLE>Bookmarks</TITLE>
<H1>Bookmarks</H1>

<DL><p>
    <DT><H3 ADD_DATE="961112773" LAST_MODIFIED="1241209009" PERSONAL_TOOLBAR_FOLDER="true">Bookmarks Toolbar</H3>
    <DL><p>
        <DT><A HREF="http://docs.fedoraproject.org/" ADD_DATE="1158286602" LAST_MODIFIED="1176675660" LAST_CHARSET="UTF-8">Fedora Documentation</A>
        <DD>Fedora Documentation.
        <DT><H3 ADD_DATE="1130967903" LAST_MODIFIED="1241211003">Fedora Project</H3>
        <DL><p>
            <DT><A HREF="http://fedoraproject.org/" ADD_DATE="1158286779" LAST_MODIFIED="1176675285" LAST_CHARSET="UTF-8">Fedora Project</A>
            <DD>Home of the Fedora Project.
            <DT><A HREF="http://forums.fedoraforum.org/" ADD_DATE="1130967896" LAST_MODIFIED="1176675301" LAST_CHARSET="ISO-8859-1">Fedora Forum</A>
            <DD>Fedora Forums for community interaction.
            <DT><A HREF="http://fedorasolved.org/" ADD_DATE="1130967896" LAST_MODIFIED="1176675301" LAST_CHARSET="ISO-8859-1">Fedora Solved</A>
            <DD>Community answers to community questions.
            <DT><A HREF="http://fedoraproject.org/wiki/FWN/LatestIssue" ADD_DATE="1176675071" LAST_MODIFIED="1176675310" LAST_CHARSET="ISO-8859-1">Fedora Weekly News</A>
            <DD>Fedora Weekly News.
            <DT><A HREF="http://planet.fedoraproject.org/" ADD_DATE="1176675201" LAST_MODIFIED="1241208858" LAST_CHARSET="UTF-8">Planet Fedora</A>
            <DD>Blogs by Fedora contributors.
            <DT><A HREF="http://fedoraproject.org/en/join-fedora" ADD_DATE="1241209418" LAST_MODIFIED="1241209719">Join Fedora!</A>
            <DD>Join the Fedora Project!
        </DL><p>
      
        <DT><H3 ADD_DATE="1176674113" LAST_MODIFIED="1241208802">Red Hat</H3>
        <DL><p>
            <DT><A HREF="http://www.redhat.com/" ADD_DATE="1176674148" LAST_MODIFIED="1176674158" LAST_CHARSET="ISO-8859-1">Red Hat</A>
            <DD>Home of Red Hat, sponsor of the Fedora Project.
            <DT><A HREF="http://www.jboss.org/" ADD_DATE="1176674189" LAST_MODIFIED="1176674200" LAST_CHARSET="UTF-8">JBoss</A>
            <DD>Home of the JBoss community, sponsored by Red Hat.
            <DT><A HREF="http://opensource.com/" ADD_DATE="1269287471" LAST_MODIFIED="1176674200">OpenSource.com</A>
            <DD>Open Source applied to the world.
            <DT><A HREF="http://theopensourceway.org/" ADD_DATE="1269287471" LAST_MODIFIED="1176674200">The Open Source Way</A>
            <DD>Community authored open source best practices.
        </DL><p>

        <DT><H3 ADD_DATE="1176674388" LAST_MODIFIED="1241209425">Free Content</H3>
        <DL><p>
            <DT><A HREF="http://www.wikipedia.org/" ADD_DATE="1176674401" LAST_MODIFIED="1176675382" LAST_CHARSET="UTF-8">Wikipedia</A>
            <DD>Collaborative encycolpedia.
            <DT><A HREF="http://librivox.org/" ADD_DATE="1241209006" LAST_MODIFIED="1241209033">LibriVox</A>
            <DD>Freely licensed audio books.
            <DT><A HREF="http://www.openclipart.org/" ADD_DATE="1269287471" LAST_MODIFIED="1241209033">Open Clip Art</A>
            <DD>Freely licensed clip art.
            <DT><A HREF="http://www.freesound.org/" ADD_DATE="1269287471" LAST_MODIFIED="1241209033">Free Sound</A>
            <DD>Freely licensed sound.
            <DT><A HREF="http://creativecommons.org/" ADD_DATE="1176674776" LAST_MODIFIED="1176675626" LAST_CHARSET="UTF-8">Creative Commons</A>
            <DD>Free licenses for creative work.
        </DL><p>
        <DT><A FEEDURL="http://foss.rit.edu/files/bookmarks.rss" HREF="http://fss.rit.edu">RIT Bookmarks</A>
        </DL><p>
</DL><p>
EOF

# Zip things back up
# >/dev/null will mute output
zip -9 -r omni.jar * >/dev/null

mv omni.jar /usr/lib*/firefox/omni.jar


# go to the backgrounds folder for custom images
cd /usr/share/backgrounds/images

# fetch custom RIT backgrounds
# note: resolv.conf is not yet set up, so we have to use the hosting ip directly
su -c "wget --header=\"Host: foss.rit.edu\" http://129.21.49.21/ritfedoraremix/RIT_1280x1024.png"
su -c "wget --header=\"Host: foss.rit.edu\" http://129.21.49.21/ritfedoraremix/RIT_2048x1536.png"
su -c "wget --header=\"Host: foss.rit.edu\" http://129.21.49.21/ritfedoraremix/RIT_1920x1200.png"
su -c "wget --header=\"Host: foss.rit.edu\" http://129.21.49.21/ritfedoraremix/tiger_1280x1024.png"
su -c "wget --header=\"Host: foss.rit.edu\" http://129.21.49.21/ritfedoraremix/tiger_2048x1536.png"
su -c "wget --header=\"Host: foss.rit.edu\" http://129.21.49.21/ritfedoraremix/tiger_1920x1200.png"
su -c "wget --header=\"Host: foss.rit.edu\" http://129.21.49.21/ritfedoraremix/sentinel_1280x800.png"
su -c "wget --header=\"Host: foss.rit.edu\" http://129.21.49.21/ritfedoraremix/celebration_1280x800.png"

# normalish (1280 x 1024)
su -c "cp /usr/share/backgrounds/lovelock/default-stripes/normalish/lovelock.png /usr/share/backgrounds/lovelock/default-stripes/normalish/lovelock.png.backup"
su -c "rm /usr/share/backgrounds/lovelock/default-stripes/normalish/lovelock.png"
su -c "cp /usr/share/backgrounds/images/tiger_1280x1024.png /usr/share/backgrounds/lovelock/default-stripes/normalish/lovelock.png"

# standard (2048x1536)
su -c "cp /usr/share/backgrounds/lovelock/default-stripes/standard/lovelock.png /usr/share/backgrounds/lovelock/default-stripes/standard/lovelock.png.backup"
su -c "rm /usr/share/backgrounds/lovelock/default-stripes/standard/lovelock.png"
su -c "cp /usr/share/backgrounds/images/tiger_2048x1536.png /usr/share/backgrounds/lovelock/default-stripes/standard/lovelock.png"

# wide (1920x1200)
su -c "cp /usr/share/backgrounds/lovelock/default-stripes/wide/lovelock.png /usr/share/backgrounds/lovelock/default-stripes/wide/lovelock.png.backup"
su -c "rm /usr/share/backgrounds/lovelock/default-stripes/wide/lovelock.png"
su -c "cp /usr/share/backgrounds/images/tiger_1920x1200.png /usr/share/backgrounds/lovelock/default-stripes/wide/lovelock.png"


# Fetch rpm fusion scripts
su -c "mkdir -p /usr/share/autostart"

su -c "wget --header=\"Host: foss.rit.edu\" http://129.21.49.21/ritfedoraremix/enablerpmfusion.txt"
su -c "wget --header=\"Host: foss.rit.edu\" http://129.21.49.21/ritfedoraremix/FusionEnableLauncher.txt"
su -c "mv FusionEnableLauncher.txt FusionEnableLauncher.py"
su -c "mv enablerpmfusion.txt enablerpmfusion.sh"
su -c "chmod a+rwx FusionEnableLauncher.py"
su -c "chmod a+rwx enablerpmfusion.sh"

su -c "cp FusionEnableLauncher.py /usr/share/autostart/FusionEnableLauncher.py"
su -c "cp enablerpmfusion.sh /usr/share/autostart/enablerpmfusion.sh"

%end

%packages
@admin-tools
@base
@base-x
@core
@dial-up
@fonts
@gnome-desktop
@graphical-internet
@hardware-support
@input-methods
@office
@printing
@sound-and-video
anaconda
efibootmgr
fpaste
grub-efi
grub2
ibus-pinyin-db-android
isomd5sum
kernel
memtest86+
nss-mdns
-ibus-gnome3
-ibus-pinyin-db-open-phrase
-smartmontools

%end
