# Dorrie - Web interface for building Fedora Spins/Remixes
# Copyright (C) 2009 Red Hat Inc.
# Author: Shreyank Gupta <sgupta@redhat.com>

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU Affero General Public License as
# published by the Free Software Foundation, either version 3 of the
# License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Affero General Public License for more details.

# You should have received a copy of the GNU Affero General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# Django settings for dorrie project.

import os
import subprocess

# The directory of the project
APP_ROOT = os.path.dirname(os.path.abspath(__file__))

DEBUG = True
TEMPLATE_DEBUG = DEBUG

# Serve static files from the Django development web server?
STATIC_SERVE = True

ADMINS = (
    # ('Your Name', 'your_email@domain.com'),
)

MANAGERS = ADMINS

DATABASE_ENGINE = 'sqlite3'           # 'postgresql_psycopg2', 'postgresql',
#'mysql', 'sqlite3' or 'oracle'.
# DB Name is path to database file if using sqlite3.
DATABASE_NAME = os.path.join(APP_ROOT, 'dorrie.sqlite3')
DATABASE_USER = ''             # Not used with sqlite3.
DATABASE_PASSWORD = ''         # Not used with sqlite3.
DATABASE_HOST = ''             # Set to empty string for localhost. Not used
#                                with sqlite3.
DATABASE_PORT = ''             # Set to empty string for default. Not used with
#                                sqlite3.

# Local time zone for this installation. Choices can be found here:
# http://en.wikipedia.org/wiki/List_of_tz_zones_by_name
# although not all choices may be available on all operating systems.
# If running in a Windows environment this must be set to the same as your
# system time zone.
TIME_ZONE = 'America/Chicago'

# Language code for this installation. All choices can be found here:
# http://www.i18nguy.com/unicode/language-identifiers.html
LANGUAGE_CODE = 'en-us'

SITE_ID = 1

# If you set this to False, Django will make some optimizations so as not
# to load the internationalization machinery.
USE_I18N = True

# Absolute path to the directory that holds media.
# Example: "/home/media/media.lawrence.com/"
MEDIA_ROOT = os.path.join(APP_ROOT, 'comps/media')

# URL that handles the media served from MEDIA_ROOT. Make sure to use a
# trailing slash if there is a path component (optional in other cases).
# Examples: "http://media.lawrence.com", "http://example.com/media/"
MEDIA_URL = ''

# URL prefix for admin media -- CSS, JavaScript and images. Make sure to use a
# trailing slash.
# Examples: "http://foo.com/media/", "/media/".
ADMIN_MEDIA_PREFIX = '/media/'

# Make this unique, and don't share it with anybody.
SECRET_KEY = 'k1t7g+u*^80=e@^3efkmwqqtvj@6)pvoakjgagmo3*#jov^t%v'

# List of callables that know how to import templates from various sources.
TEMPLATE_LOADERS = (
    'django.template.loaders.filesystem.load_template_source',
    'django.template.loaders.app_directories.load_template_source',
#     'django.template.loaders.eggs.load_template_source',
)

MIDDLEWARE_CLASSES = (
    'django.middleware.common.CommonMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
)

ROOT_URLCONF = 'dorrie.urls'

TEMPLATE_DIRS = (
    '%scomps/templates/' % APP_ROOT,
)

INSTALLED_APPS = (
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'comps',
)

# Get the release version of the host OS
p = subprocess.Popen(['cat', '/etc/fedora-release'], stdout=subprocess.PIPE)
pout = p.communicate()[0]
RELEASE_VER = pout.split(" ")[2]
COMPS_URL = 'http://git.fedorahosted.org/git/?p=comps.git;a=blob_plain;f=comps-f' + RELEASE_VER + '.xml.in;hb=HEAD'

#COMPS_URL = 'http://git.fedorahosted.org/git/?p=comps.git;a=blob_plain;\
#f=comps-f16.xml.in;hb=HEAD'
# If you are running Fedora 15, uncomment the 2 lines below, and comment
# out the line above
#COMPS_URL = 'http://git.fedorahosted.org/git/?p=comps.git;a=blob_plain;\
#f=comps-f15.xml.in;hb=HEAD'

KS_DIR = '/usr/share/spin-kickstarts/'

# cache to store the built KS files and spins (Read 'lots of GBs')
CACHE = '/tmp/'
# Local fedora repository to the folder that contains Packages
REPO = ''

TESTING = False
