/*!
* TableSorter 2.3.11 - Client-side table sorting with ease!
* Minified using UglifyJS (http://jscompress.com/)
* Copyright (c) 2007 Christian Bach
*/
!function($){$.extend({tablesorter:new function(){function log(a){if(typeof console!=="undefined"&&typeof console.log!=="undefined"){console.log(a)}else{alert(a)}}function benchmark(a,b){log(a+" ("+((new Date).getTime()-b.getTime())+"ms)")}function getElementText(a,b,c){if(!b){return""}var d=a.config,e=d.textExtraction,f="";if(e==="simple"){if(d.supportsTextContent){f=b.textContent}else{f=$(b).text()}}else{if(typeof e==="function"){f=e(b,a,c)}else if(typeof e==="object"&&e.hasOwnProperty(c)){f=e[c](b,a,c)}else{f=d.supportsTextContent?b.textContent:$(b).text()}}return $.trim(f)}function getParserById(a){var b,c=parsers.length;for(b=0;b<c;b++){if(parsers[b].id.toLowerCase()===a.toString().toLowerCase()){return parsers[b]}}return false}function detectParserForColumn(a,b,c,d){var e,f=parsers.length,g=false,h="",i=true;while(h===""&&i){c++;if(b[c]){g=b[c].cells[d];h=getElementText(a,g,d);if(a.config.debug){log("Checking if value was empty on row "+c+", column: "+d+": "+h)}}else{i=false}}for(e=1;e<f;e++){if(parsers[e].is(h,a,g)){return parsers[e]}}return parsers[0]}function buildParserCache(a,b){var c=a.config,d=$(a.tBodies).filter(":not(."+c.cssInfoBlock+")"),e=$.tablesorter,f,g,h,i,j,k,l,m,n,o="";if(d.length===0){return}f=d[0].rows;if(f[0]){g=[];h=f[0].cells.length;for(i=0;i<h;i++){j=b.filter(':not([colspan])[data-column="'+i+'"]:last,[colspan="1"][data-column="'+i+'"]:last');l=c.headers[i];n=getParserById(e.getData(j,l,"sorter"));c.empties[i]=e.getData(j,l,"empty")||c.emptyTo||(c.emptyToBottom?"bottom":"top");c.strings[i]=e.getData(j,l,"string")||c.stringTo||"max";if(!n){n=detectParserForColumn(a,f,-1,i)}if(c.debug){o+="column:"+i+"; parser:"+n.id+"; string:"+c.strings[i]+"; empty: "+c.empties[i]+"\n"}g.push(n)}}if(c.debug){log(o)}return g}function buildCache(a){var b=a.tBodies,c=a.config,d,e,f=c.parsers,g,h,i,j,k,l,m;c.cache={};if(c.debug){m=new Date}for(j=0;j<b.length;j++){c.cache[j]={row:[],normalized:[]};if(!$(b[j]).hasClass(c.cssInfoBlock)){$(b[j]).addClass("tablesorter-hidden");d=b[j]&&b[j].rows.length||0;e=b[j].rows[0]&&b[j].rows[0].cells.length||0;for(h=0;h<d;++h){k=$(b[j].rows[h]);l=[];if(k.hasClass(c.cssChildRow)){c.cache[j].row[c.cache[j].row.length-1]=c.cache[j].row[c.cache[j].row.length-1].add(k);continue}c.cache[j].row.push(k);for(i=0;i<e;++i){g=getElementText(a,k[0].cells[i],i);l.push(f[i].format(g,a,k[0].cells[i],i))}l.push(c.cache[j].normalized.length);c.cache[j].normalized.push(l)}$(b[j]).removeClass("tablesorter-hidden")}}if(c.debug){benchmark("Building cache for "+d+" rows",m)}}function getWidgetById(a){var b,c,d=widgets.length;for(b=0;b<d;b++){c=widgets[b];if(c&&c.hasOwnProperty("id")&&c.id.toLowerCase()===a.toLowerCase()){return c}}}function applyWidget(a,b){var c=a.config,d=c.widgets,e,f,g,h=d.length;if(c.debug){e=new Date}for(f=0;f<h;f++){g=getWidgetById(d[f]);if(g){if(b===true&&g.hasOwnProperty("init")){g.init(a,widgets,g)}else if(!b&&g.hasOwnProperty("format")){g.format(a)}}}if(c.debug){benchmark("Completed "+(b===true?"initializing":"applying")+" widgets",e)}}function appendToTable(a,b){var c=a.config,d=a.tBodies,e=[],f,g,h,i,j=c.cache,k,l,m,n,o,p,q;if(c.debug){q=new Date}for(n=0;n<d.length;n++){if(!$(d[n]).hasClass(c.cssInfoBlock)){$(d[n]).addClass("tablesorter-hidden");k=document.createDocumentFragment();f=j[n].row;g=j[n].normalized;h=g.length;i=h?g[0].length-1:0;for(l=0;l<h;l++){p=g[l][i];e.push(f[p]);if(!c.appender||!c.removeRows){o=f[p].length;for(m=0;m<o;m++){k.appendChild(f[p][m])}}}a.tBodies[n].appendChild(k);$(d[n]).removeClass("tablesorter-hidden")}}if(c.appender){c.appender(a,e)}if(c.debug){benchmark("Rebuilt table",q)}if(!b){applyWidget(a)}$(a).trigger("sortEnd",a)}function computeThIndexes(a){var b=[],c={},d=$(a).find("thead:eq(0) tr"),e,f,g,h,i,j,k,l,m,n,o,p;for(e=0;e<d.length;e++){j=d[e].cells;for(f=0;f<j.length;f++){i=j[f];k=i.parentNode.rowIndex;l=k+"-"+i.cellIndex;m=i.rowSpan||1;n=i.colSpan||1;if(typeof b[k]==="undefined"){b[k]=[]}for(g=0;g<b[k].length+1;g++){if(typeof b[k][g]==="undefined"){o=g;break}}c[l]=o;$(i).attr({"data-column":o});for(g=k;g<k+m;g++){if(typeof b[g]==="undefined"){b[g]=[]}p=b[g];for(h=o;h<o+n;h++){p[h]="x"}}}}return c}function formatSortingOrder(a){return/^d/i.test(a)||a===1}function buildHeaders(a){var b=computeThIndexes(a),c,d,e,f,g,h,i=a.config,j=$.tablesorter;i.headerList=[];if(i.debug){g=new Date}h=$(a).find(i.selectorHeaders).each(function(a){d=$(this);c=i.headers[a];this.innerHTML='<div class="tablesorter-header-inner">'+this.innerHTML+"</div>";if(i.onRenderHeader){i.onRenderHeader.apply(d,[a])}this.column=b[this.parentNode.rowIndex+"-"+this.cellIndex];this.order=formatSortingOrder(j.getData(d,c,"sortInitialOrder")||i.sortInitialOrder)?[1,0,2]:[0,1,2];this.count=-1;if(j.getData(d,c,"sorter")==="false"){this.sortDisabled=true}this.lockedOrder=false;f=j.getData(d,c,"lockedOrder")||false;if(typeof f!=="undefined"&&f!==false){this.order=this.lockedOrder=formatSortingOrder(f)?[1,1,1]:[0,0,0]}if(!this.sortDisabled){e=d.addClass(i.cssHeader)}i.headerList[a]=this;d.parent().addClass(i.cssHeader)});if(a.config.debug){benchmark("Built headers:",g);log(h)}return h}function isValueInArray(a,b){var c,d=b.length;for(c=0;c<d;c++){if(b[c][0]===a){return true}}return false}function setHeadersCss(a,b,c){var d,e=[],f,g,h,i=[a.config.cssDesc,a.config.cssAsc];b.removeClass(i.join(" ")).each(function(){if(!this.sortDisabled){e[this.column]=$(this)}});h=c.length;for(f=0;f<h;f++){if(c[f][1]===2){continue}if(e[c[f][0]]){e[c[f][0]].addClass(i[c[f][1]])}d=b.filter('[data-column="'+c[f][0]+'"]');if(h>1&&d.length){for(g=0;g<d.length;g++){if(!d[g].sortDisabled){$(d[g]).addClass(i[c[f][1]])}}}}}function fixColumnWidth(a){if(a.config.widthFixed){var b=$("<colgroup>");$("tr:first td",a.tBodies[0]).each(function(){b.append($("<col>").css("width",$(this).width()))});$(a).prepend(b)}}function updateHeaderSortCount(a,b){var c,d,e,f=a.config,g=b.length;for(c=0;c<g;c++){d=b[c];e=f.headerList[d[0]];if(e){e.count=d[1]%(f.sortReset?3:2)}}}function getCachedSortType(a,b){return a&&a[b]?a[b].type||"":""}function multisort(table,sortList){var dynamicExp,sortWrapper,col,mx=0,dir=0,tc=table.config,l=sortList.length,bl=table.tBodies.length,sortTime,i,j,k,c,cache,lc,s,e,order,orgOrderCol;if(tc.debug){sortTime=new Date}for(k=0;k<bl;k++){dynamicExp="sortWrapper = function(a,b) {";cache=tc.cache[k];lc=cache.normalized.length;for(i=0;i<l;i++){c=sortList[i][0];order=sortList[i][1];s=/n/i.test(getCachedSortType(tc.parsers,c))?"Numeric":"Text";s+=order===0?"":"Desc";e="e"+i;if(/Numeric/.test(s)&&tc.strings[c]){for(j=0;j<lc;j++){col=Math.abs(parseFloat(cache.normalized[j][c]));mx=Math.max(mx,isNaN(col)?0:col)}if(typeof tc.string[tc.strings[c]]==="boolean"){dir=(order===0?1:-1)*(tc.string[tc.strings[c]]?-1:1)}else{dir=tc.strings[c]?tc.string[tc.strings[c]]||0:0}}dynamicExp+="var "+e+" = $.tablesorter.sort"+s+"(table,a["+c+"],b["+c+"],"+c+","+mx+","+dir+"); ";dynamicExp+="if ("+e+") { return "+e+"; } ";dynamicExp+="else { "}orgOrderCol=cache.normalized&&cache.normalized[0]?cache.normalized[0].length-1:0;dynamicExp+="return a["+orgOrderCol+"]-b["+orgOrderCol+"];";for(i=0;i<l;i++){dynamicExp+="}; "}dynamicExp+="return 0; ";dynamicExp+="}; ";cache.normalized.sort(eval(dynamicExp))}if(tc.debug){benchmark("Sorting on "+sortList.toString()+" and dir "+order+" time",sortTime)}}function checkResort(a,b,c){var d=a[0];if(b!==false){a.trigger("sorton",[d.config.sortList,function(){a.trigger("updateComplete");if(typeof c==="function"){c(d)}}])}else{a.trigger("updateComplete");if(typeof c==="function"){c(d)}}}this.version="2.3.11";var parsers=[],widgets=[];this.defaults={widthFixed:false,cancelSelection:true,dateFormat:"mmddyyyy",sortMultiSortKey:"shiftKey",usNumberFormat:true,delayInit:false,headers:{},ignoreCase:true,sortForce:null,sortList:[],sortAppend:null,sortInitialOrder:"asc",sortLocaleCompare:false,sortReset:false,sortRestart:false,emptyTo:"bottom",stringTo:"max",textExtraction:"simple",textSorter:null,widgets:[],widgetOptions:{zebra:["even","odd"]},initWidgets:true,initialized:null,onRenderHeader:null,tableClass:"tablesorter",cssAsc:"tablesorter-headerSortUp",cssChildRow:"expand-child",cssDesc:"tablesorter-headerSortDown",cssHeader:"tablesorter-header",cssInfoBlock:"tablesorter-infoOnly",selectorHeaders:"> thead th",selectorRemove:"tr.remove-me",debug:false,headerList:[],empties:{},strings:{},parsers:[]};this.benchmark=benchmark;this.hasInitialized=false;this.construct=function(a){return this.each(function(){if(!this.tHead||this.tBodies.length===0){return}var b,c,d,e,f,g,h,i,j,k,l,m=$.metadata;this.config={};e=$.extend(true,this.config,$.tablesorter.defaults,a);if(e.debug){$.data(this,"startoveralltimer",new Date)}d=$(this).addClass(e.tableClass);$.data(this,"tablesorter",e);e.supportsTextContent=$("<span>x</span>")[0].textContent==="x";e.string={max:1,min:-1,"max+":1,"max-":-1,zero:0,none:0,"null":0,top:true,bottom:false};b=buildHeaders(this);e.parsers=buildParserCache(this,b);if(!e.delayInit){buildCache(this)}fixColumnWidth(this);b.bind("mousedown.tablesorter mouseup.tablesorter",function(a,m){if(a.type==="mousedown"){l=(new Date).getTime();return!e.cancelSelection}if(m!==true&&(new Date).getTime()-l>500){return false}if(e.delayInit&&!e.cache){buildCache(d[0])}if(!this.sortDisabled){d.trigger("sortStart",d[0]);c=$(this);h=!a[e.sortMultiSortKey];this.count=(this.count+1)%(e.sortReset?3:2);if(e.sortRestart){f=this;b.each(function(){if(this!==f&&(h||!$(this).is("."+e.cssDesc+",."+e.cssAsc))){this.count=-1}})}f=this.column;if(h){e.sortList=[];if(e.sortForce!==null){i=e.sortForce;for(g=0;g<i.length;g++){if(i[g][0]!==f){e.sortList.push(i[g])}}}k=this.order[this.count];if(k<2){e.sortList.push([f,k]);if(this.colSpan>1){for(g=1;g<this.colSpan;g++){e.sortList.push([f+g,k])}}}}else{if(isValueInArray(f,e.sortList)){for(g=0;g<e.sortList.length;g++){j=e.sortList[g];k=e.headerList[j[0]];if(j[0]===f){j[1]=k.order[k.count];if(j[1]===2){e.sortList.splice(g,1);k.count=-1}}}}else{k=this.order[this.count];if(k<2){e.sortList.push([f,k]);if(this.colSpan>1){for(g=1;g<this.colSpan;g++){e.sortList.push([f+g,k])}}}}}if(e.sortAppend!==null){i=e.sortAppend;for(g=0;g<i.length;g++){if(i[g][0]!==f){e.sortList.push(i[g])}}}d.trigger("sortBegin",d[0]);setHeadersCss(d[0],b,e.sortList);multisort(d[0],e.sortList);appendToTable(d[0])}});if(e.cancelSelection){b.each(function(){this.onselectstart=function(){return false}})}d.bind("update",function(a,c,f){$(e.selectorRemove,this).remove();e.parsers=buildParserCache(this,b);buildCache(this);checkResort(d,c,f)}).bind("updateCell",function(a,b,c,f){var g=this,h=$(this).find("tbody"),i,j,k=h.index($(b).closest("tbody"));i=h.eq(k).find("tr").index($(b).closest("tr"));j=[i,b.cellIndex];g.config.cache[k].normalized[j[0]][j[1]]=e.parsers[j[1]].format(getElementText(g,b,j[1]),g,b,j[1]);checkResort(d,c,f)}).bind("addRows",function(a,b,c,f){var h,i=b.filter("tr").length,j=[],k=b[0].cells.length,l=this,m=$(this).find("tbody").index(b.closest("tbody"));for(h=0;h<i;h++){for(g=0;g<k;g++){j[g]=e.parsers[g].format(getElementText(l,b[h].cells[g],g),l,b[h].cells[g],g)}j.push(e.cache[m].row.length);e.cache[m].row.push([b[h]]);e.cache[m].normalized.push(j);j=[]}checkResort(d,c,f)}).bind("sorton",function(a,c,d,f){$(this).trigger("sortStart",this);var g=e.headerList.length;e.sortList=[];$.each(c,function(a,b){if(b[0]<g){e.sortList.push(c[a])}});updateHeaderSortCount(this,e.sortList);setHeadersCss(this,b,e.sortList);multisort(this,e.sortList);appendToTable(this,f);if(typeof d==="function"){d(this)}}).bind("appendCache",function(a,b){appendToTable(this,b)}).bind("applyWidgetId",function(a,b){getWidgetById(b).format(this)}).bind("applyWidgets",function(a,b){applyWidget(this,b)}).bind("destroy",function(a,b){$.tablesorter.destroy(this,b)});if(d.data()&&typeof d.data().sortlist!=="undefined"){e.sortList=d.data().sortlist}else if(m&&d.metadata()&&d.metadata().sortlist){e.sortList=d.metadata().sortlist}applyWidget(this,true);if(e.sortList.length>0){d.trigger("sorton",[e.sortList,{},!e.initWidgets])}else if(e.initWidgets){applyWidget(this)}this.hasInitialized=true;if(e.debug){$.tablesorter.benchmark("Overall initialization time",$.data(this,"startoveralltimer"))}d.trigger("tablesorter-initialized",this);if(typeof e.initialized==="function"){e.initialized(this)}})};this.sortText=function(a,b,c,d){if(b===c){return 0}var e=a.config,f=e.string[e.empties[d]||e.emptyTo],g=$.tablesorter.regex,h,i,j,k,l,m,n,o;if(b===""&&f!==0){return typeof f==="boolean"?f?-1:1:-f||-1}if(c===""&&f!==0){return typeof f==="boolean"?f?1:-1:f||1}if(typeof e.textSorter==="function"){return e.textSorter(b,c,a,d)}h=b.replace(g[0],"\\0$1\\0").replace(/\\0$/,"").replace(/^\\0/,"").split("\\0");j=c.replace(g[0],"\\0$1\\0").replace(/\\0$/,"").replace(/^\\0/,"").split("\\0");i=parseInt(b.match(g[2]),16)||h.length!==1&&b.match(g[1])&&Date.parse(b);k=parseInt(c.match(g[2]),16)||i&&c.match(g[1])&&Date.parse(c)||null;if(k){if(i<k){return-1}if(i>k){return 1}}o=Math.max(h.length,j.length);for(n=0;n<o;n++){l=!(h[n]||"").match(g[3])&&parseFloat(h[n])||h[n]||0;m=!(j[n]||"").match(g[3])&&parseFloat(j[n])||j[n]||0;if(isNaN(l)!==isNaN(m)){return isNaN(l)?1:-1}if(typeof l!==typeof m){l+="";m+=""}if(l<m){return-1}if(l>m){return 1}}return 0};this.sortTextDesc=function(a,b,c,d){if(b===c){return 0}var e=a.config,f=e.string[e.empties[d]||e.emptyTo];if(b===""&&f!==0){return typeof f==="boolean"?f?-1:1:f||1}if(c===""&&f!==0){return typeof f==="boolean"?f?1:-1:-f||-1}if(typeof e.textSorter==="function"){return e.textSorter(c,b,a,d)}return this.sortText(a,c,b)};this.getTextValue=function(a,b,c){if(b){var d,e=a.length,f=b+c;for(d=0;d<e;d++){f+=a.charCodeAt(d)}return c*f}return 0};this.sortNumeric=function(a,b,c,d,e,f){if(b===c){return 0}var g=a.config,h=g.string[g.empties[d]||g.emptyTo];if(b===""&&h!==0){return typeof h==="boolean"?h?-1:1:-h||-1}if(c===""&&h!==0){return typeof h==="boolean"?h?1:-1:h||1}if(isNaN(b)){b=this.getTextValue(b,e,f)}if(isNaN(c)){c=this.getTextValue(c,e,f)}return b-c};this.sortNumericDesc=function(a,b,c,d,e,f){if(b===c){return 0}var g=a.config,h=g.string[g.empties[d]||g.emptyTo];if(b===""&&h!==0){return typeof h==="boolean"?h?-1:1:h||1}if(c===""&&h!==0){return typeof h==="boolean"?h?1:-1:-h||-1}if(isNaN(b)){b=this.getTextValue(b,e,f)}if(isNaN(c)){c=this.getTextValue(c,e,f)}return c-b};this.destroy=function(a,b){var c=$(a),d=a.config;c.find("thead:first tr:not(."+d.cssHeader+")").remove();c.find("thead:first .tablesorter-resizer").remove();c.unbind("update updateCell addRows sorton appendCache applyWidgetId applyWidgets destroy mouseup mouseleave").find(d.selectorHeaders).unbind("click mousedown mousemove mouseup").removeClass(d.cssHeader+" "+d.cssAsc+" "+d.cssDesc);if(b!==false){c.removeClass(d.tableClass)}};this.addParser=function(a){var b,c=parsers.length,d=true;for(b=0;b<c;b++){if(parsers[b].id.toLowerCase()===a.id.toLowerCase()){d=false}}if(d){parsers.push(a)}};this.addWidget=function(a){widgets.push(a)};this.formatFloat=function(a,b){if(typeof a!=="string"||a===""){return a}if(b.config.usNumberFormat!==false){a=a.replace(/,/g,"")}else{a=a.replace(/[\s|\.]/g,"").replace(/,/g,".")}if(/^\s*\([.\d]+\)/.test(a)){a=a.replace(/^\s*\(/,"-").replace(/\)/,"")}var c=parseFloat(a);return isNaN(c)?$.trim(a):c};this.isDigit=function(a){return/^[\-+(]?\d+[)]?$/.test(a.replace(/[,.'\s]/g,""))};this.regex=[/(^-?[0-9]+(\.?[0-9]*)[df]?e?[0-9]?$|^0x[0-9a-f]+$|[0-9]+)/gi,/(^([\w ]+,?[\w ]+)?[\w ]+,?[\w ]+\d+:\d+(:\d+)?[\w ]?|^\d{1,4}[\/\-]\d{1,4}[\/\-]\d{1,4}|^\w+, \w+ \d+, \d{4})/,/^0x[0-9a-f]+$/i,/^0/];this.characterEquivalents={a:"\u00e1\u00e0\u00e2\u00e3\u00e4",A:"\u00c1\u00c0\u00c2\u00c3\u00c4",c:"\u00e7",C:"\u00c7",e:"\u00e9\u00e8\u00ea\u00eb",E:"\u00c9\u00c8\u00ca\u00cb",i:"\u00ed\u00ec\u0130\u00ee\u00ef",I:"\u00cd\u00cc\u0130\u00ce\u00cf",o:"\u00f3\u00f2\u00f4\u00f5\u00f6",O:"\u00d3\u00d2\u00d4\u00d5\u00d6",S:"\u00df",u:"\u00fa\u00f9\u00fb\u00fc",U:"\u00da\u00d9\u00db\u00dc"};this.replaceAccents=function(a){var b,c="[",d=this.characterEquivalents;if(!this.characterRegex){this.characterRegexArray={};for(b in d){if(typeof b==="string"){c+=d[b];this.characterRegexArray[b]=new RegExp("["+d[b]+"]","g")}}this.characterRegex=new RegExp(c+"]")}if(this.characterRegex.test(a)){for(b in d){if(typeof b==="string"){a=a.replace(this.characterRegexArray[b],b)}}}return a};this.getData=function(a,b,c){var d="",e=$(a),f,g;if(!e.length){return""}f=$.metadata?e.metadata():false;g=" "+(e.attr("class")||"");if(e.data()&&(typeof e.data(c)!=="undefined"||typeof e.data(c.toLowerCase())!=="undefined")){d+=e.data(c)||e.data(c.toLowerCase())}else if(f&&typeof f[c]!=="undefined"){d+=f[c]}else if(b&&typeof b[c]!=="undefined"){d+=b[c]}else if(g&&g.match(" "+c+"-")){d=g.match(new RegExp(" "+c+"-(\\w+)"))[1]||""}return $.trim(d)};this.clearTableBody=function(a){$(a.tBodies).filter(":not(."+a.config.cssInfoBlock+")").empty()}}})();var ts=$.tablesorter;$.fn.extend({tablesorter:ts.construct});ts.addParser({id:"text",is:function(a,b,c){return true},format:function(a,b,c,d){var e=b.config;a=$.trim(e.ignoreCase?a.toLocaleLowerCase():a);return e.sortLocaleCompare?ts.replaceAccents(a):a},type:"text"});ts.addParser({id:"currency",is:function(a){return/^\(?[\u00a3$\u20ac\u00a4\u00a5\u00a2?.]\d+/.test(a)},format:function(a,b){return ts.formatFloat(a.replace(/[^\w,. \-()]/g,""),b)},type:"numeric"});ts.addParser({id:"ipAddress",is:function(a){return/^\d{1,3}[\.]\d{1,3}[\.]\d{1,3}[\.]\d{1,3}$/.test(a)},format:function(a,b){var c,d=a.split("."),e="",f=d.length;for(c=0;c<f;c++){e+=("00"+d[c]).slice(-3)}return ts.formatFloat(e,b)},type:"numeric"});ts.addParser({id:"url",is:function(a){return/^(https?|ftp|file):\/\//.test(a)},format:function(a){return $.trim(a.replace(/(https?|ftp|file):\/\//,""))},type:"text"});ts.addParser({id:"isoDate",is:function(a){return/^\d{4}[\/\-]\d{1,2}[\/\-]\d{1,2}$/.test(a)},format:function(a,b){return ts.formatFloat(a!==""?(new Date(a.replace(/-/g,"/"))).getTime()||"":"",b)},type:"numeric"});ts.addParser({id:"percent",is:function(a){return/\d%\)?$/.test(a)},format:function(a,b){return ts.formatFloat(a.replace(/%/g,""),b)},type:"numeric"});ts.addParser({id:"usLongDate",is:function(a){return a.match(/^[A-Za-z]{3,10}\.? [0-9]{1,2}, ([0-9]{4}|'?[0-9]{2}) (([0-2]?[0-9]:[0-5][0-9])|([0-1]?[0-9]:[0-5][0-9]\s(AM|PM)))$/)},format:function(a,b){return ts.formatFloat((new Date(a)).getTime()||"",b)},type:"numeric"});ts.addParser({id:"shortDate",is:function(a){return/^(\d{2}|\d{4})[\/\-\,\.\s+]\d{2}[\/\-\.\,\s+](\d{2}|\d{4})$/.test(a)},format:function(a,b,c,d){var e=b.config,f=e.headerList[d],g=f.shortDateFormat;if(typeof g==="undefined"){g=f.shortDateFormat=ts.getData(f,e.headers[d],"dateFormat")||e.dateFormat}a=a.replace(/\s+/g," ").replace(/[\-|\.|\,]/g,"/");if(g==="mmddyyyy"){a=a.replace(/(\d{1,2})[\/\s](\d{1,2})[\/\s](\d{4})/,"$3/$1/$2")}else if(g==="ddmmyyyy"){a=a.replace(/(\d{1,2})[\/\s](\d{1,2})[\/\s](\d{4})/,"$3/$2/$1")}else if(g==="yyyymmdd"){a=a.replace(/(\d{4})[\/\s](\d{1,2})[\/\s](\d{1,2})/,"$1/$2/$3")}return ts.formatFloat((new Date(a)).getTime()||"",b)},type:"numeric"});ts.addParser({id:"time",is:function(a){return/^(([0-2]?[0-9]:[0-5][0-9])|([0-1]?[0-9]:[0-5][0-9]\s(am|pm)))$/.test(a)},format:function(a,b){return ts.formatFloat((new Date("2000/01/01 "+a)).getTime()||"",b)},type:"numeric"});ts.addParser({id:"digit",is:function(a){return ts.isDigit(a)},format:function(a,b){return ts.formatFloat(a.replace(/[^\w,. \-()]/g,""),b)},type:"numeric"});ts.addParser({id:"metadata",is:function(a){return false},format:function(a,b,c){var d=b.config,e=!d.parserMetadataName?"sortValue":d.parserMetadataName;return $(c).metadata()[e]},type:"numeric"});ts.addWidget({id:"zebra",format:function(a){var b,c,d,e,f,g,h,i,j=a.config,k=new RegExp(j.cssChildRow,"i"),l=$(a).children("tbody:not(."+j.cssInfoBlock+")"),m=["even","odd"];m=j.widgetZebra&&j.hasOwnProperty("css")?j.widgetZebra.css:j.widgetOptions&&j.widgetOptions.hasOwnProperty("zebra")?j.widgetOptions.zebra:m;if(j.debug){g=new Date}for(h=0;h<l.length;h++){b=$(l[h]);i=b.children("tr").length;if(i>1){e=0;c=b.find("tr:visible");b.addClass("tablesorter-hidden");c.each(function(){d=$(this);if(!k.test(this.className)){e++}f=e%2===0;d.removeClass(m[f?1:0]).addClass(m[f?0:1])});b.removeClass("tablesorter-hidden")}}if(j.debug){ts.benchmark("Applying Zebra widget",g)}}})}(jQuery)
