'''img2data.py

This script will process all .gif files, and overwrite the __init__.py
file in this directory with base64-encoded strings for each image. This
data can be used directly by tkinter images.
'''

import sys
import base64
import os
import glob

here = os.path.abspath(os.path.dirname(__file__))
prefix = '''
This data was automatically generated by script %s.

These images are part of the FAMFAMFAM silk icons set which is
provided under a creative commons license.  For more information see
http://www.famfamfam.com/lab/icons/silk/
''' % os.path.basename(__file__)

image_data = {}
for path in glob.glob("%s/silk/*.gif" % here):
    with open(path, "rb") as f:
        print path
        data = base64.b64encode(f.read())
        (name,ext) = os.path.splitext(os.path.basename(path))
        image_data[name] = data


outfile = os.path.join(here, "__init__.py")
with open(outfile, "w") as out:
    out.write("'''\n" + prefix.strip()+"\n'''\n\n")
    out.write("data = {\n")
    for name in sorted(image_data.keys()):
        data = image_data[name]
        out.write("    '%s': '''\n" % name)
        for i in xrange(0, len(data), 64):
            out.write("        " + data[i:i+64] + "\n")
        out.write("    ''',\n\n")
    out.write("}\n")
print "output written to", outfile
