import numpy as np


def cpltaxes(zz, plt):
    """
    CPLTAXES   Determine suitable AXIS for plot of complex vector.
           X = CPLTAXES(Z), where Z is a complex vector,
           determines a 4-vector X such that AXIS(X) sets axes for a plot
           of Z that has axes of equal length and leaves a reasonable amount
           of space around the edge of the plot.

           Called by FV, GERSH, PS and PSCONT.

           NOTE: You must pass in the module instance of pylab in the
                 'plt' argument.
    """
    # Collapse down to a vector
    z = zz.ravel()

    # Set x and y axis ranges so both have the same length.

    xmin = min(z.real)
    xmax = max(z.real)
    ymin = min(z.imag)
    ymax = max(z.imag)

    # Fix for rare case of `trivial data'.
    if xmin == xmax:
        xmin = xmin - 1 / 2.
        xmax = xmax + 1 / 2.

    if ymin == ymax:
        ymin = ymin - 1 / 2.
        ymax = ymax + 1 / 2.

    if xmax - xmin >= ymax - ymin:
        ymid = (ymin + ymax) / 2.
        ymin =  ymid - (xmax - xmin) / 2.
        ymax =  ymid + (xmax - xmin) / 2.
    else:
        xmid = (xmin + xmax) / 2
        xmin = xmid - (ymax - ymin) / 2.
        xmax = xmid + (ymax - ymin) / 2.

    plt.axis('equal')

    # Scale ranges by 1+2*alpha to give extra space around edges of plot.

    alpha = 0.1
    x = np.zeros(4)
    x[0] = xmin - alpha * (xmax - xmin)
    x[1] = xmax + alpha * (xmax - xmin)
    x[2] = ymin - alpha * (ymax - ymin)
    x[3] = ymax + alpha * (ymax - ymin)

    if x[0] == x[1]:
        x[1] = x[1] + 0.1

    if x[2] == x[3]:
        x[3] = x[2] + 0.1

    return x
