#!/usr/bin/env python
# -*- coding:utf-8 -*-
import re
from types import ListType

from docutils import nodes


class BaseTranslator(nodes.NodeVisitor):
    """
    """
    def __init__(self, document):
        nodes.NodeVisitor.__init__(self, document)
        self.body = []

    def astext(self):
        return ''.join(self.body)

    def dispatch_visit(self, node):
        #print node.__class__.__name__
        return nodes.NodeVisitor.dispatch_visit(self, node)

    def visit_Text(self, node):
        self.body.append(node.astext())

    def depart_Text(self, node):
        pass

    # ==============
    #  Root Element
    # ==============

    def visit_document(self, node):
        pass

    def depart_document(self, node):
        pass

    # ================
    #  Title Elements
    # ================

    def visit_title(self, node):
        pass

    def depart_title(self, node):
        pass

    def visit_subtitle(self, node):
        pass

    def depart_subtitle(self, node):
        pass

    def visit_rubric(self, node):
        pass

    def depart_rubric(self, node):
        pass

    # ========================
    #  Bibliographic Elements
    # ========================
    def visit_docinfo(self, node):
        pass

    def depart_docinfo(self, node):
        pass

    def visit_author(self, node):
        pass

    def depart_author(self, node):
        pass

    def visit_authors(self, node):
        pass

    def depart_authors(self, node):
        pass

    def visit_organization(self, node):
        pass

    def depart_organization(self, node):
        pass

    def visit_address(self, node):
        pass

    def depart_address(self, node):
        pass

    def visit_contact(self, node):
        pass

    def depart_contact(self, node):
        pass

    def visit_version(self, node):
        pass

    def depart_version(self, node):
        pass

    def visit_revision(self, node):
        pass

    def depart_revision(self, node):
        pass

    def visit_status(self, node):
        pass

    def depart_status(self, node):
        pass

    def visit_date(self, node):
        pass

    def depart_date(self, node):
        pass

    def visit_copyright(self, node):
        pass

    def depart_copyright(self, node):
        pass

    # =====================
    #  Decorative Elements
    # =====================

    def visit_decoration(self, node):
        pass

    def depart_decoration(self, node):
        pass

    def visit_header(self, node):
        pass

    def depart_header(self, node):
        pass

    def visit_footer(self, node):
        pass

    def depart_footer(self, node):
        pass

    # =====================
    #  Structural Elements
    # =====================

    def visit_section(self, node):
        pass

    def depart_section(self, node):
        pass

    def visit_topic(self, node):
        pass

    def depart_topic(self, node):
        pass

    def visit_sidebar(self, node):
        pass

    def depart_sidebar(self, node):
        pass

    def visit_transition(self, node):
        pass

    def depart_transition(self, node):
        pass

    # ===============
    #  Body Elements
    # ===============

    def visit_paragraph(self, node):
        pass

    def depart_paragraph(self, node):
        pass

    def visit_compound(self, node):
        pass

    def depart_compound(self, node):
        pass

    def visit_container(self, node):
        pass

    def depart_container(self, node):
        pass

    def visit_bullet_list(self, node):
        pass

    def depart_bullet_list(self, node):
        pass

    def visit_enumerated_list(self, node):
        pass

    def depart_enumerated_list(self, node):
        pass

    def visit_list_item(self, node):
        pass

    def depart_list_item(self, node):
        pass

    def visit_definition_list(self, node):
        pass

    def depart_definition_list(self, node):
        pass

    def visit_definition_list_item(self, node):
        pass

    def depart_definition_list_item(self, node):
        pass

    def visit_term(self, node):
        pass

    def depart_term(self, node):
        pass

    def visit_classifier(self, node):
        pass

    def depart_classifier(self, node):
        pass

    def visit_definition(self, node):
        pass

    def depart_definition(self, node):
        pass

    def visit_field_list(self, node):
        pass

    def depart_field_list(self, node):
        pass

    def visit_field(self, node):
        pass

    def depart_field(self, node):
        pass

    def visit_field_name(self, node):
        pass

    def depart_field_name(self, node):
        pass

    def visit_field_body(self, node):
        pass

    def depart_field_body(self, node):
        pass

    def visit_option(self, node):
        pass

    def depart_option(self, node):
        pass

    def visit_option_argument(self, node):
        pass

    def depart_option_argument(self, node):
        pass

    def visit_option_group(self, node):
        pass

    def depart_option_group(self, node):
        pass

    def visit_option_list(self, node):
        pass

    def depart_option_list(self, node):
        pass

    def visit_option_list_item(self, node):
        pass

    def depart_option_list_item(self, node):
        pass

    def visit_option_string(self, node):
        pass

    def depart_option_string(self, node):
        pass

    def visit_description(self, node):
        pass

    def depart_description(self, node):
        pass

    def visit_literal_block(self, node):
        pass

    def depart_literal_block(self, node):
        pass

    def visit_doctest_block(self, node):
        pass

    def depart_doctest_block(self, node):
        pass

    def visit_line_block(self, node):
        pass

    def depart_line_block(self, node):
        pass

    def visit_line(self, node):
        pass

    def depart_line(self, node):
        pass

    def visit_block_quote(self, node):
        pass

    def depart_block_quote(self, node):
        pass

    def visit_attribution(self, node):
        pass

    def depart_attribution(self, node):
        pass

    def visit_attention(self, node):
        pass

    def depart_attention(self, node):
        pass

    def visit_caution(self, node):
        pass

    def depart_caution(self, node):
        pass

    def visit_danger(self, node):
        pass

    def depart_danger(self, node):
        pass

    def visit_error(self, node):
        pass

    def depart_error(self, node):
        pass

    def visit_important(self, node):
        pass

    def depart_important(self, node):
        pass

    def visit_note(self, node):
        pass

    def depart_note(self, node):
        pass

    def visit_tip(self, node):
        pass

    def depart_tip(self, node):
        pass

    def visit_hint(self, node):
        pass

    def depart_hint(self, node):
        pass

    def visit_warning(self, node):
        pass

    def depart_warning(self, node):
        pass

    def visit_admonition(self, node):
        pass

    def depart_admonition(self, node):
        pass

    def visit_comment(self, node):
        pass

    def depart_comment(self, node):
        pass

    def visit_substitution_definition(self, node):
        pass

    def depart_substitution_definition(self, node):
        pass

    def visit_target(self, node):
        pass

    def depart_target(self, node):
        pass

    def visit_footnote(self, node):
        pass

    def depart_footnote(self, node):
        pass

    def visit_citation(self, node):
        pass

    def depart_citation(self, node):
        pass

    def visit_label(self, node):
        pass

    def depart_label(self, node):
        pass

    def visit_figure(self, node):
        pass

    def depart_figure(self, node):
        pass

    def visit_caption(self, node):
        pass

    def depart_caption(self, node):
        pass

    def visit_legend(self, node):
        pass

    def depart_legend(self, node):
        pass

    def visit_table(self, node):
        pass

    def depart_table(self, node):
        pass

    def visit_tgroup(self, node):
        pass

    def depart_tgroup(self, node):
        pass

    def visit_colspec(self, node):
        pass

    def depart_colspec(self, node):
        pass

    def visit_thead(self, node):
        pass

    def depart_thead(self, node):
        pass

    def visit_tbody(self, node):
        pass

    def depart_tbody(self, node):
        pass

    def visit_row(self, node):
        pass

    def depart_row(self, node):
        pass

    def visit_entry(self, node):
        pass

    def depart_entry(self, node):
        pass

    def visit_system_message(self, node):
        pass

    def depart_system_message(self, node):
        pass

    def visit_pending(self, node):
        pass

    def depart_pending(self, node):
        pass

    def visit_raw(self, node):
        pass

    def depart_raw(self, node):
        pass

    # =================
    #  Inline Elements
    # =================

    def visit_emphasis(self, node):
        pass

    def depart_emphasis(self, node):
        pass

    def visit_strong(self, node):
        pass

    def depart_strong(self, node):
        pass

    def visit_literal(self, node):
        pass

    def depart_literal(self, node):
        pass

    def visit_reference(self, node):
        pass

    def depart_reference(self, node):
        pass

    def visit_footnote_reference(self, node):
        pass

    def depart_footnote_reference(self, node):
        pass

    def visit_citation_reference(self, node):
        pass

    def depart_citation_reference(self, node):
        pass

    def visit_substitution_reference(self, node):
        pass

    def depart_substitution_reference(self, node):
        pass

    def visit_title_reference(self, node):
        pass

    def depart_title_reference(self, node):
        pass

    def visit_abbreviation(self, node):
        pass

    def depart_abbreviation(self, node):
        pass

    def visit_acronym(self, node):
        pass

    def depart_acronym(self, node):
        pass

    def visit_superscript(self, node):
        pass

    def depart_superscript(self, node):
        pass

    def visit_subscript(self, node):
        pass

    def depart_subscript(self, node):
        pass

    def visit_image(self, node):
        pass

    def depart_image(self, node):
        pass

    def visit_inline(self, node):
        pass

    def depart_inline(self, node):
        pass

    def visit_problematic(self, node):
        pass

    def depart_problematic(self, node):
        pass

    def visit_generated(self, node):
        pass

    def depart_generated(self, node):
        pass

    # ==================
    #  Hatena directives
    # ==================
    def visit_niconico(self, node):
        raise NotImplementedError('"niconico" directive is not implemented')

    def depart_niconico(self, node):
        raise NotImplementedError('"niconico" directive is not implemented')

    def visit_google(self, node):
        raise NotImplementedError('"google" directive is not implemented')

    def depart_google(self, node):
        raise NotImplementedError('"google" directive is not implemented')

    def visit_amazon(self, node):
        raise NotImplementedError('"amazon" directive is not implemented')

    def depart_amazon(self, node):
        raise NotImplementedError('"amazon" directive is not implemented')

    def visit_wikipedia(self, node):
        raise NotImplementedError('"wikipedia" directive is not implemented')

    def depart_wikipedia(self, node):
        raise NotImplementedError('"wikipedia" directive is not implemented')

    def visit_twitter(self, node):
        raise NotImplementedError('"twitter" directive is not implemented')

    def depart_twitter(self, node):
        raise NotImplementedError('"twitter" directive is not implemented')

    def visit_map(self, node):
        raise NotImplementedError('"map" directive is not implemented')

    def depart_map(self, node):
        raise NotImplementedError('"map" directive is not implemented')
