#!/usr/bin/env python


# $Id: rst2html.py 4564 2006-05-21 20:44:42Z wiemann $
# Author: David Goodger <goodger@python.org>
# Copyright: This module has been placed in the public domain.

"""
A front end to the Docutils Publisher, registering the GoDiagramDirective 
and producing HTML.  Based on rst2html.py by David Goodger, in the public 
domain.
"""

try:
    import locale
    locale.setlocale(locale.LC_ALL, '')
except:
    pass

from docutils.core import publish_cmdline, default_description

from rstgo.rst import setup_pelican

setup_pelican()

description = ('Generates (X)HTML documents from standalone reStructuredText '
               'sources.  ' + default_description)

publish_cmdline(writer_name='html', description=description)
