import unittest
from functools import partial
from unittest.mock import Mock, call
from importlib import import_module
component = import_module('run_io.dialog')


class DialogTest(unittest.TestCase):

    # Actions

    def setUp(self):
        self.reader = Mock()
        self.writer = Mock()
        self.pDialog = partial(
            component.Dialog, reader=self.reader, writer=self.writer)

    # Tests

    def test_answer(self):
        self.dialog = self.pDialog(attr1='value1')
        self.dialog.message('Attr is {attr1}')
        self.dialog.message('Attr is {attr1}', attr1='value2')
        self.dialog.message('Attr is {attr1}')
        self.writer.assert_has_calls([
            call('Attr is value1'),
            call('Attr is value2'),
            call('Attr is value1')])

    def test_hint(self):
        self.dialog = self.pDialog()
        self.assertEqual(self.dialog.hint, '*')

    def test_hint_with_default(self):
        self.dialog = self.pDialog(default='y')
        self.assertEqual(self.dialog.hint, '[y]/*')

    def test_hint_with_options(self):
        self.dialog = self.pDialog(options=['y', 'n'])
        self.assertEqual(self.dialog.hint, 'y/n')

    def test_hint_with_default_and_options(self):
        self.dialog = self.pDialog(default='y', options=['y', 'n'])
        self.assertEqual(self.dialog.hint, '[y]/n')
